using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using SensorTechnology;

namespace PreviewSize
{
	/// <summary>
	/// frmMain
	/// </summary>
	public class frmMain : System.Windows.Forms.Form
	{

		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItemSetting;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuItemChildWindow;
		private System.Windows.Forms.MenuItem menuItemOverlappedWindow;

		private System.ComponentModel.Container components = null;

		public frmMain(CStCamera stCamera)
		{
			InitializeComponent();
			m_StCamera = stCamera;

			eventActivated = new System.EventHandler(this.frmMain_Activated);
			Activated += eventActivated;
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer Code
		private void InitializeComponent()
		{
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItemSetting = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.menuItemChildWindow = new System.Windows.Forms.MenuItem();
			this.menuItemOverlappedWindow = new System.Windows.Forms.MenuItem();
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem1});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItemSetting,
																					  this.menuItem3});
			this.menuItem1.Text = "&Mode";
			// 
			// menuItemSetting
			// 
			this.menuItemSetting.Index = 0;
			this.menuItemSetting.Text = "&Setting";
			this.menuItemSetting.Click += new System.EventHandler(this.menuItemSetting_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 1;
			this.menuItem3.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItemChildWindow,
																					  this.menuItemOverlappedWindow});
			this.menuItem3.Text = "&Window Style";
			// 
			// menuItemChildWindow
			// 
			this.menuItemChildWindow.Index = 0;
			this.menuItemChildWindow.Text = "&Child Window";
			this.menuItemChildWindow.Click += new System.EventHandler(this.menuItemWindowStyle_Click);
			// 
			// menuItemOverlappedWindow
			// 
			this.menuItemOverlappedWindow.Index = 1;
			this.menuItemOverlappedWindow.Text = "&Overlapped";
			this.menuItemOverlappedWindow.Click += new System.EventHandler(this.menuItemWindowStyle_Click);
			// 
			// frmMain
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(976, 569);
			this.Menu = this.mainMenu1;
			this.Name = "frmMain";
			this.Text = "PreviewSize";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.frmMain_Closing);

		}
		#endregion


		private CStCamera m_StCamera = null;
		private frmSetting m_frmSetting = null;
		private System.EventHandler eventActivated = null;

		private void frmMain_Activated(object sender, System.EventArgs e)
		{
			Activated -= eventActivated;
			menuItemChildWindow.PerformClick();
			m_StCamera.StartTransfer();
		}
		private void menuItemWindowStyle_Click(object sender, System.EventArgs e)
		{
			bool bChildWindow = menuItemChildWindow.Equals(sender);
			IntPtr hParentWindow = IntPtr.Zero;
			bool result = true;

			if(bChildWindow)
			{
				hParentWindow = this.Handle;
			}

			result = m_StCamera.CreateWindow(hParentWindow);

			menuItemChildWindow.Checked = bChildWindow;
			menuItemOverlappedWindow.Checked = !bChildWindow;
		}

		private void menuItemSetting_Click(object sender, System.EventArgs e)
		{
			if(m_frmSetting == null)
			{
				m_frmSetting = new frmSetting(m_StCamera);
				m_frmSetting.Closed += new System.EventHandler(frmSetting_Closed);
			}
			m_frmSetting.Show();
			m_frmSetting.Activate();
		}
		private void frmSetting_Closed(object sender, System.EventArgs e)
		{
			m_frmSetting = null;
		}

		private void frmMain_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
		
			if(m_StCamera != null)
			{
				m_StCamera.Dispose();
				m_StCamera = null;
			}
		}








	}
}
