using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using SensorTechnology;

namespace PreviewSize
{
	public class frmSelectCamera : System.Windows.Forms.Form
	{
		private System.ComponentModel.IContainer components;

		public frmSelectCamera()
		{
			InitializeComponent();
			eventActivated = new System.EventHandler(this.frmSelectCamera_Activated);
			Activated += eventActivated;
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer Code
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.cmbCameraList = new System.Windows.Forms.ComboBox();
			this.btnOK = new System.Windows.Forms.Button();
			this.btnCancel = new System.Windows.Forms.Button();
			this.timerCheckCamera = new System.Windows.Forms.Timer(this.components);
			this.SuspendLayout();
			// 
			// cmbCameraList
			// 
			this.cmbCameraList.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.cmbCameraList.Location = new System.Drawing.Point(16, 16);
			this.cmbCameraList.Name = "cmbCameraList";
			this.cmbCameraList.Size = new System.Drawing.Size(256, 20);
			this.cmbCameraList.TabIndex = 0;
			// 
			// btnOK
			// 
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Location = new System.Drawing.Point(112, 48);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 1;
			this.btnOK.Text = "OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(192, 48);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "Cancel";
			// 
			// timerCheckCamera
			// 
			this.timerCheckCamera.Interval = 500;
			this.timerCheckCamera.Tick += new System.EventHandler(this.timerCheckCamera_Tick);
			// 
			// frmSelectCamera
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(280, 86);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.cmbCameraList);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.Name = "frmSelectCamera";
			this.Text = "frmSelectCamera";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.frmSelectCamera_Closing);
			this.ResumeLayout(false);

		}
		#endregion

		
		private System.EventHandler eventActivated = null;
		private ArrayList m_arrayStCamera = new ArrayList(127);
		private System.Windows.Forms.ComboBox cmbCameraList;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Timer timerCheckCamera;
		private int m_keepOpenIndex = -1;

		private bool mOpenAllCamera()
		{
			bool result = true;
			for(int i = 0; i < m_arrayStCamera.Capacity; i++)
			{
				CStCamera stCamera = new CStCamera();
				if(stCamera.Open())
				{
					m_arrayStCamera.Add(stCamera);
				}
				else
				{
					break;
				}
			}
			return(result);
		}

		private bool mCloseCamera()
		{
			bool result = true;
			while((m_keepOpenIndex < m_arrayStCamera.Count - 1) && (0 < m_arrayStCamera.Count))
			{
				CStCamera stCamera = m_arrayStCamera[m_arrayStCamera.Count - 1] as CStCamera;
				m_arrayStCamera.RemoveAt(m_arrayStCamera.Count - 1);
				stCamera.Dispose();
			}

			while(1 < m_arrayStCamera.Count)
			{
				CStCamera stCamera = m_arrayStCamera[0] as CStCamera;
				m_arrayStCamera.RemoveAt(0);
				stCamera.Dispose();
			}

			return(result);
		}

		public CStCamera OpendCamera
		{
			get
			{
				CStCamera stCamera = null;
				if(0 < m_arrayStCamera.Count)
				{
					stCamera = m_arrayStCamera[0] as CStCamera;
				}

				return(stCamera);
			}
		}

		private bool mUpdateDisplay()
		{
			bool result = true;
			int nSelectedIndex = cmbCameraList.SelectedIndex;

			cmbCameraList.Items.Clear();

			foreach(CStCamera stCamera in m_arrayStCamera)
			{
				cmbCameraList.Items.Add(stCamera);
			}

			if(0 < cmbCameraList.Items.Count)
			{
				if(nSelectedIndex < 0)
				{
					nSelectedIndex = 0;
				}
				else if(cmbCameraList.Items.Count <= nSelectedIndex)
				{
					nSelectedIndex = cmbCameraList.Items.Count - 1;
				}

				cmbCameraList.SelectedIndex = nSelectedIndex;

				btnOK.Enabled = true;
				cmbCameraList.Enabled = true;
			}
			else
			{
				btnOK.Enabled = false;
				cmbCameraList.Enabled = false;
			}
			if(1 == cmbCameraList.Items.Count)
			{
				btnOK.PerformClick();
			}
			return(result);
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			m_keepOpenIndex = cmbCameraList.SelectedIndex;
		}

		private void frmSelectCamera_Activated(object sender, System.EventArgs e)
		{
			Activated -= eventActivated;
			timerCheckCamera.Enabled = true;
			btnOK.Enabled = false;
			cmbCameraList.Enabled = false;
		}

		private void frmSelectCamera_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			timerCheckCamera.Enabled = false;
			mCloseCamera();
		}

		private void timerCheckCamera_Tick(object sender, System.EventArgs e)
		{
			bool result = true;

			do
			{
				result = mCloseCamera();
				if(!result) break;

				result = mOpenAllCamera();
				if(!result) break;

				result = mUpdateDisplay();
				if(!result) break;
			}while(false);
		}



	}
}
