using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using SensorTechnology;
using SettingCtrl;

namespace PreviewSize
{
	public class frmSetting : System.Windows.Forms.Form
	{
		private System.ComponentModel.Container components = null;

		public frmSetting(CStCamera stCamera)
		{
			InitializeComponent();
			m_StCamera = stCamera;
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer Code
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.comboBoxDisplayMode = new SettingCtrl.SettingComboBox();
			this.label2 = new System.Windows.Forms.Label();
			this.comboBoxAspectMode = new SettingCtrl.SettingComboBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.tbPWHeight = new SettingCtrl.SettingTextBox();
			this.sbPWHeight = new SettingCtrl.SettingScrollBar();
			this.label6 = new System.Windows.Forms.Label();
			this.tbPWWidth = new SettingCtrl.SettingTextBox();
			this.sbPWWidth = new SettingCtrl.SettingScrollBar();
			this.label5 = new System.Windows.Forms.Label();
			this.tbPWOffsetY = new SettingCtrl.SettingTextBox();
			this.sbPWOffsetY = new SettingCtrl.SettingScrollBar();
			this.label4 = new System.Windows.Forms.Label();
			this.tbPWOffsetX = new SettingCtrl.SettingTextBox();
			this.sbPWOffsetX = new SettingCtrl.SettingScrollBar();
			this.label3 = new System.Windows.Forms.Label();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.tbPMHeight = new SettingCtrl.SettingTextBox();
			this.sbPMHeight = new SettingCtrl.SettingScrollBar();
			this.label7 = new System.Windows.Forms.Label();
			this.tbPMWidth = new SettingCtrl.SettingTextBox();
			this.sbPMWidth = new SettingCtrl.SettingScrollBar();
			this.label8 = new System.Windows.Forms.Label();
			this.tbPMOffsetY = new SettingCtrl.SettingTextBox();
			this.sbPMOffsetY = new SettingCtrl.SettingScrollBar();
			this.label9 = new System.Windows.Forms.Label();
			this.tbPMOffsetX = new SettingCtrl.SettingTextBox();
			this.sbPMOffsetX = new SettingCtrl.SettingScrollBar();
			this.label10 = new System.Windows.Forms.Label();
			this.groupBox3 = new System.Windows.Forms.GroupBox();
			this.tbPDHeight = new SettingCtrl.SettingTextBox();
			this.sbPDHeight = new SettingCtrl.SettingScrollBar();
			this.label11 = new System.Windows.Forms.Label();
			this.tbPDWidth = new SettingCtrl.SettingTextBox();
			this.sbPDWidth = new SettingCtrl.SettingScrollBar();
			this.label12 = new System.Windows.Forms.Label();
			this.tbPDOffsetY = new SettingCtrl.SettingTextBox();
			this.sbPDOffsetY = new SettingCtrl.SettingScrollBar();
			this.label13 = new System.Windows.Forms.Label();
			this.tbPDOffsetX = new SettingCtrl.SettingTextBox();
			this.sbPDOffsetX = new SettingCtrl.SettingScrollBar();
			this.label14 = new System.Windows.Forms.Label();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.groupBox3.SuspendLayout();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.AutoSize = true;
			this.label1.Location = new System.Drawing.Point(8, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(73, 15);
			this.label1.TabIndex = 0;
			this.label1.Text = "Display Mode";
			// 
			// comboBoxDisplayMode
			// 
			this.comboBoxDisplayMode.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboBoxDisplayMode.Location = new System.Drawing.Point(144, 8);
			this.comboBoxDisplayMode.Name = "comboBoxDisplayMode";
			this.comboBoxDisplayMode.SettingID = SettingCtrl.SettingIDs.DISPLAY_MODE;
			this.comboBoxDisplayMode.SettingValue = 0;
			this.comboBoxDisplayMode.Size = new System.Drawing.Size(240, 20);
			this.comboBoxDisplayMode.TabIndex = 1;
			this.comboBoxDisplayMode.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// label2
			// 
			this.label2.AutoSize = true;
			this.label2.Location = new System.Drawing.Point(8, 40);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(72, 15);
			this.label2.TabIndex = 2;
			this.label2.Text = "Aspect Mode";
			// 
			// comboBoxAspectMode
			// 
			this.comboBoxAspectMode.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboBoxAspectMode.Location = new System.Drawing.Point(144, 40);
			this.comboBoxAspectMode.Name = "comboBoxAspectMode";
			this.comboBoxAspectMode.SettingID = SettingCtrl.SettingIDs.ASPECT_MODE;
			this.comboBoxAspectMode.SettingValue = 0;
			this.comboBoxAspectMode.Size = new System.Drawing.Size(240, 20);
			this.comboBoxAspectMode.TabIndex = 3;
			this.comboBoxAspectMode.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.tbPWHeight);
			this.groupBox1.Controls.Add(this.sbPWHeight);
			this.groupBox1.Controls.Add(this.label6);
			this.groupBox1.Controls.Add(this.tbPWWidth);
			this.groupBox1.Controls.Add(this.sbPWWidth);
			this.groupBox1.Controls.Add(this.label5);
			this.groupBox1.Controls.Add(this.tbPWOffsetY);
			this.groupBox1.Controls.Add(this.sbPWOffsetY);
			this.groupBox1.Controls.Add(this.label4);
			this.groupBox1.Controls.Add(this.tbPWOffsetX);
			this.groupBox1.Controls.Add(this.sbPWOffsetX);
			this.groupBox1.Controls.Add(this.label3);
			this.groupBox1.Location = new System.Drawing.Point(8, 80);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(376, 128);
			this.groupBox1.TabIndex = 4;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Preview Window Size";
			// 
			// tbPWHeight
			// 
			this.tbPWHeight.Location = new System.Drawing.Point(320, 96);
			this.tbPWHeight.Name = "tbPWHeight";
			this.tbPWHeight.SettingID = SettingCtrl.SettingIDs.PW_HEIGHT;
			this.tbPWHeight.SettingMax = 2147483647;
			this.tbPWHeight.SettingMin = -2147483648;
			this.tbPWHeight.SettingValue = 0;
			this.tbPWHeight.Size = new System.Drawing.Size(40, 19);
			this.tbPWHeight.TabIndex = 11;
			this.tbPWHeight.Text = "0";
			this.tbPWHeight.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.tbPWHeight.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// sbPWHeight
			// 
			this.sbPWHeight.Location = new System.Drawing.Point(72, 96);
			this.sbPWHeight.Name = "sbPWHeight";
			this.sbPWHeight.SettingID = SettingCtrl.SettingIDs.PW_HEIGHT;
			this.sbPWHeight.SettingMax = 100;
			this.sbPWHeight.SettingMin = 0;
			this.sbPWHeight.SettingValue = 0;
			this.sbPWHeight.Size = new System.Drawing.Size(232, 17);
			this.sbPWHeight.TabIndex = 10;
			this.sbPWHeight.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// label6
			// 
			this.label6.AutoSize = true;
			this.label6.Location = new System.Drawing.Point(16, 96);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(37, 15);
			this.label6.TabIndex = 9;
			this.label6.Text = "Height";
			// 
			// tbPWWidth
			// 
			this.tbPWWidth.Location = new System.Drawing.Point(320, 72);
			this.tbPWWidth.Name = "tbPWWidth";
			this.tbPWWidth.SettingID = SettingCtrl.SettingIDs.PW_WIDTH;
			this.tbPWWidth.SettingMax = 2147483647;
			this.tbPWWidth.SettingMin = -2147483648;
			this.tbPWWidth.SettingValue = 0;
			this.tbPWWidth.Size = new System.Drawing.Size(40, 19);
			this.tbPWWidth.TabIndex = 8;
			this.tbPWWidth.Text = "0";
			this.tbPWWidth.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.tbPWWidth.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// sbPWWidth
			// 
			this.sbPWWidth.Location = new System.Drawing.Point(72, 72);
			this.sbPWWidth.Name = "sbPWWidth";
			this.sbPWWidth.SettingID = SettingCtrl.SettingIDs.PW_WIDTH;
			this.sbPWWidth.SettingMax = 100;
			this.sbPWWidth.SettingMin = 0;
			this.sbPWWidth.SettingValue = 0;
			this.sbPWWidth.Size = new System.Drawing.Size(232, 17);
			this.sbPWWidth.TabIndex = 7;
			this.sbPWWidth.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// label5
			// 
			this.label5.AutoSize = true;
			this.label5.Location = new System.Drawing.Point(16, 72);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(33, 15);
			this.label5.TabIndex = 6;
			this.label5.Text = "Width";
			// 
			// tbPWOffsetY
			// 
			this.tbPWOffsetY.Location = new System.Drawing.Point(320, 48);
			this.tbPWOffsetY.Name = "tbPWOffsetY";
			this.tbPWOffsetY.SettingID = SettingCtrl.SettingIDs.PW_OFFSETY;
			this.tbPWOffsetY.SettingMax = 2147483647;
			this.tbPWOffsetY.SettingMin = -2147483648;
			this.tbPWOffsetY.SettingValue = 0;
			this.tbPWOffsetY.Size = new System.Drawing.Size(40, 19);
			this.tbPWOffsetY.TabIndex = 5;
			this.tbPWOffsetY.Text = "0";
			this.tbPWOffsetY.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.tbPWOffsetY.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// sbPWOffsetY
			// 
			this.sbPWOffsetY.Location = new System.Drawing.Point(72, 48);
			this.sbPWOffsetY.Name = "sbPWOffsetY";
			this.sbPWOffsetY.SettingID = SettingCtrl.SettingIDs.PW_OFFSETY;
			this.sbPWOffsetY.SettingMax = 100;
			this.sbPWOffsetY.SettingMin = 0;
			this.sbPWOffsetY.SettingValue = 0;
			this.sbPWOffsetY.Size = new System.Drawing.Size(232, 17);
			this.sbPWOffsetY.TabIndex = 4;
			this.sbPWOffsetY.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// label4
			// 
			this.label4.AutoSize = true;
			this.label4.Location = new System.Drawing.Point(16, 48);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(44, 15);
			this.label4.TabIndex = 3;
			this.label4.Text = "OffsetY";
			// 
			// tbPWOffsetX
			// 
			this.tbPWOffsetX.Location = new System.Drawing.Point(320, 24);
			this.tbPWOffsetX.Name = "tbPWOffsetX";
			this.tbPWOffsetX.SettingID = SettingCtrl.SettingIDs.PW_OFFSETX;
			this.tbPWOffsetX.SettingMax = 2147483647;
			this.tbPWOffsetX.SettingMin = -2147483648;
			this.tbPWOffsetX.SettingValue = 0;
			this.tbPWOffsetX.Size = new System.Drawing.Size(40, 19);
			this.tbPWOffsetX.TabIndex = 2;
			this.tbPWOffsetX.Text = "0";
			this.tbPWOffsetX.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.tbPWOffsetX.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// sbPWOffsetX
			// 
			this.sbPWOffsetX.Location = new System.Drawing.Point(72, 24);
			this.sbPWOffsetX.Name = "sbPWOffsetX";
			this.sbPWOffsetX.SettingID = SettingCtrl.SettingIDs.PW_OFFSETX;
			this.sbPWOffsetX.SettingMax = 100;
			this.sbPWOffsetX.SettingMin = 0;
			this.sbPWOffsetX.SettingValue = 0;
			this.sbPWOffsetX.Size = new System.Drawing.Size(232, 17);
			this.sbPWOffsetX.TabIndex = 1;
			this.sbPWOffsetX.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// label3
			// 
			this.label3.AutoSize = true;
			this.label3.Location = new System.Drawing.Point(16, 24);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(44, 15);
			this.label3.TabIndex = 0;
			this.label3.Text = "OffsetX";
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.Add(this.tbPMHeight);
			this.groupBox2.Controls.Add(this.sbPMHeight);
			this.groupBox2.Controls.Add(this.label7);
			this.groupBox2.Controls.Add(this.tbPMWidth);
			this.groupBox2.Controls.Add(this.sbPMWidth);
			this.groupBox2.Controls.Add(this.label8);
			this.groupBox2.Controls.Add(this.tbPMOffsetY);
			this.groupBox2.Controls.Add(this.sbPMOffsetY);
			this.groupBox2.Controls.Add(this.label9);
			this.groupBox2.Controls.Add(this.tbPMOffsetX);
			this.groupBox2.Controls.Add(this.sbPMOffsetX);
			this.groupBox2.Controls.Add(this.label10);
			this.groupBox2.Location = new System.Drawing.Point(9, 216);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(376, 128);
			this.groupBox2.TabIndex = 5;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Preview Mask Size";
			// 
			// tbPMHeight
			// 
			this.tbPMHeight.Location = new System.Drawing.Point(320, 96);
			this.tbPMHeight.Name = "tbPMHeight";
			this.tbPMHeight.SettingID = SettingCtrl.SettingIDs.PM_HEIGHT;
			this.tbPMHeight.SettingMax = 2147483647;
			this.tbPMHeight.SettingMin = -2147483648;
			this.tbPMHeight.SettingValue = 0;
			this.tbPMHeight.Size = new System.Drawing.Size(40, 19);
			this.tbPMHeight.TabIndex = 11;
			this.tbPMHeight.Text = "0";
			this.tbPMHeight.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.tbPMHeight.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// sbPMHeight
			// 
			this.sbPMHeight.Location = new System.Drawing.Point(72, 96);
			this.sbPMHeight.Name = "sbPMHeight";
			this.sbPMHeight.SettingID = SettingCtrl.SettingIDs.PM_HEIGHT;
			this.sbPMHeight.SettingMax = 100;
			this.sbPMHeight.SettingMin = 0;
			this.sbPMHeight.SettingValue = 0;
			this.sbPMHeight.Size = new System.Drawing.Size(232, 17);
			this.sbPMHeight.TabIndex = 10;
			this.sbPMHeight.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// label7
			// 
			this.label7.AutoSize = true;
			this.label7.Location = new System.Drawing.Point(16, 96);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(37, 15);
			this.label7.TabIndex = 9;
			this.label7.Text = "Height";
			// 
			// tbPMWidth
			// 
			this.tbPMWidth.Location = new System.Drawing.Point(320, 72);
			this.tbPMWidth.Name = "tbPMWidth";
			this.tbPMWidth.SettingID = SettingCtrl.SettingIDs.PM_WIDTH;
			this.tbPMWidth.SettingMax = 2147483647;
			this.tbPMWidth.SettingMin = -2147483648;
			this.tbPMWidth.SettingValue = 0;
			this.tbPMWidth.Size = new System.Drawing.Size(40, 19);
			this.tbPMWidth.TabIndex = 8;
			this.tbPMWidth.Text = "0";
			this.tbPMWidth.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.tbPMWidth.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// sbPMWidth
			// 
			this.sbPMWidth.Location = new System.Drawing.Point(72, 72);
			this.sbPMWidth.Name = "sbPMWidth";
			this.sbPMWidth.SettingID = SettingCtrl.SettingIDs.PM_WIDTH;
			this.sbPMWidth.SettingMax = 100;
			this.sbPMWidth.SettingMin = 0;
			this.sbPMWidth.SettingValue = 0;
			this.sbPMWidth.Size = new System.Drawing.Size(232, 17);
			this.sbPMWidth.TabIndex = 7;
			this.sbPMWidth.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// label8
			// 
			this.label8.AutoSize = true;
			this.label8.Location = new System.Drawing.Point(16, 72);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(33, 15);
			this.label8.TabIndex = 6;
			this.label8.Text = "Width";
			// 
			// tbPMOffsetY
			// 
			this.tbPMOffsetY.Location = new System.Drawing.Point(320, 48);
			this.tbPMOffsetY.Name = "tbPMOffsetY";
			this.tbPMOffsetY.SettingID = SettingCtrl.SettingIDs.PM_OFFSETY;
			this.tbPMOffsetY.SettingMax = 2147483647;
			this.tbPMOffsetY.SettingMin = -2147483648;
			this.tbPMOffsetY.SettingValue = 0;
			this.tbPMOffsetY.Size = new System.Drawing.Size(40, 19);
			this.tbPMOffsetY.TabIndex = 5;
			this.tbPMOffsetY.Text = "0";
			this.tbPMOffsetY.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.tbPMOffsetY.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// sbPMOffsetY
			// 
			this.sbPMOffsetY.Location = new System.Drawing.Point(72, 48);
			this.sbPMOffsetY.Name = "sbPMOffsetY";
			this.sbPMOffsetY.SettingID = SettingCtrl.SettingIDs.PM_OFFSETY;
			this.sbPMOffsetY.SettingMax = 100;
			this.sbPMOffsetY.SettingMin = 0;
			this.sbPMOffsetY.SettingValue = 0;
			this.sbPMOffsetY.Size = new System.Drawing.Size(232, 17);
			this.sbPMOffsetY.TabIndex = 4;
			this.sbPMOffsetY.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// label9
			// 
			this.label9.AutoSize = true;
			this.label9.Location = new System.Drawing.Point(16, 48);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(44, 15);
			this.label9.TabIndex = 3;
			this.label9.Text = "OffsetY";
			// 
			// tbPMOffsetX
			// 
			this.tbPMOffsetX.Location = new System.Drawing.Point(320, 24);
			this.tbPMOffsetX.Name = "tbPMOffsetX";
			this.tbPMOffsetX.SettingID = SettingCtrl.SettingIDs.PM_OFFSETX;
			this.tbPMOffsetX.SettingMax = 2147483647;
			this.tbPMOffsetX.SettingMin = -2147483648;
			this.tbPMOffsetX.SettingValue = 0;
			this.tbPMOffsetX.Size = new System.Drawing.Size(40, 19);
			this.tbPMOffsetX.TabIndex = 2;
			this.tbPMOffsetX.Text = "0";
			this.tbPMOffsetX.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.tbPMOffsetX.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// sbPMOffsetX
			// 
			this.sbPMOffsetX.Location = new System.Drawing.Point(72, 24);
			this.sbPMOffsetX.Name = "sbPMOffsetX";
			this.sbPMOffsetX.SettingID = SettingCtrl.SettingIDs.PM_OFFSETX;
			this.sbPMOffsetX.SettingMax = 100;
			this.sbPMOffsetX.SettingMin = 0;
			this.sbPMOffsetX.SettingValue = 0;
			this.sbPMOffsetX.Size = new System.Drawing.Size(232, 17);
			this.sbPMOffsetX.TabIndex = 1;
			this.sbPMOffsetX.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// label10
			// 
			this.label10.AutoSize = true;
			this.label10.Location = new System.Drawing.Point(16, 24);
			this.label10.Name = "label10";
			this.label10.Size = new System.Drawing.Size(44, 15);
			this.label10.TabIndex = 0;
			this.label10.Text = "OffsetX";
			// 
			// groupBox3
			// 
			this.groupBox3.Controls.Add(this.tbPDHeight);
			this.groupBox3.Controls.Add(this.sbPDHeight);
			this.groupBox3.Controls.Add(this.label11);
			this.groupBox3.Controls.Add(this.tbPDWidth);
			this.groupBox3.Controls.Add(this.sbPDWidth);
			this.groupBox3.Controls.Add(this.label12);
			this.groupBox3.Controls.Add(this.tbPDOffsetY);
			this.groupBox3.Controls.Add(this.sbPDOffsetY);
			this.groupBox3.Controls.Add(this.label13);
			this.groupBox3.Controls.Add(this.tbPDOffsetX);
			this.groupBox3.Controls.Add(this.sbPDOffsetX);
			this.groupBox3.Controls.Add(this.label14);
			this.groupBox3.Location = new System.Drawing.Point(8, 352);
			this.groupBox3.Name = "groupBox3";
			this.groupBox3.Size = new System.Drawing.Size(376, 128);
			this.groupBox3.TabIndex = 6;
			this.groupBox3.TabStop = false;
			this.groupBox3.Text = "Preview Dest Size";
			// 
			// tbPDHeight
			// 
			this.tbPDHeight.Location = new System.Drawing.Point(320, 96);
			this.tbPDHeight.Name = "tbPDHeight";
			this.tbPDHeight.SettingID = SettingCtrl.SettingIDs.PD_HEIGHT;
			this.tbPDHeight.SettingMax = 2147483647;
			this.tbPDHeight.SettingMin = -2147483648;
			this.tbPDHeight.SettingValue = 0;
			this.tbPDHeight.Size = new System.Drawing.Size(40, 19);
			this.tbPDHeight.TabIndex = 11;
			this.tbPDHeight.Text = "0";
			this.tbPDHeight.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.tbPDHeight.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// sbPDHeight
			// 
			this.sbPDHeight.Location = new System.Drawing.Point(72, 96);
			this.sbPDHeight.Name = "sbPDHeight";
			this.sbPDHeight.SettingID = SettingCtrl.SettingIDs.PD_HEIGHT;
			this.sbPDHeight.SettingMax = 100;
			this.sbPDHeight.SettingMin = 0;
			this.sbPDHeight.SettingValue = 0;
			this.sbPDHeight.Size = new System.Drawing.Size(232, 17);
			this.sbPDHeight.TabIndex = 10;
			this.sbPDHeight.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// label11
			// 
			this.label11.AutoSize = true;
			this.label11.Location = new System.Drawing.Point(16, 96);
			this.label11.Name = "label11";
			this.label11.Size = new System.Drawing.Size(37, 15);
			this.label11.TabIndex = 9;
			this.label11.Text = "Height";
			// 
			// tbPDWidth
			// 
			this.tbPDWidth.Location = new System.Drawing.Point(320, 72);
			this.tbPDWidth.Name = "tbPDWidth";
			this.tbPDWidth.SettingID = SettingCtrl.SettingIDs.PD_WIDTH;
			this.tbPDWidth.SettingMax = 2147483647;
			this.tbPDWidth.SettingMin = -2147483648;
			this.tbPDWidth.SettingValue = 0;
			this.tbPDWidth.Size = new System.Drawing.Size(40, 19);
			this.tbPDWidth.TabIndex = 8;
			this.tbPDWidth.Text = "0";
			this.tbPDWidth.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.tbPDWidth.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// sbPDWidth
			// 
			this.sbPDWidth.Location = new System.Drawing.Point(72, 72);
			this.sbPDWidth.Name = "sbPDWidth";
			this.sbPDWidth.SettingID = SettingCtrl.SettingIDs.PD_WIDTH;
			this.sbPDWidth.SettingMax = 100;
			this.sbPDWidth.SettingMin = 0;
			this.sbPDWidth.SettingValue = 0;
			this.sbPDWidth.Size = new System.Drawing.Size(232, 17);
			this.sbPDWidth.TabIndex = 7;
			this.sbPDWidth.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// label12
			// 
			this.label12.AutoSize = true;
			this.label12.Location = new System.Drawing.Point(16, 72);
			this.label12.Name = "label12";
			this.label12.Size = new System.Drawing.Size(33, 15);
			this.label12.TabIndex = 6;
			this.label12.Text = "Width";
			// 
			// tbPDOffsetY
			// 
			this.tbPDOffsetY.Location = new System.Drawing.Point(320, 48);
			this.tbPDOffsetY.Name = "tbPDOffsetY";
			this.tbPDOffsetY.SettingID = SettingCtrl.SettingIDs.PD_OFFSETY;
			this.tbPDOffsetY.SettingMax = 2147483647;
			this.tbPDOffsetY.SettingMin = -2147483648;
			this.tbPDOffsetY.SettingValue = 0;
			this.tbPDOffsetY.Size = new System.Drawing.Size(40, 19);
			this.tbPDOffsetY.TabIndex = 5;
			this.tbPDOffsetY.Text = "0";
			this.tbPDOffsetY.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.tbPDOffsetY.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// sbPDOffsetY
			// 
			this.sbPDOffsetY.Location = new System.Drawing.Point(72, 48);
			this.sbPDOffsetY.Name = "sbPDOffsetY";
			this.sbPDOffsetY.SettingID = SettingCtrl.SettingIDs.PD_OFFSETY;
			this.sbPDOffsetY.SettingMax = 100;
			this.sbPDOffsetY.SettingMin = 0;
			this.sbPDOffsetY.SettingValue = 0;
			this.sbPDOffsetY.Size = new System.Drawing.Size(232, 17);
			this.sbPDOffsetY.TabIndex = 4;
			this.sbPDOffsetY.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// label13
			// 
			this.label13.AutoSize = true;
			this.label13.Location = new System.Drawing.Point(16, 48);
			this.label13.Name = "label13";
			this.label13.Size = new System.Drawing.Size(44, 15);
			this.label13.TabIndex = 3;
			this.label13.Text = "OffsetY";
			// 
			// tbPDOffsetX
			// 
			this.tbPDOffsetX.Location = new System.Drawing.Point(320, 24);
			this.tbPDOffsetX.Name = "tbPDOffsetX";
			this.tbPDOffsetX.SettingID = SettingCtrl.SettingIDs.PD_OFFSETX;
			this.tbPDOffsetX.SettingMax = 2147483647;
			this.tbPDOffsetX.SettingMin = -2147483648;
			this.tbPDOffsetX.SettingValue = 0;
			this.tbPDOffsetX.Size = new System.Drawing.Size(40, 19);
			this.tbPDOffsetX.TabIndex = 2;
			this.tbPDOffsetX.Text = "0";
			this.tbPDOffsetX.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.tbPDOffsetX.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// sbPDOffsetX
			// 
			this.sbPDOffsetX.Location = new System.Drawing.Point(72, 24);
			this.sbPDOffsetX.Name = "sbPDOffsetX";
			this.sbPDOffsetX.SettingID = SettingCtrl.SettingIDs.PD_OFFSETX;
			this.sbPDOffsetX.SettingMax = 100;
			this.sbPDOffsetX.SettingMin = 0;
			this.sbPDOffsetX.SettingValue = 0;
			this.sbPDOffsetX.Size = new System.Drawing.Size(232, 17);
			this.sbPDOffsetX.TabIndex = 1;
			this.sbPDOffsetX.SettingValueChanged += new System.EventHandler(this.OnUpdateSettingValue);
			// 
			// label14
			// 
			this.label14.AutoSize = true;
			this.label14.Location = new System.Drawing.Point(16, 24);
			this.label14.Name = "label14";
			this.label14.Size = new System.Drawing.Size(44, 15);
			this.label14.TabIndex = 0;
			this.label14.Text = "OffsetX";
			// 
			// frmSetting
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(394, 488);
			this.Controls.Add(this.groupBox3);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.comboBoxAspectMode);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.comboBoxDisplayMode);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.Name = "frmSetting";
			this.Text = "frmSetting";
			this.Load += new System.EventHandler(this.frmSetting_Load);
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.groupBox3.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private System.Windows.Forms.Label label1;
		private SettingCtrl.SettingComboBox comboBoxDisplayMode;
		private System.Windows.Forms.Label label2;
		private SettingCtrl.SettingComboBox comboBoxAspectMode;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Label label3;
		private SettingCtrl.SettingScrollBar sbPWOffsetX;
		private SettingCtrl.SettingTextBox tbPWOffsetX;
		private System.Windows.Forms.Label label4;
		private SettingCtrl.SettingTextBox tbPWOffsetY;
		private SettingCtrl.SettingScrollBar sbPWOffsetY;
		private SettingCtrl.SettingTextBox tbPWWidth;
		private SettingCtrl.SettingScrollBar sbPWWidth;
		private System.Windows.Forms.Label label5;
		private SettingCtrl.SettingTextBox tbPWHeight;
		private SettingCtrl.SettingScrollBar sbPWHeight;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.GroupBox groupBox2;
		private SettingCtrl.SettingTextBox tbPMHeight;
		private SettingCtrl.SettingScrollBar sbPMHeight;
		private System.Windows.Forms.Label label7;
		private SettingCtrl.SettingTextBox tbPMWidth;
		private SettingCtrl.SettingScrollBar sbPMWidth;
		private System.Windows.Forms.Label label8;
		private SettingCtrl.SettingTextBox tbPMOffsetY;
		private SettingCtrl.SettingScrollBar sbPMOffsetY;
		private System.Windows.Forms.Label label9;
		private SettingCtrl.SettingTextBox tbPMOffsetX;
		private SettingCtrl.SettingScrollBar sbPMOffsetX;
		private System.Windows.Forms.Label label10;
		private System.Windows.Forms.GroupBox groupBox3;
		private SettingCtrl.SettingTextBox tbPDHeight;
		private SettingCtrl.SettingScrollBar sbPDHeight;
		private System.Windows.Forms.Label label11;
		private SettingCtrl.SettingTextBox tbPDWidth;
		private SettingCtrl.SettingScrollBar sbPDWidth;
		private System.Windows.Forms.Label label12;
		private SettingCtrl.SettingTextBox tbPDOffsetY;
		private SettingCtrl.SettingScrollBar sbPDOffsetY;
		private System.Windows.Forms.Label label13;
		private SettingCtrl.SettingTextBox tbPDOffsetX;
		private SettingCtrl.SettingScrollBar sbPDOffsetX;
		private System.Windows.Forms.Label label14;

		private CStCamera m_StCamera = null;

		private void OnUpdateSettingValue(object sender, System.EventArgs e)
		{
			ISettingCtrl isc = sender as ISettingCtrl;

			switch(isc.SettingID)
			{
				case(SettingIDs.DISPLAY_MODE):
					m_StCamera.DisplayMode = (byte)isc.SettingValue;
					break;
				case(SettingIDs.ASPECT_MODE):
					m_StCamera.AspectMode = (byte)isc.SettingValue;
					break;
				case(SettingIDs.PW_OFFSETX):
					m_StCamera.PreviewWindowOffsetX = isc.SettingValue;
						break;
				case(SettingIDs.PW_OFFSETY):
					m_StCamera.PreviewWindowOffsetY = isc.SettingValue;
						break;
				case(SettingIDs.PW_WIDTH):
					m_StCamera.PreviewWindowWidth = (uint)isc.SettingValue;
						break;
				case(SettingIDs.PW_HEIGHT):
					m_StCamera.PreviewWindowHeight = (uint)isc.SettingValue;
						break;
				case(SettingIDs.PM_OFFSETX):
					m_StCamera.PreviewMaskOffsetX = (uint)isc.SettingValue;
						break;
				case(SettingIDs.PM_OFFSETY):
					m_StCamera.PreviewMaskOffsetY = (uint)isc.SettingValue;
						break;
				case(SettingIDs.PM_WIDTH):
					m_StCamera.PreviewMaskWidth = (uint)isc.SettingValue;
						break;
				case(SettingIDs.PM_HEIGHT):
					m_StCamera.PreviewMaskHeight = (uint)isc.SettingValue;
					break;
				case(SettingIDs.PD_OFFSETX):
					m_StCamera.PreviewDestOffsetX = (uint)isc.SettingValue;
					break;
				case(SettingIDs.PD_OFFSETY):
					m_StCamera.PreviewDestOffsetY = (uint)isc.SettingValue;
					break;
				case(SettingIDs.PD_WIDTH):
					m_StCamera.PreviewDestWidth = (uint)isc.SettingValue;
					break;
				case(SettingIDs.PD_HEIGHT):
					m_StCamera.PreviewDestHeight = (uint)isc.SettingValue;
					break;
			}


			mUpdateDisplay();
		}

		private void frmSetting_Load(object sender, System.EventArgs e)
		{
			mInitComboBox();
			mUpdateDisplay();
		}
		private void mUpdateDisplay()
		{
			mUpdateDisplayComboBox();
			mUpdateDisplayTextBoxAndScrollBar();
		}
		private void mInitComboBox()
		{
			CItemForComboBox[] itemsAspectMode = new CItemForComboBox[]{
																		   new CItemForComboBox("Fixed", StCam.STCAM_ASPECT_MODE_FIXED),
																		   new CItemForComboBox("Keep Aspect", StCam.STCAM_ASPECT_MODE_KEEP_ASPECT),
																		   new CItemForComboBox("Adjust Window", StCam.STCAM_ASPECT_MODE_ADJUST_WINDOW),
																		   new CItemForComboBox("Mask", StCam.STCAM_ASPECT_MODE_MASK_SIZE),
																		   new CItemForComboBox("Custom(Offset)", StCam.STCAM_ASPECT_MODE_CUSTOM_OFFSET),
																		   new CItemForComboBox("Custom(Center)", StCam.STCAM_ASPECT_MODE_CUSTOM_CENTER)};
														
			comboBoxAspectMode.Items.Clear();
			comboBoxAspectMode.Items.AddRange(itemsAspectMode);
			comboBoxAspectMode.SelectedIndex = 0;


			CItemForComboBox[] itemsDisplayMode = new CItemForComboBox[]{ 
																			new CItemForComboBox("GDI", StCam.STCAM_DISPLAY_MODE_GDI), 
																			new CItemForComboBox("DirectDraw[Offscreeen]", StCam.STCAM_DISPLAY_MODE_DD_OFFSCREEN), 
																			new CItemForComboBox("DirectDraw[Overlay]", StCam.STCAM_DISPLAY_MODE_DD_OVERLAY), 
																			new CItemForComboBox("DirectDraw[Offscreen HQ]", StCam.STCAM_DISPLAY_MODE_DD_OFFSCREEN_HQ), 
																			new CItemForComboBox("DirectDraw[Overlay HQ]", StCam.STCAM_DISPLAY_MODE_DD_OVERLAY_HQ), 
																			new CItemForComboBox("DirectX", StCam.STCAM_DISPLAY_MODE_DIRECTX), 
																			new CItemForComboBox("DirectX[V Sync ON]", StCam.STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON), 
																			new CItemForComboBox("DirectX[V Sync ON 2]", StCam.STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON2)};


			comboBoxDisplayMode.Items.Clear();
			comboBoxDisplayMode.Items.AddRange(itemsDisplayMode);
			comboBoxDisplayMode.SelectedIndex = 0;

		}
		private void mUpdateDisplayComboBox()
		{
			comboBoxDisplayMode.SettingValue = m_StCamera.DisplayMode;
			comboBoxAspectMode.SettingValue = m_StCamera.AspectMode;
		}
		private void mUpdateDisplayTextBoxAndScrollBar()
		{
			SettingTextBox[] aTB = new SettingTextBox[] { 
											tbPWOffsetX, tbPWOffsetY, tbPWWidth, tbPWHeight, 
											tbPMOffsetX, tbPMOffsetY, tbPMWidth, tbPMHeight, 
											tbPDOffsetX, tbPDOffsetY, tbPDWidth, tbPDHeight};

			SettingScrollBar[] aSB = new SettingScrollBar[] { 
											sbPWOffsetX, sbPWOffsetY, sbPWWidth, sbPWHeight, 
											sbPMOffsetX, sbPMOffsetY, sbPMWidth, sbPMHeight, 
											sbPDOffsetX, sbPDOffsetY, sbPDWidth, sbPDHeight};

			for(int i = 0; i < aTB.GetLength(0); i++)
			{
				const int maxSizeH = 1600;
				const int maxSizeV = 1600;
				int val = 0;
				int max = 0;
				int min = 0;
				bool enabled = true;

				//val , max
				switch(aTB[i].SettingID)
				{
					case(SettingIDs.PW_OFFSETX):
						max = maxSizeH;
						val = m_StCamera.PreviewWindowOffsetX;
						break;
					case(SettingIDs.PW_OFFSETY):
						max = maxSizeV;
						val = m_StCamera.PreviewWindowOffsetY;
						break;
					case(SettingIDs.PW_WIDTH):
						max = maxSizeH;
						val = (int)m_StCamera.PreviewWindowWidth;
						break;
					case(SettingIDs.PW_HEIGHT):
						max = maxSizeV;
						val = (int)m_StCamera.PreviewWindowHeight;
						break;
					case(SettingIDs.PM_OFFSETX):
						max = (int)m_StCamera.OrgImageWidth - (int)m_StCamera.PreviewMaskWidth;
						val = (int)m_StCamera.PreviewMaskOffsetX;
						break;
					case(SettingIDs.PM_OFFSETY):
						max = (int)m_StCamera.OrgImageHeight - (int)m_StCamera.PreviewMaskHeight;
						val = (int)m_StCamera.PreviewMaskOffsetY;
						break;
					case(SettingIDs.PM_WIDTH):
						max = (int)m_StCamera.OrgImageWidth - (int)m_StCamera.PreviewMaskOffsetX;
						val = (int)m_StCamera.PreviewMaskWidth;
						break;
					case(SettingIDs.PM_HEIGHT):
						max = (int)m_StCamera.OrgImageHeight - (int)m_StCamera.PreviewMaskOffsetY;
						val = (int)m_StCamera.PreviewMaskHeight;
						break;
					case(SettingIDs.PD_OFFSETX):
						max = maxSizeH;
						val = (int)m_StCamera.PreviewDestOffsetX;
						break;
					case(SettingIDs.PD_OFFSETY):
						max = maxSizeV;
						val = (int)m_StCamera.PreviewDestOffsetY;
						break;
					case(SettingIDs.PD_WIDTH):
						max = maxSizeH;
						val = (int)m_StCamera.PreviewDestWidth;
						break;
					case(SettingIDs.PD_HEIGHT):
						max = maxSizeV;
						val = (int)m_StCamera.PreviewDestHeight;
						break;
				}

				//Enabled
				if((max <= min) || (val < min) || (max < val))
				{
					enabled = false;
				}
				else
				{
					switch(aTB[i].SettingID)
					{
						case(SettingIDs.PD_OFFSETX):
						case(SettingIDs.PD_OFFSETY):
						case(SettingIDs.PD_WIDTH):
						case(SettingIDs.PD_HEIGHT):
							byte byteAspectMode = m_StCamera.AspectMode;
							if((byteAspectMode != StCam.STCAM_ASPECT_MODE_CUSTOM_OFFSET) && (byteAspectMode != StCam.STCAM_ASPECT_MODE_CUSTOM))
							{
								enabled = false;
							}
							break;
					}



				}


				aTB[i].SettingMin = min;
				aTB[i].SettingMax = max;
				aTB[i].SettingValue = val;
				aTB[i].Enabled = enabled;

				aSB[i].SettingMin = min;
				aSB[i].SettingMax = max;
				aSB[i].SettingValue = val;
				aSB[i].Enabled = enabled;

			}
		}

	}
}
