using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace SettingCtrl
{
	public class SettingComboBox : System.Windows.Forms.ComboBox, ISettingCtrl
	{
		/// <summary>
		private System.ComponentModel.Container components = null;

		public SettingComboBox()
		{
			InitializeComponent();


		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if( components != null )
					components.Dispose();
			}
			base.Dispose( disposing );
		}

		#region Component Designer Code
		private void InitializeComponent()
		{
			// 
			// SettingComboBox
			// 
			this.SelectionChangeCommitted += new System.EventHandler(this.SettingComboBox_SelectionChangeCommitted);

		}
		#endregion

		private SettingIDs m_SettingID = SettingIDs.UNKNOWN;

		private void SettingComboBox_SelectionChangeCommitted(object sender, System.EventArgs e)
		{
			if(SettingValueChanged != null)
			{
				SettingValueChanged(sender, e);
			}
		}
	
		public event System.EventHandler SettingValueChanged = null;

		public SettingIDs SettingID
		{
			get{return(m_SettingID);}
			set{m_SettingID = value;}
		}
		public int SettingValue
		{
			get
			{
				int val = 0;
				if(0 < SelectedIndex)
				{
					CItemForComboBox ifcb = Items[SelectedIndex] as CItemForComboBox;
					val = ifcb.SettingValue;
				}
				return(val);
			}
			set
			{
				for(int index = 0; index < Items.Count; index++)
				{
					CItemForComboBox ifcb = Items[index] as CItemForComboBox;
					if(ifcb.SettingValue == value)
					{
						SelectedIndex = index;
						break;
					}
				}
			}
		}
		
	}
}
