using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace SettingCtrl
{
	public class SettingScrollBar : System.Windows.Forms.HScrollBar, ISettingCtrl, ISettingRange
	{
		private System.ComponentModel.Container components = null;

		public SettingScrollBar()
		{
			InitializeComponent();


		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer Code
		private void InitializeComponent()
		{
			// 
			// SettingScrollBar
			// 
			this.Scroll += new System.Windows.Forms.ScrollEventHandler(this.SettingScrollBar_Scroll);

		}
		#endregion

		#region ISettingCtrl
		private SettingIDs m_SettingId = SettingIDs.UNKNOWN;
		public SettingCtrl.SettingIDs SettingID
		{
			get
			{
				return(m_SettingId);
			}
			set
			{
				m_SettingId = value;
			}
		}

		public int SettingValue
		{
			get
			{
				return(Value);
			}
			set
			{
				Value = value;
			}
		}

		public event System.EventHandler SettingValueChanged = null;

		#endregion

		private void SettingScrollBar_Scroll(object sender, System.Windows.Forms.ScrollEventArgs e)
		{
			if(SettingValueChanged != null)
			{
				SettingValueChanged(this, new EventArgs());
			}
		
		}


		#region ISettingRange

		public int SettingMin
		{
			get
			{
				return(Minimum);
			}
			set
			{
				Minimum = value;
			}
		}

		public int SettingMax
		{
			get
			{
				return(Maximum);
			}
			set
			{
				Maximum = value;
			}
		}

		#endregion
	}
}
