using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace SettingCtrl
{
	public class SettingTextBox : System.Windows.Forms.TextBox, ISettingCtrl, ISettingRange
	{
		private System.ComponentModel.Container components = null;

		public SettingTextBox()
		{
			InitializeComponent();


		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		#region Component Designer Code
		private void InitializeComponent()
		{
			// 
			// SettingTextBox
			// 
			this.Leave += new System.EventHandler(this.SettingTextBox_Leave);

		}
		#endregion


		private int m_nPos = 0;
		private int m_nMin = int.MinValue;
		private int m_nMax = int.MaxValue;

		protected override void OnKeyDown(KeyEventArgs e)
		{
			if(e.KeyCode == Keys.Enter)
			{
				int val = m_nPos;
				try
				{
					val = int.Parse(Text);
				}
				catch(Exception)
				{
					Text = m_nPos.ToString();
				}

				if(val < m_nMin)
				{
					val = m_nMin;
				}
				else if(m_nMax < val)
				{
					val = m_nMax;
				}
				m_nPos = val;
				if(SettingValueChanged != null)
				{
					SettingValueChanged(this, new EventArgs());
				}
			}
			base.OnKeyDown (e);
		}


		#region ISettingCtrl
		private SettingIDs m_SettingID = SettingIDs.UNKNOWN;

		private void SettingTextBox_Leave(object sender, System.EventArgs e)
		{
			Text = m_nPos.ToString();
		}
	
		public SettingCtrl.SettingIDs SettingID
		{
			get
			{
				return(m_SettingID);
			}
			set
			{
				m_SettingID = value;
			}
		}

		public int SettingValue
		{
			get
			{
				return(m_nPos);
			}
			set
			{
				m_nPos = value;
				Text = m_nPos.ToString();
			}
		}

		public event System.EventHandler SettingValueChanged;

		#endregion

		#region ISettingRange

		public int SettingMin
		{
			get
			{
				return(m_nMin);
			}
			set
			{
				m_nMin = value;
			}
		}

		public int SettingMax
		{
			get
			{
				return(m_nMax);
			}
			set
			{
				m_nMax = value;
			}
		}

		#endregion
	}
}
