using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace SampleCallback
{
	/// <summary>
	/// FormSnapShot
	/// </summary>
	public class FormSnapShot : System.Windows.Forms.Form
	{
		private System.Windows.Forms.SaveFileDialog saveFileDialog1;
		private System.Windows.Forms.ContextMenu contextMenu1;
		private System.Windows.Forms.MenuItem MenuItemSave;
		private System.Windows.Forms.PictureBox pictureBox1;
		/// <summary>
		/// 
		/// </summary>
		private System.ComponentModel.Container components = null;

		public FormSnapShot()
		{
			//
			// Windows 
			//
			InitializeComponent();

			//
			//
		}

		/// <summary>
		/// 
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer Code
		/// <summary>
		/// </summary>
		private void InitializeComponent()
		{
			this.saveFileDialog1 = new System.Windows.Forms.SaveFileDialog();
			this.contextMenu1 = new System.Windows.Forms.ContextMenu();
			this.MenuItemSave = new System.Windows.Forms.MenuItem();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.SuspendLayout();
			// 
			// saveFileDialog1
			// 
			this.saveFileDialog1.DefaultExt = "bmp";
			this.saveFileDialog1.Filter = "Bitmap File|*.bmp|All Files|*.*";
			// 
			// contextMenu1
			// 
			this.contextMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this.MenuItemSave});
			// 
			// MenuItemSave
			// 
			this.MenuItemSave.Index = 0;
			this.MenuItemSave.Text = "Save";
			this.MenuItemSave.Click += new System.EventHandler(this.MenuItemSave_Click);
			// 
			// pictureBox1
			// 
			this.pictureBox1.ContextMenu = this.contextMenu1;
			this.pictureBox1.Location = new System.Drawing.Point(80, 80);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// FormSnapShot
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.AutoScroll = true;
			this.ClientSize = new System.Drawing.Size(292, 273);
			this.Controls.Add(this.pictureBox1);
			this.Name = "FormSnapShot";
			this.Text = "Snap Shot";
			this.KeyDown += new System.Windows.Forms.KeyEventHandler(this.FormSnapShot_KeyDown);
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FormSnapShot_Closing);
			this.ResumeLayout(false);

		}
		#endregion


		private Bitmap m_Bitmap;
		private bool m_SavedFg = false;

		private void SaveImage()
		{
			if(null != m_Bitmap)
			{
				if(DialogResult.OK == saveFileDialog1.ShowDialog())
				{
					m_Bitmap.Save(saveFileDialog1.FileName, System.Drawing.Imaging.ImageFormat.Bmp);
					m_SavedFg = true;
				}
			}
		}

		private void MenuItemSave_Click(object sender, System.EventArgs e)
		{
			SaveImage();
		}

		public bool bUpdateSnapShot(byte[] pbyteImg, int nWidth, int nHeight, System.Drawing.Imaging.PixelFormat pixelFormat)
		{
			Bitmap bitmap = new Bitmap(nWidth, nHeight, pixelFormat);
			int nBufferSize = nWidth * nHeight;

			switch(pixelFormat)
			{

				case(System.Drawing.Imaging.PixelFormat.Format8bppIndexed):
					//Palette
					{
							
						System.Drawing.Imaging.ColorPalette colorPalette = bitmap.Palette;
						for(int pixelValue = 0; pixelValue <= 255; pixelValue++)
						{
							colorPalette.Entries[pixelValue] = Color.FromArgb(pixelValue, pixelValue, pixelValue);
						}
						bitmap.Palette = colorPalette;
					}
					break;
				case(System.Drawing.Imaging.PixelFormat.Format24bppRgb):
					nBufferSize *= 3;
					break;
				case(System.Drawing.Imaging.PixelFormat.Format32bppRgb):
					nBufferSize *= 4;
					break;
			}

			//Copy
			System.Drawing.Imaging.BitmapData bitmapData = bitmap.LockBits(new Rectangle(0, 0, nWidth, nHeight), System.Drawing.Imaging.ImageLockMode.WriteOnly, pixelFormat);
			System.Runtime.InteropServices.Marshal.Copy(pbyteImg, 0, bitmapData.Scan0, nBufferSize);
			bitmap.UnlockBits(bitmapData);
			
			if(m_Bitmap != null)
			{
				pictureBox1.Image = null;
				m_Bitmap.Dispose();
			}

			m_Bitmap = bitmap;
			this.ClientSize = new Size(nWidth, nHeight);
			this.MaximumSize = this.Size;
			pictureBox1.Location = new Point(0, 0);
			pictureBox1.Image = m_Bitmap;
			m_SavedFg = false;

			return(true);
		}

		private void FormSnapShot_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if(!m_SavedFg)
			{
				if(DialogResult.Yes == System.Windows.Forms.MessageBox.Show("Do You Want To Save The Image?", "Save Image", System.Windows.Forms.MessageBoxButtons.YesNo, System.Windows.Forms.MessageBoxIcon.Question))
				{
					SaveImage();
				}
			}
			if(m_Bitmap != null)
			{
				pictureBox1.Image = null;
				m_Bitmap.Dispose();
				m_Bitmap = null;
			}
		}

		private void FormSnapShot_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if(e.KeyCode == Keys.Apps)
			{
				contextMenu1.Show(this, this.PointToClient(MousePosition));
			}
		}


	}
}
