using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using SensorTechnology;
using System.Runtime.InteropServices;
namespace SampleErrMsg
{
	/// <summary>
	/// Form1
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Button btnPreview;
		private System.IntPtr m_hCamera;

		private bool m_bStatusTransfer = false;
		private bool m_bStatusAVIFile = false;
		private bool m_bStatusPreviewWnd = false;


		public Form1()
		{
			InitializeComponent();

			
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer Code

		private void InitializeComponent()
		{
			this.btnPreview = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// btnPreview
			// 
			this.btnPreview.Location = new System.Drawing.Point(8, 8);
			this.btnPreview.Name = "btnPreview";
			this.btnPreview.Size = new System.Drawing.Size(120, 32);
			this.btnPreview.TabIndex = 0;
			this.btnPreview.Text = "Preview";
			this.btnPreview.Click += new System.EventHandler(this.btnPreview_Click);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(136, 46);
			this.Controls.Add(this.btnPreview);
			this.Name = "Form1";
			this.Text = "Form1";
			this.Load += new System.EventHandler(this.Form1_Load);
			this.Closed += new System.EventHandler(this.Form1_Closed);
			this.ResumeLayout(false);

		}
		#endregion

		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
			m_hCamera = StCam.Open(0);
			if(m_hCamera == IntPtr.Zero) ShowErrorMsg(StCam.GetLastError(m_hCamera));
			if(!StCam.SetReceiveMsgWindow(m_hCamera, this.Handle))
				ShowErrorMsg(StCam.GetLastError(m_hCamera));
			StatusChanged();
		}

		private void Form1_Closed(object sender, System.EventArgs e)
		{
			if(m_hCamera != System.IntPtr.Zero) StCam.Close(m_hCamera);
		}

		private void btnPreview_Click(object sender, System.EventArgs e)
		{
			if(m_bStatusPreviewWnd && m_bStatusTransfer)
			{
				//Stop
				if(!StCam.StopTransfer(m_hCamera))
					ShowErrorMsg(StCam.GetLastError(m_hCamera));
			}
			else
			{
				//Start
				if(!StCam.CreatePreviewWindow(m_hCamera,"Preview",StCam.WS_OVERLAPPEDWINDOW | StCam.WS_VISIBLE,0,0,0,0,System.IntPtr.Zero,System.IntPtr.Zero,true))
					ShowErrorMsg(StCam.GetLastError(m_hCamera));
				if(!StCam.StartTransfer(m_hCamera))
					ShowErrorMsg(StCam.GetLastError(m_hCamera));
			}
		}
		private void StatusChanged()
		{
			if(m_bStatusPreviewWnd && m_bStatusTransfer)
				btnPreview.Text = "STOP";
			else
				btnPreview.Text = "START";
		}
		[System.Security.Permissions.PermissionSet(System.Security.Permissions.SecurityAction.Demand,Name="FullTrust")]
		protected override void WndProc(ref Message m)
		{
			switch(m.Msg)
			{
				case StCam.WM_STCAM_TRANSFER_START:
					m_bStatusTransfer = true;
					StatusChanged();
					break;
				case StCam.WM_STCAM_TRANSFER_FINISH:
					m_bStatusTransfer = false;
					StatusChanged();
					if((uint)m.LParam != 0) ShowErrorMsg((uint)m.LParam);	
					break;
				case StCam.WM_STCAM_AVI_FILE_START:
					m_bStatusAVIFile = true;
					StatusChanged();
					break;
				case StCam.WM_STCAM_AVI_FILE_FINISH:
					m_bStatusAVIFile = false;
					StatusChanged();
					if((uint)m.LParam != 0) ShowErrorMsg((uint)m.LParam);	
					break;
				case StCam.WM_STCAM_PREVIEW_WINDOW_CREATE:
					m_bStatusPreviewWnd = true;
					StatusChanged();
					break;
				case StCam.WM_STCAM_PREVIEW_WINDOW_CLOSE:
					m_bStatusPreviewWnd = false;
					StatusChanged();
					if((uint)m.LParam != 0) ShowErrorMsg((uint)m.LParam);	
					break;

				default:
					base.WndProc(ref m);
					break;
			}
		}
		
		[DllImport("kernel32.dll", CharSet=System.Runtime.InteropServices.CharSet.Auto)]
		private static extern int FormatMessage(int dwFlags, IntPtr lpSource,
			int dwMessageId, int dwLanguageId, System.Text.StringBuilder lpBuffer, int nSize, IntPtr Arguments);
		[DllImport("kernel32.dll", CharSet=System.Runtime.InteropServices.CharSet.Auto)]
		private static extern IntPtr LoadLibraryEx(String lpszLibFile, IntPtr hFile, int dwFlags);
		[DllImport("kernel32.dll")]
		private static extern int FreeLibrary(IntPtr hModule);

		private void ShowErrorMsg(uint dwErrorCode)
		{
			int FORMAT_MESSAGE_FROM_SYSTEM = 0x00001000;
			int FORMAT_MESSAGE_FROM_HMODULE = 0x00000800;

			int DONT_RESOLVE_DLL_REFERENCES = 0x00000001;

			System.Text.StringBuilder strErrorMsg = new System.Text.StringBuilder(255);
			int dwFlags = FORMAT_MESSAGE_FROM_SYSTEM;
			IntPtr ptrlpSource = IntPtr.Zero;

			int iFoundErrMsg = FormatMessage(dwFlags, ptrlpSource, (int)dwErrorCode, 0, strErrorMsg, strErrorMsg.Capacity, IntPtr.Zero);
			if(iFoundErrMsg == 0)
			{
				ptrlpSource = LoadLibraryEx("StCamMsg.dll", IntPtr.Zero, DONT_RESOLVE_DLL_REFERENCES);
				dwFlags |= FORMAT_MESSAGE_FROM_HMODULE;

				if(!ptrlpSource.Equals(IntPtr.Zero))
				{
					iFoundErrMsg = FormatMessage(dwFlags, ptrlpSource, (int)dwErrorCode, 0, strErrorMsg, strErrorMsg.Capacity, IntPtr.Zero);
					FreeLibrary(ptrlpSource);
				}
			}

			System.Windows.Forms.MessageBox.Show(strErrorMsg.ToString(), "Error Message", System.Windows.Forms.MessageBoxButtons.OK, System.Windows.Forms.MessageBoxIcon.Exclamation);

		}
	}
}
