#include <windows.h>
#include <tchar.h>
#include <stdio.h>

#include "../../../include/StTrgApi.h"

#ifdef _WIN64
#pragma comment(lib, "../../../lib/x64/StTrgApi.lib")
#else //_WIN64
#pragma comment(lib, "../../../lib/x86/StTrgApi.lib")
#endif //_WIN64

int main(int argc, char* argv[])
{
	HANDLE hCamera = INVALID_HANDLE_VALUE;

	//-------------------------------------------------------------------------
	//Bitmap File Path
	//-------------------------------------------------------------------------
	TCHAR szBitmapFilePath[MAX_PATH];
	_tcscpy(szBitmapFilePath, argv[0]);
	TCHAR *szTmp = _tcsrchr(szBitmapFilePath, TEXT('\\'));
	szTmp[1] = NULL;

	//-------------------------------------------------------------------------
	//Open
	//-------------------------------------------------------------------------
	hCamera = StTrg_Open();
	if(INVALID_HANDLE_VALUE == hCamera)
	{
		_tprintf(TEXT("Couldn't Open.\n"));
		return(-1);
	}

	//-------------------------------------------------------------------------
	//Camera Version
	//-------------------------------------------------------------------------
	WORD wUSBVendorID = 0;
	WORD wUSBProductID = 0;
	WORD wFPGAVersion = 0;
	WORD wFirmVersion = 0;
	if(!StTrg_GetCameraVersion(hCamera, &wUSBVendorID, &wUSBProductID, &wFPGAVersion, &wFirmVersion))
	{
		_tprintf(TEXT("Get Camera Version Failed.\n"));
		return(-1);
	}
	TCHAR szProductName[MAX_PATH];
	if(!StTrg_GetProductName(hCamera, szProductName, sizeof(szProductName)))
	{
		_tprintf(TEXT("Get Product Name Failed.\n"));
		return(-1);
	}

	_tprintf(TEXT("USB Vendor ID : 0x%04X - Sensor Technology\n"), wUSBVendorID);
	_tprintf(TEXT("USB Product ID : 0x%04X - %s\n"), wUSBProductID, szProductName);
	_tprintf(TEXT("FPGA Version : 0x%04X\n"), wFPGAVersion);
	_tprintf(TEXT("Firmware Version : 0x%04X\n"), wFirmVersion);

	
	//-------------------------------------------------------------------------
	//
	//-------------------------------------------------------------------------
	BOOL bTriggerEnabled = TRUE;
	switch(wUSBProductID)
	{
	case(STCAM_USBPID_STC_C33USB):
	case(STCAM_USBPID_STC_C83USB):
	case(STCAM_USBPID_STC_B33USB):
	case(STCAM_USBPID_STC_B83USB):
		bTriggerEnabled = FALSE;
		break;
	}
	//-------------------------------------------------------------------------
	//Trigger Mode -> Free Run Mode
	//-------------------------------------------------------------------------
	if(bTriggerEnabled)
	{
		if(!StTrg_SetTriggerMode(hCamera, 0))
		{
			_tprintf(TEXT("Set Trigger Mode Failed.\n"));
			return(-1);
		}
	}
	//-------------------------------------------------------------------------
	//Scan Mode
	//-------------------------------------------------------------------------
	WORD	wScanMode = STCAM_SCAN_MODE_NORMAL;
		//STCAM_SCAN_MODE_NORMAL,  STCAM_SCAN_MODE_PARTIAL_1, 
		//STCAM_SCAN_MODE_PARTIAL_2, STCAM_SCAN_MODE_PARTIAL_4,STCAM_SCAN_MODE_VARIABLE_PARTIAL
		//STCAM_SCAN_MODE_BINNING, STCAM_SCAN_MODE_BINNING_PARTIAL_1, 
		//STCAM_SCAN_MODE_BINNING_PARTIAL_2, STCAM_SCAN_MODE_BINNING_PARTIAL_4, STCAM_SCAN_MODE_BINNING_VARIABLE_PARTIAL
		//STCAM_SCAN_MODE_AOI
	DWORD dwOffsetX = 0;
	DWORD dwOffsetY = 0;
	DWORD dwWidth = 0;
	DWORD dwHeight = 0;
	/*
	if(!StTrg_SetScanMode(hCamera, wScanMode, dwOffsetX, dwOffsetY, dwWidth, dwHeight))
	{
		_tprintf(TEXT("Set Scan Mode Failed.\n"));
		return(-1);
	}
	*/
	if(!StTrg_GetScanMode(hCamera, &wScanMode, &dwOffsetX, &dwOffsetY, &dwWidth, &dwHeight))
	{
		_tprintf(TEXT("Get Scan Mode Failed.\n"));
		return(-1);
	}
	LPCTSTR	szScanMode = NULL;
	switch(wScanMode)
	{
		case(STCAM_SCAN_MODE_NORMAL):					szScanMode = TEXT("NORMAL"); break;
		case(STCAM_SCAN_MODE_PARTIAL_1):				szScanMode = TEXT("PARTIAL_1"); break;
		case(STCAM_SCAN_MODE_PARTIAL_2):				szScanMode = TEXT("PARTIAL_2"); break;
		case(STCAM_SCAN_MODE_PARTIAL_4):				szScanMode = TEXT("PARTIAL_4"); break;
		case(STCAM_SCAN_MODE_VARIABLE_PARTIAL):			szScanMode = TEXT("VARIABLE_PARTIAL"); break;
		case(STCAM_SCAN_MODE_BINNING):					szScanMode = TEXT("BINNING"); break;
		case(STCAM_SCAN_MODE_BINNING_PARTIAL_1):		szScanMode = TEXT("BINNING_PARTIAL_1"); break;
		case(STCAM_SCAN_MODE_BINNING_PARTIAL_2):		szScanMode = TEXT("BINNING_PARTIAL_2"); break;
		case(STCAM_SCAN_MODE_BINNING_PARTIAL_4):		szScanMode = TEXT("BINNING_PARTIAL_4"); break;
		case(STCAM_SCAN_MODE_BINNING_VARIABLE_PARTIAL):	szScanMode = TEXT("BINNING_VARIABLE_PARTIAL"); break;
		case(STCAM_SCAN_MODE_AOI):						szScanMode = TEXT("AOI"); break;
		default:										szScanMode = TEXT("UNKNOWN"); break;
	}
	_tprintf(TEXT("Scan Mode : 0x%04X - %s\n"), wScanMode, szScanMode);
	_tprintf(TEXT("OffsetX : %u / OffsetY : %u\n"), dwOffsetX, dwOffsetY);
	_tprintf(TEXT("Width : %u / Height : %u\n"), dwWidth, dwHeight);

	//-------------------------------------------------------------------------
	//
	//-------------------------------------------------------------------------
	DWORD dwTransferBitsPerPixel = 	STCAM_TRANSFER_BITS_PER_PIXEL_RAW_08;
	//DWORD dwTransferBitsPerPixel = 	STCAM_TRANSFER_BITS_PER_PIXEL_RAW_10
	//DWORD dwTransferBitsPerPixel = 	STCAM_TRANSFER_BITS_PER_PIXEL_RAW_12
	DWORD dwEnableTransferBitsPerPixel = STCAM_TRANSFER_BITS_PER_PIXEL_RAW_08;
	if(!StTrg_GetEnableTransferBitsPerPixel(hCamera, &dwEnableTransferBitsPerPixel))
	{
		_tprintf(TEXT("GetEnableTransferBitsPerPixel Failed.\n"));
		return(-1);
	}
	dwTransferBitsPerPixel &= dwEnableTransferBitsPerPixel;
	if(0 == dwTransferBitsPerPixel)
	{
		dwTransferBitsPerPixel = STCAM_TRANSFER_BITS_PER_PIXEL_RAW_08;
	}
	if(!StTrg_SetTransferBitsPerPixel(hCamera, dwTransferBitsPerPixel))
	{
		_tprintf(TEXT("SetTransferBitsPerPixel Failed.\n"));
		return(-1);
	}
	if(!StTrg_GetTransferBitsPerPixel(hCamera, &dwTransferBitsPerPixel))
	{
		_tprintf(TEXT("GetTransferBitsPerPixel Failed.\n"));
		return(-1);
	}

	BOOL is2BytesMode = (STCAM_TRANSFER_BITS_PER_PIXEL_RAW_08 != dwTransferBitsPerPixel);
	DWORD  dwClockMode = is2BytesMode?STCAM_CLOCK_MODE_DIV_2:STCAM_CLOCK_MODE_NORMAL;
	if(!StTrg_SetClock(hCamera, dwClockMode, 0))
	{
		_tprintf(TEXT("SetClock Failed.\n"));
		return(-1);
	}


	//-------------------------------------------------------------------------
	//Transfer Start
	//-------------------------------------------------------------------------
	if(!StTrg_StartTransfer(hCamera))
	{
		_tprintf(TEXT("Couldn't Start.\n"));
		return(-1);
	}

	//-------------------------------------------------------------------------
	//
	//-------------------------------------------------------------------------
	DWORD dwBufferSize = dwWidth * dwHeight;
	if(is2BytesMode)
	{
		dwBufferSize *= 2;
	}
	PBYTE pbyteRaw = new BYTE[dwBufferSize];
	if(NULL != pbyteRaw)
	{
		DWORD dwNumberOfByteTrans = 0;
		DWORD dwFrameNo = 0;
		DWORD dwMilliseconds = 3000;
		for(DWORD dwPos = 0; dwPos < 10; dwPos++)
		{

			if(StTrg_TakeRawSnapShot(hCamera, pbyteRaw, dwBufferSize, &dwNumberOfByteTrans, &dwFrameNo, dwMilliseconds))
			{
				TCHAR szFileName[MAX_PATH];
				if(is2BytesMode)
				{
					_stprintf(szFileName, TEXT("%s\\%u.tif"), szBitmapFilePath, dwFrameNo);
					StTrg_SaveImage(dwWidth, dwHeight, STCAM_PIXEL_FORMAT_16_MONO_OR_RAW, pbyteRaw, szFileName, 0);
				}
				else
				{
					_stprintf(szFileName, TEXT("%s\\%u.bmp"), szBitmapFilePath, dwFrameNo);
					StTrg_SaveImage(dwWidth, dwHeight, STCAM_PIXEL_FORMAT_08_MONO_OR_RAW, pbyteRaw, szFileName, 0);
				}
				_tprintf(TEXT("Save Image:%s\n"), szFileName);
			}
			else
			{
				_tprintf(TEXT("Fail:StTrg_TakeRawSnapShot\n"));
				break;
			}
		}
		delete[] pbyteRaw;
	}

	
	//-------------------------------------------------------------------------
	//Stop Transfer
	//-------------------------------------------------------------------------
	if(!StTrg_StopTransfer(hCamera))
	{
		_tprintf(TEXT("Can't Stop.\n"));
		return(-1);
	}


	//-------------------------------------------------------------------------
	//Close
	//-------------------------------------------------------------------------
	StTrg_Close(hCamera);
	
	_tprintf(TEXT("End(Press Enter)\n"));
	getchar();
	getchar();

	return 0;
}

