// FPS.cpp
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "StTrgDisplay.h"
#include "FPS.h"
#include <mmsystem.h>

#pragma comment(lib, "winmm.lib")

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
CFPS::CFPS(DWORD dwMaxSampleCount)
{
	if(2 <= dwMaxSampleCount)
	{
		m_dwMaxSampleCount = dwMaxSampleCount;
	}
	else
	{
		m_dwMaxSampleCount = 100;
	}
	m_dwPos = m_dwMaxSampleCount - 1;
	m_dwCurSampleCount = 0;

	m_pdwRcvTime = new DWORD[m_dwMaxSampleCount];
	if(NULL != m_pdwRcvTime)
	{
		memset(m_pdwRcvTime, 0, sizeof(DWORD) * m_dwMaxSampleCount);
	}

	m_hTimeMutex = CreateMutex(NULL, FALSE, NULL);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
CFPS::~CFPS()
{
	if(NULL != m_hTimeMutex)
	{
		CloseHandle(m_hTimeMutex);
		m_hTimeMutex = NULL;
	}

	if(NULL != m_pdwRcvTime)
	{
		delete[] m_pdwRcvTime;
		m_pdwRcvTime = NULL;
	}
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CFPS::Rcv()
{
	WaitForSingleObject(m_hTimeMutex, INFINITE);

	m_dwPos++;
	if(m_dwMaxSampleCount <= m_dwPos)
	{
		m_dwPos = 0;
	}
	if(m_dwCurSampleCount < m_dwMaxSampleCount)
	{
		m_dwCurSampleCount++;
	}
	m_pdwRcvTime[m_dwPos] = timeGetTime();

	ReleaseMutex(m_hTimeMutex);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
double CFPS::GetFPS()
{
	DWORD	dwFirstPos = 0;
	
	if(m_dwCurSampleCount < 2)
	{
		return(0.0);
	}

	WaitForSingleObject(m_hTimeMutex, INFINITE);
	if(m_dwMaxSampleCount <= m_dwCurSampleCount)
	{
		if(m_dwPos < m_dwMaxSampleCount - 1)
		{
			dwFirstPos = m_dwPos + 1;
		}
		else
		{
			dwFirstPos = 0;
		}
	}

	double dblFPS = 1000.0 * (m_dwCurSampleCount - 1) / (double)(m_pdwRcvTime[m_dwPos] - m_pdwRcvTime[dwFirstPos]);
	ReleaseMutex(m_hTimeMutex);
	return(dblFPS);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------