// StCamera.cpp: CStCamera
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "StCamera.h"

//////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////

CStCamera::CStCamera():
	m_hCamera(NULL),
	m_dwCameraNo(0), 
	m_wUSBVendorID(0), m_wUSBProductID(0), m_wFPGAVersion(0), m_wFirmVersion(0), m_wColorArray(0),
	m_dwFileVersionMS(0), m_dwFileVersionLS(0), m_dwProductVersionMS(0), m_dwProductVersionLS(0), 
	m_dwPixelFormat(STCAM_PIXEL_FORMAT_08_MONO_OR_RAW),
	m_byteColorInterpolationMethod(STCAM_COLOR_INTERPOLATION_NONE_MONO),
	m_dwTriggerMode(0), m_bAutoTrigger(FALSE), m_dwNoiseReductionMode(STCAM_NR_OFF),
	m_byteMirrorMode(STCAM_MIRROR_OFF), m_byteRotationMode(STCAM_ROTATION_OFF),
	m_dwEnableTranderBitsPerPixel(STCAM_TRANSFER_BITS_PER_PIXEL_08), m_wEnableScanMode(STCAM_SCAN_MODE_NORMAL), m_dwEnableCloclMode(0),
	m_dwMaximumImageWidth(0), m_dwMaximumImageHeight(0), m_dwMaxVBlankForFPS(0)
{
	_tcscpy(m_szCameraName, TEXT(""));
	StTrg_GetDllVersion(&m_dwFileVersionMS, &m_dwFileVersionLS, &m_dwProductVersionMS, &m_dwProductVersionLS);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
CStCamera::~CStCamera()
{

}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::InitializeCameraInfo()
{
	BOOL	bReval = TRUE;

	do{
		//Get Camera Info
		bReval = StTrg_GetCameraVersion(m_hCamera, &m_wUSBVendorID, &m_wUSBProductID, &m_wFPGAVersion, &m_wFirmVersion);
		if(!bReval) break;

		bReval = StTrg_GetEnableTransferBitsPerPixel(m_hCamera, &m_dwEnableTranderBitsPerPixel);
		if(!bReval) break;

		bReval = StTrg_GetEnableScanMode(m_hCamera, &m_wEnableScanMode);
		if(!bReval) break;

		bReval = StTrg_GetEnableClockMode(m_hCamera, &m_dwEnableCloclMode);
		if(!bReval) break;

		bReval = StTrg_GetColorArray(m_hCamera, &m_wColorArray);
		if(!bReval) break;

		if(STCAM_COLOR_ARRAY_MONO != m_wColorArray)
		{
			m_dwPixelFormat = STCAM_PIXEL_FORMAT_24_BGR;
			//m_dwPixelFormat = STCAM_PIXEL_FORMAT_32_BGR;
			m_byteColorInterpolationMethod = STCAM_COLOR_INTERPOLATION_BILINEAR;
		}

		//Image Size
		bReval = StTrg_GetMaximumImageSize(m_hCamera, &m_dwMaximumImageWidth, &m_dwMaximumImageHeight);
		if(!bReval) break;

		memset(m_szCameraName, 0, sizeof(m_szCameraName));
		bReval = StTrg_ReadCameraUserID(m_hCamera, &m_dwCameraNo, m_szCameraName, sizeof(m_szCameraName));
		if(!bReval) break;

		if(HasTriggerFunction())
		{
			//Trigger Mode
			bReval = StTrg_GetTriggerMode(m_hCamera, &m_dwTriggerMode);
			if(!bReval) break;
		}

		//Max V Blank For FPS
		bReval = StTrg_GetMaxVBlankForFPS(m_hCamera, &m_dwMaxVBlankForFPS);
		if(!bReval) break;

		//Set Callback Functions
		bReval = StTrg_SetExposureEndCallback(m_hCamera, CStCamera::StaticExposureEndCallback, this);
		if(!bReval) break;

		bReval = StTrg_SetTransferEndCallback(m_hCamera, CStCamera::StaticTransferEndCallback, this);
		if(!bReval) break;

		bReval = StTrg_SetRcvErrorCallback(m_hCamera, CStCamera::StaticRcvErrorCallback, this);
		if(!bReval) break;

	}while(0);

	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::StartTransfer()
{
	BOOL	bReval = TRUE;

	bReval = StTrg_StartTransfer(m_hCamera);



	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::StopTransfer()
{
	BOOL	bReval = TRUE;

	if(
		(STCAM_TRIGGER_MODE_EXPTIME_START_STOP == (STCAM_TRIGGER_MODE_EXPTIME_MASK & m_dwTriggerMode)) &&
		(STCAM_TRIGGER_MODE_SOURCE_SOFTWARE == (STCAM_TRIGGER_MODE_SOURCE_MASK & m_dwTriggerMode)) &&
		(m_bAutoTrigger)
	)
	{
		StopTimer();
	}

	bReval = StTrg_StopTransfer(m_hCamera);
	return(bReval);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::SoftTrigger()
{

	BOOL bReval = TRUE;
	if(
		(STCAM_TRIGGER_MODE_EXPTIME_START_STOP == (STCAM_TRIGGER_MODE_EXPTIME_MASK & m_dwTriggerMode)) &&
		(STCAM_TRIGGER_MODE_SOURCE_SOFTWARE == (STCAM_TRIGGER_MODE_SOURCE_MASK & m_dwTriggerMode)) &&
		(m_bAutoTrigger)
	)
	{
		StartTimer();
	}
	else
	{
		bReval = StTrg_SoftTrigger(m_hCamera);
	}
	return(bReval);


}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::SettingFile(BOOL bOpenFg, LPCTSTR szFileName)
{
	BOOL bReval = TRUE;

	TCHAR	szSectionName[MAX_PATH];
	_stprintf(szSectionName, TEXT("Other-%04X"), m_wUSBProductID);
	

	do{
		if(bOpenFg)
		{
			bReval = StTrg_ReadSettingFile(m_hCamera, szFileName);
			if(!bReval) break;
			
			if(HasTriggerFunction())
			{
				//Trigger Mode
				bReval = StTrg_GetTriggerMode(m_hCamera, &m_dwTriggerMode);
				if(!bReval) break;
			}

		}
		else
		{
			bReval = StTrg_WriteSettingFile(m_hCamera, szFileName);
			if(!bReval) break;
		}
	
		//Color Interpolation
		LPCTSTR szKeyName = TEXT("ColorInterpolationMethod");
		TCHAR szValue[MAX_PATH];
		if(bOpenFg)
		{
			m_byteColorInterpolationMethod = GetPrivateProfileInt(szSectionName, szKeyName, m_byteColorInterpolationMethod, szFileName);
		}
		else
		{
			_stprintf(szValue, TEXT("%u"), m_byteColorInterpolationMethod);
			WritePrivateProfileString(szSectionName, szKeyName, szValue, szFileName);
		}

		//Mirror
		szKeyName = TEXT("MirrorMode");
		if(bOpenFg)
		{
			m_byteMirrorMode = GetPrivateProfileInt(szSectionName, szKeyName, m_byteMirrorMode, szFileName);
		}
		else
		{
			_stprintf(szValue, TEXT("%u"), m_byteMirrorMode);
			WritePrivateProfileString(szSectionName, szKeyName, szValue, szFileName);
		}
		//Rotation
		szKeyName = TEXT("RotationMode");
		if(bOpenFg)
		{
			m_byteRotationMode = GetPrivateProfileInt(szSectionName, szKeyName, m_byteRotationMode, szFileName);
		}
		else
		{
			_stprintf(szValue, TEXT("%u"), m_byteRotationMode);
			WritePrivateProfileString(szSectionName, szKeyName, szValue, szFileName);
		}

		_stprintf(szSectionName, TEXT("Trigger-%04X"), m_wUSBProductID);

		//Start/Stop
		UINT Delay = 0, Resolution = 0;
		GetPeriod(&Delay, &Resolution);
			
		szKeyName = TEXT("AutoTriggerMode");
		if(bOpenFg)
		{
			m_bAutoTrigger = GetPrivateProfileInt(szSectionName, szKeyName, m_bAutoTrigger, szFileName);
		}
		else
		{
			_stprintf(szValue, TEXT("%d"), m_bAutoTrigger);
			WritePrivateProfileString(szSectionName, szKeyName, szValue, szFileName);
		}

		szKeyName = TEXT("AutoTriggerDelay");
		if(bOpenFg)
		{
			Delay = GetPrivateProfileInt(szSectionName, szKeyName, Delay, szFileName);
		}
		else
		{
			_stprintf(szValue, TEXT("%u"), Delay);
			WritePrivateProfileString(szSectionName, szKeyName, szValue, szFileName);
		}

		szKeyName = TEXT("AutoTriggerResolution");
		if(bOpenFg)
		{
			Resolution = GetPrivateProfileInt(szSectionName, szKeyName, Resolution, szFileName);
		}
		else
		{
			_stprintf(szValue, TEXT("%u"), Resolution);
			WritePrivateProfileString(szSectionName, szKeyName, szValue, szFileName);
		}
		if(bOpenFg)
		{
			SetPeriod(Delay, Resolution);
		}
	}while(0);

	return(bReval);
}





