// StCamera.h: CStCamera
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_STCAMERA_H__EADFB89B_7118_42CE_8239_B97FCDC34FC0__INCLUDED_)
#define AFX_STCAMERA_H__EADFB89B_7118_42CE_8239_B97FCDC34FC0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "TimerFunc.h"

class CStCamera : public CTimerFunc 
{
public:
	CStCamera();
	virtual ~CStCamera();

	BOOL	InitializeCameraInfo();
	BOOL	StartTransfer();
	BOOL	StopTransfer();
	BOOL	SoftTrigger();
	
	BOOL	SettingFile(BOOL bOpenFg, LPCTSTR szFileName);
	static void CALLBACK StaticExposureEndCallback(HANDLE hCamera, DWORD dwFrameNo, PVOID pvContext)
	{
		((CStCamera*)pvContext)->ExposureEndCallback(hCamera, dwFrameNo);
	};
	static void CALLBACK StaticTransferEndCallback(HANDLE hCamera, DWORD dwFrameNo, DWORD dwWidth, DWORD dwHeight, WORD wColorArray, PBYTE pbyteRaw, PVOID pvContext)
	{
		((CStCamera*)pvContext)->TransferEndCallback(hCamera, dwFrameNo, dwWidth, dwHeight, wColorArray, pbyteRaw);
	};
	static void CALLBACK StaticRcvErrorCallback(HANDLE hCamera, DWORD dwErrorCode, PVOID pvContext)
	{
		((CStCamera*)pvContext)->RcvErrorCallback(hCamera, dwErrorCode);
	};
	BOOL TimerStartProc()
	{
		//Start Trigger
#ifdef _DEBUG
		DWORD dwTime = timeGetTime();
		TRACE(TEXT("[%u]:Strat Trigger\r\n"), dwTime - m_dwLastStartTriggerTime);
		m_dwLastStartTriggerTime = dwTime;
#endif //_DEUBG
		BOOL bReval = StTrg_SoftTrigger(m_hCamera);
		return(bReval);
	};
	BOOL TimerStopProc()
	{
		//End Trigger
#ifdef _DEBUG
		DWORD dwTime = timeGetTime();
		TRACE(TEXT("[%u]:End Trigger\r\n"),  dwTime - m_dwLastStartTriggerTime);
		m_dwLastStartTriggerTime = dwTime;
#endif //_DEBUG
		BOOL bReval = StTrg_SoftSubTrigger(m_hCamera);
		return(bReval);
	};
	BOOL HasTriggerFunction(void)
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_TRIGGER, &bReval);
		return(bReval);
	};

	BOOL HasDigitalGainFunction(void)
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_DIGITAL_GAIN, &bReval);
		return(bReval);
	};
	BOOL HasVariablePartialMode(void)
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_VARIABLE_PARTIAL, &bReval);
		return(bReval);
	};
	BOOL HasBinningPartialMode(void)
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_BINNING_PARTIAL, &bReval);
		return(bReval);
	};
	BOOL HasStartStopMode(void)
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_STARTSTOP, &bReval);
		return(bReval);
	};
	BOOL HasPulseWidthExposureFunction(void)
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_DISABLE_PULSE_WIDTH_EXPOSURE, &bReval);
		return(!bReval);
	};

	BOOL HasTriggerMaskFunction(void)
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_TRIGGER_MASK, &bReval);
		return(bReval);
	};
	BOOL HasTriggerThroughFunction(void)
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_PHOTOCOUPLER, &bReval);
		return(!bReval);
	};
	BOOL HasChangeIOFunction(void)
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_IO_CHANGE_DIRECTION, &bReval);
		return(bReval);
	};
	BOOL HasLEDFunction(DWORD index)
	{
		DWORD dwLEDExistence = 0;
		BOOL bReval = FALSE;
		StTrg_GetLEDExistence(m_hCamera, &dwLEDExistence);
		return((dwLEDExistence & (1 << index)) ? TRUE : FALSE);
	};
	BOOL HasVGA90FPSFunction(void)
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_VGA90FPS, &bReval);
		return(bReval);
	};
	INT CDSGainType()
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_CDS_GAIN_TYPE, &bReval);
		INT nType = 0;
		if(bReval)
		{
			nType = 1;
		}
		return(nType);
	};
	BOOL HasMirrorHorizontal()
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_MIRROR_HORIZONTAL, &bReval);
		return(bReval);
	};
	BOOL HasMirrorVertical()
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_MIRROR_VERTICAL, &bReval);
		return(bReval);
	};
	BOOL HasVBlankForFPS()
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_V_BLANK_FOR_FPS, &bReval);
		return(bReval);
	};
	BOOL HasReadOut()
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_DISABLED_READOUT, &bReval);
		return(!bReval);
	};

	DWORD GetSupportedCMOSResetType()
	{
		DWORD value = 0;
		DWORD pdwID[] = {
				STCAM_CAMERA_FUNCTION_CMOS_RESET_TYPE_0,
				STCAM_CAMERA_FUNCTION_CMOS_RESET_TYPE_1
			};
		DWORD dwMask = 1;
		for(int i = 0; i < sizeof(pdwID) / sizeof(DWORD); i++)
		{
			BOOL has = FALSE;
			StTrg_HasFunction(m_hCamera, pdwID[i], &has);
			if(has)
			{
				value |= dwMask;
			}
			dwMask <<= 1;
		}
		return(value);
	};
	BOOL HasTriggerValidOutput()
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_TRIGGER_VALID_OUT, &bReval);
		return(bReval);
	};
	BOOL HasAE()
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_AE, &bReval);
		return(bReval);
	};
	BOOL HasAGC()
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_AGC, &bReval);
		return(bReval);
	};
	BOOL HasStoreCameraSetting()
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_STORE_CAMERA_SETTING, &bReval);
		return(bReval);
	};
	BOOL HasCameraMemoryFunction()
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_MEMORY, &bReval);
		if(bReval)
		{
			StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_DISABLE_MEMORY_TYPE_SELECTION, &bReval);
			bReval = !bReval;
		}
		return(bReval);
	};
	BOOL HasCameraGamma()
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_CAMERA_GAMMA, &bReval);
		return(bReval);
	};
	BOOL HasHBinningSum()
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_H_BINNING_SUM, &bReval);
		return(bReval);
	};
	BOOL HasVBinningSum()
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_V_BINNING_SUM, &bReval);
		return(bReval);
	};
	BOOL HasExposureStartWaitHD()
	{
		BOOL bReval = FALSE;
		if(HasTriggerFunction())
		{
			StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_DISABLE_EXPOSURE_START_WAIT_HD, &bReval);
			bReval = !bReval;
		}
		return(bReval);
	};
	BOOL HasExposureStartWaitReadOut()
	{
		BOOL bReval = FALSE;
		if(HasTriggerFunction())
		{
			StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_DISABLE_EXPOSURE_START_WAIT_READ_OUT, &bReval);
			bReval = !bReval;
		}
		return(bReval);
	};
	BOOL HasDigitalClamp()
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_DIGITAL_CLAMP, &bReval);
		return(bReval);
	};
	BOOL IsIOUnitUs()
	{
		BOOL bReval = FALSE;
		StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_IO_UNIT_US, &bReval);
		return(bReval);
	};
	BOOL IsSupportedTransferBitsPerPixel(DWORD dwTransferBitsPerPixel)
	{
		return((m_dwEnableTranderBitsPerPixel & dwTransferBitsPerPixel)?TRUE:FALSE);
	};
	BOOL IsSupportedScanMode(WORD wScanMode)
	{
		return((m_wEnableScanMode & wScanMode)?TRUE:FALSE);
	};
	BOOL IsSupportedClockMode(DWORD dwClockMode)
	{
		return((m_dwEnableCloclMode & dwClockMode)?TRUE:FALSE);
	};
	WORD GetProductID()
	{
		return(m_wUSBProductID);
	};
	DWORD	MaximumImageWidth()
	{
		return(m_dwMaximumImageWidth);
	};
	DWORD	MaximumImageHeight()
	{
		return(m_dwMaximumImageHeight);
	};
	DWORD	GetMaxVBlankForFPS()
	{
		return(m_dwMaxVBlankForFPS);
	};
	
	HANDLE	m_hCamera;

	//Setting
	BYTE	m_byteColorInterpolationMethod;
	DWORD	m_dwPixelFormat;
	DWORD	m_dwTriggerMode;
	BOOL	m_bAutoTrigger;
	DWORD	m_dwNoiseReductionMode;
	BYTE	m_byteMirrorMode;
	BYTE	m_byteRotationMode;

	//SDK Version
	DWORD	m_dwFileVersionMS;
	DWORD	m_dwFileVersionLS;
	DWORD	m_dwProductVersionMS;
	DWORD	m_dwProductVersionLS;

	//Camera Info
	WORD	m_wUSBVendorID;
	WORD	m_wUSBProductID;
	WORD	m_wFPGAVersion;
	WORD	m_wFirmVersion;
	WORD	m_wColorArray;
	DWORD	m_dwCameraNo;
	TCHAR	m_szCameraName[250 / sizeof(TCHAR)];
#ifdef _DEBUG
	//Debug
	DWORD	m_dwLastStartTriggerTime;
#endif //_DEBUG
protected:
	virtual void ExposureEndCallback(HANDLE hCamera, DWORD dwFrameNo) = 0;
	virtual void TransferEndCallback(HANDLE hCamera, DWORD dwFrameNo, DWORD dwWidth, DWORD dwHeight, WORD wColorArray, PBYTE pbyteRaw) = 0;
	virtual void RcvErrorCallback(HANDLE hCamera, DWORD dwErrorCode) = 0;
protected:
	DWORD	m_dwEnableTranderBitsPerPixel;
	WORD	m_wEnableScanMode;
	DWORD	m_dwEnableCloclMode;
	DWORD	m_dwMaximumImageWidth;
	DWORD	m_dwMaximumImageHeight;
	DWORD	m_dwMaxVBlankForFPS;
};

#endif // !defined(AFX_STCAMERA_H__EADFB89B_7118_42CE_8239_B97FCDC34FC0__INCLUDED_)
