// StTrgDisplayDoc.cpp
//

#include "stdafx.h"
#include "StTrgDisplay.h"

#include "StTrgDisplayDoc.h"

#include "CameraSelectDlg.h"
#include "MainFrm.h"	//for Update Status Bar
#include "InputCameraIDDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStTrgDisplayDoc

IMPLEMENT_DYNCREATE(CStTrgDisplayDoc, CDocument)

BEGIN_MESSAGE_MAP(CStTrgDisplayDoc, CDocument)
	//{{AFX_MSG_MAP(CStTrgDisplayDoc)
	ON_COMMAND(ID_FILE_SAVE_BMP, OnFileSaveBmp)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_BMP, OnUpdateFileSaveBmp)
	ON_COMMAND(ID_MODE_SOFT_TRIGGER, OnModeSoftTrigger)
	ON_UPDATE_COMMAND_UI(ID_MODE_SOFT_TRIGGER, OnUpdateModeSoftTrigger)
	ON_COMMAND(ID_MODE_READOUT, OnModeReadout)
	ON_UPDATE_COMMAND_UI(ID_MODE_READOUT, OnUpdateModeReadout)
	ON_COMMAND(ID_MODE_SETTING, OnModeSetting)
	ON_COMMAND(ID_MODE_CAMERA_ID, OnModeCameraId)
	ON_COMMAND(ID_MODE_SOFT_SUB_TRIGGER, OnModeSoftSubTrigger)
	ON_UPDATE_COMMAND_UI(ID_MODE_SOFT_SUB_TRIGGER, OnUpdateModeSoftSubTrigger)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStTrgDisplayDoc

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
CStTrgDisplayDoc::CStTrgDisplayDoc():
	m_hBGRMutex(NULL), m_dwBGRFrameNo(0), m_dwBGRWidth(0), m_dwBGRHeight(0), m_dwBGRPixelFormat(0), m_pbyteBGRData(NULL), 	//For BGR Data
	m_pImageView(NULL),
	m_bTransferFg(FALSE),
	m_hSettingDlg(NULL),
	m_pbyte8BitsRawData(NULL), m_dw8BitsRawImageSize(0), m_dwALCSkipCount(0)
{
	//For BGR Data
	m_hBGRMutex = CreateMutex(NULL, FALSE, NULL);

	//For FPS
	m_pobjFPS = new CFPS(100);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
CStTrgDisplayDoc::~CStTrgDisplayDoc()
{
	//For BGR Data
	if(NULL != m_hBGRMutex)
	{
		CloseHandle(m_hBGRMutex);
		m_hBGRMutex = NULL;
	}
	//For FPS
	if(NULL != m_pobjFPS)
	{
		delete m_pobjFPS;
		m_pobjFPS = NULL;
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStTrgDisplayDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	CCameraSelectDlg dlg;
	dlg.DoModal();
	HANDLE hCamera = dlg.m_hCamera;

	if(INVALID_HANDLE_VALUE == hCamera)
	{
		AfxMessageBox(TEXT("Couldn't open a USB Camera."), MB_ICONEXCLAMATION);
		return FALSE;
	}

	m_hCamera = hCamera;
	BOOL bReval = TRUE;
	
	do{
		//Counter
		m_dwReceiveCount = 0;
		m_dwDropCount = 0;

		bReval = InitializeCameraInfo();
		if(!bReval) break;


		UpdateDocTitle();


		bReval = StartTransfer();
		if(!bReval) break;

		m_bTransferFg = TRUE;
	}while(0);

	if(!bReval)
	{
		StTrg_Close(m_hCamera);
		m_hCamera = NULL;
		AfxMessageBox(TEXT("Error occurred while initializing."), MB_ICONEXCLAMATION);
		return FALSE;
	}
	
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CStTrgDisplayDoc

void CStTrgDisplayDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
	}
	else
	{
	}
}

/////////////////////////////////////////////////////////////////////////////
// CStTrgDisplayDoc

#ifdef _DEBUG
void CStTrgDisplayDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CStTrgDisplayDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CStTrgDisplayDoc

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::DeleteContents() 
{
	if(NULL != m_hSettingDlg)
	{
		m_hSettingDlg->m_pImageView = NULL;
		m_hSettingDlg->DestroyWindow();
		m_hSettingDlg = NULL;
	}

	if(NULL != m_hCamera)
	{
		StTrg_Close(m_hCamera);
		m_hCamera = NULL;
	}
	



	//For BGR Data
	WaitForSingleObject(m_hBGRMutex, INFINITE);
	if(NULL != m_pbyteBGRData)
	{
		delete[] m_pbyteBGRData;
	}
	m_dwBGRFrameNo = 0;
	m_dwBGRWidth = 0;
	m_dwBGRHeight = 0;
	m_dwBGRPixelFormat = 0;
	m_pbyteBGRData = NULL;
	ReleaseMutex(m_hBGRMutex);
	
	if(NULL != m_pbyte8BitsRawData)
	{
		delete[] m_pbyte8BitsRawData;
		m_pbyte8BitsRawData = NULL;
	}
	m_dw8BitsRawImageSize = 0;

	CDocument::DeleteContents();
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void	CStTrgDisplayDoc::GetImageSize(SIZE *psizeImage)
{
	WaitForSingleObject(m_hBGRMutex, INFINITE);
	psizeImage->cx = m_dwBGRWidth;
	psizeImage->cy = m_dwBGRHeight;
	ReleaseMutex(m_hBGRMutex);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void	CStTrgDisplayDoc::Draw(HDC hDC, CRect *pRect)
{
	if(NULL != m_hCamera)
	{
		WaitForSingleObject(m_hBGRMutex, INFINITE);
		if(NULL != m_pbyteBGRData)
		{
			StTrg_Draw(m_hCamera, hDC, 
				pRect->left, pRect->top, pRect->Width(), pRect->Height(),
				pRect->left, pRect->top, pRect->Width(), pRect->Height(),
				m_dwBGRWidth, m_dwBGRHeight, m_pbyteBGRData, m_dwBGRPixelFormat);
		}
		ReleaseMutex(m_hBGRMutex);
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::TransferEndCallback(HANDLE hCamera, DWORD dwFrameNo, DWORD dwWidth, DWORD dwHeight, WORD wColorArray, PBYTE pbyteRaw)
{

	DWORD	dwPixelFormat = m_dwPixelFormat;
	WaitForSingleObject(m_hBGRMutex, INFINITE);
	if(
		(dwWidth != m_dwBGRWidth) ||
		(dwHeight != m_dwBGRHeight) ||
		(dwPixelFormat != m_dwBGRPixelFormat)
	)
	{
		if(NULL != m_pbyteBGRData)
		{
			delete[] m_pbyteBGRData;
		}

		DWORD dwBufferSize = dwWidth * dwHeight;
		switch(dwPixelFormat)
		{
		case(STCAM_PIXEL_FORMAT_24_BGR):
			dwBufferSize *= 3;
			break;
		case(STCAM_PIXEL_FORMAT_32_BGR):
			dwBufferSize *= 4;
			break;
		}
		m_pbyteBGRData = new BYTE[dwBufferSize];
		if(NULL == m_pbyteBGRData)
		{
			m_dwBGRWidth = 0;
			m_dwBGRHeight = 0;
			m_dwBGRPixelFormat = 0;
		}
		else
		{
			m_dwBGRWidth = dwWidth;
			m_dwBGRHeight = dwHeight;
			m_dwBGRPixelFormat = dwPixelFormat;
		}
	}

	DWORD	dwTransferBitsPerPixel = STCAM_TRANSFER_BITS_PER_PIXEL_08;
	StTrg_GetTransferBitsPerPixel(hCamera, &dwTransferBitsPerPixel);
	if(
		(STCAM_TRANSFER_BITS_PER_PIXEL_BGR_08 == dwTransferBitsPerPixel) ||
		(STCAM_TRANSFER_BITS_PER_PIXEL_BGR_10 == dwTransferBitsPerPixel)
	)
	{
		//BGR8,10->dwPixelFormat
		StTrg_ConvYUVOrBGRToBGRImage(dwWidth, dwHeight, dwTransferBitsPerPixel, pbyteRaw, dwPixelFormat, m_pbyteBGRData);
	}
	else
	{
		//Raw or MONO		
		if(
			(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10 == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12 == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_14 == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_16 == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_10 == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_12 == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_14 == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_16 == dwTransferBitsPerPixel)
		)
		{
			//16bits->8bits
			DWORD dw8BitsRawImageSize = dwWidth * dwHeight * 2;
			if(m_dw8BitsRawImageSize != dw8BitsRawImageSize)
			{
				if(NULL != m_pbyte8BitsRawData)
				{
					delete[] m_pbyte8BitsRawData;
					m_pbyte8BitsRawData = NULL;
					m_dw8BitsRawImageSize = 0;
				}
				m_pbyte8BitsRawData = new BYTE[dw8BitsRawImageSize];
				if(NULL != m_pbyte8BitsRawData)
				{
					m_dw8BitsRawImageSize = dw8BitsRawImageSize;
				}
			}
			if(NULL != m_pbyte8BitsRawData)
			{
				StTrg_ConvTo8BitsImage(dwWidth, dwHeight, dwTransferBitsPerPixel, (PWORD)pbyteRaw, m_pbyte8BitsRawData);
				pbyteRaw = m_pbyte8BitsRawData;

				if(
					(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10 == dwTransferBitsPerPixel) ||
					(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12 == dwTransferBitsPerPixel) ||
					(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_14 == dwTransferBitsPerPixel) ||
					(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_16 == dwTransferBitsPerPixel)
				)
				{
					dwTransferBitsPerPixel = STCAM_TRANSFER_BITS_PER_PIXEL_MONO_08;
				}
				else
				{
					dwTransferBitsPerPixel = STCAM_TRANSFER_BITS_PER_PIXEL_RAW_08;
				}
			}
		}
		if(dwTransferBitsPerPixel == STCAM_TRANSFER_BITS_PER_PIXEL_MONO_08)
		{
			wColorArray = STCAM_COLOR_ARRAY_MONO;
		}

		//PC Side ALC
		if((!HasAE()) && (!HasAGC()))
		{
			if(0 < m_dwALCSkipCount)
			{
				m_dwALCSkipCount--;
			}
			else
			{
				BYTE byteALCMode = STCAM_ALCMODE_OFF;
				StTrg_GetALCMode(hCamera, &byteALCMode);

				if(byteALCMode != STCAM_ALCMODE_OFF)
				{
					float	pfAverage[4];
					StTrg_GetAveragePixelValue(dwWidth, dwHeight, wColorArray, STCAM_TRANSFER_BITS_PER_PIXEL_RAW_08, pbyteRaw, 0, 0, dwWidth, dwHeight, pfAverage);

					WORD	wAverage = 0;
					if(STCAM_COLOR_ARRAY_MONO == wColorArray)
					{
						wAverage = (WORD)pfAverage[0];	//B/W
					}
					else
					{
						wAverage = (WORD)((pfAverage[1] + pfAverage[2]) / 2);	//(Gr + Gb) / 2
					}
					DWORD	dwALCStatus = 0;
					StTrg_ALC(hCamera, wAverage, &dwALCStatus);

					if(dwALCStatus & 0x03)
					{
						if(STCAM_TRIGGER_MODE_TYPE_FREE_RUN == (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK))
						{
							m_dwALCSkipCount = 5;
						}
					}

				}
			}
		}


		BYTE	byteColorInterpolationMethod = m_byteColorInterpolationMethod;

		if(dwTransferBitsPerPixel != STCAM_TRANSFER_BITS_PER_PIXEL_MONO_08)
		{
			if(
				(STCAM_TRIGGER_MODE_TYPE_FREE_RUN != (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK)) &&
				(STCAM_TRIGGER_MODE_EXPTIME_EDGE_PRESET != (m_dwTriggerMode & STCAM_TRIGGER_MODE_EXPTIME_MASK))
			)
			{
				//Noise Reduction
				StTrg_NoiseReduction(hCamera, m_dwNoiseReductionMode, dwWidth, dwHeight, wColorArray, pbyteRaw);
			}
		}
		if(NULL != m_pbyteBGRData)
		{
			m_dwBGRFrameNo = dwFrameNo;

			if(dwTransferBitsPerPixel != STCAM_TRANSFER_BITS_PER_PIXEL_MONO_08)
			{
				if(STCAM_COLOR_ARRAY_MONO != wColorArray)
				{
					//WhiteBalance
					StTrg_WhiteBalance(hCamera, pbyteRaw);
				
					//Color Gamma
					StTrg_RawColorGamma(hCamera, dwWidth, dwHeight, wColorArray, pbyteRaw);
				}
			}
			

			//Mirror Rotation
			StTrg_MirrorRotation(m_byteMirrorMode, m_byteRotationMode, &dwWidth, &dwHeight, &wColorArray, pbyteRaw);
			m_dwBGRWidth = dwWidth;
			m_dwBGRHeight = dwHeight;

			//Color Interpolation
			StTrg_ColorInterpolation(dwWidth, dwHeight, wColorArray, pbyteRaw, m_pbyteBGRData, byteColorInterpolationMethod, dwPixelFormat);
				
			//Gamma
			StTrg_BGRGamma(hCamera, dwWidth, dwHeight, dwPixelFormat, m_pbyteBGRData);

			if(STCAM_COLOR_ARRAY_MONO != wColorArray)
			{
				//HueSaturationColorMatrix
				StTrg_HueSaturationColorMatrix(hCamera, dwWidth, dwHeight, dwPixelFormat, m_pbyteBGRData);
			}

			//Sharpness
			StTrg_Sharpness(hCamera, dwWidth, dwHeight, dwPixelFormat, m_pbyteBGRData);

		}
	}
	ReleaseMutex(m_hBGRMutex);
	
	if(NULL != m_pImageView)
	{
		m_pImageView->Invalidate(FALSE);
	}

	//Counter
	m_dwReceiveCount++;

	m_pobjFPS->Rcv();

	//Post Message
	if(NULL != m_pImageView)
	{
		PostMessage(m_pImageView->GetSafeHwnd(), WM_APP_TRANSFER_END, (WPARAM)hCamera, (LPARAM)dwFrameNo);
	}
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::ExposureEndCallback(HANDLE hCamera, DWORD dwFrameNo)
{
/*
if(NULL != m_hCamera)
{
	StTrg_SoftTrigger(m_hCamera);
}
*/

	//Post Message
	if(NULL != m_pImageView)
	{
		PostMessage(m_pImageView->GetSafeHwnd(), WM_APP_EXPOSURE_END, (WPARAM)hCamera, (LPARAM)dwFrameNo);
	}	
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::RcvErrorCallback(HANDLE hCamera, DWORD dwErrorCode)
{
	//Counter
	if(
		(ERR_EXPOSURE_END_DROPPED == dwErrorCode) ||
		(ERR_IMAGE_DATA_DROPPED == dwErrorCode)
	)
	{
		m_dwDropCount++;	
	}

	//Access Denied
	if(ERROR_ACCESS_DENIED == dwErrorCode)
	{
		m_bTransferFg = FALSE;
	}
	
	//Post Message
	if(NULL != m_pImageView)
	{
		PostMessage(m_pImageView->GetSafeHwnd(), WM_APP_RCV_ERROR, (WPARAM)hCamera, (LPARAM)dwErrorCode);
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnFileSaveBmp() 
{
	DWORD dwJpegQuality = 0;
	WaitForSingleObject(m_hBGRMutex, INFINITE);
	if(NULL != m_pbyteBGRData)
	{
		CFileDialog dlg(FALSE, TEXT("bmp"), TEXT(""), OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
			TEXT("Bitmap(*.bmp)|*.bmp|Tiff(*.tif)|*.tif|JPEG(*.jpg)|*.jpg|All Files(*.*)|*.*||"), NULL);
		if(IDOK == dlg.DoModal())
		{
			StTrg_SaveImage(m_dwBGRWidth, m_dwBGRHeight, m_dwBGRPixelFormat, m_pbyteBGRData, dlg.GetPathName(), dwJpegQuality);
		}
	}
	ReleaseMutex(m_hBGRMutex);	
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnUpdateFileSaveBmp(CCmdUI* pCmdUI) 
{
	BOOL	bEnabled = FALSE;
	WaitForSingleObject(m_hBGRMutex, INFINITE);
	if(NULL != m_pbyteBGRData)
	{
		bEnabled = TRUE;
	}
	ReleaseMutex(m_hBGRMutex);	
	pCmdUI->Enable(bEnabled);	
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnModeSoftTrigger() 
{
	BOOL bReval = TRUE;
	if(NULL != m_hCamera)
	{
		bReval = SoftTrigger();
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnUpdateModeSoftTrigger(CCmdUI* pCmdUI) 
{
	BOOL	bEnabled = FALSE;
	
	do{

		if(STCAM_TRIGGER_MODE_TYPE_FREE_RUN != (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK))
		{
			if(STCAM_TRIGGER_MODE_SOURCE_SOFTWARE == (m_dwTriggerMode & STCAM_TRIGGER_MODE_SOURCE_MASK))
			{
				bEnabled = TRUE;
			}
		}
	}while(0);

	pCmdUI->Enable(bEnabled);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnModeSoftSubTrigger() 
{
	BOOL bReval = TRUE;
	if(NULL != m_hCamera)
	{
		bReval = StTrg_SoftSubTrigger(m_hCamera);
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnUpdateModeSoftSubTrigger(CCmdUI* pCmdUI) 
{

	BOOL	bEnabled = FALSE;
	
	do{

		if(STCAM_TRIGGER_MODE_TYPE_FREE_RUN != (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK))
		{
			if(
				(STCAM_TRIGGER_MODE_SOURCE_SOFTWARE == (m_dwTriggerMode & STCAM_TRIGGER_MODE_SOURCE_MASK)) &&
				(STCAM_TRIGGER_MODE_EXPTIME_START_STOP == (m_dwTriggerMode & STCAM_TRIGGER_MODE_EXPTIME_MASK)) &&
				(!m_bAutoTrigger)
			)
			{
				bEnabled = TRUE;
			}
		}
	}while(0);

	pCmdUI->Enable(bEnabled);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnModeReadout() 
{
	BOOL bReval = TRUE;
	if(NULL != m_hCamera)
	{
		bReval = StTrg_TriggerReadOut(m_hCamera);
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnUpdateModeReadout(CCmdUI* pCmdUI) 
{
	BOOL	bEnabled = FALSE;
	
	do{
		if(STCAM_TRIGGER_MODE_TYPE_TRIGGER_RO == (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK))
		{
			if(STCAM_TRIGGER_MODE_READOUT_SOFTWARE == (m_dwTriggerMode & STCAM_TRIGGER_MODE_READOUT_SOURCE_MASK))
			{
				bEnabled = TRUE;
			}
		}
	}while(0);

	pCmdUI->Enable(bEnabled);	
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::GetStatusInfo(PSSTATUS_INFO pStatusInfo)
{
	pStatusInfo->dblFPS = m_pobjFPS->GetFPS();
	pStatusInfo->dwFrameNo = m_dwBGRFrameNo;
	pStatusInfo->dwRcvCount = m_dwReceiveCount;
	pStatusInfo->dwDropCount = m_dwDropCount;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnModeSetting() 
{
	if(NULL != m_hSettingDlg)
	{
		m_hSettingDlg->SetFocus();
	}
	else
	{
		m_hSettingDlg = new CTabParentDlg;
		m_hSettingDlg->m_pImageView = m_pImageView;
		m_hSettingDlg->m_pStCamera = (CStCamera*)this;

		m_hSettingDlg->m_hCamera = m_hCamera;

		m_hSettingDlg->Create(IDD_TAB_PARENT_DIALOG, CWnd::GetDesktopWindow());
		m_hSettingDlg->ShowWindow(SW_SHOW);
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnModeCameraId() 
{
	CInputCameraIDDlg	dlg;
	BOOL bReval = TRUE;
	dlg.m_szCameraName = m_szCameraName;
	dlg.m_dwCameraNumber = m_dwCameraNo;
	if(IDOK == dlg.DoModal())
	{
		_tcscpy(m_szCameraName, dlg.m_szCameraName.GetBuffer(250));
		dlg.m_szCameraName.ReleaseBuffer();
		m_dwCameraNo = dlg.m_dwCameraNumber;
		do{
			bReval = StTrg_WriteCameraUserID(m_hCamera, m_dwCameraNo, m_szCameraName, sizeof(m_szCameraName));
			if(!bReval) break;

			bReval = StTrg_ReadCameraUserID(m_hCamera, &m_dwCameraNo, m_szCameraName, sizeof(m_szCameraName));
			if(!bReval) break;
		}while(0);
		UpdateDocTitle();
	}
}
