// StTrgDisplayDoc.h
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_STTRGDISPLAYDOC_H__57B23045_BB29_478C_95C7_03D21F3F601B__INCLUDED_)
#define AFX_STTRGDISPLAYDOC_H__57B23045_BB29_478C_95C7_03D21F3F601B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "FPS.h"
#include "TabParentDlg.h"
#include "StCamera.h"

typedef struct _SSTATUS_INFO
{
	DWORD	dwFrameNo;
	DWORD	dwRcvCount;
	DWORD	dwDropCount;
	double	dblFPS;
}SSTATUS_INFO, *PSSTATUS_INFO;

class CStTrgDisplayDoc : public CDocument, CStCamera
{
protected:
	CStTrgDisplayDoc();
	DECLARE_DYNCREATE(CStTrgDisplayDoc)

public:

public:

	//{{AFX_VIRTUAL(CStTrgDisplayDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual void DeleteContents();
	//}}AFX_VIRTUAL

public:
	virtual ~CStTrgDisplayDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif


public:
	void	GetImageSize(SIZE *psizeImage);
	void	Draw(HDC hDC, CRect *pRect);
	void GetStatusInfo(PSSTATUS_INFO pStatusInfo);
	CView	*m_pImageView;

	
	CTabParentDlg *m_hSettingDlg;

protected:
	void ExposureEndCallback(HANDLE hCamera, DWORD dwFrameNo);
	void TransferEndCallback(HANDLE hCamera, DWORD dwFrameNo, DWORD dwWidth, DWORD dwHeight, WORD wColorArray, PBYTE pbyteRaw);
	void RcvErrorCallback(HANDLE hCamera, DWORD dwErrorCode);
	void UpdateDocTitle()
	{
		TCHAR szTitle[MAX_PATH * 10];
		_stprintf(szTitle, TEXT("%s[%u]"), m_szCameraName, m_dwCameraNo);
		SetTitle(szTitle);

	};
	CFPS	*m_pobjFPS;



	//For BGR Data
	HANDLE	m_hBGRMutex;
	DWORD	m_dwBGRFrameNo;
	DWORD	m_dwBGRWidth;
	DWORD	m_dwBGRHeight;
	DWORD	m_dwBGRPixelFormat;
	PBYTE	m_pbyteBGRData;

	//Counter
	DWORD	m_dwReceiveCount;
	DWORD	m_dwDropCount;

	//Transfer
	BOOL	m_bTransferFg;
	
	//For 8bits raw image
	DWORD	m_dw8BitsRawImageSize;
	PBYTE	m_pbyte8BitsRawData;

	//ALC
	DWORD	m_dwALCSkipCount;
public:
protected:
	//{{AFX_MSG(CStTrgDisplayDoc)
	afx_msg void OnFileSaveBmp();
	afx_msg void OnUpdateFileSaveBmp(CCmdUI* pCmdUI);
	afx_msg void OnModeSoftTrigger();
	afx_msg void OnUpdateModeSoftTrigger(CCmdUI* pCmdUI);
	afx_msg void OnModeReadout();
	afx_msg void OnUpdateModeReadout(CCmdUI* pCmdUI);
	afx_msg void OnModeSetting();
	afx_msg void OnModeCameraId();
	afx_msg void OnModeSoftSubTrigger();
	afx_msg void OnUpdateModeSoftSubTrigger(CCmdUI* pCmdUI);
	//}}AFX_MSG
	afx_msg void OnUpdateTriggerMode(CCmdUI* pCmdUI);
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}

#endif // !defined(AFX_STTRGDISPLAYDOC_H__57B23045_BB29_478C_95C7_03D21F3F601B__INCLUDED_)
