// StTrgDisplayView.cpp
//

#include "stdafx.h"
#include "StTrgDisplay.h"

#include "StTrgDisplayDoc.h"
#include "StTrgDisplayView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStTrgDisplayView

IMPLEMENT_DYNCREATE(CStTrgDisplayView, CScrollView)

BEGIN_MESSAGE_MAP(CStTrgDisplayView, CScrollView)
	//{{AFX_MSG_MAP(CStTrgDisplayView)
	ON_WM_DESTROY()
	ON_WM_ERASEBKGND()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_APP_EXPOSURE_END, OnExposureEnd)
	ON_MESSAGE(WM_APP_TRANSFER_END, OnTransferEnd)
	ON_MESSAGE(WM_APP_RCV_ERROR, OnRcvError)
	ON_MESSAGE(WM_APP_SETTING_DIALOG_DESTROYED, OnPropertyDialogDestroyed)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStTrgDisplayView

CStTrgDisplayView::CStTrgDisplayView()
{
}

CStTrgDisplayView::~CStTrgDisplayView()
{
}

BOOL CStTrgDisplayView::PreCreateWindow(CREATESTRUCT& cs)
{
	return CScrollView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CStTrgDisplayView
void CStTrgDisplayView::OnDraw(CDC* pDC)
{
	CStTrgDisplayDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	//Update Scroll Size
	int nMapMode = 0;
	SIZE	sizeTotal;
	SIZE	sizePage;
	SIZE	sizeLine;
	GetDeviceScrollSizes(nMapMode, sizeTotal, sizePage, sizeLine);
	SIZE	sizeImage;
	pDoc->GetImageSize(&sizeImage);
	if(
		(MM_TEXT != nMapMode) ||
		(sizeImage.cx != sizeTotal.cx) ||
		(sizeImage.cy != sizeTotal.cy)
	)
	{
		SetScrollSizes(MM_TEXT, sizeImage);
	}

	//Draw Image
	CRect rectImage;
	pDC->GetClipBox(&rectImage);
	pDoc->Draw(pDC->GetSafeHdc(), &rectImage);

	//Draw Background
	CRect rectClient;
	GetClientRect(rectClient);
	CPoint pointScroll = GetScrollPosition();
	rectClient.OffsetRect(pointScroll);

	CRect rectBottomSide(0, sizeImage.cy, sizeImage.cx, rectClient.bottom);
	CRect rectRightSide(sizeImage.cx, 0, rectClient.right, rectClient.bottom);

	if(
		(!rectBottomSide.IsRectEmpty()) ||
		(!rectRightSide.IsRectEmpty())
	)
	{
		//CBrush brushClear(RGB(255, 255, 255));
		CBrush brushClear(HS_DIAGCROSS, RGB(192, 192, 192));
		pDC->FillRect(&rectBottomSide, &brushClear);
		pDC->FillRect(&rectRightSide, &brushClear);
		brushClear.DeleteObject();
	}
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CSize sizeTotal;
	sizeTotal.cx = sizeTotal.cy = 100;
	SetScrollSizes(MM_TEXT, sizeTotal);

	CStTrgDisplayDoc* pDoc = GetDocument();
	pDoc->m_pImageView = this;
}

/////////////////////////////////////////////////////////////////////////////
// CStTrgDisplayView

#ifdef _DEBUG
void CStTrgDisplayView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CStTrgDisplayView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CStTrgDisplayDoc* CStTrgDisplayView::GetDocument()
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CStTrgDisplayDoc)));
	return (CStTrgDisplayDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CStTrgDisplayView

void CStTrgDisplayView::OnDestroy() 
{
	CScrollView::OnDestroy();
	
	CStTrgDisplayDoc* pDoc = GetDocument();
	pDoc->m_pImageView = NULL;
	
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
LRESULT CStTrgDisplayView::OnExposureEnd(WPARAM, LPARAM)
{
	UpdateStatusBar();
	return(0);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
LRESULT CStTrgDisplayView::OnTransferEnd(WPARAM, LPARAM)
{
	UpdateStatusBar();
	return(0);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
LRESULT CStTrgDisplayView::OnRcvError(WPARAM, LPARAM)
{
	UpdateStatusBar();
	return(0);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayView::UpdateStatusBar()
{
	CStTrgDisplayDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	SSTATUS_INFO	sStatusInfo = {0};
	pDoc->GetStatusInfo(&sStatusInfo);

	CStatusBar	*pStatusBar = (CStatusBar*)((CFrameWnd*)AfxGetMainWnd())->GetMessageBar();

	CString string;
	
	string.Format(TEXT("%.1f FPS"), sStatusInfo.dblFPS);
	pStatusBar->SetPaneText(1, string);
	
	string.Format(TEXT("No. %u"), sStatusInfo.dwFrameNo);
	pStatusBar->SetPaneText(2, string);
	
	string.Format(TEXT("RCV %u"), sStatusInfo.dwRcvCount);
	pStatusBar->SetPaneText(3, string);
	
	string.Format(TEXT("DROP %u"), sStatusInfo.dwDropCount);
	pStatusBar->SetPaneText(4, string);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
LRESULT CStTrgDisplayView::OnPropertyDialogDestroyed(WPARAM wParam, LPARAM lParam)
{
	CStTrgDisplayDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	pDoc->m_hSettingDlg = NULL;

	return 0;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStTrgDisplayView::OnEraseBkgnd(CDC* pDC) 
{
	//Don't Erase Background
	return TRUE;
}
