// TabParentDlg.cpp
//

#include "stdafx.h"
#include "StTrgDisplay.h"
#include "TabParentDlg.h"

#include "TabShutterGainDlg.h"
#include "TabIODlg.h"
#include "TabOtherDlg.h"
#include "TabWBDlg.h"
#include "TabYDlg.h"
#include "TabTriggerModeDlg.h"
#include "TabTriggerTimingDlg.h"
#include "TabColorGammaDlg.h"
#include "TabEEPROMDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

typedef struct _S_NAME_AND_DWORD
{
	PCTSTR szName;
	DWORD dwValue;
}S_NAME_AND_DWORD, *PS_NAME_AND_DWORD;

/////////////////////////////////////////////////////////////////////////////
// CTabParentDlg
CTabParentDlg::CTabParentDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTabParentDlg::IDD, pParent),
	m_dwListCount(0), m_hCamera(NULL), m_pStCamera(NULL)
	, m_byteHSkipping(0), m_byteVSkipping(0), m_byteHBinning(0), m_byteVBinning(0),
	m_dwVBlankForFPS(0), 
	m_byteALCMode(0), m_wALCTargetLevel(128), 
	m_dwAEMaxExposureClock(0), m_dwAEMinExposureClock(1), 
	m_wMaxGain(255), m_wAGCMaxGain(255), m_wAGCMinGain(0),
	m_wBinningSumMode(0), m_wCameraGamma(0), m_wDigitalClamp(0)
	
{
	//{{AFX_DATA_INIT(CTabParentDlg)
	//}}AFX_DATA_INIT
	for(DWORD dwPos = 0; dwPos < MAX_TAB_COUNT; dwPos++)
	{
		m_ppTabList[dwPos] = 0;
	}
}

void CTabParentDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTabParentDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTabParentDlg, CDialog)
	//{{AFX_MSG_MAP(CTabParentDlg)
	ON_WM_DESTROY()
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB, OnSelchangeTab)
	ON_NOTIFY(TCN_SELCHANGING, IDC_TAB, OnSelchangingTab)
	ON_BN_CLICKED(IDC_BUTTON_REFRESH, OnButtonRefresh)
	//}}AFX_MSG_MAP
	ON_CONTROL_RANGE(BN_CLICKED, IDC_BUTTON_SAVE_SETTING, IDC_BUTTON_LOAD_SETTING, OnButtonSettingFile)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTabParentDlg
/////////////////////////////////////////////////////////////////////////////
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CTabParentDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	ReadCameraProperty();

	CreateTabs();

	return TRUE;
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CTabParentDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	for(DWORD dwPos = 0; dwPos < m_dwListCount; dwPos++)
	{
		m_ppTabList[dwPos]->DestroyWindow();
		delete m_ppTabList[dwPos];
	}
	m_dwListCount = 0;	
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CTabParentDlg::CreateTabs(void)
{
	DWORD dwIndex = 0;

	m_ppTabList[dwIndex++] = new CTabShutterGainDlg();
	if(STCAM_COLOR_ARRAY_MONO != m_pStCamera->m_wColorArray)
	{
		m_ppTabList[dwIndex++] = new CTabWBDlg();
	}
	m_ppTabList[dwIndex++] = new CTabYDlg();

	if(STCAM_COLOR_ARRAY_MONO != m_pStCamera->m_wColorArray)
	{
		m_ppTabList[dwIndex++] = new CTabColorGammaDlg();
	}

	if(m_pStCamera->HasTriggerFunction())
	{
		m_ppTabList[dwIndex++] = new CTabTriggerModeDlg();
		m_ppTabList[dwIndex++] = new CTabTriggerTimingDlg();
		m_ppTabList[dwIndex++] = new CTabIODlg();
	}

	if(m_pStCamera->HasStoreCameraSetting())
	{
		m_ppTabList[dwIndex++] = new CTabEEPROMDlg();
	}

	m_ppTabList[dwIndex++] = new CTabOtherDlg();
	m_dwListCount = dwIndex;

	CTabCtrl	objTabCtrl;
	objTabCtrl.Attach(GetDlgItem(IDC_TAB)->GetSafeHwnd());

	for(DWORD dwPos = 0; dwPos < m_dwListCount; dwPos++)
	{
		m_ppTabList[dwPos]->Create(m_ppTabList[dwPos]->m_DlgID, &objTabCtrl);

		TC_ITEM	TabCtrlItem = {0};
		TabCtrlItem.pszText = const_cast<LPTSTR>(m_ppTabList[dwPos]->m_szTabName);
		TabCtrlItem.mask = TCIF_TEXT;
		objTabCtrl.InsertItem(dwPos, &TabCtrlItem);
	}
	objTabCtrl.Detach();

	ShowTab(0, SW_SHOW);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CTabParentDlg::ShowTab(DWORD dwTabNo, int nCmdShow)
{
	if(SW_SHOW == nCmdShow)
	{
		CTabCtrl	objTabCtrl;
		CRect	rectTabClient;

		objTabCtrl.Attach(GetDlgItem(IDC_TAB)->GetSafeHwnd());
		objTabCtrl.GetClientRect(&rectTabClient);
		objTabCtrl.AdjustRect(FALSE, &rectTabClient);
		objTabCtrl.Detach();
		m_ppTabList[dwTabNo]->MoveWindow(rectTabClient.left, rectTabClient.top, rectTabClient.Width(), rectTabClient.Height());

		m_ppTabList[dwTabNo]->ShowWindow(SW_SHOW);
		m_ppTabList[dwTabNo]->UpdateWindow();
		m_ppTabList[dwTabNo]->UpdateDisplay();
	}
	else
	{
		m_ppTabList[dwTabNo]->ShowWindow(nCmdShow);
	}
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CTabParentDlg::OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CTabCtrl	objTabCtrl;
	objTabCtrl.Attach(GetDlgItem(IDC_TAB)->GetSafeHwnd());
	int iCurSel = objTabCtrl.GetCurSel();
	objTabCtrl.Detach();

	if(0 <= iCurSel)
	{
		ShowTab(iCurSel, SW_SHOW);
	}
	*pResult = 0;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CTabParentDlg::OnSelchangingTab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CTabCtrl	objTabCtrl;
	objTabCtrl.Attach(GetDlgItem(IDC_TAB)->GetSafeHwnd());
	int iCurSel = objTabCtrl.GetCurSel();
	objTabCtrl.Detach();

	if(0 <= iCurSel)
	{
		ShowTab(iCurSel, SW_HIDE);
	}
	*pResult = 0;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CTabParentDlg::DisplaySlider(HWND hWnd)
{
	BOOL bReval = TRUE;
	int nID = ::GetDlgCtrlID(hWnd);
	CSliderCtrl	objSliderCtrl;
	objSliderCtrl.Attach(hWnd);
	switch(nID)
	{
	case(IDC_SLIDER_EXPOSURE):
		objSliderCtrl.SetRange(0, GetMaxExposureClock(), TRUE);
		objSliderCtrl.SetPageSize(GetMaxExposureClock() / 100);
		objSliderCtrl.SetPos(m_dwExposureClock);
		objSliderCtrl.EnableWindow(!IsAEOn());
		break;
	case(IDC_SLIDER_CDS_GAIN):
		objSliderCtrl.SetRange(0, m_wMaxGain, TRUE);
		objSliderCtrl.SetPageSize(5);
		objSliderCtrl.SetPos(m_wCDSGain);
		objSliderCtrl.EnableWindow(!IsAGCOn());
		break;
	case(IDC_SLIDER_DIGITAL_GAIN):
		objSliderCtrl.SetRange(64, 256, TRUE);
		objSliderCtrl.SetPageSize(5);
		objSliderCtrl.SetPos(m_wDigitalGain);
		objSliderCtrl.EnableWindow(m_pStCamera->HasDigitalGainFunction());
		break;
	case(IDC_SLIDER_ALC_TARGET_LEVEL):
		objSliderCtrl.SetRange(0, 255, TRUE);
		objSliderCtrl.SetPageSize(5);
		objSliderCtrl.SetPos(m_wALCTargetLevel);
		objSliderCtrl.EnableWindow(m_byteALCMode != STCAM_ALCMODE_OFF);
		break;
	case(IDC_SLIDER_AE_MIN_EXPOSURE):
		objSliderCtrl.SetRange(0, GetMaxExposureClock(), TRUE);
		objSliderCtrl.SetPageSize(GetMaxExposureClock() / 100);
		objSliderCtrl.SetPos(m_dwAEMinExposureClock);
		objSliderCtrl.EnableWindow(IsAEOn());
		break;
	case(IDC_SLIDER_AE_MAX_EXPOSURE):
		objSliderCtrl.SetRange(0, GetMaxExposureClock(), TRUE);
		objSliderCtrl.SetPageSize(GetMaxExposureClock() / 100);
		objSliderCtrl.SetPos(m_dwAEMaxExposureClock);
		objSliderCtrl.EnableWindow(IsAEOn());
		break;
	case(IDC_SLIDER_AGC_MIN_GAIN):
		objSliderCtrl.SetRange(0, m_wMaxGain, TRUE);
		objSliderCtrl.SetPageSize(5);
		objSliderCtrl.SetPos(m_wAGCMinGain);
		objSliderCtrl.EnableWindow(IsAGCOn());
		break;
	case(IDC_SLIDER_AGC_MAX_GAIN):
		objSliderCtrl.SetRange(0, m_wMaxGain, TRUE);
		objSliderCtrl.SetPageSize(5);
		objSliderCtrl.SetPos(m_wAGCMaxGain);
		objSliderCtrl.EnableWindow(IsAGCOn());
		break;

	case(IDC_SLIDER_WB_GAIN_R):
	case(IDC_SLIDER_WB_GAIN_B):
		objSliderCtrl.SetRange(0, 511, TRUE);
		objSliderCtrl.SetPageSize(16);
		objSliderCtrl.SetPos(m_pwWhiteBalanceGain[nID - IDC_SLIDER_WB_GAIN_R]);
		objSliderCtrl.EnableWindow(
			(STCAM_COLOR_ARRAY_MONO != m_pStCamera->m_wColorArray) &&
			(STCAM_WB_MANUAL == m_byteWhiteBalanceMode)
			);
		break;
	case(IDC_SLIDER_WB_GAIN_GR):
	case(IDC_SLIDER_WB_GAIN_GB):
		objSliderCtrl.SetRange(0, 511, TRUE);
		objSliderCtrl.SetPageSize(16);
		objSliderCtrl.SetPos(m_pwWhiteBalanceGain[nID - IDC_SLIDER_WB_GAIN_R]);
		objSliderCtrl.EnableWindow(
			(STCAM_COLOR_ARRAY_MONO != m_pStCamera->m_wColorArray) &&
			(STCAM_WB_OFF != m_byteWhiteBalanceMode)
			);
		break;
	case(IDC_SLIDER_HUE):
		objSliderCtrl.SetRange(-1800, 1800, TRUE);
		objSliderCtrl.SetPageSize(100);
		objSliderCtrl.SetPos(m_shtHue);
		objSliderCtrl.EnableWindow(
			(STCAM_COLOR_ARRAY_MONO != m_pStCamera->m_wColorArray) &&
			(STCAM_HUE_SATURATION_ON == m_byteHueSaturationMode)
			);
		break;
	case(IDC_SLIDER_SATURATION):
		objSliderCtrl.SetRange(0, 200, TRUE);
		objSliderCtrl.SetPageSize(10);
		objSliderCtrl.SetPos(m_wSaturation);
		objSliderCtrl.EnableWindow(
			(STCAM_COLOR_ARRAY_MONO != m_pStCamera->m_wColorArray) &&
			(STCAM_HUE_SATURATION_ON == m_byteHueSaturationMode)
			);
		break;
	case(IDC_SLIDER_TRIGGER_TIMING_EXPOSURE_DELAY):
	case(IDC_SLIDER_TRIGGER_TIMING_STROBE_START_DELAY):
	case(IDC_SLIDER_TRIGGER_TIMING_STROBE_END_DELAY):
	case(IDC_SLIDER_TRIGGER_TIMING_OUTPUT_PULSE_DELAY):
	case(IDC_SLIDER_TRIGGER_TIMING_OUTPUT_PULSE_DURATION):
		if(m_pStCamera->IsIOUnitUs())
		{
			objSliderCtrl.SetRange(0, 0x3FFFF, TRUE);
		}
		else
		{
			objSliderCtrl.SetRange(0, 4094, TRUE);
		}
		objSliderCtrl.SetPageSize(256);
		objSliderCtrl.SetPos(m_pdwTriggerTiming[nID - IDC_SLIDER_TRIGGER_TIMING_EXPOSURE_DELAY]);
		break;
	case(IDC_SLIDER_TRIGGER_TIMING_READOUT_DELAY):
		objSliderCtrl.SetRange(0, 65535, TRUE);
		objSliderCtrl.SetPageSize(16);
		objSliderCtrl.SetPos(m_pdwTriggerTiming[nID - IDC_SLIDER_TRIGGER_TIMING_EXPOSURE_DELAY]);
		objSliderCtrl.EnableWindow(m_pStCamera->HasReadOut());
		break;
	case(IDC_SLIDER_TRIGGER_TIMER_PERIOD):
		if(
			(STCAM_TRIGGER_MODE_TYPE_FREE_RUN != (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK)) &&
			(STCAM_TRIGGER_MODE_SOURCE_SOFTWARE == (m_dwTriggerMode & STCAM_TRIGGER_MODE_SOURCE_MASK)) &&
			(STCAM_TRIGGER_MODE_EXPTIME_START_STOP == (m_dwTriggerMode & STCAM_TRIGGER_MODE_EXPTIME_MASK)) &&
			(m_pStCamera->m_bAutoTrigger)
		)
		{
			UINT Delay, Resolution;
			m_pStCamera->GetPeriod(&Delay, &Resolution);
			objSliderCtrl.SetRange(500, 600000, TRUE);	//500ms - 10min
			objSliderCtrl.SetPageSize(1000);
			objSliderCtrl.SetPos(Delay);
			::EnableWindow(hWnd, TRUE);
		}
		else
		{
			::EnableWindow(hWnd, FALSE);
		}
		break;
	case(IDC_SLIDER_IMAGE_OFFSET_X):
		objSliderCtrl.SetRange(0, m_pStCamera->MaximumImageWidth() - 1, TRUE);
		objSliderCtrl.SetPageSize(128);
		objSliderCtrl.SetPos(m_dwOffsetX);
		objSliderCtrl.EnableWindow(m_wScanMode == STCAM_SCAN_MODE_AOI);
		break;
	case(IDC_SLIDER_IMAGE_OFFSET_Y):
		objSliderCtrl.SetRange(0, m_pStCamera->MaximumImageHeight() - 1, TRUE);
		objSliderCtrl.SetPageSize(128);
		objSliderCtrl.SetPos(m_dwOffsetY);
		objSliderCtrl.EnableWindow((m_wScanMode == STCAM_SCAN_MODE_AOI) || (m_wScanMode == STCAM_SCAN_MODE_BINNING_VARIABLE_PARTIAL) || (m_wScanMode == STCAM_SCAN_MODE_VARIABLE_PARTIAL));
		break;
	case(IDC_SLIDER_IMAGE_WIDTH):
		objSliderCtrl.SetRange(0, m_pStCamera->MaximumImageWidth(), TRUE);
		objSliderCtrl.SetPageSize(128);
		objSliderCtrl.SetPos(m_dwWidth);
		objSliderCtrl.EnableWindow(m_wScanMode == STCAM_SCAN_MODE_AOI);
		break;
	case(IDC_SLIDER_IMAGE_HEIGHT):
		objSliderCtrl.SetRange(0, m_pStCamera->MaximumImageHeight(), TRUE);
		objSliderCtrl.SetPageSize(128);
		objSliderCtrl.SetPos(m_dwHeight);
		objSliderCtrl.EnableWindow((m_wScanMode == STCAM_SCAN_MODE_AOI) || (m_wScanMode == STCAM_SCAN_MODE_BINNING_VARIABLE_PARTIAL) || (m_wScanMode == STCAM_SCAN_MODE_VARIABLE_PARTIAL));
		break;
	case(IDC_SLIDER_V_BLANK_FOR_FPS):
		objSliderCtrl.SetRange(0, m_pStCamera->GetMaxVBlankForFPS(), TRUE);
		objSliderCtrl.SetPageSize(64);
		objSliderCtrl.SetPos(m_dwVBlankForFPS);
		objSliderCtrl.EnableWindow(m_pStCamera->HasVBlankForFPS());
		break;

	case(IDC_SLIDER_SHARPNESS_GAIN):
		objSliderCtrl.SetRange(0, 500, TRUE);
		objSliderCtrl.SetPageSize(10);
		objSliderCtrl.SetPos(m_wSharpnessGain);
		objSliderCtrl.EnableWindow(STCAM_SHARPNESS_OFF != m_byteSharpnessMode);
		break;
	case(IDC_SLIDER_SHARPNESS_CORING):
		objSliderCtrl.SetRange(0, 255, TRUE);
		objSliderCtrl.SetPageSize(5);
		objSliderCtrl.SetPos(m_byteSharpnessCoring);
		objSliderCtrl.EnableWindow(STCAM_SHARPNESS_OFF != m_byteSharpnessMode);
		break;
	case(IDC_SLIDER_Y_GAMMA_VALUE):
	case(IDC_SLIDER_R_GAMMA_VALUE):
	case(IDC_SLIDER_GR_GAMMA_VALUE):
	case(IDC_SLIDER_GB_GAMMA_VALUE):
	case(IDC_SLIDER_B_GAMMA_VALUE):
		objSliderCtrl.SetRange(1, 500, TRUE);
		objSliderCtrl.SetPageSize(10);
		objSliderCtrl.SetPos(m_pwGamma[nID - IDC_SLIDER_Y_GAMMA_VALUE]);
		objSliderCtrl.EnableWindow(STCAM_GAMMA_OFF != m_pbyteGammaMode[nID - IDC_SLIDER_Y_GAMMA_VALUE]);
		break;
	case(IDC_SLIDER_CAMERA_GAMMA_VALUE):
		objSliderCtrl.SetRange(0, 40, TRUE);
		objSliderCtrl.SetPageSize(5);
		objSliderCtrl.SetPos(m_wCameraGamma);
		objSliderCtrl.EnableWindow(m_pStCamera->HasCameraGamma());
		break;
	case(IDC_SLIDER_DIGITAL_CLAMP):
		objSliderCtrl.SetRange(0, 255, TRUE);
		objSliderCtrl.SetPageSize(5);
		objSliderCtrl.SetPos(m_wDigitalClamp);
		objSliderCtrl.EnableWindow(m_pStCamera->HasDigitalClamp());
		break;
	}
	objSliderCtrl.Detach();
	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CTabParentDlg::DisplayStatic(HWND hWnd)
{
	BOOL bReval = TRUE;
	int nID = ::GetDlgCtrlID(hWnd);
	TCHAR	szTmp[1024];
	_tcscpy(szTmp, TEXT(""));
	switch(nID)
	{
	case(IDC_STATIC_EXPOSURE_VALUE):
	case(IDC_STATIC_AE_MIN_EXPOSURE):
	case(IDC_STATIC_AE_MAX_EXPOSURE):
		{
			DWORD	dwExposureClock = m_dwExposureClock;
			float fExpTime = 0;
			switch(nID)
			{
			case(IDC_STATIC_AE_MIN_EXPOSURE):	dwExposureClock = m_dwAEMinExposureClock;	break;
			case(IDC_STATIC_AE_MAX_EXPOSURE):	dwExposureClock = m_dwAEMaxExposureClock;	break;
			}
			bReval = StTrg_GetExposureTimeFromClock(m_hCamera, dwExposureClock, &fExpTime);
			if(fExpTime != 0)
			{
				_stprintf(szTmp, TEXT("1/%.2f s"), 1.0 / fExpTime);
			}
		}
		break;
	case(IDC_STATIC_CDS_GAIN_VALUE):
	case(IDC_STATIC_AGC_MIN_GAIN):
	case(IDC_STATIC_AGC_MAX_GAIN):
		{
			WORD wGain = m_wCDSGain;
			switch(nID)
			{
			case(IDC_STATIC_AGC_MIN_GAIN):	wGain = m_wAGCMinGain;	break;
			case(IDC_STATIC_AGC_MAX_GAIN):	wGain = m_wAGCMaxGain;	break;
			}
			float fValue = 0;
			bReval = StTrg_GetGainDBFromSettingValue(m_hCamera, wGain, &fValue);
			_stprintf(szTmp, TEXT("%.2f dB"), fValue);
		}
		break;
	case(IDC_STATIC_DIGITAL_GAIN_VALUE):
		_stprintf(szTmp, TEXT("x %.2f"), m_wDigitalGain / 64.0);
		break;
	case(IDC_STATIC_WB_GAIN_R):
	case(IDC_STATIC_WB_GAIN_GR):
	case(IDC_STATIC_WB_GAIN_GB):
	case(IDC_STATIC_WB_GAIN_B):
		_stprintf(szTmp, TEXT("x %.2f"), m_pwWhiteBalanceGain[nID - IDC_STATIC_WB_GAIN_R] / 128.0);
		break;
	case(IDC_STATIC_HUE):
		_stprintf(szTmp, TEXT("%.1f"), m_shtHue / 10.0);
		break;
	case(IDC_STATIC_SATURATION):
		_stprintf(szTmp, TEXT("%.2f"), m_wSaturation / 100.0);
		break;
	case(IDC_STATIC_TRIGGER_TIMING_EXPOSURE_DELAY_VALUE):
	case(IDC_STATIC_TRIGGER_TIMING_STROBE_START_DELAY_VALUE):
	case(IDC_STATIC_TRIGGER_TIMING_STROBE_END_DELAY_VALUE):
	case(IDC_STATIC_TRIGGER_TIMING_OUTPUT_PULSE_DELAY_VALUE):
	case(IDC_STATIC_TRIGGER_TIMING_OUTPUT_PULSE_DURATION_VALUE):
	case(IDC_STATIC_TRIGGER_TIMING_READOUT_DELAY_VALUE):
		{
			DWORD dwValue = m_pdwTriggerTiming[nID - IDC_STATIC_TRIGGER_TIMING_EXPOSURE_DELAY_VALUE];
			if(m_pStCamera->IsIOUnitUs())
			{
				_stprintf(szTmp, TEXT("%u us"), dwValue);
			}
			else if(0 == dwValue)
			{
				_tcscpy(szTmp, TEXT("0 ns"));
			}
			else if(IDC_STATIC_TRIGGER_TIMING_READOUT_DELAY_VALUE == nID)
			{
				GetTimeStrFromClock(dwValue * m_wClockPerLine, szTmp);
			}
			else
			{
				GetTimeStrFromClock(dwValue, szTmp);
			}
		}
		break;
	case(IDC_STATIC_TRIGGER_TIMER_PERIOD):
		if(
			(STCAM_TRIGGER_MODE_TYPE_FREE_RUN != (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK)) &&
			(STCAM_TRIGGER_MODE_SOURCE_SOFTWARE == (m_dwTriggerMode & STCAM_TRIGGER_MODE_SOURCE_MASK)) &&
			(STCAM_TRIGGER_MODE_EXPTIME_START_STOP == (m_dwTriggerMode & STCAM_TRIGGER_MODE_EXPTIME_MASK)) &&
			(m_pStCamera->m_bAutoTrigger)
		)
		{
			UINT Delay, Resolution;
			m_pStCamera->GetPeriod(&Delay, &Resolution);

			UINT MSec = Delay;
			UINT Min = Delay / 1000 / 60;
			MSec %= 1000 * 60;
			UINT Sec = MSec / 1000;
			MSec %= 1000;

			if(0 < Min)	_stprintf(szTmp, TEXT("%umin"), Min);
			if(0 < Sec) _stprintf(szTmp, TEXT("%s%us"), szTmp, Sec);
			if(0 < MSec) _stprintf(szTmp, TEXT("%s%ums"), szTmp, MSec);
		}
		break;
	case(IDC_EDIT_CAMERA_TYPE):
		{
			TCHAR szCameraName[MAX_PATH];
			StTrg_GetProductName(m_hCamera, szCameraName, sizeof(szCameraName));
			_tcscpy(szTmp, szCameraName);
		}
		break;
	case(IDC_EDIT_SW_STATUS_1):
	case(IDC_EDIT_SW_STATUS_2):
	case(IDC_EDIT_SW_STATUS_3):
	case(IDC_EDIT_SW_STATUS_4):
		{
			int iSW = nID - IDC_EDIT_SW_STATUS_1;
			DWORD dwMask = 1 << iSW;
			DWORD dwCurValue = m_dwSWStatus & dwMask;
			if(dwCurValue)
			{
				_tcscpy(szTmp, TEXT("High"));
			}
			else
			{
				_tcscpy(szTmp, TEXT("Low"));
			}
		}
		break;
	case(IDC_EDIT_FPGA_VERSION):
		_stprintf(szTmp, TEXT("%04X"), m_pStCamera->m_wFPGAVersion);
		break;
	case(IDC_EDIT_FIRM_VERSION):
		_stprintf(szTmp, TEXT("%04X"), m_pStCamera->m_wFirmVersion);
		break;
	case(IDC_EDIT_SDK_VERSION):
		_stprintf(szTmp, TEXT("%u.%u.%u.%u"), 
			m_pStCamera->m_dwFileVersionMS >> 16,
			m_pStCamera->m_dwFileVersionMS & 0xFFFF, 
			m_pStCamera->m_dwFileVersionLS >> 16,
			m_pStCamera->m_dwFileVersionLS & 0xFFFF);
		break;
	case(IDC_STATIC_V_BLANK_FOR_FPS):
		{
			float fOutputFPS = 0;
			bReval = StTrg_GetOutputFPS(m_hCamera, &fOutputFPS);
			_stprintf(szTmp, TEXT("%.2fFPS"),  fOutputFPS);
		}
		break;
	}
	
	::SetWindowText(hWnd, szTmp);
	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CTabParentDlg::DisplayEdit(HWND hWnd)
{
	BOOL bReval = TRUE;
	int nID = ::GetDlgCtrlID(hWnd);
	TCHAR	szTmp[1024];
	_tcscpy(szTmp, TEXT(""));
	switch(nID)
	{
	case(IDC_EDIT_EXPOSURE):
		{
			DWORD dwMaxExposureClock = GetMaxExposureClock();
			_stprintf(szTmp, TEXT("%u"), (dwMaxExposureClock < m_dwExposureClock)?dwMaxExposureClock:m_dwExposureClock);
			::EnableWindow(hWnd, !IsAEOn());
		}
		break;
	case(IDC_EDIT_CDS_GAIN):
		_stprintf(szTmp, TEXT("%u"), m_wCDSGain);
		::EnableWindow(hWnd, !IsAGCOn());
		break;
	case(IDC_EDIT_DIGITAL_GAIN):
		_stprintf(szTmp, TEXT("%u"), m_wDigitalGain);
		::EnableWindow(hWnd, m_pStCamera->HasDigitalGainFunction());
		break;
	case(IDC_EDIT_ALC_TARGET_LEVEL):
		_stprintf(szTmp, TEXT("%u"), m_wALCTargetLevel);
		::EnableWindow(hWnd, m_byteALCMode != STCAM_ALCMODE_OFF);
		break;
	case(IDC_EDIT_AE_MIN_EXPOSURE):
		_stprintf(szTmp, TEXT("%u"), m_dwAEMinExposureClock);
		::EnableWindow(hWnd, IsAEOn());
		break;
	case(IDC_EDIT_AE_MAX_EXPOSURE):
		_stprintf(szTmp, TEXT("%u"), m_dwAEMaxExposureClock);
		::EnableWindow(hWnd, IsAEOn());
		break;
	case(IDC_EDIT_AGC_MIN_GAIN):
		_stprintf(szTmp, TEXT("%u"), m_wAGCMinGain);
		::EnableWindow(hWnd, IsAGCOn());
		break;
	case(IDC_EDIT_AGC_MAX_GAIN):
		_stprintf(szTmp, TEXT("%u"), m_wAGCMaxGain);
		::EnableWindow(hWnd, IsAGCOn());
		break;
	case(IDC_EDIT_WB_GAIN_R):
	case(IDC_EDIT_WB_GAIN_GR):
	case(IDC_EDIT_WB_GAIN_GB):
	case(IDC_EDIT_WB_GAIN_B):
		_stprintf(szTmp, TEXT("%u"), m_pwWhiteBalanceGain[nID - IDC_EDIT_WB_GAIN_R]);
		::EnableWindow(hWnd, 
			(STCAM_COLOR_ARRAY_MONO != m_pStCamera->m_wColorArray) &&
			(STCAM_WB_MANUAL == m_byteWhiteBalanceMode)
			);
		break;
	case(IDC_EDIT_HUE):
		_stprintf(szTmp, TEXT("%d"), m_shtHue);
		::EnableWindow(hWnd, 
			(STCAM_COLOR_ARRAY_MONO != m_pStCamera->m_wColorArray) &&
			(STCAM_HUE_SATURATION_ON == m_byteHueSaturationMode)
			);
		break;
	case(IDC_EDIT_SATURATION):
		_stprintf(szTmp, TEXT("%u"), m_wSaturation);
		::EnableWindow(hWnd, 
			(STCAM_COLOR_ARRAY_MONO != m_pStCamera->m_wColorArray) &&
			(STCAM_HUE_SATURATION_ON == m_byteHueSaturationMode)
			);
		break;
	case(IDC_EDIT_TRIGGER_TIMING_EXPOSURE_DELAY):
	case(IDC_EDIT_TRIGGER_TIMING_STROBE_START_DELAY):
	case(IDC_EDIT_TRIGGER_TIMING_STROBE_END_DELAY):
	case(IDC_EDIT_TRIGGER_TIMING_OUTPUT_PULSE_DELAY):
	case(IDC_EDIT_TRIGGER_TIMING_OUTPUT_PULSE_DURATION):
		_stprintf(szTmp, TEXT("%u"), m_pdwTriggerTiming[nID - IDC_EDIT_TRIGGER_TIMING_EXPOSURE_DELAY]);
		break;
	case(IDC_EDIT_TRIGGER_TIMING_READOUT_DELAY):
		_stprintf(szTmp, TEXT("%u"), m_pdwTriggerTiming[nID - IDC_EDIT_TRIGGER_TIMING_EXPOSURE_DELAY]);
		::EnableWindow(hWnd, m_pStCamera->HasReadOut());
		break;
	case(IDC_EDIT_TRIGGER_TIMER_PERIOD):
		if(
			(STCAM_TRIGGER_MODE_TYPE_FREE_RUN != (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK)) &&
			(STCAM_TRIGGER_MODE_SOURCE_SOFTWARE == (m_dwTriggerMode & STCAM_TRIGGER_MODE_SOURCE_MASK)) &&
			(STCAM_TRIGGER_MODE_EXPTIME_START_STOP == (m_dwTriggerMode & STCAM_TRIGGER_MODE_EXPTIME_MASK)) &&
			(m_pStCamera->m_bAutoTrigger)
		)
		{
			UINT Delay, Resolution;
			m_pStCamera->GetPeriod(&Delay, &Resolution);
			_stprintf(szTmp, TEXT("%u"), Delay);
			::EnableWindow(hWnd, TRUE);
		}
		else
		{
			::EnableWindow(hWnd, FALSE);
		}
		break;
	case(IDC_EDIT_IMAGE_OFFSET_X):
		_stprintf(szTmp, TEXT("%u"), m_dwOffsetX);
		::EnableWindow(hWnd, m_wScanMode == STCAM_SCAN_MODE_AOI);
		break;
	case(IDC_EDIT_IMAGE_OFFSET_Y):
		_stprintf(szTmp, TEXT("%u"), m_dwOffsetY);
		::EnableWindow(hWnd, (m_wScanMode == STCAM_SCAN_MODE_AOI) || (m_wScanMode == STCAM_SCAN_MODE_BINNING_VARIABLE_PARTIAL) || (m_wScanMode == STCAM_SCAN_MODE_VARIABLE_PARTIAL));
		break;
	case(IDC_EDIT_IMAGE_WIDTH):
		_stprintf(szTmp, TEXT("%u"), m_dwWidth);
		::EnableWindow(hWnd, m_wScanMode == STCAM_SCAN_MODE_AOI);
		break;
	case(IDC_EDIT_IMAGE_HEIGHT):
		_stprintf(szTmp, TEXT("%u"), m_dwHeight);
		::EnableWindow(hWnd, (m_wScanMode == STCAM_SCAN_MODE_AOI) || (m_wScanMode == STCAM_SCAN_MODE_BINNING_VARIABLE_PARTIAL) || (m_wScanMode == STCAM_SCAN_MODE_VARIABLE_PARTIAL));
		break;
	case(IDC_EDIT_V_BLANK_FOR_FPS):
		_stprintf(szTmp, TEXT("%u"), m_dwVBlankForFPS);
		::EnableWindow(hWnd, m_pStCamera->HasVBlankForFPS());
		break;
	case(IDC_EDIT_SHARPNESS_GAIN):
		_stprintf(szTmp, TEXT("%u"), m_wSharpnessGain);
		::EnableWindow(hWnd, STCAM_SHARPNESS_OFF != m_byteSharpnessMode);
		break;
	case(IDC_EDIT_SHARPNESS_CORING):
		_stprintf(szTmp, TEXT("%u"), m_byteSharpnessCoring);
		::EnableWindow(hWnd, STCAM_SHARPNESS_OFF != m_byteSharpnessMode);
		break;
	case(IDC_EDIT_Y_GAMMA_VALUE):
	case(IDC_EDIT_R_GAMMA_VALUE):
	case(IDC_EDIT_GR_GAMMA_VALUE):
	case(IDC_EDIT_GB_GAMMA_VALUE):
	case(IDC_EDIT_B_GAMMA_VALUE):
		_stprintf(szTmp, TEXT("%u"), m_pwGamma[nID - IDC_EDIT_Y_GAMMA_VALUE]);
		::EnableWindow(hWnd, STCAM_GAMMA_OFF != m_pbyteGammaMode[nID - IDC_EDIT_Y_GAMMA_VALUE]);
		break;
	case(IDC_EDIT_CAMERA_GAMMA_VALUE):
		_stprintf(szTmp, TEXT("%u"), m_wCameraGamma);
		::EnableWindow(hWnd, m_pStCamera->HasCameraGamma());
		break;
	case(IDC_EDIT_DIGITAL_CLAMP):
		_stprintf(szTmp, TEXT("%u"), m_wDigitalClamp);
		::EnableWindow(hWnd, m_pStCamera->HasDigitalClamp());
		break;

	}
	
	::SetWindowText(hWnd, szTmp);
	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CTabParentDlg::DisplayCombo(HWND hWnd)
{
	BOOL bReval = TRUE;
	int nID = ::GetDlgCtrlID(hWnd);

	CComboBox objComboBox;
	objComboBox.Attach(hWnd);
	int nListIndex = 0;

	while(objComboBox.GetCount())	objComboBox.DeleteString(0);
	switch(nID)
	{
	case(IDC_COMBO_ALC_MODE):
		{
			DWORD dwCurValue = m_byteALCMode;
			AddComboStr(&objComboBox, TEXT("OFF"), STCAM_ALCMODE_OFF, dwCurValue, &nListIndex);
			BOOL hasAE = m_pStCamera->HasAE();
			BOOL hasAGC = m_pStCamera->HasAGC();
			if(hasAE || hasAGC)
			{
				if(hasAE)
				{
					AddComboStr(&objComboBox, TEXT("AE ON"), STCAM_ALCMODE_CAMERA_AE_ON, dwCurValue, &nListIndex);
				}
				if(hasAGC)
				{
					AddComboStr(&objComboBox, TEXT("AGC ON"), STCAM_ALCMODE_CAMERA_AGC_ON, dwCurValue, &nListIndex);
					if(hasAE)
					{
						AddComboStr(&objComboBox, TEXT("AE/AGC ON"), STCAM_ALCMODE_CAMERA_AE_AGC_ON, dwCurValue, &nListIndex);
					}
				}
			}
			else
			{
				AddComboStr(&objComboBox, TEXT("AE/AGC ON"), STCAM_ALCMODE_PC_AE_AGC_ON, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("AE ON"), STCAM_ALCMODE_PC_AE_ON, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("AGC ON"), STCAM_ALCMODE_PC_AGC_ON, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("AE/AGC OneShot"), STCAM_ALCMODE_PC_AE_AGC_ONESHOT, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("AE OneShot"), STCAM_ALCMODE_PC_AE_ONESHOT, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("AGC OneShot"), STCAM_ALCMODE_PC_AGC_ONESHOT, dwCurValue, &nListIndex);
			}
		}
		break;
	case(IDC_COMBO_IO_DIR_0):
	case(IDC_COMBO_IO_DIR_1):
	case(IDC_COMBO_IO_DIR_2):
	case(IDC_COMBO_IO_DIR_3):
		{
			int iIONo = nID - IDC_COMBO_IO_DIR_0;
			DWORD dwMask = 1 << iIONo;
			DWORD dwCurValue = m_dwIODirection & dwMask;
			AddComboStr(&objComboBox, TEXT("Input"), 0, dwCurValue, &nListIndex);
			AddComboStr(&objComboBox, TEXT("Output"), dwMask, dwCurValue, &nListIndex);
			
			objComboBox.EnableWindow((m_dwIOExistence & dwMask) && m_pStCamera->HasChangeIOFunction());
		}
		break;
	case(IDC_COMBO_IO_POL_0):
	case(IDC_COMBO_IO_POL_1):
	case(IDC_COMBO_IO_POL_2):
	case(IDC_COMBO_IO_POL_3):
		{
			int iIONo = nID - IDC_COMBO_IO_POL_0;
			DWORD dwMask = 1 << iIONo;
			DWORD dwCurValue = m_dwIOPolarity & dwMask;
			AddComboStr(&objComboBox, TEXT("Positive"), 0, dwCurValue, &nListIndex);
			AddComboStr(&objComboBox, TEXT("Negative"), dwMask, dwCurValue, &nListIndex);
			
			DWORD dwIOMode = m_pdwIOMode[iIONo];
			DWORD dwDirMask = 1 << iIONo;
			BOOL bOutputFg = m_dwIODirection & dwDirMask;
			BOOL bEnabled = TRUE;
			if(bOutputFg)
			{
				if(
					(STCAM_OUT_PIN_MODE_DISABLE == dwIOMode) || 
					(STCAM_OUT_PIN_MODE_GENERAL_OUTPUT == dwIOMode)
				)
				{
					bEnabled = FALSE;
				}
			}
			else
			{
				if(
					(STCAM_IN_PIN_MODE_DISABLE == dwIOMode) || 
					(STCAM_IN_PIN_MODE_GENERAL_INPUT == dwIOMode)
				)
				{
					bEnabled = FALSE;
				}
			}
			objComboBox.EnableWindow((m_dwIOExistence & dwMask) && bEnabled);
		}
		break;
	case(IDC_COMBO_IO_STATUS_0):
	case(IDC_COMBO_IO_STATUS_1):
	case(IDC_COMBO_IO_STATUS_2):
	case(IDC_COMBO_IO_STATUS_3):
		{
			int iIONo = nID - IDC_COMBO_IO_STATUS_0;
			DWORD dwMask = 1 << iIONo;
			DWORD dwCurValue = m_dwIOStatus & dwMask;
			AddComboStr(&objComboBox, TEXT("Low"), 0, dwCurValue, &nListIndex);
			AddComboStr(&objComboBox, TEXT("High"), dwMask, dwCurValue, &nListIndex);
			
			objComboBox.EnableWindow((m_dwIOExistence & dwMask) && (m_dwIODirection & dwMask) && (STCAM_OUT_PIN_MODE_GENERAL_OUTPUT == m_pdwIOMode[iIONo]));
		}
		break;
	case(IDC_COMBO_IO_MODE_0):
	case(IDC_COMBO_IO_MODE_1):
	case(IDC_COMBO_IO_MODE_2):
	case(IDC_COMBO_IO_MODE_3):
		{
			int iIONo = nID - IDC_COMBO_IO_MODE_0;
			DWORD dwIOMode = m_pdwIOMode[iIONo];
			DWORD dwMask = 1 << iIONo;
			BOOL bOutputFg = m_dwIODirection & dwMask;
			if(bOutputFg)
			{
				AddComboStr(&objComboBox, TEXT("Disable"), STCAM_OUT_PIN_MODE_DISABLE, dwIOMode, &nListIndex);
				AddComboStr(&objComboBox, TEXT("General Output"), STCAM_OUT_PIN_MODE_GENERAL_OUTPUT, dwIOMode, &nListIndex);
				AddComboStr(&objComboBox, TEXT("Trigger Output Programmable"), STCAM_OUT_PIN_MODE_TRIGGER_OUTPUT_PROGRAMMABLE, dwIOMode, &nListIndex);
				if(m_pStCamera->HasTriggerThroughFunction())
				{
					AddComboStr(&objComboBox, TEXT("Trigger Output Loop Through"), STCAM_OUT_PIN_MODE_TRIGGER_OUTPUT_LOOP_THROUGH, dwIOMode, &nListIndex);
				}
				AddComboStr(&objComboBox, TEXT("Exposure End"), STCAM_OUT_PIN_MODE_EXPOSURE_END, dwIOMode, &nListIndex);
				AddComboStr(&objComboBox, TEXT("CCD Read End Output"), STCAM_OUT_PIN_MODE_CCD_READ_END_OUTPUT, dwIOMode, &nListIndex);
				AddComboStr(&objComboBox, TEXT("Strobe Output Programmable"), STCAM_OUT_PIN_MODE_STROBE_OUTPUT_PROGRAMMABLE, dwIOMode, &nListIndex);
				AddComboStr(&objComboBox, TEXT("Strobe Output Exposure"), STCAM_OUT_PIN_MODE_STROBE_OUTPUT_EXPOSURE, dwIOMode, &nListIndex);
				if(m_pStCamera->HasTriggerValidOutput())
				{
					AddComboStr(&objComboBox, TEXT("Trigger Valid Out"), STCAM_OUT_PIN_MODE_TRIGGER_VALID_OUT, dwIOMode, &nListIndex);
				}
			}
			else
			{
				AddComboStr(&objComboBox, TEXT("Disable"), STCAM_IN_PIN_MODE_DISABLE, dwIOMode, &nListIndex);
				AddComboStr(&objComboBox, TEXT("General Input"), STCAM_IN_PIN_MODE_GENERAL_INPUT, dwIOMode, &nListIndex);
				AddComboStr(&objComboBox, TEXT("Trigger Input"), STCAM_IN_PIN_MODE_TRIGGER_INPUT, dwIOMode, &nListIndex);
				if(m_pStCamera->HasReadOut())
				{
					AddComboStr(&objComboBox, TEXT("Readout Input"), STCAM_IN_PIN_MODE_READOUT_INPUT, dwIOMode, &nListIndex);
				}

				if(m_pStCamera->HasStartStopMode())
				{
					AddComboStr(&objComboBox, TEXT("Sub Trigger Input"), STCAM_IN_PIN_MODE_SUB_TRIGGER_INPUT, dwIOMode, &nListIndex);
				}
			}
			objComboBox.EnableWindow(m_dwIOExistence & dwMask);
		}
		break;
	case(IDC_COMBO_LED_RED):
		{
			DWORD dwCurValue = m_dwLEDStatus & STCAM_LED_RED_ON;
			AddComboStr(&objComboBox, TEXT("OFF"), 0, dwCurValue, &nListIndex);
			AddComboStr(&objComboBox, TEXT("ON"), STCAM_LED_RED_ON, dwCurValue, &nListIndex);
			
			objComboBox.EnableWindow(m_pStCamera->HasLEDFunction(1));
		}
		break;
	case(IDC_COMBO_LED_GREEN):
		{
			DWORD dwCurValue = m_dwLEDStatus & STCAM_LED_GREEN_ON;
			AddComboStr(&objComboBox, TEXT("OFF"), 0, dwCurValue, &nListIndex);
			AddComboStr(&objComboBox, TEXT("ON"), STCAM_LED_GREEN_ON, dwCurValue, &nListIndex);
			
			objComboBox.EnableWindow(m_pStCamera->HasLEDFunction(0));
		}
		break;

	case(IDC_COMBO_SCAN_MODE):
		{
			AddComboStr(&objComboBox, TEXT("Normal"), STCAM_SCAN_MODE_NORMAL, m_wScanMode, &nListIndex);

			S_NAME_AND_DWORD psNameAndValue[] =
				{
					{TEXT("Partial_1"), STCAM_SCAN_MODE_PARTIAL_1},
					{TEXT("Partial_2"), STCAM_SCAN_MODE_PARTIAL_2},
					{TEXT("Partial_4"), STCAM_SCAN_MODE_PARTIAL_4},
					{TEXT("Variable Partial"), STCAM_SCAN_MODE_VARIABLE_PARTIAL},
					{TEXT("Binning"), STCAM_SCAN_MODE_BINNING},
					{TEXT("Binning Partial_1"), STCAM_SCAN_MODE_BINNING_PARTIAL_1},
					{TEXT("Binning Partial_2"), STCAM_SCAN_MODE_BINNING_PARTIAL_2},
					{TEXT("Binning Partial_4"), STCAM_SCAN_MODE_BINNING_PARTIAL_4},
					{TEXT("Binning Variable Partial"), STCAM_SCAN_MODE_BINNING_VARIABLE_PARTIAL},
					{TEXT("AOI"), STCAM_SCAN_MODE_AOI}
				};
			for(int i = 0; i < sizeof(psNameAndValue) / sizeof(S_NAME_AND_DWORD); i++)
			{
				if(m_pStCamera->IsSupportedScanMode((WORD)psNameAndValue[i].dwValue))
				{
					AddComboStr(&objComboBox, psNameAndValue[i].szName, psNameAndValue[i].dwValue, m_wScanMode, &nListIndex);
				}
			}
		}
		break;
	case(IDC_COMBO_H_BINNING_SKIPPING):
		if(m_wScanMode == STCAM_SCAN_MODE_AOI)
		{
			DWORD dwCurValue = (m_byteHBinning << 8) | m_byteHSkipping;
			switch(m_pStCamera->GetProductID())
			{
			case(STCAM_USBPID_STC_MBA5MUSB3):
			case(STCAM_USBPID_STC_MCA5MUSB3):
				AddComboStr(&objComboBox, TEXT("1/1"), 0x0000, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/2"), 0x0001, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("2/2"), 0x0101, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/3"), 0x0002, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/4"), 0x0003, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("2/4"), 0x0103, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("4/4"), 0x0203, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/5"), 0x0004, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/6"), 0x0005, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("2/6"), 0x0105, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/7"), 0x0006, dwCurValue, &nListIndex);
				break;
			case(STCAM_USBPID_STC_MBE132U3V):
			case(STCAM_USBPID_STC_MCE132U3V):
				AddComboStr(&objComboBox, TEXT("1/1"), 0x0100, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/2"), 0x0102, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/4"), 0x0104, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("2/1"), 0x0201, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("2/2"), 0x0202, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("2/4"), 0x0204, dwCurValue, &nListIndex);
				break;
			}
		}
		objComboBox.EnableWindow(m_wScanMode == STCAM_SCAN_MODE_AOI);
		break;
	case(IDC_COMBO_V_BINNING_SKIPPING):
		if(m_wScanMode == STCAM_SCAN_MODE_AOI)
		{
			DWORD dwCurValue = (m_byteVBinning << 8) | m_byteVSkipping;
			switch(m_pStCamera->GetProductID())
			{
			case(STCAM_USBPID_STC_MBA5MUSB3):
			case(STCAM_USBPID_STC_MCA5MUSB3):
				AddComboStr(&objComboBox, TEXT("1/1"), 0x0000, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/2"), 0x0001, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("2/2"), 0x0101, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/3"), 0x0002, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/4"), 0x0003, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("2/4"), 0x0103, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("4/4"), 0x0203, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/5"), 0x0004, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/6"), 0x0005, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("2/6"), 0x0105, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/7"), 0x0006, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/8"), 0x0007, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("2/8"), 0x0107, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("4/8"), 0x0207, dwCurValue, &nListIndex);
				break;
			case(STCAM_USBPID_STC_MBE132U3V):
			case(STCAM_USBPID_STC_MCE132U3V):
				AddComboStr(&objComboBox, TEXT("1/1"), 0x0100, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/2"), 0x0102, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("1/4"), 0x0104, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("2/1"), 0x0201, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("2/2"), 0x0202, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("2/4"), 0x0204, dwCurValue, &nListIndex);
				break;
			}
		}
		objComboBox.EnableWindow(m_wScanMode == STCAM_SCAN_MODE_AOI);
		break;
	case(IDC_COMBO_H_BINNING_SUM):
		if(m_pStCamera->HasHBinningSum() && (m_wScanMode == STCAM_SCAN_MODE_AOI))
		{
			DWORD dwCurValue = m_wBinningSumMode & 0x00FF;
			AddComboStr(&objComboBox, TEXT("OFF"), STCAM_BINNING_SUM_MODE_OFF, dwCurValue, &nListIndex);
			AddComboStr(&objComboBox, TEXT("ON"), STCAM_BINNING_SUM_MODE_H, dwCurValue, &nListIndex);
			objComboBox.EnableWindow(TRUE);
		}
		else
		{
			objComboBox.EnableWindow(FALSE);
		}
		break;
	case(IDC_COMBO_V_BINNING_SUM):
		if(m_pStCamera->HasVBinningSum() && (m_wScanMode == STCAM_SCAN_MODE_AOI))
		{
			DWORD dwCurValue = m_wBinningSumMode & 0xFF00;
			AddComboStr(&objComboBox, TEXT("OFF"), STCAM_BINNING_SUM_MODE_OFF, dwCurValue, &nListIndex);
			AddComboStr(&objComboBox, TEXT("ON"), STCAM_BINNING_SUM_MODE_V, dwCurValue, &nListIndex);
			objComboBox.EnableWindow(TRUE);
		}
		else
		{
			objComboBox.EnableWindow(FALSE);
		}
		break;
	case(IDC_COMBO_CLOCK):
		{
			AddComboStr(&objComboBox, TEXT("Normal"), STCAM_CLOCK_MODE_NORMAL, m_dwClockMode, &nListIndex);
			S_NAME_AND_DWORD psNameAndValue[] =
				{
					{TEXT("1/2"), STCAM_CLOCK_MODE_DIV_2},
					{TEXT("1/4"), STCAM_CLOCK_MODE_DIV_4},
					{TEXT("90FPS"), STCAM_CLOCK_MODE_VGA_90FPS}
				};
			for(int i = 0; i < sizeof(psNameAndValue) / sizeof(S_NAME_AND_DWORD); i++)
			{
				if(m_pStCamera->IsSupportedClockMode(psNameAndValue[i].dwValue))
				{
					AddComboStr(&objComboBox, psNameAndValue[i].szName, psNameAndValue[i].dwValue, m_dwClockMode, &nListIndex);
				}
			}
			objComboBox.EnableWindow(1 < objComboBox.GetCount());
		}
		break;
	case(IDC_COMBO_TRANSFER_BITS):
		{
			AddComboStr(&objComboBox, TEXT("RAW_8bits"), STCAM_TRANSFER_BITS_PER_PIXEL_RAW_08, m_dwTransferBitsPerPixel, &nListIndex);
			S_NAME_AND_DWORD psNameAndValue[] =
				{
					{TEXT("RAW_10bits"), STCAM_TRANSFER_BITS_PER_PIXEL_RAW_10},
					{TEXT("RAW_12bits"), STCAM_TRANSFER_BITS_PER_PIXEL_RAW_12},
					{TEXT("RAW_14bits"), STCAM_TRANSFER_BITS_PER_PIXEL_RAW_14},
					{TEXT("RAW_16bits"), STCAM_TRANSFER_BITS_PER_PIXEL_RAW_16},
					{TEXT("MONO_8bits"), STCAM_TRANSFER_BITS_PER_PIXEL_MONO_08},
					{TEXT("MONO_10bits"), STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10},
					{TEXT("MONO_12bits"), STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12},
					{TEXT("MONO_14bits"), STCAM_TRANSFER_BITS_PER_PIXEL_MONO_14},
					{TEXT("MONO_16bits"), STCAM_TRANSFER_BITS_PER_PIXEL_MONO_16},
					{TEXT("BGR_8bits"), STCAM_TRANSFER_BITS_PER_PIXEL_BGR_08},
					{TEXT("BGR_10bits"), STCAM_TRANSFER_BITS_PER_PIXEL_BGR_10}
				};
			for(int i = 0; i < sizeof(psNameAndValue) / sizeof(S_NAME_AND_DWORD); i++)
			{
				if(m_pStCamera->IsSupportedTransferBitsPerPixel(psNameAndValue[i].dwValue))
				{
					AddComboStr(&objComboBox, psNameAndValue[i].szName, psNameAndValue[i].dwValue, m_dwTransferBitsPerPixel, &nListIndex);
				}
			}
		}
		break;
	case(IDC_COMBO_COLOR_INTERPOLATION):
		{
			BYTE byteColorInterpolation = m_pStCamera->m_byteColorInterpolationMethod;
			
			AddComboStr(&objComboBox, TEXT("None(MONO)"), STCAM_COLOR_INTERPOLATION_NONE_MONO, byteColorInterpolation, &nListIndex);
			AddComboStr(&objComboBox, TEXT("None(Color)"), STCAM_COLOR_INTERPOLATION_NONE_COLOR, byteColorInterpolation, &nListIndex);
			AddComboStr(&objComboBox, TEXT("Nearest Neighbor"), STCAM_COLOR_INTERPOLATION_NEAREST_NEIGHBOR, byteColorInterpolation, &nListIndex);
			AddComboStr(&objComboBox, TEXT("Bilinear"), STCAM_COLOR_INTERPOLATION_BILINEAR, byteColorInterpolation, &nListIndex);
			AddComboStr(&objComboBox, TEXT("Bilinear(False color reduction)"), STCAM_COLOR_INTERPOLATION_BILINEAR_FALSE_COLOR_REDUCTION, byteColorInterpolation, &nListIndex);
			AddComboStr(&objComboBox, TEXT("Bicubic"), STCAM_COLOR_INTERPOLATION_BICUBIC, byteColorInterpolation, &nListIndex);

			objComboBox.EnableWindow(STCAM_COLOR_ARRAY_MONO != m_pStCamera->m_wColorArray);
		}
		break;
	case(IDC_COMBO_MIRROR_MODE):
		{
			BYTE byteMirrorMode = STCAM_MIRROR_OFF;
			
			BOOL hasMirrorH = m_pStCamera->HasMirrorHorizontal();
			BOOL hasMirrorV = m_pStCamera->HasMirrorVertical();
			if(hasMirrorH || hasMirrorV)
			{
				StTrg_GetMirrorMode(m_hCamera, &byteMirrorMode);
			}
			byteMirrorMode |= m_pStCamera->m_byteMirrorMode;


			AddComboStr(&objComboBox, TEXT("OFF"), STCAM_MIRROR_OFF, byteMirrorMode, &nListIndex);
			AddComboStr(&objComboBox, TEXT("Horizontal"), STCAM_MIRROR_HORIZONTAL, byteMirrorMode, &nListIndex);
			AddComboStr(&objComboBox, TEXT("Vertical"), STCAM_MIRROR_VERTICAL, byteMirrorMode, &nListIndex);
			AddComboStr(&objComboBox, TEXT("Horizontal/Vertical"), STCAM_MIRROR_HORIZONTAL_VERTICAL, byteMirrorMode, &nListIndex);
			if(hasMirrorH)
			{
				AddComboStr(&objComboBox, TEXT("Horizontal[Camera]"), STCAM_MIRROR_HORIZONTAL_CAMERA, byteMirrorMode, &nListIndex);
			}
			if(hasMirrorV)
			{
				AddComboStr(&objComboBox, TEXT("Vertical[Camera]"), STCAM_MIRROR_VERTICAL_CAMERA, byteMirrorMode, &nListIndex);
				if(hasMirrorH)
				{
					AddComboStr(&objComboBox, TEXT("Horizontal/Vertical[Camera]"), STCAM_MIRROR_HORIZONTAL_CAMERA | STCAM_MIRROR_VERTICAL_CAMERA, byteMirrorMode, &nListIndex);
				}
			}
		}
		break;
	case(IDC_COMBO_ROTATION_MODE):
		{
			BYTE byteRotationMode = m_pStCamera->m_byteRotationMode;
			
			AddComboStr(&objComboBox, TEXT("OFF"), STCAM_ROTATION_OFF, byteRotationMode, &nListIndex);
			AddComboStr(&objComboBox, TEXT("CLOCKWISE_90"), STCAM_ROTATION_CLOCKWISE_90, byteRotationMode, &nListIndex);
			AddComboStr(&objComboBox, TEXT("COUNTERCLOCKWISE_90"), STCAM_ROTATION_COUNTERCLOCKWISE_90, byteRotationMode, &nListIndex);
		}
		break;
	case(IDC_COMBO_NOISE_REDUCTION):
		{
			DWORD dwNoiseReductionMode = m_pStCamera->m_dwNoiseReductionMode;
			
			AddComboStr(&objComboBox, TEXT("OFF"), STCAM_NR_OFF, dwNoiseReductionMode, &nListIndex);
			AddComboStr(&objComboBox, TEXT("Easy"), STCAM_NR_EASY, dwNoiseReductionMode, &nListIndex);
			AddComboStr(&objComboBox, TEXT("Calibration"), STCAM_NR_DARK_CL, dwNoiseReductionMode, &nListIndex);
			AddComboStr(&objComboBox, TEXT("Complex"), STCAM_NR_COMPREX, dwNoiseReductionMode, &nListIndex);

			objComboBox.EnableWindow(
					(STCAM_TRIGGER_MODE_TYPE_FREE_RUN != (m_pStCamera->m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK)) &&
					(STCAM_TRIGGER_MODE_EXPTIME_EDGE_PRESET != (m_pStCamera->m_dwTriggerMode & STCAM_TRIGGER_MODE_EXPTIME_MASK))
				);
		}
		break;

		
	case(IDC_COMBO_WB_MODE):
		{
			AddComboStr(&objComboBox, TEXT("OFF"), STCAM_WB_OFF, m_byteWhiteBalanceMode, &nListIndex);
			AddComboStr(&objComboBox, TEXT("Manual"), STCAM_WB_MANUAL, m_byteWhiteBalanceMode, &nListIndex);
			AddComboStr(&objComboBox, TEXT("One Shot"), STCAM_WB_ONESHOT, m_byteWhiteBalanceMode, &nListIndex);
			AddComboStr(&objComboBox, TEXT("Full Auto"), STCAM_WB_FULLAUTO, m_byteWhiteBalanceMode, &nListIndex);

			objComboBox.EnableWindow(STCAM_COLOR_ARRAY_MONO != m_pStCamera->m_wColorArray);
		}
		break;
	case(IDC_COMBO_HUE_SATURATION_MODE):
		{
			AddComboStr(&objComboBox, TEXT("OFF"), STCAM_HUE_SATURATION_OFF, m_byteHueSaturationMode, &nListIndex);
			AddComboStr(&objComboBox, TEXT("ON"), STCAM_HUE_SATURATION_ON, m_byteHueSaturationMode, &nListIndex);

			objComboBox.EnableWindow(STCAM_COLOR_ARRAY_MONO != m_pStCamera->m_wColorArray);
		}
		break;
	case(IDC_COMBO_TRIGGER_TYPE):
		{
			DWORD dwCurValue = m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK;
			AddComboStr(&objComboBox, TEXT("Free Run"), STCAM_TRIGGER_MODE_TYPE_FREE_RUN, dwCurValue, &nListIndex);
			AddComboStr(&objComboBox, TEXT("Trigger"), STCAM_TRIGGER_MODE_TYPE_TRIGGER, dwCurValue, &nListIndex);
			if(m_pStCamera->HasReadOut())
			{
				AddComboStr(&objComboBox, TEXT("Trigger Read Out"), STCAM_TRIGGER_MODE_TYPE_TRIGGER_RO, dwCurValue, &nListIndex);
			}
		}
		break;
	case(IDC_COMBO_TRIGGER_EXPOSURE_END):
		{
			DWORD dwCurValue = m_dwTriggerMode & STCAM_TRIGGER_MODE_EXPEND_MASK;
			AddComboStr(&objComboBox, TEXT("Disable"), STCAM_TRIGGER_MODE_EXPEND_DISABLE, dwCurValue, &nListIndex);
			AddComboStr(&objComboBox, TEXT("Enable"), STCAM_TRIGGER_MODE_EXPEND_ENABLE, dwCurValue, &nListIndex);
		}
		break;
	case(IDC_COMBO_TRIGGER_SOURCE):
		{
			if(STCAM_TRIGGER_MODE_TYPE_FREE_RUN != (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK))
			{
				DWORD dwCurValue = m_dwTriggerMode & STCAM_TRIGGER_MODE_SOURCE_MASK;
				AddComboStr(&objComboBox, TEXT("Disable"), STCAM_TRIGGER_MODE_SOURCE_NONE, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("Software"), STCAM_TRIGGER_MODE_SOURCE_SOFTWARE, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("Hardware"), STCAM_TRIGGER_MODE_SOURCE_HARDWARE, dwCurValue, &nListIndex);
				objComboBox.EnableWindow(TRUE);
			}
			else
			{
				objComboBox.EnableWindow(FALSE);
			}
		}
		break;
	case(IDC_COMBO_TRIGGER_READ_OUT_SOURCE):
		{
			if(STCAM_TRIGGER_MODE_TYPE_TRIGGER_RO == (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK))
			{
				DWORD dwCurValue = m_dwTriggerMode & STCAM_TRIGGER_MODE_READOUT_SOURCE_MASK;
				AddComboStr(&objComboBox, TEXT("Software"), STCAM_TRIGGER_MODE_READOUT_SOFTWARE, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("Hardware"), STCAM_TRIGGER_MODE_READOUT_HARDWARE, dwCurValue, &nListIndex);
				objComboBox.EnableWindow(TRUE);
			}
			else
			{
				objComboBox.EnableWindow(FALSE);
			}
		}
		break;
	case(IDC_COMBO_TRIGGER_CAMERA_MEMORY):
		{
			if(m_pStCamera->HasCameraMemoryFunction())
			{
				DWORD dwCurValue = m_dwTriggerMode & STCAM_TRIGGER_MODE_CAMERA_MEMORY_MASK;
				AddComboStr(&objComboBox, TEXT("Type B"), STCAM_TRIGGER_MODE_CAMERA_MEMORY_TYPE_B, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("Type A"), STCAM_TRIGGER_MODE_CAMERA_MEMORY_TYPE_A, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("OFF"), STCAM_TRIGGER_MODE_CAMERA_MEMORY_OFF, dwCurValue, &nListIndex);
				objComboBox.EnableWindow(TRUE);
			}
			else
			{
				objComboBox.EnableWindow(FALSE);
			}
		}
		break;
	case(IDC_COMBO_TRIGGER_MASK):
		{
			if(m_pStCamera->HasTriggerMaskFunction())
			{
				DWORD dwCurValue = m_dwTriggerMode & STCAM_TRIGGER_MODE_TRIGGER_MASK_MASK;
				AddComboStr(&objComboBox, TEXT("OFF"), STCAM_TRIGGER_MODE_TRIGGER_MASK_OFF, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("ON"), STCAM_TRIGGER_MODE_TRIGGER_MASK_ON, dwCurValue, &nListIndex);
				objComboBox.EnableWindow(TRUE);
			}
			else
			{
				objComboBox.EnableWindow(FALSE);
			}
		}
		break;
	case(IDC_COMBO_CMOS_RESET_TYPE):
		{
			DWORD dwSupportedCMOSResetType = m_pStCamera->GetSupportedCMOSResetType();
			
			if(0 < dwSupportedCMOSResetType)
			{
				DWORD dwCurValue = m_dwTriggerMode & STCAM_TRIGGER_MODE_CMOS_RESET_TYPE_MASK;
				AddComboStr(&objComboBox, TEXT("Electronic Rolling Shutter"), STCAM_TRIGGER_MODE_CMOS_RESET_TYPE_ERS, dwCurValue, &nListIndex);
				if(dwSupportedCMOSResetType & 0x01)
				{
					AddComboStr(&objComboBox, TEXT("Global Reset Release"), STCAM_TRIGGER_MODE_CMOS_RESET_TYPE_GRR, dwCurValue, &nListIndex);
				}
				if(dwSupportedCMOSResetType & 0x02)
				{
					AddComboStr(&objComboBox, TEXT("Global Shutter"), STCAM_TRIGGER_MODE_CMOS_RESET_TYPE_GS, dwCurValue, &nListIndex);
				}
				objComboBox.EnableWindow(TRUE);
			}
			else
			{
				objComboBox.EnableWindow(FALSE);
			}
		}
		break;
	case(IDC_COMBO_TRIGGER_EXPOSURE_TIME):
		{
			if(STCAM_TRIGGER_MODE_TYPE_FREE_RUN != (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK))
			{
				DWORD dwCurValue = m_dwTriggerMode & STCAM_TRIGGER_MODE_EXPTIME_MASK;
				AddComboStr(&objComboBox, TEXT("Edge Preset"), STCAM_TRIGGER_MODE_EXPTIME_EDGE_PRESET, dwCurValue, &nListIndex);
				if(m_pStCamera->HasPulseWidthExposureFunction())
				{
					AddComboStr(&objComboBox, TEXT("Pulse Width"), STCAM_TRIGGER_MODE_EXPTIME_PULSE_WIDTH, dwCurValue, &nListIndex);
				}

				if(m_pStCamera->HasStartStopMode())
				{
					AddComboStr(&objComboBox, TEXT("Start/Stop"), STCAM_TRIGGER_MODE_EXPTIME_START_STOP, dwCurValue, &nListIndex);
				}

				objComboBox.EnableWindow(TRUE);
			}
			else
			{
				objComboBox.EnableWindow(FALSE);
			}
		}
		break;
	case(IDC_COMBO_TRIGGER_WAIT_HD):
		{
			if(STCAM_TRIGGER_MODE_TYPE_FREE_RUN != (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK))
			{
				DWORD dwCurValue = m_dwTriggerMode & STCAM_TRIGGER_MODE_EXPOSURE_WAIT_HD_MASK;
				AddComboStr(&objComboBox, TEXT("OFF"), STCAM_TRIGGER_MODE_EXPOSURE_WAIT_HD_OFF, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("ON"), STCAM_TRIGGER_MODE_EXPOSURE_WAIT_HD_ON, dwCurValue, &nListIndex);
				objComboBox.EnableWindow(m_pStCamera->HasExposureStartWaitHD());
			}
			else
			{
				objComboBox.EnableWindow(FALSE);
			}
		}
		break;
	case(IDC_COMBO_TRIGGER_WAIT_READ_OUT):
		{
			if(STCAM_TRIGGER_MODE_TYPE_FREE_RUN != (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK))
			{
				DWORD dwCurValue = m_dwTriggerMode & STCAM_TRIGGER_MODE_EXPOSURE_WAIT_READOUT_MASK;
				AddComboStr(&objComboBox, TEXT("OFF"), STCAM_TRIGGER_MODE_EXPOSURE_WAIT_READOUT_OFF, dwCurValue, &nListIndex);
				AddComboStr(&objComboBox, TEXT("ON"), STCAM_TRIGGER_MODE_EXPOSURE_WAIT_READOUT_ON, dwCurValue, &nListIndex);
				objComboBox.EnableWindow(m_pStCamera->HasExposureStartWaitReadOut());
			}
			else
			{
				objComboBox.EnableWindow(FALSE);
			}
		}
		break;
	case(IDC_COMBO_SHARPNESS_MODE):
		{
			AddComboStr(&objComboBox, TEXT("OFF"), STCAM_SHARPNESS_OFF, m_byteSharpnessMode, &nListIndex);
			AddComboStr(&objComboBox, TEXT("ON"), STCAM_SHARPNESS_ON, m_byteSharpnessMode, &nListIndex);
		}
		break;
	case(IDC_COMBO_Y_GAMMA_MODE):
	case(IDC_COMBO_R_GAMMA_MODE):
	case(IDC_COMBO_GR_GAMMA_MODE):
	case(IDC_COMBO_GB_GAMMA_MODE):
	case(IDC_COMBO_B_GAMMA_MODE):
		{
			BYTE byteGammaMode = m_pbyteGammaMode[nID - IDC_COMBO_Y_GAMMA_MODE];
			AddComboStr(&objComboBox, TEXT("OFF"), STCAM_GAMMA_OFF, byteGammaMode, &nListIndex);
			AddComboStr(&objComboBox, TEXT("ON"), STCAM_GAMMA_ON, byteGammaMode, &nListIndex);
			AddComboStr(&objComboBox, TEXT("REVERSE"), STCAM_GAMMA_REVERSE, byteGammaMode, &nListIndex);
		}
		break;

	}
	objComboBox.SetCurSel(nListIndex);
	objComboBox.Detach();
	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CTabParentDlg::DisplayButton(HWND hWnd)
{
	BOOL bReval = TRUE;
	int nID = ::GetDlgCtrlID(hWnd);

	switch(nID)
	{
	case(IDC_BUTTON_SOFTWARE_TRIGGER):
		if(
			(STCAM_TRIGGER_MODE_TYPE_FREE_RUN != (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK)) &&
			(STCAM_TRIGGER_MODE_SOURCE_SOFTWARE == (m_dwTriggerMode & STCAM_TRIGGER_MODE_SOURCE_MASK))
		)
		{
			::EnableWindow(hWnd, TRUE);
		}
		else
		{
			::EnableWindow(hWnd, FALSE);
		}
		break;
	case(IDC_CHECK_TRIGGER_TIMER_ON):
		if(
			(STCAM_TRIGGER_MODE_TYPE_FREE_RUN != (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK)) &&
			(STCAM_TRIGGER_MODE_SOURCE_SOFTWARE == (m_dwTriggerMode & STCAM_TRIGGER_MODE_SOURCE_MASK)) &&
			(STCAM_TRIGGER_MODE_EXPTIME_START_STOP == (m_dwTriggerMode & STCAM_TRIGGER_MODE_EXPTIME_MASK))
		)
		{
			::EnableWindow(hWnd, TRUE);
			::SendMessage(hWnd, BM_SETCHECK, m_pStCamera->m_bAutoTrigger?BST_CHECKED:BST_UNCHECKED, 0);

		}
		else
		{
			::EnableWindow(hWnd, FALSE);
		}
		
		break;
	case(IDC_BUTTON_SOFTWARE_TRIGGER_SUB):
		if(
			(STCAM_TRIGGER_MODE_TYPE_FREE_RUN != (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK)) &&
			(STCAM_TRIGGER_MODE_SOURCE_SOFTWARE == (m_dwTriggerMode & STCAM_TRIGGER_MODE_SOURCE_MASK)) &&
			(STCAM_TRIGGER_MODE_EXPTIME_START_STOP == (m_dwTriggerMode & STCAM_TRIGGER_MODE_EXPTIME_MASK)) &&
			(!m_pStCamera->m_bAutoTrigger)
		)
		{
			::EnableWindow(hWnd, TRUE);

		}
		else
		{
			::EnableWindow(hWnd, FALSE);
		}
		
		break;

	case(IDC_BUTTON_SOFTWARE_READ_OUT):
		if(
			(STCAM_TRIGGER_MODE_TYPE_TRIGGER_RO == (m_dwTriggerMode & STCAM_TRIGGER_MODE_TYPE_MASK)) &&
			(STCAM_TRIGGER_MODE_READOUT_SOFTWARE == (m_dwTriggerMode & STCAM_TRIGGER_MODE_READOUT_SOURCE_MASK))
		)
		{
			::EnableWindow(hWnd, TRUE);
		}
		else
		{
			::EnableWindow(hWnd, FALSE);
		}
		break;
	case(IDC_BUTTON_RESET_COUNTER):
		::EnableWindow(hWnd, m_pStCamera->HasTriggerFunction());
		break;
	}
	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CTabParentDlg::UpdateByCombo(HWND hWnd)
{
	BOOL bReval = TRUE;
	int nID = ::GetDlgCtrlID(hWnd);

	CComboBox objComboBox;
	objComboBox.Attach(hWnd);

	switch(nID)
	{
	case(IDC_COMBO_ALC_MODE):
		{
			m_byteALCMode = (BYTE)objComboBox.GetItemData(objComboBox.GetCurSel());
			bReval = StTrg_SetALCMode(m_hCamera, m_byteALCMode);
		}
		break;
	case(IDC_COMBO_IO_MODE_0):
	case(IDC_COMBO_IO_MODE_1):
	case(IDC_COMBO_IO_MODE_2):
	case(IDC_COMBO_IO_MODE_3):
		{
			int iIONo = nID - IDC_COMBO_IO_MODE_0;
			m_pdwIOMode[iIONo] = objComboBox.GetItemData(objComboBox.GetCurSel());
			bReval = StTrg_SetIOPinMode(m_hCamera, iIONo, m_pdwIOMode[iIONo]);

			if(bReval)
			{
				bReval = StTrg_GetIOPinStatus(m_hCamera, &m_dwIOStatus);
			}
		}
		break;
	case(IDC_COMBO_IO_POL_0):
	case(IDC_COMBO_IO_POL_1):
	case(IDC_COMBO_IO_POL_2):
	case(IDC_COMBO_IO_POL_3):
		{
			int iIONo = nID - IDC_COMBO_IO_POL_0;
			DWORD dwMask = 1 << iIONo;
			m_dwIOPolarity &= ~dwMask;
			m_dwIOPolarity |= objComboBox.GetItemData(objComboBox.GetCurSel());
			bReval = StTrg_SetIOPinPolarity(m_hCamera, m_dwIOPolarity);
			if(bReval)
			{
				bReval = StTrg_GetIOPinStatus(m_hCamera, &m_dwIOStatus);
			}
		}
		break;
	case(IDC_COMBO_IO_DIR_0):
	case(IDC_COMBO_IO_DIR_1):
	case(IDC_COMBO_IO_DIR_2):
	case(IDC_COMBO_IO_DIR_3):
		{
			int iIONo = nID - IDC_COMBO_IO_DIR_0;
			DWORD dwMask = 1 << iIONo;
			m_dwIODirection &= ~dwMask;
			m_dwIODirection |= objComboBox.GetItemData(objComboBox.GetCurSel());
			bReval = StTrg_SetIOPinDirection(m_hCamera, m_dwIODirection);
		}
		break;
	case(IDC_COMBO_IO_STATUS_0):
	case(IDC_COMBO_IO_STATUS_1):
	case(IDC_COMBO_IO_STATUS_2):
	case(IDC_COMBO_IO_STATUS_3):
		{
			int iIONo = nID - IDC_COMBO_IO_STATUS_0;
			DWORD dwMask = 1 << iIONo;
			m_dwIOStatus &= ~dwMask;
			m_dwIOStatus |= objComboBox.GetItemData(objComboBox.GetCurSel());
			bReval = StTrg_SetIOPinStatus(m_hCamera, m_dwIOStatus);
		}
		break;
	case(IDC_COMBO_SCAN_MODE):
		{
			m_wScanMode = (WORD)objComboBox.GetItemData(objComboBox.GetCurSel());
			bReval = UpdateScanMode();
		}
		break;
	case(IDC_COMBO_H_BINNING_SKIPPING):
		{
			WORD wValue = (WORD)objComboBox.GetItemData(objComboBox.GetCurSel());
			m_byteHSkipping = wValue & 0xFF;
			m_byteHBinning = wValue >> 8;
			bReval = UpdateBinnningSkipping();
		}
		break;
	case(IDC_COMBO_V_BINNING_SKIPPING):
		{
			WORD wValue = (WORD)objComboBox.GetItemData(objComboBox.GetCurSel());
			m_byteVSkipping = wValue & 0xFF;
			m_byteVBinning = wValue >> 8;
			bReval = UpdateBinnningSkipping();
		}
		break;
	case(IDC_COMBO_H_BINNING_SUM):
		{
			m_wBinningSumMode &= 0xFF00;
			m_wBinningSumMode |= (WORD)objComboBox.GetItemData(objComboBox.GetCurSel());
			do
			{
				bReval = StTrg_SetBinningSumMode(m_hCamera, m_wBinningSumMode);
				if(!bReval) break;
				bReval = StTrg_GetBinningSumMode(m_hCamera, &m_wBinningSumMode);
				if(!bReval) break;
			}while(FALSE);
		}
		break;
	case(IDC_COMBO_V_BINNING_SUM):
		{
			m_wBinningSumMode &= 0x00FF;
			m_wBinningSumMode |= (WORD)objComboBox.GetItemData(objComboBox.GetCurSel());
			do
			{
				bReval = StTrg_SetBinningSumMode(m_hCamera, m_wBinningSumMode);
				if(!bReval) break;
				bReval = StTrg_GetBinningSumMode(m_hCamera, &m_wBinningSumMode);
				if(!bReval) break;
			}while(FALSE);
		}
		break;
	case(IDC_COMBO_LED_RED):
		{
			m_dwLEDStatus &= ~STCAM_LED_RED_ON;
			m_dwLEDStatus |= objComboBox.GetItemData(objComboBox.GetCurSel());
			bReval = StTrg_SetLEDStatus(m_hCamera, m_dwLEDStatus);
		}
		break;
	case(IDC_COMBO_LED_GREEN):
		{
			m_dwLEDStatus &= ~STCAM_LED_GREEN_ON;
			m_dwLEDStatus |= objComboBox.GetItemData(objComboBox.GetCurSel());
			bReval = StTrg_SetLEDStatus(m_hCamera, m_dwLEDStatus);
		}
		break;

	case(IDC_COMBO_CLOCK):
		{
			m_dwClockMode = objComboBox.GetItemData(objComboBox.GetCurSel());
			do{
				bReval = m_pStCamera->StopTransfer();
				if(!bReval) break;

				bReval = StTrg_SetClock(m_hCamera, m_dwClockMode, m_dwClock);
				if(!bReval) break;

				bReval = StTrg_GetClock(m_hCamera, &m_dwClockMode, &m_dwClock);
				if(!bReval) break;


				bReval = m_pStCamera->StartTransfer();
			}while(0);
		}
		break;
	case(IDC_COMBO_TRANSFER_BITS):
		{
			m_dwTransferBitsPerPixel = objComboBox.GetItemData(objComboBox.GetCurSel());
			do{
				bReval = m_pStCamera->StopTransfer();
				if(!bReval) break;

				bReval = StTrg_SetTransferBitsPerPixel(m_hCamera, m_dwTransferBitsPerPixel);
				if(!bReval) break;

				bReval = m_pStCamera->StartTransfer();
			}while(0);
		}
		break;
	case(IDC_COMBO_COLOR_INTERPOLATION):
		{
			m_pStCamera->m_byteColorInterpolationMethod = static_cast<BYTE>(objComboBox.GetItemData(objComboBox.GetCurSel()));
		}
		break;
	case(IDC_COMBO_MIRROR_MODE):
		{
			BOOL hasMirrorH = m_pStCamera->HasMirrorHorizontal();
			BOOL hasMirrorV = m_pStCamera->HasMirrorVertical();
			BYTE byteMirroMode = static_cast<BYTE>(objComboBox.GetItemData(objComboBox.GetCurSel()));
			
			m_pStCamera->m_byteMirrorMode = byteMirroMode & 0x0F;

			if(hasMirrorH || hasMirrorV)
			{
				do{
					bReval = m_pStCamera->StopTransfer();
					if(!bReval) break;

					bReval = StTrg_SetMirrorMode(m_hCamera, byteMirroMode & 0xF0);
					if(!bReval) break;

					bReval = m_pStCamera->StartTransfer();
				}while(0);
			}
		}
		break;
	case(IDC_COMBO_ROTATION_MODE):
		{
			m_pStCamera->m_byteRotationMode = static_cast<BYTE>(objComboBox.GetItemData(objComboBox.GetCurSel()));
		}
		break;
	case(IDC_COMBO_NOISE_REDUCTION):
		{
			m_pStCamera->m_dwNoiseReductionMode = static_cast<DWORD>(objComboBox.GetItemData(objComboBox.GetCurSel()));
		}
		break;

	case(IDC_COMBO_WB_MODE):
		{
			m_byteWhiteBalanceMode = static_cast<BYTE>(objComboBox.GetItemData(objComboBox.GetCurSel()));
			do{
				bReval = StTrg_SetWhiteBalanceMode(m_hCamera, m_byteWhiteBalanceMode);
				if(!bReval) break;
				bReval = StTrg_GetWhiteBalanceGain(m_hCamera, &m_pwWhiteBalanceGain[0], &m_pwWhiteBalanceGain[1], &m_pwWhiteBalanceGain[2], &m_pwWhiteBalanceGain[3]);
			}while(0);
			if(!bReval) break;
		}
		break;
	case(IDC_COMBO_HUE_SATURATION_MODE):
		{
			m_byteHueSaturationMode = static_cast<BYTE>(objComboBox.GetItemData(objComboBox.GetCurSel()));
			do{
				bReval = StTrg_SetHueSaturationMode(m_hCamera, m_byteHueSaturationMode, m_shtHue, m_wSaturation);
				if(!bReval) break;
			}while(0);
			if(!bReval) break;
		}
		break;
	case(IDC_COMBO_TRIGGER_TYPE):
	case(IDC_COMBO_TRIGGER_EXPOSURE_END):
	case(IDC_COMBO_TRIGGER_SOURCE):
	case(IDC_COMBO_TRIGGER_READ_OUT_SOURCE):
	case(IDC_COMBO_TRIGGER_EXPOSURE_TIME):
	case(IDC_COMBO_TRIGGER_WAIT_HD):
	case(IDC_COMBO_TRIGGER_WAIT_READ_OUT):
	case(IDC_COMBO_TRIGGER_CAMERA_MEMORY):
	case(IDC_COMBO_TRIGGER_MASK):
	case(IDC_COMBO_CMOS_RESET_TYPE):
		{
			DWORD dwMask = 0;
			if(IDC_COMBO_TRIGGER_TYPE == nID)				dwMask = STCAM_TRIGGER_MODE_TYPE_MASK;
			else if(IDC_COMBO_TRIGGER_EXPOSURE_END == nID)	dwMask = STCAM_TRIGGER_MODE_EXPEND_MASK;
			else if(IDC_COMBO_TRIGGER_SOURCE == nID)		dwMask = STCAM_TRIGGER_MODE_SOURCE_MASK;
			else if(IDC_COMBO_TRIGGER_READ_OUT_SOURCE == nID)		dwMask = STCAM_TRIGGER_MODE_READOUT_SOURCE_MASK;
			else if(IDC_COMBO_TRIGGER_EXPOSURE_TIME == nID)		dwMask = STCAM_TRIGGER_MODE_EXPTIME_MASK;
			else if(IDC_COMBO_TRIGGER_WAIT_HD == nID)		dwMask = STCAM_TRIGGER_MODE_EXPOSURE_WAIT_HD_MASK;
			else if(IDC_COMBO_TRIGGER_WAIT_READ_OUT == nID)		dwMask = STCAM_TRIGGER_MODE_EXPOSURE_WAIT_READOUT_MASK;
			else if(IDC_COMBO_TRIGGER_CAMERA_MEMORY == nID)		dwMask = STCAM_TRIGGER_MODE_CAMERA_MEMORY_MASK;
			else if(IDC_COMBO_TRIGGER_MASK == nID)		dwMask = STCAM_TRIGGER_MODE_TRIGGER_MASK_MASK;
			else if(IDC_COMBO_CMOS_RESET_TYPE == nID)	dwMask = STCAM_TRIGGER_MODE_CMOS_RESET_TYPE_MASK;
			m_dwTriggerMode &= ~dwMask;
			m_dwTriggerMode |= objComboBox.GetItemData(objComboBox.GetCurSel());
			do{
				bReval = m_pStCamera->StopTransfer();
				if(!bReval) break;

				bReval = StTrg_SetTriggerMode(m_hCamera, m_dwTriggerMode);
				if(!bReval) break;
				m_pStCamera->m_dwTriggerMode = m_dwTriggerMode;


				bReval = m_pStCamera->StartTransfer();
			}while(0);
		}
		break;
	case(IDC_COMBO_SHARPNESS_MODE):
		{
			m_byteSharpnessMode = static_cast<BYTE>(objComboBox.GetItemData(objComboBox.GetCurSel()));
			bReval = StTrg_SetSharpnessMode(m_hCamera, m_byteSharpnessMode, m_wSharpnessGain, m_byteSharpnessCoring);
			if(!bReval) break;
		}
		break;

	case(IDC_COMBO_Y_GAMMA_MODE):
	case(IDC_COMBO_R_GAMMA_MODE):
	case(IDC_COMBO_GR_GAMMA_MODE):
	case(IDC_COMBO_GB_GAMMA_MODE):
	case(IDC_COMBO_B_GAMMA_MODE):
		{
			int index = nID - IDC_COMBO_Y_GAMMA_MODE;
			m_pbyteGammaMode[index] = static_cast<BYTE>(objComboBox.GetItemData(objComboBox.GetCurSel()));
			bReval = StTrg_SetGammaModeEx(m_hCamera, index, m_pbyteGammaMode[index], m_pwGamma[index], m_shtBrightness[index], m_byteContrast[index], m_ppbyteGammaTable[index]);
			if(!bReval) break;
			bReval = StTrg_GetGammaModeEx(m_hCamera, index, &m_pbyteGammaMode[index], &m_pwGamma[index], &m_shtBrightness[index], &m_byteContrast[index], m_ppbyteGammaTable[index]);
			if(!bReval) break;
		}
		break;
	}
	objComboBox.Detach();
	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CTabParentDlg::UpdateByButton(HWND hWnd)
{
	BOOL bReval = TRUE;
	int nID = ::GetDlgCtrlID(hWnd);

	switch(nID)
	{
	case(IDC_BUTTON_SOFTWARE_TRIGGER):
#ifdef _DEBUG
		{
			DWORD dwRestTime = m_pStCamera->GetRestTime();
			TRACE(TEXT("RestTime:%ums\n"), dwRestTime);

			if(0 == dwRestTime)
			{

				bReval = m_pStCamera->SoftTrigger();
			}
		}
#else

		bReval = m_pStCamera->SoftTrigger();
#endif
		break;
	case(IDC_BUTTON_SOFTWARE_TRIGGER_SUB):
		bReval = StTrg_SoftSubTrigger(m_hCamera);
		break;
	case(IDC_BUTTON_SOFTWARE_READ_OUT):
		bReval = StTrg_TriggerReadOut(m_hCamera);
		break;
	case(IDC_BUTTON_RESET_COUNTER):
		bReval = StTrg_ResetCounter(m_hCamera);
		break;
	case(IDC_CHECK_TRIGGER_TIMER_ON):
		do{
			bReval = m_pStCamera->StopTransfer();
			if(!bReval) break;


			if(BST_CHECKED == ::SendMessage(hWnd, BM_GETCHECK, 0, 0))
			{
				m_pStCamera->m_bAutoTrigger = TRUE;
			}
			else
			{
				m_pStCamera->m_bAutoTrigger = FALSE;
			}


			bReval = m_pStCamera->StartTransfer();
		}while(0);

		break;
	case(IDC_BUTTON_READ_CAMERA_SETTING):	//1800
	case(IDC_BUTTON_WRITE_CAMERA_SETTING):	//2800
	case(IDC_BUTTON_INIT_CAMERA_SETTING):	//8000
	case(IDC_BUTTON_READ_CAMERA_SETTING_DPP):	//1400
	case(IDC_BUTTON_WRITE_CAMERA_SETTING_DPP):	//2400
		do{
			WORD wMode = 0;
			switch(nID)
			{
			case(IDC_BUTTON_READ_CAMERA_SETTING):	wMode = 0x1800;	break;
			case(IDC_BUTTON_WRITE_CAMERA_SETTING):	wMode = 0x2800;	break;
			case(IDC_BUTTON_INIT_CAMERA_SETTING):	wMode = 0x8000;	break;
			case(IDC_BUTTON_READ_CAMERA_SETTING_DPP):	wMode = 0x1400;	break;
			case(IDC_BUTTON_WRITE_CAMERA_SETTING_DPP):	wMode = 0x2400;	break;
			}
			bReval = m_pStCamera->StopTransfer();
			if(!bReval) break;

			bReval = StTrg_CameraSetting(m_pStCamera->m_hCamera, wMode);
			if(!bReval) break;

			bReval = ReadCameraProperty();
			UppdateAllTabs();
			if(!bReval) break;

			bReval = m_pStCamera->StartTransfer();
			if(!bReval) break;
		}while(0);
		break;
	}
	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CTabParentDlg::UpdateByEdit(HWND hWnd)
{
	BOOL bReval = TRUE;
	int nID = ::GetDlgCtrlID(hWnd);
	
	CEdit objEdit;
	objEdit.Attach(hWnd);
	TCHAR szTmp[MAX_PATH];
	objEdit.GetWindowText(szTmp, MAX_PATH);
	objEdit.Detach();

	int iNewValue = _ttol(szTmp);
	if(bReval)
	{
		switch(nID)
		{
			case(IDC_EDIT_EXPOSURE):
				m_dwExposureClock = (DWORD)iNewValue;
				if(GetMaxExposureClock() < m_dwExposureClock)
				{
					m_dwExposureClock = GetMaxExposureClock();
				}
				bReval = StTrg_SetExposureClock(m_hCamera, m_dwExposureClock);
				break;
			case(IDC_EDIT_CDS_GAIN):
				m_wCDSGain = (WORD)iNewValue;
				if(m_wMaxGain < m_wCDSGain)
				{
					m_wCDSGain = m_wMaxGain;
				}
				bReval = StTrg_SetGain(m_hCamera, m_wCDSGain);
				break;
			case(IDC_EDIT_DIGITAL_GAIN):
				m_wDigitalGain = (WORD)iNewValue;
				if(256 < m_wDigitalGain)
				{
					m_wDigitalGain = 256;
				}
				else if(m_wDigitalGain < 64)
				{
					m_wDigitalGain = 64;
				}
				bReval = StTrg_SetDigitalGain(m_hCamera, m_wDigitalGain);
				break;

			case(IDC_EDIT_ALC_TARGET_LEVEL):
				m_wALCTargetLevel = (WORD)iNewValue;
				if(255 < m_wALCTargetLevel)
				{
					m_wALCTargetLevel = 255;
				}
				bReval = StTrg_SetALCTargetLevel(m_hCamera, m_wALCTargetLevel);
				break;
			case(IDC_EDIT_AE_MIN_EXPOSURE):
				m_dwAEMinExposureClock = (DWORD)iNewValue;
				if(GetMaxExposureClock() < m_dwAEMinExposureClock)
				{
					m_dwAEMinExposureClock = GetMaxExposureClock();
				}
				bReval = StTrg_SetAEMinExposureClock(m_hCamera, m_dwAEMinExposureClock);
				break;
			case(IDC_EDIT_AE_MAX_EXPOSURE):
				m_dwAEMaxExposureClock = (DWORD)iNewValue;
				if(GetMaxExposureClock() < m_dwAEMaxExposureClock)
				{
					m_dwAEMaxExposureClock = GetMaxExposureClock();
				}
				bReval = StTrg_SetAEMaxExposureClock(m_hCamera, m_dwAEMaxExposureClock);
				break;
			case(IDC_EDIT_AGC_MIN_GAIN):
				m_wAGCMinGain = (WORD)iNewValue;
				if(m_wMaxGain < m_wAGCMinGain)
				{
					m_wAGCMinGain = m_wMaxGain;
				}
				bReval = StTrg_SetAGCMinGain(m_hCamera, m_wAGCMinGain);
				break;
			case(IDC_EDIT_AGC_MAX_GAIN):
				m_wAGCMaxGain = (WORD)iNewValue;
				if(m_wMaxGain < m_wAGCMaxGain)
				{
					m_wAGCMaxGain = m_wMaxGain;
				}
				bReval = StTrg_SetAGCMaxGain(m_hCamera, m_wAGCMaxGain);
				break;
			case(IDC_EDIT_WB_GAIN_R):
			case(IDC_EDIT_WB_GAIN_GR):
			case(IDC_EDIT_WB_GAIN_GB):
			case(IDC_EDIT_WB_GAIN_B):
				m_pwWhiteBalanceGain[nID - IDC_EDIT_WB_GAIN_R] = (WORD)iNewValue;
				if(511 < m_pwWhiteBalanceGain[nID - IDC_EDIT_WB_GAIN_R])
				{
					m_pwWhiteBalanceGain[nID - IDC_EDIT_WB_GAIN_R] = 511;
				}
				bReval = StTrg_SetWhiteBalanceGain(m_hCamera, m_pwWhiteBalanceGain[0], m_pwWhiteBalanceGain[1], m_pwWhiteBalanceGain[2], m_pwWhiteBalanceGain[3]); 
				break;
			case(IDC_EDIT_HUE):
				m_shtHue = (SHORT)iNewValue;
				if(1800 < m_shtHue)
				{
					m_shtHue = 1800;
				}
				else if(m_shtHue < -1800)
				{
					m_shtHue = -1800;
				}
				bReval = StTrg_SetHueSaturationMode(m_hCamera, m_byteHueSaturationMode, m_shtHue, m_wSaturation);
				break;
			case(IDC_EDIT_SATURATION):
				m_wSaturation = (WORD)iNewValue;
				if(200 < m_wSaturation)
				{
					m_wSaturation = 200;
				}
				bReval = StTrg_SetHueSaturationMode(m_hCamera, m_byteHueSaturationMode, m_shtHue, m_wSaturation);
				break;
			case(IDC_EDIT_TRIGGER_TIMING_EXPOSURE_DELAY):
			case(IDC_EDIT_TRIGGER_TIMING_STROBE_START_DELAY):
			case(IDC_EDIT_TRIGGER_TIMING_STROBE_END_DELAY):
			case(IDC_EDIT_TRIGGER_TIMING_OUTPUT_PULSE_DELAY):
			case(IDC_EDIT_TRIGGER_TIMING_OUTPUT_PULSE_DURATION):
			case(IDC_EDIT_TRIGGER_TIMING_READOUT_DELAY):
				{
					DWORD dwTimingNo = nID - IDC_EDIT_TRIGGER_TIMING_EXPOSURE_DELAY;
					m_pdwTriggerTiming[dwTimingNo] = (DWORD)iNewValue;

					if(IDC_EDIT_TRIGGER_TIMING_READOUT_DELAY == nID)
					{
						if(65535 < m_pdwTriggerTiming[dwTimingNo])
						{
							m_pdwTriggerTiming[dwTimingNo] = 65535;
						}
					}
					else
					{
						if(4094 < m_pdwTriggerTiming[dwTimingNo])
						{
							m_pdwTriggerTiming[dwTimingNo] = 4094;
						}

					}
					bReval = StTrg_SetTriggerTiming(m_hCamera, dwTimingNo, m_pdwTriggerTiming[dwTimingNo]);
				}
				break;
			case(IDC_EDIT_TRIGGER_TIMER_PERIOD):
				{

					do{
						bReval = m_pStCamera->StopTransfer();
						if(!bReval) break;
						
						UINT Delay, Resolution;
						m_pStCamera->GetPeriod(&Delay, &Resolution);

						Delay = static_cast <UINT>(iNewValue);
						m_pStCamera->SetPeriod(Delay, Resolution);

						bReval = m_pStCamera->StartTransfer();
					}while(0);
				}
				break;
				
			case(IDC_EDIT_IMAGE_OFFSET_X):
			case(IDC_EDIT_IMAGE_OFFSET_Y):
			case(IDC_EDIT_IMAGE_WIDTH):
			case(IDC_EDIT_IMAGE_HEIGHT):
				switch(nID)
				{
				case(IDC_EDIT_IMAGE_OFFSET_X):	m_dwOffsetX = static_cast <DWORD>(iNewValue);	break;
				case(IDC_EDIT_IMAGE_OFFSET_Y):	m_dwOffsetY = static_cast <DWORD>(iNewValue);	break;
				case(IDC_EDIT_IMAGE_WIDTH):		m_dwWidth = static_cast <DWORD>(iNewValue);	break;
				case(IDC_EDIT_IMAGE_HEIGHT):		m_dwHeight = static_cast <DWORD>(iNewValue);	break;
				}
				bReval = UpdateScanMode();
				break;
			case(IDC_SLIDER_V_BLANK_FOR_FPS):
				m_dwVBlankForFPS = (DWORD)iNewValue;
				bReval = UpdateVBlankForFPS();
				break;
			case(IDC_EDIT_SHARPNESS_GAIN):
				m_wSharpnessGain = (WORD)iNewValue;
				if(500 < m_wSharpnessGain)
				{
					m_wSharpnessGain = 500;
				}
				bReval = StTrg_SetSharpnessMode(m_hCamera, m_byteSharpnessMode, m_wSharpnessGain, m_byteSharpnessCoring);
				break;
			case(IDC_EDIT_SHARPNESS_CORING):
				m_byteSharpnessCoring = (BYTE)iNewValue;
				bReval = StTrg_SetSharpnessMode(m_hCamera, m_byteSharpnessMode, m_wSharpnessGain, m_byteSharpnessCoring);
				break;
			case(IDC_EDIT_Y_GAMMA_VALUE):
			case(IDC_EDIT_R_GAMMA_VALUE):
			case(IDC_EDIT_GR_GAMMA_VALUE):
			case(IDC_EDIT_GB_GAMMA_VALUE):
			case(IDC_EDIT_B_GAMMA_VALUE):
				{
					int index = nID - IDC_EDIT_Y_GAMMA_VALUE;
					m_pwGamma[index] = static_cast <WORD>(iNewValue);
					bReval = StTrg_SetGammaModeEx(m_hCamera, index, m_pbyteGammaMode[index], m_pwGamma[index], m_shtBrightness[index], m_byteContrast[index], m_ppbyteGammaTable[index]);	
				}
				break;
			case(IDC_EDIT_CAMERA_GAMMA_VALUE):
				m_wCameraGamma = (WORD)iNewValue;
				if(40 < m_wCameraGamma)
				{
					m_wCameraGamma = 40;
				}
				bReval = StTrg_SetCameraGammaValue(m_hCamera, m_wCameraGamma);
				break;
			case(IDC_EDIT_DIGITAL_CLAMP):
				m_wDigitalClamp = (WORD)iNewValue;
				if(255 < m_wDigitalClamp)
				{
					m_wDigitalClamp = 255;
				}
				bReval = StTrg_SetDigitalClamp(m_hCamera, m_wDigitalClamp);
				break;
		}
	}
	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CTabParentDlg::UpdateBySlider(HWND hWnd)
{
	BOOL bReval = TRUE;
	int nID = ::GetDlgCtrlID(hWnd);
	CSliderCtrl	objSliderCtrl;
	objSliderCtrl.Attach(hWnd);
	int iNewValue = objSliderCtrl.GetPos();
	objSliderCtrl.Detach();
	switch(nID)
	{
	case(IDC_SLIDER_EXPOSURE):
		m_dwExposureClock = static_cast <DWORD>(iNewValue);
		bReval = StTrg_SetExposureClock(m_hCamera, m_dwExposureClock);
		break;
	case(IDC_SLIDER_CDS_GAIN):
		m_wCDSGain = static_cast <WORD>(iNewValue);
		bReval = StTrg_SetGain(m_hCamera, m_wCDSGain);
		break;
	case(IDC_SLIDER_DIGITAL_GAIN):
		m_wDigitalGain = (WORD)iNewValue;
		bReval = StTrg_SetDigitalGain(m_hCamera, m_wDigitalGain);
		break;
	case(IDC_SLIDER_ALC_TARGET_LEVEL):
		m_wALCTargetLevel = static_cast <WORD>(iNewValue);
		bReval = StTrg_SetALCTargetLevel(m_hCamera, m_wALCTargetLevel);
		break;
	case(IDC_SLIDER_AE_MIN_EXPOSURE):
		m_dwAEMinExposureClock = static_cast <DWORD>(iNewValue);
		bReval = StTrg_SetAEMinExposureClock(m_hCamera, m_dwAEMinExposureClock);
		break;
	case(IDC_SLIDER_AE_MAX_EXPOSURE):
		m_dwAEMaxExposureClock = static_cast <DWORD>(iNewValue);
		bReval = StTrg_SetAEMaxExposureClock(m_hCamera, m_dwAEMaxExposureClock);
		break;
	case(IDC_SLIDER_AGC_MIN_GAIN):
		m_wAGCMinGain = static_cast <WORD>(iNewValue);
		bReval = StTrg_SetAGCMinGain(m_hCamera, m_wAGCMinGain);
		break;
	case(IDC_SLIDER_AGC_MAX_GAIN):
		m_wAGCMaxGain = static_cast <WORD>(iNewValue);
		bReval = StTrg_SetAGCMaxGain(m_hCamera, m_wAGCMaxGain);
		break;
	case(IDC_SLIDER_WB_GAIN_R):
	case(IDC_SLIDER_WB_GAIN_GR):
	case(IDC_SLIDER_WB_GAIN_GB):
	case(IDC_SLIDER_WB_GAIN_B):
		m_pwWhiteBalanceGain[nID - IDC_SLIDER_WB_GAIN_R] = (WORD)iNewValue;
		bReval = StTrg_SetWhiteBalanceGain(m_hCamera, m_pwWhiteBalanceGain[0], m_pwWhiteBalanceGain[1], m_pwWhiteBalanceGain[2], m_pwWhiteBalanceGain[3]); 
		break;
	case(IDC_SLIDER_HUE):
		m_shtHue = (SHORT)iNewValue;
		bReval = StTrg_SetHueSaturationMode(m_hCamera, m_byteHueSaturationMode, m_shtHue, m_wSaturation);
		break;
	case(IDC_SLIDER_SATURATION):
		m_wSaturation = (WORD)iNewValue;
		bReval = StTrg_SetHueSaturationMode(m_hCamera, m_byteHueSaturationMode, m_shtHue, m_wSaturation);
		break;
	case(IDC_SLIDER_TRIGGER_TIMING_EXPOSURE_DELAY):
	case(IDC_SLIDER_TRIGGER_TIMING_STROBE_START_DELAY):
	case(IDC_SLIDER_TRIGGER_TIMING_STROBE_END_DELAY):
	case(IDC_SLIDER_TRIGGER_TIMING_OUTPUT_PULSE_DELAY):
	case(IDC_SLIDER_TRIGGER_TIMING_OUTPUT_PULSE_DURATION):
	case(IDC_SLIDER_TRIGGER_TIMING_READOUT_DELAY):
		m_pdwTriggerTiming[nID - IDC_SLIDER_TRIGGER_TIMING_EXPOSURE_DELAY] = (DWORD)iNewValue;
		bReval = StTrg_SetTriggerTiming(m_hCamera, nID - IDC_SLIDER_TRIGGER_TIMING_EXPOSURE_DELAY, m_pdwTriggerTiming[nID - IDC_SLIDER_TRIGGER_TIMING_EXPOSURE_DELAY]);
		break;
	case(IDC_SLIDER_TRIGGER_TIMER_PERIOD):
		{

			do{
				bReval = m_pStCamera->StopTransfer();
				if(!bReval) break;
				
				UINT Delay, Resolution;
				m_pStCamera->GetPeriod(&Delay, &Resolution);

				Delay = static_cast <UINT>(iNewValue);
				m_pStCamera->SetPeriod(Delay, Resolution);

				bReval = m_pStCamera->StartTransfer();
			}while(0);
		}
		break;


	case(IDC_SLIDER_IMAGE_OFFSET_X):
	case(IDC_SLIDER_IMAGE_OFFSET_Y):
	case(IDC_SLIDER_IMAGE_WIDTH):
	case(IDC_SLIDER_IMAGE_HEIGHT):

		{
			switch(nID)
			{
			case(IDC_SLIDER_IMAGE_OFFSET_X):	m_dwOffsetX = static_cast <DWORD>(iNewValue);	break;
			case(IDC_SLIDER_IMAGE_OFFSET_Y):	m_dwOffsetY = static_cast <DWORD>(iNewValue);	break;
			case(IDC_SLIDER_IMAGE_WIDTH):		m_dwWidth = static_cast <DWORD>(iNewValue);	break;
			case(IDC_SLIDER_IMAGE_HEIGHT):		m_dwHeight = static_cast <DWORD>(iNewValue);	break;
			}
			do{
				bReval = m_pStCamera->StopTransfer();
				if(!bReval) break;

				bReval = StTrg_SetScanMode(m_hCamera, m_wScanMode, m_dwOffsetX, m_dwOffsetY, m_dwWidth, m_dwHeight);
				if(!bReval) break;

				bReval = StTrg_GetScanMode(m_hCamera, &m_wScanMode, &m_dwOffsetX, &m_dwOffsetY, &m_dwWidth, &m_dwHeight);
				if(!bReval) break;

				bReval = StTrg_GetFrameClock(m_hCamera, &m_wTotalLine, &m_wClockPerLine);
				if(!bReval) break;

				bReval = m_pStCamera->StartTransfer();
			}while(0);
		}
		break;
	case(IDC_SLIDER_V_BLANK_FOR_FPS):
		m_dwVBlankForFPS = static_cast <DWORD>(iNewValue);
		bReval = UpdateVBlankForFPS();
		break;
	case(IDC_SLIDER_SHARPNESS_GAIN):
		m_wSharpnessGain = static_cast <WORD>(iNewValue);
		bReval = StTrg_SetSharpnessMode(m_hCamera, m_byteSharpnessMode, m_wSharpnessGain, m_byteSharpnessCoring);
		break;
	case(IDC_SLIDER_SHARPNESS_CORING):
		m_byteSharpnessCoring = static_cast <BYTE>(iNewValue);
		bReval = StTrg_SetSharpnessMode(m_hCamera, m_byteSharpnessMode, m_wSharpnessGain, m_byteSharpnessCoring);
		break;

	case(IDC_SLIDER_Y_GAMMA_VALUE):
	case(IDC_SLIDER_R_GAMMA_VALUE):
	case(IDC_SLIDER_GR_GAMMA_VALUE):
	case(IDC_SLIDER_GB_GAMMA_VALUE):
	case(IDC_SLIDER_B_GAMMA_VALUE):
		{
			int index = nID - IDC_SLIDER_Y_GAMMA_VALUE;
			m_pwGamma[index] = static_cast <WORD>(iNewValue);
			bReval = StTrg_SetGammaModeEx(m_hCamera, index, m_pbyteGammaMode[index], m_pwGamma[index], m_shtBrightness[index], m_byteContrast[index], m_ppbyteGammaTable[index]);	
		}
		break;
	case(IDC_SLIDER_CAMERA_GAMMA_VALUE):
		m_wCameraGamma = static_cast <WORD>(iNewValue);
		bReval = StTrg_SetCameraGammaValue(m_hCamera, m_wCameraGamma);
		break;
	case(IDC_SLIDER_DIGITAL_CLAMP):
		m_wDigitalClamp = static_cast <WORD>(iNewValue);
		bReval = StTrg_SetDigitalClamp(m_hCamera, m_wDigitalClamp);
		break;
	}
	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
DWORD CTabParentDlg::GetMaxExposureClock(void)
{
	DWORD dwMaxExposureClock = 0;
	BOOL bReval = TRUE;
	switch(m_wScanMode)
	{
	case (STCAM_SCAN_MODE_AOI):
	case(STCAM_SCAN_MODE_PARTIAL_1):
	case(STCAM_SCAN_MODE_PARTIAL_2):
	case(STCAM_SCAN_MODE_PARTIAL_4):
	case(STCAM_SCAN_MODE_BINNING_PARTIAL_1):
	case(STCAM_SCAN_MODE_BINNING_PARTIAL_2):
	case(STCAM_SCAN_MODE_BINNING_PARTIAL_4):
		bReval = StTrg_GetMaxLongExposureClock(m_hCamera, &dwMaxExposureClock);
		break;
	default:
		bReval = StTrg_GetMaxShortExposureClock(m_hCamera, &dwMaxExposureClock);
		break;
	}

	return(dwMaxExposureClock);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CTabParentDlg::ReadCameraProperty(void)
{
	BOOL bReval = TRUE;
	INT i = 0;
	do{
		bReval = StTrg_GetScanMode(m_hCamera, &m_wScanMode, &m_dwOffsetX, &m_dwOffsetY, &m_dwWidth, &m_dwHeight);
		if(!bReval) break;

		bReval = StTrg_GetSkippingAndBinning(m_hCamera, &m_byteHSkipping, &m_byteVSkipping, &m_byteHBinning, &m_byteVBinning);
		if(!bReval) break;

		if(m_pStCamera->HasHBinningSum() || m_pStCamera->HasVBinningSum())
		{
			bReval = StTrg_GetBinningSumMode(m_hCamera, &m_wBinningSumMode);
			if(!bReval) break;
		}

		bReval = StTrg_GetClock(m_hCamera, &m_dwClockMode, &m_dwClock);
		if(!bReval) break;

		bReval = StTrg_GetTransferBitsPerPixel(m_hCamera, &m_dwTransferBitsPerPixel);
		if(!bReval) break;

		bReval = StTrg_GetFrameClock(m_hCamera, &m_wTotalLine, &m_wClockPerLine);
		if(!bReval) break;
		
		if(m_pStCamera->HasVBlankForFPS())
		{
			bReval = StTrg_GetVBlankForFPS(m_hCamera, &m_dwVBlankForFPS);
			if(!bReval) break;
		}


		bReval = StTrg_GetExposureClock(m_hCamera, &m_dwExposureClock);
		if(!bReval) break;

		bReval = StTrg_GetMaxGain(m_hCamera, &m_wMaxGain);
		if(!bReval) break;

		bReval = StTrg_GetGain(m_hCamera, &m_wCDSGain);
		if(!bReval) break;
		
		//DigitalGain
		if(m_pStCamera->HasDigitalGainFunction())
		{
			bReval = StTrg_GetDigitalGain(m_hCamera, &m_wDigitalGain);
			if(!bReval) break;
		}
		else
		{
			m_wDigitalGain = 64;
		}
		
		BOOL hasAE = m_pStCamera->HasAE();
		BOOL hasAGC = m_pStCamera->HasAGC();
		if(hasAE || hasAGC)
		{
			bReval = StTrg_GetALCMode(m_hCamera, &m_byteALCMode);
			if(!bReval) break;

			bReval = StTrg_GetALCTargetLevel(m_hCamera, &m_wALCTargetLevel);
			if(!bReval) break;
			
			if(hasAE)
			{
				bReval = StTrg_GetAEMaxExposureClock(m_hCamera, &m_dwAEMaxExposureClock);
				if(!bReval) break;
				bReval = StTrg_GetAEMinExposureClock(m_hCamera, &m_dwAEMinExposureClock);
				if(!bReval) break;
			}

			if(hasAGC)
			{
				bReval = StTrg_GetAGCMaxGain(m_hCamera, &m_wAGCMaxGain);
				if(!bReval) break;
				bReval = StTrg_GetAGCMinGain(m_hCamera, &m_wAGCMinGain);
				if(!bReval) break;
			}
		}

		//WB
		bReval = StTrg_GetWhiteBalanceMode(m_hCamera, &m_byteWhiteBalanceMode);
		if(!bReval) break;

		bReval = StTrg_GetWhiteBalanceGain(m_hCamera, &m_pwWhiteBalanceGain[0], &m_pwWhiteBalanceGain[1], &m_pwWhiteBalanceGain[2], &m_pwWhiteBalanceGain[3]);
		if(!bReval) break;

		//Hue/Saturation
		bReval = StTrg_GetHueSaturationMode(m_hCamera, &m_byteHueSaturationMode, &m_shtHue, &m_wSaturation);
		if(!bReval) break;

		//Sharpness
		bReval = StTrg_GetSharpnessMode(m_hCamera, &m_byteSharpnessMode, &m_wSharpnessGain, &m_byteSharpnessCoring);
		if(!bReval) break;

		//Gamma
		for(int index = 0; index < 5; index++)
		{
			bReval = StTrg_GetGammaModeEx(m_hCamera, index, &m_pbyteGammaMode[index], &m_pwGamma[index], &m_shtBrightness[index], &m_byteContrast[index], m_ppbyteGammaTable[index]);
			if(!bReval) break;
		}
		if(!bReval) break;

		if(m_pStCamera->HasCameraGamma())
		{
			bReval = StTrg_GetCameraGammaValue(m_hCamera, &m_wCameraGamma);
			if(!bReval) break;
		}

		if(m_pStCamera->HasDigitalClamp())
		{
			bReval = StTrg_GetDigitalClamp(m_hCamera, &m_wDigitalClamp);
			if(!bReval) break;
		}

		if(m_pStCamera->HasTriggerFunction())
		{
			//IO
			bReval = StTrg_GetIOExistence(m_hCamera, &m_dwIOExistence);
			if(!bReval) break;
			bReval = StTrg_GetIOPinDirection(m_hCamera, &m_dwIODirection);
			if(!bReval) break;
			
			for(i = 0; i< 4; i++)
			{
				bReval = StTrg_GetIOPinMode(m_hCamera, i, &m_pdwIOMode[i]);
				if(!bReval) break;
			}
			if(!bReval) break;
			
			bReval = StTrg_GetIOPinPolarity(m_hCamera, &m_dwIOPolarity);
			if(!bReval) break;
		
			bReval = StTrg_GetIOPinStatus(m_hCamera, &m_dwIOStatus);
			if(!bReval) break;

			//SW
			bReval = StTrg_GetSwStatus(m_hCamera, &m_dwSWStatus);
			if(!bReval) break;

			//Trigger
			bReval = StTrg_GetTriggerMode(m_hCamera, &m_dwTriggerMode);
			if(!bReval) break;
			m_pStCamera->m_dwTriggerMode = m_dwTriggerMode;

			//Trigger Timing
			for(i = 0; i < 6; i++)
			{
				bReval = StTrg_GetTriggerTiming(m_hCamera, i, &m_pdwTriggerTiming[i]);
				if(!bReval) break;
			}
			if(!bReval) break;
		}
		if(m_pStCamera->HasLEDFunction(0) || m_pStCamera->HasLEDFunction(1) )
		{
			//LED
			bReval = StTrg_GetLEDStatus(m_hCamera, &m_dwLEDStatus);
			if(!bReval) break;
		}

		
	}while(0);
	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CTabParentDlg::UppdateAllTabs()
{
	for(DWORD dwPos = 0; dwPos < m_dwListCount; dwPos++)
	{
		m_ppTabList[dwPos]->UpdateDisplay();
	}
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CTabParentDlg::OnButtonSettingFile(UINT nID) 
{
	BOOL bOpenFileDialog = (IDC_BUTTON_LOAD_SETTING == nID);
	

	CFileDialog dlg(bOpenFileDialog, TEXT("cfg"), m_pStCamera->m_szCameraName, 
		bOpenFileDialog?OFN_HIDEREADONLY:OFN_OVERWRITEPROMPT, 
		TEXT("CFG File(*.cfg)|*.cfg|All Files(*.*)|*.*||"), 
		this);

	BOOL bReval = TRUE;
	if(IDOK == dlg.DoModal())
	{
		do{
			bReval = m_pStCamera->StopTransfer();
			if(!bReval) break;


			bReval = m_pStCamera->SettingFile(bOpenFileDialog, dlg.GetPathName());
			if(!bReval) break;

			if(bOpenFileDialog)
			{
				bReval = ReadCameraProperty();
				UppdateAllTabs();
			}
			else
			{

			}
			if(!bReval) break;

			bReval = m_pStCamera->StartTransfer();
			if(!bReval) break;
		}while(0);
	}

}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CTabParentDlg::PostNcDestroy() 
{
	CDialog::PostNcDestroy();
	if(NULL != m_pImageView)
	{
		m_pImageView->SendMessage(WM_APP_SETTING_DIALOG_DESTROYED, 0, 0);
	}
	delete this;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CTabParentDlg::OnOK()
{
	DestroyWindow();
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CTabParentDlg::OnCancel()
{
	DestroyWindow();
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CTabParentDlg::OnButtonRefresh() 
{
	ReadCameraProperty();
	UppdateAllTabs();
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CTabParentDlg::UpdateScanMode()
{
	BOOL bReval = TRUE;
	do{
		bReval = m_pStCamera->StopTransfer();
		if(!bReval) break;

		bReval = StTrg_SetScanMode(m_hCamera, m_wScanMode, m_dwOffsetX, m_dwOffsetY, m_dwWidth, m_dwHeight);
		if(!bReval) break;

		bReval = StTrg_GetSkippingAndBinning(m_hCamera, &m_byteHSkipping, &m_byteVSkipping, &m_byteHBinning, &m_byteVBinning);
		if(!bReval) break;

		bReval = StTrg_GetScanMode(m_hCamera, &m_wScanMode, &m_dwOffsetX, &m_dwOffsetY, &m_dwWidth, &m_dwHeight);
		if(!bReval) break;

		bReval = StTrg_GetFrameClock(m_hCamera, &m_wTotalLine, &m_wClockPerLine);
		if(!bReval) break;

		bReval = m_pStCamera->StartTransfer();
	}while(0);
	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CTabParentDlg::UpdateBinnningSkipping()
{
	BOOL bReval = TRUE;
	do{
		bReval = m_pStCamera->StopTransfer();
		if(!bReval) break;

		bReval = StTrg_SetSkippingAndBinning(m_hCamera, m_byteHSkipping, m_byteVSkipping, m_byteHBinning, m_byteVBinning);
		if(!bReval) break;

		bReval = StTrg_GetSkippingAndBinning(m_hCamera, &m_byteHSkipping, &m_byteVSkipping, &m_byteHBinning, &m_byteVBinning);
		if(!bReval) break;

		bReval = StTrg_GetScanMode(m_hCamera, &m_wScanMode, &m_dwOffsetX, &m_dwOffsetY, &m_dwWidth, &m_dwHeight);
		if(!bReval) break;

		bReval = StTrg_GetFrameClock(m_hCamera, &m_wTotalLine, &m_wClockPerLine);
		if(!bReval) break;

		bReval = m_pStCamera->StartTransfer();
	}while(0);
	return(bReval);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CTabParentDlg::UpdateVBlankForFPS()
{
	BOOL bReval = TRUE;
	do{		
		DWORD dwMaxVBlankForFPS = m_pStCamera->GetMaxVBlankForFPS();
		if(dwMaxVBlankForFPS < m_dwVBlankForFPS)
		{
			m_dwVBlankForFPS = dwMaxVBlankForFPS;
		}

		bReval = StTrg_SetVBlankForFPS(m_hCamera, m_dwVBlankForFPS);
		if(!bReval) break;
	}while(0);
	return(bReval);
}
