// TimerFunc.cpp: CTimerFunc
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "TimerFunc.h"

//////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////

CTimerFunc::CTimerFunc():
	m_TimerID(0),
	m_Delay(1000),
	m_Resolution(0),
	m_bRunning(FALSE),
	m_dwEndTime(0)
{
	timeBeginPeriod(1);
	m_hTimerIDMutex = CreateMutex(NULL, FALSE, NULL);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
CTimerFunc::~CTimerFunc()
{
	if(0 != m_TimerID)
	{
		timeKillEvent(m_TimerID);
	}
	CloseHandle(m_hTimerIDMutex);
	timeEndPeriod(1);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CTimerFunc::SetPeriod(UINT Delay, UINT Resolution)
{
	m_Delay = Delay;
	m_Resolution = Resolution;
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CTimerFunc::GetPeriod(PUINT pDelay, PUINT pResolution)
{
	*pDelay = m_Delay;
	*pResolution = m_Resolution;
}



