#if !defined(AFX_TABPARENTDLG_H__533CECDD_4BF2_4FEC_95C1_983692B02543__INCLUDED_)
#define AFX_TABPARENTDLG_H__533CECDD_4BF2_4FEC_95C1_983692B02543__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// TabParentDlg.h
//

#include "TabChildBase.h"
#include "StCamera.h"

/////////////////////////////////////////////////////////////////////////////
// CTabParentDlg
#define MAX_TAB_COUNT 10
class CTabParentDlg : public CDialog
{
public:
	CView	*m_pImageView;
	HANDLE	m_hCamera;
	CStCamera	*m_pStCamera;

	CTabParentDlg(CWnd* pParent = NULL);

	BOOL DisplaySlider(HWND hWnd);
	BOOL DisplayStatic(HWND hWnd);
	BOOL DisplayEdit(HWND hWnd);
	BOOL DisplayCombo(HWND hWnd);
	BOOL DisplayButton(HWND hWnd);

	BOOL UpdateByEdit(HWND hWnd);
	BOOL UpdateBySlider(HWND hWnd);
	BOOL UpdateByCombo(HWND hWnd);
	BOOL UpdateByButton(HWND hWnd);
	
protected:
	DWORD GetMaxExposureClock(void);

	BOOL ReadCameraProperty(void);
	void GetTimeStrFromClock(DWORD dwClockNum, LPTSTR szTime)
	{
		double dblSecond = 0.0;
		if(0 < m_dwClock)
		{
			dblSecond = dwClockNum / (double)m_dwClock;
		}
		GetTimeStrFromSecond(dblSecond, szTime);
	};
	void GetTimeStrFromSecond(double dblSecond, LPTSTR szTime)
	{
		if(1.0 < dblSecond)
		{
			_stprintf(szTime, TEXT("%.1f s"), dblSecond);
		}
		else
		{ 
			double dblMiliSecond = dblSecond * 1000.0;
			if(1.0 < dblMiliSecond)
			{
				_stprintf(szTime, TEXT("%.1f ms"), dblMiliSecond);
			}
			else
			{
				double dblMicroSecond = dblMiliSecond * 1000.0;
				if(1.0 < dblMicroSecond)
				{
					_stprintf(szTime, TEXT("%.1f us"), dblMicroSecond);
				}
				else
				{
					double dlbNSecond = dblMicroSecond * 1000.0;
					_stprintf(szTime, TEXT("%.1f ns"), dlbNSecond);
				}
			}
		}
	};
public:
	//{{AFX_DATA(CTabParentDlg)
	enum { IDD = IDD_TAB_PARENT_DIALOG };
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CTabParentDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	virtual void PostNcDestroy();
	//}}AFX_VIRTUAL
	virtual void OnOK();
	virtual void OnCancel();

protected:
	CTabChildBase	*m_ppTabList[MAX_TAB_COUNT];
	DWORD	m_dwListCount;

	//Clock
	DWORD	m_dwClockMode;
	DWORD	m_dwClock;

	//Transfer Bits Per Pixel
	DWORD	m_dwTransferBitsPerPixel;

	//Frame Clock
	WORD	m_wTotalLine;
	WORD	m_wClockPerLine;

	//ALC
	BYTE	m_byteALCMode;
	WORD	m_wALCTargetLevel;

	//Exposure
	DWORD	m_dwExposureClock;
	DWORD	m_dwAEMaxExposureClock;
	DWORD	m_dwAEMinExposureClock;

	//Gain
	WORD	m_wCDSGain;
	WORD	m_wDigitalGain;
	WORD	m_wMaxGain;
	WORD	m_wAGCMaxGain;
	WORD	m_wAGCMinGain;



	//WB
	BYTE	m_byteWhiteBalanceMode;
	WORD	m_pwWhiteBalanceGain[4];

	//Hue/Saturation
	BYTE	m_byteHueSaturationMode;
	SHORT	m_shtHue;
	WORD	m_wSaturation;

	//Sharpness
	BYTE m_byteSharpnessMode;
	WORD m_wSharpnessGain;
	BYTE m_byteSharpnessCoring;

	//ScanMode
	WORD	m_wScanMode;
	DWORD	m_dwOffsetX;
	DWORD	m_dwOffsetY;
	DWORD	m_dwWidth;
	DWORD	m_dwHeight;

	//Binning & Skipping
	BYTE	m_byteHSkipping;
	BYTE	m_byteVSkipping;
	BYTE	m_byteHBinning;
	BYTE	m_byteVBinning;
	WORD	m_wBinningSumMode;

	//V Blanking for FPS
	DWORD	m_dwVBlankForFPS;

	//IO
	DWORD	m_dwIODirection;
	DWORD	m_pdwIOMode[4];
	DWORD	m_dwIOPolarity;
	DWORD	m_dwIOStatus;
	DWORD	m_dwIOExistence;

	//SW
	DWORD	m_dwSWStatus;

	//LED
	DWORD	m_dwLEDStatus;

	//Trigger
	DWORD	m_dwTriggerMode;
	DWORD	m_pdwTriggerTiming[6];

	//Gamma
	BYTE	m_pbyteGammaMode[5];
	WORD	m_pwGamma[5];
	SHORT	m_shtBrightness[5];
	BYTE	m_byteContrast[5];
	BYTE	m_ppbyteGammaTable[5][256];
	WORD	m_wCameraGamma;

	WORD	m_wDigitalClamp;

	void CreateTabs(void);
	void ShowTab(DWORD dwTabNo, int nCmdShow);
	void AddComboStr(CComboBox *pComboBox, LPCTSTR szItem, DWORD dwItemData, DWORD dwCurData, INT *pSelIndex)
	{
		int iIndex = pComboBox->GetCount();
		pComboBox->AddString(szItem);
		pComboBox->SetItemData(iIndex, dwItemData);
		if(dwItemData == dwCurData)
		{
			*pSelIndex = iIndex;
		}
	};
	BOOL UpdateScanMode();
	BOOL UpdateBinnningSkipping();
	BOOL UpdateVBlankForFPS();
	void UppdateAllTabs();
	BOOL IsAGCOn()
	{
		BOOL bValue = FALSE;
		switch(m_byteALCMode)
		{
		case(STCAM_ALCMODE_CAMERA_AE_AGC_ON):
		case(STCAM_ALCMODE_CAMERA_AGC_ON):
		case(STCAM_ALCMODE_PC_AE_AGC_ON):
		case(STCAM_ALCMODE_PC_AE_AGC_ONESHOT):
		case(STCAM_ALCMODE_PC_AGC_ON):
		case(STCAM_ALCMODE_PC_AGC_ONESHOT):
			bValue = TRUE;
			break;
		}
		return(bValue);
	};
	BOOL IsAEOn()
	{
		BOOL bValue = FALSE;
		switch(m_byteALCMode)
		{
		case (STCAM_ALCMODE_CAMERA_AE_AGC_ON):
		case (STCAM_ALCMODE_CAMERA_AE_ON):
		case (STCAM_ALCMODE_PC_AE_AGC_ON):
		case (STCAM_ALCMODE_PC_AE_AGC_ONESHOT):
		case (STCAM_ALCMODE_PC_AE_ON):
		case (STCAM_ALCMODE_PC_AE_ONESHOT):
			bValue = TRUE;
			break;
		}
		return(bValue);
	};

protected:

	//{{AFX_MSG(CTabParentDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnDestroy();
	afx_msg void OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSelchangingTab(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnButtonRefresh();
	//}}AFX_MSG
	afx_msg void OnButtonSettingFile(UINT nID);
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}

#endif // !defined(AFX_TABPARENTDLG_H__533CECDD_4BF2_4FEC_95C1_983692B02543__INCLUDED_)
