VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CFPS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private m_lMaxSampleCount As Long
Private m_plRcvTime() As Long
Private m_lPos As Long
Private m_lCurSampleCount As Long


Private Declare Function timeGetTime Lib "winmm.dll" () As Long
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Class_Initialize()
    m_lMaxSampleCount = 100
    
    m_lPos = m_lMaxSampleCount - 1
    m_lCurSampleCount = 0
    
    ReDim m_plRcvTime(m_lMaxSampleCount)
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Sub Rcv()
    m_lPos = m_lPos + 1
    If m_lMaxSampleCount <= m_lPos Then
        m_lPos = 0
    End If
    
    If m_lCurSampleCount < m_lMaxSampleCount Then
        m_lCurSampleCount = m_lCurSampleCount + 1
    End If
    m_plRcvTime(m_lPos) = timeGetTime()
    
        
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function GetFPS() As Double
    Dim lFirstPos As Long
    If m_lCurSampleCount < 2 Then
        GetFPS = 0#
        Exit Function
    End If
    
    If m_lMaxSampleCount <= m_lCurSampleCount Then
        If m_lPos < m_lMaxSampleCount - 1 Then
            lFirstPos = m_lPos + 1
        End If
    End If
    
    Dim lPeriod As Long
    lPeriod = m_plRcvTime(m_lPos) - m_plRcvTime(lFirstPos)
    If lPeriod = 0 Then
        GetFPS = 0#
    Else
        GetFPS = 1000# * (m_lCurSampleCount - 1) / lPeriod
    End If
    
            
End Function
