VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CStCamera"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Event OnUpdatePreviewImage()
Public Event OnExposureEnd(ByVal vlFrameNo As Long)
Public Event OnRcvError(ByVal vlErrorCode As Long)

Public Event OnUpdateTriggerMode()
Public Event OnUpdateWBMode()
Public Event OnNeedToClear()
Public Event OnUpdateBGRImageSize()


Private Declare Function GetPrivateProfileInt Lib "kernel32" Alias "GetPrivateProfileIntA" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Long, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long

'
Public g_lDefWndProc As Long
Attribute g_lDefWndProc.VB_VarHelpID = -1

Private m_hWnd As Long

Private m_hCamera As Long
Private m_bNowTransfer As Boolean

'Raw Image Information
Private m_pbyteRaw() As Byte
Private m_lRawImage As Long
Private m_dwRawBufferSize As Long
Private m_wColorArray As Integer
Private m_FrameNo As Long


'BGR Image Information
Private m_bHasImage As Boolean
Private m_pbyteBGR() As Byte
Private m_lBGRImage As Long
Private m_BGRWidth As Long
Private m_BGRHeight As Long
Private m_lBGRPixelFormat As Long
Private m_lDisplayPixelFormat As Long
Private m_byteColorInterpolationMode As Byte

'Version
Private m_dwFileVersionMS As Long
Private m_dwFileVersionLS As Long
Private m_dwProductVersionMS As Long
Private m_dwProductVersionLS As Long
Private m_wUSBVendorID As Integer
Private m_wUSBProductID As Integer
Private m_wFPGAVersion As Integer
Private m_wFirmVersion As Integer

'Camera ID
Private m_lCameraNo As Long
Private m_strCameraName As String

'Scan Mode
Private m_lCurrentRegion As Long
Private m_lMaxRegionCount As Long
Private m_alRegionMode() As Long
Private m_wScanMode As Integer
Private m_adwOffsetX() As Long
Private m_adwOffsetY() As Long
Private m_adwWidth() As Long
Private m_adwHeight() As Long
Private m_wEnableScanMode As Integer

Private m_dwMaximumImageWidth As Long
Private m_dwMaximumImageHeight As Long


'Binning Skipping
Private m_byteHSkipping As Byte
Private m_byteVSkipping As Byte
Private m_byteHBinning As Byte
Private m_byteVBinning As Byte
Private m_wBinningSumMode As Integer

'Transfer Bits Per Pixel
Private m_dwTransferBitsPerPixel As Long
Private m_dwEnableTransferBitsPerPixel As Long

'Frame Clock
Private m_wTotalVLine As Integer
Private m_wTotalHClock As Integer

'Clock
Private m_dwClockMode As Long
Private m_dwClock As Long
Private m_dwEnableCloclMode As Long
Private m_dwVBlankForFPS As Long
Private m_dwMaxVBlankForFPS As Long


'ALC
Private m_byteALCMode As Byte
Private m_wALCTargetLevel As Integer

Private m_dwAEMaxExposureClock As Long
Private m_dwAEMinExposureClock As Long

Private m_wAGCMaxGain As Integer
Private m_wAGCMinGain As Integer

'Exposure Clock
Private m_dwExposureClock As Long


'Gain
Private m_wMaxGain As Integer
Private m_wGain As Integer

'Digital Gain
Private m_wDigitalGainOffValue As Integer
Private m_wMaxDigitalGain As Integer
Private m_wDigitalGain As Integer

'WB
Private m_byteWBMode As Byte
Private m_pwWBGain(3) As Integer

'Mirror/Rotation
Private m_byteMirrorMode As Byte
Private m_byteRotationMode As Byte

'Hue Saturation/Color Matrix
Private m_byteHueSaturationMode As Byte
Private m_shtHue As Integer
Private m_wSaturation As Integer

Private m_byteColorMatrixMode As Byte
Private m_pshtColorMatrix(11) As Integer

'Sharpness
Private m_byteSharpnessMode As Byte
Private m_wSharpnessGain As Integer
Private m_byteSharpnessCoring As Byte

'
Private m_dwTriggerMode As Long

'NoiseReductionMode
Private m_dwNoiseReductionMode As Long

'Trigger Timing
Private m_pdwTriggerTiming(5) As Long

'Gamma
Private m_pbyteGammaMode(4) As Byte
Private m_pwGammaValue(4) As Integer
Private m_pshtGammaBrightness(4) As Integer
Private m_pbyteContrast(4) As Byte
Private m_pbyteGammaTable(255, 4) As Byte
Private m_wCameraGamma As Integer

'Clamp
Private m_wDigitalClamp As Integer
Private m_wMaxDigitalClamp As Integer
Private m_wAnalogBlackLevel As Integer
Private m_wMaxAnalogBlackLevel As Integer


'AdjustmentMode
Private m_dwAdjustmentMode As Long


'IO
Private m_dwIOExistence As Long
Private m_dwIODirection As Long
Private m_pdwIOMode(3) As Long
Private m_dwIOPolarity As Long
Private m_dwIOStatus As Long
Private m_dwSWStatus As Long
Private m_dwLEDStatus As Long
Private m_ResetSwitchEnabled As Boolean

'HDR
Private m_dwHDRType As Long
Private m_dwHDRParameterSize As Long
Private m_pdwHDRParameterBuffer() As Long

'Start/Stop
Private m_bAutoSubTrigger As Boolean
Private m_dwAutoSubTriggerTime As Long


'
Private m_lLastFrameNo As Long
Private m_lRcvCount As Long
Private m_lDropCount As Long
Private m_lPCSideDropCount As Long
Private m_objFPS As CFPS

Private m_dwALCSkipCount As Long
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get CameraTypeString() As String
    Dim strName As String
    Dim lReval As Long
    strName = String(1024, " ")
    If m_hCamera <> 0 Then
        lReval = StTrg_GetProductNameA(m_hCamera, strName, 1024)
    End If
    CameraTypeString = Trim(strName)
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get FPGAVesionString() As String
    FPGAVesionString = Right("0000" & Hex(m_wFPGAVersion), 4)
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get FirmVesionString() As String
    FirmVesionString = Right("0000" & Hex(m_wFirmVersion), 4)
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get SDKVersionString() As String
    SDKVersionString = (m_dwFileVersionMS \ &H10000) & "." & (m_dwFileVersionMS Mod &H10000) & "." & (m_dwFileVersionLS \ &H10000) & "." & (m_dwFileVersionLS Mod &H10000)
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get SoftTriggerIsEnable() As Boolean
    SoftTriggerIsEnable = False
    If (STCAM_TRIGGER_MODE_TYPE_FREE_RUN <> TMType) And _
        (STCAM_TRIGGER_MODE_SOURCE_SOFTWARE = TMSource) Then
        SoftTriggerIsEnable = True
        
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get SoftSubTriggerIsEnable() As Boolean
    SoftSubTriggerIsEnable = False
    If (STCAM_TRIGGER_MODE_TYPE_FREE_RUN <> TMType) And _
        (STCAM_TRIGGER_MODE_SOURCE_SOFTWARE = TMSource) And _
        (STCAM_TRIGGER_MODE_EXPTIME_START_STOP = TMExpTime) Then
        SoftSubTriggerIsEnable = True
        
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get SoftReadOutIsEnable() As Boolean
    SoftReadOutIsEnable = False
    If (STCAM_TRIGGER_MODE_TYPE_TRIGGER_RO = TMType) And _
        (STCAM_TRIGGER_MODE_READOUT_SOFTWARE = TMReadOutSource) Then
        SoftReadOutIsEnable = True
        
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get IsColorCamera() As Boolean
    If STCAM_COLOR_ARRAY_MONO = m_wColorArray Then
        IsColorCamera = False
    Else
        IsColorCamera = True
    End If
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get ExposureString() As String
    Dim fExposureTime As Single
    Dim lReval As Long
    fExposureTime = 0
    If m_hCamera <> 0 Then
        lReval = StTrg_GetExposureTimeFromClock(m_hCamera, ExposureClock, fExposureTime)
    End If
    If fExposureTime <> 0 Then
        ExposureString = "1/" & Format(1 / fExposureTime, "##0.0") & "[s]"
    Else
        ExposureString = "?"
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get CDSGainString() As String
    Dim fValue As Single
    Dim lReval As Long
    CDSGainString = ""
    If m_hCamera <> 0 Then
        If HasAnalogGain Then
            lReval = StTrg_GetGainDBFromSettingValue(m_hCamera, m_wGain, fValue)
            If lReval <> 0 Then
                CDSGainString = Format(fValue, "#0.00") & " dB"
            End If
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get DigitalGainString() As String
    Dim fValue As Single
    Dim lReval As Long
    DigitalGainString = ""
    If m_hCamera <> 0 Then
        lReval = StTrg_GetDigitalGainTimesFromSettingValue(m_hCamera, DigitalGain, fValue)
        If lReval <> 0 Then
            DigitalGainString = "x " & Format(fValue, "#0.00")
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get MaxDigitalGain() As Integer
    MaxDigitalGain = m_wMaxDigitalGain
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get DigitalGainOffValue() As Integer
    DigitalGainOffValue = m_wDigitalGainOffValue
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get AEMinExposureString() As String
    Dim fExposureTime As Single
    Dim lReval As Long
    fExposureTime = 0
    If m_hCamera <> 0 Then
        lReval = StTrg_GetExposureTimeFromClock(m_hCamera, AEMinExposureClock, fExposureTime)
    End If
    If fExposureTime <> 0 Then
        AEMinExposureString = "1/" & Format(1 / fExposureTime, "##0.0") & "[s]"
    Else
        AEMinExposureString = "?"
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get AEMaxExposureString() As String
    Dim fExposureTime As Single
    Dim lReval As Long
    fExposureTime = 0
    If m_hCamera <> 0 Then
        lReval = StTrg_GetExposureTimeFromClock(m_hCamera, AEMaxExposureClock, fExposureTime)
    End If
    If fExposureTime <> 0 Then
        AEMaxExposureString = "1/" & Format(1 / fExposureTime, "##0.0") & "[s]"
    Else
        AEMaxExposureString = "?"
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get AGCMinGainString() As String
    Dim fValue As Single
    Dim lReval As Long
    AGCMinGainString = ""
    If m_hCamera <> 0 Then
        If IsDigitalGainCtrl Then
            lReval = StTrg_GetDigitalGainTimesFromSettingValue(m_hCamera, m_wAGCMinGain, fValue)
            If lReval <> 0 Then
                AGCMinGainString = "x " & Format(fValue, "#0.00")
            End If
        Else
            lReval = StTrg_GetGainDBFromSettingValue(m_hCamera, m_wAGCMinGain, fValue)
            If lReval <> 0 Then
                AGCMinGainString = Format(fValue, "#0.00") & " dB"
            End If
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get AGCMaxGainString() As String
    Dim fValue As Single
    Dim lReval As Long
    AGCMaxGainString = ""
    If m_hCamera <> 0 Then
        If IsDigitalGainCtrl Then
            lReval = StTrg_GetDigitalGainTimesFromSettingValue(m_hCamera, m_wAGCMaxGain, fValue)
            If lReval <> 0 Then
                AGCMaxGainString = "x " & Format(fValue, "#0.00")
            End If
        Else
            lReval = StTrg_GetGainDBFromSettingValue(m_hCamera, m_wAGCMaxGain, fValue)
            If lReval <> 0 Then
                AGCMaxGainString = Format(fValue, "#0.00") & " dB"
            End If
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get TotalVLine() As Integer
    TotalVLine = m_wTotalVLine
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get TotalHClock() As Integer
    TotalHClock = m_wTotalHClock
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get MaxExposureClock() As Long
    Dim lReval As Long
    MaxExposureClock = 0
    If m_hCamera <> 0 Then
        Select Case m_wScanMode
            Case STCAM_SCAN_MODE_ROI, STCAM_SCAN_MODE_PARTIAL_1, STCAM_SCAN_MODE_PARTIAL_2, STCAM_SCAN_MODE_PARTIAL_4, STCAM_SCAN_MODE_BINNING_PARTIAL_1, STCAM_SCAN_MODE_BINNING_PARTIAL_2, STCAM_SCAN_MODE_BINNING_PARTIAL_4
                lReval = StTrg_GetMaxLongExposureClock(m_hCamera, MaxExposureClock)
            Case Else
                lReval = StTrg_GetMaxShortExposureClock(m_hCamera, MaxExposureClock)
        End Select
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get LastFrameNo() As Long
    LastFrameNo = m_lLastFrameNo
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get RcvCount() As Long
    RcvCount = m_lRcvCount
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get DropCount() As Long
    DropCount = m_lDropCount
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get PCSideDropCount() As Long
    PCSideDropCount = m_lPCSideDropCount
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get FPS() As Double
    FPS = m_objFPS.GetFPS()
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get TriggerMode() As Long
    TriggerMode = m_dwTriggerMode
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let TriggerMode(ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        Dim bTransfer As Boolean
        Dim hwnd As Long
        
        bTransfer = m_bNowTransfer
        If bTransfer Then
            hwnd = m_hWnd
            Call StopTransfer
        End If
            
        lReval = StTrg_SetTriggerMode(m_hCamera, value)
        If lReval <> 0 Then
            lReval = StTrg_GetTriggerMode(m_hCamera, m_dwTriggerMode)
            RaiseEvent OnUpdateTriggerMode
        End If
        If bTransfer Then
            Call StartTransfer(hwnd)
        End If
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get TMType() As Long
    TMType = m_dwTriggerMode And STCAM_TRIGGER_MODE_TYPE_MASK
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let TMType(ByVal value As Long)
    Dim lTriggerMode As Long
    lTriggerMode = TriggerMode
    lTriggerMode = lTriggerMode And (Not STCAM_TRIGGER_MODE_TYPE_MASK)
    TriggerMode = lTriggerMode Or value
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get TMCameraMemory() As Long
    TMCameraMemory = m_dwTriggerMode And STCAM_TRIGGER_MODE_CAMERA_MEMORY_MASK
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let TMCameraMemory(ByVal value As Long)
    Dim lTriggerMode As Long
    lTriggerMode = TriggerMode
    lTriggerMode = lTriggerMode And (Not STCAM_TRIGGER_MODE_CAMERA_MEMORY_MASK)
    TriggerMode = lTriggerMode Or value
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get TMTriggerMask() As Long
    TMCameraMemory = m_dwTriggerMode And STCAM_TRIGGER_MODE_TRIGGER_MASK_MASK
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let TMTriggerMask(ByVal value As Long)
    Dim lTriggerMode As Long
    lTriggerMode = TriggerMode
    lTriggerMode = lTriggerMode And (Not STCAM_TRIGGER_MODE_TRIGGER_MASK_MASK)
    TriggerMode = lTriggerMode Or value
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get TMCmosResetType() As Long
    TMCmosResetType = m_dwTriggerMode And STCAM_TRIGGER_MODE_CMOS_RESET_TYPE_MASK
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let TMCmosResetType(ByVal value As Long)
    Dim lTriggerMode As Long
    lTriggerMode = TriggerMode
    lTriggerMode = lTriggerMode And (Not STCAM_TRIGGER_MODE_CMOS_RESET_TYPE_MASK)
    TriggerMode = lTriggerMode Or value
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get TMReadOutSource() As Long
    TMReadOutSource = m_dwTriggerMode And STCAM_TRIGGER_MODE_READOUT_SOURCE_MASK
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let TMReadOutSource(ByVal value As Long)
    Dim lTriggerMode As Long
    lTriggerMode = TriggerMode
    lTriggerMode = lTriggerMode And (Not STCAM_TRIGGER_MODE_READOUT_SOURCE_MASK)
    TriggerMode = lTriggerMode Or value
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get TMExpEnd() As Long
    TMExpEnd = m_dwTriggerMode And STCAM_TRIGGER_MODE_EXPEND_MASK
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let TMExpEnd(ByVal value As Long)
    Dim lTriggerMode As Long
    lTriggerMode = TriggerMode
    lTriggerMode = lTriggerMode And (Not STCAM_TRIGGER_MODE_EXPEND_MASK)
    TriggerMode = lTriggerMode Or value
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get TMSource() As Long
    TMSource = m_dwTriggerMode And STCAM_TRIGGER_MODE_SOURCE_MASK
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let TMSource(ByVal value As Long)
    Dim lTriggerMode As Long
    lTriggerMode = TriggerMode
    lTriggerMode = lTriggerMode And (Not STCAM_TRIGGER_MODE_SOURCE_MASK)
    TriggerMode = lTriggerMode Or value
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get TMExpTime() As Long
    TMExpTime = m_dwTriggerMode And STCAM_TRIGGER_MODE_EXPTIME_MASK
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let TMExpTime(ByVal value As Long)
    Dim lTriggerMode As Long
    lTriggerMode = TriggerMode
    lTriggerMode = lTriggerMode And (Not STCAM_TRIGGER_MODE_EXPTIME_MASK)
    TriggerMode = lTriggerMode Or value
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get TMExposureWaitHD() As Long
    TMExposureWaitHD = m_dwTriggerMode And STCAM_TRIGGER_MODE_EXPOSURE_WAIT_HD_MASK
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let TMExposureWaitHD(ByVal value As Long)
    Dim lTriggerMode As Long
    lTriggerMode = TriggerMode
    lTriggerMode = lTriggerMode And (Not STCAM_TRIGGER_MODE_EXPOSURE_WAIT_HD_MASK)
    TriggerMode = lTriggerMode Or value
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get TMExposureWaitReadOut() As Long
    TMExposureWaitReadOut = m_dwTriggerMode And STCAM_TRIGGER_MODE_EXPOSURE_WAIT_READOUT_MASK
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get AutoSubTrigger() As Boolean
    AutoSubTrigger = m_bAutoSubTrigger
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let AutoSubTrigger(ByVal value As Boolean)
    m_bAutoSubTrigger = value
    RaiseEvent OnUpdateTriggerMode
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get AutoSubTriggerTime() As Long
    AutoSubTriggerTime = m_dwAutoSubTriggerTime
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let AutoSubTriggerTime(ByVal value As Long)
    m_dwAutoSubTriggerTime = value
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get AutoSubTriggerTimeString() As String
    
    
    Dim strReval As String
    Dim tmp As Long
    Dim min  As Long
    Dim sec As Long
    Dim msec As Long
    
    strReval = ""
    tmp = m_dwAutoSubTriggerTime
    min = tmp \ 60000
    If min Then
        strReval = min & "min "
        tmp = tmp Mod 60000
    End If
    sec = tmp \ 1000
    If sec Then
        strReval = strReval & sec & "s "
        tmp = tmp Mod 1000
    End If
    
    msec = tmp
    If msec Then
        strReval = strReval & msec & "ms"
    End If
    
    AutoSubTriggerTimeString = strReval
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let TMExposureWaitReadOut(ByVal value As Long)
    Dim lTriggerMode As Long
    lTriggerMode = TriggerMode
    lTriggerMode = lTriggerMode And (Not STCAM_TRIGGER_MODE_EXPOSURE_WAIT_READOUT_MASK)
    TriggerMode = lTriggerMode Or value
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get NoiseReductionMode() As Long
    NoiseReductionMode = m_dwNoiseReductionMode
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let NoiseReductionMode(ByVal value As Long)
    m_dwNoiseReductionMode = value
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get ExposureClock() As Long
    ExposureClock = m_dwExposureClock
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let ExposureClock(ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        Dim lMaxExposureClock As Long
        lMaxExposureClock = MaxExposureClock
        If lMaxExposureClock < value Then
            value = lMaxExposureClock
        ElseIf value < 0 Then
            value = 0
        End If
    
        lReval = StTrg_SetExposureClock(m_hCamera, value)
        If lReval <> 0 Then
            m_dwExposureClock = value
        End If
    End If
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get Clock() As Long
    Clock = m_dwClock
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get ClockMode() As Long
    ClockMode = m_dwClockMode
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let ClockMode(ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        Dim bTransfer As Boolean
        Dim hwnd As Long
        
        bTransfer = m_bNowTransfer
        If bTransfer Then
            hwnd = m_hWnd
            Call StopTransfer
        End If
            
        lReval = StTrg_SetClock(m_hCamera, value, m_dwClock)
        If lReval <> 0 Then
            If Not mbGetClock() Then
            
            End If
        End If
        If bTransfer Then
            Call StartTransfer(hwnd)
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get VBlankForFPS() As Long
    VBlankForFPS = m_dwVBlankForFPS
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let VBlankForFPS(ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        If HasVBlankForFPS() Then
            m_dwVBlankForFPS = value
            If m_dwMaxVBlankForFPS < m_dwVBlankForFPS Then
                m_dwVBlankForFPS = m_dwMaxVBlankForFPS
            End If
            lReval = StTrg_SetVBlankForFPS(m_hCamera, m_dwVBlankForFPS)
            If lReval <> 0 Then

            End If
        End If
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get MaxVBlankForFPS() As Long
    MaxVBlankForFPS = m_dwMaxVBlankForFPS
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get OutputFPS() As Single
    Dim lReval As Long
    OutputFPS = 0
    If m_hCamera <> 0 Then
        lReval = StTrg_GetOutputFPS(m_hCamera, OutputFPS)
        If lReval <> 0 Then

        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get Gain() As Integer
    Gain = m_wGain
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let Gain(ByVal value As Integer)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        If value < 0 Then
            value = 0
        ElseIf m_wMaxGain < value Then
            value = m_wMaxGain
        End If
        
        lReval = StTrg_SetGain(m_hCamera, value)
        If lReval <> 0 Then
            m_wGain = value
        End If

    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get MaxGain() As Integer
    MaxGain = m_wMaxGain
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get ALCMode() As Byte
    ALCMode = m_byteALCMode
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get IsAGCOn() As Boolean
    Select Case m_byteALCMode
        Case STCAM_ALCMODE_CAMERA_AE_AGC_ON, STCAM_ALCMODE_CAMERA_AGC_ON, STCAM_ALCMODE_PC_AE_AGC_ON, STCAM_ALCMODE_PC_AE_AGC_ONESHOT, STCAM_ALCMODE_PC_AGC_ON, STCAM_ALCMODE_PC_AGC_ONESHOT
            IsAGCOn = True
        Case Else
            IsAGCOn = False
    End Select
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get IsAEOn() As Boolean
    Select Case m_byteALCMode
        Case STCAM_ALCMODE_CAMERA_AE_AGC_ON, STCAM_ALCMODE_CAMERA_AE_ON, STCAM_ALCMODE_PC_AE_AGC_ON, STCAM_ALCMODE_PC_AE_AGC_ONESHOT, STCAM_ALCMODE_PC_AE_ON, STCAM_ALCMODE_PC_AE_ONESHOT
            IsAEOn = True
        Case Else
            IsAEOn = False
    End Select
End Property

    
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let ALCMode(ByVal value As Byte)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        lReval = StTrg_SetALCMode(m_hCamera, value)
        If lReval <> 0 Then
            m_byteALCMode = value
        End If
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get ALCTargetLevel() As Integer
    ALCTargetLevel = m_wALCTargetLevel
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let ALCTargetLevel(ByVal value As Integer)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        lReval = StTrg_SetALCTargetLevel(m_hCamera, value)
        If lReval <> 0 Then
            m_wALCTargetLevel = value
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get AEMaxExposureClock() As Long
    AEMaxExposureClock = m_dwAEMaxExposureClock
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let AEMaxExposureClock(ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        lReval = StTrg_SetAEMaxExposureClock(m_hCamera, value)
        If lReval <> 0 Then
            m_dwAEMaxExposureClock = value
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get AEMinExposureClock() As Long
    AEMinExposureClock = m_dwAEMinExposureClock
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let AEMinExposureClock(ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        lReval = StTrg_SetAEMinExposureClock(m_hCamera, value)
        If lReval <> 0 Then
            m_dwAEMinExposureClock = value
        End If
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get AGCMaxGain() As Integer
    AGCMaxGain = m_wAGCMaxGain
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let AGCMaxGain(ByVal value As Integer)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        lReval = StTrg_SetAGCMaxGain(m_hCamera, value)
        If lReval <> 0 Then
            m_wAGCMaxGain = value
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get AGCMinGain() As Integer
    AGCMinGain = m_wAGCMinGain
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let AGCMinGain(ByVal value As Integer)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        lReval = StTrg_SetAGCMinGain(m_hCamera, value)
        If lReval <> 0 Then
            m_wAGCMinGain = value
        End If
    End If
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get DigitalGain() As Integer
    DigitalGain = m_wDigitalGain
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let DigitalGain(ByVal value As Integer)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        If value < 0 Then
            value = 0
        ElseIf 511 < value Then
            value = 511
        End If
        
        lReval = StTrg_SetDigitalGain(m_hCamera, value)
        If lReval <> 0 Then
            m_wDigitalGain = value
        End If

    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get WBMode() As Byte
    WBMode = m_byteWBMode
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let WBMode(ByVal value As Byte)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        lReval = StTrg_SetWhiteBalanceMode(m_hCamera, value)
        If lReval <> 0 Then
            m_byteWBMode = value
            lReval = StTrg_GetWhiteBalanceGain(m_hCamera, m_pwWBGain(0), m_pwWBGain(1), m_pwWBGain(2), m_pwWBGain(3))
            If 0 = lReval Then
            
            End If

            RaiseEvent OnUpdateWBMode
        End If
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get WBGain(ByVal Color As Integer) As Integer
    WBGain = m_pwWBGain(Color)
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let WBGain(ByVal Color As Integer, ByVal value As Integer)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        If 511 < value Then
            value = 511
        End If
        m_pwWBGain(Color) = value
        lReval = StTrg_SetWhiteBalanceGain(m_hCamera, m_pwWBGain(0), m_pwWBGain(1), m_pwWBGain(2), m_pwWBGain(3))
    End If
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HueSaturationMode() As Byte
    HueSaturationMode = m_byteHueSaturationMode
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let HueSaturationMode(ByVal value As Byte)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        lReval = StTrg_SetHueSaturationMode(m_hCamera, value, m_shtHue, m_wSaturation)
        If lReval <> 0 Then
            m_byteHueSaturationMode = value
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get Hue() As Integer
    Hue = m_shtHue
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let Hue(ByVal value As Integer)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        If value < -1800 Then
            value = -1800
        ElseIf 1800 < value Then
            value = 1800
        End If
        lReval = StTrg_SetHueSaturationMode(m_hCamera, m_byteHueSaturationMode, value, m_wSaturation)
        If lReval <> 0 Then
            m_shtHue = value
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get Saturation() As Integer
    Saturation = m_wSaturation
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let Saturation(ByVal value As Integer)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        If value < 0 Then
            value = 0
        ElseIf 200 < value Then
            value = 200
        End If
        lReval = StTrg_SetHueSaturationMode(m_hCamera, m_byteHueSaturationMode, m_shtHue, value)
        If lReval <> 0 Then
            m_wSaturation = value
        End If
    End If
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HighChromaSuppressionStartLevel() As Integer
    Dim wStartLevel As Integer
    Dim wSuppression As Integer
    wStartLevel = 255
    wSuppression = 0
    If m_hCamera <> 0 Then
        Dim lReval As Long
        lReval = StTrg_GetChromaSuppression(m_hCamera, wStartLevel, wSuppression)
    End If
    HighChromaSuppressionStartLevel = wStartLevel
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let HighChromaSuppressionStartLevel(ByVal value As Integer)
    If m_hCamera <> 0 Then
        Dim lReval As Long
        lReval = StTrg_SetChromaSuppression(m_hCamera, value, HighChromaSuppressionSuppressionLevel)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HighChromaSuppressionSuppressionLevel() As Integer
    Dim wStartLevel As Integer
    Dim wSuppression As Integer
    wStartLevel = 255
    wSuppression = 0
    If m_hCamera <> 0 Then
        Dim lReval As Long
        lReval = StTrg_GetChromaSuppression(m_hCamera, wStartLevel, wSuppression)
    End If
    HighChromaSuppressionSuppressionLevel = wSuppression
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let HighChromaSuppressionSuppressionLevel(ByVal value As Integer)
    If m_hCamera <> 0 Then
        Dim lReval As Long
        lReval = StTrg_SetChromaSuppression(m_hCamera, HighChromaSuppressionStartLevel, value)
    End If
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get LowChromaSuppressionStartLevel() As Integer
    Dim wStartLevel As Integer
    Dim wSuppression As Integer
    wStartLevel = 255
    wSuppression = 0
    If m_hCamera <> 0 Then
        Dim lReval As Long
        lReval = StTrg_GetLowChromaSuppression(m_hCamera, wStartLevel, wSuppression)
    End If
    LowChromaSuppressionStartLevel = wStartLevel
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let LowChromaSuppressionStartLevel(ByVal value As Integer)
    If m_hCamera <> 0 Then
        Dim lReval As Long
        lReval = StTrg_SetLowChromaSuppression(m_hCamera, value, LowChromaSuppressionSuppressionLevel)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get LowChromaSuppressionSuppressionLevel() As Integer
    Dim wStartLevel As Integer
    Dim wSuppression As Integer
    wStartLevel = 255
    wSuppression = 0
    If m_hCamera <> 0 Then
        Dim lReval As Long
        lReval = StTrg_GetLowChromaSuppression(m_hCamera, wStartLevel, wSuppression)
    End If
    LowChromaSuppressionSuppressionLevel = wSuppression
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let LowChromaSuppressionSuppressionLevel(ByVal value As Integer)
    If m_hCamera <> 0 Then
        Dim lReval As Long
        lReval = StTrg_SetLowChromaSuppression(m_hCamera, LowChromaSuppressionStartLevel, value)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get ShadingCorrectionMode() As Long
    Dim dwMode As Long
    dwMode = 0
    If m_hCamera <> 0 Then
        Dim lReval As Long
        lReval = StTrg_GetShadingCorrectionMode(m_hCamera, dwMode)
    End If
    ShadingCorrectionMode = dwMode
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let ShadingCorrectionMode(ByVal value As Long)
    If m_hCamera <> 0 Then
        Dim lReval As Long
        lReval = StTrg_SetShadingCorrectionMode(m_hCamera, value)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get ShadingCorrectionTarget() As Integer
    Dim value As Integer
    value = 0
    If m_hCamera <> 0 Then
        Dim lReval As Long
        lReval = StTrg_GetShadingCorrectionTarget(m_hCamera, value)
    End If
    ShadingCorrectionTarget = value
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let ShadingCorrectionTarget(ByVal value As Integer)
    If m_hCamera <> 0 Then
        Dim lReval As Integer
        lReval = StTrg_SetShadingCorrectionTarget(m_hCamera, value)
    End If
End Property





'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get MaximumImageWidth() As Integer
    Dim lReval As Long
    If m_hCamera <> 0 Then
        If m_dwMaximumImageWidth = 0 Then
            lReval = StTrg_GetMaximumImageSize(m_hCamera, m_dwMaximumImageWidth, m_dwMaximumImageHeight)
        End If
    End If
    MaximumImageWidth = m_dwMaximumImageWidth
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get MaximumImageHeight() As Integer
    Dim lReval As Long
    If m_hCamera <> 0 Then
        If m_dwMaximumImageWidth = 0 Then
            lReval = StTrg_GetMaximumImageSize(m_hCamera, m_dwMaximumImageWidth, m_dwMaximumImageHeight)
        End If
    End If
    MaximumImageHeight = m_dwMaximumImageHeight
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get MaxRegionCount() As Long
    MaxRegionCount = m_lMaxRegionCount
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get CurrentRegion() As Long
    If m_wScanMode <> STCAM_SCAN_MODE_ROI Then
        m_lCurrentRegion = 0
    End If
    CurrentRegion = m_lCurrentRegion
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let CurrentRegion(ByVal value As Long)
    m_lCurrentRegion = value
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get RegionMode() As Long
    RegionMode = m_alRegionMode(CurrentRegion)
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let RegionMode(ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_alRegionMode(CurrentRegion) = value
        lReval = UpdateScanMode()
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get ScanMode() As Integer
    ScanMode = m_wScanMode
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let ScanMode(ByVal value As Integer)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_wScanMode = value
        lReval = UpdateScanMode()
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get ImageOffsetX() As Long
    ImageOffsetX = m_adwOffsetX(CurrentRegion)
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let ImageOffsetX(ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_adwOffsetX(CurrentRegion) = value
        lReval = UpdateScanMode()
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get ImageOffsetY() As Long
    ImageOffsetY = m_adwOffsetY(CurrentRegion)
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let ImageOffsetY(ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_adwOffsetY(CurrentRegion) = value
        lReval = UpdateScanMode()
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get ImageWidth() As Long
    ImageWidth = m_adwWidth(CurrentRegion)
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let ImageWidth(ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_adwWidth(CurrentRegion) = value
        lReval = UpdateScanMode()
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get ImageHeight() As Long
    ImageHeight = m_adwHeight(CurrentRegion)
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let ImageHeight(ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_adwHeight(CurrentRegion) = value
        lReval = UpdateScanMode()
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function UpdateScanMode() As Long
    Dim lReval As Long
    If m_hCamera <> 0 Then
        Dim bTransfer As Boolean
        Dim hwnd As Long
        Dim i As Long
        
        bTransfer = m_bNowTransfer
        If bTransfer Then
            hwnd = m_hWnd
            Call StopTransfer
        End If
       
        lReval = StTrg_SetScanMode(m_hCamera, m_wScanMode, m_adwOffsetX(0), m_adwOffsetY(0), m_adwWidth(0), m_adwHeight(0))
        If lReval <> 0 Then
            For i = 1 To m_lMaxRegionCount - 1
                lReval = StTrg_SetROI(m_hCamera, i, m_alRegionMode(i), m_adwOffsetX(i), m_adwOffsetY(i), m_adwWidth(i), m_adwHeight(i))
                If 0 = lReval Then
                    Exit For
                End If
            Next i
        End If
        If lReval <> 0 Then
            If Not mbGetScanMode() Then
            
            End If
            If Not mbGetSkippingBinning() Then
            
            End If
        End If
        If bTransfer Then
            Call StartTransfer(hwnd)
        End If
    End If
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HBinningSkipping() As Long
    HBinningSkipping = m_byteHBinning * 256 + m_byteHSkipping
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let HBinningSkipping(ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_byteHSkipping = value And &HFF
        m_byteHBinning = (value / 256) And &HFF
        lReval = UpdateBinningSkipping()
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get VBinningSkipping() As Long
    VBinningSkipping = m_byteVBinning * 256 + m_byteVSkipping
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let VBinningSkipping(ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_byteVSkipping = value And &HFF
        m_byteVBinning = (value / 256) And &HFF
        lReval = UpdateBinningSkipping()
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function UpdateBinningSkipping() As Long
    Dim lReval As Long
    If m_hCamera <> 0 Then
        Dim bTransfer As Boolean
        Dim hwnd As Long
        
        bTransfer = m_bNowTransfer
        If bTransfer Then
            hwnd = m_hWnd
            Call StopTransfer
        End If
       
        lReval = StTrg_SetSkippingAndBinning(m_hCamera, m_byteHSkipping, m_byteVSkipping, m_byteHBinning, m_byteVBinning)
        If lReval <> 0 Then
            If Not mbGetScanMode() Then
            
            End If
            If Not mbGetSkippingBinning() Then
            
            End If
        End If
        If bTransfer Then
            Call StartTransfer(hwnd)
        End If
    End If
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function mbGetSkippingBinning()
    mbGetSkippingBinning = True
    Dim lReval As Long
    lReval = StTrg_GetSkippingAndBinning(m_hCamera, m_byteHSkipping, m_byteVSkipping, m_byteHBinning, m_byteVBinning)
    If lReval <> 0 Then
        mbGetSkippingBinning = False
    End If
    
    lReval = StTrg_GetBinningSumMode(m_hCamera, m_wBinningSumMode)
    If lReval <> 0 Then
        mbGetSkippingBinning = False
    End If
    
    
    
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get BinningSumMode() As Long
    BinningSumMode = m_wBinningSumMode
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let BinningSumMode(ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_wBinningSumMode = value And &HFFFF
        lReval = StTrg_SetBinningSumMode(m_hCamera, m_wBinningSumMode)
        lReval = StTrg_GetBinningSumMode(m_hCamera, m_wBinningSumMode)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get TransferBitsPerPixel() As Long
    TransferBitsPerPixel = m_dwTransferBitsPerPixel
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let TransferBitsPerPixel(ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        Dim bTransfer As Boolean
        Dim hwnd As Long
        
        bTransfer = m_bNowTransfer
        If bTransfer Then
            hwnd = m_hWnd
            Call StopTransfer
        End If
       
        lReval = StTrg_SetTransferBitsPerPixel(m_hCamera, value)
        If lReval <> 0 Then
            m_dwTransferBitsPerPixel = value
        End If
        If bTransfer Then
            Call StartTransfer(hwnd)
        End If
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get DisplayPixelFormat() As Long
    DisplayPixelFormat = m_lDisplayPixelFormat
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let DisplayPixelFormat(ByVal value As Long)
    If m_hCamera <> 0 Then
        Dim bTransfer As Boolean
        Dim hwnd As Long
        
        bTransfer = m_bNowTransfer
        If bTransfer Then
            hwnd = m_hWnd
            Call StopTransfer
        End If
       
        m_lDisplayPixelFormat = value
  
        If bTransfer Then
            Call StartTransfer(hwnd)
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function IsSupportedTransferBitsPerPixel(ByVal lTransferBitsPerPixel As Long) As Boolean
    IsSupportedTransferBitsPerPixel = False
    If m_dwEnableTransferBitsPerPixel And lTransferBitsPerPixel Then
        IsSupportedTransferBitsPerPixel = True
    End If
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get ColorInterpolationMode() As Byte
    ColorInterpolationMode = m_byteColorInterpolationMode
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let ColorInterpolationMode(ByVal value As Byte)
    m_byteColorInterpolationMode = value
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get MirrorMode() As Byte
    MirrorMode = m_byteMirrorMode
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let MirrorMode(ByVal value As Byte)
    m_byteMirrorMode = value
    Dim lReval As Long
    Dim byteMirrorMode As Byte
    If m_hCamera <> 0 Then
        Dim bTransfer As Boolean
        Dim hwnd As Long
        
        bTransfer = m_bNowTransfer
        If bTransfer Then
            hwnd = m_hWnd
            Call StopTransfer
        End If
       
        byteMirrorMode = value And &HF0
        lReval = StTrg_SetMirrorMode(m_hCamera, byteMirrorMode)
        If lReval <> 0 Then
            
        End If
        If bTransfer Then
            Call StartTransfer(hwnd)
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get RotationMode() As Byte
    RotationMode = m_byteRotationMode
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let RotationMode(ByVal value As Byte)
    m_byteRotationMode = value
        
    m_bHasImage = False
    
    RaiseEvent OnNeedToClear
End Property



'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get SharpnessMode() As Byte
    SharpnessMode = m_byteSharpnessMode
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let SharpnessMode(ByVal value As Byte)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        lReval = StTrg_SetSharpnessMode(m_hCamera, value, m_wSharpnessGain, m_byteSharpnessCoring)
        If lReval <> 0 Then
            m_byteSharpnessMode = value
        End If
    End If
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get SharpnessGain() As Integer
    SharpnessGain = m_wSharpnessGain
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let SharpnessGain(ByVal value As Integer)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        If value < 0 Then
            value = 0
        ElseIf 500 < value Then
            value = 500
        End If
        lReval = StTrg_SetSharpnessMode(m_hCamera, m_byteSharpnessMode, value, m_byteSharpnessCoring)
        If lReval <> 0 Then
            m_wSharpnessGain = value
        End If
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get SharpnessCoring() As Integer
    SharpnessCoring = m_byteSharpnessCoring
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let SharpnessCoring(ByVal value As Integer)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        If value < 0 Then
            value = 0
        ElseIf 255 < value Then
            value = 255
        End If
        lReval = StTrg_SetSharpnessMode(m_hCamera, m_byteSharpnessMode, m_wSharpnessGain, value)
        If lReval <> 0 Then
            m_byteSharpnessCoring = value
        End If
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get GammaMode(ByVal Index As Integer) As Byte
    If Index <= STCAM_GAMMA_TARGET_B Then
        GammaMode = m_pbyteGammaMode(Index)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let GammaMode(ByVal Index As Integer, ByVal value As Byte)
    Dim lReval As Long
    If Index <= STCAM_GAMMA_TARGET_B Then
        If m_hCamera <> 0 Then
            m_pbyteGammaMode(Index) = value
            lReval = StTrg_SetGammaModeEx(m_hCamera, Index, m_pbyteGammaMode(Index), m_pwGammaValue(Index), m_pshtGammaBrightness(Index), m_pbyteContrast(Index), m_pbyteGammaTable(0, Index))
            If lReval <> 0 Then
                lReval = StTrg_GetGammaModeEx(m_hCamera, Index, m_pbyteGammaMode(Index), m_pwGammaValue(Index), m_pshtGammaBrightness(Index), m_pbyteContrast(Index), m_pbyteGammaTable(0, Index))
            End If
        End If
    End If
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get GammaValue(ByVal Index As Integer) As Integer
    If Index <= STCAM_GAMMA_TARGET_B Then
        GammaValue = m_pwGammaValue(Index)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let GammaValue(ByVal Index As Integer, ByVal value As Integer)
    Dim lReval As Long
    If Index <= STCAM_GAMMA_TARGET_B Then
        If m_hCamera <> 0 Then
            m_pwGammaValue(Index) = value
            lReval = StTrg_SetGammaModeEx(m_hCamera, Index, m_pbyteGammaMode(Index), m_pwGammaValue(Index), m_pshtGammaBrightness(Index), m_pbyteContrast(Index), m_pbyteGammaTable(0, Index))
            If lReval <> 0 Then
                lReval = StTrg_GetGammaModeEx(m_hCamera, Index, m_pbyteGammaMode(Index), m_pwGammaValue(Index), m_pshtGammaBrightness(Index), m_pbyteContrast(Index), m_pbyteGammaTable(0, Index))
            End If
        End If
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get CameraGamma() As Integer
    CameraGamma = m_wCameraGamma
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let CameraGamma(ByVal value As Integer)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_wCameraGamma = value
        lReval = StTrg_SetCameraGammaValue(m_hCamera, m_wCameraGamma)
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get DigitalClamp() As Integer
    DigitalClamp = m_wDigitalClamp
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get MaxDigitalClamp() As Integer
    MaxDigitalClamp = m_wMaxDigitalClamp
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let DigitalClamp(ByVal value As Integer)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_wDigitalClamp = value
        lReval = StTrg_SetDigitalClamp(m_hCamera, m_wDigitalClamp)
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get AnalogBlackLevel() As Integer
    AnalogBlackLevel = m_wAnalogBlackLevel
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get MaxAnalogBlackLevel() As Integer
    MaxAnalogBlackLevel = m_wMaxAnalogBlackLevel
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let AnalogBlackLevel(ByVal value As Integer)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_wAnalogBlackLevel = value
        lReval = StTrg_SetAnalogBlackLevel(m_hCamera, m_wAnalogBlackLevel)
    End If
End Property



'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get AdjustmentMode() As Long
    AdjustmentMode = m_dwAdjustmentMode
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let AdjustmentMode(ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_dwAdjustmentMode = value
        lReval = StTrg_SetAdjustmentMode(m_hCamera, m_dwAdjustmentMode)
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get EnableAdjustmentDigitalGain() As Boolean
    EnableAdjustmentDigitalGain = ((m_dwAdjustmentMode And STCAM_ADJUSTMENT_MODE_DIGITAL_GAIN) <> 0)
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let EnableAdjustmentDigitalGain(ByVal value As Boolean)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        If value Then
            m_dwAdjustmentMode = (m_dwAdjustmentMode Or STCAM_ADJUSTMENT_MODE_DIGITAL_GAIN)
        Else
            m_dwAdjustmentMode = (m_dwAdjustmentMode And (Not STCAM_ADJUSTMENT_MODE_DIGITAL_GAIN))
            lReval = StTrg_SetAdjustmentMode(m_hCamera, m_dwAdjustmentMode)
        End If
    End If
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get DeviceTemperatureMainBoard() As Long
    DeviceTemperatureMainBoard = 0
    Dim lReval As Long
    If m_hCamera <> 0 Then
        If HasDeviceTemperatureMainBoard() Then
            lReval = StTrg_GetDeviceTemperature(m_hCamera, STCAM_DEVICE_TEMPERATURE_MAINBOARD, DeviceTemperatureMainBoard)
        End If
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get TriggerTiming(ByVal Index As Integer) As Long
    TriggerTiming = m_pdwTriggerTiming(Index)
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let TriggerTiming(ByVal Index As Integer, ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        Dim Max As Long
        If STCAM_TRIGGER_TIMING_READOUT_DELAY = Index Then
            Max = 65535
        Else
            If IsIOUnitUs() Then
                Max = 262143
            Else
                Max = 4094
            End If
        End If
        If value < 0 Then
            value = 0
        ElseIf Max < value Then
            value = Max
        End If
        lReval = StTrg_SetTriggerTiming(m_hCamera, Index, value)
        If lReval <> 0 Then
            m_pdwTriggerTiming(Index) = value
        End If
    End If
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get TriggerTimingString(ByVal Index As Integer) As String
    Dim lClock As Long
    lClock = m_pdwTriggerTiming(Index)
    If IsIOUnitUs() Then
        TriggerTimingString = lClock & " us"
    Else
        If STCAM_TRIGGER_TIMING_READOUT_DELAY = Index Then
            lClock = lClock * m_wTotalHClock
        End If
        
        Dim strUnit As String
        Dim dSec As Double
        dSec = lClock / m_dwClock
        
        strUnit = " ns"
        Dim i As Long
        For i = 0 To 2
            If 1# < dSec Then
                Select Case i
                    Case 0
                        strUnit = " s"
                    Case 1
                        strUnit = " ms"
                    Case 2
                        strUnit = " us"
                End Select
                Exit For
            End If
            dSec = dSec * 1000#
        Next i
        TriggerTimingString = Format(dSec, "#0.0") & strUnit
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get IODirection(ByVal Index As Integer) As Long
    Dim lMask As Long
    lMask = 1
    
    Dim i As Long
    For i = 1 To Index
        lMask = lMask * 2
    Next i
    
    If lMask And m_dwIODirection Then
        IODirection = 1
    Else
        IODirection = 0
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let IODirection(ByVal Index As Integer, ByVal value As Long)
    Dim lMask As Long
    lMask = 1
    
    Dim i As Long
    For i = 1 To Index
        lMask = lMask * 2
    Next i
    
    
    Dim lReval As Long
    If m_hCamera <> 0 Then
        Dim NewValue As Long
        If value = 0 Then
            NewValue = m_dwIODirection And (Not lMask)
        Else
            NewValue = m_dwIODirection Or lMask
        End If
        
        lReval = StTrg_SetIOPinDirection(m_hCamera, NewValue)
        If lReval <> 0 Then
            m_dwIODirection = NewValue
        End If
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get IOPolarity(ByVal Index As Integer) As Long
    Dim lMask As Long
    lMask = 1
    
    Dim i As Long
    For i = 1 To Index
        lMask = lMask * 2
    Next i
    
    If lMask And m_dwIOPolarity Then
        IOPolarity = 1
    Else
        IOPolarity = 0
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let IOPolarity(ByVal Index As Integer, ByVal value As Long)
    Dim lMask As Long
    lMask = 1
    
    Dim i As Long
    For i = 1 To Index
        lMask = lMask * 2
    Next i
    
    
    Dim lReval As Long
    If m_hCamera <> 0 Then
        Dim NewValue As Long
        If value = 0 Then
            NewValue = m_dwIOPolarity And (Not lMask)
        Else
            NewValue = m_dwIOPolarity Or lMask
        End If
        
        lReval = StTrg_SetIOPinPolarity(m_hCamera, NewValue)
        If lReval <> 0 Then
            m_dwIOPolarity = NewValue
        End If
    End If
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get IOStatus(ByVal Index As Integer) As Long
    Dim lMask As Long
    lMask = 1
    
    Dim i As Long
    For i = 1 To Index
        lMask = lMask * 2
    Next i
    
    If lMask And m_dwIOStatus Then
        IOStatus = 1
    Else
        IOStatus = 0
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let IOStatus(ByVal Index As Integer, ByVal value As Long)
    Dim lMask As Long
    lMask = 1
    
    Dim i As Long
    For i = 1 To Index
        lMask = lMask * 2
    Next i
    
    
    Dim lReval As Long
    If m_hCamera <> 0 Then
        Dim NewValue As Long
        If value = 0 Then
            NewValue = m_dwIOStatus And (Not lMask)
        Else
            NewValue = m_dwIOStatus Or lMask
        End If
        
        lReval = StTrg_SetIOPinStatus(m_hCamera, NewValue)
        If lReval <> 0 Then
            m_dwIOStatus = NewValue
        End If
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get ResetSwitchEnabled() As Boolean
    ResetSwitchEnabled = m_ResetSwitchEnabled
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let ResetSwitchEnabled(ByVal value As Boolean)
  
    Dim lReval As Long
    If m_hCamera <> 0 Then
        lReval = StTrg_SetResetSwitchEnabled(m_hCamera, IIf(value, 1, 0))
        If lReval <> 0 Then
            m_ResetSwitchEnabled = value
        End If
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get LEDStatus() As Long
    LEDStatus = m_dwLEDStatus
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let LEDStatus(ByVal value As Long)
  
    Dim lReval As Long
    If m_hCamera <> 0 Then
        lReval = StTrg_SetLEDStatus(m_hCamera, value)
        If lReval <> 0 Then
            m_dwLEDStatus = value
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get LEDRed() As Long
    LEDRed = STCAM_LED_RED_ON And m_dwLEDStatus
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let LEDRed(ByVal value As Long)
  
    Dim lReval As Long
    If m_hCamera <> 0 Then
        Dim NewValue As Long
        If STCAM_LED_RED_ON = value Then
            NewValue = m_dwLEDStatus Or STCAM_LED_RED_ON
        Else
            NewValue = m_dwLEDStatus And (Not STCAM_LED_RED_ON)
        End If
        lReval = StTrg_SetLEDStatus(m_hCamera, NewValue)
        If lReval <> 0 Then
            m_dwLEDStatus = NewValue
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get LEDGreen() As Long
    LEDGreen = STCAM_LED_GREEN_ON And m_dwLEDStatus
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let LEDGreen(ByVal value As Long)
  
    Dim lReval As Long
    If m_hCamera <> 0 Then
        Dim NewValue As Long
        If STCAM_LED_GREEN_ON = value Then
            NewValue = m_dwLEDStatus Or STCAM_LED_GREEN_ON
        Else
            NewValue = m_dwLEDStatus And (Not STCAM_LED_GREEN_ON)
        End If
        lReval = StTrg_SetLEDStatus(m_hCamera, NewValue)
        If lReval <> 0 Then
            m_dwLEDStatus = NewValue
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get SWStatus(ByVal Index As Integer) As Long
    Dim lMask As Long
    lMask = 1
    
    Dim i As Long
    For i = 1 To Index
        lMask = lMask * 2
    Next i
    
    If lMask And m_dwSWStatus Then
        SWStatus = 1
    Else
        SWStatus = 0
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get IOMode(ByVal Index As Integer) As Long
    IOMode = m_pdwIOMode(Index)
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Let IOMode(ByVal Index As Integer, ByVal value As Long)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        lReval = StTrg_SetIOPinMode(m_hCamera, Index, value)
        If lReval <> 0 Then
            m_pdwIOMode(Index) = value
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function mbGetScanMode() As Boolean
    On Error GoTo ErrTrap
    mbGetScanMode = True
    Dim lReval As Long
    Dim i As Long
    

    'Get Image Size
    lReval = StTrg_GetScanMode(m_hCamera, m_wScanMode, m_adwOffsetX(0), m_adwOffsetY(0), m_adwWidth(0), m_adwHeight(0))
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    m_alRegionMode(0) = 1
    
    For i = 1 To m_lMaxRegionCount - 1
        lReval = StTrg_GetROI(m_hCamera, i, m_alRegionMode(i), m_adwOffsetX(i), m_adwOffsetY(i), m_adwWidth(i), m_adwHeight(i))
        If 0 = lReval Then
            GoTo ErrTrap
        End If
    Next i
    
    
    'Get FrameClock
    If Not mbGetFrameClock() Then
        GoTo ErrTrap
    End If

    'Create Buffer
    If Not mbCreateBuffer() Then
        GoTo ErrTrap
    End If
    
    RaiseEvent OnNeedToClear
    

Exit Function
ErrTrap:
    mbGetScanMode = False
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasLEDFunction(lIndex As Long) As Boolean
    HasLEDFunction = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        Dim lMask As Long
        lReval = StTrg_GetLEDExistence(m_hCamera, lValue)
        
        lMask = 1
        Do While 0 < lIndex
            lMask = lMask * 2
            lIndex = lIndex - 1
        Loop
        
        HasLEDFunction = IIf((lMask And lValue) <> 0, True, False)
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasMemoryFunction() As Boolean
    HasMemoryFunction = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_MEMORY, lValue)
        HasMemoryFunction = IIf(lValue <> 0, True, False)
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasTriggerMaskFunction() As Boolean
    HasTriggerMaskFunction = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_TRIGGER_MASK, lValue)
        HasTriggerMaskFunction = IIf(lValue <> 0, True, False)
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasTriggerThroughFunction() As Boolean
    HasTriggerThroughFunction = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_PHOTOCOUPLER, lValue)
        HasTriggerThroughFunction = Not IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasChangeIOFunction() As Boolean
    HasChangeIOFunction = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_IO_CHANGE_DIRECTION, lValue)
        HasChangeIOFunction = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasStartStopFunction() As Boolean
    HasStartStopFunction = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_STARTSTOP, lValue)
        HasStartStopFunction = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasHardwareStartStopFunction() As Boolean
    HasHardwareStartStopFunction = False
    If m_hCamera <> 0 Then
        If HasStartStopFunction Then
            Dim lReval As Long
            Dim lValue As Long
            lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_STARTSTOP_TRIGGER_SOURCE, lValue)
            HasHardwareStartStopFunction = Not IIf(lValue <> 0, True, False)
        End If
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasTriggerFunction() As Boolean
    HasTriggerFunction = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_TRIGGER, lValue)
        HasTriggerFunction = IIf(lValue <> 0, True, False)
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasVariablePertialFunction() As Boolean
    HasVariablePertialFunction = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_VARIABLE_PARTIAL, lValue)
        HasVariablePertialFunction = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasBinningPertialFunction() As Boolean
    HasBinningPertialFunction = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_BINNING_PARTIAL, lValue)
        HasBinningPertialFunction = IIf(lValue <> 0, True, False)
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasVGA90FPSFunction() As Boolean
    HasVGA90FPSFunction = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_VGA90FPS, lValue)
        HasVGA90FPSFunction = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function HasIOPin(lIndex As Long) As Boolean
    Dim lMask As Long
    lMask = 1
    Do While 0 < lIndex
        lMask = lMask * 2
        lIndex = lIndex - 1
    Loop
    HasIOPin = IIf((m_dwIOExistence And lMask) <> 0, True, False)
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function IsSupportedScanMode(wScanMode As Integer) As Boolean
    IsSupportedScanMode = False
    If m_wEnableScanMode And wScanMode Then
        IsSupportedScanMode = True
    End If
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasMirrorHorizontal() As Boolean
    HasMirrorHorizontal = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_MIRROR_HORIZONTAL, lValue)
        HasMirrorHorizontal = IIf(lValue <> 0, True, False)
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasMirrorVertical() As Boolean
    HasMirrorVertical = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_MIRROR_VERTICAL, lValue)
        HasMirrorVertical = IIf(lValue <> 0, True, False)
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasVBlankForFPS() As Boolean
    HasVBlankForFPS = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_V_BLANK_FOR_FPS, lValue)
        HasVBlankForFPS = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function IsSupportedClockMode(dwClockMode As Long) As Boolean
    IsSupportedClockMode = False
    If m_dwEnableCloclMode And dwClockMode Then
        IsSupportedClockMode = True
    End If
End Function


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasStartStopExposure() As Boolean
    HasStartStopExposure = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_STARTSTOP, lValue)
        HasStartStopExposure = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasPulseWidthExposure() As Boolean
    HasPulseWidthExposure = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_DISABLE_PULSE_WIDTH_EXPOSURE, lValue)
        HasPulseWidthExposure = IIf(lValue <> 0, False, True)  'Caution
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasReadOut() As Boolean
    HasReadOut = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_DISABLED_READOUT, lValue)
        HasReadOut = IIf(lValue <> 0, False, True)  'Caution
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get IsIOUnitUs() As Boolean
    IsIOUnitUs = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_IO_UNIT_US, lValue)
        IsIOUnitUs = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get GetSupportedCMOSResetType() As Long
    GetSupportedCMOSResetType = 0
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_CMOS_RESET_TYPE_0, lValue)
        If (lValue <> 0) Then
            GetSupportedCMOSResetType = GetSupportedCMOSResetType Or 1
        End If
        
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_CMOS_RESET_TYPE_1, lValue)
        If (lValue <> 0) Then
            GetSupportedCMOSResetType = GetSupportedCMOSResetType Or 2
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasTriggerValidOutput() As Boolean
    HasTriggerValidOutput = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_TRIGGER_VALID_OUT, lValue)
        HasTriggerValidOutput = IIf(lValue <> 0, True, False)
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasAE() As Boolean
    HasAE = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_AE, lValue)
        HasAE = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasAGC() As Boolean
    HasAGC = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_AGC, lValue)
        HasAGC = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasStoreCameraSetting() As Boolean
    HasStoreCameraSetting = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_STORE_CAMERA_SETTING, lValue)
        HasStoreCameraSetting = IIf(lValue <> 0, True, False)
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasCameraMemoryFunction() As Boolean
    HasCameraMemoryFunction = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_MEMORY, lValue)
        HasCameraMemoryFunction = IIf(lValue <> 0, True, False)
        If HasCameraMemoryFunction Then
            lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_DISABLE_MEMORY_TYPE_SELECTION, lValue)
            If lValue <> 0 Then
                HasCameraMemoryFunction = False
            End If
        End If
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasCameraGamma() As Boolean
    HasCameraGamma = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_CAMERA_GAMMA, lValue)
        HasCameraGamma = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasHBinningSum() As Boolean
    HasHBinningSum = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_H_BINNING_SUM, lValue)
        HasHBinningSum = IIf(lValue <> 0, True, False)
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasVBinningSum() As Boolean
    HasVBinningSum = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_V_BINNING_SUM, lValue)
        HasVBinningSum = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasExposureStartWaitHD() As Boolean
    HasExposureStartWaitHD = False
    If m_hCamera <> 0 Then
        If HasTriggerFunction() Then
            Dim lReval As Long
            Dim lValue As Long
            lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_DISABLE_EXPOSURE_START_WAIT_HD, lValue)
            HasExposureStartWaitHD = IIf(lValue <> 0, False, True)
        End If
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasExposureStartWaitReadOut() As Boolean
    HasExposureStartWaitReadOut = False
    If m_hCamera <> 0 Then
        If HasTriggerFunction() Then
            Dim lReval As Long
            Dim lValue As Long
            lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_DISABLE_EXPOSURE_START_WAIT_READ_OUT, lValue)
            HasExposureStartWaitReadOut = IIf(lValue <> 0, False, True)
        End If
    End If
End Property


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasDigitalClamp() As Boolean
    HasDigitalClamp = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_DIGITAL_CLAMP, lValue)
        HasDigitalClamp = IIf(lValue <> 0, True, False)
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasAnalogBlackLevel() As Boolean
    HasAnalogBlackLevel = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_ANALOG_BLACK_LEVEL, lValue)
        HasAnalogBlackLevel = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasResetSwitchDisabledFunction() As Boolean
    HasResetSwitchDisabledFunction = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_IO_RESET_SW_DISABLED, lValue)
        HasResetSwitchDisabledFunction = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasTransferEndOutput() As Boolean
    HasTransferEndOutput = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_TRANSFER_END_OUT, lValue)
        HasTransferEndOutput = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasAnalogGain() As Boolean
    HasAnalogGain = True
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_DISABLED_ANALOG_GAIN, lValue)
        HasAnalogGain = Not IIf(lValue <> 0, True, False)
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasAdjustmentModeDigitalGain() As Boolean
    HasAdjustmentModeDigitalGain = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_ADJUSTMENT_MODE_DIGITAL_GAIN, lValue)
        HasAdjustmentModeDigitalGain = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasDeviceTemperatureMainBoard() As Boolean
    HasDeviceTemperatureMainBoard = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_DEVICE_TEMPERATURE_MAINBOARD, lValue)
        HasDeviceTemperatureMainBoard = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get IsDigitalGainCtrl() As Boolean
    IsDigitalGainCtrl = False
    If m_hCamera <> 0 Then
        Dim lReval As Long
        Dim lValue As Long
        lReval = StTrg_HasFunction(m_hCamera, STCAM_CAMERA_FUNCTION_AGC_GAIN_TYPE, lValue)
        IsDigitalGainCtrl = IIf(lValue <> 0, True, False)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get ProductID() As Integer
    ProductID = m_wUSBProductID
End Property







'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HasImage() As Boolean
    HasImage = m_bHasImage
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Class_Initialize()
    On Error GoTo ErrTrap
    Set m_objFPS = New CFPS
    m_hCamera = 0

    m_lRcvCount = 0
    m_lDropCount = 0
    m_lLastFrameNo = 0
    m_lPCSideDropCount = 0

    m_wEnableScanMode = 0
    m_dwEnableCloclMode = 0
    m_dwVBlankForFPS = 0
    
    'ALC
    m_byteALCMode = STCAM_ALCMODE_OFF
    m_wALCTargetLevel = 128
    m_dwAEMaxExposureClock = 0
    m_dwAEMinExposureClock = 1
    m_wAGCMaxGain = 255
    m_wAGCMinGain = 0
    m_wMaxGain = 255
    
    'Binning Skipping
    m_byteHSkipping = 0
    m_byteVSkipping = 0
    m_byteHBinning = 0
    m_byteVBinning = 0
    m_wBinningSumMode = 0

    'Mirror/Rotation
    m_byteMirrorMode = STCAM_MIRROR_OFF
    m_byteRotationMode = STCAM_ROTATION_OFF

    'Hue Saturation/Color Matrix
    m_byteHueSaturationMode = STCAM_HUE_SATURATION_OFF
    m_shtHue = 0
    m_wSaturation = 100
    
    m_byteColorMatrixMode = STCAM_COLOR_MATRIX_OFF
    m_pshtColorMatrix(0) = 100: m_pshtColorMatrix(1) = 0: m_pshtColorMatrix(2) = 0: m_pshtColorMatrix(3) = 0
    m_pshtColorMatrix(4) = 0: m_pshtColorMatrix(5) = 100: m_pshtColorMatrix(6) = 0: m_pshtColorMatrix(7) = 0
    m_pshtColorMatrix(8) = 0: m_pshtColorMatrix(9) = 0: m_pshtColorMatrix(10) = 100: m_pshtColorMatrix(11) = 0
    
    'Sharpness
    m_byteSharpnessMode = STCAM_SHARPNESS_OFF
    m_wSharpnessGain = 0
    m_byteSharpnessCoring = 0
    
    'WB
    m_byteWBMode = STCAM_WB_OFF
    
    'NoiseReductionMode
    m_dwNoiseReductionMode = STCAM_NR_OFF
    
    'Auto Sub Trigger
    m_dwAutoSubTriggerTime = 5000
    
    Dim lReval As Long
    lReval = StTrg_GetDllVersion(m_dwFileVersionMS, m_dwFileVersionLS, m_dwProductVersionMS, m_dwProductVersionLS)
    If 0 = lReval Then
        m_dwFileVersionMS = 0
        m_dwFileVersionLS = 0
        m_dwProductVersionMS = 0
        m_dwProductVersionLS = 0
    End If
        
Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Class_Terminate()
    On Error GoTo ErrTrap
    
    Dim lReval As Long

    If 0 <> m_hCamera Then
        Call StopTransfer
        
        
        StTrg_Close (m_hCamera)
        m_hCamera = 0
    End If
    Set m_objFPS = Nothing
Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function mbCreateBuffer() As Boolean
    On Error GoTo ErrTrap
    mbCreateBuffer = True

    Dim lBGRBufferSize As Long
    Dim lReval As Long
    
    
    m_FrameNo = 0
     
    lReval = StTrg_GetRawDataSize(m_hCamera, m_dwRawBufferSize)
    
    
    'RAW
    ReDim m_pbyteRaw(m_dwRawBufferSize)
    m_lRawImage = VarPtr(m_pbyteRaw(0))
    
    'BGR
    m_bHasImage = False
    m_BGRWidth = 0
    m_BGRHeight = 0
    m_lBGRPixelFormat = 0

Exit Function
ErrTrap:
    mbCreateBuffer = False
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function mbGetFrameClock() As Boolean
    On Error GoTo ErrTrap
    mbGetFrameClock = True
    
    Dim lReval As Long
    lReval = StTrg_GetFrameClock(m_hCamera, m_wTotalVLine, m_wTotalHClock)
    If lReval = 0 Then
        GoTo ErrTrap
    End If

Exit Function
ErrTrap:
    mbGetFrameClock = False
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function mbGetClock() As Boolean
    On Error GoTo ErrTrap
    mbGetClock = True
    
    Dim lReval As Long
    lReval = StTrg_GetClock(m_hCamera, m_dwClockMode, m_dwClock)
    If lReval = 0 Then
        GoTo ErrTrap
    End If

Exit Function
ErrTrap:
    mbGetClock = False
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function mbGetHDRParameter() As Boolean
    On Error GoTo ErrTrap
    mbGetHDRParameter = True
    
    Dim lReval As Long
    lReval = StTrg_GetHDRType(m_hCamera, m_dwHDRType)
    If lReval = 0 Then
        GoTo ErrTrap
    End If
    
    If 0 < m_dwHDRType Then
        Dim pdwDummy(0) As Long
        m_dwHDRParameterSize = 0
        lReval = StTrg_GetHDRParameter(m_hCamera, pdwDummy(0), m_dwHDRParameterSize)
        If lReval = 0 Then
            GoTo ErrTrap
        End If
        
        ReDim m_pdwHDRParameterBuffer((m_dwHDRParameterSize / 4) - 1)
        
        lReval = StTrg_GetHDRParameter(m_hCamera, m_pdwHDRParameterBuffer(0), m_dwHDRParameterSize)
        If lReval = 0 Then
            GoTo ErrTrap
        End If
    End If
Exit Function
ErrTrap:
    mbGetHDRParameter = False
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function mbSetHDRParameter() As Boolean
    On Error GoTo ErrTrap
    mbSetHDRParameter = True
    
    Dim lReval As Long
    If 0 < m_dwHDRType Then
        lReval = StTrg_SetHDRParameter(m_hCamera, m_pdwHDRParameterBuffer(0), m_dwHDRParameterSize)
        If lReval = 0 Then
            GoTo ErrTrap
        End If
    End If
Exit Function
ErrTrap:
    mbSetHDRParameter = False
End Function


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HDRType() As Long
    HDRType = m_dwHDRType
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HDR_CMOSIS4M_Mode() As Byte
    HDR_CMOSIS4M_Mode = 0
    If ((Not IsNull(m_pdwHDRParameterBuffer)) And (0 <= UBound(m_pdwHDRParameterBuffer))) Then
        HDR_CMOSIS4M_Mode = (m_pdwHDRParameterBuffer(0) And 1)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------

Property Let HDR_CMOSIS4M_Mode(ByVal value As Byte)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        If value Then
            m_pdwHDRParameterBuffer(0) = (m_pdwHDRParameterBuffer(0) Or 1)
        Else
            m_pdwHDRParameterBuffer(0) = (m_pdwHDRParameterBuffer(0) And (Not 1))
            Call mbSetHDRParameter
        End If
    End If
End Property
Public Function ShiftR(ByVal value As Long, ByVal count As Long) As Long
    If count < 0 Then
        ShiftR = ShiftL(value, -count)
    Else
        Do While 0 < count
            If 0 <= value Then
                value = value / 2
            ElseIf value < 0 Then
                value = (value And &H7FFFFFFF)
                value = value / 2
                value = (value Or &O40000000)
            End If
            count = count - 1
        Loop
        ShiftR = value
    End If
End Function
Public Function ShiftL(ByVal value As Long, ByVal count As Long) As Long
    If count < 0 Then
        ShiftL = ShiftR(value, -count)
    Else
        Do While 0 < count
            If 0 <= value Then
                If &H40000000 <= value Then
                    value = (value And &H3FFFFFFF)
                    value = value * 2
                    value = (value Or &H80000000)
                Else
                    value = value * 2
                End If
                count = count - 1
            ElseIf value < 0 Then
                value = (value And &H7FFFFFFF)
            End If
        Loop
        ShiftL = value
    End If
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HDR_CMOSIS4M_SlopeNum() As Byte
    HDR_CMOSIS4M_SlopeNum = 0
    If ((Not IsNull(m_pdwHDRParameterBuffer)) And (0 <= UBound(m_pdwHDRParameterBuffer))) Then
        HDR_CMOSIS4M_SlopeNum = (ShiftR(m_pdwHDRParameterBuffer(0), 8) And 3)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------

Property Let HDR_CMOSIS4M_SlopeNum(ByVal value As Byte)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_pdwHDRParameterBuffer(0) = (m_pdwHDRParameterBuffer(0) And (Not &HFF00))
        m_pdwHDRParameterBuffer(0) = (m_pdwHDRParameterBuffer(0) Or ShiftL(value, 8))
        Call mbSetHDRParameter
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HDR_CMOSIS4M_Vlow3() As Byte
    HDR_CMOSIS4M_Vlow3 = 0
    If ((Not IsNull(m_pdwHDRParameterBuffer)) And (1 <= UBound(m_pdwHDRParameterBuffer))) Then
        HDR_CMOSIS4M_Vlow3 = (m_pdwHDRParameterBuffer(1) And &HFF)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------

Property Let HDR_CMOSIS4M_Vlow3(ByVal value As Byte)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_pdwHDRParameterBuffer(1) = (m_pdwHDRParameterBuffer(1) And (Not &HFF))
        m_pdwHDRParameterBuffer(1) = (m_pdwHDRParameterBuffer(1) Or value)
        Call mbSetHDRParameter
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HDR_CMOSIS4M_Vlow2() As Byte
    HDR_CMOSIS4M_Vlow2 = 0
    If ((Not IsNull(m_pdwHDRParameterBuffer)) And (1 <= UBound(m_pdwHDRParameterBuffer))) Then
        HDR_CMOSIS4M_Vlow2 = (ShiftR(m_pdwHDRParameterBuffer(1), 8) And &HFF)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------

Property Let HDR_CMOSIS4M_Vlow2(ByVal value As Byte)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_pdwHDRParameterBuffer(1) = (m_pdwHDRParameterBuffer(1) And (Not &HFF00))
        m_pdwHDRParameterBuffer(1) = (m_pdwHDRParameterBuffer(1) Or ShiftL(value, 8))
        Call mbSetHDRParameter
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HDR_CMOSIS4M_Knee2() As Byte
    HDR_CMOSIS4M_Knee2 = 0
    If ((Not IsNull(m_pdwHDRParameterBuffer)) And (1 <= UBound(m_pdwHDRParameterBuffer))) Then
        HDR_CMOSIS4M_Knee2 = (ShiftR(m_pdwHDRParameterBuffer(1), 16) And &HFF)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------

Property Let HDR_CMOSIS4M_Knee2(ByVal value As Byte)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_pdwHDRParameterBuffer(1) = (m_pdwHDRParameterBuffer(1) And (Not &HFF0000))
        m_pdwHDRParameterBuffer(1) = (m_pdwHDRParameterBuffer(1) Or ShiftL(value, 16))
        Call mbSetHDRParameter
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Property Get HDR_CMOSIS4M_Knee1() As Byte
    HDR_CMOSIS4M_Knee1 = 0
    If ((Not IsNull(m_pdwHDRParameterBuffer)) And (1 <= UBound(m_pdwHDRParameterBuffer))) Then
        HDR_CMOSIS4M_Knee1 = (ShiftR(m_pdwHDRParameterBuffer(1), 24) And &HFF)
    End If
End Property
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------

Property Let HDR_CMOSIS4M_Knee1(ByVal value As Byte)
    Dim lReval As Long
    If m_hCamera <> 0 Then
        m_pdwHDRParameterBuffer(1) = (m_pdwHDRParameterBuffer(1) And (Not &HFF000000))
        m_pdwHDRParameterBuffer(1) = (m_pdwHDRParameterBuffer(1) Or ShiftL(value, 24))
        Call mbSetHDRParameter
    End If
End Property

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function Refresh() As Boolean
    On Error GoTo ErrTrap
    Refresh = True
    Dim lReval As Long
    Dim i As Long

    'Get Camera Version
    lReval = StTrg_GetCameraVersion(m_hCamera, m_wUSBVendorID, m_wUSBProductID, m_wFPGAVersion, m_wFirmVersion)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    'Camera ID
    m_strCameraName = Space(250)
    lReval = StTrg_ReadCameraUserIDA(m_hCamera, m_lCameraNo, m_strCameraName, Len(m_strCameraName))
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    m_strCameraName = Left(m_strCameraName, InStr(1, m_strCameraName, vbNullChar) - 1)
    
    
    'Transfer Bits Per Pixel
    lReval = StTrg_GetEnableTransferBitsPerPixel(m_hCamera, m_dwEnableTransferBitsPerPixel)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    lReval = StTrg_GetTransferBitsPerPixel(m_hCamera, m_dwTransferBitsPerPixel)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    'Get Color Array
    lReval = StTrg_GetColorArray(m_hCamera, m_wColorArray)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    'Get Clock
    If Not mbGetClock() Then
        GoTo ErrTrap
    End If
    

    'Exposure
    lReval = StTrg_GetExposureClock(m_hCamera, m_dwExposureClock)
    If 0 = lReval Then
        GoTo ErrTrap
    End If

    'Gain
    lReval = StTrg_GetGain(m_hCamera, m_wGain)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    
    'WB
    If STCAM_COLOR_ARRAY_MONO <> m_wColorArray Then
        m_byteWBMode = STCAM_WB_ONESHOT
        lReval = StTrg_SetWhiteBalanceMode(m_hCamera, m_byteWBMode)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
    Else
        lReval = StTrg_GetWhiteBalanceMode(m_hCamera, m_byteWBMode)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
    End If
    
    'SetRawSnapShotBufferCount
    lReval = StTrg_SetRawSnapShotBufferCount(m_hCamera, 10)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    If HasTriggerFunction() Then
        'ALC
        If HasAE() Or HasAGC() Then
            lReval = StTrg_GetALCMode(m_hCamera, m_byteALCMode)
            If 0 = lReval Then
                GoTo ErrTrap
            End If
            
            lReval = StTrg_GetALCTargetLevel(m_hCamera, m_wALCTargetLevel)
            If 0 = lReval Then
                GoTo ErrTrap
            End If
            If HasAE() Then
                lReval = StTrg_GetAEMaxExposureClock(m_hCamera, m_dwAEMaxExposureClock)
                If 0 = lReval Then
                    GoTo ErrTrap
                End If
                
                lReval = StTrg_GetAEMinExposureClock(m_hCamera, m_dwAEMinExposureClock)
                If 0 = lReval Then
                    GoTo ErrTrap
                End If
            End If
            
            If HasAGC() Then
                lReval = StTrg_GetAGCMaxGain(m_hCamera, m_wAGCMaxGain)
                If 0 = lReval Then
                    GoTo ErrTrap
                End If
                
                lReval = StTrg_GetAGCMinGain(m_hCamera, m_wAGCMinGain)
                If 0 = lReval Then
                    GoTo ErrTrap
                End If
            End If
        End If
        
        'Digital Gain
        lReval = StTrg_GetDigitalGain(m_hCamera, m_wDigitalGain)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        'GetTriggerMode
        lReval = StTrg_GetTriggerMode(m_hCamera, m_dwTriggerMode)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
    
        'IO Direction
        lReval = StTrg_GetIOPinDirection(m_hCamera, m_dwIODirection)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        'IO Polarity
        lReval = StTrg_GetIOPinPolarity(m_hCamera, m_dwIOPolarity)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        'IO Status
        lReval = StTrg_GetIOPinStatus(m_hCamera, m_dwIOStatus)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        'IO Mode
        For i = 0 To UBound(m_pdwIOMode)
            lReval = StTrg_GetIOPinMode(m_hCamera, i, m_pdwIOMode(i))
            If 0 = lReval Then
                GoTo ErrTrap
            End If
        Next i
        
        'SW
        lReval = StTrg_GetSwStatus(m_hCamera, m_dwSWStatus)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        'ResetSwitch
        If HasResetSwitchDisabledFunction() Then
            Dim lValue As Long
            lReval = StTrg_GetResetSwitchEnabled(m_hCamera, lValue)
            If 0 = lReval Then
                GoTo ErrTrap
            End If
            m_ResetSwitchEnabled = (lValue <> 0)
        End If
    
        'Trigger Timing
        For i = 0 To UBound(m_pdwTriggerTiming)
            lReval = StTrg_GetTriggerTiming(m_hCamera, i, m_pdwTriggerTiming(i))
            If 0 = lReval Then
                GoTo ErrTrap
            End If
        Next i
        
        'Gamma
        For i = 0 To UBound(m_pbyteGammaMode)
            lReval = StTrg_GetGammaModeEx(m_hCamera, i, m_pbyteGammaMode(i), m_pwGammaValue(i), m_pshtGammaBrightness(i), m_pbyteContrast(i), m_pbyteGammaTable(0, i))
            If 0 = lReval Then
                GoTo ErrTrap
            End If
        Next i
        
        If HasCameraGamma() Then
            lReval = StTrg_GetCameraGammaValue(m_hCamera, m_wCameraGamma)
            If 0 = lReval Then
                GoTo ErrTrap
            End If
        End If
        
        'Clamp
        If HasDigitalClamp() Then
            lReval = StTrg_GetMaxDigitalClamp(m_hCamera, m_wMaxDigitalClamp)
            If 0 = lReval Then
                GoTo ErrTrap
            End If
            
            lReval = StTrg_GetDigitalClamp(m_hCamera, m_wDigitalClamp)
            If 0 = lReval Then
                GoTo ErrTrap
            End If
        End If
        
        If HasAnalogBlackLevel() Then
            lReval = StTrg_GetMaxAnalogBlackLevel(m_hCamera, m_wMaxAnalogBlackLevel)
            If 0 = lReval Then
                GoTo ErrTrap
            End If
            lReval = StTrg_GetAnalogBlackLevel(m_hCamera, m_wAnalogBlackLevel)
            If 0 = lReval Then
                GoTo ErrTrap
            End If
        End If
        
            
        
        'LED
        If HasLEDFunction(0) Or HasLEDFunction(1) Then
            lReval = StTrg_GetLEDStatus(m_hCamera, m_dwLEDStatus)
            If 0 = lReval Then
                GoTo ErrTrap
            End If
        End If
        
            
        'VBlankForFPS
        If HasVBlankForFPS() Then
            lReval = StTrg_GetMaxVBlankForFPS(m_hCamera, m_dwMaxVBlankForFPS)
            If 0 = lReval Then
                GoTo ErrTrap
            End If
        
        
            lReval = StTrg_GetVBlankForFPS(m_hCamera, m_dwVBlankForFPS)
            If 0 = lReval Then
                GoTo ErrTrap
            End If
        End If

        
        'Mirror
        lReval = StTrg_GetMirrorMode(m_hCamera, m_byteMirrorMode)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        
        'Adjustment Mode
        lReval = StTrg_GetAdjustmentMode(m_hCamera, m_dwAdjustmentMode)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        
        'HDR
        Call mbGetHDRParameter
    End If
Exit Function
ErrTrap:
    Refresh = False
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function OpenCamera() As Boolean
    On Error GoTo ErrTrap
    OpenCamera = True
  
    Dim lReval As Long
    
    Dim SelectCamera As frmSelectCamera
    Set SelectCamera = New frmSelectCamera
    m_hCamera = SelectCamera.GetCameraHandle()
    Unload SelectCamera
    Set SelectCamera = Nothing
    If m_hCamera = 0 Then
        GoTo ErrTrap
    End If
    
    
    
'    m_hCamera = StTrg_Open()
'    If -1 = m_hCamera Then
'        m_hCamera = 0
'        GoTo ErrTrap
'    End If

    If Not Refresh() Then
        GoTo ErrTrap
    End If
    
    'MaxROICount
    lReval = StTrg_GetMaxROICount(m_hCamera, m_lMaxRegionCount)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    ReDim m_alRegionMode(m_lMaxRegionCount - 1)
    ReDim m_adwOffsetX(m_lMaxRegionCount - 1)
    ReDim m_adwOffsetY(m_lMaxRegionCount - 1)
    ReDim m_adwWidth(m_lMaxRegionCount - 1)
    ReDim m_adwHeight(m_lMaxRegionCount - 1)
    m_lCurrentRegion = 0
    
    
    'EnableScanMode
    lReval = StTrg_GetEnableScanMode(m_hCamera, m_wEnableScanMode)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    'EnableClockMode
    lReval = StTrg_GetEnableClockMode(m_hCamera, m_dwEnableCloclMode)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    m_lDisplayPixelFormat = STCAM_PIXEL_FORMAT_08_MONO_OR_RAW
    m_byteColorInterpolationMode = STCAM_COLOR_INTERPOLATION_NONE_MONO
    If STCAM_COLOR_ARRAY_MONO <> m_wColorArray Then
        'm_lDisplayPixelFormat = STCAM_PIXEL_FORMAT_24_BGR
        'm_byteColorInterpolationMode = STCAM_COLOR_INTERPOLATION_BILINEAR
        m_lDisplayPixelFormat = STCAM_PIXEL_FORMAT_32_BGR
        m_byteColorInterpolationMode = STCAM_COLOR_INTERPOLATION_NEAREST_NEIGHBOR
    End If

    
    
    lReval = StTrg_GetWhiteBalanceGain(m_hCamera, m_pwWBGain(0), m_pwWBGain(1), m_pwWBGain(2), m_pwWBGain(3))
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    If Not mbGetScanMode() Then
        GoTo ErrTrap
    End If
    
    If Not mbGetSkippingBinning() Then
    
    End If

    'Max Gain
    lReval = StTrg_GetMaxGain(m_hCamera, m_wMaxGain)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    'Max Digital Gain
    lReval = StTrg_GetMaxDigitalGain(m_hCamera, m_wMaxDigitalGain)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    lReval = StTrg_GetDigitalGainSettingValueFromGainTimes(m_hCamera, 1#, m_wDigitalGainOffValue)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    


    lReval = StTrg_GetIOExistence(m_hCamera, m_dwIOExistence)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
          
Exit Function
ErrTrap:
    OpenCamera = False
    If 0 <> m_hCamera Then
        StTrg_Close (m_hCamera)
        m_hCamera = 0
    End If
        
End Function


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function ReadCameraUserID(ByRef rlCameraNo As Long, ByRef rstrCameraName As String) As Boolean
    On Error GoTo ErrTrap
    ReadCameraUserID = True
    
    If 0 = m_hCamera Then
        GoTo ErrTrap
    End If
    
    rlCameraNo = m_lCameraNo
    rstrCameraName = m_strCameraName

Exit Function
ErrTrap:
    ReadCameraUserID = False
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function WriteCameraUserID(ByVal vlCameraNo As Long, ByVal vstrCameraName As String) As Boolean
    On Error GoTo ErrTrap
    WriteCameraUserID = True
    
    If 0 = m_hCamera Then
        GoTo ErrTrap
    End If
    
    Dim lReval As Long
    
    lReval = StTrg_WriteCameraUserIDA(m_hCamera, vlCameraNo, vstrCameraName, Len(vstrCameraName))
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    m_strCameraName = Space(250)
    lReval = StTrg_ReadCameraUserIDA(m_hCamera, m_lCameraNo, m_strCameraName, Len(m_strCameraName))
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    m_strCameraName = Left(m_strCameraName, InStr(1, m_strCameraName, vbNullChar) - 1)
Exit Function
ErrTrap:
    WriteCameraUserID = False
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function StartTransfer(ByVal hwnd As Long) As Boolean
    On Error GoTo ErrTrap
    StartTransfer = True
    
    If 0 = m_hCamera Then
        GoTo ErrTrap
    End If
    
    Dim lReval As Long
    
    
    
    m_hWnd = hwnd
    
    'Set User Data
    SetWindowLong m_hWnd, GWL_USERDATA, ObjPtr(Me)
    
    'Set Window Proc
    g_lDefWndProc = SetWindowLong(m_hWnd, GWL_WNDPROC, AddressOf WindowProc)

    
    'Set Receive Message Window
    lReval = StTrg_SetRcvMsgWnd(m_hCamera, hwnd)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    'Start Transfer
    lReval = StTrg_StartTransfer(m_hCamera)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    m_bNowTransfer = True
Exit Function
ErrTrap:
    StartTransfer = False
    m_bNowTransfer = False
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function StopTransfer() As Boolean
    On Error GoTo ErrTrap
    StopTransfer = True
    
    If 0 = m_hCamera Then
        GoTo ErrTrap
    End If

    Dim lReval As Long
    lReval = StTrg_StopTransfer(m_hCamera)
    
    'Set Receive Message Window
    lReval = StTrg_SetRcvMsgWnd(m_hCamera, 0)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    Dim tmp As Long
    
    'Set Window Proc
    If 0 <> g_lDefWndProc Then
        tmp = SetWindowLong(m_hWnd, GWL_WNDPROC, g_lDefWndProc)
        g_lDefWndProc = 0
    End If
    
    'Set User Data
    SetWindowLong m_hWnd, GWL_USERDATA, 0&
    m_hWnd = 0

    m_bNowTransfer = False
Exit Function
ErrTrap:
    StopTransfer = False
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function SoftTrigger() As Boolean
    On Error GoTo ErrTrap
    SoftTrigger = True
    
    If 0 = m_hCamera Then
        GoTo ErrTrap
    End If
    
    Dim lReval As Long
    lReval = StTrg_SoftTrigger(m_hCamera)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    If (STCAM_TRIGGER_MODE_EXPTIME_START_STOP = TMExpTime) And m_bAutoSubTrigger Then
        Call mStartTimer
    End If
    
Exit Function
ErrTrap:
    SoftTrigger = False
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function SoftSubTrigger() As Boolean
    On Error GoTo ErrTrap
    SoftSubTrigger = True
    
    If 0 = m_hCamera Then
        GoTo ErrTrap
    End If
    
    Dim lReval As Long
    lReval = StTrg_SoftSubTrigger(m_hCamera)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
Exit Function
ErrTrap:
    SoftSubTrigger = False
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function ReadOut() As Boolean
    On Error GoTo ErrTrap
    ReadOut = True
    
    If 0 = m_hCamera Then
        GoTo ErrTrap
    End If
    
    Dim lReval As Long
    lReval = StTrg_TriggerReadOut(m_hCamera)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
Exit Function
ErrTrap:
    ReadOut = False
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function ResetFrameNo() As Boolean
    On Error GoTo ErrTrap
    ResetFrameNo = True
    
    If 0 = m_hCamera Then
        GoTo ErrTrap
    End If
    
    Dim lReval As Long
    lReval = StTrg_ResetCounter(m_hCamera)
    If 0 = lReval Then
        GoTo ErrTrap
    End If
Exit Function
ErrTrap:
    ResetFrameNo = False
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Sub ExposureEnd(ByVal vlFrameNo As Long)
    On Error GoTo ErrTrap
    
    'Event
    RaiseEvent OnExposureEnd(vlFrameNo)
Exit Sub
ErrTrap:
End Sub


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Sub TransferEnd(ByVal vlFrameNo As Long)
    On Error GoTo ErrTrap
    Dim lReval As Long
    
    Dim lNumberOfByteTrans As Long
    Dim lFrameNo As Long
    Dim BGRWidth As Long
    Dim BGRHeight As Long
    Dim wColorArray As Integer
    
    Dim lTransferBitsPerPixel As Long
    Dim lRawImageSize As Long
    
    Dim isMono As Boolean
    Dim pfAverage(3) As Single
    Dim wAverage As Integer
    Dim dwALCStatus As Long
    
    Dim lRawImage As Long
    Dim lBGRImage As Long
    
    
    lRawImage = m_lRawImage
    lBGRImage = m_lBGRImage
    
    
    If 0 <> m_hCamera Then
        lReval = StTrg_GetTransferBitsPerPixel(m_hCamera, lTransferBitsPerPixel)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        lRawImageSize = m_dwRawBufferSize
        'Take a Snap Shot
        lReval = StTrg_TakeRawSnapShot(m_hCamera, lRawImage, lRawImageSize, lNumberOfByteTrans, lFrameNo, 0)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        
        BGRWidth = m_adwWidth(0)
        BGRHeight = m_adwHeight(0)
        If 1 < m_lMaxRegionCount Then
            Dim lMultiWidth As Long
            Dim lMultiHeight As Long
            Dim lMultiLinePitch As Long
            lReval = StTrg_DecodingCombinedMultiROI(m_hCamera, STCAM_DECODING_COMBINED_MULTI_ROI_EXCEPT_BLANK_ROW_AND_COL, lRawImage, lRawImage, lMultiWidth, lMultiHeight, lMultiLinePitch)
    
            BGRWidth = lMultiWidth
            BGRHeight = lMultiHeight
        End If
        
        If (m_BGRWidth < BGRWidth) Or (m_BGRHeight < BGRHeight) Or (m_lDisplayPixelFormat <> m_lBGRPixelFormat) Then
            m_bHasImage = False
            Dim lBGRBufferSize As Long
            lBGRBufferSize = BGRWidth
            m_lBGRPixelFormat = m_lDisplayPixelFormat
            If m_lBGRPixelFormat = STCAM_PIXEL_FORMAT_24_BGR Then
                lBGRBufferSize = lBGRBufferSize * 3
            ElseIf m_lBGRPixelFormat = STCAM_PIXEL_FORMAT_32_BGR Then
                lBGRBufferSize = lBGRBufferSize * 4
            End If
            If (lBGRBufferSize And 3) <> 0 Then
                lBGRBufferSize = lBGRBufferSize + 4 - (lBGRBufferSize And 3)
            End If
            lBGRBufferSize = lBGRBufferSize * BGRHeight
            ReDim m_pbyteBGR(lBGRBufferSize)
            m_BGRWidth = BGRWidth
            m_BGRHeight = BGRHeight
            m_lBGRImage = VarPtr(m_pbyteBGR(0))
            lBGRImage = m_lBGRImage
        End If
            
        If (STCAM_TRANSFER_BITS_PER_PIXEL_BGR_08 = lTransferBitsPerPixel) Or _
            (STCAM_TRANSFER_BITS_PER_PIXEL_BGR_10 = lTransferBitsPerPixel) Then
            'BGR8,10->m_lBGRPixelFormat
            
            lReval = StTrg_ConvYUVOrBGRToBGRImage(BGRWidth, BGRHeight, lTransferBitsPerPixel, lRawImage, m_lBGRPixelFormat, lBGRImage)
            If 0 = lReval Then
                GoTo ErrTrap
            End If
        Else
            'RAW or MONO
            If (STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10 = lTransferBitsPerPixel) Or _
                (STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12 = lTransferBitsPerPixel) Or _
                (STCAM_TRANSFER_BITS_PER_PIXEL_MONO_14 = lTransferBitsPerPixel) Or _
                (STCAM_TRANSFER_BITS_PER_PIXEL_MONO_16 = lTransferBitsPerPixel) Or _
                (STCAM_TRANSFER_BITS_PER_PIXEL_RAW_10 = lTransferBitsPerPixel) Or _
                (STCAM_TRANSFER_BITS_PER_PIXEL_RAW_12 = lTransferBitsPerPixel) Or _
                (STCAM_TRANSFER_BITS_PER_PIXEL_RAW_14 = lTransferBitsPerPixel) Or _
                (STCAM_TRANSFER_BITS_PER_PIXEL_RAW_16 = lTransferBitsPerPixel) Then
                '16bits
                lReval = StTrg_ConvTo8BitsImage(BGRWidth, BGRHeight, lTransferBitsPerPixel, lRawImage, lRawImage)
                If 0 = lReval Then
                    GoTo ErrTrap
                End If
            End If

            wColorArray = m_wColorArray
            If m_byteMirrorMode And &HF0 Then
                If m_byteMirrorMode And STCAM_MIRROR_HORIZONTAL_CAMERA Then
                    If m_byteMirrorMode And STCAM_MIRROR_VERTICAL_CAMERA Then
                        'Horizontal and Vertical
                        Select Case wColorArray
                            Case STCAM_COLOR_ARRAY_RGGB
                                wColorArray = STCAM_COLOR_ARRAY_BGGR
                            Case STCAM_COLOR_ARRAY_GRBG
                                wColorArray = STCAM_COLOR_ARRAY_GBRG
                            Case STCAM_COLOR_ARRAY_BGGR
                                wColorArray = STCAM_COLOR_ARRAY_RGGB
                            Case STCAM_COLOR_ARRAY_GBRG
                                wColorArray = STCAM_COLOR_ARRAY_GRBG
                       End Select
                    Else
                        'Horizontal
                        Select Case wColorArray
                            Case STCAM_COLOR_ARRAY_RGGB
                                wColorArray = STCAM_COLOR_ARRAY_GRBG
                            Case STCAM_COLOR_ARRAY_GRBG
                                wColorArray = STCAM_COLOR_ARRAY_RGGB
                            Case STCAM_COLOR_ARRAY_BGGR
                                wColorArray = STCAM_COLOR_ARRAY_GBRG
                            Case STCAM_COLOR_ARRAY_GBRG
                                wColorArray = STCAM_COLOR_ARRAY_BGGR
                       End Select
                    End If
                ElseIf m_byteMirrorMode And STCAM_MIRROR_VERTICAL_CAMERA Then
                    'Vertical
                        Select Case wColorArray
                            Case STCAM_COLOR_ARRAY_RGGB
                                wColorArray = STCAM_COLOR_ARRAY_GBRG
                            Case STCAM_COLOR_ARRAY_GRBG
                                wColorArray = STCAM_COLOR_ARRAY_BGGR
                            Case STCAM_COLOR_ARRAY_BGGR
                                wColorArray = STCAM_COLOR_ARRAY_GRBG
                            Case STCAM_COLOR_ARRAY_GBRG
                                wColorArray = STCAM_COLOR_ARRAY_RGGB
                       End Select
                End If
            End If
            
            If (STCAM_TRANSFER_BITS_PER_PIXEL_MONO_08 = lTransferBitsPerPixel) Or _
                (STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10 = lTransferBitsPerPixel) Or _
                (STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12 = lTransferBitsPerPixel) Or _
                (STCAM_TRANSFER_BITS_PER_PIXEL_MONO_14 = lTransferBitsPerPixel) Or _
                (STCAM_TRANSFER_BITS_PER_PIXEL_MONO_16 = lTransferBitsPerPixel) Then
                wColorArray = STCAM_COLOR_ARRAY_MONO
                isMono = True
            Else
                isMono = False
            End If
                
            'PC Side ALC
            If (Not HasAE) And (Not HasAGC) Then
                If 0 < m_dwALCSkipCount Then
                    m_dwALCSkipCount = m_dwALCSkipCount - 1
                Else
                    If m_byteALCMode <> STCAM_ALCMODE_OFF Then
                        lReval = StTrg_GetAveragePixelValue(BGRWidth, BGRHeight, wColorArray, STCAM_TRANSFER_BITS_PER_PIXEL_RAW_08, lRawImage, 0, 0, BGRWidth, BGRHeight, pfAverage(0))
                        If 0 = lReval Then
                            GoTo ErrTrap
                        End If
                    
                        If STCAM_COLOR_ARRAY_MONO = wColorArray Then
                            wAverage = pfAverage(0)                         'B/W
                        Else
                            wAverage = (pfAverage(1) + pfAverage(2)) / 2    '(Gr + Gb) / 2
                        End If
                        lReval = StTrg_ALC(m_hCamera, wAverage, dwALCStatus)
                        If 0 = lReval Then
                            GoTo ErrTrap
                        End If
                        
                        If dwALCStatus And 3 Then
                            If TMType <> STCAM_TRIGGER_MODE_TYPE_MASK Then
                                m_dwALCSkipCount = 5
                            End If
                        End If
                        
                    End If
                End If
            End If
                
                
            'NoiseReduction
            If (STCAM_TRIGGER_MODE_TYPE_FREE_RUN <> TMType) And (STCAM_TRIGGER_MODE_EXPTIME_EDGE_PRESET <> TMExpTime) Then
                lReval = StTrg_NoiseReduction(m_hCamera, m_dwNoiseReductionMode, BGRWidth, BGRHeight, m_wColorArray, lRawImage)
                If 0 = lReval Then
                    GoTo ErrTrap
                End If
            End If
            
            'Shading Correction
            lReval = StTrg_ShadingCorrection(m_hCamera, BGRWidth, BGRHeight, BGRWidth, lRawImage, 8)
            If 0 = lReval Then
                GoTo ErrTrap
            End If
            If Not isMono Then
                
                If STCAM_COLOR_ARRAY_MONO <> wColorArray Then
                
                    'WB
                    lReval = StTrg_WhiteBalance(m_hCamera, lRawImage)
                    If 0 = lReval Then
                        GoTo ErrTrap
                    End If
                    
                    If STCAM_WB_ONESHOT = m_byteWBMode Then
                        lReval = StTrg_GetWhiteBalanceMode(m_hCamera, m_byteWBMode)
                        If 0 = lReval Then
                            GoTo ErrTrap
                        End If
            
                        If (STCAM_WB_ONESHOT <> m_byteWBMode) Then
                            lReval = StTrg_GetWhiteBalanceGain(m_hCamera, m_pwWBGain(0), m_pwWBGain(1), m_pwWBGain(2), m_pwWBGain(3))
                            If 0 = lReval Then
                                GoTo ErrTrap
                            End If
                
                            RaiseEvent OnUpdateWBMode
                        End If
                    End If
                    
                    'Color Gamma
                    lReval = StTrg_RawColorGamma(m_hCamera, BGRWidth, BGRHeight, m_wColorArray, lRawImage)
                    If 0 = lReval Then
                        GoTo ErrTrap
                    End If
                
                End If
            End If
            
            'Mirror/Rotation
            lReval = StTrg_MirrorRotation(m_byteMirrorMode And &HF, m_byteRotationMode, BGRWidth, BGRHeight, wColorArray, lRawImage)
            If 0 = lReval Then
                GoTo ErrTrap
            End If
            
                

            'Color Interpalation
            lReval = StTrg_ColorInterpolation(BGRWidth, BGRHeight, wColorArray, lRawImage, lBGRImage, m_byteColorInterpolationMode, m_lBGRPixelFormat)
            If 0 = lReval Then
                GoTo ErrTrap
            End If
        End If
        
        'Gamma
        lReval = StTrg_BGRGamma(m_hCamera, BGRWidth, BGRHeight, m_lBGRPixelFormat, lBGRImage)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        'Hue Saturation/Color Matrix
        lReval = StTrg_HueSaturationColorMatrix(m_hCamera, BGRWidth, BGRHeight, m_lBGRPixelFormat, lBGRImage)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        'Sharpness
        lReval = StTrg_Sharpness(m_hCamera, BGRWidth, BGRHeight, m_lBGRPixelFormat, lBGRImage)
        If 0 = lReval Then
            GoTo ErrTrap
        End If

        'Count Drop Frame[Inside PC]
        If vlFrameNo <> lFrameNo Then
            m_lPCSideDropCount = m_lPCSideDropCount + (lFrameNo - vlFrameNo)
        End If
        
        'Count Rcv Frame
        m_lRcvCount = m_lRcvCount + 1
        
        m_lLastFrameNo = lFrameNo
        
        m_bHasImage = True
        
        Call m_objFPS.Rcv
        
        
        If (m_BGRWidth <> BGRWidth) Or (m_BGRHeight <> BGRHeight) Then
            m_BGRWidth = BGRWidth
            m_BGRHeight = BGRHeight
            RaiseEvent OnUpdateBGRImageSize
        End If
        'Event
        RaiseEvent OnUpdatePreviewImage
        
    End If

Exit Sub
ErrTrap:
End Sub


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Sub RcvError(ByVal vlErrorCode As Long)
    On Error GoTo ErrTrap

    'Count Drop Frame[On USB Bus]
    If (ERR_EXPOSURE_END_DROPPED = vlErrorCode) Or (ERR_IMAGE_DATA_DROPPED = vlErrorCode) Then
        m_lDropCount = m_lDropCount + 1
    End If
    
    'Event
    RaiseEvent OnRcvError(vlErrorCode)

Exit Sub
ErrTrap:
End Sub


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function SaveImage(ByVal vstrFileName As String) As Boolean
    On Error GoTo ErrTrap
    SaveImage = True

    Dim lReval As Long
    
    If HasImage Then
        lReval = StTrg_SaveImageA(m_BGRWidth, m_BGRHeight, m_lBGRPixelFormat, m_lBGRImage, vstrFileName, 0)
        If lReval = 0 Then
            GoTo ErrTrap
        End If
    End If
Exit Function
ErrTrap:
    SaveImage = False
End Function
'------------------------------------------------------------------------------
'Draw
'------------------------------------------------------------------------------
Public Function DrawImage(ByVal hDC As Long, ByVal vlHScroll As Long, ByVal vlVScroll As Long) As Boolean
    On Error GoTo ErrTrap
    DrawImage = True
    
    If 0 = m_hCamera Then
        GoTo ErrTrap
    End If
    
    Dim lReval As Long
    
    Dim lDispWidth As Long
    Dim lDispHeight As Long
    
    lDispWidth = m_BGRWidth - vlHScroll
    lDispHeight = m_BGRHeight - vlVScroll
    
    If HasImage Then
        'Draw
        lReval = StTrg_Draw(m_hCamera, hDC, _
                        0, 0, lDispWidth, lDispHeight, _
                        vlHScroll, vlVScroll, lDispWidth, lDispHeight, _
                        m_BGRWidth, m_BGRHeight, _
                        m_lBGRImage, m_lBGRPixelFormat)
        If lReval = 0 Then
            GoTo ErrTrap
        End If
    End If
Exit Function
ErrTrap:
    DrawImage = False
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function DelayedInvalidateRequest(ByVal hwnd As Long) As Boolean
    On Error GoTo ErrTrap
    DelayedInvalidateRequest = True

    Dim lReval As Long
    If m_hCamera <> 0 Then
        lReval = StTrg_SetDelayedInvalidateRequest(m_hCamera, hwnd)
        If lReval = 0 Then
            GoTo ErrTrap
        End If
    End If
Exit Function
ErrTrap:
    DelayedInvalidateRequest = False
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function GetImageSize(ByRef rlWidth As Long, ByRef rlHeight As Long) As Boolean
    On Error GoTo ErrTrap
    GetImageSize = True
    rlWidth = m_BGRWidth
    rlHeight = m_BGRHeight
Exit Function
ErrTrap:
    GetImageSize = False
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function SettingFile(ByVal vbSaveFg As Boolean, ByRef rstrFileName As String) As Boolean
    On Error GoTo ErrTrap
    SettingFile = True

    Dim lReval As Long
    If m_hCamera <> 0 Then
        Dim bTransfer As Boolean
        Dim hwnd As Long
        
        bTransfer = m_bNowTransfer
        If bTransfer Then
            hwnd = m_hWnd
            Call StopTransfer
        End If
            
        Dim strKey As String
        Dim strValue As String
        strKey = "Other-" & FirmVesionString()
        
        If vbSaveFg Then
            lReval = StTrg_WriteSettingFileA(m_hCamera, rstrFileName)
            If lReval = 0 Then
                GoTo ErrTrap
            End If
            
            'ColorInterpolationMethod
            strValue = CStr(m_byteColorInterpolationMode)
            lReval = WritePrivateProfileString(strKey, "ColorInterpolationMethod", strValue, rstrFileName)
            
            'MirrorMode
            strValue = CStr(m_byteMirrorMode)
            lReval = WritePrivateProfileString(strKey, "MirrorMode", strValue, rstrFileName)
            
            'RotationMode
            strValue = CStr(m_byteRotationMode)
            lReval = WritePrivateProfileString(strKey, "RotationMode", strValue, rstrFileName)

        Else
            lReval = StTrg_ReadSettingFileA(m_hCamera, rstrFileName)
            If lReval = 0 Then
                GoTo ErrTrap
            End If
            
            'ColorInterpolationMethod
            strValue = CStr(m_byteColorInterpolationMode)
            m_byteColorInterpolationMode = CByte(GetPrivateProfileInt(strKey, "ColorInterpolationMethod", strValue, rstrFileName))
            
            'MirrorMode
            strValue = CStr(m_byteMirrorMode)
            m_byteMirrorMode = CByte(GetPrivateProfileInt(strKey, "MirrorMode", strValue, rstrFileName))
            
            'RotationMode
            strValue = CStr(m_byteRotationMode)
            m_byteRotationMode = CByte(GetPrivateProfileInt(strKey, "RotationMode", strValue, rstrFileName))
            
            Call Refresh
            If Not mbGetScanMode() Then
                GoTo ErrTrap
            End If
            
            If Not mbGetSkippingBinning() Then
            
            End If
            
            RaiseEvent OnUpdateTriggerMode
            RaiseEvent OnUpdateWBMode
    
        End If


        If bTransfer Then
            Call StartTransfer(hwnd)
        End If
    End If
Exit Function
ErrTrap:
    SettingFile = False
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function CameraSetting(ByVal wMode As Integer) As Boolean
    On Error GoTo ErrTrap
    CameraSetting = True

    Dim lReval As Long
    If m_hCamera <> 0 Then
        Dim bTransfer As Boolean
        Dim hwnd As Long
        
        bTransfer = m_bNowTransfer
        If bTransfer Then
            hwnd = m_hWnd
            Call StopTransfer
        End If
            
        lReval = StTrg_CameraSetting(m_hCamera, wMode)
        If lReval = 0 Then
            GoTo ErrTrap
        End If
        
        Call Refresh
        If Not mbGetScanMode() Then
            GoTo ErrTrap
        End If
        
        If Not mbGetSkippingBinning() Then
        
        End If
        
        RaiseEvent OnUpdateTriggerMode
        RaiseEvent OnUpdateWBMode
    
        If bTransfer Then
            Call StartTransfer(hwnd)
        End If
    End If
Exit Function
ErrTrap:
    CameraSetting = False
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub mStartTimer()
    On Error GoTo ErrTrap
    
    Call SetTimer(m_hWnd, 1, m_dwAutoSubTriggerTime, 0)
    
Exit Sub
ErrTrap:

End Sub
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Sub gEndTimer(ByVal vTimerID As Long)
    On Error GoTo ErrTrap
    
    Call SoftSubTrigger
    Call KillTimer(m_hWnd, vTimerID)
    
Exit Sub
ErrTrap:

End Sub

