VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.1#0"; "MSCOMCTL.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form frmMain 
   Caption         =   "StTrgDislpayVB6"
   ClientHeight    =   7395
   ClientLeft      =   225
   ClientTop       =   870
   ClientWidth     =   8670
   LinkTopic       =   "Form1"
   ScaleHeight     =   493
   ScaleMode       =   3  '߸
   ScaleWidth      =   578
   StartUpPosition =   3  'Windows ̊l
   Begin VB.Timer TimerReOpen 
      Enabled         =   0   'False
      Interval        =   100
      Left            =   3720
      Top             =   3480
   End
   Begin MSComDlg.CommonDialog commonDialogSave 
      Left            =   7320
      Top             =   480
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin MSComctlLib.ImageList imageListToolBar 
      Left            =   6600
      Top             =   480
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   15
      MaskColor       =   12632256
      _Version        =   393216
      BeginProperty Images {2C247F25-8591-11D1-B16A-00C0F0283628} 
         NumListImages   =   4
         BeginProperty ListImage1 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0000
            Key             =   ""
         EndProperty
         BeginProperty ListImage2 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0324
            Key             =   ""
         EndProperty
         BeginProperty ListImage3 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0648
            Key             =   ""
         EndProperty
         BeginProperty ListImage4 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":096C
            Key             =   ""
         EndProperty
      EndProperty
   End
   Begin MSComctlLib.Toolbar toolBarMain 
      Align           =   1  '㑵
      Height          =   705
      Left            =   0
      TabIndex        =   4
      Top             =   0
      Width           =   8670
      _ExtentX        =   15293
      _ExtentY        =   1244
      ButtonWidth     =   609
      ButtonHeight    =   556
      Appearance      =   1
      ImageList       =   "imageListToolBar"
      _Version        =   393216
      BeginProperty Buttons {66833FE8-8583-11D1-B16A-00C0F0283628} 
         NumButtons      =   4
         BeginProperty Button1 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            ImageIndex      =   1
         EndProperty
         BeginProperty Button2 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            ImageIndex      =   2
         EndProperty
         BeginProperty Button3 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            ImageIndex      =   3
         EndProperty
         BeginProperty Button4 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            ImageIndex      =   4
         EndProperty
      EndProperty
   End
   Begin MSComctlLib.StatusBar statusBarMain 
      Align           =   2  '
      Height          =   375
      Left            =   0
      TabIndex        =   3
      Top             =   7020
      Width           =   8670
      _ExtentX        =   15293
      _ExtentY        =   661
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   5
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   4498
         EndProperty
         BeginProperty Panel2 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Text            =   "0.00 FPS"
            TextSave        =   "0.00 FPS"
         EndProperty
         BeginProperty Panel3 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Text            =   "No. 0"
            TextSave        =   "No. 0"
         EndProperty
         BeginProperty Panel4 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Text            =   "RCV 0"
            TextSave        =   "RCV 0"
         EndProperty
         BeginProperty Panel5 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Text            =   "DROP 0(0)"
            TextSave        =   "DROP 0(0)"
         EndProperty
      EndProperty
   End
   Begin VB.HScrollBar HScrollImage 
      Height          =   255
      Left            =   0
      TabIndex        =   2
      Top             =   6720
      Width           =   6255
   End
   Begin VB.VScrollBar VScrollImage 
      Height          =   6255
      Left            =   6240
      TabIndex        =   1
      Top             =   480
      Width           =   255
   End
   Begin VB.PictureBox PicturePreview 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00FFFFFF&
      Height          =   6255
      Left            =   0
      ScaleHeight     =   413
      ScaleMode       =   3  '߸
      ScaleWidth      =   410
      TabIndex        =   0
      Top             =   480
      Width           =   6210
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileSaveBitmap 
         Caption         =   "Save Bitmap..."
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuMode 
      Caption         =   "&Mode"
      Begin VB.Menu mnuModeSoftTrigger 
         Caption         =   "&Soft Trigger"
      End
      Begin VB.Menu mnuModeSoftSubTrigger 
         Caption         =   "Soft S&ub Trigger"
      End
      Begin VB.Menu mnuModeReadOut 
         Caption         =   "&Read Out"
      End
      Begin VB.Menu sp0 
         Caption         =   "-"
      End
      Begin VB.Menu mnuModeSetting 
         Caption         =   "&Setting..."
      End
      Begin VB.Menu mnuModeCameraID 
         Caption         =   "Camera ID..."
      End
   End
   Begin VB.Menu mnuView 
      Caption         =   "&View"
      Begin VB.Menu mnuViewToolbar 
         Caption         =   "&Toolbar"
         Checked         =   -1  'True
      End
      Begin VB.Menu mnuViewStatusBar 
         Caption         =   "&StatusBar"
         Checked         =   -1  'True
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpAboutStTrgDisplayVB6 
         Caption         =   "&About StTrgDisplayVB6"
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit


#Const START_TRANSFER = 1
'#Const START_TRANSFER = 0

Private WithEvents m_StCamera As CStCamera
Attribute m_StCamera.VB_VarHelpID = -1
Private m_frmSetting As frmSetting
Attribute m_frmSetting.VB_VarHelpID = -1
Private m_hDisplayWnd As Long

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function mbUpdateCaption() As Boolean
    On Error GoTo ErrTrap
    mbUpdateCaption = True
    
    If Not (m_StCamera Is Nothing) Then
        Dim lReval As Long
        Dim lCameraNo As Long
        Dim strCameraName As String
        lReval = m_StCamera.ReadCameraUserID(lCameraNo, strCameraName)
        If lReval = 0 Then
            GoTo ErrTrap
        End If
        
        Caption = strCameraName & "[" & lCameraNo & "] - " & App.Title
    End If
Exit Function
ErrTrap:
    mbUpdateCaption = False
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_Load()
    On Error GoTo ErrTrap
    
    m_hDisplayWnd = PicturePreview.hwnd
    Call OpenCamera
        

Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub OpenCamera()
    On Error GoTo ErrTrap
    
    
    Set m_StCamera = New CStCamera
 
    
    PicturePreview.Move 0, 0
    HScrollImage.ZOrder 0
    VScrollImage.ZOrder 0
    
    'Open the Camera
    If Not m_StCamera.OpenCamera() Then
        Set m_StCamera = Nothing
        mnuModeSetting.Enabled = False
        mnuModeCameraID.Enabled = False
        
    End If
    If Not mbUpdateCaption() Then
        GoTo ErrTrap
    End If
    
    Call mbUpdateToolBarButtonStatus

#If START_TRANSFER Then
    If Not (m_StCamera Is Nothing) Then
        
        If Not m_StCamera.StartTransfer(Me.hwnd) Then
            GoTo ErrTrap
        End If
    End If
#End If
Exit Sub
ErrTrap:
End Sub
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub CloseCamera()
    On Error GoTo ErrTrap

    Call m_StCamera.StopTransfer
    
    If Not (m_frmSetting Is Nothing) Then
        Unload m_frmSetting
        Set m_frmSetting = Nothing
    End If
    
    Set m_StCamera = Nothing
Exit Sub
ErrTrap:
End Sub
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    On Error GoTo ErrTrap


Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_Resize()
    On Error GoTo ErrTrap
    
    Dim lSBH_Width As Long
    Dim lSBH_Height As Long
    Dim lSBV_Width As Long
    Dim lSBV_Height As Long
    
    Dim lHStep As Long
    Dim lVStep As Long
    
    Dim lPPVOffset As Long
    Dim lPPWidth As Long
    Dim lPPHeight As Long
    
    Dim lImageWidth As Long
    Dim lImageHeight As Long
    
    
    If Not (m_StCamera Is Nothing) Then
    
        If Not m_StCamera.GetImageSize(lImageWidth, lImageHeight) Then
            GoTo ErrTrap
        End If
    End If
    lPPWidth = ScaleWidth
    lPPHeight = ScaleHeight
    lPPVOffset = 0
    If vbMinimized = WindowState Then Exit Sub
    
    If statusBarMain.Visible Then
        lPPHeight = lPPHeight - statusBarMain.Height
    End If
    
    If toolBarMain.Visible Then
        lPPVOffset = toolBarMain.Height
        lPPHeight = lPPHeight - toolBarMain.Height
    End If

    lSBH_Height = HScrollImage.Height
    lSBV_Width = VScrollImage.Width
    
    lSBH_Width = lPPWidth - lSBV_Width
    lSBV_Height = lPPHeight - lSBH_Height
    
    lHStep = lImageWidth - lSBH_Width
    lVStep = lImageHeight - lSBV_Height
    
    With HScrollImage
        If (lHStep < 0) Or _
            ((lHStep < lSBV_Width) And (lVStep < lSBH_Height)) Then
            .Visible = False
            .value = 0
        Else
            .Move 0, lPPVOffset + lPPHeight - lSBH_Height, lSBH_Width, lSBH_Height
            .Visible = True
            .Max = lHStep
            lPPHeight = lPPHeight - lSBH_Height
        End If
    End With
    
    With VScrollImage
        If (lVStep < 0) Or _
            ((lHStep < lSBV_Width) And (lVStep < lSBH_Height)) Then
            .Visible = False
            .value = 0
        Else
            .Move lPPWidth - lSBV_Width, lPPVOffset, lSBV_Width, lSBV_Height
            .Visible = True
            .Max = lVStep
            lPPWidth = lPPWidth - lSBV_Width
        End If
    End With
    
    With PicturePreview
        .Move 0, lPPVOffset
        .Width = lPPWidth
        .Height = lPPHeight
    End With

Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_Unload(Cancel As Integer)
    On Error GoTo ErrTrap

    Call CloseCamera
    
  
Exit Sub
ErrTrap:
End Sub




'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub m_StCamera_OnNeedToClear()
    Call Redraw
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub m_StCamera_OnUpdateBGRImageSize()
    Call Form_Resize
End Sub

Private Sub m_StCamera_OnUpdateTriggerMode()
    Call mbUpdateToolBarButtonStatus
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub m_StCamera_OnRcvError(ByVal vlErrorCode As Long)
    Const ERROR_ACCESS_DENIED = 5&
    Call UpdateStausBar
    If ERROR_ACCESS_DENIED = vlErrorCode Then
        TimerReOpen.Enabled = True
    End If
    'MsgBox "Error(0x" & Right(String(8, "0") & Hex(vlErrorCode), 8) & ")"
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub m_StCamera_OnUpdatePreviewImage()
    Call Redraw

    mnuFileSaveBitmap.Enabled = True
    toolBarMain.Buttons(1).Enabled = True
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub m_StCamera_OnExposureEnd(ByVal vlFrameNo As Long)
    On Error GoTo ErrTrap

'    If Not m_StCamera.SoftTrigger() Then
'        GoTo ErrTrap
'    End If
Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub mnuFileExit_Click()
    On Error GoTo ErrTrap

    Unload Me
Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub mnuFileSaveBitmap_Click()
    On Error GoTo ErrTrap
    With commonDialogSave
        .Filter = "Bitmap(*.bmp)|*.bmp|Tiff(*.tif)|*.tif|JPEG(*.jpg)|*.jpg|AllFiles(*.*)|*.*"
        .DefaultExt = "bmp"
        .CancelError = True
        .ShowSave
    End With
    
    If m_StCamera.HasImage Then
        If Not m_StCamera.SaveImage(commonDialogSave.FileName) Then
            GoTo ErrTrap
        End If
    End If
    
    
Exit Sub
ErrTrap:
    If Err.Number = 32755 Then
        
    Else
        
    End If
End Sub

Private Sub mnuHelpAboutStTrgDisplayVB6_Click()
    On Error GoTo ErrTrap

    Dim FormAbout As New frmAbout
    FormAbout.Show vbModal
    Set FormAbout = Nothing

Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub mnuModeCameraID_Click()
    On Error GoTo ErrTrap

    Dim lReval As Long
    Dim lCameraNo As Long
    Dim strCameraName As String
    lReval = m_StCamera.ReadCameraUserID(lCameraNo, strCameraName)
    If lReval = 0 Then
        GoTo ErrTrap
    End If
    Dim FormCameraID As New frmCameraID
    
    FormCameraID.CameraName = strCameraName
    FormCameraID.CameraNo = lCameraNo
    FormCameraID.Show vbModal, Me
    
    
    If Not FormCameraID.Cancel Then
        lCameraNo = FormCameraID.CameraNo
        strCameraName = FormCameraID.CameraName
        lReval = m_StCamera.WriteCameraUserID(lCameraNo, strCameraName)
        If lReval = 0 Then
            GoTo ErrTrap
        End If
        If Not mbUpdateCaption() Then
            GoTo ErrTrap
        End If
    End If
    
    Set FormCameraID = Nothing

Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub mnuModeReadOut_Click()
    On Error GoTo ErrTrap

    If Not m_StCamera.ReadOut() Then
        GoTo ErrTrap
    End If
Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub mnuModeSetting_Click()
    On Error GoTo ErrTrap
    If m_frmSetting Is Nothing Then
        Set m_frmSetting = New frmSetting
    End If
    Set m_frmSetting.g_StCamera = m_StCamera
    m_frmSetting.Show vbModeless ', Me
    
Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub mnuModeSoftSubTrigger_Click()
    On Error GoTo ErrTrap

    If Not m_StCamera.SoftSubTrigger() Then
        GoTo ErrTrap
    End If
Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub mnuModeSoftTrigger_Click()
    On Error GoTo ErrTrap

    If Not m_StCamera.SoftTrigger() Then
        GoTo ErrTrap
    End If
Exit Sub
ErrTrap:
End Sub


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub toolBarMain_ButtonClick(ByVal Button As MSComctlLib.Button)
    On Error GoTo ErrTrap
    
    Select Case Button.Index
        Case 1: 'Save
            Call mnuFileSaveBitmap_Click
        Case 2: 'Soft Trigger
            Call mnuModeSoftTrigger_Click
        Case 3: 'Soft Sub Trigger
            Call mnuModeSoftSubTrigger_Click
        Case 4: 'Read Out
            Call mnuModeReadOut_Click
    End Select

Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function mbUpdateToolBarButtonStatus() As Boolean
    On Error GoTo ErrTrap
    mbUpdateToolBarButtonStatus = True

    
    Dim bSave As Boolean
    Dim bSoftTrigger As Boolean
    Dim bSoftSubTrigger As Boolean
    Dim bSoftReadOut As Boolean
    If Not (m_StCamera Is Nothing) Then
        
        bSave = m_StCamera.HasImage
        bSoftTrigger = m_StCamera.SoftTriggerIsEnable
        bSoftSubTrigger = m_StCamera.SoftSubTriggerIsEnable
        bSoftReadOut = m_StCamera.SoftReadOutIsEnable
        
    End If
    mnuFileSaveBitmap.Enabled = bSave
    mnuModeSoftTrigger.Enabled = bSoftTrigger
    mnuModeSoftSubTrigger.Enabled = bSoftSubTrigger
    mnuModeReadOut.Enabled = bSoftReadOut
    
    toolBarMain.Buttons(1).Enabled = bSave
    toolBarMain.Buttons(2).Enabled = bSoftTrigger
    toolBarMain.Buttons(3).Enabled = bSoftSubTrigger
    toolBarMain.Buttons(4).Enabled = bSoftReadOut
Exit Function
ErrTrap:
    mbUpdateToolBarButtonStatus = False
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub mnuViewStatusBar_Click()
    On Error GoTo ErrTrap
    statusBarMain.Visible = Not statusBarMain.Visible
    mnuViewStatusBar.Checked = statusBarMain.Visible
    If statusBarMain.Visible Then
        Call UpdateStausBar
    End If
    Call Form_Resize
Exit Sub
ErrTrap:

End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub mnuViewToolbar_Click()

    On Error GoTo ErrTrap
    toolBarMain.Visible = Not toolBarMain.Visible
    mnuViewToolbar.Checked = toolBarMain.Visible
    Call Form_Resize
Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub PicturePreview_Paint()
    On Error GoTo ErrTrap
    Dim lReval As Long

    PicturePreview.AutoRedraw = True
    
    If Not (m_StCamera Is Nothing) Then
        If Not m_StCamera.DrawImage(PicturePreview.hDC, HScrollImage.value, VScrollImage.value) Then
            GoTo ErrTrap
        End If
        Call UpdateStausBar
    End If
Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Redraw()
    On Error GoTo ErrTrap
    Dim lReval As Long

    PicturePreview.AutoRedraw = False
    If IsDebugMode Then
        PicturePreview.Refresh
        Call UpdateStausBar
    Else
        m_StCamera.DelayedInvalidateRequest (m_hDisplayWnd)
    End If
Exit Sub
ErrTrap:

End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub HScrollImage_Change()
    Call Redraw
End Sub


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub VScrollImage_Change()
    Call Redraw
End Sub
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub UpdateStausBar()
    On Error GoTo ErrTrap
    
    
    If Not (m_StCamera Is Nothing) Then
        With statusBarMain
            If .Visible Then
                .Panels(2).text = Format(m_StCamera.FPS, "#0.0") & " FPS"
                .Panels(3).text = "No. " & m_StCamera.LastFrameNo
                .Panels(4).text = "RCV " & m_StCamera.RcvCount
                .Panels(5).text = "DROP " & m_StCamera.DropCount & "(" & m_StCamera.PCSideDropCount & ")"
            End If
        End With
    End If

Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub TimerReOpen_Timer()
    On Error GoTo ErrTrap

    TimerReOpen.Enabled = False
    Call CloseCamera
    Call OpenCamera
    If (m_StCamera Is Nothing) Then
        Unload Me
    End If
Exit Sub
ErrTrap:
End Sub
