VERSION 5.00
Begin VB.Form frmSelectCamera 
   Caption         =   "Select Camera"
   ClientHeight    =   1215
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   4560
   LinkTopic       =   "Form1"
   ScaleHeight     =   1215
   ScaleWidth      =   4560
   StartUpPosition =   2  '
   Begin VB.Timer timerSearch 
      Enabled         =   0   'False
      Interval        =   500
      Left            =   360
      Top             =   720
   End
   Begin VB.CommandButton cmdOKCancel 
      Caption         =   "OK"
      Height          =   375
      Index           =   1
      Left            =   1920
      TabIndex        =   2
      Top             =   720
      Width           =   1215
   End
   Begin VB.CommandButton cmdOKCancel 
      Caption         =   "Cancel"
      Height          =   375
      Index           =   0
      Left            =   3240
      TabIndex        =   1
      Top             =   720
      Width           =   1215
   End
   Begin VB.ComboBox cmbCameraList 
      Enabled         =   0   'False
      Height          =   300
      Left            =   240
      Style           =   2  '
      TabIndex        =   0
      Top             =   240
      Width           =   4215
   End
End
Attribute VB_Name = "frmSelectCamera"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private m_CameraHandle As Long
Private m_CameraCount As Long

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function GetCameraHandle() As Long
    On Error GoTo ErrTrap
    
    
    Call mbCreateCameraList
    
    If m_CameraCount = 1 Then
        Call cmdOKCancel_Click(1)
    Else
        timerSearch.Enabled = (m_CameraCount = 0)
        Me.Show vbModal
    End If
    
    GetCameraHandle = m_CameraHandle
Exit Function
ErrTrap:
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub cmdOKCancel_Click(Index As Integer)
    On Error GoTo ErrTrap
    
    With cmbCameraList
        If (Index <> 0) And (m_CameraCount <> 0) Then
            m_CameraHandle = .ItemData(.ListIndex)
        End If
    End With
    Hide
Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_Load()
    On Error GoTo ErrTrap
    
    m_CameraHandle = 0
    m_CameraCount = 0
    cmdOKCancel(1).Enabled = False
        
Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_Unload(Cancel As Integer)
    On Error GoTo ErrTrap
    timerSearch.Enabled = False
    Call mbCloseCameraList
Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub timerSearch_Timer()
    On Error GoTo ErrTrap
    
    Call mbCreateCameraList
    timerSearch.Enabled = (m_CameraCount = 0)
    If m_CameraCount = 1 Then
        Call cmdOKCancel_Click(1)
    End If
Exit Sub
ErrTrap:
End Sub
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function mbCreateCameraList() As Boolean
    On Error GoTo ErrTrap
    mbCreateCameraList = True
    
    Dim lCameraHandle As Long
    With cmbCameraList
        Do
            lCameraHandle = StTrg_Open()
            If lCameraHandle = -1 Then
                Exit Do
            End If
            
            Dim strCameraName As String
            strCameraName = mstrGetCameraName(lCameraHandle)
            .AddItem (strCameraName)
            .ItemData(.ListCount - 1) = lCameraHandle
            m_CameraCount = m_CameraCount + 1
        Loop
        If 0 < m_CameraCount Then
            .ListIndex = 0
            cmdOKCancel(1).Enabled = True
            cmbCameraList.Enabled = True
        End If
    End With

Exit Function
ErrTrap:
    If Err.Number <> 0 Then
        MsgBox Err.Description, vbOKOnly + vbCritical, Me.Name & ".mbCreateCameraList()"
    End If
    mbCreateCameraList = False
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function mstrGetCameraName(ByVal lCameraHandle As Long) As String
    On Error GoTo ErrTrap
    mstrGetCameraName = ""
    Dim lReval As Long
    
    Dim lCameraNo As Long
    Dim strCameraName As String
    
    strCameraName = Space(250)
    lReval = StTrg_ReadCameraUserIDA(lCameraHandle, lCameraNo, strCameraName, Len(strCameraName))
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    mstrGetCameraName = "[" & lCameraNo & "]" & strCameraName
    

Exit Function
ErrTrap:
    mstrGetCameraName = ""
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function mbCloseCameraList() As Boolean
    On Error GoTo ErrTrap
    mbCloseCameraList = True
    
    With cmbCameraList
        Do While cmbCameraList.ListCount <> 0
            If m_CameraHandle <> .ItemData(0) Then
                Call StTrg_Close(.ItemData(0))
            End If
            .RemoveItem (0)
        Loop
    End With
Exit Function
ErrTrap:
    mbCloseCameraList = False
End Function
