Public Class CStCamera
	Implements IDisposable

	Private m_hCamera As IntPtr

	Private m_hPreviewParentWnd As IntPtr

	'Camera ID
	Private m_nCameraID As Integer
	Private m_strCameraName As String


	'Original Image
	Private m_wScanMode As Short
	Private m_dwOrgImageOffsetX As Integer
	Private m_dwOrgImageOffsetY As Integer
	Private m_dwOrgImageWidth As Integer
	Private m_dwOrgImageHeight As Integer

	'Display Mode
	Private m_byteDisplayMode As Byte = StCam.STCAM_DISPLAY_MODE_GDI

	'Aspect Mode
	Private m_byteAspectMode As Byte = StCam.STCAM_ASPECT_MODE_FIXED

	'Preview Window
	Private m_lPreviewWindowOffsetX As Integer
	Private m_lPreviewWindowOffsetY As Integer
	Private m_dwPreviewWindowWidth As Integer
	Private m_dwPreviewWindowHeight As Integer

	'Preview Mask
	Private m_dwPreviewMaskOffsetX As Integer
	Private m_dwPreviewMaskOffsetY As Integer
	Private m_dwPreviewMaskWidth As Integer
	Private m_dwPreviewMaskHeight As Integer

	'Preview Dest
	Private m_dwPreviewDestOffsetX As Integer
	Private m_dwPreviewDestOffsetY As Integer
	Private m_dwPreviewDestWidth As Integer
	Private m_dwPreviewDestHeight As Integer
	Public Overrides Function ToString() As String
		Return (m_strCameraName)
	End Function
	Public Sub Close()
		Dispose()
	End Sub
	Public Sub Dispose() Implements System.IDisposable.Dispose
		If Not m_hCamera.Equals(IntPtr.Zero) Then
			StCam.Close(m_hCamera)
			m_hCamera = IntPtr.Zero
		End If
	End Sub
	Public Function Open() As Boolean
		Dim result As Boolean = True
		Close()
		m_hCamera = StCam.Open(0)
		If m_hCamera.Equals(IntPtr.Zero) Then
			result = False
		Else
			result = mGetSettings()

			If Not result Then
				Close()
			End If
		End If
		Return (result)
	End Function

	Private Function mGetSettings() As Boolean
		Dim result As Boolean = True
		Do
			result = mGetCameraName()
			If Not result Then Exit Do

			result = mGetImageSize()
			If Not result Then Exit Do

			result = mGetDisplayMode()
			If Not result Then Exit Do

			result = mGetAspectMode()
			If Not result Then Exit Do

			result = mGetPreviewMaskSize()
			If Not result Then Exit Do

			result = mGetPreviewDestSize()
			If Not result Then Exit Do
		Loop While False

		Return (result)
	End Function
	Public Function CreateWindow(ByVal hWnd As IntPtr) As Boolean
		Dim result As Boolean = True
		Dim dwStyle As Integer = StCam.WS_VISIBLE Or StCam.WS_HSCROLL Or StCam.WS_VSCROLL

		If m_hCamera.Equals(IntPtr.Zero) Then
			result = False
		Else
			If hWnd.Equals(IntPtr.Zero) Then
				'Overlapped Window
				dwStyle = dwStyle Or StCam.WS_OVERLAPPEDWINDOW
				m_hPreviewParentWnd = IntPtr.Zero
			Else
				'Child Window
				dwStyle = dwStyle Or StCam.WS_CHILDWINDOW
				m_hPreviewParentWnd = hWnd
			End If


			If StCam.STCAM_FALSE = StCam.CreatePreviewWindow(m_hCamera, "Preview", dwStyle, _
			 m_lPreviewWindowOffsetX, m_lPreviewWindowOffsetY, m_dwPreviewWindowWidth, m_dwPreviewWindowHeight, _
			 hWnd, IntPtr.Zero, 0) Then
				result = False
			Else
				result = mGetPreviewWindowSize()
			End If

		End If

		Return (result)
	End Function
	Public Function StartTransfer() As Boolean
		Dim result As Boolean = True

		If m_hCamera.Equals(IntPtr.Zero) Then
			result = False
		ElseIf StCam.STCAM_FALSE = StCam.StartTransfer(m_hCamera) Then
			result = False
		End If

		Return (result)
	End Function
	Public Function StopTransfer() As Boolean
		Dim result As Boolean = True

		If m_hCamera.Equals(IntPtr.Zero) Then
			result = False
		ElseIf StCam.STCAM_FALSE = StCam.StopTransfer(m_hCamera) Then
			result = False
		End If

		Return (result)
	End Function
	'-----------------------------------------------------------------------------
	'Camera Name
	'-----------------------------------------------------------------------------
	Private Function mGetCameraName() As Boolean
		Dim result As Boolean = True
		Dim strCameraName As New System.Text.StringBuilder(255)
		Dim nCameraID As Integer

		If StCam.STCAM_FALSE = StCam.ReadCameraUserID(m_hCamera, nCameraID, strCameraName, strCameraName.Capacity) Then
			result = False
		Else
			m_nCameraID = nCameraID
			m_strCameraName = strCameraName.ToString()
		End If
		Return (result)
	End Function
	Public ReadOnly Property CameraName() As String
		Get
			Return (m_strCameraName)
		End Get
	End Property
	'-----------------------------------------------------------------------------
	'Image Size
	'-----------------------------------------------------------------------------
	Private Function mGetImageSize() As Boolean
		Dim result As Boolean = True
		Dim dwReserved As Integer
		If StCam.STCAM_FALSE = StCam.GetImageSize(m_hCamera, dwReserved, m_wScanMode, m_dwOrgImageOffsetX, m_dwOrgImageOffsetY, m_dwOrgImageWidth, m_dwOrgImageHeight) Then
			result = False
		End If
		Return (result)
	End Function
	Public ReadOnly Property OrgImageWidth() As Integer
		Get
			Return (m_dwOrgImageWidth)
		End Get
	End Property
	Public ReadOnly Property OrgImageHeight() As Integer
		Get
			Return (m_dwOrgImageHeight)
		End Get
	End Property
	'-----------------------------------------------------------------------------
	'DisplayMode
	'-----------------------------------------------------------------------------
	Private Function mGetDisplayMode() As Boolean
		Dim result As Boolean = True
		If StCam.STCAM_FALSE = StCam.GetDisplayMode(m_hCamera, m_byteDisplayMode) Then
			result = False
		End If
		Return (result)
	End Function
	Private Function mSetDisplayMode(ByVal byteDisplayMode As Byte) As Boolean
		Dim result As Boolean = True
		Do
			If StCam.STCAM_FALSE = StCam.DestroyPreviewWindow(m_hCamera) Then
				result = False
				Exit Do
			End If
			If StCam.STCAM_FALSE = StCam.SetDisplayMode(m_hCamera, byteDisplayMode) Then
				result = False
				Exit Do
			End If
			m_byteDisplayMode = byteDisplayMode

			result = CreateWindow(m_hPreviewParentWnd)

		Loop While False
		Return (result)
	End Function
	Public Property DisplayMode() As Byte
		Get
			Return (m_byteDisplayMode)
		End Get
		Set(ByVal value As Byte)
			mSetDisplayMode(value)
		End Set
	End Property
	'-----------------------------------------------------------------------------
	'Aspect Mode
	'-----------------------------------------------------------------------------
	Private Function mGetAspectMode() As Boolean
		Dim result As Boolean = True
		If StCam.STCAM_FALSE = StCam.GetAspectMode(m_hCamera, m_byteAspectMode) Then
			result = False
		End If
		Return (result)
	End Function
	Private Function mSetAspectMode(ByVal byteAspectMode As Byte) As Boolean
		Dim result As Boolean = True
		Do
			If StCam.STCAM_FALSE = StCam.SetAspectMode(m_hCamera, byteAspectMode) Then
				result = False
				Exit Do
			End If
			m_byteAspectMode = byteAspectMode

			result = mGetSettings()

		Loop While False
		Return (result)
	End Function
	Public Property AspectMode() As Byte
		Get
			Return (m_byteAspectMode)
		End Get
		Set(ByVal value As Byte)
			mSetAspectMode(value)
		End Set
	End Property
	'-----------------------------------------------------------------------------
	'PreviewWindowSize
	'-----------------------------------------------------------------------------
	Private Function mGetPreviewWindowSize() As Boolean
		Dim result As Boolean = True
		If StCam.STCAM_FALSE = StCam.GetPreviewWindowSize(m_hCamera, m_lPreviewWindowOffsetX, m_lPreviewWindowOffsetY, m_dwPreviewWindowWidth, m_dwPreviewWindowHeight) Then
			result = False
		End If
		Return (result)
	End Function
	Private Function mSetPreviewWindowSize(ByVal nOffsetX As Integer, ByVal nOffsetY As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer) As Boolean
		Dim result As Boolean = True
		Do
			If StCam.STCAM_FALSE = StCam.SetPreviewWindowSize(m_hCamera, nOffsetX, nOffsetY, nWidth, nHeight) Then
				result = False
				Exit Do
			End If
			m_lPreviewWindowOffsetX = nOffsetX
			m_lPreviewWindowOffsetY = nOffsetY
			m_dwPreviewWindowWidth = nWidth
			m_dwPreviewWindowHeight = nHeight
		Loop While False
		Return (result)
	End Function
	Public Property PreviewWindowOffsetX() As Integer
		Get
			Return (m_lPreviewWindowOffsetX)
		End Get
		Set(ByVal value As Integer)
			mSetPreviewWindowSize(value, m_lPreviewWindowOffsetY, m_dwPreviewWindowWidth, m_dwPreviewWindowHeight)
		End Set
	End Property
	Public Property PreviewWindowOffsetY() As Integer
		Get
			Return (m_lPreviewWindowOffsetY)
		End Get
		Set(ByVal value As Integer)
			mSetPreviewWindowSize(m_lPreviewWindowOffsetX, value, m_dwPreviewWindowWidth, m_dwPreviewWindowHeight)
		End Set
	End Property
	Public Property PreviewWindowWidth() As Integer
		Get
			Return (m_dwPreviewWindowWidth)
		End Get
		Set(ByVal value As Integer)
			mSetPreviewWindowSize(m_lPreviewWindowOffsetX, m_lPreviewWindowOffsetY, value, m_dwPreviewWindowHeight)
		End Set
	End Property
	Public Property PreviewWindowHeight() As Integer
		Get
			Return (m_dwPreviewWindowHeight)
		End Get
		Set(ByVal value As Integer)
			mSetPreviewWindowSize(m_lPreviewWindowOffsetX, m_lPreviewWindowOffsetY, m_dwPreviewWindowWidth, value)
		End Set
	End Property

	'-----------------------------------------------------------------------------
	'PreviewMaskSize
	'-----------------------------------------------------------------------------
	Private Function mGetPreviewMaskSize() As Boolean
		Dim result As Boolean = True
		If StCam.STCAM_FALSE = StCam.GetPreviewMaskSize(m_hCamera, m_dwPreviewMaskOffsetX, m_dwPreviewMaskOffsetY, m_dwPreviewMaskWidth, m_dwPreviewMaskHeight) Then
			result = False
		End If
		Return (result)
	End Function
	Private Function mSetPreviewMaskSize(ByVal nOffsetX As Integer, ByVal nOffsetY As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer) As Boolean
		Dim result As Boolean = True
		Do
			If StCam.STCAM_FALSE = StCam.SetPreviewMaskSize(m_hCamera, nOffsetX, nOffsetY, nWidth, nHeight) Then
				result = False
				Exit Do
			End If
			m_dwPreviewMaskOffsetX = nOffsetX
			m_dwPreviewMaskOffsetY = nOffsetY
			m_dwPreviewMaskWidth = nWidth
			m_dwPreviewMaskHeight = nHeight
		Loop While False
		Return (result)
	End Function
	Public Property PreviewMaskOffsetX() As Integer
		Get
			Return (m_dwPreviewMaskOffsetX)
		End Get
		Set(ByVal value As Integer)
			mSetPreviewMaskSize(value, m_dwPreviewMaskOffsetY, m_dwPreviewMaskWidth, m_dwPreviewMaskHeight)
		End Set
	End Property
	Public Property PreviewMaskOffsetY() As Integer
		Get
			Return (m_dwPreviewMaskOffsetY)
		End Get
		Set(ByVal value As Integer)
			mSetPreviewMaskSize(m_dwPreviewMaskOffsetX, value, m_dwPreviewMaskWidth, m_dwPreviewMaskHeight)
		End Set
	End Property
	Public Property PreviewMaskWidth() As Integer
		Get
			Return (m_dwPreviewMaskWidth)
		End Get
		Set(ByVal value As Integer)
			mSetPreviewMaskSize(m_dwPreviewMaskOffsetX, m_dwPreviewMaskOffsetY, value, m_dwPreviewMaskHeight)
		End Set
	End Property
	Public Property PreviewMaskHeight() As Integer
		Get
			Return (m_dwPreviewMaskHeight)
		End Get
		Set(ByVal value As Integer)
			mSetPreviewMaskSize(m_dwPreviewMaskOffsetX, m_dwPreviewMaskOffsetY, m_dwPreviewMaskWidth, value)
		End Set
	End Property

	'-----------------------------------------------------------------------------
	'
	'-----------------------------------------------------------------------------
	Private Function mGetPreviewDestSize() As Boolean
		Dim result As Boolean = True
		If StCam.STCAM_FALSE = StCam.GetPreviewMaskSize(m_hCamera, m_dwPreviewDestOffsetX, m_dwPreviewDestOffsetY, m_dwPreviewDestWidth, m_dwPreviewDestHeight) Then
			result = False
		End If
		Return (result)
	End Function
	Private Function mSetPreviewDestSize(ByVal nOffsetX As Integer, ByVal nOffsetY As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer) As Boolean
		Dim result As Boolean = True
		Do
			If StCam.STCAM_FALSE = StCam.SetPreviewDestSize(m_hCamera, nOffsetX, nOffsetY, nWidth, nHeight) Then
				result = False
				Exit Do
			End If
			m_dwPreviewDestOffsetX = nOffsetX
			m_dwPreviewDestOffsetY = nOffsetY
			m_dwPreviewDestWidth = nWidth
			m_dwPreviewDestHeight = nHeight
		Loop While False
		Return (result)
	End Function
	Public Property PreviewDestOffsetX() As Integer
		Get
			Return (m_dwPreviewDestOffsetX)
		End Get
		Set(ByVal value As Integer)
			mSetPreviewDestSize(value, m_dwPreviewDestOffsetY, m_dwPreviewDestWidth, m_dwPreviewDestHeight)
		End Set
	End Property
	Public Property PreviewDestOffsetY() As Integer
		Get
			Return (m_dwPreviewDestOffsetY)
		End Get
		Set(ByVal value As Integer)
			mSetPreviewDestSize(m_dwPreviewDestOffsetX, value, m_dwPreviewDestWidth, m_dwPreviewDestHeight)
		End Set
	End Property
	Public Property PreviewDestWidth() As Integer
		Get
			Return (m_dwPreviewDestWidth)
		End Get
		Set(ByVal value As Integer)
			mSetPreviewDestSize(m_dwPreviewDestOffsetX, m_dwPreviewDestOffsetY, value, m_dwPreviewDestHeight)
		End Set
	End Property
	Public Property PreviewDestHeight() As Integer
		Get
			Return (m_dwPreviewDestHeight)
		End Get
		Set(ByVal value As Integer)
			mSetPreviewDestSize(m_dwPreviewDestOffsetX, m_dwPreviewDestOffsetY, m_dwPreviewDestWidth, value)
		End Set
	End Property



End Class
