Public Class FormMain
	Inherits System.Windows.Forms.Form

#Region " Windows Form Designer Code "

	Public Sub New(ByVal stCamera As CStCamera)
		MyBase.New()

		InitializeComponent()
		m_StCamera = stCamera

	End Sub

	Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
		If disposing Then
			If Not (components Is Nothing) Then
				components.Dispose()
			End If
		End If
		MyBase.Dispose(disposing)
	End Sub

	Private components As System.ComponentModel.IContainer
	Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
	Friend WithEvents MenuItem1 As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItemSetting As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItem3 As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItemChildWindow As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItemOverlappedWindow As System.Windows.Forms.MenuItem

	<System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
		Me.MainMenu1 = New System.Windows.Forms.MainMenu
		Me.MenuItem1 = New System.Windows.Forms.MenuItem
		Me.MenuItemSetting = New System.Windows.Forms.MenuItem
		Me.MenuItem3 = New System.Windows.Forms.MenuItem
		Me.MenuItemChildWindow = New System.Windows.Forms.MenuItem
		Me.MenuItemOverlappedWindow = New System.Windows.Forms.MenuItem
		'
		'MainMenu1
		'
		Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem1})
		'
		'MenuItem1
		'
		Me.MenuItem1.Index = 0
		Me.MenuItem1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItemSetting, Me.MenuItem3})
		Me.MenuItem1.Text = "&Mode"
		'
		'MenuItemSetting
		'
		Me.MenuItemSetting.Index = 0
		Me.MenuItemSetting.Text = "&Setting"
		'
		'MenuItem3
		'
		Me.MenuItem3.Index = 1
		Me.MenuItem3.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItemChildWindow, Me.MenuItemOverlappedWindow})
		Me.MenuItem3.Text = "&Window Style"
		'
		'MenuItemChildWindow
		'
		Me.MenuItemChildWindow.Index = 0
		Me.MenuItemChildWindow.Text = "&Child Window"
		'
		'MenuItemOverlappedWindow
		'
		Me.MenuItemOverlappedWindow.Index = 1
		Me.MenuItemOverlappedWindow.Text = "&Overlapped"
		'
		'FormMain
		'
		Me.AutoScaleBaseSize = New System.Drawing.Size(5, 12)
		Me.ClientSize = New System.Drawing.Size(1032, 621)
		Me.Menu = Me.MainMenu1
		Me.Name = "FormMain"
		Me.Text = "PreviewSize"

	End Sub

#End Region
	Private m_StCamera As CStCamera
	Private m_FormSetting As FormSetting

	Private Sub FormMain_Closed(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Closed
		If Not m_StCamera Is Nothing Then
			m_StCamera.Dispose()
			m_StCamera = Nothing
		End If
	End Sub



	Private Sub FormMain_Activated(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Activated
		RemoveHandler Me.Activated, AddressOf FormMain_Activated
		MenuItemChildWindow.PerformClick()
		m_StCamera.StartTransfer()

	End Sub

	Private Sub MenuItemWindowStyle_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItemChildWindow.Click, MenuItemOverlappedWindow.Click
		Dim bChildWindow As Boolean = False
		Dim hParentWindow As IntPtr = IntPtr.Zero

		If MenuItemChildWindow Is sender Then
			bChildWindow = True
			hParentWindow = Me.Handle
		End If

		Dim result As Boolean = True

		result = m_StCamera.CreateWindow(hParentWindow)

		MenuItemChildWindow.Checked = bChildWindow
		MenuItemOverlappedWindow.Checked = Not bChildWindow

	End Sub

	Private Sub MenuItemSetting_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItemSetting.Click
		If m_FormSetting Is Nothing Then
			m_FormSetting = New FormSetting(m_StCamera)
			AddHandler m_FormSetting.Closed, AddressOf FormSetting_Closed
		End If
		m_FormSetting.Show()
		m_FormSetting.Activate()
	End Sub
	Private Sub FormSetting_Closed(ByVal sender As System.Object, ByVal e As System.EventArgs)
		m_FormSetting = Nothing
	End Sub
End Class
