Public Class FormSelectCamera
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer Code "

	Public Sub New()
		MyBase.New()

		InitializeComponent()


	End Sub

	Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
		If disposing Then
			If Not (components Is Nothing) Then
				components.Dispose()
			End If
		End If
		MyBase.Dispose(disposing)
	End Sub

	Private components As System.ComponentModel.IContainer

	Friend WithEvents btnOK As System.Windows.Forms.Button
	Friend WithEvents btnCancel As System.Windows.Forms.Button
	Friend WithEvents cmbCameraList As System.Windows.Forms.ComboBox
	Friend WithEvents TimerCheckCamera As System.Windows.Forms.Timer
	<System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
		Me.components = New System.ComponentModel.Container
		Me.cmbCameraList = New System.Windows.Forms.ComboBox
		Me.btnOK = New System.Windows.Forms.Button
		Me.btnCancel = New System.Windows.Forms.Button
		Me.TimerCheckCamera = New System.Windows.Forms.Timer(Me.components)
		Me.SuspendLayout()
		'
		'cmbCameraList
		'
		Me.cmbCameraList.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList
		Me.cmbCameraList.Location = New System.Drawing.Point(8, 8)
		Me.cmbCameraList.Name = "cmbCameraList"
		Me.cmbCameraList.Size = New System.Drawing.Size(208, 20)
		Me.cmbCameraList.TabIndex = 1
		'
		'btnOK
		'
		Me.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK
		Me.btnOK.Location = New System.Drawing.Point(72, 40)
		Me.btnOK.Name = "btnOK"
		Me.btnOK.TabIndex = 2
		Me.btnOK.Text = "OK"
		'
		'btnCancel
		'
		Me.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel
		Me.btnCancel.Location = New System.Drawing.Point(144, 40)
		Me.btnCancel.Name = "btnCancel"
		Me.btnCancel.TabIndex = 3
		Me.btnCancel.Text = "Cancel"
		'
		'TimerCheckCamera
		'
		Me.TimerCheckCamera.Interval = 500
		'
		'FormSelectCamera
		'
		Me.AcceptButton = Me.btnOK
		Me.AutoScaleBaseSize = New System.Drawing.Size(5, 12)
		Me.CancelButton = Me.btnCancel
		Me.ClientSize = New System.Drawing.Size(224, 77)
		Me.Controls.Add(Me.btnCancel)
		Me.Controls.Add(Me.btnOK)
		Me.Controls.Add(Me.cmbCameraList)
		Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog
		Me.Name = "FormSelectCamera"
		Me.Text = "Select Camera"
		Me.ResumeLayout(False)

	End Sub

#End Region

	Private m_arrayStCamera As New ArrayList(127)
	Private m_keepOpenIndex As Integer = -1


	Private Function mOpenAllCamera() As Boolean
		Dim result As Boolean = True

		For i As Integer = 0 To m_arrayStCamera.Capacity
			Dim stCamera As New CStCamera
			If stCamera.Open() Then
				m_arrayStCamera.Add(stCamera)
			Else
				Exit For
			End If
		Next

		Return (result)
	End Function

	Private Function mCloseCamera() As Boolean
		Dim result As Boolean = True

		Do While (m_keepOpenIndex < m_arrayStCamera.Count - 1) And (0 < m_arrayStCamera.Count)
			Dim stCamera As CStCamera = CType(m_arrayStCamera(m_arrayStCamera.Count - 1), CStCamera)
			stCamera.Dispose()

			m_arrayStCamera.RemoveAt(m_arrayStCamera.Count - 1)
		Loop

		Do While 1 < m_arrayStCamera.Count
			Dim stCamera As CStCamera = CType(m_arrayStCamera(0), CStCamera)
			stCamera.Dispose()
			m_arrayStCamera.RemoveAt(0)
		Loop

		Return (result)
	End Function

	Public ReadOnly Property OpenedCamera() As CStCamera
		Get
			Dim stCamera As CStCamera = Nothing
			If 0 < m_arrayStCamera.Count Then
				stCamera = CType(m_arrayStCamera(0), CStCamera)
			End If
			Return (stCamera)
		End Get
	End Property
	Private Function mUpdateDisplay() As Boolean
		Dim result As Boolean = True
		Dim nSelectedIndex As Integer = cmbCameraList.SelectedIndex

		cmbCameraList.Items.Clear()

		For Each stCamera As CStCamera In m_arrayStCamera
			cmbCameraList.Items.Add(stCamera)
		Next

		If 0 < cmbCameraList.Items.Count Then
			If nSelectedIndex < 0 Then
				nSelectedIndex = 0
			ElseIf cmbCameraList.Items.Count <= nSelectedIndex Then
				nSelectedIndex = cmbCameraList.Items.Count - 1
			End If
			cmbCameraList.SelectedIndex = nSelectedIndex
			btnOK.Enabled = True
			cmbCameraList.Enabled = True
		Else
			btnOK.Enabled = False
			cmbCameraList.Enabled = False
		End If
		If 1 = cmbCameraList.Items.Count Then
			btnOK.PerformClick()
		End If
		Return (result)
	End Function
	Private Sub btnOK_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnOK.Click
		m_keepOpenIndex = cmbCameraList.SelectedIndex
	End Sub

	Private Sub FormSelectCamera_Activated(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Activated
		RemoveHandler Me.Activated, AddressOf FormSelectCamera_Activated
		TimerCheckCamera.Enabled = True
		btnOK.Enabled = False
		cmbCameraList.Enabled = False
	End Sub

	Private Sub FormSelectCamera_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
		TimerCheckCamera.Enabled = False
		mCloseCamera()
	End Sub

	Private Sub TimerCheckCamera_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles TimerCheckCamera.Tick
		Dim result As Boolean = True
		Do
			result = mCloseCamera()
			If Not result Then
				Exit Do
			End If
			result = mOpenAllCamera()
			If Not result Then
				Exit Do
			End If
			result = mUpdateDisplay()
			If Not result Then
				Exit Do
			End If
		Loop While False
	End Sub
End Class
