Imports SettingCtrl
Public Class FormSetting
	Inherits System.Windows.Forms.Form

#Region " Windows Form Designer Code "

	Public Sub New(ByVal stCamera As CStCamera)
		MyBase.New()

		InitializeComponent()

		m_StCamera = stCamera
	End Sub

	Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
		If disposing Then
			If Not (components Is Nothing) Then
				components.Dispose()
			End If
		End If
		MyBase.Dispose(disposing)
	End Sub

	Private components As System.ComponentModel.IContainer
	Friend WithEvents Label1 As System.Windows.Forms.Label
	Friend WithEvents Label2 As System.Windows.Forms.Label
	Friend WithEvents comboBoxDisplayMode As SettingComboBox
	Friend WithEvents comboBoxAspectMode As SettingComboBox
	Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
	Friend WithEvents Label3 As System.Windows.Forms.Label
	Friend WithEvents Label4 As System.Windows.Forms.Label
	Friend WithEvents Label5 As System.Windows.Forms.Label
	Friend WithEvents Label6 As System.Windows.Forms.Label
	Friend WithEvents tbPWOffsetX As SettingTextBox
	Friend WithEvents sbPWHeight As SettingScrollBar
	Friend WithEvents tbPWHeight As SettingTextBox
	Friend WithEvents sbPWWidth As SettingScrollBar
	Friend WithEvents tbPWWidth As SettingTextBox
	Friend WithEvents sbPWOffsetY As SettingScrollBar
	Friend WithEvents tbPWOffsetY As SettingTextBox
	Friend WithEvents sbPWOffsetX As SettingScrollBar
	Friend WithEvents GroupBox2 As System.Windows.Forms.GroupBox
	Friend WithEvents Label7 As System.Windows.Forms.Label
	Friend WithEvents Label8 As System.Windows.Forms.Label
	Friend WithEvents Label9 As System.Windows.Forms.Label
	Friend WithEvents Label10 As System.Windows.Forms.Label
	Friend WithEvents GroupBox3 As System.Windows.Forms.GroupBox
	Friend WithEvents Label11 As System.Windows.Forms.Label
	Friend WithEvents Label12 As System.Windows.Forms.Label
	Friend WithEvents Label13 As System.Windows.Forms.Label
	Friend WithEvents Label14 As System.Windows.Forms.Label
	Friend WithEvents sbPMHeight As SettingScrollBar
	Friend WithEvents tbPMHeight As SettingTextBox
	Friend WithEvents sbPMWidth As SettingScrollBar
	Friend WithEvents tbPMWidth As SettingTextBox
	Friend WithEvents sbPMOffsetY As SettingScrollBar
	Friend WithEvents tbPMOffsetY As SettingTextBox
	Friend WithEvents sbPMOffsetX As SettingScrollBar
	Friend WithEvents tbPMOffsetX As SettingTextBox
	Friend WithEvents sbPDHeight As SettingScrollBar
	Friend WithEvents tbPDHeight As SettingTextBox
	Friend WithEvents sbPDWidth As SettingScrollBar
	Friend WithEvents tbPDWidth As SettingTextBox
	Friend WithEvents sbPDOffsetY As SettingScrollBar
	Friend WithEvents tbPDOffsetY As SettingTextBox
	Friend WithEvents sbPDOffsetX As SettingScrollBar
	Friend WithEvents tbPDOffsetX As SettingTextBox

	<System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
		Me.tbPWOffsetX = New SettingTextBox
		Me.Label1 = New System.Windows.Forms.Label
		Me.Label2 = New System.Windows.Forms.Label
		Me.comboBoxDisplayMode = New SettingComboBox
		Me.comboBoxAspectMode = New SettingComboBox
		Me.GroupBox1 = New System.Windows.Forms.GroupBox
		Me.sbPWHeight = New SettingScrollBar
		Me.Label6 = New System.Windows.Forms.Label
		Me.tbPWHeight = New SettingTextBox
		Me.sbPWWidth = New SettingScrollBar
		Me.Label5 = New System.Windows.Forms.Label
		Me.tbPWWidth = New SettingTextBox
		Me.sbPWOffsetY = New SettingScrollBar
		Me.Label4 = New System.Windows.Forms.Label
		Me.tbPWOffsetY = New SettingTextBox
		Me.sbPWOffsetX = New SettingScrollBar
		Me.Label3 = New System.Windows.Forms.Label
		Me.GroupBox2 = New System.Windows.Forms.GroupBox
		Me.sbPMHeight = New SettingScrollBar
		Me.Label7 = New System.Windows.Forms.Label
		Me.tbPMHeight = New SettingTextBox
		Me.sbPMWidth = New SettingScrollBar
		Me.Label8 = New System.Windows.Forms.Label
		Me.tbPMWidth = New SettingTextBox
		Me.sbPMOffsetY = New SettingScrollBar
		Me.Label9 = New System.Windows.Forms.Label
		Me.tbPMOffsetY = New SettingTextBox
		Me.sbPMOffsetX = New SettingScrollBar
		Me.Label10 = New System.Windows.Forms.Label
		Me.tbPMOffsetX = New SettingTextBox
		Me.GroupBox3 = New System.Windows.Forms.GroupBox
		Me.sbPDHeight = New SettingScrollBar
		Me.Label11 = New System.Windows.Forms.Label
		Me.tbPDHeight = New SettingTextBox
		Me.sbPDWidth = New SettingScrollBar
		Me.Label12 = New System.Windows.Forms.Label
		Me.tbPDWidth = New SettingTextBox
		Me.sbPDOffsetY = New SettingScrollBar
		Me.Label13 = New System.Windows.Forms.Label
		Me.tbPDOffsetY = New SettingTextBox
		Me.sbPDOffsetX = New SettingScrollBar
		Me.Label14 = New System.Windows.Forms.Label
		Me.tbPDOffsetX = New SettingTextBox
		Me.GroupBox1.SuspendLayout()
		Me.GroupBox2.SuspendLayout()
		Me.GroupBox3.SuspendLayout()
		Me.SuspendLayout()
		'
		'tbPWOffsetX
		'
		Me.tbPWOffsetX.Location = New System.Drawing.Point(352, 24)
		Me.tbPWOffsetX.SettingMax = 1023
		Me.tbPWOffsetX.SettingMin = 0
		Me.tbPWOffsetX.Name = "tbPWOffsetX"
		Me.tbPWOffsetX.SettingID = SettingIDs.PW_OFFSETX
		Me.tbPWOffsetX.SettingValue = 0
		Me.tbPWOffsetX.Size = New System.Drawing.Size(48, 19)
		Me.tbPWOffsetX.TabIndex = 0
		Me.tbPWOffsetX.Text = "0"
		Me.tbPWOffsetX.TextAlign = System.Windows.Forms.HorizontalAlignment.Right
		'
		'Label1
		'
		Me.Label1.AutoSize = True
		Me.Label1.Location = New System.Drawing.Point(8, 8)
		Me.Label1.Name = "Label1"
		Me.Label1.Size = New System.Drawing.Size(73, 15)
		Me.Label1.TabIndex = 3
		Me.Label1.Text = "Display Mode"
		'
		'Label2
		'
		Me.Label2.AutoSize = True
		Me.Label2.Location = New System.Drawing.Point(8, 40)
		Me.Label2.Name = "Label2"
		Me.Label2.Size = New System.Drawing.Size(72, 15)
		Me.Label2.TabIndex = 4
		Me.Label2.Text = "Aspect Mode"
		'
		'comboBoxDisplayMode
		'
		Me.comboBoxDisplayMode.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList
		Me.comboBoxDisplayMode.Location = New System.Drawing.Point(120, 8)
		Me.comboBoxDisplayMode.Name = "comboBoxDisplayMode"
		Me.comboBoxDisplayMode.SettingID = SettingIDs.DISPLAY_MODE
		Me.comboBoxDisplayMode.SettingValue = 0
		Me.comboBoxDisplayMode.Size = New System.Drawing.Size(240, 20)
		Me.comboBoxDisplayMode.TabIndex = 5
		'
		'comboBoxAspectMode
		'
		Me.comboBoxAspectMode.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList
		Me.comboBoxAspectMode.Location = New System.Drawing.Point(120, 32)
		Me.comboBoxAspectMode.Name = "comboBoxAspectMode"
		Me.comboBoxAspectMode.SettingID = SettingIDs.ASPECT_MODE
		Me.comboBoxAspectMode.SettingValue = 0
		Me.comboBoxAspectMode.Size = New System.Drawing.Size(240, 20)
		Me.comboBoxAspectMode.TabIndex = 6
		'
		'GroupBox1
		'
		Me.GroupBox1.Controls.Add(Me.sbPWHeight)
		Me.GroupBox1.Controls.Add(Me.Label6)
		Me.GroupBox1.Controls.Add(Me.tbPWHeight)
		Me.GroupBox1.Controls.Add(Me.sbPWWidth)
		Me.GroupBox1.Controls.Add(Me.Label5)
		Me.GroupBox1.Controls.Add(Me.tbPWWidth)
		Me.GroupBox1.Controls.Add(Me.sbPWOffsetY)
		Me.GroupBox1.Controls.Add(Me.Label4)
		Me.GroupBox1.Controls.Add(Me.tbPWOffsetY)
		Me.GroupBox1.Controls.Add(Me.sbPWOffsetX)
		Me.GroupBox1.Controls.Add(Me.Label3)
		Me.GroupBox1.Controls.Add(Me.tbPWOffsetX)
		Me.GroupBox1.Location = New System.Drawing.Point(16, 72)
		Me.GroupBox1.Name = "GroupBox1"
		Me.GroupBox1.Size = New System.Drawing.Size(416, 128)
		Me.GroupBox1.TabIndex = 7
		Me.GroupBox1.TabStop = False
		Me.GroupBox1.Text = "Preview Window Size"
		'
		'sbPWHeight
		'
		Me.sbPWHeight.Location = New System.Drawing.Point(112, 96)
		Me.sbPWHeight.SettingMax = 100
		Me.sbPWHeight.SettingMin = 0
		Me.sbPWHeight.Name = "sbPWHeight"
		Me.sbPWHeight.SettingID = SettingIDs.PW_HEIGHT
		Me.sbPWHeight.SettingValue = 0
		Me.sbPWHeight.Size = New System.Drawing.Size(232, 16)
		Me.sbPWHeight.TabIndex = 15
		'
		'Label6
		'
		Me.Label6.AutoSize = True
		Me.Label6.Location = New System.Drawing.Point(16, 96)
		Me.Label6.Name = "Label6"
		Me.Label6.Size = New System.Drawing.Size(37, 15)
		Me.Label6.TabIndex = 14
		Me.Label6.Text = "Height"
		'
		'tbPWHeight
		'
		Me.tbPWHeight.Location = New System.Drawing.Point(352, 96)
		Me.tbPWHeight.SettingMax = 1023
		Me.tbPWHeight.SettingMin = 0
		Me.tbPWHeight.Name = "tbPWHeight"
		Me.tbPWHeight.SettingID = SettingIDs.PW_HEIGHT
		Me.tbPWHeight.SettingValue = 0
		Me.tbPWHeight.Size = New System.Drawing.Size(48, 19)
		Me.tbPWHeight.TabIndex = 13
		Me.tbPWHeight.Text = "0"
		Me.tbPWHeight.TextAlign = System.Windows.Forms.HorizontalAlignment.Right
		'
		'sbPWWidth
		'
		Me.sbPWWidth.Location = New System.Drawing.Point(112, 72)
		Me.sbPWWidth.SettingMax = 100
		Me.sbPWWidth.SettingMin = 0
		Me.sbPWWidth.Name = "sbPWWidth"
		Me.sbPWWidth.SettingID = SettingIDs.PW_WIDTH
		Me.sbPWWidth.SettingValue = 0
		Me.sbPWWidth.Size = New System.Drawing.Size(232, 16)
		Me.sbPWWidth.TabIndex = 12
		'
		'Label5
		'
		Me.Label5.AutoSize = True
		Me.Label5.Location = New System.Drawing.Point(16, 72)
		Me.Label5.Name = "Label5"
		Me.Label5.Size = New System.Drawing.Size(33, 15)
		Me.Label5.TabIndex = 11
		Me.Label5.Text = "Width"
		'
		'tbPWWidth
		'
		Me.tbPWWidth.Location = New System.Drawing.Point(352, 72)
		Me.tbPWWidth.SettingMax = 1023
		Me.tbPWWidth.SettingMin = 0
		Me.tbPWWidth.Name = "tbPWWidth"
		Me.tbPWWidth.SettingID = SettingIDs.PW_WIDTH
		Me.tbPWWidth.SettingValue = 0
		Me.tbPWWidth.Size = New System.Drawing.Size(48, 19)
		Me.tbPWWidth.TabIndex = 10
		Me.tbPWWidth.Text = "0"
		Me.tbPWWidth.TextAlign = System.Windows.Forms.HorizontalAlignment.Right
		'
		'sbPWOffsetY
		'
		Me.sbPWOffsetY.Location = New System.Drawing.Point(112, 48)
		Me.sbPWOffsetY.SettingMax = 100
		Me.sbPWOffsetY.SettingMin = 0
		Me.sbPWOffsetY.Name = "sbPWOffsetY"
		Me.sbPWOffsetY.SettingID = SettingIDs.PW_OFFSETY
		Me.sbPWOffsetY.SettingValue = 0
		Me.sbPWOffsetY.Size = New System.Drawing.Size(232, 16)
		Me.sbPWOffsetY.TabIndex = 9
		'
		'Label4
		'
		Me.Label4.AutoSize = True
		Me.Label4.Location = New System.Drawing.Point(16, 48)
		Me.Label4.Name = "Label4"
		Me.Label4.Size = New System.Drawing.Size(48, 15)
		Me.Label4.TabIndex = 8
		Me.Label4.Text = "Offset Y"
		'
		'tbPWOffsetY
		'
		Me.tbPWOffsetY.Location = New System.Drawing.Point(352, 48)
		Me.tbPWOffsetY.SettingMax = 1023
		Me.tbPWOffsetY.SettingMin = 0
		Me.tbPWOffsetY.Name = "tbPWOffsetY"
		Me.tbPWOffsetY.SettingID = SettingIDs.PW_OFFSETY
		Me.tbPWOffsetY.SettingValue = 0
		Me.tbPWOffsetY.Size = New System.Drawing.Size(48, 19)
		Me.tbPWOffsetY.TabIndex = 7
		Me.tbPWOffsetY.Text = "0"
		Me.tbPWOffsetY.TextAlign = System.Windows.Forms.HorizontalAlignment.Right
		'
		'sbPWOffsetX
		'
		Me.sbPWOffsetX.Location = New System.Drawing.Point(112, 24)
		Me.sbPWOffsetX.SettingMax = 100
		Me.sbPWOffsetX.SettingMin = 0
		Me.sbPWOffsetX.Name = "sbPWOffsetX"
		Me.sbPWOffsetX.SettingID = SettingIDs.PW_OFFSETX
		Me.sbPWOffsetX.SettingValue = 0
		Me.sbPWOffsetX.Size = New System.Drawing.Size(232, 16)
		Me.sbPWOffsetX.TabIndex = 6
		'
		'Label3
		'
		Me.Label3.AutoSize = True
		Me.Label3.Location = New System.Drawing.Point(16, 24)
		Me.Label3.Name = "Label3"
		Me.Label3.Size = New System.Drawing.Size(48, 15)
		Me.Label3.TabIndex = 5
		Me.Label3.Text = "Offset X"
		'
		'GroupBox2
		'
		Me.GroupBox2.Controls.Add(Me.sbPMHeight)
		Me.GroupBox2.Controls.Add(Me.Label7)
		Me.GroupBox2.Controls.Add(Me.tbPMHeight)
		Me.GroupBox2.Controls.Add(Me.sbPMWidth)
		Me.GroupBox2.Controls.Add(Me.Label8)
		Me.GroupBox2.Controls.Add(Me.tbPMWidth)
		Me.GroupBox2.Controls.Add(Me.sbPMOffsetY)
		Me.GroupBox2.Controls.Add(Me.Label9)
		Me.GroupBox2.Controls.Add(Me.tbPMOffsetY)
		Me.GroupBox2.Controls.Add(Me.sbPMOffsetX)
		Me.GroupBox2.Controls.Add(Me.Label10)
		Me.GroupBox2.Controls.Add(Me.tbPMOffsetX)
		Me.GroupBox2.Location = New System.Drawing.Point(16, 208)
		Me.GroupBox2.Name = "GroupBox2"
		Me.GroupBox2.Size = New System.Drawing.Size(416, 128)
		Me.GroupBox2.TabIndex = 8
		Me.GroupBox2.TabStop = False
		Me.GroupBox2.Text = "Preview Mask Size"
		'
		'sbPMHeight
		'
		Me.sbPMHeight.Location = New System.Drawing.Point(112, 96)
		Me.sbPMHeight.SettingMax = 100
		Me.sbPMHeight.SettingMin = 0
		Me.sbPMHeight.Name = "sbPMHeight"
		Me.sbPMHeight.SettingID = SettingIDs.PM_HEIGHT
		Me.sbPMHeight.SettingValue = 0
		Me.sbPMHeight.Size = New System.Drawing.Size(232, 16)
		Me.sbPMHeight.TabIndex = 15
		'
		'Label7
		'
		Me.Label7.AutoSize = True
		Me.Label7.Location = New System.Drawing.Point(16, 96)
		Me.Label7.Name = "Label7"
		Me.Label7.Size = New System.Drawing.Size(37, 15)
		Me.Label7.TabIndex = 14
		Me.Label7.Text = "Height"
		'
		'tbPMHeight
		'
		Me.tbPMHeight.Location = New System.Drawing.Point(352, 96)
		Me.tbPMHeight.SettingMax = 1023
		Me.tbPMHeight.SettingMin = 0
		Me.tbPMHeight.Name = "tbPMHeight"
		Me.tbPMHeight.SettingID = SettingIDs.PM_HEIGHT
		Me.tbPMHeight.SettingValue = 0
		Me.tbPMHeight.Size = New System.Drawing.Size(48, 19)
		Me.tbPMHeight.TabIndex = 13
		Me.tbPMHeight.Text = "0"
		Me.tbPMHeight.TextAlign = System.Windows.Forms.HorizontalAlignment.Right
		'
		'sbPMWidth
		'
		Me.sbPMWidth.Location = New System.Drawing.Point(112, 72)
		Me.sbPMWidth.SettingMax = 100
		Me.sbPMWidth.SettingMin = 0
		Me.sbPMWidth.Name = "sbPMWidth"
		Me.sbPMWidth.SettingID = SettingIDs.PM_WIDTH
		Me.sbPMWidth.SettingValue = 0
		Me.sbPMWidth.Size = New System.Drawing.Size(232, 16)
		Me.sbPMWidth.TabIndex = 12
		'
		'Label8
		'
		Me.Label8.AutoSize = True
		Me.Label8.Location = New System.Drawing.Point(16, 72)
		Me.Label8.Name = "Label8"
		Me.Label8.Size = New System.Drawing.Size(33, 15)
		Me.Label8.TabIndex = 11
		Me.Label8.Text = "Width"
		'
		'tbPMWidth
		'
		Me.tbPMWidth.Location = New System.Drawing.Point(352, 72)
		Me.tbPMWidth.SettingMax = 1023
		Me.tbPMWidth.SettingMin = 0
		Me.tbPMWidth.Name = "tbPMWidth"
		Me.tbPMWidth.SettingID = SettingIDs.PM_WIDTH
		Me.tbPMWidth.SettingValue = 0
		Me.tbPMWidth.Size = New System.Drawing.Size(48, 19)
		Me.tbPMWidth.TabIndex = 10
		Me.tbPMWidth.Text = "0"
		Me.tbPMWidth.TextAlign = System.Windows.Forms.HorizontalAlignment.Right
		'
		'sbPMOffsetY
		'
		Me.sbPMOffsetY.Location = New System.Drawing.Point(112, 48)
		Me.sbPMOffsetY.SettingMax = 100
		Me.sbPMOffsetY.SettingMin = 0
		Me.sbPMOffsetY.Name = "sbPMOffsetY"
		Me.sbPMOffsetY.SettingID = SettingIDs.PM_OFFSETY
		Me.sbPMOffsetY.SettingValue = 0
		Me.sbPMOffsetY.Size = New System.Drawing.Size(232, 16)
		Me.sbPMOffsetY.TabIndex = 9
		'
		'Label9
		'
		Me.Label9.AutoSize = True
		Me.Label9.Location = New System.Drawing.Point(16, 48)
		Me.Label9.Name = "Label9"
		Me.Label9.Size = New System.Drawing.Size(48, 15)
		Me.Label9.TabIndex = 8
		Me.Label9.Text = "Offset Y"
		'
		'tbPMOffsetY
		'
		Me.tbPMOffsetY.Location = New System.Drawing.Point(352, 48)
		Me.tbPMOffsetY.SettingMax = 1023
		Me.tbPMOffsetY.SettingMin = 0
		Me.tbPMOffsetY.Name = "tbPMOffsetY"
		Me.tbPMOffsetY.SettingID = SettingIDs.PM_OFFSETY
		Me.tbPMOffsetY.SettingValue = 0
		Me.tbPMOffsetY.Size = New System.Drawing.Size(48, 19)
		Me.tbPMOffsetY.TabIndex = 7
		Me.tbPMOffsetY.Text = "0"
		Me.tbPMOffsetY.TextAlign = System.Windows.Forms.HorizontalAlignment.Right
		'
		'sbPMOffsetX
		'
		Me.sbPMOffsetX.Location = New System.Drawing.Point(112, 24)
		Me.sbPMOffsetX.SettingMax = 100
		Me.sbPMOffsetX.SettingMin = 0
		Me.sbPMOffsetX.Name = "sbPMOffsetX"
		Me.sbPMOffsetX.SettingID = SettingIDs.PM_OFFSETX
		Me.sbPMOffsetX.SettingValue = 0
		Me.sbPMOffsetX.Size = New System.Drawing.Size(232, 16)
		Me.sbPMOffsetX.TabIndex = 6
		'
		'Label10
		'
		Me.Label10.AutoSize = True
		Me.Label10.Location = New System.Drawing.Point(16, 24)
		Me.Label10.Name = "Label10"
		Me.Label10.Size = New System.Drawing.Size(48, 15)
		Me.Label10.TabIndex = 5
		Me.Label10.Text = "Offset X"
		'
		'tbPMOffsetX
		'
		Me.tbPMOffsetX.Location = New System.Drawing.Point(352, 24)
		Me.tbPMOffsetX.SettingMax = 1023
		Me.tbPMOffsetX.SettingMin = 0
		Me.tbPMOffsetX.Name = "tbPMOffsetX"
		Me.tbPMOffsetX.SettingID = SettingIDs.PM_OFFSETX
		Me.tbPMOffsetX.SettingValue = 0
		Me.tbPMOffsetX.Size = New System.Drawing.Size(48, 19)
		Me.tbPMOffsetX.TabIndex = 0
		Me.tbPMOffsetX.Text = "0"
		Me.tbPMOffsetX.TextAlign = System.Windows.Forms.HorizontalAlignment.Right
		'
		'GroupBox3
		'
		Me.GroupBox3.Controls.Add(Me.sbPDHeight)
		Me.GroupBox3.Controls.Add(Me.Label11)
		Me.GroupBox3.Controls.Add(Me.tbPDHeight)
		Me.GroupBox3.Controls.Add(Me.sbPDWidth)
		Me.GroupBox3.Controls.Add(Me.Label12)
		Me.GroupBox3.Controls.Add(Me.tbPDWidth)
		Me.GroupBox3.Controls.Add(Me.sbPDOffsetY)
		Me.GroupBox3.Controls.Add(Me.Label13)
		Me.GroupBox3.Controls.Add(Me.tbPDOffsetY)
		Me.GroupBox3.Controls.Add(Me.sbPDOffsetX)
		Me.GroupBox3.Controls.Add(Me.Label14)
		Me.GroupBox3.Controls.Add(Me.tbPDOffsetX)
		Me.GroupBox3.Location = New System.Drawing.Point(16, 344)
		Me.GroupBox3.Name = "GroupBox3"
		Me.GroupBox3.Size = New System.Drawing.Size(416, 128)
		Me.GroupBox3.TabIndex = 9
		Me.GroupBox3.TabStop = False
		Me.GroupBox3.Text = "Preview Dest Size"
		'
		'sbPDHeight
		'
		Me.sbPDHeight.Location = New System.Drawing.Point(112, 96)
		Me.sbPDHeight.SettingMax = 100
		Me.sbPDHeight.SettingMin = 0
		Me.sbPDHeight.Name = "sbPDHeight"
		Me.sbPDHeight.SettingID = SettingIDs.PD_HEIGHT
		Me.sbPDHeight.SettingValue = 0
		Me.sbPDHeight.Size = New System.Drawing.Size(232, 16)
		Me.sbPDHeight.TabIndex = 15
		'
		'Label11
		'
		Me.Label11.AutoSize = True
		Me.Label11.Location = New System.Drawing.Point(16, 96)
		Me.Label11.Name = "Label11"
		Me.Label11.Size = New System.Drawing.Size(37, 15)
		Me.Label11.TabIndex = 14
		Me.Label11.Text = "Height"
		'
		'tbPDHeight
		'
		Me.tbPDHeight.Location = New System.Drawing.Point(352, 96)
		Me.tbPDHeight.SettingMax = 1023
		Me.tbPDHeight.SettingMin = 0
		Me.tbPDHeight.Name = "tbPDHeight"
		Me.tbPDHeight.SettingID = SettingIDs.PD_HEIGHT
		Me.tbPDHeight.SettingValue = 0
		Me.tbPDHeight.Size = New System.Drawing.Size(48, 19)
		Me.tbPDHeight.TabIndex = 13
		Me.tbPDHeight.Text = "0"
		Me.tbPDHeight.TextAlign = System.Windows.Forms.HorizontalAlignment.Right
		'
		'sbPDWidth
		'
		Me.sbPDWidth.Location = New System.Drawing.Point(112, 72)
		Me.sbPDWidth.SettingMax = 100
		Me.sbPDWidth.SettingMin = 0
		Me.sbPDWidth.Name = "sbPDWidth"
		Me.sbPDWidth.SettingID = SettingIDs.PD_WIDTH
		Me.sbPDWidth.SettingValue = 0
		Me.sbPDWidth.Size = New System.Drawing.Size(232, 16)
		Me.sbPDWidth.TabIndex = 12
		'
		'Label12
		'
		Me.Label12.AutoSize = True
		Me.Label12.Location = New System.Drawing.Point(16, 72)
		Me.Label12.Name = "Label12"
		Me.Label12.Size = New System.Drawing.Size(33, 15)
		Me.Label12.TabIndex = 11
		Me.Label12.Text = "Width"
		'
		'tbPDWidth
		'
		Me.tbPDWidth.Location = New System.Drawing.Point(352, 72)
		Me.tbPDWidth.SettingMax = 1023
		Me.tbPDWidth.SettingMin = 0
		Me.tbPDWidth.Name = "tbPDWidth"
		Me.tbPDWidth.SettingID = SettingIDs.PD_WIDTH
		Me.tbPDWidth.SettingValue = 0
		Me.tbPDWidth.Size = New System.Drawing.Size(48, 19)
		Me.tbPDWidth.TabIndex = 10
		Me.tbPDWidth.Text = "0"
		Me.tbPDWidth.TextAlign = System.Windows.Forms.HorizontalAlignment.Right
		'
		'sbPDOffsetY
		'
		Me.sbPDOffsetY.Location = New System.Drawing.Point(112, 48)
		Me.sbPDOffsetY.SettingMax = 100
		Me.sbPDOffsetY.SettingMin = 0
		Me.sbPDOffsetY.Name = "sbPDOffsetY"
		Me.sbPDOffsetY.SettingID = SettingIDs.PD_OFFSETY
		Me.sbPDOffsetY.SettingValue = 0
		Me.sbPDOffsetY.Size = New System.Drawing.Size(232, 16)
		Me.sbPDOffsetY.TabIndex = 9
		'
		'Label13
		'
		Me.Label13.AutoSize = True
		Me.Label13.Location = New System.Drawing.Point(16, 48)
		Me.Label13.Name = "Label13"
		Me.Label13.Size = New System.Drawing.Size(48, 15)
		Me.Label13.TabIndex = 8
		Me.Label13.Text = "Offset Y"
		'
		'tbPDOffsetY
		'
		Me.tbPDOffsetY.Location = New System.Drawing.Point(352, 48)
		Me.tbPDOffsetY.SettingMax = 1023
		Me.tbPDOffsetY.SettingMin = 0
		Me.tbPDOffsetY.Name = "tbPDOffsetY"
		Me.tbPDOffsetY.SettingID = SettingIDs.PD_OFFSETY
		Me.tbPDOffsetY.SettingValue = 0
		Me.tbPDOffsetY.Size = New System.Drawing.Size(48, 19)
		Me.tbPDOffsetY.TabIndex = 7
		Me.tbPDOffsetY.Text = "0"
		Me.tbPDOffsetY.TextAlign = System.Windows.Forms.HorizontalAlignment.Right
		'
		'sbPDOffsetX
		'
		Me.sbPDOffsetX.Location = New System.Drawing.Point(112, 24)
		Me.sbPDOffsetX.SettingMax = 100
		Me.sbPDOffsetX.SettingMin = 0
		Me.sbPDOffsetX.Name = "sbPDOffsetX"
		Me.sbPDOffsetX.SettingID = SettingIDs.PD_OFFSETX
		Me.sbPDOffsetX.SettingValue = 0
		Me.sbPDOffsetX.Size = New System.Drawing.Size(232, 16)
		Me.sbPDOffsetX.TabIndex = 6
		'
		'Label14
		'
		Me.Label14.AutoSize = True
		Me.Label14.Location = New System.Drawing.Point(16, 24)
		Me.Label14.Name = "Label14"
		Me.Label14.Size = New System.Drawing.Size(48, 15)
		Me.Label14.TabIndex = 5
		Me.Label14.Text = "Offset X"
		'
		'tbPDOffsetX
		'
		Me.tbPDOffsetX.Location = New System.Drawing.Point(352, 24)
		Me.tbPDOffsetX.SettingMax = 1023
		Me.tbPDOffsetX.SettingMin = 0
		Me.tbPDOffsetX.Name = "tbPDOffsetX"
		Me.tbPDOffsetX.SettingID = SettingIDs.PD_OFFSETX
		Me.tbPDOffsetX.SettingValue = 0
		Me.tbPDOffsetX.Size = New System.Drawing.Size(48, 19)
		Me.tbPDOffsetX.TabIndex = 0
		Me.tbPDOffsetX.Text = "0"
		Me.tbPDOffsetX.TextAlign = System.Windows.Forms.HorizontalAlignment.Right
		'
		'FormSetting
		'
		Me.AutoScaleBaseSize = New System.Drawing.Size(5, 12)
		Me.ClientSize = New System.Drawing.Size(440, 478)
		Me.Controls.Add(Me.GroupBox3)
		Me.Controls.Add(Me.GroupBox2)
		Me.Controls.Add(Me.GroupBox1)
		Me.Controls.Add(Me.comboBoxAspectMode)
		Me.Controls.Add(Me.comboBoxDisplayMode)
		Me.Controls.Add(Me.Label2)
		Me.Controls.Add(Me.Label1)
		Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog
		Me.Name = "FormSetting"
		Me.Text = "Set Size"
		Me.GroupBox1.ResumeLayout(False)
		Me.GroupBox2.ResumeLayout(False)
		Me.GroupBox3.ResumeLayout(False)
		Me.ResumeLayout(False)

	End Sub

#End Region
	Private m_StCamera As CStCamera

	Private Sub OnUpdateSettingValue(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles _
	 comboBoxAspectMode.SettingValueChanged, comboBoxDisplayMode.SettingValueChanged, _
	 tbPWOffsetX.SettingValueChanged, tbPWOffsetY.SettingValueChanged, tbPWWidth.SettingValueChanged, tbPWHeight.SettingValueChanged, _
	 sbPWOffsetX.SettingValueChanged, sbPWOffsetY.SettingValueChanged, sbPWWidth.SettingValueChanged, sbPWHeight.SettingValueChanged, _
	 tbPMOffsetX.SettingValueChanged, tbPMOffsetY.SettingValueChanged, tbPMWidth.SettingValueChanged, tbPMHeight.SettingValueChanged, _
	 sbPMOffsetX.SettingValueChanged, sbPMOffsetY.SettingValueChanged, sbPMWidth.SettingValueChanged, sbPMHeight.SettingValueChanged, _
	 tbPDOffsetX.SettingValueChanged, tbPDOffsetY.SettingValueChanged, tbPDWidth.SettingValueChanged, tbPDHeight.SettingValueChanged, _
	 sbPDOffsetX.SettingValueChanged, sbPDOffsetY.SettingValueChanged, sbPDWidth.SettingValueChanged, sbPDHeight.SettingValueChanged
		Dim isc As ISettingCtrl = CType(sender, ISettingCtrl)

		Select Case isc.SettingID
			Case SettingIDs.DISPLAY_MODE
				m_StCamera.DisplayMode = CType(isc.SettingValue, Byte)
			Case SettingIDs.ASPECT_MODE
				m_StCamera.AspectMode = CType(isc.SettingValue, Byte)
			Case SettingIDs.PW_OFFSETX
				m_StCamera.PreviewWindowOffsetX = isc.SettingValue
			Case SettingIDs.PW_OFFSETY
				m_StCamera.PreviewWindowOffsetY = isc.SettingValue
			Case SettingIDs.PW_WIDTH
				m_StCamera.PreviewWindowWidth = isc.SettingValue
			Case SettingIDs.PW_HEIGHT
				m_StCamera.PreviewWindowHeight = isc.SettingValue
			Case SettingIDs.PM_OFFSETX
				m_StCamera.PreviewMaskOffsetX = isc.SettingValue
			Case SettingIDs.PM_OFFSETY
				m_StCamera.PreviewMaskOffsetY = isc.SettingValue
			Case SettingIDs.PM_WIDTH
				m_StCamera.PreviewMaskWidth = isc.SettingValue
			Case SettingIDs.PM_HEIGHT
				m_StCamera.PreviewMaskHeight = isc.SettingValue
			Case SettingIDs.PD_OFFSETX
				m_StCamera.PreviewDestOffsetX = isc.SettingValue
			Case SettingIDs.PD_OFFSETY
				m_StCamera.PreviewDestOffsetY = isc.SettingValue
			Case SettingIDs.PD_WIDTH
				m_StCamera.PreviewDestWidth = isc.SettingValue
			Case SettingIDs.PD_HEIGHT
				m_StCamera.PreviewDestHeight = isc.SettingValue
		End Select

		mUpdateDisplay()
		Debug.WriteLine("id=" & isc.SettingID.ToString() & ", value=" & isc.SettingValue.ToString())
	End Sub

	Private Sub FormSetting_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
		mInitComboBox()
		mUpdateDisplay()
	End Sub


	Private Sub mUpdateDisplay()
		mUpdateDisplayComboBox()
		mUpdateDisplayTextBoxAndScrollBar()
	End Sub
	Private Sub mInitComboBox()
		Dim itemsAspectMode() As CItemForComboBox = { _
		 New CItemForComboBox("Fixed", StCam.STCAM_ASPECT_MODE_FIXED), _
		 New CItemForComboBox("Keep Aspect", StCam.STCAM_ASPECT_MODE_KEEP_ASPECT), _
		 New CItemForComboBox("Adjust Window", StCam.STCAM_ASPECT_MODE_ADJUST_WINDOW), _
		 New CItemForComboBox("Mask", StCam.STCAM_ASPECT_MODE_MASK_SIZE), _
		 New CItemForComboBox("Custom(Offset)", StCam.STCAM_ASPECT_MODE_CUSTOM_OFFSET), _
		 New CItemForComboBox("Custom(Center)", StCam.STCAM_ASPECT_MODE_CUSTOM_CENTER)}
		comboBoxAspectMode.Items.Clear()
		comboBoxAspectMode.Items.AddRange(itemsAspectMode)
		comboBoxAspectMode.SelectedIndex = 0

		Dim itemsDisplayMode() As CItemForComboBox = { _
		 New CItemForComboBox("GDI", StCam.STCAM_DISPLAY_MODE_GDI), _
		 New CItemForComboBox("DirectDraw[Offscreeen]", StCam.STCAM_DISPLAY_MODE_DD_OFFSCREEN), _
		 New CItemForComboBox("DirectDraw[Overlay]", StCam.STCAM_DISPLAY_MODE_DD_OVERLAY), _
		 New CItemForComboBox("DirectDraw[Offscreen HQ]", StCam.STCAM_DISPLAY_MODE_DD_OFFSCREEN_HQ), _
		 New CItemForComboBox("DirectDraw[Overlay HQ]", StCam.STCAM_DISPLAY_MODE_DD_OVERLAY_HQ), _
		 New CItemForComboBox("DirectX", StCam.STCAM_DISPLAY_MODE_DIRECTX), _
		 New CItemForComboBox("DirectX[V Sync ON]", StCam.STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON), _
		 New CItemForComboBox("DirectX[V Sync ON 2]", StCam.STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON2)}
		comboBoxDisplayMode.Items.Clear()
		comboBoxDisplayMode.Items.AddRange(itemsDisplayMode)
		comboBoxDisplayMode.SelectedIndex = 0
	End Sub

	Private Sub mUpdateDisplayComboBox()
		comboBoxDisplayMode.SettingValue = m_StCamera.DisplayMode()
		comboBoxAspectMode.SettingValue = m_StCamera.AspectMode()
	End Sub

	Private Sub mUpdateDisplayTextBoxAndScrollBar()
		Dim aTB() As SettingTextBox = { _
		 tbPWOffsetX, tbPWOffsetY, tbPWWidth, tbPWHeight, _
		 tbPMOffsetX, tbPMOffsetY, tbPMWidth, tbPMHeight, _
		 tbPDOffsetX, tbPDOffsetY, tbPDWidth, tbPDHeight}
		Dim aSB() As SettingScrollBar = { _
		 sbPWOffsetX, sbPWOffsetY, sbPWWidth, sbPWHeight, _
		 sbPMOffsetX, sbPMOffsetY, sbPMWidth, sbPMHeight, _
		 sbPDOffsetX, sbPDOffsetY, sbPDWidth, sbPDHeight}

		For i As Integer = 0 To UBound(aTB)
			Const maxSizeH As Integer = 1600
			Const maxSizeV As Integer = 1600
			Dim value As Integer = 0
			Dim max As Integer = 0
			Dim min As Integer = 0
			Dim enabled As Boolean = True

			'value , max
			Select Case aTB(i).SettingID
				Case SettingIDs.PW_OFFSETX
					max = maxSizeH
					value = m_StCamera.PreviewWindowOffsetX
				Case SettingIDs.PW_OFFSETY
					max = maxSizeV
					value = m_StCamera.PreviewWindowOffsetY
				Case SettingIDs.PW_WIDTH
					max = maxSizeH
					value = m_StCamera.PreviewWindowWidth
				Case SettingIDs.PW_HEIGHT
					max = maxSizeV
					value = m_StCamera.PreviewWindowHeight

				Case SettingIDs.PM_OFFSETX
					max = m_StCamera.OrgImageWidth - m_StCamera.PreviewMaskWidth
					value = m_StCamera.PreviewMaskOffsetX
				Case SettingIDs.PM_OFFSETY
					max = m_StCamera.OrgImageHeight - m_StCamera.PreviewMaskHeight
					value = m_StCamera.PreviewMaskOffsetY
				Case SettingIDs.PM_WIDTH
					max = m_StCamera.OrgImageWidth - m_StCamera.PreviewMaskOffsetX
					value = m_StCamera.PreviewMaskWidth
				Case SettingIDs.PM_HEIGHT
					max = m_StCamera.OrgImageHeight - m_StCamera.PreviewMaskOffsetY
					value = m_StCamera.PreviewMaskHeight

				Case SettingIDs.PD_OFFSETX
					max = maxSizeH
					value = m_StCamera.PreviewDestOffsetX
				Case SettingIDs.PD_OFFSETY
					max = maxSizeV
					value = m_StCamera.PreviewDestOffsetY
				Case SettingIDs.PD_WIDTH
					max = maxSizeH
					value = m_StCamera.PreviewDestWidth
				Case SettingIDs.PD_HEIGHT
					max = maxSizeV
					value = m_StCamera.PreviewDestHeight
			End Select

			'Enabled
			If (max <= min) Or (value < min) Or (max < value) Then
				enabled = False
			Else
				Select Case aTB(i).SettingID
					Case SettingIDs.PD_OFFSETX, SettingIDs.PD_OFFSETY, SettingIDs.PD_WIDTH, SettingIDs.PD_HEIGHT
						Dim byteAspectMode As Byte = m_StCamera.AspectMode
						If (byteAspectMode <> StCam.STCAM_ASPECT_MODE_CUSTOM_OFFSET) And (byteAspectMode <> StCam.STCAM_ASPECT_MODE_CUSTOM) Then
							enabled = False
						End If
				End Select


			End If


			aTB(i).SettingMin = min
			aTB(i).SettingMax = max
			aTB(i).SettingValue = value
			aTB(i).Enabled = enabled

			aSB(i).SettingMin = min
			aSB(i).SettingMax = max
			aSB(i).SettingValue = value
			aSB(i).Enabled = enabled

		Next

	End Sub
End Class
