
Imports System.Runtime.InteropServices
Public Class Form1
	Inherits System.Windows.Forms.Form

#Region " Windows Form Designer Code "

	Public Sub New()
		MyBase.New()

		InitializeComponent()


	End Sub

	Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
		If disposing Then
			If Not (components Is Nothing) Then
				components.Dispose()
			End If
		End If
		MyBase.Dispose(disposing)
	End Sub

	Private components As System.ComponentModel.IContainer

	Friend WithEvents btnPreview As System.Windows.Forms.Button
	Friend WithEvents btnSnap As System.Windows.Forms.Button
	Friend WithEvents btnMovie As System.Windows.Forms.Button
	Friend WithEvents SaveFileDialog1 As System.Windows.Forms.SaveFileDialog
	Friend WithEvents btnFPS As System.Windows.Forms.Button
	<System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
		Me.btnPreview = New System.Windows.Forms.Button
		Me.btnSnap = New System.Windows.Forms.Button
		Me.btnMovie = New System.Windows.Forms.Button
		Me.SaveFileDialog1 = New System.Windows.Forms.SaveFileDialog
		Me.btnFPS = New System.Windows.Forms.Button
		Me.SuspendLayout()
		'
		'btnPreview
		'
		Me.btnPreview.Location = New System.Drawing.Point(8, 8)
		Me.btnPreview.Name = "btnPreview"
		Me.btnPreview.Size = New System.Drawing.Size(88, 23)
		Me.btnPreview.TabIndex = 0
		Me.btnPreview.Text = "Preview"
		'
		'btnSnap
		'
		Me.btnSnap.Location = New System.Drawing.Point(8, 40)
		Me.btnSnap.Name = "btnSnap"
		Me.btnSnap.Size = New System.Drawing.Size(88, 23)
		Me.btnSnap.TabIndex = 1
		Me.btnSnap.Text = "Snap"
		'
		'btnMovie
		'
		Me.btnMovie.Location = New System.Drawing.Point(8, 72)
		Me.btnMovie.Name = "btnMovie"
		Me.btnMovie.Size = New System.Drawing.Size(88, 23)
		Me.btnMovie.TabIndex = 2
		Me.btnMovie.Text = "Movie"
		'
		'SaveFileDialog1
		'
		Me.SaveFileDialog1.DefaultExt = "avi"
		Me.SaveFileDialog1.Filter = "AVI File|*.avi|All Files|*.*"
		'
		'btnFPS
		'
		Me.btnFPS.Location = New System.Drawing.Point(8, 104)
		Me.btnFPS.Name = "btnFPS"
		Me.btnFPS.Size = New System.Drawing.Size(88, 23)
		Me.btnFPS.TabIndex = 3
		Me.btnFPS.Text = "Show FPS"
		'
		'Form1
		'
		Me.AutoScaleBaseSize = New System.Drawing.Size(5, 12)
		Me.ClientSize = New System.Drawing.Size(104, 133)
		Me.Controls.Add(Me.btnFPS)
		Me.Controls.Add(Me.btnMovie)
		Me.Controls.Add(Me.btnSnap)
		Me.Controls.Add(Me.btnPreview)
		Me.Name = "Form1"
		Me.Text = "Form1"
		Me.ResumeLayout(False)

	End Sub

#End Region

	Private m_hCamera As IntPtr
	Private m_bStatusTransfer As Boolean
	Private m_bStatusAVIFile As Boolean
	Private m_bStatusPreviewWnd As Boolean

	Private m_FormSnapShot As FormSnapShot

	Private m_dwPreviewGDICallbackNo As Integer = 0
	Private m_GDICallbackDelegate As StCam.fStCamPreviewGDICallbackFunc = New StCam.fStCamPreviewGDICallbackFunc(AddressOf OnGDICallbackFunc)
	Private m_FPS As New CFPS(100)


	Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
		m_hCamera = StCam.Open(0)
		If m_hCamera.Equals(IntPtr.Zero) Then
			ShowErrorMsg(StCam.GetLastError(m_hCamera))
		End If
		If 0 = StCam.SetReceiveMsgWindow(m_hCamera, Me.Handle) Then
			ShowErrorMsg(StCam.GetLastError(m_hCamera))
		End If
		StatusChanged()
	End Sub

	Private Sub Form1_Closed(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Closed
		If Not m_hCamera.Equals(IntPtr.Zero) Then
			StCam.Close(m_hCamera)
		End If
	End Sub
	Private Sub btnPreview_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPreview.Click
		If m_bStatusPreviewWnd And m_bStatusTransfer Then
			'Stop
			If 0 = StCam.StopTransfer(m_hCamera) Then
				ShowErrorMsg(StCam.GetLastError(m_hCamera))
			End If
		Else
			'Start
			If 0 = StCam.CreatePreviewWindow(m_hCamera, "Preview", StCam.WS_OVERLAPPEDWINDOW Or StCam.WS_VISIBLE, 0, 0, 0, 0, IntPtr.Zero, IntPtr.Zero, StCam.STCAM_FALSE) Then
				ShowErrorMsg(StCam.GetLastError(m_hCamera))
			End If
			If 0 = StCam.StartTransfer(m_hCamera) Then
				ShowErrorMsg(StCam.GetLastError(m_hCamera))
			End If
		End If
	End Sub
	Private Sub StatusChanged()
		If m_bStatusPreviewWnd And m_bStatusTransfer Then
			btnPreview.Text = "STOP"
		Else
			btnPreview.Text = "START"
		End If

		btnMovie.Enabled = Not m_bStatusAVIFile
		If m_dwPreviewGDICallbackNo = 0 Then
			btnFPS.Text = "Show FPS"
		Else
			btnFPS.Text = "Erase FPS"
		End If
	End Sub

	Protected Overrides Sub WndProc(ByRef m As System.Windows.Forms.Message)
		Select Case m.Msg
			Case StCam.WM_STCAM_TRANSFER_START
				m_bStatusTransfer = True
				StatusChanged()
			Case StCam.WM_STCAM_TRANSFER_FINISH
				m_bStatusTransfer = False
				StatusChanged()
				If m.LParam.ToInt32() <> 0 Then
					ShowErrorMsg(m.LParam.ToInt32())
				End If
			Case StCam.WM_STCAM_AVI_FILE_START
				m_bStatusAVIFile = True
				StatusChanged()
			Case StCam.WM_STCAM_AVI_FILE_FINISH
				m_bStatusAVIFile = False
				StatusChanged()
				If m.LParam.ToInt32() <> 0 Then
					ShowErrorMsg(m.LParam.ToInt32())
				End If
			Case StCam.WM_STCAM_PREVIEW_WINDOW_CREATE
				m_bStatusPreviewWnd = True
				StatusChanged()
			Case StCam.WM_STCAM_PREVIEW_WINDOW_CLOSE
				m_bStatusPreviewWnd = False
				StatusChanged()
				If m.LParam.ToInt32() <> 0 Then
					ShowErrorMsg(m.LParam.ToInt32())
				End If
			Case Else
				MyBase.WndProc(m)
		End Select
	End Sub
	<DllImport("kernel32.dll", CharSet:=CharSet.Auto)> _
	Private Shared Function FormatMessage(ByVal dwFlags As Integer, ByVal lpSource As IntPtr, ByVal dwMessageId As Integer, ByVal dwLanguageId As Integer, ByVal lpBuffer As System.Text.StringBuilder, ByVal nSize As Integer, ByRef Arguments As IntPtr) As Integer

	End Function

	<DllImport("kernel32.dll", CharSet:=CharSet.Auto)> _
	Private Shared Function LoadLibraryEx(ByVal lpszLibFile As String, ByVal hFile As IntPtr, ByVal dwFlags As Integer) As IntPtr

	End Function

	<DllImport("kernel32.dll")> _
	Private Shared Function FreeLibrary(ByVal hModule As IntPtr) As Integer

	End Function

	Private Sub ShowErrorMsg(ByVal dwErrorCode As Integer)
		Const FORMAT_MESSAGE_FROM_SYSTEM As Integer = &H1000
		Const FORMAT_MESSAGE_FROM_HMODULE As Integer = &H800
		Const DONT_RESOLVE_DLL_REFERENCES As Integer = &H1

		Dim strErrorMsg As New System.Text.StringBuilder(255)
		Dim nFlags As Integer = FORMAT_MESSAGE_FROM_SYSTEM
		Dim nFoundErrMsg As Integer = 0

		nFoundErrMsg = FormatMessage(nFlags, IntPtr.Zero, dwErrorCode, 0, strErrorMsg, strErrorMsg.Capacity, IntPtr.Zero)
		If nFoundErrMsg = 0 Then
			Dim ptrlpSource As IntPtr
			ptrlpSource = LoadLibraryEx("StCamMsg.dll", IntPtr.Zero, DONT_RESOLVE_DLL_REFERENCES)
			nFlags = nFlags Or FORMAT_MESSAGE_FROM_HMODULE

			If Not ptrlpSource.Equals(IntPtr.Zero) Then
				nFoundErrMsg = FormatMessage(nFlags, ptrlpSource, dwErrorCode, 0, strErrorMsg, strErrorMsg.Capacity, IntPtr.Zero)
				FreeLibrary(ptrlpSource)
			End If
		End If
		System.Windows.Forms.MessageBox.Show(strErrorMsg.ToString(), "Error Message", System.Windows.Forms.MessageBoxButtons.OK, System.Windows.Forms.MessageBoxIcon.Exclamation)
	End Sub

	Private Sub btnSnap_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSnap.Click
		Dim nReval As Integer
		Dim nLastErrorNo As Integer

		Do
			'Get Image Size
			Dim dwReserved As Integer
			Dim wScanMode As Short
			Dim dwOffsetX As Integer
			Dim dwOffsetY As Integer
			Dim dwWidth As Integer
			Dim dwHeight As Integer
			nReval = StCam.GetImageSize(m_hCamera, dwReserved, wScanMode, dwOffsetX, dwOffsetY, dwWidth, dwHeight)
			If nReval = 0 Then
				nLastErrorNo = StCam.GetLastError(m_hCamera)
				Exit Do
			End If

			'Get Preview Pixel Format
			Dim dwPreviewPixelFormat As Integer

			nReval = StCam.GetPreviewPixelFormat(m_hCamera, dwPreviewPixelFormat)
			If nReval = 0 Then
				nLastErrorNo = StCam.GetLastError(m_hCamera)
				Exit Do
			End If

			'Allocate Memory
			Dim nBufferSize As Integer = dwWidth * dwHeight
			Dim pixelFormat As Imaging.PixelFormat = Imaging.PixelFormat.Format8bppIndexed
			Select Case dwPreviewPixelFormat
				Case StCam.STCAM_PIXEL_FORMAT_24_BGR
					nBufferSize = nBufferSize * 3
					pixelFormat = Imaging.PixelFormat.Format24bppRgb
				Case StCam.STCAM_PIXEL_FORMAT_32_BGR
					nBufferSize = nBufferSize * 4
					pixelFormat = Imaging.PixelFormat.Format32bppRgb
			End Select
			Dim pbyteImageBuffer(nBufferSize) As Byte

			'Take Snap Shot
			Dim dwNumberOfByteTrans As Integer = 0
			Dim pdwFrameNo(1) As Integer
			Dim dwMilliseconds As Integer = 100
			Dim gch As System.Runtime.InteropServices.GCHandle = System.Runtime.InteropServices.GCHandle.Alloc(pbyteImageBuffer, System.Runtime.InteropServices.GCHandleType.Pinned)
			Dim ptr As IntPtr = gch.AddrOfPinnedObject()
			nReval = StCam.TakePreviewSnapShot(m_hCamera, ptr, nBufferSize, dwNumberOfByteTrans, pdwFrameNo, dwMilliseconds)
			gch.Free()
			If nReval = 0 Then
				nLastErrorNo = StCam.GetLastError(m_hCamera)
				Exit Do
			End If

			If m_FormSnapShot Is Nothing Then
				m_FormSnapShot = New FormSnapShot
				AddHandler m_FormSnapShot.Closed, AddressOf FormSnapShot_Closed
			End If
			m_FormSnapShot.bUpdateSnapShot(pbyteImageBuffer, dwWidth, dwHeight, pixelFormat)
			m_FormSnapShot.Show()
		Loop While False

		'Show Error Message
		If nReval = 0 Then
			ShowErrorMsg(nLastErrorNo)
		End If
	End Sub

	Private Sub FormSnapShot_Closed(ByVal sender As Object, ByVal e As System.EventArgs)
		m_FormSnapShot = Nothing
	End Sub
	Private Sub btnMovie_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMovie.Click
		Dim nReval As Integer
		Dim nLastErrorNo As Integer

		If DialogResult.OK = SaveFileDialog1.ShowDialog(Me) Then
			nReval = StCam.SaveAVI(m_hCamera, SaveFileDialog1.FileName, StCam.STCAM_AVI_COMPRESSOR_MJPG, 300, IntPtr.Zero)
			If nReval = 0 Then
				nLastErrorNo = StCam.GetLastError(m_hCamera)
			End If
		End If

		'Show Error Message
		If nReval = 0 Then
			ShowErrorMsg(nLastErrorNo)
		End If
	End Sub
	Public Sub OnGDICallbackFunc(ByVal hDC As IntPtr, ByVal dwWidth As Integer, ByVal dwHeight As Integer, ByVal dwFrameNo As Integer, ByVal lpContext As IntPtr, ByVal lpReserved As IntPtr)
		Dim grfx As Graphics = Graphics.FromHdcInternal(hDC)
		Dim fontString As New Font(FontFamily.GenericSerif, 12)
		Dim brushString As New SolidBrush(Color.Black)

		m_FPS.Check()

		Dim dblFPS As Double = m_FPS.GetFPS()
		grfx.DrawString(dblFPS.ToString("0.0") & "FPS", fontString, brushString, 0, 0)

		brushString.Dispose()
		fontString.Dispose()
		grfx.Dispose()
	End Sub

	Private Sub btnFPS_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnFPS.Click
		Dim nReval As Integer
		Dim nLastErrorNo As Integer

		If m_dwPreviewGDICallbackNo = 0 Then
			m_FPS.Reset()
			nReval = StCam.AddPreviewGDICallback(m_hCamera, m_GDICallbackDelegate, IntPtr.Zero, m_dwPreviewGDICallbackNo)
			If nReval = 0 Then
				nLastErrorNo = StCam.GetLastError(m_hCamera)
			End If
		Else
			nReval = StCam.RemovePreviewGDICallback(m_hCamera, m_dwPreviewGDICallbackNo)
			If nReval = 0 Then
				nLastErrorNo = StCam.GetLastError(m_hCamera)
			End If
			m_dwPreviewGDICallbackNo = 0
		End If

		'Show Error Message
		If nReval = 0 Then
			ShowErrorMsg(nLastErrorNo)
		End If

		StatusChanged()
	End Sub
End Class
