
Public Class FormSnapShot
	Inherits System.Windows.Forms.Form

#Region " Windows Form Designer Code "

	Public Sub New()
		MyBase.New()

		InitializeComponent()


	End Sub

	Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
		If disposing Then
			If Not (components Is Nothing) Then
				components.Dispose()
			End If
		End If
		MyBase.Dispose(disposing)
	End Sub

	Private components As System.ComponentModel.IContainer

	Friend WithEvents SaveFileDialog1 As System.Windows.Forms.SaveFileDialog
	Friend WithEvents ContextMenu1 As System.Windows.Forms.ContextMenu
	Friend WithEvents MenuItemSave As System.Windows.Forms.MenuItem
	Friend WithEvents PictureBox1 As System.Windows.Forms.PictureBox
	<System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
		Me.SaveFileDialog1 = New System.Windows.Forms.SaveFileDialog
		Me.ContextMenu1 = New System.Windows.Forms.ContextMenu
		Me.MenuItemSave = New System.Windows.Forms.MenuItem
		Me.PictureBox1 = New System.Windows.Forms.PictureBox
		Me.SuspendLayout()
		'
		'SaveFileDialog1
		'
		Me.SaveFileDialog1.DefaultExt = "bmp"
		Me.SaveFileDialog1.Filter = "Bitmap File|*.bmp|All Files|*.*"
		'
		'ContextMenu1
		'
		Me.ContextMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItemSave})
		'
		'MenuItemSave
		'
		Me.MenuItemSave.Index = 0
		Me.MenuItemSave.Text = "Save"
		'
		'PictureBox1
		'
		Me.PictureBox1.ContextMenu = Me.ContextMenu1
		Me.PictureBox1.Location = New System.Drawing.Point(48, 56)
		Me.PictureBox1.Name = "PictureBox1"
		Me.PictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize
		Me.PictureBox1.TabIndex = 0
		Me.PictureBox1.TabStop = False
		'
		'FormSnapShot
		'
		Me.AutoScaleBaseSize = New System.Drawing.Size(5, 12)
		Me.AutoScroll = True
		Me.ClientSize = New System.Drawing.Size(292, 273)
		Me.Controls.Add(Me.PictureBox1)
		Me.Name = "FormSnapShot"
		Me.Text = "Snap Shot"
		Me.ResumeLayout(False)

	End Sub

#End Region

	Private m_Bitmap As Bitmap
	Private m_SavedFg As Boolean = False
	Private Sub SaveImage()
		If Not m_Bitmap Is Nothing Then
			If DialogResult.OK = SaveFileDialog1.ShowDialog() Then
				m_Bitmap.Save(SaveFileDialog1.FileName, System.Drawing.Imaging.ImageFormat.Bmp)
				m_SavedFg = True
			End If
		End If
	End Sub
	Private Sub MenuItemSave_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItemSave.Click
		SaveImage()
	End Sub



	Public Function bUpdateSnapShot(ByVal pbyteImg() As Byte, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal pixelFormat As Imaging.PixelFormat) As Boolean

		Dim bitmap As Bitmap = New Bitmap(nWidth, nHeight, pixelFormat)
		Dim nBufferSize As Integer = nWidth * nHeight

		Select Case pixelFormat
			Case Imaging.PixelFormat.Format8bppIndexed
				'Palette
				Dim colorPalette As System.Drawing.Imaging.ColorPalette = bitmap.Palette
				For pixelValue As Integer = 0 To 255
					colorPalette.Entries(pixelValue) = Color.FromArgb(pixelValue, pixelValue, pixelValue)
				Next
				bitmap.Palette = colorPalette
			Case Imaging.PixelFormat.Format24bppRgb
				nBufferSize = nBufferSize * 3
			Case Imaging.PixelFormat.Format32bppRgb
				nBufferSize = nBufferSize * 4
		End Select

		'Copy
		Dim bitmapData As Imaging.BitmapData = bitmap.LockBits(New Rectangle(0, 0, nWidth, nHeight), Imaging.ImageLockMode.WriteOnly, pixelFormat)
		Runtime.InteropServices.Marshal.Copy(pbyteImg, 0, bitmapData.Scan0(), nBufferSize)
		bitmap.UnlockBits(bitmapData)

		If Not m_Bitmap Is Nothing Then
			PictureBox1.Image = Nothing
			m_Bitmap.Dispose()
		End If
		m_Bitmap = bitmap
		Me.ClientSize = New Size(nWidth, nHeight)
		Me.MaximumSize = Me.Size
		PictureBox1.Location = New Point(0, 0)
		PictureBox1.Image = m_Bitmap
		m_SavedFg = False


		Return True
	End Function

	Private Sub FormSnapShot_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
		If Not m_SavedFg Then
			If DialogResult.Yes = Windows.Forms.MessageBox.Show("Do You Want To Save The Image?", "Save Image", System.Windows.Forms.MessageBoxButtons.YesNo, System.Windows.Forms.MessageBoxIcon.Question) Then
				SaveImage()
			End If
		End If
		If Not m_Bitmap Is Nothing Then
			PictureBox1.Image = Nothing
			m_Bitmap.Dispose()
			m_Bitmap = Nothing
		End If
	End Sub

	Private Sub FormSnapShot_KeyDown(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles MyBase.KeyDown
		If e.KeyCode = Keys.Apps Then
			ContextMenu1.Show(Me, Me.PointToClient(MousePosition))
		End If
	End Sub
End Class
