Imports System.Runtime.InteropServices
Public Class Form1
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer Code "

    Public Sub New()
        MyBase.New()

        InitializeComponent()


    End Sub

    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    Private components As System.ComponentModel.IContainer

    Friend WithEvents btnPreview As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
		Me.btnPreview = New System.Windows.Forms.Button
		Me.SuspendLayout()
		'
		'btnPreview
		'
		Me.btnPreview.Location = New System.Drawing.Point(8, 8)
		Me.btnPreview.Name = "btnPreview"
		Me.btnPreview.Size = New System.Drawing.Size(88, 23)
		Me.btnPreview.TabIndex = 0
		Me.btnPreview.Text = "Preview"
		'
		'Form1
		'
		Me.AutoScaleBaseSize = New System.Drawing.Size(5, 12)
		Me.ClientSize = New System.Drawing.Size(104, 37)
		Me.Controls.Add(Me.btnPreview)
		Me.Name = "Form1"
		Me.Text = "Form1"
		Me.ResumeLayout(False)

	End Sub

#End Region

	Private m_hCamera As IntPtr
	Private m_bStatusTransfer As Boolean
	Private m_bStatusAVIFile As Boolean
	Private m_bStatusPreviewWnd As Boolean
	Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
		m_hCamera = StCam.Open(0)
		If m_hCamera.Equals(IntPtr.Zero) Then
			ShowErrorMsg(StCam.GetLastError(m_hCamera))
		End If
		If 0 = StCam.SetReceiveMsgWindow(m_hCamera, Me.Handle) Then
			ShowErrorMsg(StCam.GetLastError(m_hCamera))
		End If
		StatusChanged()
	End Sub

	Private Sub Form1_Closed(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Closed
		If Not m_hCamera.Equals(IntPtr.Zero) Then
			StCam.Close(m_hCamera)
		End If
	End Sub
	Private Sub btnPreview_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPreview.Click
		If m_bStatusPreviewWnd And m_bStatusTransfer Then
			'Stop
			If 0 = StCam.StopTransfer(m_hCamera) Then
				ShowErrorMsg(StCam.GetLastError(m_hCamera))
			End If
		Else
			'Start
			If 0 = StCam.CreatePreviewWindow(m_hCamera, "Preview", StCam.WS_OVERLAPPEDWINDOW Or StCam.WS_VISIBLE, 0, 0, 0, 0, IntPtr.Zero, IntPtr.Zero, StCam.STCAM_FALSE) Then
				ShowErrorMsg(StCam.GetLastError(m_hCamera))
			End If
			If 0 = StCam.StartTransfer(m_hCamera) Then
				ShowErrorMsg(StCam.GetLastError(m_hCamera))
			End If
		End If
	End Sub
	Private Sub StatusChanged()
		If m_bStatusPreviewWnd And m_bStatusTransfer Then
			btnPreview.Text = "STOP"
		Else
			btnPreview.Text = "START"
		End If
	End Sub

	Protected Overrides Sub WndProc(ByRef m As System.Windows.Forms.Message)
		Select Case m.Msg
			Case StCam.WM_STCAM_TRANSFER_START
				m_bStatusTransfer = True
				StatusChanged()
			Case StCam.WM_STCAM_TRANSFER_FINISH
				m_bStatusTransfer = False
				StatusChanged()
				If m.LParam.ToInt32() <> 0 Then
					ShowErrorMsg(m.LParam.ToInt32())
				End If
			Case StCam.WM_STCAM_AVI_FILE_START
				m_bStatusAVIFile = True
				StatusChanged()
			Case StCam.WM_STCAM_AVI_FILE_FINISH
				m_bStatusAVIFile = False
				StatusChanged()
				If m.LParam.ToInt32() <> 0 Then
					ShowErrorMsg(m.LParam.ToInt32())
				End If
			Case StCam.WM_STCAM_PREVIEW_WINDOW_CREATE
				m_bStatusPreviewWnd = True
				StatusChanged()
			Case StCam.WM_STCAM_PREVIEW_WINDOW_CLOSE
				m_bStatusPreviewWnd = False
				StatusChanged()
				If m.LParam.ToInt32() <> 0 Then
					ShowErrorMsg(m.LParam.ToInt32())
				End If
			Case Else
				MyBase.WndProc(m)
		End Select
	End Sub
	<DllImport("kernel32.dll", CharSet:=CharSet.Auto)> _
	Private Shared Function FormatMessage(ByVal dwFlags As Integer, ByVal lpSource As IntPtr, ByVal dwMessageId As Integer, ByVal dwLanguageId As Integer, ByVal lpBuffer As System.Text.StringBuilder, ByVal nSize As Integer, ByRef Arguments As IntPtr) As Integer

	End Function

	<DllImport("kernel32.dll", CharSet:=CharSet.Auto)> _
	Private Shared Function LoadLibraryEx(ByVal lpszLibFile As String, ByVal hFile As IntPtr, ByVal dwFlags As Integer) As IntPtr

	End Function

	<DllImport("kernel32.dll")> _
	Private Shared Function FreeLibrary(ByVal hModule As IntPtr) As Integer

	End Function

	Private Sub ShowErrorMsg(ByVal dwErrorCode As Integer)
		Const FORMAT_MESSAGE_FROM_SYSTEM As Integer = &H1000
		Const FORMAT_MESSAGE_FROM_HMODULE As Integer = &H800
		Const DONT_RESOLVE_DLL_REFERENCES As Integer = &H1

		Dim strErrorMsg As New System.Text.StringBuilder(255)
		Dim nFlags As Integer = FORMAT_MESSAGE_FROM_SYSTEM
		Dim nFoundErrMsg As Integer = 0

		nFoundErrMsg = FormatMessage(nFlags, IntPtr.Zero, dwErrorCode, 0, strErrorMsg, strErrorMsg.Capacity, IntPtr.Zero)
		If nFoundErrMsg = 0 Then
			Dim ptrlpSource As IntPtr
			ptrlpSource = LoadLibraryEx("StCamMsg.dll", IntPtr.Zero, DONT_RESOLVE_DLL_REFERENCES)
			nFlags = nFlags Or FORMAT_MESSAGE_FROM_HMODULE

			If Not ptrlpSource.Equals(IntPtr.Zero) Then
				nFoundErrMsg = FormatMessage(nFlags, ptrlpSource, dwErrorCode, 0, strErrorMsg, strErrorMsg.Capacity, IntPtr.Zero)
				FreeLibrary(ptrlpSource)
			End If
		End If
		System.Windows.Forms.MessageBox.Show(strErrorMsg.ToString(), "Error Message", System.Windows.Forms.MessageBoxButtons.OK, System.Windows.Forms.MessageBoxIcon.Exclamation)
	End Sub
End Class
