Public Class Form1
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer Code "

    Public Sub New()
        MyBase.New()

        InitializeComponent()


    End Sub

    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    Private components As System.ComponentModel.IContainer

    Friend WithEvents btnPreview As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.btnPreview = New System.Windows.Forms.Button
        Me.SuspendLayout()
        '
        'btnPreview
        '
        Me.btnPreview.Location = New System.Drawing.Point(8, 8)
        Me.btnPreview.Name = "btnPreview"
        Me.btnPreview.Size = New System.Drawing.Size(88, 23)
        Me.btnPreview.TabIndex = 0
        Me.btnPreview.Text = "Preview"
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 12)
        Me.ClientSize = New System.Drawing.Size(104, 37)
        Me.Controls.Add(Me.btnPreview)
        Me.Name = "Form1"
        Me.Text = "Form1"
        Me.ResumeLayout(False)

    End Sub

#End Region
    Private m_hCamera As IntPtr
    Private m_bStatusTransfer As Boolean
    Private m_bStatusAVIFile As Boolean
    Private m_bStatusPreviewWnd As Boolean
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        m_hCamera = StCam.Open(0)
        StCam.SetReceiveMsgWindow(m_hCamera, Me.Handle)
        StatusChanged()
    End Sub

    Private Sub Form1_Closed(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Closed
        If Not m_hCamera.Equals(IntPtr.Zero) Then
            StCam.Close(m_hCamera)
        End If

    End Sub

    Private Sub btnPreview_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPreview.Click
        If m_bStatusPreviewWnd And m_bStatusTransfer Then
            'Stop
            StCam.StopTransfer(m_hCamera)
        Else
            'Start
            StCam.CreatePreviewWindow(m_hCamera, "Preview", StCam.WS_OVERLAPPEDWINDOW Or StCam.WS_VISIBLE, 0, 0, 0, 0, IntPtr.Zero, IntPtr.Zero, StCam.STCAM_FALSE)
            StCam.StartTransfer(m_hCamera)
        End If


    End Sub

    Private Sub StatusChanged()
        If m_bStatusPreviewWnd And m_bStatusTransfer Then
            btnPreview.Text = "STOP"
        Else
            btnPreview.Text = "START"
        End If
    End Sub

    Protected Overrides Sub WndProc(ByRef m As System.Windows.Forms.Message)
        Select Case m.Msg
            Case StCam.WM_STCAM_TRANSFER_START
                m_bStatusTransfer = True
                StatusChanged()
            Case StCam.WM_STCAM_TRANSFER_FINISH
                m_bStatusTransfer = False
                StatusChanged()
            Case StCam.WM_STCAM_AVI_FILE_START
                m_bStatusAVIFile = True
                StatusChanged()
            Case StCam.WM_STCAM_AVI_FILE_FINISH
                m_bStatusAVIFile = False
                StatusChanged()
            Case StCam.WM_STCAM_PREVIEW_WINDOW_CREATE
                m_bStatusPreviewWnd = True
                StatusChanged()
            Case StCam.WM_STCAM_PREVIEW_WINDOW_CLOSE
                m_bStatusPreviewWnd = False
                StatusChanged()
            Case Else
                MyBase.WndProc(m)
        End Select
    End Sub
End Class
