Public Class SettingTextBox
	Inherits System.Windows.Forms.TextBox
	Implements ISettingCtrl
	Implements ISettingRange
#Region " Windows Form Designer Code "

	Public Sub New()
		MyBase.New()

		InitializeComponent()


	End Sub

	Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
		If disposing Then
			If Not (components Is Nothing) Then
				components.Dispose()
			End If
		End If
		MyBase.Dispose(disposing)
	End Sub

	Private components As System.ComponentModel.IContainer

	<System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
		'
		'SettingTextBox
		'
		Me.Name = "SettingTextBox"
		Me.TextAlign = System.Windows.Forms.HorizontalAlignment.Right

	End Sub

#End Region

	Private m_nPos As Integer = 0
	Private m_nMin As Integer = Integer.MinValue
	Private m_nMax As Integer = Integer.MaxValue

	Public Event SettingValueChanged(ByVal sender As Object, ByVal e As EventArgs) Implements ISettingCtrl.SettingValueChanged

	Private m_SettingID As SettingIDs = SettingIDs.UNKNOWN
	Public Property SettingID() As SettingIDs Implements ISettingCtrl.SettingID
		Get
			Return (m_SettingID)
		End Get
		Set(ByVal Value As SettingIDs)
			m_SettingID = Value
		End Set
	End Property

	Protected Overrides Sub OnKeyDown(ByVal e As System.Windows.Forms.KeyEventArgs)
		MyBase.OnKeyDown(e)

		If e.KeyCode = Keys.Enter Then
			Dim value As Integer = m_nPos

			Try
				value = CInt(Text)
			Catch ex As Exception
				Text = m_nPos.ToString()
			End Try

			If value < m_nMin Then
				value = m_nMin
			ElseIf m_nMax < value Then
				value = m_nMax
			End If
			m_nPos = value
			RaiseEvent SettingValueChanged(Me, New EventArgs)
		End If
	End Sub
	Public Property SettingValue() As Integer Implements ISettingCtrl.SettingValue
		Get
			Return (m_nPos)
		End Get
		Set(ByVal Value As Integer)
			m_nPos = Value
			Text = m_nPos.ToString()
		End Set
	End Property
	Public Property SettingMin() As Integer Implements ISettingRange.SettingMin
		Get
			Return (m_nMin)
		End Get
		Set(ByVal Value As Integer)
			m_nMin = Value
		End Set
	End Property
	Public Property SettingMax() As Integer Implements ISettingRange.SettingMax
		Get
			Return (m_nMax)
		End Get
		Set(ByVal Value As Integer)
			m_nMax = Value
		End Set
	End Property

	Protected Overrides Sub OnLeave(ByVal e As System.EventArgs)
		Text = m_nPos.ToString()
	End Sub
End Class
