Public Class Form1
    Private m_hCamera As IntPtr
    Private m_bStatusTransfer As Boolean
    Private m_bStatusAVIFile As Boolean
    Private m_bStatusPreviewWnd As Boolean

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        m_hCamera = StCam.Open(0)
        StCam.SetReceiveMsgWindow(m_hCamera, Me.Handle)
        StatusChanged()
    End Sub

    Private Sub Form1_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
        If Not m_hCamera.Equals(IntPtr.Zero) Then
            StCam.Close(m_hCamera)
        End If
    End Sub

    Private Sub btnPreview_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPreview.Click

        If m_bStatusPreviewWnd And m_bStatusTransfer Then
            'Stop
            StCam.StopTransfer(m_hCamera)
        Else
            'Start
            StCam.CreatePreviewWindow(m_hCamera, "Preview", StCam.WS_OVERLAPPEDWINDOW Or StCam.WS_VISIBLE, 0, 0, 0, 0, IntPtr.Zero, IntPtr.Zero, StCam.STCAM_TRUE)
            StCam.StartTransfer(m_hCamera)
        End If
    End Sub
    Private Sub StatusChanged()
        If m_bStatusPreviewWnd And m_bStatusTransfer Then
            btnPreview.Text = "STOP"
        Else
            btnPreview.Text = "START"
        End If
    End Sub
    Protected Overrides Sub WndProc(ByRef m As System.Windows.Forms.Message)
        Select Case m.Msg
            Case StCam.WM_STCAM_TRANSFER_START
                m_bStatusTransfer = True
                StatusChanged()
            Case StCam.WM_STCAM_TRANSFER_FINISH
                m_bStatusTransfer = False
                StatusChanged()
            Case StCam.WM_STCAM_AVI_FILE_START
                m_bStatusAVIFile = True
                StatusChanged()
            Case StCam.WM_STCAM_AVI_FILE_FINISH
                m_bStatusAVIFile = False
                StatusChanged()
            Case StCam.WM_STCAM_PREVIEW_WINDOW_CREATE
                m_bStatusPreviewWnd = True
                StatusChanged()
            Case StCam.WM_STCAM_PREVIEW_WINDOW_CLOSE
                m_bStatusPreviewWnd = False
                StatusChanged()
            Case Else
                MyBase.WndProc(m)
        End Select
    End Sub
End Class
