// PreviewSizeDlg.cpp
//

#include "stdafx.h"
#include "PreviewSize.h"
#include "PreviewSizeDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPreviewSizeDlg

CPreviewSizeDlg::CPreviewSizeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPreviewSizeDlg::IDD, pParent),
	m_pSetSizeDlg(NULL)
{
	//{{AFX_DATA_INIT(CPreviewSizeDlg)
		//
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPreviewSizeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPreviewSizeDlg)
		//
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPreviewSizeDlg, CDialog)
	//{{AFX_MSG_MAP(CPreviewSizeDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(IDM_SET_SIZE, OnSetSize)
	//}}AFX_MSG_MAP
	ON_COMMAND_RANGE(IDM_WS_CHILD, IDM_WS_OVERLAPPED, OnWindowStyle)
	ON_MESSAGE(WM_USER_DIALOG_DESTROYED, OnDialogDestroyed)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPreviewSizeDlg
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CPreviewSizeDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);
	
	OnWindowStyle(IDM_WS_CHILD);
	g_pStCamera->StartTransfer();
	
	return TRUE;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CPreviewSizeDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this);

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// 
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// 
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
HCURSOR CPreviewSizeDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CPreviewSizeDlg::OnWindowStyle(UINT nID) 
{
	BOOL IsChildWindow = (nID == IDM_WS_CHILD);
	if(IsChildWindow)
	{
		g_pStCamera->CreateChildWindow(GetSafeHwnd());
	}
	else
	{
		g_pStCamera->CreateOverlappedWindow();
	}
	CMenu *pMenu = GetMenu();
	pMenu->CheckMenuItem(IDM_WS_CHILD, IsChildWindow?MF_CHECKED:MF_UNCHECKED);
	pMenu->CheckMenuItem(IDM_WS_OVERLAPPED, (!IsChildWindow)?MF_CHECKED:MF_UNCHECKED);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CPreviewSizeDlg::DestroyWindow() 
{
	g_pStCamera->StopTransfer();

	if(NULL != m_pSetSizeDlg)
	{
		m_pSetSizeDlg->DestroyWindow();
		m_pSetSizeDlg = NULL;
	}
	
	return CDialog::DestroyWindow();
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CPreviewSizeDlg::OnSetSize() 
{

	if(NULL != m_pSetSizeDlg)
	{
		m_pSetSizeDlg->SetFocus();
	}
	else
	{
		m_pSetSizeDlg = new CSetSizeDlg;
		m_pSetSizeDlg->g_pStCamera = g_pStCamera;
		m_pSetSizeDlg->Create(IDD_SET_SIZE_DIALOG, CWnd::GetDesktopWindow());
		m_pSetSizeDlg->ShowWindow(SW_SHOW);
	}	
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
LRESULT CPreviewSizeDlg::OnDialogDestroyed(WPARAM wParam, LPARAM lParam)
{
	m_pSetSizeDlg = NULL;
	return(0);
}
