// SetSizeDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "PreviewSize.h"
#include "SetSizeDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetSizeDlg 


CSetSizeDlg::CSetSizeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSetSizeDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetSizeDlg)
	//}}AFX_DATA_INIT
	m_pComboBoxID[0] = IDC_COMBO_DISPLAY_MODE;
	m_pComboBoxID[1] = IDC_COMBO_ASPECT_MODE;

	m_pSliderID[0] = IDC_SLIDER_PREVIEW_WINDOW_OFFSET_X;
	m_pSliderID[1] = IDC_SLIDER_PREVIEW_WINDOW_OFFSET_Y;
	m_pSliderID[2] = IDC_SLIDER_PREVIEW_WINDOW_WIDTH;
	m_pSliderID[3] = IDC_SLIDER_PREVIEW_WINDOW_HEIGHT;

	m_pSliderID[4] = IDC_SLIDER_PREVIEW_MASK_OFFSET_X;
	m_pSliderID[5] = IDC_SLIDER_PREVIEW_MASK_OFFSET_Y;
	m_pSliderID[6] = IDC_SLIDER_PREVIEW_MASK_WIDTH;
	m_pSliderID[7] = IDC_SLIDER_PREVIEW_MASK_HEIGHT;

	m_pSliderID[8] = IDC_SLIDER_PREVIEW_DEST_OFFSET_X;
	m_pSliderID[9] = IDC_SLIDER_PREVIEW_DEST_OFFSET_Y;
	m_pSliderID[10] = IDC_SLIDER_PREVIEW_DEST_WIDTH;
	m_pSliderID[11] = IDC_SLIDER_PREVIEW_DEST_HEIGHT;


	m_pEditID[0] = IDC_EDIT_PREVIEW_WINDOW_OFFSET_X;
	m_pEditID[1] = IDC_EDIT_PREVIEW_WINDOW_OFFSET_Y;
	m_pEditID[2] = IDC_EDIT_PREVIEW_WINDOW_WIDTH;
	m_pEditID[3] = IDC_EDIT_PREVIEW_WINDOW_HEIGHT;

	m_pEditID[4] = IDC_EDIT_PREVIEW_MASK_OFFSET_X;
	m_pEditID[5] = IDC_EDIT_PREVIEW_MASK_OFFSET_Y;
	m_pEditID[6] = IDC_EDIT_PREVIEW_MASK_WIDTH;
	m_pEditID[7] = IDC_EDIT_PREVIEW_MASK_HEIGHT;

	m_pEditID[8] = IDC_EDIT_PREVIEW_DEST_OFFSET_X;
	m_pEditID[9] = IDC_EDIT_PREVIEW_DEST_OFFSET_Y;
	m_pEditID[10] = IDC_EDIT_PREVIEW_DEST_WIDTH;
	m_pEditID[11] = IDC_EDIT_PREVIEW_DEST_HEIGHT;
}


void CSetSizeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetSizeDlg)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetSizeDlg, CDialog)
	//{{AFX_MSG_MAP(CSetSizeDlg)
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
	ON_CONTROL_RANGE(CBN_SELCHANGE, IDC_COMBO_DISPLAY_MODE, IDC_COMBO_ASPECT_MODE, OnSelchangeComboItem)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetSizeDlg 
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CSetSizeDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	mInitComboBox();
	mUpdateDisplay();
	
	return TRUE;
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CSetSizeDlg::DestroyWindow() 
{
	return CDialog::DestroyWindow();
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CSetSizeDlg::mUpdateDisplay()
{
	mUpdateDisplayComboBox();

	mUpdateDisplaySlider();

	mUpdateDisplayEdit();
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CSetSizeDlg::mInitComboBox()
{
	for(UINT i = 0; i < sizeof(m_pComboBoxID) / sizeof(UINT); i++)
	{
		UINT nID = m_pComboBoxID[i];
		CComboBox objComboBox;
		objComboBox.Attach(GetDlgItem(nID)->GetSafeHwnd());

		//Clear
		while(objComboBox.GetCount())	objComboBox.DeleteString(0);

		switch(nID)
		{
		case(IDC_COMBO_ASPECT_MODE):
			objComboBox.AddString(TEXT("Fixed"));			objComboBox.SetItemData(objComboBox.GetCount() - 1, STCAM_ASPECT_MODE_FIXED);
			objComboBox.AddString(TEXT("Keep Aspect"));		objComboBox.SetItemData(objComboBox.GetCount() - 1, STCAM_ASPECT_MODE_KEEP_ASPECT);
			objComboBox.AddString(TEXT("Adjust Window"));	objComboBox.SetItemData(objComboBox.GetCount() - 1, STCAM_ASPECT_MODE_ADJUST_WINDOW);
			objComboBox.AddString(TEXT("Mask"));			objComboBox.SetItemData(objComboBox.GetCount() - 1, STCAM_ASPECT_MODE_MASK_SIZE);
			objComboBox.AddString(TEXT("Custom(Offset)"));	objComboBox.SetItemData(objComboBox.GetCount() - 1, STCAM_ASPECT_MODE_CUSTOM_OFFSET);
			objComboBox.AddString(TEXT("Custom(Center)"));	objComboBox.SetItemData(objComboBox.GetCount() - 1, STCAM_ASPECT_MODE_CUSTOM);
			break;
		case(IDC_COMBO_DISPLAY_MODE):
			objComboBox.AddString(TEXT("GDI"));						objComboBox.SetItemData(objComboBox.GetCount() - 1, STCAM_DISPLAY_MODE_GDI);
			objComboBox.AddString(TEXT("DirectDraw[Offscreen]"));	objComboBox.SetItemData(objComboBox.GetCount() - 1, STCAM_DISPLAY_MODE_DD_OFFSCREEN);
			objComboBox.AddString(TEXT("DirectDraw[Overlay]"));		objComboBox.SetItemData(objComboBox.GetCount() - 1, STCAM_DISPLAY_MODE_DD_OVERLAY);
			objComboBox.AddString(TEXT("DirectDraw[Offscreen HQ]"));objComboBox.SetItemData(objComboBox.GetCount() - 1, STCAM_DISPLAY_MODE_DD_OFFSCREEN_HQ);
			objComboBox.AddString(TEXT("DirectDraw[Overlay HQ]"));	objComboBox.SetItemData(objComboBox.GetCount() - 1, STCAM_DISPLAY_MODE_DD_OVERLAY_HQ);
			objComboBox.AddString(TEXT("DirectX"));					objComboBox.SetItemData(objComboBox.GetCount() - 1, STCAM_DISPLAY_MODE_DIRECTX);
			objComboBox.AddString(TEXT("DirectX[V Sync ON]"));		objComboBox.SetItemData(objComboBox.GetCount() - 1, STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON);
			objComboBox.AddString(TEXT("DirectX[V Sync ON 2]"));	objComboBox.SetItemData(objComboBox.GetCount() - 1, STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON2);
			break;
		}

		objComboBox.Detach();
	}
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CSetSizeDlg::mUpdateDisplayComboBox()
{
	for(UINT i = 0; i < sizeof(m_pComboBoxID) / sizeof(UINT); i++)
	{
		UINT	nID = m_pComboBoxID[i];
		DWORD	dwValue = 0;
		switch(nID)
		{
		case(IDC_COMBO_DISPLAY_MODE):
			dwValue = g_pStCamera->GetDisplayMode();
			break;
		case(IDC_COMBO_ASPECT_MODE):
			dwValue = g_pStCamera->GetAspectMode();
			break;
		}
		CComboBox objComboBox;
		objComboBox.Attach(GetDlgItem(nID)->GetSafeHwnd());
		for(INT iListIndex = 0; iListIndex < objComboBox.GetCount(); iListIndex++)
		{
			if(objComboBox.GetItemData(iListIndex) == dwValue)
			{
				objComboBox.SetCurSel(iListIndex);
				break;
			}
		}
		objComboBox.Detach();
	}
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CSetSizeDlg::mUpdateByComboBox(UINT nID)
{
	CComboBox objComboBox;
	objComboBox.Attach(GetDlgItem(nID)->GetSafeHwnd());
#ifdef _WIN64
	DWORD_PTR	dwValue = objComboBox.GetItemData(objComboBox.GetCurSel());
#else
	DWORD	dwValue = objComboBox.GetItemData(objComboBox.GetCurSel());
#endif //_WIN64
	objComboBox.Detach();

	switch(nID)
	{
	case(IDC_COMBO_DISPLAY_MODE):
		g_pStCamera->SetDisplayMode(static_cast<BYTE>(dwValue));
		break;
	case(IDC_COMBO_ASPECT_MODE):
		g_pStCamera->SetAspectMode(static_cast<BYTE>(dwValue));
		break;
	}
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CSetSizeDlg::OnSelchangeComboItem(UINT nID) 
{
	mUpdateByComboBox(nID);
	mUpdateDisplay();
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CSetSizeDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	UINT nID = pScrollBar->GetDlgCtrlID();
	switch(nID)
	{
	case(IDC_SLIDER_PREVIEW_WINDOW_OFFSET_X):
	case(IDC_SLIDER_PREVIEW_WINDOW_OFFSET_Y):
	case(IDC_SLIDER_PREVIEW_WINDOW_WIDTH):
	case(IDC_SLIDER_PREVIEW_WINDOW_HEIGHT):

	case(IDC_SLIDER_PREVIEW_MASK_OFFSET_X):
	case(IDC_SLIDER_PREVIEW_MASK_OFFSET_Y):
	case(IDC_SLIDER_PREVIEW_MASK_WIDTH):
	case(IDC_SLIDER_PREVIEW_MASK_HEIGHT):

	case(IDC_SLIDER_PREVIEW_DEST_OFFSET_X):
	case(IDC_SLIDER_PREVIEW_DEST_OFFSET_Y):
	case(IDC_SLIDER_PREVIEW_DEST_WIDTH):
	case(IDC_SLIDER_PREVIEW_DEST_HEIGHT):
		mUpdateBySlider(nID);
		mUpdateDisplay();
		break;
	default:
		CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
		break;
	}
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CSetSizeDlg::mUpdateDisplaySlider()
{

	for(UINT i = 0; i < sizeof(m_pSliderID) / sizeof(UINT); i++)
	{
		UINT	nID = m_pSliderID[i];
		INT	iValue = 0;
		INT iMin = 0;
		INT iMax = 0;
		BOOL	bEnabled = TRUE;


		switch(nID)
		{
		case(IDC_SLIDER_PREVIEW_WINDOW_OFFSET_X):
			iMax = 2048;
			iValue = g_pStCamera->GetPreviewWindowOffsetX();
			break;
		case(IDC_SLIDER_PREVIEW_WINDOW_OFFSET_Y):
			iMax = 2048;
			iValue = g_pStCamera->GetPreviewWindowOffsetY();
			break;
		case(IDC_SLIDER_PREVIEW_WINDOW_WIDTH):
			iMax = 2048;
			iValue = g_pStCamera->GetPreviewWindowWidth();
			break;
		case(IDC_SLIDER_PREVIEW_WINDOW_HEIGHT):
			iMax = 2048;
			iValue = g_pStCamera->GetPreviewWindowHeight();
			break;

		case(IDC_SLIDER_PREVIEW_MASK_OFFSET_X):
			iMax = g_pStCamera->GetOrgImageWidth() - g_pStCamera->GetPreviewMaskWidth();
			iValue = g_pStCamera->GetPreviewMaskOffsetX();
			break;
		case(IDC_SLIDER_PREVIEW_MASK_OFFSET_Y):
			iMax = g_pStCamera->GetOrgImageHeight() - g_pStCamera->GetPreviewMaskHeight();
			iValue = g_pStCamera->GetPreviewMaskOffsetY();
			break;
		case(IDC_SLIDER_PREVIEW_MASK_WIDTH):
			iMax = g_pStCamera->GetOrgImageWidth() - g_pStCamera->GetPreviewMaskOffsetX();
			iValue = g_pStCamera->GetPreviewMaskWidth();
			break;
		case(IDC_SLIDER_PREVIEW_MASK_HEIGHT):
			iMax = g_pStCamera->GetOrgImageHeight() - g_pStCamera->GetPreviewMaskOffsetY();
			iValue = g_pStCamera->GetPreviewMaskHeight();
			break;

		case(IDC_SLIDER_PREVIEW_DEST_OFFSET_X):
			iMax = g_pStCamera->GetPreviewWindowWidth() - g_pStCamera->GetPreviewDestWidth();
			iValue = g_pStCamera->GetPreviewDestOffsetX();
			break;
		case(IDC_SLIDER_PREVIEW_DEST_OFFSET_Y):
			iMax = g_pStCamera->GetPreviewWindowHeight() - g_pStCamera->GetPreviewDestHeight();
			iValue = g_pStCamera->GetPreviewDestOffsetY();
			break;
		case(IDC_SLIDER_PREVIEW_DEST_WIDTH):
			iMax = g_pStCamera->GetPreviewWindowWidth() - g_pStCamera->GetPreviewDestOffsetX();
			iValue = g_pStCamera->GetPreviewDestWidth();
			break;
		case(IDC_SLIDER_PREVIEW_DEST_HEIGHT):
			iMax = g_pStCamera->GetPreviewWindowHeight() - g_pStCamera->GetPreviewDestOffsetY();
			iValue = g_pStCamera->GetPreviewDestHeight();
			break;
			
		default:
			break;
		}

		//Enabled
		if((iMax <= iMin) || (iValue < iMin) || (iMax < iValue))
		{
			bEnabled = FALSE;
		}
		else
		{
			switch(nID)
			{
			case(IDC_SLIDER_PREVIEW_DEST_OFFSET_X):
			case(IDC_SLIDER_PREVIEW_DEST_OFFSET_Y):
			case(IDC_SLIDER_PREVIEW_DEST_WIDTH):
			case(IDC_SLIDER_PREVIEW_DEST_HEIGHT):
				{
					BYTE byteAspectMode = g_pStCamera->GetAspectMode();
					if(
						(STCAM_ASPECT_MODE_CUSTOM_OFFSET != byteAspectMode) &&
						(STCAM_ASPECT_MODE_CUSTOM != byteAspectMode)
					)
					{
						bEnabled = FALSE;
					}
				}
				break;
			}
		}
		CSliderCtrl	objSliderCtrl;
		objSliderCtrl.Attach(GetDlgItem(nID)->GetSafeHwnd());
		objSliderCtrl.SetRange(iMin, iMax, FALSE);
		objSliderCtrl.SetPageSize((iMax - iMin) / 10);
		objSliderCtrl.SetPos(iValue);
		objSliderCtrl.EnableWindow(bEnabled);
		objSliderCtrl.Detach();

	}

}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CSetSizeDlg::mUpdateBySlider(UINT nID)
{
	CSliderCtrl	objSliderCtrl;
	objSliderCtrl.Attach(GetDlgItem(nID)->GetSafeHwnd());
	int iValue = objSliderCtrl.GetPos();
	objSliderCtrl.Detach();

	switch(nID)
	{
	case(IDC_SLIDER_PREVIEW_WINDOW_OFFSET_X):
		g_pStCamera->SetPreviewWindowOffsetX(iValue);
		break;
	case(IDC_SLIDER_PREVIEW_WINDOW_OFFSET_Y):
		g_pStCamera->SetPreviewWindowOffsetY(iValue);
		break;
	case(IDC_SLIDER_PREVIEW_WINDOW_WIDTH):
		g_pStCamera->SetPreviewWindowWidth(iValue);
		break;
	case(IDC_SLIDER_PREVIEW_WINDOW_HEIGHT):
		g_pStCamera->SetPreviewWindowHeight(iValue);
		break;

	case(IDC_SLIDER_PREVIEW_MASK_OFFSET_X):
		g_pStCamera->SetPreviewMaskOffsetX(iValue);
		break;
	case(IDC_SLIDER_PREVIEW_MASK_OFFSET_Y):
		g_pStCamera->SetPreviewMaskOffsetY(iValue);
		break;
	case(IDC_SLIDER_PREVIEW_MASK_WIDTH):
		g_pStCamera->SetPreviewMaskWidth(iValue);
		break;
	case(IDC_SLIDER_PREVIEW_MASK_HEIGHT):
		g_pStCamera->SetPreviewMaskHeight(iValue);
		break;

	case(IDC_SLIDER_PREVIEW_DEST_OFFSET_X):
		g_pStCamera->SetPreviewDestOffsetX(iValue);
		break;
	case(IDC_SLIDER_PREVIEW_DEST_OFFSET_Y):
		g_pStCamera->SetPreviewDestOffsetY(iValue);
		break;
	case(IDC_SLIDER_PREVIEW_DEST_WIDTH):
		g_pStCamera->SetPreviewDestWidth(iValue);
		break;
	case(IDC_SLIDER_PREVIEW_DEST_HEIGHT):
		g_pStCamera->SetPreviewDestHeight(iValue);
		break;
		
	default:
		break;
	}

}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CSetSizeDlg::mUpdateDisplayEdit()
{
	
	for(UINT i = 0; i < sizeof(m_pEditID) / sizeof(UINT); i++)
	{
		UINT	nID = m_pEditID[i];
		INT	iValue = 0;

		switch(nID)
		{
		case(IDC_EDIT_PREVIEW_WINDOW_OFFSET_X):
			iValue = g_pStCamera->GetPreviewWindowOffsetX();
			break;
		case(IDC_EDIT_PREVIEW_WINDOW_OFFSET_Y):
			iValue = g_pStCamera->GetPreviewWindowOffsetY();
			break;
		case(IDC_EDIT_PREVIEW_WINDOW_WIDTH):
			iValue = g_pStCamera->GetPreviewWindowWidth();
			break;
		case(IDC_EDIT_PREVIEW_WINDOW_HEIGHT):
			iValue = g_pStCamera->GetPreviewWindowHeight();
			break;

		case(IDC_EDIT_PREVIEW_MASK_OFFSET_X):
			iValue = g_pStCamera->GetPreviewMaskOffsetX();
			break;
		case(IDC_EDIT_PREVIEW_MASK_OFFSET_Y):
			iValue = g_pStCamera->GetPreviewMaskOffsetY();
			break;
		case(IDC_EDIT_PREVIEW_MASK_WIDTH):
			iValue = g_pStCamera->GetPreviewMaskWidth();
			break;
		case(IDC_EDIT_PREVIEW_MASK_HEIGHT):
			iValue = g_pStCamera->GetPreviewMaskHeight();
			break;

		case(IDC_EDIT_PREVIEW_DEST_OFFSET_X):
			iValue = g_pStCamera->GetPreviewDestOffsetX();
			break;
		case(IDC_EDIT_PREVIEW_DEST_OFFSET_Y):
			iValue = g_pStCamera->GetPreviewDestOffsetY();
			break;
		case(IDC_EDIT_PREVIEW_DEST_WIDTH):
			iValue = g_pStCamera->GetPreviewDestWidth();
			break;
		case(IDC_EDIT_PREVIEW_DEST_HEIGHT):
			iValue = g_pStCamera->GetPreviewDestHeight();
			break;

		default:
			break;
		}
		GetDlgItem(nID)->EnableWindow(GetDlgItem(m_pSliderID[i])->IsWindowEnabled());
		SetDlgItemInt(nID, iValue);
		//::SetWindowText(hWnd, szTmp);
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CSetSizeDlg::mUpdateByEdit(UINT nID)
{
	BOOL bTranslated = FALSE;
	INT iValue = static_cast<INT>(GetDlgItemInt(nID, &bTranslated, TRUE));
	if(!bTranslated)
	{
		return;
	}

	switch(nID)
	{
	case(IDC_EDIT_PREVIEW_WINDOW_OFFSET_X):
		g_pStCamera->SetPreviewWindowOffsetX(iValue);
		break;
	case(IDC_EDIT_PREVIEW_WINDOW_OFFSET_Y):
		g_pStCamera->SetPreviewWindowOffsetY(iValue);
		break;
	case(IDC_EDIT_PREVIEW_WINDOW_WIDTH):
		g_pStCamera->SetPreviewWindowWidth(iValue);
		break;
	case(IDC_EDIT_PREVIEW_WINDOW_HEIGHT):
		g_pStCamera->SetPreviewWindowHeight(iValue);
		break;

	case(IDC_EDIT_PREVIEW_MASK_OFFSET_X):
		g_pStCamera->SetPreviewMaskOffsetX(iValue);
		break;
	case(IDC_EDIT_PREVIEW_MASK_OFFSET_Y):
		g_pStCamera->SetPreviewMaskOffsetY(iValue);
		break;
	case(IDC_EDIT_PREVIEW_MASK_WIDTH):
		g_pStCamera->SetPreviewMaskWidth(iValue);
		break;
	case(IDC_EDIT_PREVIEW_MASK_HEIGHT):
		g_pStCamera->SetPreviewMaskHeight(iValue);
		break;

	case(IDC_EDIT_PREVIEW_DEST_OFFSET_X):
		g_pStCamera->SetPreviewDestOffsetX(iValue);
		break;
	case(IDC_EDIT_PREVIEW_DEST_OFFSET_Y):
		g_pStCamera->SetPreviewDestOffsetY(iValue);
		break;
	case(IDC_EDIT_PREVIEW_DEST_WIDTH):
		g_pStCamera->SetPreviewDestWidth(iValue);
		break;
	case(IDC_EDIT_PREVIEW_DEST_HEIGHT):
		g_pStCamera->SetPreviewDestHeight(iValue);
		break;
		
	default:
		break;
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CSetSizeDlg::PreTranslateMessage(MSG* pMsg) 
{
	switch(pMsg->message)
	{
		case(WM_KEYDOWN ):
			switch( pMsg->wParam )
			{
				case VK_RETURN:
					{
						UINT nID = ::GetDlgCtrlID(pMsg->hwnd);
						for(int i = 0; i < sizeof(m_pEditID) / sizeof(UINT); i++)
						{
							if(nID == m_pEditID[i])
							{
								mUpdateByEdit(nID);
								mUpdateDisplay();
								break;
							}
						}
					}
					return TRUE;
				case VK_ESCAPE:
					return TRUE;
				default:
					break;
			}
			break;
	}	
	return CDialog::PreTranslateMessage(pMsg);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CSetSizeDlg::PostNcDestroy() 
{
	CDialog::PostNcDestroy();
	AfxGetMainWnd()->SendMessage(WM_USER_DIALOG_DESTROYED, 0, 0);
	delete this;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CSetSizeDlg::OnOK() 
{
	DestroyWindow();
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CSetSizeDlg::OnCancel()
{
	DestroyWindow();
}
