// StCamera.h: CStCamera
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_STCAMERA_H__75F9A590_8D67_45CA_A4F2_8DBC729FB486__INCLUDED_)
#define AFX_STCAMERA_H__75F9A590_8D67_45CA_A4F2_8DBC729FB486__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CStCamera  
{
public:
	CStCamera(HANDLE hCamera);
	virtual ~CStCamera();

	BOOL	CreateOverlappedWindow();
	BOOL	CreateChildWindow(HWND hParentWnd);

	BOOL	StartTransfer(){return(StCam_StartTransfer(m_hCamera));};
	BOOL	StopTransfer(){return(StCam_StopTransfer(m_hCamera));};

	//Original Image
	DWORD	GetOrgImageWidth(){return(m_dwOrgImageWidth);};
	DWORD	GetOrgImageHeight(){return(m_dwOrgImageHeight);};

	//Display Mode
	BYTE	GetDisplayMode(){return(m_byteDisplayMode);};
	BOOL	SetDisplayMode(BYTE byteDisplayMode)
	{
		m_byteDisplayMode = byteDisplayMode;
		return(mSetDisplayMode());
	};

	//Aspect Mode
	BYTE	GetAspectMode(){return(m_byteAspectMode);};
	BOOL	SetAspectMode(BYTE byteAspectMode)
	{
		m_byteAspectMode = byteAspectMode;
		BOOL bReval = TRUE;
		bReval = mSetAspectMode();
		if(bReval)
		{
			bReval = mRefresh();
		}
		return(bReval);
	};

	//Preview Window
	LONG	GetPreviewWindowOffsetX(){return(m_lPreviewWindowOffsetX);};
	BOOL	SetPreviewWindowOffsetX(LONG lPreviewWindowOffsetX)
	{
		m_lPreviewWindowOffsetX = lPreviewWindowOffsetX;
		return(mSetPreviewWindowSize());
	};
	LONG	GetPreviewWindowOffsetY(){return(m_lPreviewWindowOffsetY);};
	BOOL	SetPreviewWindowOffsetY(LONG lPreviewWindowOffsetY)
	{
		m_lPreviewWindowOffsetY = lPreviewWindowOffsetY;
		return(mSetPreviewWindowSize());
	};
	DWORD	GetPreviewWindowWidth(){return(m_dwPreviewWindowWidth);};
	BOOL	SetPreviewWindowWidth(DWORD dwPreviewWindowWidth)
	{
		m_dwPreviewWindowWidth = dwPreviewWindowWidth;
		return(mSetPreviewWindowSize());
	};
	DWORD	GetPreviewWindowHeight(){return(m_dwPreviewWindowHeight);};
	BOOL	SetPreviewWindowHeight(DWORD dwPreviewWindowHeight)
	{
		m_dwPreviewWindowHeight = dwPreviewWindowHeight;
		return(mSetPreviewWindowSize());
	};


	//Preview Mask
	DWORD	GetPreviewMaskOffsetX(){return(m_dwPreviewMaskOffsetX);};
	BOOL	SetPreviewMaskOffsetX(DWORD dwPreviewMaskOffsetX)
	{
		m_dwPreviewMaskOffsetX= dwPreviewMaskOffsetX;
		return(mSetPreviewMaskSize());
	};
	DWORD	GetPreviewMaskOffsetY(){return(m_dwPreviewMaskOffsetY);};
	BOOL	SetPreviewMaskOffsetY(DWORD dwPreviewMaskOffsetY)
	{
		m_dwPreviewMaskOffsetY = dwPreviewMaskOffsetY;
		return(mSetPreviewMaskSize());
	};
	DWORD	GetPreviewMaskWidth(){return(m_dwPreviewMaskWidth);};
	BOOL	SetPreviewMaskWidth(DWORD dwPreviewMaskWidth)
	{
		m_dwPreviewMaskWidth = dwPreviewMaskWidth;
		return(mSetPreviewMaskSize());
	};
	DWORD	GetPreviewMaskHeight(){return(m_dwPreviewMaskHeight);};
	BOOL	SetPreviewMaskHeight(DWORD dwPreviewMaskHeight)
	{
		m_dwPreviewMaskHeight = dwPreviewMaskHeight;
		return(mSetPreviewMaskSize());
	};

	//Preview Dest
	DWORD	GetPreviewDestOffsetX(){return(m_dwPreviewDestOffsetX);};
	BOOL	SetPreviewDestOffsetX(DWORD dwPreviewDestOffsetX)
	{
		m_dwPreviewDestOffsetX= dwPreviewDestOffsetX;
		return(mSetPreviewDestSize());
	};
	DWORD	GetPreviewDestOffsetY(){return(m_dwPreviewDestOffsetY);};
	BOOL	SetPreviewDestOffsetY(DWORD dwPreviewDestOffsetY)
	{
		m_dwPreviewDestOffsetY = dwPreviewDestOffsetY;
		return(mSetPreviewDestSize());
	};
	DWORD	GetPreviewDestWidth(){return(m_dwPreviewDestWidth);};
	BOOL	SetPreviewDestWidth(DWORD dwPreviewDestWidth)
	{
		m_dwPreviewDestWidth = dwPreviewDestWidth;
		return(mSetPreviewDestSize());
	};
	DWORD	GetPreviewDestHeight(){return(m_dwPreviewDestHeight);};
	BOOL	SetPreviewDestHeight(DWORD dwPreviewDestHeight)
	{
		m_dwPreviewDestHeight = dwPreviewDestHeight;
		return(mSetPreviewDestSize());
	};

protected:
	HANDLE	m_hCamera;

	BOOL	m_IsOverlappedWindow;
	HWND	m_hPreviewParentWnd;
	BOOL	mRefresh();

	//Original Image
	BOOL	mGetImageSize();
	DWORD m_dwOrgImageWidth;
	DWORD m_dwOrgImageHeight;

	//Display Mode
	BOOL	mGetDisplayMode();
	BOOL	mSetDisplayMode();
	BYTE m_byteDisplayMode;

	//Aspect Mode
	BOOL	mGetAspectMode();
	BOOL	mSetAspectMode();
	BYTE m_byteAspectMode;

	//Preview Window
	BOOL	mGetPreviewWindowSize();
	BOOL	mSetPreviewWindowSize();
	LONG m_lPreviewWindowOffsetX;
	LONG m_lPreviewWindowOffsetY;
	DWORD m_dwPreviewWindowWidth;
	DWORD m_dwPreviewWindowHeight;

	//Preview Mask
	BOOL	mGetPreviewMaskSize();
	BOOL	mSetPreviewMaskSize();
	DWORD m_dwPreviewMaskOffsetX;
	DWORD m_dwPreviewMaskOffsetY;
	DWORD m_dwPreviewMaskWidth;
	DWORD m_dwPreviewMaskHeight;

	//Preview Dest
	BOOL	mGetPreviewDestSize();
	BOOL	mSetPreviewDestSize();
	DWORD m_dwPreviewDestOffsetX;
	DWORD m_dwPreviewDestOffsetY;
	DWORD m_dwPreviewDestWidth;
	DWORD m_dwPreviewDestHeight;
};

#endif // !defined(AFX_STCAMERA_H__75F9A590_8D67_45CA_A4F2_8DBC729FB486__INCLUDED_)
