#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;


namespace SampleCallback {

	/// <summary>
	/// FormSnapShot
	/// </summary>
	public ref class FormSnapShot : public System::Windows::Forms::Form
	{
	public:
		FormSnapShot(void) : m_SavedFg(false), m_Bitmap(nullptr)
		{
			InitializeComponent();
		}

	protected:
		/// <summary>
		/// </summary>
		~FormSnapShot()
		{
			if (components)
			{
				delete components;
			}
		}
	private: System::Windows::Forms::SaveFileDialog^  saveFileDialog1;
	protected: 
	private: System::Windows::Forms::ContextMenuStrip^  contextMenuStrip1;
	private: System::Windows::Forms::ToolStripMenuItem^  saveToolStripMenuItem;
	private: System::Windows::Forms::PictureBox^  pictureBox1;
	private: System::ComponentModel::IContainer^  components;

	private:
		/// <summary>
		/// </summary>

	private: Bitmap^ m_Bitmap;
	private: bool m_SavedFg;




	private: void SaveImage()
	{
		if(nullptr != m_Bitmap)
			{
				if(Windows::Forms::DialogResult::OK == saveFileDialog1->ShowDialog())
				{
					m_Bitmap->Save(saveFileDialog1->FileName, System::Drawing::Imaging::ImageFormat::Bmp);
					m_SavedFg = true;
				}
			}
	}
	private: void saveToolStripMenuItem_Click(System::Object^  sender,  EventArgs^ e)
	{
			SaveImage();
	}

	private: void FormSnapShot_FormClosing(System::Object^  sender,  FormClosingEventArgs^ e)
	{
		if (!m_SavedFg)
		{
			if (Windows::Forms::DialogResult::Yes == System::Windows::Forms::MessageBox::Show("Do You Want To Save The Image?", "Save Image", System::Windows::Forms::MessageBoxButtons::YesNo, System::Windows::Forms::MessageBoxIcon::Question))
			{
				SaveImage();
			}
		}
		if (m_Bitmap != nullptr)
		{
			pictureBox1->Image = nullptr;
			m_Bitmap = nullptr;
		}
	}
	private: System::Void FormSnapShot_KeyDown(System::Object^  sender, System::Windows::Forms::KeyEventArgs^  e) {
		if (e->KeyCode == Keys::Apps)
		{
			contextMenuStrip1->Show(this, this->PointToClient(MousePosition));
		}
			 }


	public: bool bUpdateSnapShot(int nWidth, int nHeight, array<unsigned char, 1>^ pbyteImg, unsigned int nBufferSize, System::Drawing::Imaging::PixelFormat pixelFormat)
	{
			Bitmap^ bitmap = gcnew Bitmap(nWidth, nHeight, pixelFormat);
	        

			switch(pixelFormat)
			{
			case(System::Drawing::Imaging::PixelFormat::Format8bppIndexed):
					//Palette
					{
					
						System::Drawing::Imaging::ColorPalette^ colorPalette = bitmap->Palette;
						for(int pixelValue = 0; pixelValue <= 255; pixelValue++)
						{
							colorPalette->Entries[pixelValue] = Color::FromArgb(pixelValue, pixelValue, pixelValue);
						}
						bitmap->Palette = colorPalette;
					}
					break;
			}

			//Copy
			Rectangle rect(0, 0, nWidth, nHeight);
			System::Drawing::Imaging::BitmapData^ bitmapData = bitmap->LockBits(rect, System::Drawing::Imaging::ImageLockMode::WriteOnly, pixelFormat);
			System::Runtime::InteropServices::Marshal::Copy(pbyteImg, 0, bitmapData->Scan0, (int)nBufferSize);
			bitmap->UnlockBits(bitmapData);
		
			if(m_Bitmap != nullptr)
			{
				pictureBox1->Image = nullptr;
			}

			m_Bitmap = bitmap;
			this->ClientSize = System::Drawing::Size(nWidth, nHeight);
			this->MaximumSize = this->Size;
			pictureBox1->Location = System::Drawing::Point(0, 0);
			pictureBox1->Image = m_Bitmap;
			m_SavedFg = false;

			return(true);
	}









#pragma region Windows Form Designer generated code
		/// <summary>
		/// </summary>
		void InitializeComponent(void)
		{
			this->components = (gcnew System::ComponentModel::Container());
			this->saveFileDialog1 = (gcnew System::Windows::Forms::SaveFileDialog());
			this->contextMenuStrip1 = (gcnew System::Windows::Forms::ContextMenuStrip(this->components));
			this->saveToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->pictureBox1 = (gcnew System::Windows::Forms::PictureBox());
			this->contextMenuStrip1->SuspendLayout();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->pictureBox1))->BeginInit();
			this->SuspendLayout();
			// 
			// saveFileDialog1
			// 
			this->saveFileDialog1->DefaultExt = L"bmp";
			this->saveFileDialog1->Filter = L"Bitmap File|*.bmp|All Files|*.*";
			// 
			// contextMenuStrip1
			// 
			this->contextMenuStrip1->Items->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(1) {this->saveToolStripMenuItem});
			this->contextMenuStrip1->Name = L"contextMenuStrip1";
			this->contextMenuStrip1->Size = System::Drawing::Size(106, 26);
			// 
			// saveToolStripMenuItem
			// 
			this->saveToolStripMenuItem->Name = L"saveToolStripMenuItem";
			this->saveToolStripMenuItem->Size = System::Drawing::Size(105, 22);
			this->saveToolStripMenuItem->Text = L"Save";
			this->saveToolStripMenuItem->Click += gcnew System::EventHandler(this, &FormSnapShot::saveToolStripMenuItem_Click);
			// 
			// pictureBox1
			// 
			this->pictureBox1->ContextMenuStrip = this->contextMenuStrip1;
			this->pictureBox1->Location = System::Drawing::Point(47, 50);
			this->pictureBox1->Name = L"pictureBox1";
			this->pictureBox1->Size = System::Drawing::Size(100, 50);
			this->pictureBox1->SizeMode = System::Windows::Forms::PictureBoxSizeMode::AutoSize;
			this->pictureBox1->TabIndex = 1;
			this->pictureBox1->TabStop = false;
			// 
			// FormSnapShot
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 12);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->AutoScroll = true;
			this->ClientSize = System::Drawing::Size(284, 262);
			this->Controls->Add(this->pictureBox1);
			this->Name = L"FormSnapShot";
			this->Text = L"Snap Shot";
			this->FormClosing += gcnew System::Windows::Forms::FormClosingEventHandler(this, &FormSnapShot::FormSnapShot_FormClosing);
			this->KeyDown += gcnew System::Windows::Forms::KeyEventHandler(this, &FormSnapShot::FormSnapShot_KeyDown);
			this->contextMenuStrip1->ResumeLayout(false);
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->pictureBox1))->EndInit();
			this->ResumeLayout(false);
			this->PerformLayout();

		}
#pragma endregion
};
}
