#pragma once


namespace SampleRcvMsg {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	using namespace SensorTechnology;

	/// <summary>
	/// Form1
	/// </summary>
	public ref class Form1 : public System::Windows::Forms::Form
	{
	public:
		Form1(void) : m_bStatusTransfer(false), m_bStatusAVIFile(false), m_bStatusPreviewWnd(false)
		{
			InitializeComponent();
		}

	protected:
		/// <summary>
		/// </summary>
		~Form1()
		{
			if (components)
			{
				delete components;
			}
		}
	private: System::Windows::Forms::Button^  btnPreview;
	protected: 

	private:
		/// <summary>
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// </summary>
		void InitializeComponent(void)
		{
			this->btnPreview = (gcnew System::Windows::Forms::Button());
			this->SuspendLayout();
			// 
			// btnPreview
			// 
			this->btnPreview->Location = System::Drawing::Point(13, 13);
			this->btnPreview->Name = L"btnPreview";
			this->btnPreview->Size = System::Drawing::Size(75, 23);
			this->btnPreview->TabIndex = 0;
			this->btnPreview->Text = L"Preview";
			this->btnPreview->UseVisualStyleBackColor = true;
			this->btnPreview->Click += gcnew System::EventHandler(this, &Form1::btnPreview_Click);
			// 
			// Form1
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 12);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->ClientSize = System::Drawing::Size(116, 43);
			this->Controls->Add(this->btnPreview);
			this->Name = L"Form1";
			this->Text = L"Form1";
			this->Load += gcnew System::EventHandler(this, &Form1::Form1_Load);
			this->FormClosed += gcnew System::Windows::Forms::FormClosedEventHandler(this, &Form1::Form1_FormClosed);
			this->ResumeLayout(false);

		}
#pragma endregion
	private: StCam::HANDLE m_hCamera;
	private: bool m_bStatusTransfer;
	private: bool m_bStatusAVIFile;
	private: bool m_bStatusPreviewWnd;
	
	private: void StatusChanged()
	{
		if(m_bStatusPreviewWnd && m_bStatusTransfer)
			btnPreview->Text = "STOP";
		else
			btnPreview->Text = "START";
	}

	private: System::Void Form1_Load(System::Object^  sender, System::EventArgs^  e) {
				m_hCamera = StCam::Open(0);
				StCam::SetReceiveMsgWindow(m_hCamera, this->Handle);
				StatusChanged();
			 }
	private: System::Void Form1_FormClosed(System::Object^  sender, System::Windows::Forms::FormClosedEventArgs^  e) {
				if(m_hCamera != IntPtr::Zero) StCam::Close(m_hCamera);
			 }
	private: System::Void btnPreview_Click(System::Object^  sender, System::EventArgs^  e) {
			
				if(m_bStatusPreviewWnd && m_bStatusTransfer)
				{
					//Stop
					StCam::StopTransfer(m_hCamera);
				}
				else
				{
					//Start
					StCam::CreatePreviewWindow(
						m_hCamera,
						"Preview",
						StCam::WS_OVERLAPPEDWINDOW | StCam::WS_VISIBLE,
						0,0,0,0,System::IntPtr::Zero,System::IntPtr::Zero,true);
					StCam::StartTransfer(m_hCamera);	
				}
			 }
	protected:
			virtual void WndProc(Message% m) override 
			{
				switch(m.Msg)
				{
				case StCam::WM_STCAM_TRANSFER_START:
					m_bStatusTransfer = true;
					StatusChanged();
					break;
				case StCam::WM_STCAM_TRANSFER_FINISH:
					m_bStatusTransfer = false;
					StatusChanged();
					break;
				case StCam::WM_STCAM_AVI_FILE_START:
					m_bStatusAVIFile = true;
					StatusChanged();
					break;
				case StCam::WM_STCAM_AVI_FILE_FINISH:
					m_bStatusAVIFile = false;
					StatusChanged();
					break;
				case StCam::WM_STCAM_PREVIEW_WINDOW_CREATE:
					m_bStatusPreviewWnd = true;
					StatusChanged();
					break;
				case StCam::WM_STCAM_PREVIEW_WINDOW_CLOSE:
					m_bStatusPreviewWnd = false;
					StatusChanged();
					break;
				default:
					Form::WndProc(m);
					break;
				}
			}
	};
}

