#pragma once

#include "FormSnapShot.h"
namespace SampleSnap {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	using namespace SensorTechnology;
	using namespace System::Runtime::InteropServices;
	/// <summary>
	/// Form1
	/// </summary>
	public ref class Form1 : public System::Windows::Forms::Form
	{
	public:
		Form1(void) : m_bStatusTransfer(false), m_bStatusAVIFile(false), m_bStatusPreviewWnd(false)
		{
			InitializeComponent();
		}

	protected:
		/// <summary>
		/// </summary>
		~Form1()
		{
			if (components)
			{
				delete components;
			}
		}
	private: System::Windows::Forms::Button^  btnPreview;
	private: System::Windows::Forms::Button^  btnSnap;
	protected: 

	private:
		/// <summary>
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// </summary>
		void InitializeComponent(void)
		{
			this->btnPreview = (gcnew System::Windows::Forms::Button());
			this->btnSnap = (gcnew System::Windows::Forms::Button());
			this->SuspendLayout();
			// 
			// btnPreview
			// 
			this->btnPreview->Location = System::Drawing::Point(12, 12);
			this->btnPreview->Name = L"btnPreview";
			this->btnPreview->Size = System::Drawing::Size(75, 23);
			this->btnPreview->TabIndex = 0;
			this->btnPreview->Text = L"Preview";
			this->btnPreview->UseVisualStyleBackColor = true;
			this->btnPreview->Click += gcnew System::EventHandler(this, &Form1::btnPreview_Click);
			// 
			// btnSnap
			// 
			this->btnSnap->Location = System::Drawing::Point(12, 41);
			this->btnSnap->Name = L"btnSnap";
			this->btnSnap->Size = System::Drawing::Size(75, 23);
			this->btnSnap->TabIndex = 1;
			this->btnSnap->Text = L"Snap";
			this->btnSnap->UseVisualStyleBackColor = true;
			this->btnSnap->Click += gcnew System::EventHandler(this, &Form1::btnSnap_Click);
			// 
			// Form1
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 12);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->ClientSize = System::Drawing::Size(116, 79);
			this->Controls->Add(this->btnSnap);
			this->Controls->Add(this->btnPreview);
			this->Name = L"Form1";
			this->Text = L"Form1";
			this->Load += gcnew System::EventHandler(this, &Form1::Form1_Load);
			this->FormClosed += gcnew System::Windows::Forms::FormClosedEventHandler(this, &Form1::Form1_FormClosed);
			this->ResumeLayout(false);

		}
#pragma endregion
	private: StCam::HANDLE m_hCamera;
	private: bool m_bStatusTransfer;
	private: bool m_bStatusAVIFile;
	private: bool m_bStatusPreviewWnd;
	private: FormSnapShot^ m_FormSnapShot;
	private: void StatusChanged()
	{
		if(m_bStatusPreviewWnd && m_bStatusTransfer)
			btnPreview->Text = "STOP";
		else
			btnPreview->Text = "START";
	}

	private: System::Void Form1_Load(System::Object^  sender, System::EventArgs^  e) {
				m_hCamera = StCam::Open(0);
				if(m_hCamera == IntPtr::Zero)
					ShowErrorMsg(StCam::GetLastError(m_hCamera));
				if(!StCam::SetReceiveMsgWindow(m_hCamera, this->Handle))
					ShowErrorMsg(StCam::GetLastError(m_hCamera));
				StatusChanged();
			 }
	private: System::Void Form1_FormClosed(System::Object^  sender, System::Windows::Forms::FormClosedEventArgs^  e) {
				 if(m_hCamera != IntPtr::Zero) StCam::Close(m_hCamera);
			 }
	private: System::Void btnPreview_Click(System::Object^  sender, System::EventArgs^  e) {
			

				if(m_bStatusPreviewWnd && m_bStatusTransfer)
				{
					//Stop
					if(!StCam::StopTransfer(m_hCamera))
						ShowErrorMsg(StCam::GetLastError(m_hCamera));
				}
				else
				{
					//Start
					if(!StCam::CreatePreviewWindow(
						m_hCamera,"Preview",
						StCam::WS_OVERLAPPEDWINDOW | StCam::WS_VISIBLE,
						0,0,0,0,System::IntPtr::Zero,System::IntPtr::Zero,true))
						ShowErrorMsg(StCam::GetLastError(m_hCamera));
					if(!StCam::StartTransfer(m_hCamera))
						ShowErrorMsg(StCam::GetLastError(m_hCamera));
				}
			 }
	protected:
			virtual void WndProc(Message% m) override 
			{
				switch(m.Msg)
				{
				case StCam::WM_STCAM_TRANSFER_START:
					m_bStatusTransfer = true;
					StatusChanged();
					break;
				case StCam::WM_STCAM_TRANSFER_FINISH:
					m_bStatusTransfer = false;
					StatusChanged();
					if(m.LParam.ToInt32() != 0)
						ShowErrorMsg((unsigned int)m.LParam.ToInt32());
					break;
				case StCam::WM_STCAM_AVI_FILE_START:
					m_bStatusAVIFile = true;
					StatusChanged();
					break;
				case StCam::WM_STCAM_AVI_FILE_FINISH:
					m_bStatusAVIFile = false;
					StatusChanged();
					if(m.LParam.ToInt32() != 0)
						ShowErrorMsg((unsigned int)m.LParam.ToInt32());
					break;
				case StCam::WM_STCAM_PREVIEW_WINDOW_CREATE:
					m_bStatusPreviewWnd = true;
					StatusChanged();
					break;
				case StCam::WM_STCAM_PREVIEW_WINDOW_CLOSE:
					m_bStatusPreviewWnd = false;
					StatusChanged();
					if(m.LParam.ToInt32() != 0)
						ShowErrorMsg((unsigned int)m.LParam.ToInt32());
					break;
				default:
					Form::WndProc(m);
					break;
				}
			}
	private:
		[DllImport("kernel32.dll",  CharSet=System::Runtime::InteropServices::CharSet::Auto, EntryPoint="FormatMessage")]
		static int FormatMessage(int dwFlags, IntPtr lpSource,
			int dwMessageId, int dwLanguageId, System::Text::StringBuilder^ lpBuffer, int nSize, IntPtr Arguments);
		[DllImport("kernel32.dll", CharSet=System::Runtime::InteropServices::CharSet::Auto)]
		static IntPtr LoadLibraryEx(String^ lpszLibFile, IntPtr hFile, int dwFlags);
		[DllImport("kernel32.dll")]
		static int FreeLibrary(IntPtr hModule);

		void ShowErrorMsg(unsigned int dwErrorCode)
		{
			int FORMAT_MESSAGE_FROM_SYSTEM = 0x00001000;
			int FORMAT_MESSAGE_FROM_HMODULE = 0x00000800;

			int DONT_RESOLVE_DLL_REFERENCES = 0x00000001;

			System::Text::StringBuilder^ strErrorMsg = gcnew System::Text::StringBuilder(255);
			int dwFlags = FORMAT_MESSAGE_FROM_SYSTEM;
			IntPtr ptrlpSource = IntPtr::Zero;

			int iFoundErrMsg = FormatMessage(dwFlags, ptrlpSource, (int)dwErrorCode, 0, strErrorMsg, strErrorMsg->Capacity, IntPtr::Zero);
			if(iFoundErrMsg == 0)
			{
				ptrlpSource = LoadLibraryEx("StCamMsg.dll", IntPtr::Zero, DONT_RESOLVE_DLL_REFERENCES);
				dwFlags |= FORMAT_MESSAGE_FROM_HMODULE;

				if(!ptrlpSource.Equals(IntPtr::Zero))
				{
					iFoundErrMsg = FormatMessage(dwFlags, ptrlpSource, (int)dwErrorCode, 0, strErrorMsg, strErrorMsg->Capacity, IntPtr::Zero);
					FreeLibrary(ptrlpSource);
				}
			}

			System::Windows::Forms::MessageBox::Show(strErrorMsg->ToString(), "Error Message", System::Windows::Forms::MessageBoxButtons::OK, System::Windows::Forms::MessageBoxIcon::Exclamation);

		}
	private: System::Void btnSnap_Click(System::Object^  sender, System::EventArgs^  e) {
		bool bReval = true;
		unsigned int nLastErrorNo = 0;

		do
		{
			//Get Image Size
			unsigned int dwSize;
			unsigned int dwWidth;
			unsigned int dwHeight;
			unsigned int dwLinePitch;
			bReval = StCam::GetPreviewDataSize(m_hCamera,  dwSize, dwWidth,  dwHeight,  dwLinePitch);
			if (!bReval)
			{
				nLastErrorNo = StCam::GetLastError(m_hCamera);
				break;
			}

			//Get Preview Pixel Format
			unsigned int dwPreviewPixelFormat;
			bReval = StCam::GetPreviewPixelFormat(m_hCamera, dwPreviewPixelFormat);
			if (!bReval)
			{
				nLastErrorNo = StCam::GetLastError(m_hCamera);
				break;
			}

			//Allocate Memory
			System::Drawing::Imaging::PixelFormat pixelFormat = System::Drawing::Imaging::PixelFormat::Format8bppIndexed;
			switch (dwPreviewPixelFormat)
			{
				case (StCam::STCAM_PIXEL_FORMAT_24_BGR):
					pixelFormat = System::Drawing::Imaging::PixelFormat::Format24bppRgb;
					break;
				case (StCam::STCAM_PIXEL_FORMAT_32_BGR):
					pixelFormat = System::Drawing::Imaging::PixelFormat::Format32bppRgb;
					break;
			}

			array<unsigned char, 1>^ pbyteImageBuffer = gcnew array<unsigned char,1>(dwSize);

			//Take Snap Shot
			unsigned int dwNumberOfByteTrans;
			unsigned int pdwFrameNo[1];
			unsigned int dwMilliseconds = 100;
			System::Runtime::InteropServices::GCHandle gch = System::Runtime::InteropServices::GCHandle::Alloc(pbyteImageBuffer, System::Runtime::InteropServices::GCHandleType::Pinned);
			System::IntPtr ptr = gch.AddrOfPinnedObject();

			bReval = StCam::TakePreviewSnapShot(m_hCamera, ptr, dwSize, dwNumberOfByteTrans, pdwFrameNo, dwMilliseconds);

			gch.Free();
			if (!bReval)
			{
				nLastErrorNo = StCam::GetLastError(m_hCamera);
				break;
			}

			if (m_FormSnapShot == nullptr)
			{
				m_FormSnapShot = gcnew FormSnapShot();
				m_FormSnapShot->FormClosed += gcnew System::Windows::Forms::FormClosedEventHandler(this, &Form1::FormSnapShot_FormClosed);
			}
			m_FormSnapShot->bUpdateSnapShot((int)dwWidth, (int)dwHeight, pbyteImageBuffer, dwSize, pixelFormat);
			m_FormSnapShot->Show();
		} while (false);

		//Show Error Message
		if (!bReval)
		{
			ShowErrorMsg(nLastErrorNo);
		}
	}
	private: void FormSnapShot_FormClosed(System::Object^ sender, System::Windows::Forms::FormClosedEventArgs^ e)
	{
		m_FormSnapShot = nullptr;
	}
};
}

