﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SensorTechnology;

namespace PreviewSize
{
	public partial class frmMain : Form
	{
		public frmMain(CStCamera stCamera)
		{
			InitializeComponent();
			m_StCamera = stCamera;
			eventActivated = new System.EventHandler(this.frmMain_Activated);
			Activated += eventActivated;
		}

		private CStCamera m_StCamera = null;
		private frmSetting m_frmSetting = null;
		private System.EventHandler eventActivated = null;



		private void frmMain_Activated(object sender, System.EventArgs e)
		{
			Activated -= eventActivated;
			childWindowToolStripMenuItem.PerformClick();
			m_StCamera.StartTransfer();
		}
		private void menuItemWindowStyle_Click(object sender, System.EventArgs e)
		{
			bool bChildWindow = childWindowToolStripMenuItem.Equals(sender);
			IntPtr hParentWindow = IntPtr.Zero;
			bool result = true;

			if (bChildWindow)
			{
				hParentWindow = panelImage.Handle;
			}

			result = m_StCamera.CreateWindow(hParentWindow);

			childWindowToolStripMenuItem.Checked = bChildWindow;
			overlappedToolStripMenuItem.Checked = !bChildWindow;
		}

		private void menuItemSetting_Click(object sender, System.EventArgs e)
		{
			if (m_frmSetting == null)
			{
				m_frmSetting = new frmSetting(m_StCamera);
				m_frmSetting.Closed += new System.EventHandler(frmSetting_Closed);
			}
			m_frmSetting.Show();
			m_frmSetting.Activate();
		}
		private void frmSetting_Closed(object sender, System.EventArgs e)
		{
			m_frmSetting = null;
		}

		private void frmMain_FormClosing(object sender, FormClosingEventArgs e)
		{
			if (m_StCamera != null)
			{
				m_StCamera.Dispose();
				m_StCamera = null;
			}

		}
	}
}