using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SensorTechnology;
using SettingCtrl;

namespace PreviewSize
{
	public partial class frmSetting : Form
	{
		public frmSetting(CStCamera stCamera)
		{
			InitializeComponent();
			m_StCamera = stCamera;
		}

		private CStCamera m_StCamera = null;

		private void OnUpdateSettingValue(object sender, System.EventArgs e)
		{
			ISettingCtrl isc = sender as ISettingCtrl;

			switch (isc.SettingID)
			{
				case (SettingIDs.DISPLAY_MODE):
					m_StCamera.DisplayMode = (byte)isc.SettingValue;
					break;
				case (SettingIDs.ASPECT_MODE):
					m_StCamera.AspectMode = (byte)isc.SettingValue;
					break;
				case (SettingIDs.PW_OFFSETX):
					m_StCamera.PreviewWindowOffsetX = isc.SettingValue;
					break;
				case (SettingIDs.PW_OFFSETY):
					m_StCamera.PreviewWindowOffsetY = isc.SettingValue;
					break;
				case (SettingIDs.PW_WIDTH):
					m_StCamera.PreviewWindowWidth = (uint)isc.SettingValue;
					break;
				case (SettingIDs.PW_HEIGHT):
					m_StCamera.PreviewWindowHeight = (uint)isc.SettingValue;
					break;
				case (SettingIDs.PM_OFFSETX):
					m_StCamera.PreviewMaskOffsetX = (uint)isc.SettingValue;
					break;
				case (SettingIDs.PM_OFFSETY):
					m_StCamera.PreviewMaskOffsetY = (uint)isc.SettingValue;
					break;
				case (SettingIDs.PM_WIDTH):
					m_StCamera.PreviewMaskWidth = (uint)isc.SettingValue;
					break;
				case (SettingIDs.PM_HEIGHT):
					m_StCamera.PreviewMaskHeight = (uint)isc.SettingValue;
					break;
				case (SettingIDs.PD_OFFSETX):
					m_StCamera.PreviewDestOffsetX = (uint)isc.SettingValue;
					break;
				case (SettingIDs.PD_OFFSETY):
					m_StCamera.PreviewDestOffsetY = (uint)isc.SettingValue;
					break;
				case (SettingIDs.PD_WIDTH):
					m_StCamera.PreviewDestWidth = (uint)isc.SettingValue;
					break;
				case (SettingIDs.PD_HEIGHT):
					m_StCamera.PreviewDestHeight = (uint)isc.SettingValue;
					break;
			}


			mUpdateDisplay();
		}

		private void frmSetting_Load(object sender, System.EventArgs e)
		{
			mInitComboBox();
			mUpdateDisplay();
		}
		private void mUpdateDisplay()
		{
			mUpdateDisplayComboBox();
			mUpdateDisplayTextBoxAndScrollBar();
		}
		private void mInitComboBox()
		{
			CItemForComboBox[] itemsAspectMode = new CItemForComboBox[]{
																		   new CItemForComboBox("Fixed", StCam.STCAM_ASPECT_MODE_FIXED),
																		   new CItemForComboBox("Keep Aspect", StCam.STCAM_ASPECT_MODE_KEEP_ASPECT),
																		   new CItemForComboBox("Adjust Window", StCam.STCAM_ASPECT_MODE_ADJUST_WINDOW),
																		   new CItemForComboBox("Mask", StCam.STCAM_ASPECT_MODE_MASK_SIZE),
																		   new CItemForComboBox("Custom(Offset)", StCam.STCAM_ASPECT_MODE_CUSTOM_OFFSET),
																		   new CItemForComboBox("Custom(Center)", StCam.STCAM_ASPECT_MODE_CUSTOM_CENTER)};

			comboBoxAspectMode.Items.Clear();
			comboBoxAspectMode.Items.AddRange(itemsAspectMode);
			comboBoxAspectMode.SelectedIndex = 0;


			CItemForComboBox[] itemsDisplayMode = new CItemForComboBox[]{ 
																			new CItemForComboBox("GDI", StCam.STCAM_DISPLAY_MODE_GDI), 
																			new CItemForComboBox("DirectDraw[Offscreeen]", StCam.STCAM_DISPLAY_MODE_DD_OFFSCREEN), 
																			new CItemForComboBox("DirectDraw[Overlay]", StCam.STCAM_DISPLAY_MODE_DD_OVERLAY), 
																			new CItemForComboBox("DirectDraw[Offscreen HQ]", StCam.STCAM_DISPLAY_MODE_DD_OFFSCREEN_HQ), 
																			new CItemForComboBox("DirectDraw[Overlay HQ]", StCam.STCAM_DISPLAY_MODE_DD_OVERLAY_HQ), 
																			new CItemForComboBox("DirectX", StCam.STCAM_DISPLAY_MODE_DIRECTX), 
																			new CItemForComboBox("DirectX[V Sync ON]", StCam.STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON), 
																			new CItemForComboBox("DirectX[V Sync ON 2]", StCam.STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON2)};


			comboBoxDisplayMode.Items.Clear();
			comboBoxDisplayMode.Items.AddRange(itemsDisplayMode);
			comboBoxDisplayMode.SelectedIndex = 0;

		}
		private void mUpdateDisplayComboBox()
		{
			comboBoxDisplayMode.SettingValue = m_StCamera.DisplayMode;
			comboBoxAspectMode.SettingValue = m_StCamera.AspectMode;
		}
		private void mUpdateDisplayTextBoxAndScrollBar()
		{
			SettingTextBox[] aTB = new SettingTextBox[] { 
											tbPWOffsetX, tbPWOffsetY, tbPWWidth, tbPWHeight, 
											tbPMOffsetX, tbPMOffsetY, tbPMWidth, tbPMHeight, 
											tbPDOffsetX, tbPDOffsetY, tbPDWidth, tbPDHeight};

			SettingScrollBar[] aSB = new SettingScrollBar[] { 
											sbPWOffsetX, sbPWOffsetY, sbPWWidth, sbPWHeight, 
											sbPMOffsetX, sbPMOffsetY, sbPMWidth, sbPMHeight, 
											sbPDOffsetX, sbPDOffsetY, sbPDWidth, sbPDHeight};

			for (int i = 0; i < aTB.GetLength(0); i++)
			{
				const int maxSizeH = 2048;
                const int maxSizeV = 2048;
				int val = 0;
				int max = 0;
				int min = 0;
				bool enabled = true;

				//val , max
				switch (aTB[i].SettingID)
				{
					case (SettingIDs.PW_OFFSETX):
						max = maxSizeH;
						val = m_StCamera.PreviewWindowOffsetX;
						break;
					case (SettingIDs.PW_OFFSETY):
						max = maxSizeV;
						val = m_StCamera.PreviewWindowOffsetY;
						break;
					case (SettingIDs.PW_WIDTH):
						max = maxSizeH;
						val = (int)m_StCamera.PreviewWindowWidth;
						break;
					case (SettingIDs.PW_HEIGHT):
						max = maxSizeV;
						val = (int)m_StCamera.PreviewWindowHeight;
						break;
					case (SettingIDs.PM_OFFSETX):
						max = (int)m_StCamera.OrgImageWidth - (int)m_StCamera.PreviewMaskWidth;
						val = (int)m_StCamera.PreviewMaskOffsetX;
						break;
					case (SettingIDs.PM_OFFSETY):
						max = (int)m_StCamera.OrgImageHeight - (int)m_StCamera.PreviewMaskHeight;
						val = (int)m_StCamera.PreviewMaskOffsetY;
						break;
					case (SettingIDs.PM_WIDTH):
						max = (int)m_StCamera.OrgImageWidth - (int)m_StCamera.PreviewMaskOffsetX;
						val = (int)m_StCamera.PreviewMaskWidth;
						break;
					case (SettingIDs.PM_HEIGHT):
						max = (int)m_StCamera.OrgImageHeight - (int)m_StCamera.PreviewMaskOffsetY;
						val = (int)m_StCamera.PreviewMaskHeight;
						break;
					case (SettingIDs.PD_OFFSETX):
						max = maxSizeH;
						val = (int)m_StCamera.PreviewDestOffsetX;
						break;
					case (SettingIDs.PD_OFFSETY):
						max = maxSizeV;
						val = (int)m_StCamera.PreviewDestOffsetY;
						break;
					case (SettingIDs.PD_WIDTH):
						max = maxSizeH;
						val = (int)m_StCamera.PreviewDestWidth;
						break;
					case (SettingIDs.PD_HEIGHT):
						max = maxSizeV;
						val = (int)m_StCamera.PreviewDestHeight;
						break;
				}

				//Enabled
				if ((max <= min) || (val < min) || (max < val))
				{
					enabled = false;
				}
				else
				{
					switch (aTB[i].SettingID)
					{
						case (SettingIDs.PD_OFFSETX):
						case (SettingIDs.PD_OFFSETY):
						case (SettingIDs.PD_WIDTH):
						case (SettingIDs.PD_HEIGHT):
							byte byteAspectMode = m_StCamera.AspectMode;
							if ((byteAspectMode != StCam.STCAM_ASPECT_MODE_CUSTOM_OFFSET) && (byteAspectMode != StCam.STCAM_ASPECT_MODE_CUSTOM))
							{
								enabled = false;
							}
							break;
					}



				}


				aTB[i].SettingMin = min;
				aTB[i].SettingMax = max;
				aTB[i].SettingValue = val;
				aTB[i].Enabled = enabled;

				aSB[i].SettingMin = min;
				aSB[i].SettingMax = max;
				aSB[i].SettingValue = val;
				aSB[i].Enabled = enabled;

			}
		}

	}
}