using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SensorTechnology;

namespace SampleRcvMsg
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        private System.IntPtr m_hCamera;
        private bool m_bStatusTransfer = false;
        private bool m_bStatusAVIFile = false;
        private bool m_bStatusPreviewWnd = false;

        private void Form1_Load(object sender, EventArgs e)
        {
            m_hCamera = StCam.Open(0);
            StCam.SetReceiveMsgWindow(m_hCamera, this.Handle);
            StatusChanged();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            if (m_hCamera != System.IntPtr.Zero)
                StCam.Close(m_hCamera);
        }

        private void btnPreview_Click(object sender, EventArgs e)
        {
            if (m_bStatusPreviewWnd && m_bStatusTransfer)
            {
                //Stop
                StCam.StopTransfer(m_hCamera);
            }
            else
            {
                //Start
                StCam.CreatePreviewWindow(
                    m_hCamera,
                    "Preview",
                    StCam.WS_OVERLAPPEDWINDOW | StCam.WS_VISIBLE,
                    0, 0, 0, 0, System.IntPtr.Zero, System.IntPtr.Zero, true);
                StCam.StartTransfer(m_hCamera);
            }
        }
        private void StatusChanged()
        {
            if (m_bStatusPreviewWnd && m_bStatusTransfer)
                btnPreview.Text = "STOP";
            else
                btnPreview.Text = "START";
        }
        [System.Security.Permissions.PermissionSet(
            System.Security.Permissions.SecurityAction.Demand,
            Name = "FullTrust")]
        protected override void WndProc(ref Message m)
        {
            switch (m.Msg)
            {
                case StCam.WM_STCAM_TRANSFER_START:
                    m_bStatusTransfer = true;
                    StatusChanged();
                    break;
                case StCam.WM_STCAM_TRANSFER_FINISH:
                    m_bStatusTransfer = false;
                    StatusChanged();
                    break;
                case StCam.WM_STCAM_AVI_FILE_START:
                    m_bStatusAVIFile = true;
                    StatusChanged();
                    break;
                case StCam.WM_STCAM_AVI_FILE_FINISH:
                    m_bStatusAVIFile = false;
                    StatusChanged();
                    break;
                case StCam.WM_STCAM_PREVIEW_WINDOW_CREATE:
                    m_bStatusPreviewWnd = true;
                    StatusChanged();
                    break;
                case StCam.WM_STCAM_PREVIEW_WINDOW_CLOSE:
                    m_bStatusPreviewWnd = false;
                    StatusChanged();
                    break;
                default:
                    base.WndProc(ref m);
                    break;
            }
        }
    }
}