﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using SensorTechnology;

namespace StCamSWareCS
{
	static class Program
	{
		[STAThread]
		static void Main()
		{
			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault(false);
            bool disconnected = false;

            do
            {
                disconnected = false;
                frmSelectCamera selectCamera = new frmSelectCamera();
                if (DialogResult.OK == selectCamera.ShowDialog())
                {
                    CStCamera stCamera = selectCamera.OpendCamera;
                    selectCamera.Dispose();

                    if (stCamera != null)
                    {
                        frmMain frm = new frmMain(stCamera);
                        Application.Run(frm);
                        disconnected = frm.Disconnected;
                    }
                }
            } while (disconnected);
		}
	}
}