//Created Date:2010/04/16 11:52
namespace SensorTechnology {
	namespace StCam {
		using namespace System;
		using namespace System::Runtime::InteropServices;
		public __delegate void fStCamPreviewBitmapCallbackFunc(unsigned char* pbyteBitmap,unsigned int dwBufferSize, unsigned int dwWidth, unsigned int dwHeight, unsigned int dwFrameNo, unsigned int dwPreviewPixelFormat, System::IntPtr lpContext,System::IntPtr lpReserved);
		public __delegate void fStCamRawCallbackFunc(unsigned char* pbyteBuffer,unsigned int dwBufferSize, unsigned int dwWidth, unsigned int dwHeight, unsigned int dwFrameNo,unsigned short wColorArray, unsigned int dwTransferBitsPerPixel, System::IntPtr lpContext,System::IntPtr lpReserved);
		public __delegate void fStCamPreviewGDICallbackFunc(System::IntPtr hDC, unsigned int dwWidth, unsigned int dwHeight,  unsigned int dwFrameNo,System::IntPtr lpContext,System::IntPtr lpReserved);
		//------------------------------------------------------------------------------
		//Function
		//------------------------------------------------------------------------------

		//------------------------------------------------------------------------------
		//Initialize
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", EntryPoint="StCam_Open")]
		extern "C" int Open(unsigned int dwInstance);
		[DllImport("StCamD.dll", EntryPoint="StCam_Close")]
		extern "C" void Close(int hCamera);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetLastError")]
		extern "C" unsigned int GetLastError(int hCamera);
		[DllImport("StCamD.dll", EntryPoint="StCam_CameraCount")]
		extern "C" unsigned int CameraCount();
		[DllImport("StCamD.dll", EntryPoint="StCam_SetReceiveMsgWindow")]
		extern "C" bool SetReceiveMsgWindow(int hCamera, System::IntPtr hWnd);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetUSBSpeed")]
		extern "C" bool GetUSBSpeed(int hCamera, unsigned char* pbyteUSBSpeed);

		//------------------------------------------------------------------------------
		//Image Information
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", EntryPoint="StCam_GetColorArray")]
		extern "C" bool GetColorArray(int hCamera, unsigned short* pwColorArray);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetTransferBitsPerPixel")]
		extern "C" bool SetTransferBitsPerPixel(int hCamera, unsigned int dwTransferBitsPerPixel);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetTransferBitsPerPixel")]
		extern "C" bool GetTransferBitsPerPixel(int hCamera, unsigned int* pdwTransferBitsPerPixel);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetEnableTransferBitsPerPixel")]
		extern "C" bool GetEnableTransferBitsPerPixel(int hCamera, unsigned int* pdwEnableTransferBitsPerPixel);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetImageSize")]
		extern "C" bool SetImageSize(int hCamera, unsigned int dwImageSizeMode, unsigned short wScanMode, unsigned int dwOffsetX, unsigned int dwOffsetY, unsigned int dwWidth, unsigned int dwHeight);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetImageSize")]
		extern "C" bool GetImageSize(int hCamera, unsigned int* pdwImageSizeMode, unsigned short* pwScanMode, unsigned int* pdwOffsetX, unsigned int* pdwOffsetY, unsigned int* pdwWidth, unsigned int* pdwHeight);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetEnableImageSize")]
		extern "C" bool GetEnableImageSize(int hCamera, unsigned int* pdwEnableImageSizeMode, unsigned short* pwEnableScanMode);

		//------------------------------------------------------------------------------
		//Preview
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", EntryPoint="StCam_StartTransfer")]
		extern "C" bool StartTransfer(int hCamera);
		[DllImport("StCamD.dll", EntryPoint="StCam_StopTransfer")]
		extern "C" bool StopTransfer(int hCamera);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetPreviewPixelFormat")]
		extern "C" bool SetPreviewPixelFormat(int hCamera, unsigned int dwPreviewPixelFormat);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetPreviewPixelFormat")]
		extern "C" bool GetPreviewPixelFormat(int hCamera, unsigned int* pdwPreviewPixelFormat);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetEnablePreviewPixelFormat")]
		extern "C" bool GetEnablePreviewPixelFormat(int hCamera, unsigned int* pdwEnablePreviewPixelFormat);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetColorInterpolationMethod")]
		extern "C" bool SetColorInterpolationMethod(int hCamera, unsigned char byteColorInterpolationMethod);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetColorInterpolationMethod")]
		extern "C" bool GetColorInterpolationMethod(int hCamera, unsigned char* pbyteColorInterpolationMethod);
		[DllImport("StCamD.dll", CharSet=CharSet::Ansi, EntryPoint="StCam_CreatePreviewWindowA")]
		extern "C" bool CreatePreviewWindowA(int hCamera, String* pszWindowName, unsigned int dwStyle, int lngPositionX, int lngPositionY, unsigned int dwWidth, unsigned int dwHeight, System::IntPtr hWndParent, System::IntPtr hMenu, bool bCloseEnable);
		[DllImport("StCamD.dll", CharSet=CharSet::Unicode, EntryPoint="StCam_CreatePreviewWindowW")]
		extern "C" bool CreatePreviewWindowW(int hCamera, String* pszWindowName, unsigned int dwStyle, int lngPositionX, int lngPositionY, unsigned int dwWidth, unsigned int dwHeight, System::IntPtr hWndParent, System::IntPtr hMenu, bool bCloseEnable);
		[DllImport("StCamD.dll", CharSet=CharSet::Auto, EntryPoint="StCam_CreatePreviewWindow")]
		extern "C" bool CreatePreviewWindow(int hCamera, String* pszWindowName, unsigned int dwStyle, int lngPositionX, int lngPositionY, unsigned int dwWidth, unsigned int dwHeight, System::IntPtr hWndParent, System::IntPtr hMenu, bool bCloseEnable);
		[DllImport("StCamD.dll", EntryPoint="StCam_DestroyPreviewWindow")]
		extern "C" bool DestroyPreviewWindow(int hCamera);
		[DllImport("StCamD.dll", CharSet=CharSet::Ansi, EntryPoint="StCam_SetPreviewWindowNameA")]
		extern "C" bool SetPreviewWindowNameA(int hCamera, String* pszWindowName);
		[DllImport("StCamD.dll", CharSet=CharSet::Ansi, EntryPoint="StCam_GetPreviewWindowNameA")]
		extern "C" bool GetPreviewWindowNameA(int hCamera, System::Text::StringBuilder* pszWindowName, int lngMaxCount);
		[DllImport("StCamD.dll", CharSet=CharSet::Unicode, EntryPoint="StCam_SetPreviewWindowNameW")]
		extern "C" bool SetPreviewWindowNameW(int hCamera, String* pszWindowName);
		[DllImport("StCamD.dll", CharSet=CharSet::Auto, EntryPoint="StCam_SetPreviewWindowName")]
		extern "C" bool SetPreviewWindowName(int hCamera, String* pszWindowName);
		[DllImport("StCamD.dll", CharSet=CharSet::Unicode, EntryPoint="StCam_GetPreviewWindowNameW")]
		extern "C" bool GetPreviewWindowNameW(int hCamera, System::Text::StringBuilder* pszWindowName, int lngMaxCount);
		[DllImport("StCamD.dll", CharSet=CharSet::Auto, EntryPoint="StCam_GetPreviewWindowName")]
		extern "C" bool GetPreviewWindowName(int hCamera, System::Text::StringBuilder* pszWindowName, int lngMaxCount);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetPreviewMaskSize")]
		extern "C" bool SetPreviewMaskSize(int hCamera, unsigned int dwOffsetX, unsigned int dwOffsetY, unsigned int dwWidth, unsigned int dwHeight);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetPreviewMaskSize")]
		extern "C" bool GetPreviewMaskSize(int hCamera, unsigned int* pdwOffsetX, unsigned int* pdwOffsetY, unsigned int* pdwWidth, unsigned int* pdwHeight);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetPreviewWindowSize")]
		extern "C" bool SetPreviewWindowSize(int hCamera, int lngPositionX, int lngPositionY, unsigned int dwWidth, unsigned int dwHeight);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetPreviewWindowSize")]
		extern "C" bool GetPreviewWindowSize(int hCamera, int* plngPositionX, int* plngPositionY, unsigned int* pdwWidth, unsigned int* pdwHeight);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetPreviewWindowStyle")]
		extern "C" bool SetPreviewWindowStyle(int hCamera, unsigned int dwStyle);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetPreviewWindowStyle")]
		extern "C" bool GetPreviewWindowStyle(int hCamera, unsigned int* pdwStyle);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetAspectMode")]
		extern "C" bool SetAspectMode(int hCamera, unsigned char byteAspectMode);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetAspectMode")]
		extern "C" bool GetAspectMode(int hCamera, unsigned char* pbyteAspectMode);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetPreviewDestSize")]
		extern "C" bool SetPreviewDestSize(int hCamera, unsigned int dwOffsetX, unsigned int dwOffsetY, unsigned int dwWidth, unsigned int dwHeight);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetPreviewDestSize")]
		extern "C" bool GetPreviewDestSize(int hCamera, unsigned int* pdwOffsetX, unsigned int* pdwOffsetY, unsigned int* pdwWidth, unsigned int* pdwHeight);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetMagnificationMode")]
		extern "C" bool SetMagnificationMode(int hCamera, unsigned char byteMagnificationMode);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetMagnificationMode")]
		extern "C" bool GetMagnificationMode(int hCamera, unsigned char* pbyteMagnificationMode);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetDC")]
		extern "C" bool GetDC(int hCamera, System::IntPtr phDC);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetDCWithReset")]
		extern "C" bool GetDCWithReset(int hCamera, System::IntPtr phDC);
		[DllImport("StCamD.dll", EntryPoint="StCam_ReleaseDC")]
		extern "C" bool ReleaseDC(int hCamera, System::IntPtr hDC);
		[DllImport("StCamD.dll", EntryPoint="StCam_ResetOverlay")]
		extern "C" bool ResetOverlay(int hCamera);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetColorKey")]
		extern "C" bool SetColorKey(int hCamera, unsigned int dwColorKey);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetColorKey")]
		extern "C" bool GetColorKey(int hCamera, unsigned int* pdwColorKey);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetDisplayMode")]
		extern "C" bool SetDisplayMode(int hCamera, unsigned char byteDisplayMode);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetDisplayMode")]
		extern "C" bool GetDisplayMode(int hCamera, unsigned char* pbyteDisplayMode);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetAlphaChannel")]
		extern "C" bool GetAlphaChannel(int hCamera, unsigned char* pbyteAlphaChannel);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetAlphaChannel")]
		extern "C" bool SetAlphaChannel(int hCamera, unsigned char byteAlphaChannel);

		//------------------------------------------------------------------------------
		//Image Acquisition
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", EntryPoint="StCam_TakeRawSnapShot")]
		extern "C" bool TakeRawSnapShot(int hCamera, unsigned char* pbyteBuffer, unsigned int dwBufferSize, unsigned int* pdwNumberOfByteTrans, unsigned int* pdwFrameNo, unsigned int dwMilliseconds);
		[DllImport("StCamD.dll", EntryPoint="StCam_TakePreviewSnapShot")]
		extern "C" bool TakePreviewSnapShot(int hCamera, unsigned char* pbyteBuffer, unsigned int dwBufferSize, unsigned int* pdwNumberOfByteTrans, unsigned int* pdwFrameNo, unsigned int dwMilliseconds);
		[DllImport("StCamD.dll", CharSet=CharSet::Ansi, EntryPoint="StCam_SaveImageA")]
		extern "C" bool SaveImageA(int hCamera, unsigned int dwWidth, unsigned int dwHeight, unsigned int dwPreviewPixelFormat, unsigned char* pbyteData, String* pszFileName, unsigned int dwParam);
		[DllImport("StCamD.dll", CharSet=CharSet::Unicode, EntryPoint="StCam_SaveImageW")]
		extern "C" bool SaveImageW(int hCamera, unsigned int dwWidth, unsigned int dwHeight, unsigned int dwPreviewPixelFormat, unsigned char* pbyteData, String* pszFileName, unsigned int dwParam);
		[DllImport("StCamD.dll", CharSet=CharSet::Auto, EntryPoint="StCam_SaveImage")]
		extern "C" bool SaveImage(int hCamera, unsigned int dwWidth, unsigned int dwHeight, unsigned int dwPreviewPixelFormat, unsigned char* pbyteData, String* pszFileName, unsigned int dwParam);

		//------------------------------------------------------------------------------
		//Shutter Gain Control
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", EntryPoint="StCam_SetShutterSpeed")]
		extern "C" bool SetShutterSpeed(int hCamera, unsigned short wShutterLine, unsigned short wShutterClock);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetShutterSpeed")]
		extern "C" bool GetShutterSpeed(int hCamera, unsigned short* pwShutterLine, unsigned short* pwShutterClock);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetGain")]
		extern "C" bool SetGain(int hCamera, unsigned short wGain);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetGain")]
		extern "C" bool GetGain(int hCamera, unsigned short* pwGain);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetALCMode")]
		extern "C" bool SetALCMode(int hCamera, unsigned char byteAlcMode);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetALCMode")]
		extern "C" bool GetALCMode(int hCamera, unsigned char* pbyteAlcMode);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetTargetBrightness")]
		extern "C" bool SetTargetBrightness(int hCamera, unsigned char byteTargetBrightness, unsigned char byteTolerance, unsigned char byteThreshold);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetTargetBrightness")]
		extern "C" bool GetTargetBrightness(int hCamera, unsigned char* pbyteTargetBrightness, unsigned char* pbyteTolerance, unsigned char* pbyteThreshold);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetALCWeight")]
		extern "C" bool SetALCWeight(int hCamera, unsigned char* pbyteALCWeight);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetALCWeight")]
		extern "C" bool GetALCWeight(int hCamera, unsigned char* pbyteALCWeight);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetShutterControlRange")]
		extern "C" bool SetShutterControlRange(int hCamera, unsigned short wMinShutterLine, unsigned short wMinShutterClock, unsigned short wMaxShutterLine, unsigned short wMaxShutterClock);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetShutterControlRange")]
		extern "C" bool GetShutterControlRange(int hCamera, unsigned short* pwMinShutterLine, unsigned short* pwMinShutterClock, unsigned short* pwMaxShutterLine, unsigned short* pwMaxShutterClock);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetGainControlRange")]
		extern "C" bool SetGainControlRange(int hCamera, unsigned short wMinGain, unsigned short wMaxGain);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetGainControlRange")]
		extern "C" bool GetGainControlRange(int hCamera, unsigned short* pwMinGain, unsigned short* pwMaxGain);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetALCControlSpeed")]
		extern "C" bool SetALCControlSpeed(int hCamera, unsigned char byteShutterCtrlSpeedLimit, unsigned char byteGainCtrlSpeedLimit, unsigned char byteSkipFrameCount, unsigned char byteAverageFrameCount);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetALCControlSpeed")]
		extern "C" bool GetALCControlSpeed(int hCamera, unsigned char* pbyteShutterCtrlSpeedLimit, unsigned char* pbyteGainCtrlSpeedLimit, unsigned char* pbyteSkipFrameCount, unsigned char* pbyteAverageFrameCount);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetDigitalGain")]
		extern "C" bool SetDigitalGain(int hCamera, unsigned short wDigitalGain);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetDigitalGain")]
		extern "C" bool GetDigitalGain(int hCamera, unsigned short* pwDigitalGain);

		//------------------------------------------------------------------------------
		//White Balance Control
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", EntryPoint="StCam_SetWhiteBalanceMode")]
		extern "C" bool SetWhiteBalanceMode(int hCamera, unsigned char byteWBMode);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetWhiteBalanceMode")]
		extern "C" bool GetWhiteBalanceMode(int hCamera, unsigned char* pbyteWBMode);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetWhiteBalanceGain")]
		extern "C" bool SetWhiteBalanceGain(int hCamera, unsigned short wWBGainR, unsigned short wWBGainGr, unsigned short wWBGainGb, unsigned short wWBGainB);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetWhiteBalanceGain")]
		extern "C" bool GetWhiteBalanceGain(int hCamera, unsigned short* pwWBGainR, unsigned short* pwWBGainGr, unsigned short* pwWBGainGb, unsigned short* pwWBGainB);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetWhiteBalanceTarget")]
		extern "C" bool SetWhiteBalanceTarget(int hCamera, unsigned short wAWBTargetR, unsigned short wAWBTargetB);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetWhiteBalanceTarget")]
		extern "C" bool GetWhiteBalanceTarget(int hCamera, unsigned short* pwAWBTargetR, unsigned short* pwAWBTargetB);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetWhiteBalanceToleranceThreshold")]
		extern "C" bool SetWhiteBalanceToleranceThreshold(int hCamera, unsigned short wAWBTolerance, unsigned short wAWBThreshold);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetWhiteBalanceToleranceThreshold")]
		extern "C" bool GetWhiteBalanceToleranceThreshold(int hCamera, unsigned short* pwAWBTolerance, unsigned short* pwAWBThreshold);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetAWBWeight")]
		extern "C" bool SetAWBWeight(int hCamera, unsigned char* pbyteAWBWeight);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetAWBWeight")]
		extern "C" bool GetAWBWeight(int hCamera, unsigned char* pbyteAWBWeight);
		[DllImport("StCamD.dll", EntryPoint="StCam_RawWhiteBalance")]
		extern "C" bool RawWhiteBalance(int hCamera, unsigned int dwWidth, unsigned int dwHeight, unsigned short wColorArray, unsigned char* pbyteRaw);

		//------------------------------------------------------------------------------
		//Gamma
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", EntryPoint="StCam_SetGammaMode")]
		extern "C" bool SetGammaMode(int hCamera, unsigned char byteGammaTarget, unsigned char byteGammaMode, unsigned short wGamma, unsigned char* pbyteGammaTable);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetGammaMode")]
		extern "C" bool GetGammaMode(int hCamera, unsigned char byteGammaTarget, unsigned char* pbyteGammaMode, unsigned short* pwGamma, unsigned char* pbyteGammaTable);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetGammaModeEx")]
		extern "C" bool SetGammaModeEx(int hCamera, unsigned char byteGammaTarget, unsigned char byteGammaMode, unsigned short wGamma, short shtBrightness, unsigned char byteContrast, unsigned char* pbyteGammaTable);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetGammaModeEx")]
		extern "C" bool GetGammaModeEx(int hCamera, unsigned char byteGammaTarget, unsigned char* pbyteGammaMode, unsigned short* pwGamma, short* pshtBrightness, unsigned char* pbyteContrast, unsigned char* pbyteGammaTable);

		//------------------------------------------------------------------------------
		//Sharpness
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", EntryPoint="StCam_SetSharpnessMode")]
		extern "C" bool SetSharpnessMode(int hCamera, unsigned char byteSharpnessMode, unsigned short wSharpnessGain, unsigned char byteSharpnessCoring);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetSharpnessMode")]
		extern "C" bool GetSharpnessMode(int hCamera, unsigned char* pbyteSharpnessMode, unsigned short* pwSharpnessGain, unsigned char* pbyteSharpnessCoring);

		//------------------------------------------------------------------------------
		//Hue Saturation
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", EntryPoint="StCam_SetHueSaturationMode")]
		extern "C" bool SetHueSaturationMode(int hCamera, unsigned char byteHueSaturationMode, short shtHue, unsigned short wSaturation);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetHueSaturationMode")]
		extern "C" bool GetHueSaturationMode(int hCamera, unsigned char* pbyteHueSaturationMode, short* pshtHue, unsigned short* pwSaturation);

		//------------------------------------------------------------------------------
		//Color Matrix
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", EntryPoint="StCam_SetColorMatrix")]
		extern "C" bool SetColorMatrix(int hCamera, unsigned char byteColorMatrixMode, short* pshtColorMatrix);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetColorMatrix")]
		extern "C" bool GetColorMatrix(int hCamera, unsigned char* pbyteColorMatrixMode, short* pshtColorMatrix);

		//------------------------------------------------------------------------------
		//Mirro Rotation
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", EntryPoint="StCam_SetMirrorMode")]
		extern "C" bool SetMirrorMode(int hCamera, unsigned char byteMirrorMode);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetMirrorMode")]
		extern "C" bool GetMirrorMode(int hCamera, unsigned char* pbyteMirrorMode);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetRotationMode")]
		extern "C" bool SetRotationMode(int hCamera, unsigned char byteRotationMode);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetRotationMode")]
		extern "C" bool GetRotationMode(int hCamera, unsigned char* pbyteRotationMode);

		//------------------------------------------------------------------------------
		//Movie
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", CharSet=CharSet::Ansi, EntryPoint="StCam_SaveAVIA")]
		extern "C" bool SaveAVIA(int hCamera, String* pszFileName, unsigned int dwCompressor, unsigned int dwLength, void* lpReserved);
		[DllImport("StCamD.dll", CharSet=CharSet::Unicode, EntryPoint="StCam_SaveAVIW")]
		extern "C" bool SaveAVIW(int hCamera, String* pszFileName, unsigned int dwCompressor, unsigned int dwLength, void* lpReserved);
		[DllImport("StCamD.dll", CharSet=CharSet::Auto, EntryPoint="StCam_SaveAVI")]
		extern "C" bool SaveAVI(int hCamera, String* pszFileName, unsigned int dwCompressor, unsigned int dwLength, void* lpReserved);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetAVIStatus")]
		extern "C" bool SetAVIStatus(int hCamera, unsigned char byteAVIStatus);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetAVIStatus")]
		extern "C" bool GetAVIStatus(int hCamera, unsigned char* pbyteAVIStatus, unsigned int* pdwTotalFrameCounts, unsigned int* pdwCurrentFrameCounts);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetAVIQuality")]
		extern "C" bool SetAVIQuality(int hCamera, unsigned int dwQuality);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetAVIQuality")]
		extern "C" bool GetAVIQuality(int hCamera, unsigned int* pdwQuality);

		//------------------------------------------------------------------------------
		//Clock
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", EntryPoint="StCam_SetClock")]
		extern "C" bool SetClock(int hCamera, unsigned int dwClockMode, unsigned int dwClock);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetClock")]
		extern "C" bool GetClock(int hCamera, unsigned int* pdwClockMode, unsigned int* pdwClock);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetEnableClock")]
		extern "C" bool GetEnableClock(int hCamera, unsigned int* pdwEnableClockMode, unsigned int* pdwStandardClock, unsigned int* pdwMinimumClock, unsigned int* pdwMaximumClock);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetFrameClock")]
		extern "C" bool GetFrameClock(int hCamera, unsigned short* pwCurrentLinePerFrame, unsigned short* pwCurrentClockPerLine);

		//------------------------------------------------------------------------------
		//Callback Function
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", EntryPoint="StCam_AddPreviewBitmapCallback")]
		extern "C" bool AddPreviewBitmapCallback(int hCamera, fStCamPreviewBitmapCallbackFunc* pPreviewBitmapCallbackFunc, void* pContext, unsigned int* pdwPreviewBitmapCallbackNo);
		[DllImport("StCamD.dll", EntryPoint="StCam_RemovePreviewBitmapCallback")]
		extern "C" bool RemovePreviewBitmapCallback(int hCamera, unsigned int dwPreviewBitmapCallbackNo);
		[DllImport("StCamD.dll", EntryPoint="StCam_RemoveAllPreviewBitmapCallback")]
		extern "C" bool RemoveAllPreviewBitmapCallback(int hCamera);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetPreviewBitmapCallbackCount")]
		extern "C" bool GetPreviewBitmapCallbackCount(int hCamera, unsigned int* pdwListCount);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetPreviewBitmapCallback")]
		extern "C" bool GetPreviewBitmapCallback(int hCamera, unsigned int dwCallbackIndex, fStCamPreviewBitmapCallbackFunc** ppPreviewBitmapCallbackFunc, unsigned int* pdwCallbackFunctionNo);
		[DllImport("StCamD.dll", EntryPoint="StCam_AddPreviewGDICallback")]
		extern "C" bool AddPreviewGDICallback(int hCamera, fStCamPreviewGDICallbackFunc* pPreviewGDICallbackFunc, void* pContext, unsigned int* pdwPreviewGDICallbackNo);
		[DllImport("StCamD.dll", EntryPoint="StCam_RemovePreviewGDICallback")]
		extern "C" bool RemovePreviewGDICallback(int hCamera, unsigned int dwPreviewGDICallbackNo);
		[DllImport("StCamD.dll", EntryPoint="StCam_RemoveAllPreviewGDICallback")]
		extern "C" bool RemoveAllPreviewGDICallback(int hCamera);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetPreviewGDICallbackCount")]
		extern "C" bool GetPreviewGDICallbackCount(int hCamera, unsigned int* pdwListCount);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetPreviewGDICallback")]
		extern "C" bool GetPreviewGDICallback(int hCamera, unsigned int dwCallbackIndex, fStCamPreviewGDICallbackFunc** ppPreviewGDICallbackFunc, unsigned int* pdwCallbackFunctionNo);
		[DllImport("StCamD.dll", EntryPoint="StCam_AddRawCallback")]
		extern "C" bool AddRawCallback(int hCamera, fStCamRawCallbackFunc* pRawCallbackFunc, void* pContext, unsigned int* pdwRawCallbackNo);
		[DllImport("StCamD.dll", EntryPoint="StCam_RemoveRawCallback")]
		extern "C" bool RemoveRawCallback(int hCamera, unsigned int dwRawCallbackNo);
		[DllImport("StCamD.dll", EntryPoint="StCam_RemoveAllRawCallback")]
		extern "C" bool RemoveAllRawCallback(int hCamera);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetRawCallbackCount")]
		extern "C" bool GetRawCallbackCount(int hCamera, unsigned int* pdwListCount);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetRawCallback")]
		extern "C" bool GetRawCallback(int hCamera, unsigned int dwCallbackIndex, fStCamRawCallbackFunc** ppRawCallbackFunc, unsigned int* pdwCallbackFunctionNo);

		//------------------------------------------------------------------------------
		//Setting
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", CharSet=CharSet::Ansi, EntryPoint="StCam_SaveSettingFileA")]
		extern "C" bool SaveSettingFileA(int hCamera, String* pszFileName);
		[DllImport("StCamD.dll", CharSet=CharSet::Unicode, EntryPoint="StCam_SaveSettingFileW")]
		extern "C" bool SaveSettingFileW(int hCamera, String* pszFileName);
		[DllImport("StCamD.dll", CharSet=CharSet::Auto, EntryPoint="StCam_SaveSettingFile")]
		extern "C" bool SaveSettingFile(int hCamera, String* pszFileName);
		[DllImport("StCamD.dll", CharSet=CharSet::Ansi, EntryPoint="StCam_LoadSettingFileA")]
		extern "C" bool LoadSettingFileA(int hCamera, String* pszFileName);
		[DllImport("StCamD.dll", CharSet=CharSet::Unicode, EntryPoint="StCam_LoadSettingFileW")]
		extern "C" bool LoadSettingFileW(int hCamera, String* pszFileName);
		[DllImport("StCamD.dll", CharSet=CharSet::Auto, EntryPoint="StCam_LoadSettingFile")]
		extern "C" bool LoadSettingFile(int hCamera, String* pszFileName);
		[DllImport("StCamD.dll", EntryPoint="StCam_ResetSetting")]
		extern "C" bool ResetSetting(int hCamera);

		//------------------------------------------------------------------------------
		//EEPROM
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", EntryPoint="StCam_ReadUserMemory")]
		extern "C" bool ReadUserMemory(int hCamera, unsigned char* pbyteBuffer, unsigned short wOffset, unsigned short wLength);
		[DllImport("StCamD.dll", EntryPoint="StCam_WriteUserMemory")]
		extern "C" bool WriteUserMemory(int hCamera, unsigned char* pbyteBuffer, unsigned short wOffset, unsigned short wLength);
		[DllImport("StCamD.dll", CharSet=CharSet::Ansi, EntryPoint="StCam_ReadCameraUserIDA")]
		extern "C" bool ReadCameraUserIDA(int hCamera, unsigned int* pdwCameraID, System::Text::StringBuilder* pszBuffer, unsigned int dwBufferSize);
		[DllImport("StCamD.dll", CharSet=CharSet::Unicode, EntryPoint="StCam_ReadCameraUserIDW")]
		extern "C" bool ReadCameraUserIDW(int hCamera, unsigned int* pdwCameraID, System::Text::StringBuilder* pszBuffer, unsigned int dwBufferSize);
		[DllImport("StCamD.dll", CharSet=CharSet::Auto, EntryPoint="StCam_ReadCameraUserID")]
		extern "C" bool ReadCameraUserID(int hCamera, unsigned int* pdwCameraID, System::Text::StringBuilder* pszBuffer, unsigned int dwBufferSize);
		[DllImport("StCamD.dll", CharSet=CharSet::Ansi, EntryPoint="StCam_WriteCameraUserIDA")]
		extern "C" bool WriteCameraUserIDA(int hCamera, unsigned int dwCameraID, String* pszBuffer, unsigned int dwBufferSize);
		[DllImport("StCamD.dll", CharSet=CharSet::Unicode, EntryPoint="StCam_WriteCameraUserIDW")]
		extern "C" bool WriteCameraUserIDW(int hCamera, unsigned int dwCameraID, String* pszBuffer, unsigned int dwBufferSize);
		[DllImport("StCamD.dll", CharSet=CharSet::Auto, EntryPoint="StCam_WriteCameraUserID")]
		extern "C" bool WriteCameraUserID(int hCamera, unsigned int dwCameraID, String* pszBuffer, unsigned int dwBufferSize);

		//------------------------------------------------------------------------------
		//Version Information
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", EntryPoint="StCam_GetCameraVersion")]
		extern "C" bool GetCameraVersion(int hCamera, unsigned short* pwUSBVendorID, unsigned short* pwUSBProductID, unsigned short* pwFPGAVersion, unsigned short* pwFirmVersion);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetDriverVersion")]
		extern "C" bool GetDriverVersion(int hCamera, unsigned int* pdwFileVersionMS, unsigned int* pdwFileVersionLS, unsigned int* pdwProductVersionMS, unsigned int* pdwProductVersionLS);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetUSBDllVersion")]
		extern "C" bool GetUSBDllVersion(unsigned int* pdwFileVersionMS, unsigned int* pdwFileVersionLS, unsigned int* pdwProductVersionMS, unsigned int* pdwProductVersionLS);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetCAMDllVersion")]
		extern "C" bool GetCAMDllVersion(unsigned int* pdwFileVersionMS, unsigned int* pdwFileVersionLS, unsigned int* pdwProductVersionMS, unsigned int* pdwProductVersionLS);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetUSBFunctionAddress")]
		extern "C" bool GetUSBFunctionAddress(int hCamera, unsigned char* pbyteUSBFunctionAddress);

		//------------------------------------------------------------------------------
		//Other
		//------------------------------------------------------------------------------
		[DllImport("StCamD.dll", EntryPoint="StCam_ConvertBitmapBGR24ToRGB24")]
		extern "C" bool ConvertBitmapBGR24ToRGB24(int hCamera, unsigned int dwWidth, unsigned int dwHeight, unsigned char* pbyteBitmap);
		[DllImport("StCamD.dll", EntryPoint="StCam_ConvertRawToBGR")]
		extern "C" bool ConvertRawToBGR(int hCamera, unsigned int dwWidth, unsigned int dwHeight, unsigned char* pbyteSrcRaw, unsigned char* pbyteDstBGR, unsigned char byteColorInterpolationMethod, unsigned int dwPreviewPixelFormat);
		[DllImport("StCamD.dll", EntryPoint="StCam_SetControlArea")]
		extern "C" bool SetControlArea(int hCamera, unsigned short* pwSepalateX, unsigned short* pwSepalateY);
		[DllImport("StCamD.dll", EntryPoint="StCam_GetControlArea")]
		extern "C" bool GetControlArea(int hCamera, unsigned short* pwSepalateX, unsigned short* pwSepalateY);
		//------------------------------------------------------------------------------
		//Const
		//------------------------------------------------------------------------------

		//------------------------------------------------------------------------------
		//ERROR_STCAM
		//------------------------------------------------------------------------------
		const unsigned int ERRST_NOT_FOUND_CAMERA = 0xE0000001;
		const unsigned int ERRST_ALL_CAMARA_OPENED = 0xE0000002;
		const unsigned int ERRST_INVALID_CAMERA_HANDLE = 0xE0000003;
		const unsigned int ERRST_INVALID_FUNCTION_RECEIVING = 0xE0000004;
		const unsigned int ERRST_USB_COMMAND_TRANSFER = 0xE0000005;
		const unsigned int ERRST_WINDOW_ALREADY_EXISTS = 0xE0000006;
		const unsigned int ERRST_WINDOW_DOES_NOT_EXISTS = 0xE0000007;
		const unsigned int ERRST_INVALID_FUNCTION_RECORDING = 0xE0000008;
		const unsigned int ERRST_AVI_STREAM = 0xE0000009;
		const unsigned int ERRST_AVI_NOCOMPRESSOR = 0xE000000A;
		const unsigned int ERRST_AVI_UNSUPPORTED = 0xE000000B;
		const unsigned int ERRST_AVI_DISK = 0xE000000C;
		const unsigned int ERRST_AVI_CANCELED = 0xE000000D;
		const unsigned int ERRST_AVI_WRITE = 0xE000000E;
		const unsigned int ERRST_INVALID_FILE_NAME = 0xE000000F;
		const unsigned int ERRST_FILE_OPEN = 0xE0000010;
		const unsigned int ERRST_FILE_WRITE = 0xE0000011;
		const unsigned int ERRST_NOT_SUPPORTED_FUNCTION = 0xE0000021;

		//------------------------------------------------------------------------------
		//WM_STCAM
		//------------------------------------------------------------------------------
		const int WM_STCAM_TRANSFER_START = 0xB001;
		const int WM_STCAM_TRANSFER_FINISH = 0xB002;
		const int WM_STCAM_PREVIEW_WINDOW_CREATE = 0xB003;
		const int WM_STCAM_PREVIEW_WINDOW_CLOSE = 0xB004;
		const int WM_STCAM_PREVIEW_WINDOW_RESIZE = 0xB005;
		const int WM_STCAM_PREVIEW_MASK_RESIZE = 0xB006;
		const int WM_STCAM_PREVIEW_DEST_RESIZE = 0xB007;
		const int WM_STCAM_AVI_FILE_START = 0xB008;
		const int WM_STCAM_AVI_FILE_FINISH = 0xB009;
		const int WM_STCAM_PREVIEW_MENU_COMMAND = 0xB00A;

		//------------------------------------------------------------------------------
		//COLOR_ARRAY
		//------------------------------------------------------------------------------
		const unsigned short STCAM_COLOR_ARRAY_MONO = 0x0001;
		const unsigned short STCAM_COLOR_ARRAY_RGGB = 0x0002;
		const unsigned short STCAM_COLOR_ARRAY_GRBG = 0x0003;
		const unsigned short STCAM_COLOR_ARRAY_GBRG = 0x0004;
		const unsigned short STCAM_COLOR_ARRAY_BGGR = 0x0005;

		//------------------------------------------------------------------------------
		//TRANSER_BITS_PER_PIXEL
		//------------------------------------------------------------------------------
		const unsigned int STCAM_TRANSER_BITS_PER_PIXEL_08 = 0x00000001;
		const unsigned int STCAM_TRANSER_BITS_PER_PIXEL_16 = 0x00000002;

		//------------------------------------------------------------------------------
		//IMAGE_SIZE_MODE
		//------------------------------------------------------------------------------
		const unsigned int STCAM_IMAGE_SIZE_MODE_CUSTOM = 0x00000001;
		const unsigned int STCAM_IMAGE_SIZE_MODE_VGA = 0x00000008;
		const unsigned int STCAM_IMAGE_SIZE_MODE_XGA = 0x00000020;
		const unsigned int STCAM_IMAGE_SIZE_MODE_QUAD_VGA = 0x00000080;
		const unsigned int STCAM_IMAGE_SIZE_MODE_SXGA = 0x00000100;
		const unsigned int STCAM_IMAGE_SIZE_MODE_UXGA = 0x00000400;

		//------------------------------------------------------------------------------
		//SCAN_MODE
		//------------------------------------------------------------------------------
		const unsigned short STCAM_SCAN_MODE_NORMAL = 0x0000;
		const unsigned short STCAM_SCAN_MODE_PARTIAL_2 = 0x0001;
		const unsigned short STCAM_SCAN_MODE_PARTIAL_4 = 0x0002;
		const unsigned short STCAM_SCAN_MODE_PARTIAL_1 = 0x0004;
		const unsigned short STCAM_SCAN_MODE_VARIABLE_PARTIAL = 0x0008;
		const unsigned short STCAM_SCAN_MODE_BINNING = 0x0010;
		const unsigned short STCAM_SCAN_MODE_BINNING_PARTIAL_1 = 0x0020;
		const unsigned short STCAM_SCAN_MODE_BINNING_PARTIAL_2 = 0x0040;
		const unsigned short STCAM_SCAN_MODE_BINNING_PARTIAL_4 = 0x0080;
		const unsigned short STCAM_SCAN_MODE_BINNING_VARIABLE_PARTIAL = 0x0100;

		//------------------------------------------------------------------------------
		//PIXEL_FORMAT
		//------------------------------------------------------------------------------
		const unsigned int STCAM_PIXEL_FORMAT_08_MONO_OR_RAW = 0x00000001;
		const unsigned int STCAM_PIXEL_FORMAT_24_BGR = 0x00000004;
		const unsigned int STCAM_PIXEL_FORMAT_32_BGR = 0x00000008;

		//------------------------------------------------------------------------------
		//COLOR_INTERPOLATION
		//------------------------------------------------------------------------------
		const unsigned char STCAM_COLOR_INTERPOLATION_NONE_MONO = 0;
		const unsigned char STCAM_COLOR_INTERPOLATION_NONE_COLOR = 1;
		const unsigned char STCAM_COLOR_INTERPOLATION_NEAREST_NEIGHBOR = 2;
		const unsigned char STCAM_COLOR_INTERPOLATION_BILINEAR = 3;
		const unsigned char STCAM_COLOR_INTERPOLATION_BILINEAR_FALSE_COLOR_REDUCTION = 5;
		const unsigned char STCAM_COLOR_INTERPOLATION_BICUBIC = 4;

		//------------------------------------------------------------------------------
		//ASPECT
		//------------------------------------------------------------------------------
		const unsigned char STCAM_ASPECT_MODE_FIXED = 0;
		const unsigned char STCAM_ASPECT_MODE_KEEP_ASPECT = 1;
		const unsigned char STCAM_ASPECT_MODE_ADJUST_WINDOW = 2;
		const unsigned char STCAM_ASPECT_MODE_MASK_SIZE = 3;
		const unsigned char STCAM_ASPECT_MODE_CUSTOM_OFFSET = 254;
		const unsigned char STCAM_ASPECT_MODE_CUSTOM = 255;
		const unsigned char STCAM_ASPECT_MODE_CUSTOM_CENTER = 255;

		//------------------------------------------------------------------------------
		//MAGNIFICATION
		//------------------------------------------------------------------------------
		const unsigned char STCAM_MAGNIFICATION_MODE_OFF = 0;
		const unsigned char STCAM_MAGNIFICATION_MODE_ON = 1;

		//------------------------------------------------------------------------------
		//ALCMODE
		//------------------------------------------------------------------------------
		const unsigned char STCAM_ALCMODE_FIXED_SHUTTER_AGC_OFF = 0;
		const unsigned char STCAM_ALCMODE_AUTO_SHUTTER_ON_AGC_ON = 1;
		const unsigned char STCAM_ALCMODE_AUTO_SHUTTER_ON_AGC_OFF = 2;
		const unsigned char STCAM_ALCMODE_FIXED_SHUTTER_AGC_ON = 3;
		const unsigned char STCAM_ALCMODE_AUTO_SHUTTER_AGC_ONESHOT = 4;
		const unsigned char STCAM_ALCMODE_AUTO_SHUTTER_ONESHOT_AGC_OFF = 5;
		const unsigned char STCAM_ALCMODE_FIXED_SHUTTER_AGC_ONESHOT = 6;
		const unsigned char STCAM_ALCMODE_ALC_FIXED_AGC_OFF = 0;
		const unsigned char STCAM_ALCMODE_ALC_FULLAUTO_AGC_ON = 1;
		const unsigned char STCAM_ALCMODE_ALC_FULLAUTO_AGC_OFF = 2;
		const unsigned char STCAM_ALCMODE_ALC_FIXED_AGC_ON = 3;
		const unsigned char STCAM_ALCMODE_ALCAGC_ONESHOT = 4;
		const unsigned char STCAM_ALCMODE_ALC_ONESHOT_AGC_OFF = 5;
		const unsigned char STCAM_ALCMODE_ALC_FIXED_AGC_ONESHOT = 6;

		//------------------------------------------------------------------------------
		//WB
		//------------------------------------------------------------------------------
		const unsigned char STCAM_WB_OFF = 0;
		const unsigned char STCAM_WB_MANUAL = 1;
		const unsigned char STCAM_WB_FULLAUTO = 2;
		const unsigned char STCAM_WB_ONESHOT = 3;

		//------------------------------------------------------------------------------
		//GAMMA
		//------------------------------------------------------------------------------
		const unsigned char STCAM_GAMMA_OFF = 0;
		const unsigned char STCAM_GAMMA_ON = 1;
		const unsigned char STCAM_GAMMA_REVERSE = 2;
		const unsigned char STCAM_GAMMA_TABLE = 255;

		//------------------------------------------------------------------------------
		//GAMMA_TARGET
		//------------------------------------------------------------------------------
		const unsigned char STCAM_GAMMA_TARGET_Y = 0;
		const unsigned char STCAM_GAMMA_TARGET_R = 1;
		const unsigned char STCAM_GAMMA_TARGET_GR = 2;
		const unsigned char STCAM_GAMMA_TARGET_GB = 3;
		const unsigned char STCAM_GAMMA_TARGET_B = 4;

		//------------------------------------------------------------------------------
		//SHARPNESS
		//------------------------------------------------------------------------------
		const unsigned char STCAM_SHARPNESS_OFF = 0;
		const unsigned char STCAM_SHARPNESS_ON = 1;

		//------------------------------------------------------------------------------
		//HUE_SATURATION
		//------------------------------------------------------------------------------
		const unsigned char STCAM_HUE_SATURATION_OFF = 0;
		const unsigned char STCAM_HUE_SATURATION_ON = 1;

		//------------------------------------------------------------------------------
		//COLOR_MATRIX
		//------------------------------------------------------------------------------
		const unsigned char STCAM_COLOR_MATRIX_OFF = 0x00;
		const unsigned char STCAM_COLOR_MATRIX_CUSTOM = 0xFF;

		//------------------------------------------------------------------------------
		//MIRROR
		//------------------------------------------------------------------------------
		const unsigned char STCAM_MIRROR_OFF = 0;
		const unsigned char STCAM_MIRROR_HORIZONTAL = 1;
		const unsigned char STCAM_MIRROR_VERTICAL = 2;
		const unsigned char STCAM_MIRROR_HORIZONTAL_VERTICAL = 3;

		//------------------------------------------------------------------------------
		//ROTATION
		//------------------------------------------------------------------------------
		const unsigned char STCAM_ROTATION_OFF = 0;
		const unsigned char STCAM_ROTATION_CLOCKWISE_90 = 1;
		const unsigned char STCAM_ROTATION_COUNTERCLOCKWISE_90 = 2;

		//------------------------------------------------------------------------------
		//AVI_COMPRESSOR
		//------------------------------------------------------------------------------
		const unsigned int STCAM_AVI_COMPRESSOR_UNCOMPRESSED = 0x00000000;
		const unsigned int STCAM_AVI_COMPRESSOR_MJPG = 0x47504A4D;
		const unsigned int STCAM_AVI_COMPRESSOR_MP42 = 0x3234706D;
		const unsigned int STCAM_AVI_COMPRESSOR_MPV4 = 0x3467706D;
		const unsigned int STCAM_AVI_COMPRESSOR_DIALOG_BOX = 0xFFFFFFFF;

		//------------------------------------------------------------------------------
		//CLOCK_MODE
		//------------------------------------------------------------------------------
		const unsigned int STCAM_CLOCK_MODE_NORMAL = 0x00000000;
		const unsigned int STCAM_CLOCK_MODE_DIV_2 = 0x00000001;
		const unsigned int STCAM_CLOCK_MODE_DIV_4 = 0x00000002;
		const unsigned int STCAM_CLOCK_MODE_VGA_90FPS = 0x00000100;
		const unsigned int STCAM_CLOCK_MODE_CUSTOM = 0x80000000;

		//------------------------------------------------------------------------------
		//USBPID
		//------------------------------------------------------------------------------
		const unsigned short STCAM_USBPID_STC_C33USB = 0x0305;
		const unsigned short STCAM_USBPID_STC_B33USB = 0x0705;
		const unsigned short STCAM_USBPID_STC_B83USB = 0x0805;
		const unsigned short STCAM_USBPID_STC_C83USB = 0x0605;
		const unsigned short STCAM_USBPID_STC_TB33USB = 0x0906;
		const unsigned short STCAM_USBPID_STC_TC33USB = 0x1006;
		const unsigned short STCAM_USBPID_STC_TB83USB = 0x1106;
		const unsigned short STCAM_USBPID_STC_TC83USB = 0x1206;
		const unsigned short STCAM_USBPID_STC_TB133USB = 0x0109;
		const unsigned short STCAM_USBPID_STC_TC133USB = 0x0209;
		const unsigned short STCAM_USBPID_STC_TB152USB = 0x1306;
		const unsigned short STCAM_USBPID_STC_TC152USB = 0x1406;
		const unsigned short STCAM_USBPID_STC_TB202USB = 0x1506;
		const unsigned short STCAM_USBPID_STC_TC202USB = 0x1606;

		//------------------------------------------------------------------------------
		//AVI_STATUS
		//------------------------------------------------------------------------------
		const unsigned char STCAM_AVI_STATUS_STOP = 0x00;
		const unsigned char STCAM_AVI_STATUS_START = 0x01;
		const unsigned char STCAM_AVI_STATUS_PAUSE = 0x02;

		//------------------------------------------------------------------------------
		//DISPLAY_MODE
		//------------------------------------------------------------------------------
		const unsigned char STCAM_DISPLAY_MODE_GDI = 0x00;
		const unsigned char STCAM_DISPLAY_MODE_GDI_HALFTONE = 0x08;
		const unsigned char STCAM_DISPLAY_MODE_DD_OFFSCREEN = 0x01;
		const unsigned char STCAM_DISPLAY_MODE_DD_OVERLAY = 0x02;
		const unsigned char STCAM_DISPLAY_MODE_DD_OFFSCREEN_HQ = 0x03;
		const unsigned char STCAM_DISPLAY_MODE_DD_OVERLAY_HQ = 0x04;
		const unsigned char STCAM_DISPLAY_MODE_DIRECTX = 0x05;
		const unsigned char STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON = 0x06;
		const unsigned char STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON2 = 0x07;

		//------------------------------------------------------------------------------
		//WINDOW_STYLE
		//------------------------------------------------------------------------------
		const unsigned int WS_OVERLAPPED = 0x00000000;
		const unsigned int WS_POPUP = 0x80000000;
		const unsigned int WS_CHILD = 0x40000000;
		const unsigned int WS_MINIMIZE = 0x20000000;
		const unsigned int WS_VISIBLE = 0x10000000;
		const unsigned int WS_DISABLED = 0x08000000;
		const unsigned int WS_CLIPSIBLINGS = 0x04000000;
		const unsigned int WS_CLIPCHILDREN = 0x02000000;
		const unsigned int WS_MAXIMIZE = 0x01000000;
		const unsigned int WS_CAPTION = 0x00C00000;
		const unsigned int WS_BORDER = 0x00800000;
		const unsigned int WS_DLGFRAME = 0x00400000;
		const unsigned int WS_VSCROLL = 0x00200000;
		const unsigned int WS_HSCROLL = 0x00100000;
		const unsigned int WS_SYSMENU = 0x00080000;
		const unsigned int WS_THICKFRAME = 0x00040000;
		const unsigned int WS_GROUP = 0x00020000;
		const unsigned int WS_TABSTOP = 0x00010000;
		const unsigned int WS_MINIMIZEBOX = 0x00020000;
		const unsigned int WS_MAXIMIZEBOX = 0x00010000;
		const unsigned int WS_OVERLAPPEDWINDOW = 0x00CF0000;
		const unsigned int WS_POPUPWINDOW = 0x80880000;
		const unsigned int WS_TILED = 0x00000000;
		const unsigned int WS_ICONIC = 0x00020000;
		const unsigned int WS_SIZEBOX = 0x00040000;
		const unsigned int WS_TILEDWINDOW = 0x00CF0000;
		const unsigned int WS_CHILDWINDOW = 0x40000000;
	}
}

