'Created Date:2010/04/16 11:52
Imports System.Runtime.InteropServices
Public Class StCam
	
	'------------------------------------------------------------------------------
	'Initialize
	'------------------------------------------------------------------------------
	Public Declare Function Open Lib "StCamD.dll" Alias "StCam_Open" (ByVal dwInstance As integer) As integer
	Public Declare Sub Close Lib "StCamD.dll" Alias "StCam_Close" (ByVal hCamera As integer)
	Public Declare Function GetLastError Lib "StCamD.dll" Alias "StCam_GetLastError" (ByVal hCamera As integer) As integer
	Public Declare Function CameraCount Lib "StCamD.dll" Alias "StCam_CameraCount" () As integer
	Public Declare Function SetReceiveMsgWindow Lib "StCamD.dll" Alias "StCam_SetReceiveMsgWindow" (ByVal hCamera As integer, ByVal hWnd As integer) As integer
	Public Declare Function GetUSBSpeed Lib "StCamD.dll" Alias "StCam_GetUSBSpeed" (ByVal hCamera As integer, ByRef pbyteUSBSpeed As Byte) As integer
	
	'------------------------------------------------------------------------------
	'Image Information
	'------------------------------------------------------------------------------
	Public Declare Function GetColorArray Lib "StCamD.dll" Alias "StCam_GetColorArray" (ByVal hCamera As integer, ByRef pwColorArray As Short) As integer
	Public Declare Function SetTransferBitsPerPixel Lib "StCamD.dll" Alias "StCam_SetTransferBitsPerPixel" (ByVal hCamera As integer, ByVal dwTransferBitsPerPixel As integer) As integer
	Public Declare Function GetTransferBitsPerPixel Lib "StCamD.dll" Alias "StCam_GetTransferBitsPerPixel" (ByVal hCamera As integer, ByRef pdwTransferBitsPerPixel As integer) As integer
	Public Declare Function GetEnableTransferBitsPerPixel Lib "StCamD.dll" Alias "StCam_GetEnableTransferBitsPerPixel" (ByVal hCamera As integer, ByRef pdwEnableTransferBitsPerPixel As integer) As integer
	Public Declare Function SetImageSize Lib "StCamD.dll" Alias "StCam_SetImageSize" (ByVal hCamera As integer, ByVal dwImageSizeMode As integer, ByVal wScanMode As Short, ByVal dwOffsetX As integer, ByVal dwOffsetY As integer, ByVal dwWidth As integer, ByVal dwHeight As integer) As integer
	Public Declare Function GetImageSize Lib "StCamD.dll" Alias "StCam_GetImageSize" (ByVal hCamera As integer, ByRef pdwImageSizeMode As integer, ByRef pwScanMode As Short, ByRef pdwOffsetX As integer, ByRef pdwOffsetY As integer, ByRef pdwWidth As integer, ByRef pdwHeight As integer) As integer
	Public Declare Function GetEnableImageSize Lib "StCamD.dll" Alias "StCam_GetEnableImageSize" (ByVal hCamera As integer, ByRef pdwEnableImageSizeMode As integer, ByRef pwEnableScanMode As Short) As integer
	
	'------------------------------------------------------------------------------
	'Preview
	'------------------------------------------------------------------------------
	Public Declare Function StartTransfer Lib "StCamD.dll" Alias "StCam_StartTransfer" (ByVal hCamera As integer) As integer
	Public Declare Function StopTransfer Lib "StCamD.dll" Alias "StCam_StopTransfer" (ByVal hCamera As integer) As integer
	Public Declare Function SetPreviewPixelFormat Lib "StCamD.dll" Alias "StCam_SetPreviewPixelFormat" (ByVal hCamera As integer, ByVal dwPreviewPixelFormat As integer) As integer
	Public Declare Function GetPreviewPixelFormat Lib "StCamD.dll" Alias "StCam_GetPreviewPixelFormat" (ByVal hCamera As integer, ByRef pdwPreviewPixelFormat As integer) As integer
	Public Declare Function GetEnablePreviewPixelFormat Lib "StCamD.dll" Alias "StCam_GetEnablePreviewPixelFormat" (ByVal hCamera As integer, ByRef pdwEnablePreviewPixelFormat As integer) As integer
	Public Declare Function SetColorInterpolationMethod Lib "StCamD.dll" Alias "StCam_SetColorInterpolationMethod" (ByVal hCamera As integer, ByVal byteColorInterpolationMethod As Byte) As integer
	Public Declare Function GetColorInterpolationMethod Lib "StCamD.dll" Alias "StCam_GetColorInterpolationMethod" (ByVal hCamera As integer, ByRef pbyteColorInterpolationMethod As Byte) As integer
	Public Declare Function CreatePreviewWindowA Lib "StCamD.dll" Alias "StCam_CreatePreviewWindowA" (ByVal hCamera As integer, ByVal pszWindowName As String, ByVal dwStyle As integer, ByVal lngPositionX As integer, ByVal lngPositionY As integer, ByVal dwWidth As integer, ByVal dwHeight As integer, ByVal hWndParent As integer, ByVal hMenu As integer, ByVal bCloseEnable As integer) As integer
	Public Declare Function CreatePreviewWindowW Lib "StCamD.dll" Alias "StCam_CreatePreviewWindowW" (ByVal hCamera As integer, ByVal pszWindowName As String, ByVal dwStyle As integer, ByVal lngPositionX As integer, ByVal lngPositionY As integer, ByVal dwWidth As integer, ByVal dwHeight As integer, ByVal hWndParent As integer, ByVal hMenu As integer, ByVal bCloseEnable As integer) As integer
	Public Declare Auto Function CreatePreviewWindow Lib "StCamD.dll" Alias "StCam_CreatePreviewWindow" (ByVal hCamera As integer, ByVal pszWindowName As String, ByVal dwStyle As integer, ByVal lngPositionX As integer, ByVal lngPositionY As integer, ByVal dwWidth As integer, ByVal dwHeight As integer, ByVal hWndParent As integer, ByVal hMenu As integer, ByVal bCloseEnable As integer) As integer
	Public Declare Function DestroyPreviewWindow Lib "StCamD.dll" Alias "StCam_DestroyPreviewWindow" (ByVal hCamera As integer) As integer
	Public Declare Function SetPreviewWindowNameA Lib "StCamD.dll" Alias "StCam_SetPreviewWindowNameA" (ByVal hCamera As integer, ByVal pszWindowName As String) As integer
	Public Declare Function GetPreviewWindowNameA Lib "StCamD.dll" Alias "StCam_GetPreviewWindowNameA" (ByVal hCamera As integer, ByVal pszWindowName As String, ByVal lngMaxCount As integer) As integer
	Public Declare Function SetPreviewWindowNameW Lib "StCamD.dll" Alias "StCam_SetPreviewWindowNameW" (ByVal hCamera As integer, ByVal pszWindowName As String) As integer
	Public Declare Auto Function SetPreviewWindowName Lib "StCamD.dll" Alias "StCam_SetPreviewWindowName" (ByVal hCamera As integer, ByVal pszWindowName As String) As integer
	Public Declare Function GetPreviewWindowNameW Lib "StCamD.dll" Alias "StCam_GetPreviewWindowNameW" (ByVal hCamera As integer, ByVal pszWindowName As String, ByVal lngMaxCount As integer) As integer
	Public Declare Auto Function GetPreviewWindowName Lib "StCamD.dll" Alias "StCam_GetPreviewWindowName" (ByVal hCamera As integer, ByVal pszWindowName As String, ByVal lngMaxCount As integer) As integer
	Public Declare Function SetPreviewMaskSize Lib "StCamD.dll" Alias "StCam_SetPreviewMaskSize" (ByVal hCamera As integer, ByVal dwOffsetX As integer, ByVal dwOffsetY As integer, ByVal dwWidth As integer, ByVal dwHeight As integer) As integer
	Public Declare Function GetPreviewMaskSize Lib "StCamD.dll" Alias "StCam_GetPreviewMaskSize" (ByVal hCamera As integer, ByRef pdwOffsetX As integer, ByRef pdwOffsetY As integer, ByRef pdwWidth As integer, ByRef pdwHeight As integer) As integer
	Public Declare Function SetPreviewWindowSize Lib "StCamD.dll" Alias "StCam_SetPreviewWindowSize" (ByVal hCamera As integer, ByVal lngPositionX As integer, ByVal lngPositionY As integer, ByVal dwWidth As integer, ByVal dwHeight As integer) As integer
	Public Declare Function GetPreviewWindowSize Lib "StCamD.dll" Alias "StCam_GetPreviewWindowSize" (ByVal hCamera As integer, ByRef plngPositionX As integer, ByRef plngPositionY As integer, ByRef pdwWidth As integer, ByRef pdwHeight As integer) As integer
	Public Declare Function SetPreviewWindowStyle Lib "StCamD.dll" Alias "StCam_SetPreviewWindowStyle" (ByVal hCamera As integer, ByVal dwStyle As integer) As integer
	Public Declare Function GetPreviewWindowStyle Lib "StCamD.dll" Alias "StCam_GetPreviewWindowStyle" (ByVal hCamera As integer, ByRef pdwStyle As integer) As integer
	Public Declare Function SetAspectMode Lib "StCamD.dll" Alias "StCam_SetAspectMode" (ByVal hCamera As integer, ByVal byteAspectMode As Byte) As integer
	Public Declare Function GetAspectMode Lib "StCamD.dll" Alias "StCam_GetAspectMode" (ByVal hCamera As integer, ByRef pbyteAspectMode As Byte) As integer
	Public Declare Function SetPreviewDestSize Lib "StCamD.dll" Alias "StCam_SetPreviewDestSize" (ByVal hCamera As integer, ByVal dwOffsetX As integer, ByVal dwOffsetY As integer, ByVal dwWidth As integer, ByVal dwHeight As integer) As integer
	Public Declare Function GetPreviewDestSize Lib "StCamD.dll" Alias "StCam_GetPreviewDestSize" (ByVal hCamera As integer, ByRef pdwOffsetX As integer, ByRef pdwOffsetY As integer, ByRef pdwWidth As integer, ByRef pdwHeight As integer) As integer
	Public Declare Function SetMagnificationMode Lib "StCamD.dll" Alias "StCam_SetMagnificationMode" (ByVal hCamera As integer, ByVal byteMagnificationMode As Byte) As integer
	Public Declare Function GetMagnificationMode Lib "StCamD.dll" Alias "StCam_GetMagnificationMode" (ByVal hCamera As integer, ByRef pbyteMagnificationMode As Byte) As integer
	Public Declare Function GetDCWithReset Lib "StCamD.dll" Alias "StCam_GetDCWithReset" (ByVal hCamera As integer, ByRef phDC As integer) As integer
	Public Declare Function GetDC Lib "StCamD.dll" Alias "StCam_GetDC" (ByVal hCamera As integer, ByRef phDC As integer) As integer
	Public Declare Function ReleaseDC Lib "StCamD.dll" Alias "StCam_ReleaseDC" (ByVal hCamera As integer, ByVal hDC As integer) As integer
	Public Declare Function ResetOverlay Lib "StCamD.dll" Alias "StCam_ResetOverlay" (ByVal hCamera As integer) As integer
	Public Declare Function SetColorKey Lib "StCamD.dll" Alias "StCam_SetColorKey" (ByVal hCamera As integer, ByVal dwColorKey As integer) As integer
	Public Declare Function GetColorKey Lib "StCamD.dll" Alias "StCam_GetColorKey" (ByVal hCamera As integer, ByRef pdwColorKey As integer) As integer
	Public Declare Function SetDisplayMode Lib "StCamD.dll" Alias "StCam_SetDisplayMode" (ByVal hCamera As integer, ByVal byteDisplayMode As Byte) As integer
	Public Declare Function GetDisplayMode Lib "StCamD.dll" Alias "StCam_GetDisplayMode" (ByVal hCamera As integer, ByRef pbyteDisplayMode As Byte) As integer
	Public Declare Function GetAlphaChannel Lib "StCamD.dll" Alias "StCam_GetAlphaChannel" (ByVal hCamera As integer, ByRef pbyteAlphaChannel As Byte) As integer
	Public Declare Function SetAlphaChannel Lib "StCamD.dll" Alias "StCam_SetAlphaChannel" (ByVal hCamera As integer, ByVal byteAlphaChannel As Byte) As integer
	
	'------------------------------------------------------------------------------
	'Image Acquisition
	'------------------------------------------------------------------------------
	Public Declare Function TakeRawSnapShot Lib "StCamD.dll" Alias "StCam_TakeRawSnapShot" (ByVal hCamera As integer, ByRef pbyteBuffer As Byte, ByVal dwBufferSize As integer, ByRef pdwNumberOfByteTrans As integer, ByRef pdwFrameNo As integer, ByVal dwMilliseconds As integer) As integer
	Public Declare Function TakePreviewSnapShot Lib "StCamD.dll" Alias "StCam_TakePreviewSnapShot" (ByVal hCamera As integer, ByRef pbyteBuffer As Byte, ByVal dwBufferSize As integer, ByRef pdwNumberOfByteTrans As integer, ByRef pdwFrameNo As integer, ByVal dwMilliseconds As integer) As integer
	Public Declare Function SaveImageA Lib "StCamD.dll" Alias "StCam_SaveImageA" (ByVal hCamera As integer, ByVal dwWidth As integer, ByVal dwHeight As integer, ByVal dwPreviewPixelFormat As integer, ByRef pbyteData As Byte, ByVal pszFileName As String, ByVal dwParam As integer) As integer
	Public Declare Function SaveImageW Lib "StCamD.dll" Alias "StCam_SaveImageW" (ByVal hCamera As integer, ByVal dwWidth As integer, ByVal dwHeight As integer, ByVal dwPreviewPixelFormat As integer, ByRef pbyteData As Byte, ByVal pszFileName As String, ByVal dwParam As integer) As integer
	Public Declare Auto Function SaveImage Lib "StCamD.dll" Alias "StCam_SaveImage" (ByVal hCamera As integer, ByVal dwWidth As integer, ByVal dwHeight As integer, ByVal dwPreviewPixelFormat As integer, ByRef pbyteData As Byte, ByVal pszFileName As String, ByVal dwParam As integer) As integer
	
	'------------------------------------------------------------------------------
	'Shutter Gain Control
	'------------------------------------------------------------------------------
	Public Declare Function SetShutterSpeed Lib "StCamD.dll" Alias "StCam_SetShutterSpeed" (ByVal hCamera As integer, ByVal wShutterLine As Short, ByVal wShutterClock As Short) As integer
	Public Declare Function GetShutterSpeed Lib "StCamD.dll" Alias "StCam_GetShutterSpeed" (ByVal hCamera As integer, ByRef pwShutterLine As Short, ByRef pwShutterClock As Short) As integer
	Public Declare Function SetGain Lib "StCamD.dll" Alias "StCam_SetGain" (ByVal hCamera As integer, ByVal wGain As Short) As integer
	Public Declare Function GetGain Lib "StCamD.dll" Alias "StCam_GetGain" (ByVal hCamera As integer, ByRef pwGain As Short) As integer
	Public Declare Function SetALCMode Lib "StCamD.dll" Alias "StCam_SetALCMode" (ByVal hCamera As integer, ByVal byteAlcMode As Byte) As integer
	Public Declare Function GetALCMode Lib "StCamD.dll" Alias "StCam_GetALCMode" (ByVal hCamera As integer, ByRef pbyteAlcMode As Byte) As integer
	Public Declare Function SetTargetBrightness Lib "StCamD.dll" Alias "StCam_SetTargetBrightness" (ByVal hCamera As integer, ByVal byteTargetBrightness As Byte, ByVal byteTolerance As Byte, ByVal byteThreshold As Byte) As integer
	Public Declare Function GetTargetBrightness Lib "StCamD.dll" Alias "StCam_GetTargetBrightness" (ByVal hCamera As integer, ByRef pbyteTargetBrightness As Byte, ByRef pbyteTolerance As Byte, ByRef pbyteThreshold As Byte) As integer
	Public Declare Function SetALCWeight Lib "StCamD.dll" Alias "StCam_SetALCWeight" (ByVal hCamera As integer, ByRef pbyteALCWeight As Byte) As integer
	Public Declare Function GetALCWeight Lib "StCamD.dll" Alias "StCam_GetALCWeight" (ByVal hCamera As integer, ByRef pbyteALCWeight As Byte) As integer
	Public Declare Function SetShutterControlRange Lib "StCamD.dll" Alias "StCam_SetShutterControlRange" (ByVal hCamera As integer, ByVal wMinShutterLine As Short, ByVal wMinShutterClock As Short, ByVal wMaxShutterLine As Short, ByVal wMaxShutterClock As Short) As integer
	Public Declare Function GetShutterControlRange Lib "StCamD.dll" Alias "StCam_GetShutterControlRange" (ByVal hCamera As integer, ByRef pwMinShutterLine As Short, ByRef pwMinShutterClock As Short, ByRef pwMaxShutterLine As Short, ByRef pwMaxShutterClock As Short) As integer
	Public Declare Function SetGainControlRange Lib "StCamD.dll" Alias "StCam_SetGainControlRange" (ByVal hCamera As integer, ByVal wMinGain As Short, ByVal wMaxGain As Short) As integer
	Public Declare Function GetGainControlRange Lib "StCamD.dll" Alias "StCam_GetGainControlRange" (ByVal hCamera As integer, ByRef pwMinGain As Short, ByRef pwMaxGain As Short) As integer
	Public Declare Function SetALCControlSpeed Lib "StCamD.dll" Alias "StCam_SetALCControlSpeed" (ByVal hCamera As integer, ByVal byteShutterCtrlSpeedLimit As Byte, ByVal byteGainCtrlSpeedLimit As Byte, ByVal byteSkipFrameCount As Byte, ByVal byteAverageFrameCount As Byte) As integer
	Public Declare Function GetALCControlSpeed Lib "StCamD.dll" Alias "StCam_GetALCControlSpeed" (ByVal hCamera As integer, ByRef pbyteShutterCtrlSpeedLimit As Byte, ByRef pbyteGainCtrlSpeedLimit As Byte, ByRef pbyteSkipFrameCount As Byte, ByRef pbyteAverageFrameCount As Byte) As integer
	Public Declare Function SetDigitalGain Lib "StCamD.dll" Alias "StCam_SetDigitalGain" (ByVal hCamera As integer, ByVal wDigitalGain As Short) As integer
	Public Declare Function GetDigitalGain Lib "StCamD.dll" Alias "StCam_GetDigitalGain" (ByVal hCamera As integer, ByRef pwDigitalGain As Short) As integer
	
	'------------------------------------------------------------------------------
	'White Balance Control
	'------------------------------------------------------------------------------
	Public Declare Function SetWhiteBalanceMode Lib "StCamD.dll" Alias "StCam_SetWhiteBalanceMode" (ByVal hCamera As integer, ByVal byteWBMode As Byte) As integer
	Public Declare Function GetWhiteBalanceMode Lib "StCamD.dll" Alias "StCam_GetWhiteBalanceMode" (ByVal hCamera As integer, ByRef pbyteWBMode As Byte) As integer
	Public Declare Function SetWhiteBalanceGain Lib "StCamD.dll" Alias "StCam_SetWhiteBalanceGain" (ByVal hCamera As integer, ByVal wWBGainR As Short, ByVal wWBGainGr As Short, ByVal wWBGainGb As Short, ByVal wWBGainB As Short) As integer
	Public Declare Function GetWhiteBalanceGain Lib "StCamD.dll" Alias "StCam_GetWhiteBalanceGain" (ByVal hCamera As integer, ByRef pwWBGainR As Short, ByRef pwWBGainGr As Short, ByRef pwWBGainGb As Short, ByRef pwWBGainB As Short) As integer
	Public Declare Function SetWhiteBalanceTarget Lib "StCamD.dll" Alias "StCam_SetWhiteBalanceTarget" (ByVal hCamera As integer, ByVal wAWBTargetR As Short, ByVal wAWBTargetB As Short) As integer
	Public Declare Function GetWhiteBalanceTarget Lib "StCamD.dll" Alias "StCam_GetWhiteBalanceTarget" (ByVal hCamera As integer, ByRef pwAWBTargetR As Short, ByRef pwAWBTargetB As Short) As integer
	Public Declare Function SetWhiteBalanceToleranceThreshold Lib "StCamD.dll" Alias "StCam_SetWhiteBalanceToleranceThreshold" (ByVal hCamera As integer, ByVal wAWBTolerance As Short, ByVal wAWBThreshold As Short) As integer
	Public Declare Function GetWhiteBalanceToleranceThreshold Lib "StCamD.dll" Alias "StCam_GetWhiteBalanceToleranceThreshold" (ByVal hCamera As integer, ByRef pwAWBTolerance As Short, ByRef pwAWBThreshold As Short) As integer
	Public Declare Function SetAWBWeight Lib "StCamD.dll" Alias "StCam_SetAWBWeight" (ByVal hCamera As integer, ByRef pbyteAWBWeight As Byte) As integer
	Public Declare Function GetAWBWeight Lib "StCamD.dll" Alias "StCam_GetAWBWeight" (ByVal hCamera As integer, ByRef pbyteAWBWeight As Byte) As integer
	Public Declare Function RawWhiteBalance Lib "StCamD.dll" Alias "StCam_RawWhiteBalance" (ByVal hCamera As integer, ByVal dwWidth As integer, ByVal dwHeight As integer, ByVal wColorArray As Short, ByRef pbyteRaw As Byte) As integer
	
	'------------------------------------------------------------------------------
	'Gamma
	'------------------------------------------------------------------------------
	Public Declare Function SetGammaMode Lib "StCamD.dll" Alias "StCam_SetGammaMode" (ByVal hCamera As integer, ByVal byteGammaTarget As Byte, ByVal byteGammaMode As Byte, ByVal wGamma As Short, ByRef pbyteGammaTable As Byte) As integer
	Public Declare Function GetGammaMode Lib "StCamD.dll" Alias "StCam_GetGammaMode" (ByVal hCamera As integer, ByVal byteGammaTarget As Byte, ByRef pbyteGammaMode As Byte, ByRef pwGamma As Short, ByRef pbyteGammaTable As Byte) As integer
	Public Declare Function SetGammaModeEx Lib "StCamD.dll" Alias "StCam_SetGammaModeEx" (ByVal hCamera As integer, ByVal byteGammaTarget As Byte, ByVal byteGammaMode As Byte, ByVal wGamma As Short, ByVal shtBrightness As Short, ByVal byteContrast As Byte, ByRef pbyteGammaTable As Byte) As integer
	Public Declare Function GetGammaModeEx Lib "StCamD.dll" Alias "StCam_GetGammaModeEx" (ByVal hCamera As integer, ByVal byteGammaTarget As Byte, ByRef pbyteGammaMode As Byte, ByRef pwGamma As Short, ByRef pshtBrightness As Short, ByRef pbyteContrast As Byte, ByRef pbyteGammaTable As Byte) As integer
	
	'------------------------------------------------------------------------------
	'Sharpness
	'------------------------------------------------------------------------------
	Public Declare Function SetSharpnessMode Lib "StCamD.dll" Alias "StCam_SetSharpnessMode" (ByVal hCamera As integer, ByVal byteSharpnessMode As Byte, ByVal wSharpnessGain As Short, ByVal byteSharpnessCoring As Byte) As integer
	Public Declare Function GetSharpnessMode Lib "StCamD.dll" Alias "StCam_GetSharpnessMode" (ByVal hCamera As integer, ByRef pbyteSharpnessMode As Byte, ByRef pwSharpnessGain As Short, ByRef pbyteSharpnessCoring As Byte) As integer
	
	'------------------------------------------------------------------------------
	'Hue Saturation
	'------------------------------------------------------------------------------
	Public Declare Function SetHueSaturationMode Lib "StCamD.dll" Alias "StCam_SetHueSaturationMode" (ByVal hCamera As integer, ByVal byteHueSaturationMode As Byte, ByVal shtHue As Short, ByVal wSaturation As Short) As integer
	Public Declare Function GetHueSaturationMode Lib "StCamD.dll" Alias "StCam_GetHueSaturationMode" (ByVal hCamera As integer, ByRef pbyteHueSaturationMode As Byte, ByRef pshtHue As Short, ByRef pwSaturation As Short) As integer
	
	'------------------------------------------------------------------------------
	'Color Matrix
	'------------------------------------------------------------------------------
	Public Declare Function SetColorMatrix Lib "StCamD.dll" Alias "StCam_SetColorMatrix" (ByVal hCamera As integer, ByVal byteColorMatrixMode As Byte, ByRef pshtColorMatrix As Short) As integer
	Public Declare Function GetColorMatrix Lib "StCamD.dll" Alias "StCam_GetColorMatrix" (ByVal hCamera As integer, ByRef pbyteColorMatrixMode As Byte, ByRef pshtColorMatrix As Short) As integer
	
	'------------------------------------------------------------------------------
	'Mirro Rotation
	'------------------------------------------------------------------------------
	Public Declare Function SetMirrorMode Lib "StCamD.dll" Alias "StCam_SetMirrorMode" (ByVal hCamera As integer, ByVal byteMirrorMode As Byte) As integer
	Public Declare Function GetMirrorMode Lib "StCamD.dll" Alias "StCam_GetMirrorMode" (ByVal hCamera As integer, ByRef pbyteMirrorMode As Byte) As integer
	Public Declare Function SetRotationMode Lib "StCamD.dll" Alias "StCam_SetRotationMode" (ByVal hCamera As integer, ByVal byteRotationMode As Byte) As integer
	Public Declare Function GetRotationMode Lib "StCamD.dll" Alias "StCam_GetRotationMode" (ByVal hCamera As integer, ByRef pbyteRotationMode As Byte) As integer
	
	'------------------------------------------------------------------------------
	'Movie
	'------------------------------------------------------------------------------
	Public Declare Function SaveAVIA Lib "StCamD.dll" Alias "StCam_SaveAVIA" (ByVal hCamera As integer, ByVal pszFileName As String, ByVal dwCompressor As integer, ByVal dwLength As integer, ByVal lpReserved As integer) As integer
	Public Declare Function SaveAVIW Lib "StCamD.dll" Alias "StCam_SaveAVIW" (ByVal hCamera As integer, ByVal pszFileName As String, ByVal dwCompressor As integer, ByVal dwLength As integer, ByVal lpReserved As integer) As integer
	Public Declare Auto Function SaveAVI Lib "StCamD.dll" Alias "StCam_SaveAVI" (ByVal hCamera As integer, ByVal pszFileName As String, ByVal dwCompressor As integer, ByVal dwLength As integer, ByVal lpReserved As integer) As integer
	Public Declare Function SetAVIStatus Lib "StCamD.dll" Alias "StCam_SetAVIStatus" (ByVal hCamera As integer, ByVal byteAVIStatus As Byte) As integer
	Public Declare Function GetAVIStatus Lib "StCamD.dll" Alias "StCam_GetAVIStatus" (ByVal hCamera As integer, ByRef pbyteAVIStatus As Byte, ByRef pdwTotalFrameCounts As integer, ByRef pdwCurrentFrameCounts As integer) As integer
	Public Declare Function SetAVIQuality Lib "StCamD.dll" Alias "StCam_SetAVIQuality" (ByVal hCamera As integer, ByVal dwQuality As integer) As integer
	Public Declare Function GetAVIQuality Lib "StCamD.dll" Alias "StCam_GetAVIQuality" (ByVal hCamera As integer, ByRef pdwQuality As integer) As integer
	
	'------------------------------------------------------------------------------
	'Clock
	'------------------------------------------------------------------------------
	Public Declare Function SetClock Lib "StCamD.dll" Alias "StCam_SetClock" (ByVal hCamera As integer, ByVal dwClockMode As integer, ByVal dwClock As integer) As integer
	Public Declare Function GetClock Lib "StCamD.dll" Alias "StCam_GetClock" (ByVal hCamera As integer, ByRef pdwClockMode As integer, ByRef pdwClock As integer) As integer
	Public Declare Function GetEnableClock Lib "StCamD.dll" Alias "StCam_GetEnableClock" (ByVal hCamera As integer, ByRef pdwEnableClockMode As integer, ByRef pdwStandardClock As integer, ByRef pdwMinimumClock As integer, ByRef pdwMaximumClock As integer) As integer
	Public Declare Function GetFrameClock Lib "StCamD.dll" Alias "StCam_GetFrameClock" (ByVal hCamera As integer, ByRef pwCurrentLinePerFrame As Short, ByRef pwCurrentClockPerLine As Short) As integer
	
	'------------------------------------------------------------------------------
	'Setting
	'------------------------------------------------------------------------------
	Public Declare Function SaveSettingFileA Lib "StCamD.dll" Alias "StCam_SaveSettingFileA" (ByVal hCamera As integer, ByVal pszFileName As String) As integer
	Public Declare Function SaveSettingFileW Lib "StCamD.dll" Alias "StCam_SaveSettingFileW" (ByVal hCamera As integer, ByVal pszFileName As String) As integer
	Public Declare Auto Function SaveSettingFile Lib "StCamD.dll" Alias "StCam_SaveSettingFile" (ByVal hCamera As integer, ByVal pszFileName As String) As integer
	Public Declare Function LoadSettingFileA Lib "StCamD.dll" Alias "StCam_LoadSettingFileA" (ByVal hCamera As integer, ByVal pszFileName As String) As integer
	Public Declare Function LoadSettingFileW Lib "StCamD.dll" Alias "StCam_LoadSettingFileW" (ByVal hCamera As integer, ByVal pszFileName As String) As integer
	Public Declare Auto Function LoadSettingFile Lib "StCamD.dll" Alias "StCam_LoadSettingFile" (ByVal hCamera As integer, ByVal pszFileName As String) As integer
	Public Declare Function ResetSetting Lib "StCamD.dll" Alias "StCam_ResetSetting" (ByVal hCamera As integer) As integer
	
	'------------------------------------------------------------------------------
	'EEPROM
	'------------------------------------------------------------------------------
	Public Declare Function ReadUserMemory Lib "StCamD.dll" Alias "StCam_ReadUserMemory" (ByVal hCamera As integer, ByRef pbyteBuffer As Byte, ByVal wOffset As Short, ByVal wLength As Short) As integer
	Public Declare Function WriteUserMemory Lib "StCamD.dll" Alias "StCam_WriteUserMemory" (ByVal hCamera As integer, ByRef pbyteBuffer As Byte, ByVal wOffset As Short, ByVal wLength As Short) As integer
	Public Declare Function ReadCameraUserIDA Lib "StCamD.dll" Alias "StCam_ReadCameraUserIDA" (ByVal hCamera As integer, ByRef pdwCameraID As integer, ByVal pszBuffer As String, ByVal dwBufferSize As integer) As integer
	Public Declare Function ReadCameraUserIDW Lib "StCamD.dll" Alias "StCam_ReadCameraUserIDW" (ByVal hCamera As integer, ByRef pdwCameraID As integer, ByVal pszBuffer As String, ByVal dwBufferSize As integer) As integer
	Public Declare Auto Function ReadCameraUserID Lib "StCamD.dll" Alias "StCam_ReadCameraUserID" (ByVal hCamera As integer, ByRef pdwCameraID As integer, ByVal pszBuffer As String, ByVal dwBufferSize As integer) As integer
	Public Declare Function WriteCameraUserIDA Lib "StCamD.dll" Alias "StCam_WriteCameraUserIDA" (ByVal hCamera As integer, ByVal dwCameraID As integer, ByVal pszBuffer As String, ByVal dwBufferSize As integer) As integer
	Public Declare Function WriteCameraUserIDW Lib "StCamD.dll" Alias "StCam_WriteCameraUserIDW" (ByVal hCamera As integer, ByVal dwCameraID As integer, ByVal pszBuffer As String, ByVal dwBufferSize As integer) As integer
	Public Declare Auto Function WriteCameraUserID Lib "StCamD.dll" Alias "StCam_WriteCameraUserID" (ByVal hCamera As integer, ByVal dwCameraID As integer, ByVal pszBuffer As String, ByVal dwBufferSize As integer) As integer
	
	'------------------------------------------------------------------------------
	'Version Information
	'------------------------------------------------------------------------------
	Public Declare Function GetCameraVersion Lib "StCamD.dll" Alias "StCam_GetCameraVersion" (ByVal hCamera As integer, ByRef pwUSBVendorID As Short, ByRef pwUSBProductID As Short, ByRef pwFPGAVersion As Short, ByRef pwFirmVersion As Short) As integer
	Public Declare Function GetDriverVersion Lib "StCamD.dll" Alias "StCam_GetDriverVersion" (ByVal hCamera As integer, ByRef pdwFileVersionMS As integer, ByRef pdwFileVersionLS As integer, ByRef pdwProductVersionMS As integer, ByRef pdwProductVersionLS As integer) As integer
	Public Declare Function GetUSBDllVersion Lib "StCamD.dll" Alias "StCam_GetUSBDllVersion" (ByRef pdwFileVersionMS As integer, ByRef pdwFileVersionLS As integer, ByRef pdwProductVersionMS As integer, ByRef pdwProductVersionLS As integer) As integer
	Public Declare Function GetCAMDllVersion Lib "StCamD.dll" Alias "StCam_GetCAMDllVersion" (ByRef pdwFileVersionMS As integer, ByRef pdwFileVersionLS As integer, ByRef pdwProductVersionMS As integer, ByRef pdwProductVersionLS As integer) As integer
	Public Declare Function GetUSBFunctionAddress Lib "StCamD.dll" Alias "StCam_GetUSBFunctionAddress" (ByVal hCamera As integer, ByRef pbyteUSBFunctionAddress As Byte) As integer
	
	'------------------------------------------------------------------------------
	'Debug Only
	'------------------------------------------------------------------------------
	Public Declare Function ReadCameraSerialIDA Lib "StCamD.dll" Alias "StCam_ReadCameraSerialIDA" (ByVal hCamera As integer, ByRef pdwCameraID As integer, ByVal pszBuffer As String, ByVal dwBufferSize As integer) As integer
	
	'------------------------------------------------------------------------------
	'Other
	'------------------------------------------------------------------------------
	Public Declare Function ConvertBitmapBGR24ToRGB24 Lib "StCamD.dll" Alias "StCam_ConvertBitmapBGR24ToRGB24" (ByVal hCamera As integer, ByVal dwWidth As integer, ByVal dwHeight As integer, ByRef pbyteBitmap As Byte) As integer
	Public Declare Function ConvertRawToBGR Lib "StCamD.dll" Alias "StCam_ConvertRawToBGR" (ByVal hCamera As integer, ByVal dwWidth As integer, ByVal dwHeight As integer, ByRef pbyteSrcRaw As Byte, ByRef pbyteDstBGR As Byte, ByVal byteColorInterpolationMethod As Byte, ByVal dwPreviewPixelFormat As integer) As integer
	Public Declare Function SetControlArea Lib "StCamD.dll" Alias "StCam_SetControlArea" (ByVal hCamera As integer, ByRef pwSepalateX As Short, ByRef pwSepalateY As Short) As integer
	Public Declare Function GetControlArea Lib "StCamD.dll" Alias "StCam_GetControlArea" (ByVal hCamera As integer, ByRef pwSepalateX As Short, ByRef pwSepalateY As Short) As integer
	'------------------------------------------------------------------------------
	'ERROR_STCAM
	'------------------------------------------------------------------------------
	Public Const ERRST_NOT_FOUND_CAMERA As integer = &HE0000001
	Public Const ERRST_ALL_CAMARA_OPENED As integer = &HE0000002
	Public Const ERRST_INVALID_CAMERA_HANDLE As integer = &HE0000003
	Public Const ERRST_INVALID_FUNCTION_RECEIVING As integer = &HE0000004
	Public Const ERRST_USB_COMMAND_TRANSFER As integer = &HE0000005
	Public Const ERRST_WINDOW_ALREADY_EXISTS As integer = &HE0000006
	Public Const ERRST_WINDOW_DOES_NOT_EXISTS As integer = &HE0000007
	Public Const ERRST_INVALID_FUNCTION_RECORDING As integer = &HE0000008
	Public Const ERRST_AVI_STREAM As integer = &HE0000009
	Public Const ERRST_AVI_NOCOMPRESSOR As integer = &HE000000A
	Public Const ERRST_AVI_UNSUPPORTED As integer = &HE000000B
	Public Const ERRST_AVI_DISK As integer = &HE000000C
	Public Const ERRST_AVI_CANCELED As integer = &HE000000D
	Public Const ERRST_AVI_WRITE As integer = &HE000000E
	Public Const ERRST_INVALID_FILE_NAME As integer = &HE000000F
	Public Const ERRST_FILE_OPEN As integer = &HE0000010
	Public Const ERRST_FILE_WRITE As integer = &HE0000011
	Public Const ERRST_NOT_SUPPORTED_FUNCTION As integer = &HE0000021
	'------------------------------------------------------------------------------
	'WM_STCAM
	'------------------------------------------------------------------------------
	Public Const WM_STCAM_TRANSFER_START As integer = &HB001
	Public Const WM_STCAM_TRANSFER_FINISH As integer = &HB002
	Public Const WM_STCAM_PREVIEW_WINDOW_CREATE As integer = &HB003
	Public Const WM_STCAM_PREVIEW_WINDOW_CLOSE As integer = &HB004
	Public Const WM_STCAM_PREVIEW_WINDOW_RESIZE As integer = &HB005
	Public Const WM_STCAM_PREVIEW_MASK_RESIZE As integer = &HB006
	Public Const WM_STCAM_PREVIEW_DEST_RESIZE As integer = &HB007
	Public Const WM_STCAM_AVI_FILE_START As integer = &HB008
	Public Const WM_STCAM_AVI_FILE_FINISH As integer = &HB009
	Public Const WM_STCAM_PREVIEW_MENU_COMMAND As integer = &HB00A
	'------------------------------------------------------------------------------
	'COLOR_ARRAY
	'------------------------------------------------------------------------------
	Public Const STCAM_COLOR_ARRAY_MONO As Short = &H0001
	Public Const STCAM_COLOR_ARRAY_RGGB As Short = &H0002
	Public Const STCAM_COLOR_ARRAY_GRBG As Short = &H0003
	Public Const STCAM_COLOR_ARRAY_GBRG As Short = &H0004
	Public Const STCAM_COLOR_ARRAY_BGGR As Short = &H0005
	'------------------------------------------------------------------------------
	'TRANSER_BITS_PER_PIXEL
	'------------------------------------------------------------------------------
	Public Const STCAM_TRANSER_BITS_PER_PIXEL_08 As integer = &H00000001
	Public Const STCAM_TRANSER_BITS_PER_PIXEL_16 As integer = &H00000002
	'------------------------------------------------------------------------------
	'IMAGE_SIZE_MODE
	'------------------------------------------------------------------------------
	Public Const STCAM_IMAGE_SIZE_MODE_CUSTOM As integer = &H00000001
	Public Const STCAM_IMAGE_SIZE_MODE_VGA As integer = &H00000008
	Public Const STCAM_IMAGE_SIZE_MODE_XGA As integer = &H00000020
	Public Const STCAM_IMAGE_SIZE_MODE_QUAD_VGA As integer = &H00000080
	Public Const STCAM_IMAGE_SIZE_MODE_SXGA As integer = &H00000100
	Public Const STCAM_IMAGE_SIZE_MODE_UXGA As integer = &H00000400
	'------------------------------------------------------------------------------
	'SCAN_MODE
	'------------------------------------------------------------------------------
	Public Const STCAM_SCAN_MODE_NORMAL As Short = &H0000
	Public Const STCAM_SCAN_MODE_PARTIAL_2 As Short = &H0001
	Public Const STCAM_SCAN_MODE_PARTIAL_4 As Short = &H0002
	Public Const STCAM_SCAN_MODE_PARTIAL_1 As Short = &H0004
	Public Const STCAM_SCAN_MODE_VARIABLE_PARTIAL As Short = &H0008
	Public Const STCAM_SCAN_MODE_BINNING As Short = &H0010
	Public Const STCAM_SCAN_MODE_BINNING_PARTIAL_1 As Short = &H0020
	Public Const STCAM_SCAN_MODE_BINNING_PARTIAL_2 As Short = &H0040
	Public Const STCAM_SCAN_MODE_BINNING_PARTIAL_4 As Short = &H0080
	Public Const STCAM_SCAN_MODE_BINNING_VARIABLE_PARTIAL As Short = &H0100
	'------------------------------------------------------------------------------
	'PIXEL_FORMAT
	'------------------------------------------------------------------------------
	Public Const STCAM_PIXEL_FORMAT_08_MONO_OR_RAW As integer = &H00000001
	Public Const STCAM_PIXEL_FORMAT_24_BGR As integer = &H00000004
	Public Const STCAM_PIXEL_FORMAT_32_BGR As integer = &H00000008
	'------------------------------------------------------------------------------
	'COLOR_INTERPOLATION
	'------------------------------------------------------------------------------
	Public Const STCAM_COLOR_INTERPOLATION_NONE_MONO As Byte = 0
	Public Const STCAM_COLOR_INTERPOLATION_NONE_COLOR As Byte = 1
	Public Const STCAM_COLOR_INTERPOLATION_NEAREST_NEIGHBOR As Byte = 2
	Public Const STCAM_COLOR_INTERPOLATION_BILINEAR As Byte = 3
	Public Const STCAM_COLOR_INTERPOLATION_BILINEAR_FALSE_COLOR_REDUCTION As Byte = 5
	Public Const STCAM_COLOR_INTERPOLATION_BICUBIC As Byte = 4
	'------------------------------------------------------------------------------
	'ASPECT
	'------------------------------------------------------------------------------
	Public Const STCAM_ASPECT_MODE_FIXED As Byte = 0
	Public Const STCAM_ASPECT_MODE_KEEP_ASPECT As Byte = 1
	Public Const STCAM_ASPECT_MODE_ADJUST_WINDOW As Byte = 2
	Public Const STCAM_ASPECT_MODE_MASK_SIZE As Byte = 3
	Public Const STCAM_ASPECT_MODE_CUSTOM_OFFSET As Byte = 254
	Public Const STCAM_ASPECT_MODE_CUSTOM As Byte = 255
	Public Const STCAM_ASPECT_MODE_CUSTOM_CENTER As Byte = 255
	'------------------------------------------------------------------------------
	'MAGNIFICATION
	'------------------------------------------------------------------------------
	Public Const STCAM_MAGNIFICATION_MODE_OFF As Byte = 0
	Public Const STCAM_MAGNIFICATION_MODE_ON As Byte = 1
	'------------------------------------------------------------------------------
	'ALCMODE
	'------------------------------------------------------------------------------
	Public Const STCAM_ALCMODE_FIXED_SHUTTER_AGC_OFF As Byte = 0
	Public Const STCAM_ALCMODE_AUTO_SHUTTER_ON_AGC_ON As Byte = 1
	Public Const STCAM_ALCMODE_AUTO_SHUTTER_ON_AGC_OFF As Byte = 2
	Public Const STCAM_ALCMODE_FIXED_SHUTTER_AGC_ON As Byte = 3
	Public Const STCAM_ALCMODE_AUTO_SHUTTER_AGC_ONESHOT As Byte = 4
	Public Const STCAM_ALCMODE_AUTO_SHUTTER_ONESHOT_AGC_OFF As Byte = 5
	Public Const STCAM_ALCMODE_FIXED_SHUTTER_AGC_ONESHOT As Byte = 6
	Public Const STCAM_ALCMODE_ALC_FIXED_AGC_OFF As Byte = 0
	Public Const STCAM_ALCMODE_ALC_FULLAUTO_AGC_ON As Byte = 1
	Public Const STCAM_ALCMODE_ALC_FULLAUTO_AGC_OFF As Byte = 2
	Public Const STCAM_ALCMODE_ALC_FIXED_AGC_ON As Byte = 3
	Public Const STCAM_ALCMODE_ALCAGC_ONESHOT As Byte = 4
	Public Const STCAM_ALCMODE_ALC_ONESHOT_AGC_OFF As Byte = 5
	Public Const STCAM_ALCMODE_ALC_FIXED_AGC_ONESHOT As Byte = 6
	'------------------------------------------------------------------------------
	'WB
	'------------------------------------------------------------------------------
	Public Const STCAM_WB_OFF As Byte = 0
	Public Const STCAM_WB_MANUAL As Byte = 1
	Public Const STCAM_WB_FULLAUTO As Byte = 2
	Public Const STCAM_WB_ONESHOT As Byte = 3
	'------------------------------------------------------------------------------
	'GAMMA
	'------------------------------------------------------------------------------
	Public Const STCAM_GAMMA_OFF As Byte = 0
	Public Const STCAM_GAMMA_ON As Byte = 1
	Public Const STCAM_GAMMA_REVERSE As Byte = 2
	Public Const STCAM_GAMMA_TABLE As Byte = 255
	'------------------------------------------------------------------------------
	'GAMMA_TARGET
	'------------------------------------------------------------------------------
	Public Const STCAM_GAMMA_TARGET_Y As Byte = 0
	Public Const STCAM_GAMMA_TARGET_R As Byte = 1
	Public Const STCAM_GAMMA_TARGET_GR As Byte = 2
	Public Const STCAM_GAMMA_TARGET_GB As Byte = 3
	Public Const STCAM_GAMMA_TARGET_B As Byte = 4
	'------------------------------------------------------------------------------
	'SHARPNESS
	'------------------------------------------------------------------------------
	Public Const STCAM_SHARPNESS_OFF As Byte = 0
	Public Const STCAM_SHARPNESS_ON As Byte = 1
	'------------------------------------------------------------------------------
	'HUE_SATURATION
	'------------------------------------------------------------------------------
	Public Const STCAM_HUE_SATURATION_OFF As Byte = 0
	Public Const STCAM_HUE_SATURATION_ON As Byte = 1
	'------------------------------------------------------------------------------
	'COLOR_MATRIX
	'------------------------------------------------------------------------------
	Public Const STCAM_COLOR_MATRIX_OFF As Byte = &H00
	Public Const STCAM_COLOR_MATRIX_CUSTOM As Byte = &HFF
	'------------------------------------------------------------------------------
	'MIRROR
	'------------------------------------------------------------------------------
	Public Const STCAM_MIRROR_OFF As Byte = 0
	Public Const STCAM_MIRROR_HORIZONTAL As Byte = 1
	Public Const STCAM_MIRROR_VERTICAL As Byte = 2
	Public Const STCAM_MIRROR_HORIZONTAL_VERTICAL As Byte = 3
	'------------------------------------------------------------------------------
	'ROTATION
	'------------------------------------------------------------------------------
	Public Const STCAM_ROTATION_OFF As Byte = 0
	Public Const STCAM_ROTATION_CLOCKWISE_90 As Byte = 1
	Public Const STCAM_ROTATION_COUNTERCLOCKWISE_90 As Byte = 2
	'------------------------------------------------------------------------------
	'AVI_COMPRESSOR
	'------------------------------------------------------------------------------
	Public Const STCAM_AVI_COMPRESSOR_UNCOMPRESSED As integer = &H00000000
	Public Const STCAM_AVI_COMPRESSOR_MJPG As integer = &H47504A4D
	Public Const STCAM_AVI_COMPRESSOR_MP42 As integer = &H3234706D
	Public Const STCAM_AVI_COMPRESSOR_MPV4 As integer = &H3467706D
	Public Const STCAM_AVI_COMPRESSOR_DIALOG_BOX As integer = &HFFFFFFFF
	'------------------------------------------------------------------------------
	'CLOCK_MODE
	'------------------------------------------------------------------------------
	Public Const STCAM_CLOCK_MODE_NORMAL As integer = &H00000000
	Public Const STCAM_CLOCK_MODE_DIV_2 As integer = &H00000001
	Public Const STCAM_CLOCK_MODE_DIV_4 As integer = &H00000002
	Public Const STCAM_CLOCK_MODE_VGA_90FPS As integer = &H00000100
	Public Const STCAM_CLOCK_MODE_CUSTOM As integer = &H80000000
	'------------------------------------------------------------------------------
	'USBPID
	'------------------------------------------------------------------------------
	Public Const STCAM_USBPID_STC_C33USB As Short = &H0305
	Public Const STCAM_USBPID_STC_B33USB As Short = &H0705
	Public Const STCAM_USBPID_STC_B83USB As Short = &H0805
	Public Const STCAM_USBPID_STC_C83USB As Short = &H0605
	Public Const STCAM_USBPID_STC_TB33USB As Short = &H0906
	Public Const STCAM_USBPID_STC_TC33USB As Short = &H1006
	Public Const STCAM_USBPID_STC_TB83USB As Short = &H1106
	Public Const STCAM_USBPID_STC_TC83USB As Short = &H1206
	Public Const STCAM_USBPID_STC_TB133USB As Short = &H0109
	Public Const STCAM_USBPID_STC_TC133USB As Short = &H0209
	Public Const STCAM_USBPID_STC_TB152USB As Short = &H1306
	Public Const STCAM_USBPID_STC_TC152USB As Short = &H1406
	Public Const STCAM_USBPID_STC_TB202USB As Short = &H1506
	Public Const STCAM_USBPID_STC_TC202USB As Short = &H1606
	'------------------------------------------------------------------------------
	'AVI_STATUS
	'------------------------------------------------------------------------------
	Public Const STCAM_AVI_STATUS_STOP As Byte = &H00
	Public Const STCAM_AVI_STATUS_START As Byte = &H01
	Public Const STCAM_AVI_STATUS_PAUSE As Byte = &H02
	'------------------------------------------------------------------------------
	'DISPLAY_MODE
	'------------------------------------------------------------------------------
	Public Const STCAM_DISPLAY_MODE_GDI As Byte = &H00
	Public Const STCAM_DISPLAY_MODE_GDI_HALFTONE As Byte = &H08
	Public Const STCAM_DISPLAY_MODE_DD_OFFSCREEN As Byte = &H01
	Public Const STCAM_DISPLAY_MODE_DD_OVERLAY As Byte = &H02
	Public Const STCAM_DISPLAY_MODE_DD_OFFSCREEN_HQ As Byte = &H03
	Public Const STCAM_DISPLAY_MODE_DD_OVERLAY_HQ As Byte = &H04
	Public Const STCAM_DISPLAY_MODE_DIRECTX As Byte = &H05
	Public Const STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON As Byte = &H06
	Public Const STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON2 As Byte = &H07
	'------------------------------------------------------------------------------
	'WINDOW_STYLE
	'------------------------------------------------------------------------------
	Public Const WS_OVERLAPPED As integer = &H00000000
	Public Const WS_POPUP As integer = &H80000000
	Public Const WS_CHILD As integer = &H40000000
	Public Const WS_MINIMIZE As integer = &H20000000
	Public Const WS_VISIBLE As integer = &H10000000
	Public Const WS_DISABLED As integer = &H08000000
	Public Const WS_CLIPSIBLINGS As integer = &H04000000
	Public Const WS_CLIPCHILDREN As integer = &H02000000
	Public Const WS_MAXIMIZE As integer = &H01000000
	Public Const WS_CAPTION As integer = &H00C00000
	Public Const WS_BORDER As integer = &H00800000
	Public Const WS_DLGFRAME As integer = &H00400000
	Public Const WS_VSCROLL As integer = &H00200000
	Public Const WS_HSCROLL As integer = &H00100000
	Public Const WS_SYSMENU As integer = &H00080000
	Public Const WS_THICKFRAME As integer = &H00040000
	Public Const WS_GROUP As integer = &H00020000
	Public Const WS_TABSTOP As integer = &H00010000
	Public Const WS_MINIMIZEBOX As integer = &H00020000
	Public Const WS_MAXIMIZEBOX As integer = &H00010000
	Public Const WS_OVERLAPPEDWINDOW As integer = &H00CF0000
	Public Const WS_POPUPWINDOW As integer = &H80880000
	Public Const WS_TILED As integer = &H00000000
	Public Const WS_ICONIC As integer = &H00020000
	Public Const WS_SIZEBOX As integer = &H00040000
	Public Const WS_TILEDWINDOW As integer = &H00CF0000
	Public Const WS_CHILDWINDOW As integer = &H40000000
End Class

