'Created Date:2017/11/13 10:20
Attribute VB_Name = "mdlStCamD"
Option Explicit

'------------------------------------------------------------------------------
'Initialize
'------------------------------------------------------------------------------
Public Declare Function StCam_Open Lib "StCamD.dll" (ByVal dwInstance As Long) As Long
Public Declare Sub StCam_Close Lib "StCamD.dll" (ByVal hCamera As Long)
Public Declare Function StCam_GetLastError Lib "StCamD.dll" (ByVal hCamera As Long) As Long
Public Declare Function StCam_CameraCount Lib "StCamD.dll" () As Long
Public Declare Function StCam_SetReceiveMsgWindow Lib "StCamD.dll" (ByVal hCamera As Long, ByVal hWnd As Long) As Long
Public Declare Function StCam_GetUSBSpeed Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteUSBSpeed As Byte) As Long
Public Declare Function StCam_GetUSBMaxSpeed Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteUSBSpeed As Byte) As Long

'------------------------------------------------------------------------------
'Image Information
'------------------------------------------------------------------------------
Public Declare Function StCam_GetColorArray Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwColorArray As Integer) As Long
Public Declare Function StCam_GetEnableTransferBitsPerPixel Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwEnableTransferBitsPerPixel As Long) As Long
Public Declare Function StCam_SetTransferBitsPerPixel Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwTransferBitsPerPixel As Long) As Long
Public Declare Function StCam_GetTransferBitsPerPixel Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwTransferBitsPerPixel As Long) As Long
Public Declare Function StCam_GetMaximumImageSize Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwMaxWidth As Long, ByRef pdwMaxHeight As Long) As Long
Public Declare Function StCam_GetEnableImageSize Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwReserved As Long, ByRef pwEnableScanMode As Integer) As Long
Public Declare Function StCam_SetImageSize Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwReserved As Long, ByVal wScanMode As Integer, ByVal dwOffsetX As Long, ByVal dwOffsetY As Long, ByVal dwWidth As Long, ByVal dwHeight As Long) As Long
Public Declare Function StCam_GetImageSize Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwReserved As Long, ByRef pwScanMode As Integer, ByRef pdwOffsetX As Long, ByRef pdwOffsetY As Long, ByRef pdwWidth As Long, ByRef pdwHeight As Long) As Long
Public Declare Function StCam_GetSkippingAndBinning Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteHSkipping As Byte, ByRef pbyteVSkipping As Byte, ByRef pbyteHBinning As Byte, ByRef pbyteVBinning As Byte) As Long
Public Declare Function StCam_SetSkippingAndBinning Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteHSkipping As Byte, ByVal byteVSkipping As Byte, ByVal byteHBinning As Byte, ByVal byteVBinning As Byte) As Long
Public Declare Function StCam_GetBinningSumMode Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwMode As Integer) As Long
Public Declare Function StCam_SetBinningSumMode Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wMode As Integer) As Long
Public Declare Function StCam_SetPriorityMode Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwPriorityMode As Long) As Long
Public Declare Function StCam_GetPriorityMode Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwPriorityMode As Long) As Long

'------------------------------------------------------------------------------
'Preview
'------------------------------------------------------------------------------
Public Declare Function StCam_StartTransfer Lib "StCamD.dll" (ByVal hCamera As Long) As Long
Public Declare Function StCam_StopTransfer Lib "StCamD.dll" (ByVal hCamera As Long) As Long
Public Declare Function StCam_SetPreviewPixelFormat Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwPreviewPixelFormat As Long) As Long
Public Declare Function StCam_GetPreviewPixelFormat Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwPreviewPixelFormat As Long) As Long
Public Declare Function StCam_GetEnablePreviewPixelFormat Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwEnablePreviewPixelFormat As Long) As Long
Public Declare Function StCam_SetColorInterpolationMethod Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteColorInterpolationMethod As Byte) As Long
Public Declare Function StCam_GetColorInterpolationMethod Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteColorInterpolationMethod As Byte) As Long
Public Declare Function StCam_CreatePreviewWindowA Lib "StCamD.dll" (ByVal hCamera As Long, ByVal pszWindowName As String, ByVal dwStyle As Long, ByVal lngPositionX As Long, ByVal lngPositionY As Long, ByVal dwWidth As Long, ByVal dwHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal bCloseEnable As Long) As Long
Public Declare Function StCam_DestroyPreviewWindow Lib "StCamD.dll" (ByVal hCamera As Long) As Long
Public Declare Function StCam_SetPreviewWindowNameA Lib "StCamD.dll" (ByVal hCamera As Long, ByVal pszWindowName As String) As Long
Public Declare Function StCam_GetPreviewWindowNameA Lib "StCamD.dll" (ByVal hCamera As Long, ByVal pszWindowName As String, ByVal lngMaxCount As Long) As Long
Public Declare Function StCam_SetPreviewMaskSize Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwOffsetX As Long, ByVal dwOffsetY As Long, ByVal dwWidth As Long, ByVal dwHeight As Long) As Long
Public Declare Function StCam_GetPreviewMaskSize Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwOffsetX As Long, ByRef pdwOffsetY As Long, ByRef pdwWidth As Long, ByRef pdwHeight As Long) As Long
Public Declare Function StCam_SetPreviewWindowSize Lib "StCamD.dll" (ByVal hCamera As Long, ByVal lngPositionX As Long, ByVal lngPositionY As Long, ByVal dwWidth As Long, ByVal dwHeight As Long) As Long
Public Declare Function StCam_GetPreviewWindowSize Lib "StCamD.dll" (ByVal hCamera As Long, ByRef plngPositionX As Long, ByRef plngPositionY As Long, ByRef pdwWidth As Long, ByRef pdwHeight As Long) As Long
Public Declare Function StCam_SetPreviewWindowStyle Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwStyle As Long) As Long
Public Declare Function StCam_GetPreviewWindowStyle Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwStyle As Long) As Long
Public Declare Function StCam_SetAspectMode Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteAspectMode As Byte) As Long
Public Declare Function StCam_GetAspectMode Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteAspectMode As Byte) As Long
Public Declare Function StCam_SetPreviewDestSize Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwOffsetX As Long, ByVal dwOffsetY As Long, ByVal dwWidth As Long, ByVal dwHeight As Long) As Long
Public Declare Function StCam_GetPreviewDestSize Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwOffsetX As Long, ByRef pdwOffsetY As Long, ByRef pdwWidth As Long, ByRef pdwHeight As Long) As Long
Public Declare Function StCam_SetMagnificationMode Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteMagnificationMode As Byte) As Long
Public Declare Function StCam_GetMagnificationMode Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteMagnificationMode As Byte) As Long
Public Declare Function StCam_GetDCWithReset Lib "StCamD.dll" (ByVal hCamera As Long, ByRef phDC As Long) As Long
Public Declare Function StCam_GetDC Lib "StCamD.dll" (ByVal hCamera As Long, ByRef phDC As Long) As Long
Public Declare Function StCam_ReleaseDC Lib "StCamD.dll" (ByVal hCamera As Long, ByVal hDC As Long) As Long
Public Declare Function StCam_ResetOverlay Lib "StCamD.dll" (ByVal hCamera As Long) As Long
Public Declare Function StCam_SetColorKey Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwColorKey As Long) As Long
Public Declare Function StCam_GetColorKey Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwColorKey As Long) As Long
Public Declare Function StCam_SetDisplayMode Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteDisplayMode As Byte) As Long
Public Declare Function StCam_GetDisplayMode Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteDisplayMode As Byte) As Long
Public Declare Function StCam_GetAlphaChannel Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteAlphaChannel As Byte) As Long
Public Declare Function StCam_SetAlphaChannel Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteAlphaChannel As Byte) As Long
Public Declare Function StCam_GetPreviewImagePixelValue Lib "StCamD.dll" (ByVal hCamera As Long, ByVal nX As Long, ByVal nY As Long, ByRef pdwColor As Long) As Long
Public Declare Function StCam_GetPreviewWnd Lib "StCamD.dll" (ByVal hCamera As Long, ByRef hWnd As Long) As Long

'------------------------------------------------------------------------------
'Image Acquisition
'------------------------------------------------------------------------------
Public Declare Function StCam_TakeRawSnapShot Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteBuffer As Byte, ByVal dwBufferSize As Long, ByRef pdwNumberOfByteTrans As Long, ByRef pdwFrameNo As Long, ByVal dwMilliseconds As Long) As Long
Public Declare Function StCam_TakePreviewSnapShot Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteBuffer As Byte, ByVal dwBufferSize As Long, ByRef pdwNumberOfByteTrans As Long, ByRef pdwFrameNo As Long, ByVal dwMilliseconds As Long) As Long
Public Declare Function StCam_SaveImageA Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwWidth As Long, ByVal dwHeight As Long, ByVal dwPreviewPixelFormat As Long, ByRef pbyteData As Byte, ByVal pszFileName As String, ByVal dwParam As Long) As Long
Public Declare Function StCam_GetRawDataSize Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwSize As Long) As Long
Public Declare Function StCam_GetMaxROICount Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwRegionCount As Long) As Long
Public Declare Function StCam_GetPreviewDataSize Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwSize As Long, ByRef pdwWidth As Long, ByRef pdwHeight As Long, ByRef pdwLinePitch As Long) As Long
Public Declare Function StCam_SetROI Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwIndex As Long, ByVal dwMode As Long, ByVal dwOffsetX As Long, ByVal dwOffsetY As Long, ByVal dwWidth As Long, ByVal dwHeight As Long) As Long
Public Declare Function StCam_GetROI Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwIndex As Long, ByRef pdwMode As Long, ByRef pdwOffsetX As Long, ByRef pdwOffsetY As Long, ByRef pdwWidth As Long, ByRef pdwHeight As Long) As Long

'------------------------------------------------------------------------------
'Shutter Gain Control
'------------------------------------------------------------------------------
Public Declare Function StCam_GetALCMode Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteAlcMode As Byte) As Long
Public Declare Function StCam_SetALCMode Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteAlcMode As Byte) As Long
Public Declare Function StCam_GetExposureClock Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwExposureClock As Long) As Long
Public Declare Function StCam_SetExposureClock Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwExposureClock As Long) As Long
Public Declare Function StCam_GetMaxShortExposureClock Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwMaximumExpClock As Long) As Long
Public Declare Function StCam_GetMaxLongExposureClock Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwMaximumExpClock As Long) As Long
Public Declare Function StCam_GetExposureTimeFromClock Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwExposureClock As Long, ByRef pfExpTime As Single) As Long
Public Declare Function StCam_GetExposureClockFromTime Lib "StCamD.dll" (ByVal hCamera As Long, ByVal fExpTime As Single, ByRef pdwExposureClock As Long) As Long
Public Declare Function StCam_GetGain Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwGain As Integer) As Long
Public Declare Function StCam_SetGain Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wGain As Integer) As Long
Public Declare Function StCam_GetMaxGain Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwMaxGain As Integer) As Long
Public Declare Function StCam_GetGainDBFromSettingValue Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wGain As Integer, ByRef pfGainDB As Single) As Long
Public Declare Function StCam_GetTargetBrightness Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteTargetBrightness As Byte, ByRef pbyteTolerance As Byte, ByRef pbyteThreshold As Byte) As Long
Public Declare Function StCam_SetTargetBrightness Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteTargetBrightness As Byte, ByVal byteTolerance As Byte, ByVal byteThreshold As Byte) As Long
Public Declare Function StCam_GetALCWeight Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteALCWeight As Byte) As Long
Public Declare Function StCam_SetALCWeight Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteALCWeight As Byte) As Long
Public Declare Function StCam_SetAEMinExposureClock Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwMinExposureClock As Long) As Long
Public Declare Function StCam_GetAEMinExposureClock Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwMinExposureClock As Long) As Long
Public Declare Function StCam_GetAEMaxExposureClock Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwMaxExposureClock As Long) As Long
Public Declare Function StCam_SetAEMaxExposureClock Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwMaxExposureClock As Long) As Long
Public Declare Function StCam_SetALCControlSpeed Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteShutterCtrlSpeedLimit As Byte, ByVal byteGainCtrlSpeedLimit As Byte, ByVal byteSkipFrameCount As Byte, ByVal byteAverageFrameCount As Byte) As Long
Public Declare Function StCam_GetALCControlSpeed Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteShutterCtrlSpeedLimit As Byte, ByRef pbyteGainCtrlSpeedLimit As Byte, ByRef pbyteSkipFrameCount As Byte, ByRef pbyteAverageFrameCount As Byte) As Long
Public Declare Function StCam_GetGainControlRange Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwMinGain As Integer, ByRef pwMaxGain As Integer) As Long
Public Declare Function StCam_SetGainControlRange Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wMinGain As Integer, ByVal wMaxGain As Integer) As Long
Public Declare Function StCam_GetDigitalGain Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwDigitalGain As Integer) As Long
Public Declare Function StCam_SetDigitalGain Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wDigitalGain As Integer) As Long
Public Declare Function StCam_GetMaxDigitalGain Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwMaxDigitalGain As Integer) As Long
Public Declare Function StCam_GetDigitalGainTimesFromSettingValue Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wDigitalGain As Integer, ByRef pfDigitalGainTimes As Single) As Long
Public Declare Function StCam_GetDigitalGainSettingValueFromGainTimes Lib "StCamD.dll" (ByVal hCamera As Long, ByVal fDigitalGainTimes As Single, ByRef pwDigitalGain As Integer) As Long
Public Declare Function StCam_GetShutterSpeed Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwShutterLine As Integer, ByRef pwShutterClock As Integer) As Long
Public Declare Function StCam_SetShutterSpeed Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wShutterLine As Integer, ByVal wShutterClock As Integer) As Long
Public Declare Function StCam_GetShutterControlRange Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwMinShutterLine As Integer, ByRef pwMinShutterClock As Integer, ByRef pwMaxShutterLine As Integer, ByRef pwMaxShutterClock As Integer) As Long
Public Declare Function StCam_SetShutterControlRange Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wMinShutterLine As Integer, ByVal wMinShutterClock As Integer, ByVal wMaxShutterLine As Integer, ByVal wMaxShutterClock As Integer) As Long

'------------------------------------------------------------------------------
'White Balance Control
'------------------------------------------------------------------------------
Public Declare Function StCam_SetWhiteBalanceMode Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteWBMode As Byte) As Long
Public Declare Function StCam_GetWhiteBalanceMode Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteWBMode As Byte) As Long
Public Declare Function StCam_SetWhiteBalanceGain Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wWBGainR As Integer, ByVal wWBGainGr As Integer, ByVal wWBGainGb As Integer, ByVal wWBGainB As Integer) As Long
Public Declare Function StCam_GetWhiteBalanceGain Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwWBGainR As Integer, ByRef pwWBGainGr As Integer, ByRef pwWBGainGb As Integer, ByRef pwWBGainB As Integer) As Long
Public Declare Function StCam_SetWhiteBalanceTarget Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wAWBTargetR As Integer, ByVal wAWBTargetB As Integer) As Long
Public Declare Function StCam_GetWhiteBalanceTarget Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwAWBTargetR As Integer, ByRef pwAWBTargetB As Integer) As Long
Public Declare Function StCam_SetWhiteBalanceToleranceThreshold Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wAWBTolerance As Integer, ByVal wAWBThreshold As Integer) As Long
Public Declare Function StCam_GetWhiteBalanceToleranceThreshold Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwAWBTolerance As Integer, ByRef pwAWBThreshold As Integer) As Long
Public Declare Function StCam_SetAWBWeight Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteAWBWeight As Byte) As Long
Public Declare Function StCam_GetAWBWeight Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteAWBWeight As Byte) As Long
Public Declare Function StCam_RawWhiteBalance Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwWidth As Long, ByVal dwHeight As Long, ByVal wColorArray As Integer, ByRef pbyteRaw As Byte) As Long

'------------------------------------------------------------------------------
'Gamma
'------------------------------------------------------------------------------
Public Declare Function StCam_SetGammaMode Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteGammaTarget As Byte, ByVal byteGammaMode As Byte, ByVal wGamma As Integer, ByRef pbyteGammaTable As Byte) As Long
Public Declare Function StCam_GetGammaMode Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteGammaTarget As Byte, ByRef pbyteGammaMode As Byte, ByRef pwGamma As Integer, ByRef pbyteGammaTable As Byte) As Long
Public Declare Function StCam_SetGammaModeEx Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteGammaTarget As Byte, ByVal byteGammaMode As Byte, ByVal wGamma As Integer, ByVal shtBrightness As Integer, ByVal byteContrast As Byte, ByRef pbyteGammaTable As Byte) As Long
Public Declare Function StCam_GetGammaModeEx Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteGammaTarget As Byte, ByRef pbyteGammaMode As Byte, ByRef pwGamma As Integer, ByRef pshtBrightness As Integer, ByRef pbyteContrast As Byte, ByRef pbyteGammaTable As Byte) As Long
Public Declare Function StCam_GetCameraGammaValue Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwValue As Integer) As Long
Public Declare Function StCam_SetCameraGammaValue Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wValue As Integer) As Long

'------------------------------------------------------------------------------
'Sharpness
'------------------------------------------------------------------------------
Public Declare Function StCam_SetSharpnessMode Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteSharpnessMode As Byte, ByVal wSharpnessGain As Integer, ByVal byteSharpnessCoring As Byte) As Long
Public Declare Function StCam_GetSharpnessMode Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteSharpnessMode As Byte, ByRef pwSharpnessGain As Integer, ByRef pbyteSharpnessCoring As Byte) As Long

'------------------------------------------------------------------------------
'Hue Saturation
'------------------------------------------------------------------------------
Public Declare Function StCam_SetHueSaturationMode Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteHueSaturationMode As Byte, ByVal shtHue As Integer, ByVal wSaturation As Integer) As Long
Public Declare Function StCam_GetHueSaturationMode Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteHueSaturationMode As Byte, ByRef pshtHue As Integer, ByRef pwSaturation As Integer) As Long

'------------------------------------------------------------------------------
'Color Matrix
'------------------------------------------------------------------------------
Public Declare Function StCam_SetColorMatrix Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteColorMatrixMode As Byte, ByRef pshtColorMatrix As Integer) As Long
Public Declare Function StCam_GetColorMatrix Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteColorMatrixMode As Byte, ByRef pshtColorMatrix As Integer) As Long
Public Declare Function StCam_SetHighChromaSuppression Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wStartLevel As Integer, ByVal wSuppression As Integer) As Long
Public Declare Function StCam_SetLowChromaSuppression Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wStartLevel As Integer, ByVal wSuppression As Integer) As Long
Public Declare Function StCam_GetHighChromaSuppression Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwStartLevel As Integer, ByRef pwSuppression As Integer) As Long
Public Declare Function StCam_GetLowChromaSuppression Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwStartLevel As Integer, ByRef pwSuppression As Integer) As Long
Public Declare Function StCam_GetChromaSuppression Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwStartLevel As Integer, ByRef pwSuppression As Integer) As Long
Public Declare Function StCam_SetChromaSuppression Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wStartLevel As Integer, ByVal wSuppression As Integer) As Long

'------------------------------------------------------------------------------
'Shading Correction
'------------------------------------------------------------------------------
Public Declare Function StCam_SetShadingCorrectionMode Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwMode As Long) As Long
Public Declare Function StCam_GetShadingCorrectionMode Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwMode As Long) As Long
Public Declare Function StCam_SetShadingCorrectionTarget Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wTarget As Integer) As Long
Public Declare Function StCam_GetShadingCorrectionTarget Lib "StCamD.dll" (ByVal hCamera As Long, ByRef wTarget As Integer) As Long

'------------------------------------------------------------------------------
'Mirro Rotation
'------------------------------------------------------------------------------
Public Declare Function StCam_GetEnableMirrorMode Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteMirrorMode As Byte) As Long
Public Declare Function StCam_SetMirrorMode Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteMirrorMode As Byte) As Long
Public Declare Function StCam_GetMirrorMode Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteMirrorMode As Byte) As Long
Public Declare Function StCam_SetRotationMode Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteRotationMode As Byte) As Long
Public Declare Function StCam_GetRotationMode Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteRotationMode As Byte) As Long

'------------------------------------------------------------------------------
'Movie
'------------------------------------------------------------------------------
Public Declare Function StCam_SaveAVIA Lib "StCamD.dll" (ByVal hCamera As Long, ByVal pszFileName As String, ByVal dwCompressor As Long, ByVal dwLength As Long, ByVal lpReserved As Long) As Long
Public Declare Function StCam_SetAVIStatus Lib "StCamD.dll" (ByVal hCamera As Long, ByVal byteAVIStatus As Byte) As Long
Public Declare Function StCam_GetAVIStatus Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteAVIStatus As Byte, ByRef pdwTotalFrameCounts As Long, ByRef pdwCurrentFrameCounts As Long) As Long
Public Declare Function StCam_SetAVIQuality Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwQuality As Long) As Long
Public Declare Function StCam_GetAVIQuality Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwQuality As Long) As Long
Public Declare Function StCam_SetAVIPriorityFileFormat Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwFileFormat As Long) As Long
Public Declare Function StCam_GetAVIPriorityFileFormat Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwFileFormat As Long) As Long

'------------------------------------------------------------------------------
'Clock
'------------------------------------------------------------------------------
Public Declare Function StCam_GetEnableClock Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwEnableClockMode As Long, ByRef pdwStandardClock As Long, ByRef pdwMinimumClock As Long, ByRef pdwMaximumClock As Long) As Long
Public Declare Function StCam_SetClock Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwClockMode As Long, ByVal dwClock As Long) As Long
Public Declare Function StCam_GetClock Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwClockMode As Long, ByRef pdwClock As Long) As Long
Public Declare Function StCam_GetFrameClock Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwCurrentLinePerFrame As Integer, ByRef pwCurrentClockPerLine As Integer) As Long
Public Declare Function StCam_GetOutputFPS Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pfFPS As Single) As Long
Public Declare Function StCam_SetVBlankForFPS Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwVLines As Long) As Long
Public Declare Function StCam_GetVBlankForFPS Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwVLines As Long) As Long
Public Declare Function StCam_GetMaxVBlankForFPS Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwVLines As Long) As Long

'------------------------------------------------------------------------------
'IOPin
'------------------------------------------------------------------------------
Public Declare Function StCam_GetDeviceTemperature Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwSelector As Long, ByRef pnValue As Long) As Long

'------------------------------------------------------------------------------
'Defect pixel correction
'------------------------------------------------------------------------------
Public Declare Function StCam_GetEnableDefectPixelCorrectionCount Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwCount As Integer) As Long
Public Declare Function StCam_GetDefectPixelCorrectionMode Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwMode As Integer) As Long
Public Declare Function StCam_SetDefectPixelCorrectionMode Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wMode As Integer) As Long
Public Declare Function StCam_GetDefectPixelCorrectionPosition Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wIndex As Integer, ByRef pdwX As Long, ByRef pdwY As Long) As Long
Public Declare Function StCam_SetDefectPixelCorrectionPosition Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wIndex As Integer, ByVal dwX As Long, ByVal dwY As Long) As Long
Public Declare Function StCam_DetectDefectPixel Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwWidth As Long, ByVal dwHeight As Long, ByRef pbyteRaw As Byte, ByVal wThreshold As Integer) As Long

'------------------------------------------------------------------------------
'HDR
'------------------------------------------------------------------------------
Public Declare Function StCam_GetHDRType Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwHDRType As Long) As Long
Public Declare Function StCam_SetHDRParameter Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwBuffer As Long, ByVal dwSize As Long) As Long
Public Declare Function StCam_GetHDRParameter Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwBuffer As Long, ByRef pdwSize As Long) As Long

'------------------------------------------------------------------------------
'Setting
'------------------------------------------------------------------------------
Public Declare Function StCam_SaveSettingFileA Lib "StCamD.dll" (ByVal hCamera As Long, ByVal pszFileName As String) As Long
Public Declare Function StCam_LoadSettingFileA Lib "StCamD.dll" (ByVal hCamera As Long, ByVal pszFileName As String) As Long
Public Declare Function StCam_ResetSetting Lib "StCamD.dll" (ByVal hCamera As Long) As Long
Public Declare Function StCam_CameraSetting Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wMode As Integer) As Long

'------------------------------------------------------------------------------
'EEPROM
'------------------------------------------------------------------------------
Public Declare Function StCam_ReadUserMemory Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteBuffer As Byte, ByVal wOffset As Integer, ByVal wLength As Integer) As Long
Public Declare Function StCam_WriteUserMemory Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteBuffer As Byte, ByVal wOffset As Integer, ByVal wLength As Integer) As Long
Public Declare Function StCam_ReadCameraUserIDA Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwCameraID As Long, ByVal pszBuffer As String, ByVal dwBufferSize As Long) As Long
Public Declare Function StCam_WriteCameraUserIDA Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwCameraID As Long, ByVal pszBuffer As String, ByVal dwBufferSize As Long) As Long

'------------------------------------------------------------------------------
'Version Information
'------------------------------------------------------------------------------
Public Declare Function StCam_GetProductNameA Lib "StCamD.dll" (ByVal hCamera As Long, ByVal pszCameraName As String, ByVal dwBufferSize As Long) As Long
Public Declare Function StCam_GetCameraVersion Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwUSBVendorID As Integer, ByRef pwUSBProductID As Integer, ByRef pwFPGAVersion As Integer, ByRef pwFirmVersion As Integer) As Long
Public Declare Function StCam_GetDriverVersion Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwFileVersionMS As Long, ByRef pdwFileVersionLS As Long, ByRef pdwProductVersionMS As Long, ByRef pdwProductVersionLS As Long) As Long
Public Declare Function StCam_GetUSBDllVersion Lib "StCamD.dll" (ByRef pdwFileVersionMS As Long, ByRef pdwFileVersionLS As Long, ByRef pdwProductVersionMS As Long, ByRef pdwProductVersionLS As Long) As Long
Public Declare Function StCam_GetCAMDllVersion Lib "StCamD.dll" (ByRef pdwFileVersionMS As Long, ByRef pdwFileVersionLS As Long, ByRef pdwProductVersionMS As Long, ByRef pdwProductVersionLS As Long) As Long
Public Declare Function StCam_GetUSBFunctionAddress Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pbyteUSBFunctionAddress As Byte) As Long
Public Declare Function StCam_HasFunction Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwCameraFunctionID As Long, ByRef pbHasFunction As Long) As Long
Public Declare Function StCam_GetDevicePathA Lib "StCamD.dll" (ByVal hCamera As Long, ByVal pszDevicePath As String, ByRef pdwBufferSize As Long) As Long

'------------------------------------------------------------------------------
'Debug Only
'------------------------------------------------------------------------------
Public Declare Function StCam_ReadCameraSerialIDA Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwCameraID As Long, ByVal pszBuffer As String, ByVal dwBufferSize As Long) As Long

'------------------------------------------------------------------------------
'Other
'------------------------------------------------------------------------------
Public Declare Function StCam_ConvertBitmapBGR24ToRGB24 Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwWidth As Long, ByVal dwHeight As Long, ByRef pbyteBitmap As Byte) As Long
Public Declare Function StCam_ConvertRawToBGR Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwWidth As Long, ByVal dwHeight As Long, ByRef pbyteSrcRaw As Byte, ByRef pbyteDstBGR As Byte, ByVal byteColorInterpolationMethod As Byte, ByVal dwPreviewPixelFormat As Long) As Long
Public Declare Function StCam_SetControlArea Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwSepalateX As Integer, ByRef pwSepalateY As Integer) As Long
Public Declare Function StCam_GetControlArea Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwSepalateX As Integer, ByRef pwSepalateY As Integer) As Long
Public Declare Function StCam_GetDigitalClamp Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwValue As Integer) As Long
Public Declare Function StCam_SetDigitalClamp Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wValue As Integer) As Long
Public Declare Function StCam_ResetRootHub Lib "StCamD.dll" () As Long
Public Declare Function StCam_SetAnalogBlackLevel Lib "StCamD.dll" (ByVal hCamera As Long, ByVal wBlackLevel As Integer) As Long
Public Declare Function StCam_GetAnalogBlackLevel Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwBlackLevel As Integer) As Long
Public Declare Function StCam_GetMaxAnalogBlackLevel Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwBlackLevel As Integer) As Long
Public Declare Function StCam_GetMaxDigitalClamp Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pwDigitalClamp As Integer) As Long
Public Declare Function StCam_SetAdjustmentMode Lib "StCamD.dll" (ByVal hCamera As Long, ByVal dwValue As Long) As Long
Public Declare Function StCam_GetAdjustmentMode Lib "StCamD.dll" (ByVal hCamera As Long, ByRef pdwValue As Long) As Long
'------------------------------------------------------------------------------
'ERROR_STCAM
'------------------------------------------------------------------------------
Public Const ERRST_NOT_FOUND_CAMERA As Long = &HE0000001&
Public Const ERRST_ALL_CAMARA_OPENED As Long = &HE0000002&
Public Const ERRST_INVALID_CAMERA_HANDLE As Long = &HE0000003&
Public Const ERRST_INVALID_FUNCTION_RECEIVING As Long = &HE0000004&
Public Const ERRST_USB_COMMAND_TRANSFER As Long = &HE0000005&
Public Const ERRST_WINDOW_ALREADY_EXISTS As Long = &HE0000006&
Public Const ERRST_WINDOW_DOES_NOT_EXISTS As Long = &HE0000007&
Public Const ERRST_INVALID_FUNCTION_RECORDING As Long = &HE0000008&
Public Const ERRST_AVI_STREAM As Long = &HE0000009&
Public Const ERRST_AVI_NOCOMPRESSOR As Long = &HE000000A&
Public Const ERRST_AVI_UNSUPPORTED As Long = &HE000000B&
Public Const ERRST_AVI_DISK As Long = &HE000000C&
Public Const ERRST_AVI_CANCELED As Long = &HE000000D&
Public Const ERRST_AVI_WRITE As Long = &HE000000E&
Public Const ERRST_INVALID_FILE_NAME As Long = &HE000000F&
Public Const ERRST_FILE_OPEN As Long = &HE0000010&
Public Const ERRST_FILE_WRITE As Long = &HE0000011&
Public Const ERRST_NOT_SUPPORTED_FUNCTION As Long = &HE0000021&
'------------------------------------------------------------------------------
'WM_STCAM
'------------------------------------------------------------------------------
Public Const WM_STCAM_TRANSFER_START As Long = &HB001&
Public Const WM_STCAM_TRANSFER_FINISH As Long = &HB002&
Public Const WM_STCAM_PREVIEW_WINDOW_CREATE As Long = &HB003&
Public Const WM_STCAM_PREVIEW_WINDOW_CLOSE As Long = &HB004&
Public Const WM_STCAM_PREVIEW_WINDOW_RESIZE As Long = &HB005&
Public Const WM_STCAM_PREVIEW_MASK_RESIZE As Long = &HB006&
Public Const WM_STCAM_PREVIEW_DEST_RESIZE As Long = &HB007&
Public Const WM_STCAM_AVI_FILE_START As Long = &HB008&
Public Const WM_STCAM_AVI_FILE_FINISH As Long = &HB009&
Public Const WM_STCAM_PREVIEW_MENU_COMMAND As Long = &HB00A&
Public Const WM_STCAM_UPDATED_PREVIEW_IMAGE As Long = &HB00B&
'------------------------------------------------------------------------------
'COLOR_ARRAY
'------------------------------------------------------------------------------
Public Const STCAM_COLOR_ARRAY_MONO As Integer = &H0001
Public Const STCAM_COLOR_ARRAY_RGGB As Integer = &H0002
Public Const STCAM_COLOR_ARRAY_GRBG As Integer = &H0003
Public Const STCAM_COLOR_ARRAY_GBRG As Integer = &H0004
Public Const STCAM_COLOR_ARRAY_BGGR As Integer = &H0005
'------------------------------------------------------------------------------
'TRANSER_BITS_PER_PIXEL
'------------------------------------------------------------------------------
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_RAW_08 As Long = &H00000001&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_RAW_10 As Long = &H00000002&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_RAW_10P As Long = &H00010000&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_RAW_12 As Long = &H00000004&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_RAW_12P As Long = &H00020000&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_RAW_14 As Long = &H00000008&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_RAW_16 As Long = &H00000010&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_MONO_08 As Long = &H00000020&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10 As Long = &H00000040&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10P As Long = &H00100000&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12 As Long = &H00000080&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12P As Long = &H00200000&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_MONO_14 As Long = &H00000100&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_MONO_16 As Long = &H00000200&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_BGR_08 As Long = &H00000400&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_BGR_10 As Long = &H00000800&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_YCBCR411_08 As Long = &H00001000&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_YCBCR422_08 As Long = &H00002000&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_YCBCR444_08 As Long = &H00004000&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_08 As Long = &H00000001&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_10 As Long = &H00000002&
Public Const STCAM_TRANSFER_BITS_PER_PIXEL_12 As Long = &H00000004&
Public Const STCAM_TRANSER_BITS_PER_PIXEL_08 As Long = &H00000001&
Public Const STCAM_TRANSER_BITS_PER_PIXEL_16 As Long = &H00000002&
'------------------------------------------------------------------------------
'IMAGE_SIZE_MODE
'------------------------------------------------------------------------------
Public Const STCAM_IMAGE_SIZE_MODE_CUSTOM As Long = &H00000001&
Public Const STCAM_IMAGE_SIZE_MODE_VGA As Long = &H00000008&
Public Const STCAM_IMAGE_SIZE_MODE_XGA As Long = &H00000020&
Public Const STCAM_IMAGE_SIZE_MODE_QUAD_VGA As Long = &H00000080&
Public Const STCAM_IMAGE_SIZE_MODE_SXGA As Long = &H00000100&
Public Const STCAM_IMAGE_SIZE_MODE_UXGA As Long = &H00000400&
'------------------------------------------------------------------------------
'SCAN_MODE
'------------------------------------------------------------------------------
Public Const STCAM_SCAN_MODE_NORMAL As Integer = &H0000
Public Const STCAM_SCAN_MODE_PARTIAL_2 As Integer = &H0001
Public Const STCAM_SCAN_MODE_PARTIAL_4 As Integer = &H0002
Public Const STCAM_SCAN_MODE_PARTIAL_1 As Integer = &H0004
Public Const STCAM_SCAN_MODE_VARIABLE_PARTIAL As Integer = &H0008
Public Const STCAM_SCAN_MODE_BINNING As Integer = &H0010
Public Const STCAM_SCAN_MODE_BINNING_PARTIAL_1 As Integer = &H0020
Public Const STCAM_SCAN_MODE_BINNING_PARTIAL_2 As Integer = &H0040
Public Const STCAM_SCAN_MODE_BINNING_PARTIAL_4 As Integer = &H0080
Public Const STCAM_SCAN_MODE_BINNING_VARIABLE_PARTIAL As Integer = &H0100
Public Const STCAM_SCAN_MODE_ROI As Integer = &H8000
Public Const STCAM_SCAN_MODE_AOI As Integer = &H8000
'------------------------------------------------------------------------------
'PIXEL_FORMAT
'------------------------------------------------------------------------------
Public Const STCAM_PIXEL_FORMAT_08_MONO_OR_RAW As Long = &H00000001&
Public Const STCAM_PIXEL_FORMAT_24_BGR As Long = &H00000004&
Public Const STCAM_PIXEL_FORMAT_32_BGR As Long = &H00000008&
'------------------------------------------------------------------------------
'COLOR_INTERPOLATION
'------------------------------------------------------------------------------
Public Const STCAM_COLOR_INTERPOLATION_NONE_MONO As Byte = 0
Public Const STCAM_COLOR_INTERPOLATION_NONE_COLOR As Byte = 1
Public Const STCAM_COLOR_INTERPOLATION_NEAREST_NEIGHBOR As Byte = 2
Public Const STCAM_COLOR_INTERPOLATION_BILINEAR As Byte = 3
Public Const STCAM_COLOR_INTERPOLATION_BILINEAR_FALSE_COLOR_REDUCTION As Byte = 5
Public Const STCAM_COLOR_INTERPOLATION_BICUBIC As Byte = 4
'------------------------------------------------------------------------------
'ASPECT
'------------------------------------------------------------------------------
Public Const STCAM_ASPECT_MODE_FIXED As Byte = 0
Public Const STCAM_ASPECT_MODE_KEEP_ASPECT As Byte = 1
Public Const STCAM_ASPECT_MODE_ADJUST_WINDOW As Byte = 2
Public Const STCAM_ASPECT_MODE_MASK_SIZE As Byte = 3
Public Const STCAM_ASPECT_MODE_CUSTOM_OFFSET As Byte = 254
Public Const STCAM_ASPECT_MODE_CUSTOM_CENTER As Byte = 255
Public Const STCAM_ASPECT_MODE_CUSTOM As Byte = 255
'------------------------------------------------------------------------------
'MAGNIFICATION
'------------------------------------------------------------------------------
Public Const STCAM_MAGNIFICATION_MODE_OFF As Byte = 0
Public Const STCAM_MAGNIFICATION_MODE_ON As Byte = 1
'------------------------------------------------------------------------------
'ALCMODE
'------------------------------------------------------------------------------
Public Const STCAM_ALCMODE_FIXED_SHUTTER_AGC_OFF As Byte = 0
Public Const STCAM_ALCMODE_AUTO_SHUTTER_ON_AGC_ON As Byte = 1
Public Const STCAM_ALCMODE_AUTO_SHUTTER_ON_AGC_OFF As Byte = 2
Public Const STCAM_ALCMODE_FIXED_SHUTTER_AGC_ON As Byte = 3
Public Const STCAM_ALCMODE_AUTO_SHUTTER_AGC_ONESHOT As Byte = 4
Public Const STCAM_ALCMODE_AUTO_SHUTTER_ONESHOT_AGC_OFF As Byte = 5
Public Const STCAM_ALCMODE_FIXED_SHUTTER_AGC_ONESHOT As Byte = 6
Public Const STCAM_ALCMODE_CAMERA_AE_ON As Byte = 16
Public Const STCAM_ALCMODE_CAMERA_AGC_ON As Byte = 32
Public Const STCAM_ALCMODE_CAMERA_AE_AGC_ON As Byte = 48
Public Const STCAM_ALCMODE_ALC_FIXED_AGC_OFF As Byte = 0
Public Const STCAM_ALCMODE_ALC_FULLAUTO_AGC_ON As Byte = 1
Public Const STCAM_ALCMODE_ALC_FULLAUTO_AGC_OFF As Byte = 2
Public Const STCAM_ALCMODE_ALC_FIXED_AGC_ON As Byte = 3
Public Const STCAM_ALCMODE_ALCAGC_ONESHOT As Byte = 4
Public Const STCAM_ALCMODE_ALC_ONESHOT_AGC_OFF As Byte = 5
Public Const STCAM_ALCMODE_ALC_FIXED_AGC_ONESHOT As Byte = 6
'------------------------------------------------------------------------------
'WB
'------------------------------------------------------------------------------
Public Const STCAM_WB_OFF As Byte = 0
Public Const STCAM_WB_MANUAL As Byte = 1
Public Const STCAM_WB_FULLAUTO As Byte = 2
Public Const STCAM_WB_ONESHOT As Byte = 3
'------------------------------------------------------------------------------
'GAMMA
'------------------------------------------------------------------------------
Public Const STCAM_GAMMA_OFF As Byte = 0
Public Const STCAM_GAMMA_ON As Byte = 1
Public Const STCAM_GAMMA_REVERSE As Byte = 2
Public Const STCAM_GAMMA_TABLE As Byte = 255
'------------------------------------------------------------------------------
'GAMMA_TARGET
'------------------------------------------------------------------------------
Public Const STCAM_GAMMA_TARGET_Y As Byte = 0
Public Const STCAM_GAMMA_TARGET_R As Byte = 1
Public Const STCAM_GAMMA_TARGET_GR As Byte = 2
Public Const STCAM_GAMMA_TARGET_GB As Byte = 3
Public Const STCAM_GAMMA_TARGET_B As Byte = 4
'------------------------------------------------------------------------------
'SHARPNESS
'------------------------------------------------------------------------------
Public Const STCAM_SHARPNESS_OFF As Byte = 0
Public Const STCAM_SHARPNESS_ON As Byte = 1
'------------------------------------------------------------------------------
'HUE_SATURATION
'------------------------------------------------------------------------------
Public Const STCAM_HUE_SATURATION_OFF As Byte = 0
Public Const STCAM_HUE_SATURATION_ON As Byte = 1
'------------------------------------------------------------------------------
'COLOR_MATRIX
'------------------------------------------------------------------------------
Public Const STCAM_COLOR_MATRIX_OFF As Byte = &H00
Public Const STCAM_COLOR_MATRIX_CUSTOM As Byte = &HFF
'------------------------------------------------------------------------------
'MIRROR
'------------------------------------------------------------------------------
Public Const STCAM_MIRROR_OFF As Byte = 0
Public Const STCAM_MIRROR_HORIZONTAL As Byte = 1
Public Const STCAM_MIRROR_VERTICAL As Byte = 2
Public Const STCAM_MIRROR_HORIZONTAL_VERTICAL As Byte = 3
Public Const STCAM_MIRROR_HORIZONTAL_CAMERA As Byte = 16
Public Const STCAM_MIRROR_VERTICAL_CAMERA As Byte = 32
'------------------------------------------------------------------------------
'ROTATION
'------------------------------------------------------------------------------
Public Const STCAM_ROTATION_OFF As Byte = 0
Public Const STCAM_ROTATION_CLOCKWISE_90 As Byte = 1
Public Const STCAM_ROTATION_COUNTERCLOCKWISE_90 As Byte = 2
'------------------------------------------------------------------------------
'AVI_COMPRESSOR
'------------------------------------------------------------------------------
Public Const STCAM_AVI_COMPRESSOR_UNCOMPRESSED As Long = &H00000000&
Public Const STCAM_AVI_COMPRESSOR_MJPG As Long = &H47504A4D&
Public Const STCAM_AVI_COMPRESSOR_MP42 As Long = &H3234706D&
Public Const STCAM_AVI_COMPRESSOR_MPV4 As Long = &H3467706D&
Public Const STCAM_AVI_COMPRESSOR_DIALOG_BOX As Long = &HFFFFFFFF&
'------------------------------------------------------------------------------
'CLOCK_MODE
'------------------------------------------------------------------------------
Public Const STCAM_CLOCK_MODE_NORMAL As Long = &H00000000&
Public Const STCAM_CLOCK_MODE_DIV_2 As Long = &H00000001&
Public Const STCAM_CLOCK_MODE_DIV_4 As Long = &H00000002&
Public Const STCAM_CLOCK_MODE_VGA_90FPS As Long = &H00000100&
Public Const STCAM_CLOCK_MODE_CUSTOM As Long = &H80000000&
'------------------------------------------------------------------------------
'USBPID
'------------------------------------------------------------------------------
Public Const STCAM_USBPID_STC_C33USB As Integer = &H0305
Public Const STCAM_USBPID_STC_B33USB As Integer = &H0705
Public Const STCAM_USBPID_STC_B83USB As Integer = &H0805
Public Const STCAM_USBPID_STC_C83USB As Integer = &H0605
Public Const STCAM_USBPID_STC_TB33USB As Integer = &H0906
Public Const STCAM_USBPID_STC_TC33USB As Integer = &H1006
Public Const STCAM_USBPID_STC_TB83USB As Integer = &H1106
Public Const STCAM_USBPID_STC_TC83USB As Integer = &H1206
Public Const STCAM_USBPID_STC_TB133USB As Integer = &H0109
Public Const STCAM_USBPID_STC_TC133USB As Integer = &H0209
Public Const STCAM_USBPID_STC_TB152USB As Integer = &H1306
Public Const STCAM_USBPID_STC_TC152USB As Integer = &H1406
Public Const STCAM_USBPID_STC_TB202USB As Integer = &H1506
Public Const STCAM_USBPID_STC_TC202USB As Integer = &H1606
Public Const STCAM_USBPID_STC_MB33USB As Integer = &H0110
Public Const STCAM_USBPID_STC_MC33USB As Integer = &H0210
Public Const STCAM_USBPID_STC_MB83USB As Integer = &H0310
Public Const STCAM_USBPID_STC_MC83USB As Integer = &H0410
Public Const STCAM_USBPID_STC_MB133USB As Integer = &H0510
Public Const STCAM_USBPID_STC_MC133USB As Integer = &H0610
Public Const STCAM_USBPID_STC_MB152USB As Integer = &H0710
Public Const STCAM_USBPID_STC_MC152USB As Integer = &H0810
Public Const STCAM_USBPID_STC_MB202USB As Integer = &H0910
Public Const STCAM_USBPID_STC_MC202USB As Integer = &H1010
Public Const STCAM_USBPID_STC_MBA5MUSB3 As Integer = &H0111
Public Const STCAM_USBPID_STC_MCA5MUSB3 As Integer = &H0211
Public Const STCAM_USBPID_STC_MBE132U3V As Integer = &H0112
Public Const STCAM_USBPID_STC_MCE132U3V As Integer = &H0212
Public Const STCAM_USBPID_STC_MBCM401U3V As Integer = &H0113
Public Const STCAM_USBPID_STC_MCCM401U3V As Integer = &H0213
Public Const STCAM_USBPID_STC_MBCM200U3V As Integer = &H0313
Public Const STCAM_USBPID_STC_MCCM200U3V As Integer = &H0413
Public Const STCAM_USBPID_STC_MBCM33U3V As Integer = &H0513
Public Const STCAM_USBPID_STC_MCCM33U3V As Integer = &H0613
Public Const STCAM_USBPID_STC_MBS241U3V As Integer = &H0713
Public Const STCAM_USBPID_STC_MCS241U3V As Integer = &H0813
Public Const STCAM_USBPID_STC_MBE132U3V_IR As Integer = &H0114
Public Const STCAM_USBPID_STC_RHB33U3V As Integer = &H0115
Public Const STCAM_USBPID_STC_RHC33U3V As Integer = &H0215
Public Const STCAM_USBPID_STC_MBS510U3V As Integer = &H0315
Public Const STCAM_USBPID_STC_MCS510U3V As Integer = &H0415
Public Const STCAM_USBPID_STC_MBS322U3V As Integer = &H0515
Public Const STCAM_USBPID_STC_MCS322U3V As Integer = &H0615
Public Const STCAM_USBPID_STC_MBS891U3V As Integer = &H0116
Public Const STCAM_USBPID_STC_MCS891U3V As Integer = &H0216
Public Const STCAM_USBPID_STC_MBS123BU3V As Integer = &H0316
Public Const STCAM_USBPID_STC_MCS123BU3V As Integer = &H0416
Public Const STCAM_USBPID_STC_MBS43U3V As Integer = &H0516
Public Const STCAM_USBPID_STC_MCS43U3V As Integer = &H0616
Public Const STCAM_USBPID_STC_MBS163U3V As Integer = &H0716
Public Const STCAM_USBPID_STC_MCS163U3V As Integer = &H0816
'------------------------------------------------------------------------------
'AVI_STATUS
'------------------------------------------------------------------------------
Public Const STCAM_AVI_STATUS_STOP As Byte = &H00
Public Const STCAM_AVI_STATUS_START As Byte = &H01
Public Const STCAM_AVI_STATUS_PAUSE As Byte = &H02
'------------------------------------------------------------------------------
'DISPLAY_MODE
'------------------------------------------------------------------------------
Public Const STCAM_DISPLAY_MODE_GDI As Byte = &H00
Public Const STCAM_DISPLAY_MODE_GDI_HALFTONE As Byte = &H08
Public Const STCAM_DISPLAY_MODE_DD_OFFSCREEN As Byte = &H01
Public Const STCAM_DISPLAY_MODE_DD_OVERLAY As Byte = &H02
Public Const STCAM_DISPLAY_MODE_DD_OFFSCREEN_HQ As Byte = &H03
Public Const STCAM_DISPLAY_MODE_DD_OVERLAY_HQ As Byte = &H04
Public Const STCAM_DISPLAY_MODE_DIRECTX As Byte = &H05
Public Const STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON As Byte = &H06
Public Const STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON2 As Byte = &H07
Public Const STCAM_DISPLAY_MODE_DIRECTX_FPU As Byte = &H09
Public Const STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON_FPU As Byte = &H0A
Public Const STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON2_FPU As Byte = &H0B
'------------------------------------------------------------------------------
'TRUE_FALSE
'------------------------------------------------------------------------------
Public Const STCAM_TRUE As Long = &HFFFFFFFF&
Public Const STCAM_FALSE As Long = &H00000000&
'------------------------------------------------------------------------------
'CAMERA_SETTING
'------------------------------------------------------------------------------
Public Const STCAM_CAMERA_SETTING_INITIALIZE As Integer = &H8000
Public Const STCAM_CAMERA_SETTING_WRITE As Integer = &H2000
Public Const STCAM_CAMERA_SETTING_READ As Integer = &H1000
Public Const STCAM_CAMERA_SETTING_STANDARD As Integer = &H0800
Public Const STCAM_CAMERA_SETTING_DEFECT_PIXEL_POSITION As Integer = &H0400
'------------------------------------------------------------------------------
'DEFECT_PIXEL_CORRECTION
'------------------------------------------------------------------------------
Public Const STCAM_DEFECT_PIXEL_CORRECTION_OFF As Integer = &H0000
Public Const STCAM_DEFECT_PIXEL_CORRECTION_ON As Integer = &H0001
'------------------------------------------------------------------------------
'BINNING_SUM
'------------------------------------------------------------------------------
Public Const STCAM_BINNING_SUM_MODE_OFF As Integer = &H0000
Public Const STCAM_BINNING_SUM_MODE_H As Integer = &H0001
Public Const STCAM_BINNING_SUM_MODE_V As Integer = &H0100
'------------------------------------------------------------------------------
'AVI_FILE_FORMAT
'------------------------------------------------------------------------------
Public Const STCAM_AVI_FILE_FORMAT_AVI1 As Long = 0
Public Const STCAM_AVI_FILE_FORMAT_AVI2 As Long = 1
'------------------------------------------------------------------------------
'SHADING_CORRECTION_MODE
'------------------------------------------------------------------------------
Public Const STCAM_SHADING_CORRECTION_MODE_OFF As Long = &H0000&
Public Const STCAM_SHADING_CORRECTION_MODE_CALIBRATION_MULTIPLICATION As Long = &H0001&
Public Const STCAM_SHADING_CORRECTION_MODE_ON_MULTIPLICATION As Long = &H0002&
Public Const STCAM_SHADING_CORRECTION_MODE_CALIBRATION_ADDITION As Long = &H0003&
Public Const STCAM_SHADING_CORRECTION_MODE_ON_ADDITION As Long = &H0004&
'------------------------------------------------------------------------------
'CAMERA_FUNCTION
'------------------------------------------------------------------------------
Public Const STCAM_CAMERA_FUNCTION_AWB As Long = 24
Public Const STCAM_CAMERA_FUNCTION_AGC As Long = 25
Public Const STCAM_CAMERA_FUNCTION_AE As Long = 26
Public Const STCAM_CAMERA_FUNCTION_STORE_CAMERA_SETTING As Long = 59
Public Const STCAM_CAMERA_FUNCTION_ANALOG_BLACK_LEVEL As Long = &H00050006&
Public Const STCAM_CAMERA_FUNCTION_DISABLED_ANALOG_GAIN As Long = &H00090004&
Public Const STCAM_CAMERA_FUNCTION_AGC_GAIN_TYPE As Long = &H00090005&
Public Const STCAM_CAMERA_FUNCTION_DEVICE_TEMPERATURE_MAINBOARD As Long = &H00090009&
Public Const STCAM_CAMERA_FUNCTION_ADJUSTMENT_MODE_DIGITAL_GAIN As Long = &H0009000A&
'------------------------------------------------------------------------------
'ADJUSTMENT_MODE
'------------------------------------------------------------------------------
Public Const STCAM_ADJUSTMENT_MODE_DIGITAL_GAIN As Long = &H00000001&
'------------------------------------------------------------------------------
'DEVICE_TEMPERATURE
'------------------------------------------------------------------------------
Public Const STCAM_DEVICE_TEMPERATURE_MAINBOARD As Long = &H00000001&
'------------------------------------------------------------------------------
'HDR_TYPE
'------------------------------------------------------------------------------
Public Const STCAM_HDR_TYPE_CMOSIS_4M As Long = &H00000001&
'------------------------------------------------------------------------------
'PRIORITY_MODE
'------------------------------------------------------------------------------
Public Const STCAM_PRIORITY_MODE_IMAGE_QUALITY As Long = 0
Public Const STCAM_PRIORITY_MODE_FRAME_RATE As Long = 1
'------------------------------------------------------------------------------
'WINDOW_STYLE
'------------------------------------------------------------------------------
Public Const WS_OVERLAPPED As Long = &H00000000&
Public Const WS_POPUP As Long = &H80000000&
Public Const WS_CHILD As Long = &H40000000&
Public Const WS_MINIMIZE As Long = &H20000000&
Public Const WS_VISIBLE As Long = &H10000000&
Public Const WS_DISABLED As Long = &H08000000&
Public Const WS_CLIPSIBLINGS As Long = &H04000000&
Public Const WS_CLIPCHILDREN As Long = &H02000000&
Public Const WS_MAXIMIZE As Long = &H01000000&
Public Const WS_CAPTION As Long = &H00C00000&
Public Const WS_BORDER As Long = &H00800000&
Public Const WS_DLGFRAME As Long = &H00400000&
Public Const WS_VSCROLL As Long = &H00200000&
Public Const WS_HSCROLL As Long = &H00100000&
Public Const WS_SYSMENU As Long = &H00080000&
Public Const WS_THICKFRAME As Long = &H00040000&
Public Const WS_GROUP As Long = &H00020000&
Public Const WS_TABSTOP As Long = &H00010000&
Public Const WS_MINIMIZEBOX As Long = &H00020000&
Public Const WS_MAXIMIZEBOX As Long = &H00010000&
Public Const WS_OVERLAPPEDWINDOW As Long = &H00CF0000&
Public Const WS_POPUPWINDOW As Long = &H80880000&
Public Const WS_TILED As Long = &H00000000&
Public Const WS_ICONIC As Long = &H00020000&
Public Const WS_SIZEBOX As Long = &H00040000&
Public Const WS_TILEDWINDOW As Long = &H00CF0000&
Public Const WS_CHILDWINDOW As Long = &H40000000&

