'Created Date:2017/11/13 10:20
Imports System.Runtime.InteropServices
Public Class StCam
	Public Delegate Sub fStCamPreviewBitmapCallbackFunc(ByVal pbyteBitmap As IntPtr, ByVal dwBufferSize As Integer, ByVal dwWidth As Integer, ByVal dwHeight As Integer, ByVal dwFrameNo As Integer, ByVal dwPreviewPixelFormat As Integer, ByVal lpContext As IntPtr, ByVal lpReserved As IntPtr)
	Public Delegate Sub fStCamRawCallbackFunc(ByVal pbyteBuffer As IntPtr, ByVal dwBufferSize As Integer, ByVal dwWidth As Integer, ByVal dwHeight As Integer, ByVal dwFrameNo As Integer, ByVal wColorArray As Short, ByVal dwTransferBitsPerPixel As Integer, ByVal lpContext As IntPtr, ByVal lpReserved As IntPtr)
	Public Delegate Sub fStCamPreviewGDICallbackFunc(ByVal hDC As IntPtr, ByVal dwWidth As Integer, ByVal dwHeight As Integer, ByVal dwFrameNo As Integer, ByVal lpContext As IntPtr, ByVal lpReserved As IntPtr)
	
	'------------------------------------------------------------------------------
	'Initialize
	'------------------------------------------------------------------------------
	Public Declare Function Open Lib "StCamD.dll" Alias "StCam_Open" (ByVal dwInstance As integer) As IntPtr
	Public Declare Sub Close Lib "StCamD.dll" Alias "StCam_Close" (ByVal hCamera As IntPtr)
	Public Declare Function GetLastError Lib "StCamD.dll" Alias "StCam_GetLastError" (ByVal hCamera As IntPtr) As integer
	Public Declare Function CameraCount Lib "StCamD.dll" Alias "StCam_CameraCount" () As integer
	Public Declare Function SetReceiveMsgWindow Lib "StCamD.dll" Alias "StCam_SetReceiveMsgWindow" (ByVal hCamera As IntPtr, ByVal hWnd As IntPtr) As integer
	Public Declare Function GetUSBSpeed Lib "StCamD.dll" Alias "StCam_GetUSBSpeed" (ByVal hCamera As IntPtr, ByRef pbyteUSBSpeed As Byte) As integer
	Public Declare Function GetUSBMaxSpeed Lib "StCamD.dll" Alias "StCam_GetUSBMaxSpeed" (ByVal hCamera As IntPtr, ByRef pbyteUSBSpeed As Byte) As integer
	
	'------------------------------------------------------------------------------
	'Image Information
	'------------------------------------------------------------------------------
	Public Declare Function GetColorArray Lib "StCamD.dll" Alias "StCam_GetColorArray" (ByVal hCamera As IntPtr, ByRef pwColorArray As Short) As integer
	Public Declare Function GetEnableTransferBitsPerPixel Lib "StCamD.dll" Alias "StCam_GetEnableTransferBitsPerPixel" (ByVal hCamera As IntPtr, ByRef pdwEnableTransferBitsPerPixel As integer) As integer
	Public Declare Function SetTransferBitsPerPixel Lib "StCamD.dll" Alias "StCam_SetTransferBitsPerPixel" (ByVal hCamera As IntPtr, ByVal dwTransferBitsPerPixel As integer) As integer
	Public Declare Function GetTransferBitsPerPixel Lib "StCamD.dll" Alias "StCam_GetTransferBitsPerPixel" (ByVal hCamera As IntPtr, ByRef pdwTransferBitsPerPixel As integer) As integer
	Public Declare Function GetMaximumImageSize Lib "StCamD.dll" Alias "StCam_GetMaximumImageSize" (ByVal hCamera As IntPtr, ByRef pdwMaxWidth As integer, ByRef pdwMaxHeight As integer) As integer
	Public Declare Function GetEnableImageSize Lib "StCamD.dll" Alias "StCam_GetEnableImageSize" (ByVal hCamera As IntPtr, ByRef pdwReserved As integer, ByRef pwEnableScanMode As Short) As integer
	Public Declare Function SetImageSize Lib "StCamD.dll" Alias "StCam_SetImageSize" (ByVal hCamera As IntPtr, ByVal dwReserved As integer, ByVal wScanMode As Short, ByVal dwOffsetX As integer, ByVal dwOffsetY As integer, ByVal dwWidth As integer, ByVal dwHeight As integer) As integer
	Public Declare Function GetImageSize Lib "StCamD.dll" Alias "StCam_GetImageSize" (ByVal hCamera As IntPtr, ByRef pdwReserved As integer, ByRef pwScanMode As Short, ByRef pdwOffsetX As integer, ByRef pdwOffsetY As integer, ByRef pdwWidth As integer, ByRef pdwHeight As integer) As integer
	Public Declare Function GetSkippingAndBinning Lib "StCamD.dll" Alias "StCam_GetSkippingAndBinning" (ByVal hCamera As IntPtr, ByRef pbyteHSkipping As Byte, ByRef pbyteVSkipping As Byte, ByRef pbyteHBinning As Byte, ByRef pbyteVBinning As Byte) As integer
	Public Declare Function SetSkippingAndBinning Lib "StCamD.dll" Alias "StCam_SetSkippingAndBinning" (ByVal hCamera As IntPtr, ByVal byteHSkipping As Byte, ByVal byteVSkipping As Byte, ByVal byteHBinning As Byte, ByVal byteVBinning As Byte) As integer
	Public Declare Function GetBinningSumMode Lib "StCamD.dll" Alias "StCam_GetBinningSumMode" (ByVal hCamera As IntPtr, ByRef pwMode As Short) As integer
	Public Declare Function SetBinningSumMode Lib "StCamD.dll" Alias "StCam_SetBinningSumMode" (ByVal hCamera As IntPtr, ByVal wMode As Short) As integer
	Public Declare Function SetPriorityMode Lib "StCamD.dll" Alias "StCam_SetPriorityMode" (ByVal hCamera As IntPtr, ByVal dwPriorityMode As integer) As integer
	Public Declare Function GetPriorityMode Lib "StCamD.dll" Alias "StCam_GetPriorityMode" (ByVal hCamera As IntPtr, ByRef pdwPriorityMode As integer) As integer
	
	'------------------------------------------------------------------------------
	'Preview
	'------------------------------------------------------------------------------
	Public Declare Function StartTransfer Lib "StCamD.dll" Alias "StCam_StartTransfer" (ByVal hCamera As IntPtr) As integer
	Public Declare Function StopTransfer Lib "StCamD.dll" Alias "StCam_StopTransfer" (ByVal hCamera As IntPtr) As integer
	Public Declare Function SetPreviewPixelFormat Lib "StCamD.dll" Alias "StCam_SetPreviewPixelFormat" (ByVal hCamera As IntPtr, ByVal dwPreviewPixelFormat As integer) As integer
	Public Declare Function GetPreviewPixelFormat Lib "StCamD.dll" Alias "StCam_GetPreviewPixelFormat" (ByVal hCamera As IntPtr, ByRef pdwPreviewPixelFormat As integer) As integer
	Public Declare Function GetEnablePreviewPixelFormat Lib "StCamD.dll" Alias "StCam_GetEnablePreviewPixelFormat" (ByVal hCamera As IntPtr, ByRef pdwEnablePreviewPixelFormat As integer) As integer
	Public Declare Function SetColorInterpolationMethod Lib "StCamD.dll" Alias "StCam_SetColorInterpolationMethod" (ByVal hCamera As IntPtr, ByVal byteColorInterpolationMethod As Byte) As integer
	Public Declare Function GetColorInterpolationMethod Lib "StCamD.dll" Alias "StCam_GetColorInterpolationMethod" (ByVal hCamera As IntPtr, ByRef pbyteColorInterpolationMethod As Byte) As integer
	Public Declare Function CreatePreviewWindowA Lib "StCamD.dll" Alias "StCam_CreatePreviewWindowA" (ByVal hCamera As IntPtr, ByVal pszWindowName As String, ByVal dwStyle As integer, ByVal lngPositionX As integer, ByVal lngPositionY As integer, ByVal dwWidth As integer, ByVal dwHeight As integer, ByVal hWndParent As IntPtr, ByVal hMenu As IntPtr, ByVal bCloseEnable As integer) As integer
	Public Declare Function CreatePreviewWindowW Lib "StCamD.dll" Alias "StCam_CreatePreviewWindowW" (ByVal hCamera As IntPtr, ByVal pszWindowName As String, ByVal dwStyle As integer, ByVal lngPositionX As integer, ByVal lngPositionY As integer, ByVal dwWidth As integer, ByVal dwHeight As integer, ByVal hWndParent As IntPtr, ByVal hMenu As IntPtr, ByVal bCloseEnable As integer) As integer
	Public Declare Auto Function CreatePreviewWindow Lib "StCamD.dll" Alias "StCam_CreatePreviewWindow" (ByVal hCamera As IntPtr, ByVal pszWindowName As String, ByVal dwStyle As integer, ByVal lngPositionX As integer, ByVal lngPositionY As integer, ByVal dwWidth As integer, ByVal dwHeight As integer, ByVal hWndParent As IntPtr, ByVal hMenu As IntPtr, ByVal bCloseEnable As integer) As integer
	Public Declare Function DestroyPreviewWindow Lib "StCamD.dll" Alias "StCam_DestroyPreviewWindow" (ByVal hCamera As IntPtr) As integer
	Public Declare Function SetPreviewWindowNameA Lib "StCamD.dll" Alias "StCam_SetPreviewWindowNameA" (ByVal hCamera As IntPtr, ByVal pszWindowName As String) As integer
	Public Declare Function GetPreviewWindowNameA Lib "StCamD.dll" Alias "StCam_GetPreviewWindowNameA" (ByVal hCamera As IntPtr, ByVal pszWindowName As System.Text.StringBuilder, ByVal lngMaxCount As integer) As integer
	Public Declare Function SetPreviewWindowNameW Lib "StCamD.dll" Alias "StCam_SetPreviewWindowNameW" (ByVal hCamera As IntPtr, ByVal pszWindowName As String) As integer
	Public Declare Auto Function SetPreviewWindowName Lib "StCamD.dll" Alias "StCam_SetPreviewWindowName" (ByVal hCamera As IntPtr, ByVal pszWindowName As String) As integer
	Public Declare Function GetPreviewWindowNameW Lib "StCamD.dll" Alias "StCam_GetPreviewWindowNameW" (ByVal hCamera As IntPtr, ByVal pszWindowName As System.Text.StringBuilder, ByVal lngMaxCount As integer) As integer
	Public Declare Auto Function GetPreviewWindowName Lib "StCamD.dll" Alias "StCam_GetPreviewWindowName" (ByVal hCamera As IntPtr, ByVal pszWindowName As System.Text.StringBuilder, ByVal lngMaxCount As integer) As integer
	Public Declare Function SetPreviewMaskSize Lib "StCamD.dll" Alias "StCam_SetPreviewMaskSize" (ByVal hCamera As IntPtr, ByVal dwOffsetX As integer, ByVal dwOffsetY As integer, ByVal dwWidth As integer, ByVal dwHeight As integer) As integer
	Public Declare Function GetPreviewMaskSize Lib "StCamD.dll" Alias "StCam_GetPreviewMaskSize" (ByVal hCamera As IntPtr, ByRef pdwOffsetX As integer, ByRef pdwOffsetY As integer, ByRef pdwWidth As integer, ByRef pdwHeight As integer) As integer
	Public Declare Function SetPreviewWindowSize Lib "StCamD.dll" Alias "StCam_SetPreviewWindowSize" (ByVal hCamera As IntPtr, ByVal lngPositionX As integer, ByVal lngPositionY As integer, ByVal dwWidth As integer, ByVal dwHeight As integer) As integer
	Public Declare Function GetPreviewWindowSize Lib "StCamD.dll" Alias "StCam_GetPreviewWindowSize" (ByVal hCamera As IntPtr, ByRef plngPositionX As integer, ByRef plngPositionY As integer, ByRef pdwWidth As integer, ByRef pdwHeight As integer) As integer
	Public Declare Function SetPreviewWindowStyle Lib "StCamD.dll" Alias "StCam_SetPreviewWindowStyle" (ByVal hCamera As IntPtr, ByVal dwStyle As integer) As integer
	Public Declare Function GetPreviewWindowStyle Lib "StCamD.dll" Alias "StCam_GetPreviewWindowStyle" (ByVal hCamera As IntPtr, ByRef pdwStyle As integer) As integer
	Public Declare Function SetAspectMode Lib "StCamD.dll" Alias "StCam_SetAspectMode" (ByVal hCamera As IntPtr, ByVal byteAspectMode As Byte) As integer
	Public Declare Function GetAspectMode Lib "StCamD.dll" Alias "StCam_GetAspectMode" (ByVal hCamera As IntPtr, ByRef pbyteAspectMode As Byte) As integer
	Public Declare Function SetPreviewDestSize Lib "StCamD.dll" Alias "StCam_SetPreviewDestSize" (ByVal hCamera As IntPtr, ByVal dwOffsetX As integer, ByVal dwOffsetY As integer, ByVal dwWidth As integer, ByVal dwHeight As integer) As integer
	Public Declare Function GetPreviewDestSize Lib "StCamD.dll" Alias "StCam_GetPreviewDestSize" (ByVal hCamera As IntPtr, ByRef pdwOffsetX As integer, ByRef pdwOffsetY As integer, ByRef pdwWidth As integer, ByRef pdwHeight As integer) As integer
	Public Declare Function SetMagnificationMode Lib "StCamD.dll" Alias "StCam_SetMagnificationMode" (ByVal hCamera As IntPtr, ByVal byteMagnificationMode As Byte) As integer
	Public Declare Function GetMagnificationMode Lib "StCamD.dll" Alias "StCam_GetMagnificationMode" (ByVal hCamera As IntPtr, ByRef pbyteMagnificationMode As Byte) As integer
	Public Declare Function GetDCWithReset Lib "StCamD.dll" Alias "StCam_GetDCWithReset" (ByVal hCamera As IntPtr, ByRef phDC As IntPtr) As integer
	Public Declare Function GetDC Lib "StCamD.dll" Alias "StCam_GetDC" (ByVal hCamera As IntPtr, ByRef phDC As IntPtr) As integer
	Public Declare Function ReleaseDC Lib "StCamD.dll" Alias "StCam_ReleaseDC" (ByVal hCamera As IntPtr, ByVal hDC As IntPtr) As integer
	Public Declare Function ResetOverlay Lib "StCamD.dll" Alias "StCam_ResetOverlay" (ByVal hCamera As IntPtr) As integer
	Public Declare Function SetColorKey Lib "StCamD.dll" Alias "StCam_SetColorKey" (ByVal hCamera As IntPtr, ByVal dwColorKey As integer) As integer
	Public Declare Function GetColorKey Lib "StCamD.dll" Alias "StCam_GetColorKey" (ByVal hCamera As IntPtr, ByRef pdwColorKey As integer) As integer
	Public Declare Function SetDisplayMode Lib "StCamD.dll" Alias "StCam_SetDisplayMode" (ByVal hCamera As IntPtr, ByVal byteDisplayMode As Byte) As integer
	Public Declare Function GetDisplayMode Lib "StCamD.dll" Alias "StCam_GetDisplayMode" (ByVal hCamera As IntPtr, ByRef pbyteDisplayMode As Byte) As integer
	Public Declare Function GetAlphaChannel Lib "StCamD.dll" Alias "StCam_GetAlphaChannel" (ByVal hCamera As IntPtr, ByRef pbyteAlphaChannel As Byte) As integer
	Public Declare Function SetAlphaChannel Lib "StCamD.dll" Alias "StCam_SetAlphaChannel" (ByVal hCamera As IntPtr, ByVal byteAlphaChannel As Byte) As integer
	Public Declare Function GetPreviewImagePixelValue Lib "StCamD.dll" Alias "StCam_GetPreviewImagePixelValue" (ByVal hCamera As IntPtr, ByVal nX As integer, ByVal nY As integer, ByRef pdwColor As integer) As integer
	Public Declare Function GetPreviewWnd Lib "StCamD.dll" Alias "StCam_GetPreviewWnd" (ByVal hCamera As IntPtr, ByRef hWnd As IntPtr) As integer
	
	'------------------------------------------------------------------------------
	'Image Acquisition
	'------------------------------------------------------------------------------
	Public Declare Function TakeRawSnapShot Lib "StCamD.dll" Alias "StCam_TakeRawSnapShot" (ByVal hCamera As IntPtr,  pbyteBuffer As IntPtr, ByVal dwBufferSize As integer, ByRef pdwNumberOfByteTrans As integer, byval pdwFrameNo() As integer, ByVal dwMilliseconds As integer) As integer
	Public Declare Function TakePreviewSnapShot Lib "StCamD.dll" Alias "StCam_TakePreviewSnapShot" (ByVal hCamera As IntPtr,  pbyteBuffer As IntPtr, ByVal dwBufferSize As integer, ByRef pdwNumberOfByteTrans As integer, byval pdwFrameNo() As integer, ByVal dwMilliseconds As integer) As integer
	Public Declare Function SaveImageA Lib "StCamD.dll" Alias "StCam_SaveImageA" (ByVal hCamera As IntPtr, ByVal dwWidth As integer, ByVal dwHeight As integer, ByVal dwPreviewPixelFormat As integer,  pbyteData As IntPtr, ByVal pszFileName As String, ByVal dwParam As integer) As integer
	Public Declare Function SaveImageW Lib "StCamD.dll" Alias "StCam_SaveImageW" (ByVal hCamera As IntPtr, ByVal dwWidth As integer, ByVal dwHeight As integer, ByVal dwPreviewPixelFormat As integer,  pbyteData As IntPtr, ByVal pszFileName As String, ByVal dwParam As integer) As integer
	Public Declare Auto Function SaveImage Lib "StCamD.dll" Alias "StCam_SaveImage" (ByVal hCamera As IntPtr, ByVal dwWidth As integer, ByVal dwHeight As integer, ByVal dwPreviewPixelFormat As integer,  pbyteData As IntPtr, ByVal pszFileName As String, ByVal dwParam As integer) As integer
	Public Declare Function GetRawDataSize Lib "StCamD.dll" Alias "StCam_GetRawDataSize" (ByVal hCamera As IntPtr, ByRef pdwSize As integer) As integer
	Public Declare Function GetPreviewDataSize Lib "StCamD.dll" Alias "StCam_GetPreviewDataSize" (ByVal hCamera As IntPtr, ByRef pdwSize As integer, ByRef pdwWidth As integer, ByRef pdwHeight As integer, ByRef pdwLinePitch As integer) As integer
	Public Declare Function SetROI Lib "StCamD.dll" Alias "StCam_SetROI" (ByVal hCamera As IntPtr, ByVal dwIndex As integer, ByVal dwMode As integer, ByVal dwOffsetX As integer, ByVal dwOffsetY As integer, ByVal dwWidth As integer, ByVal dwHeight As integer) As integer
	Public Declare Function GetROI Lib "StCamD.dll" Alias "StCam_GetROI" (ByVal hCamera As IntPtr, ByVal dwIndex As integer, ByRef pdwMode As integer, ByRef pdwOffsetX As integer, ByRef pdwOffsetY As integer, ByRef pdwWidth As integer, ByRef pdwHeight As integer) As integer
	Public Declare Function GetMaxROICount Lib "StCamD.dll" Alias "StCam_GetMaxROICount" (ByVal hCamera As IntPtr, ByRef pdwRegionCount As integer) As integer
	
	'------------------------------------------------------------------------------
	'Shutter Gain Control
	'------------------------------------------------------------------------------
	Public Declare Function GetALCMode Lib "StCamD.dll" Alias "StCam_GetALCMode" (ByVal hCamera As IntPtr, ByRef pbyteAlcMode As Byte) As integer
	Public Declare Function SetALCMode Lib "StCamD.dll" Alias "StCam_SetALCMode" (ByVal hCamera As IntPtr, ByVal byteAlcMode As Byte) As integer
	Public Declare Function GetExposureClock Lib "StCamD.dll" Alias "StCam_GetExposureClock" (ByVal hCamera As IntPtr, ByRef pdwExposureClock As integer) As integer
	Public Declare Function SetExposureClock Lib "StCamD.dll" Alias "StCam_SetExposureClock" (ByVal hCamera As IntPtr, ByVal dwExposureClock As integer) As integer
	Public Declare Function GetMaxShortExposureClock Lib "StCamD.dll" Alias "StCam_GetMaxShortExposureClock" (ByVal hCamera As IntPtr, ByRef pdwMaximumExpClock As integer) As integer
	Public Declare Function GetMaxLongExposureClock Lib "StCamD.dll" Alias "StCam_GetMaxLongExposureClock" (ByVal hCamera As IntPtr, ByRef pdwMaximumExpClock As integer) As integer
	Public Declare Function GetExposureTimeFromClock Lib "StCamD.dll" Alias "StCam_GetExposureTimeFromClock" (ByVal hCamera As IntPtr, ByVal dwExposureClock As integer, ByRef pfExpTime As Single) As integer
	Public Declare Function GetExposureClockFromTime Lib "StCamD.dll" Alias "StCam_GetExposureClockFromTime" (ByVal hCamera As IntPtr, ByVal fExpTime As Single, ByRef pdwExposureClock As integer) As integer
	Public Declare Function GetGain Lib "StCamD.dll" Alias "StCam_GetGain" (ByVal hCamera As IntPtr, ByRef pwGain As Short) As integer
	Public Declare Function SetGain Lib "StCamD.dll" Alias "StCam_SetGain" (ByVal hCamera As IntPtr, ByVal wGain As Short) As integer
	Public Declare Function GetMaxGain Lib "StCamD.dll" Alias "StCam_GetMaxGain" (ByVal hCamera As IntPtr, ByRef pwMaxGain As Short) As integer
	Public Declare Function GetGainDBFromSettingValue Lib "StCamD.dll" Alias "StCam_GetGainDBFromSettingValue" (ByVal hCamera As IntPtr, ByVal wGain As Short, ByRef pfGainDB As Single) As integer
	Public Declare Function GetTargetBrightness Lib "StCamD.dll" Alias "StCam_GetTargetBrightness" (ByVal hCamera As IntPtr, ByRef pbyteTargetBrightness As Byte, ByRef pbyteTolerance As Byte, ByRef pbyteThreshold As Byte) As integer
	Public Declare Function SetTargetBrightness Lib "StCamD.dll" Alias "StCam_SetTargetBrightness" (ByVal hCamera As IntPtr, ByVal byteTargetBrightness As Byte, ByVal byteTolerance As Byte, ByVal byteThreshold As Byte) As integer
	Public Declare Function GetALCWeight Lib "StCamD.dll" Alias "StCam_GetALCWeight" (ByVal hCamera As IntPtr, byval pbyteALCWeight() As Byte) As integer
	Public Declare Function SetALCWeight Lib "StCamD.dll" Alias "StCam_SetALCWeight" (ByVal hCamera As IntPtr, byval pbyteALCWeight() As Byte) As integer
	Public Declare Function SetAEMinExposureClock Lib "StCamD.dll" Alias "StCam_SetAEMinExposureClock" (ByVal hCamera As IntPtr, ByVal dwMinExposureClock As integer) As integer
	Public Declare Function GetAEMinExposureClock Lib "StCamD.dll" Alias "StCam_GetAEMinExposureClock" (ByVal hCamera As IntPtr, ByRef pdwMinExposureClock As integer) As integer
	Public Declare Function GetAEMaxExposureClock Lib "StCamD.dll" Alias "StCam_GetAEMaxExposureClock" (ByVal hCamera As IntPtr, ByRef pdwMaxExposureClock As integer) As integer
	Public Declare Function SetAEMaxExposureClock Lib "StCamD.dll" Alias "StCam_SetAEMaxExposureClock" (ByVal hCamera As IntPtr, ByVal dwMaxExposureClock As integer) As integer
	Public Declare Function SetALCControlSpeed Lib "StCamD.dll" Alias "StCam_SetALCControlSpeed" (ByVal hCamera As IntPtr, ByVal byteShutterCtrlSpeedLimit As Byte, ByVal byteGainCtrlSpeedLimit As Byte, ByVal byteSkipFrameCount As Byte, ByVal byteAverageFrameCount As Byte) As integer
	Public Declare Function GetALCControlSpeed Lib "StCamD.dll" Alias "StCam_GetALCControlSpeed" (ByVal hCamera As IntPtr, ByRef pbyteShutterCtrlSpeedLimit As Byte, ByRef pbyteGainCtrlSpeedLimit As Byte, ByRef pbyteSkipFrameCount As Byte, ByRef pbyteAverageFrameCount As Byte) As integer
	Public Declare Function GetGainControlRange Lib "StCamD.dll" Alias "StCam_GetGainControlRange" (ByVal hCamera As IntPtr, ByRef pwMinGain As Short, ByRef pwMaxGain As Short) As integer
	Public Declare Function SetGainControlRange Lib "StCamD.dll" Alias "StCam_SetGainControlRange" (ByVal hCamera As IntPtr, ByVal wMinGain As Short, ByVal wMaxGain As Short) As integer
	Public Declare Function GetDigitalGain Lib "StCamD.dll" Alias "StCam_GetDigitalGain" (ByVal hCamera As IntPtr, ByRef pwDigitalGain As Short) As integer
	Public Declare Function SetDigitalGain Lib "StCamD.dll" Alias "StCam_SetDigitalGain" (ByVal hCamera As IntPtr, ByVal wDigitalGain As Short) As integer
	Public Declare Function GetMaxDigitalGain Lib "StCamD.dll" Alias "StCam_GetMaxDigitalGain" (ByVal hCamera As IntPtr, ByRef pwMaxDigitalGain As Short) As integer
	Public Declare Function GetDigitalGainTimesFromSettingValue Lib "StCamD.dll" Alias "StCam_GetDigitalGainTimesFromSettingValue" (ByVal hCamera As IntPtr, ByVal wDigitalGain As Short, ByRef pfDigitalGainTimes As Single) As integer
	Public Declare Function GetDigitalGainSettingValueFromGainTimes Lib "StCamD.dll" Alias "StCam_GetDigitalGainSettingValueFromGainTimes" (ByVal hCamera As IntPtr, ByVal fDigitalGainTimes As Single, ByRef pwDigitalGain As Short) As integer
	Public Declare Function GetShutterSpeed Lib "StCamD.dll" Alias "StCam_GetShutterSpeed" (ByVal hCamera As IntPtr, ByRef pwShutterLine As Short, ByRef pwShutterClock As Short) As integer
	Public Declare Function SetShutterSpeed Lib "StCamD.dll" Alias "StCam_SetShutterSpeed" (ByVal hCamera As IntPtr, ByVal wShutterLine As Short, ByVal wShutterClock As Short) As integer
	Public Declare Function GetShutterControlRange Lib "StCamD.dll" Alias "StCam_GetShutterControlRange" (ByVal hCamera As IntPtr, ByRef pwMinShutterLine As Short, ByRef pwMinShutterClock As Short, ByRef pwMaxShutterLine As Short, ByRef pwMaxShutterClock As Short) As integer
	Public Declare Function SetShutterControlRange Lib "StCamD.dll" Alias "StCam_SetShutterControlRange" (ByVal hCamera As IntPtr, ByVal wMinShutterLine As Short, ByVal wMinShutterClock As Short, ByVal wMaxShutterLine As Short, ByVal wMaxShutterClock As Short) As integer
	
	'------------------------------------------------------------------------------
	'White Balance Control
	'------------------------------------------------------------------------------
	Public Declare Function SetWhiteBalanceMode Lib "StCamD.dll" Alias "StCam_SetWhiteBalanceMode" (ByVal hCamera As IntPtr, ByVal byteWBMode As Byte) As integer
	Public Declare Function GetWhiteBalanceMode Lib "StCamD.dll" Alias "StCam_GetWhiteBalanceMode" (ByVal hCamera As IntPtr, ByRef pbyteWBMode As Byte) As integer
	Public Declare Function SetWhiteBalanceGain Lib "StCamD.dll" Alias "StCam_SetWhiteBalanceGain" (ByVal hCamera As IntPtr, ByVal wWBGainR As Short, ByVal wWBGainGr As Short, ByVal wWBGainGb As Short, ByVal wWBGainB As Short) As integer
	Public Declare Function GetWhiteBalanceGain Lib "StCamD.dll" Alias "StCam_GetWhiteBalanceGain" (ByVal hCamera As IntPtr, ByRef pwWBGainR As Short, ByRef pwWBGainGr As Short, ByRef pwWBGainGb As Short, ByRef pwWBGainB As Short) As integer
	Public Declare Function SetWhiteBalanceTarget Lib "StCamD.dll" Alias "StCam_SetWhiteBalanceTarget" (ByVal hCamera As IntPtr, ByVal wAWBTargetR As Short, ByVal wAWBTargetB As Short) As integer
	Public Declare Function GetWhiteBalanceTarget Lib "StCamD.dll" Alias "StCam_GetWhiteBalanceTarget" (ByVal hCamera As IntPtr, ByRef pwAWBTargetR As Short, ByRef pwAWBTargetB As Short) As integer
	Public Declare Function SetWhiteBalanceToleranceThreshold Lib "StCamD.dll" Alias "StCam_SetWhiteBalanceToleranceThreshold" (ByVal hCamera As IntPtr, ByVal wAWBTolerance As Short, ByVal wAWBThreshold As Short) As integer
	Public Declare Function GetWhiteBalanceToleranceThreshold Lib "StCamD.dll" Alias "StCam_GetWhiteBalanceToleranceThreshold" (ByVal hCamera As IntPtr, ByRef pwAWBTolerance As Short, ByRef pwAWBThreshold As Short) As integer
	Public Declare Function SetAWBWeight Lib "StCamD.dll" Alias "StCam_SetAWBWeight" (ByVal hCamera As IntPtr, byval pbyteAWBWeight() As Byte) As integer
	Public Declare Function GetAWBWeight Lib "StCamD.dll" Alias "StCam_GetAWBWeight" (ByVal hCamera As IntPtr, byval pbyteAWBWeight() As Byte) As integer
	Public Declare Function RawWhiteBalance Lib "StCamD.dll" Alias "StCam_RawWhiteBalance" (ByVal hCamera As IntPtr, ByVal dwWidth As integer, ByVal dwHeight As integer, ByVal wColorArray As Short,  pbyteRaw As IntPtr) As integer
	
	'------------------------------------------------------------------------------
	'Gamma
	'------------------------------------------------------------------------------
	Public Declare Function SetGammaMode Lib "StCamD.dll" Alias "StCam_SetGammaMode" (ByVal hCamera As IntPtr, ByVal byteGammaTarget As Byte, ByVal byteGammaMode As Byte, ByVal wGamma As Short, byval pbyteGammaTable() As Byte) As integer
	Public Declare Function GetGammaMode Lib "StCamD.dll" Alias "StCam_GetGammaMode" (ByVal hCamera As IntPtr, ByVal byteGammaTarget As Byte, ByRef pbyteGammaMode As Byte, ByRef pwGamma As Short, byval pbyteGammaTable() As Byte) As integer
	Public Declare Function SetGammaModeEx Lib "StCamD.dll" Alias "StCam_SetGammaModeEx" (ByVal hCamera As IntPtr, ByVal byteGammaTarget As Byte, ByVal byteGammaMode As Byte, ByVal wGamma As Short, ByVal shtBrightness As Short, ByVal byteContrast As Byte, byval pbyteGammaTable() As Byte) As integer
	Public Declare Function GetGammaModeEx Lib "StCamD.dll" Alias "StCam_GetGammaModeEx" (ByVal hCamera As IntPtr, ByVal byteGammaTarget As Byte, ByRef pbyteGammaMode As Byte, ByRef pwGamma As Short, ByRef pshtBrightness As Short, ByRef pbyteContrast As Byte, byval pbyteGammaTable() As Byte) As integer
	Public Declare Function GetCameraGammaValue Lib "StCamD.dll" Alias "StCam_GetCameraGammaValue" (ByVal hCamera As IntPtr, ByRef pwValue As Short) As integer
	Public Declare Function SetCameraGammaValue Lib "StCamD.dll" Alias "StCam_SetCameraGammaValue" (ByVal hCamera As IntPtr, ByVal wValue As Short) As integer
	
	'------------------------------------------------------------------------------
	'Sharpness
	'------------------------------------------------------------------------------
	Public Declare Function SetSharpnessMode Lib "StCamD.dll" Alias "StCam_SetSharpnessMode" (ByVal hCamera As IntPtr, ByVal byteSharpnessMode As Byte, ByVal wSharpnessGain As Short, ByVal byteSharpnessCoring As Byte) As integer
	Public Declare Function GetSharpnessMode Lib "StCamD.dll" Alias "StCam_GetSharpnessMode" (ByVal hCamera As IntPtr, ByRef pbyteSharpnessMode As Byte, ByRef pwSharpnessGain As Short, ByRef pbyteSharpnessCoring As Byte) As integer
	
	'------------------------------------------------------------------------------
	'Hue Saturation
	'------------------------------------------------------------------------------
	Public Declare Function SetHueSaturationMode Lib "StCamD.dll" Alias "StCam_SetHueSaturationMode" (ByVal hCamera As IntPtr, ByVal byteHueSaturationMode As Byte, ByVal shtHue As Short, ByVal wSaturation As Short) As integer
	Public Declare Function GetHueSaturationMode Lib "StCamD.dll" Alias "StCam_GetHueSaturationMode" (ByVal hCamera As IntPtr, ByRef pbyteHueSaturationMode As Byte, ByRef pshtHue As Short, ByRef pwSaturation As Short) As integer
	
	'------------------------------------------------------------------------------
	'Color Matrix
	'------------------------------------------------------------------------------
	Public Declare Function SetColorMatrix Lib "StCamD.dll" Alias "StCam_SetColorMatrix" (ByVal hCamera As IntPtr, ByVal byteColorMatrixMode As Byte, byval pshtColorMatrix() As Short) As integer
	Public Declare Function GetColorMatrix Lib "StCamD.dll" Alias "StCam_GetColorMatrix" (ByVal hCamera As IntPtr, ByRef pbyteColorMatrixMode As Byte, byval pshtColorMatrix() As Short) As integer
	Public Declare Function SetHighChromaSuppression Lib "StCamD.dll" Alias "StCam_SetHighChromaSuppression" (ByVal hCamera As IntPtr, ByVal wStartLevel As Short, ByVal wSuppression As Short) As integer
	Public Declare Function SetLowChromaSuppression Lib "StCamD.dll" Alias "StCam_SetLowChromaSuppression" (ByVal hCamera As IntPtr, ByVal wStartLevel As Short, ByVal wSuppression As Short) As integer
	Public Declare Function GetHighChromaSuppression Lib "StCamD.dll" Alias "StCam_GetHighChromaSuppression" (ByVal hCamera As IntPtr, ByRef pwStartLevel As Short, ByRef pwSuppression As Short) As integer
	Public Declare Function GetLowChromaSuppression Lib "StCamD.dll" Alias "StCam_GetLowChromaSuppression" (ByVal hCamera As IntPtr, ByRef pwStartLevel As Short, ByRef pwSuppression As Short) As integer
	Public Declare Function SetChromaSuppression Lib "StCamD.dll" Alias "StCam_SetChromaSuppression" (ByVal hCamera As IntPtr, ByVal wStartLevel As Short, ByVal wSuppression As Short) As integer
	Public Declare Function GetChromaSuppression Lib "StCamD.dll" Alias "StCam_GetChromaSuppression" (ByVal hCamera As IntPtr, ByRef pwStartLevel As Short, ByRef pwSuppression As Short) As integer
	
	'------------------------------------------------------------------------------
	'Shading Correction
	'------------------------------------------------------------------------------
	Public Declare Function SetShadingCorrectionMode Lib "StCamD.dll" Alias "StCam_SetShadingCorrectionMode" (ByVal hCamera As IntPtr, ByVal dwMode As integer) As integer
	Public Declare Function GetShadingCorrectionMode Lib "StCamD.dll" Alias "StCam_GetShadingCorrectionMode" (ByVal hCamera As IntPtr, ByRef pdwMode As integer) As integer
	Public Declare Function SetShadingCorrectionTarget Lib "StCamD.dll" Alias "StCam_SetShadingCorrectionTarget" (ByVal hCamera As IntPtr, ByVal wTarget As Short) As integer
	Public Declare Function GetShadingCorrectionTarget Lib "StCamD.dll" Alias "StCam_GetShadingCorrectionTarget" (ByVal hCamera As IntPtr, ByRef wTarget As Short) As integer
	
	'------------------------------------------------------------------------------
	'Mirro Rotation
	'------------------------------------------------------------------------------
	Public Declare Function GetEnableMirrorMode Lib "StCamD.dll" Alias "StCam_GetEnableMirrorMode" (ByVal hCamera As IntPtr, ByRef pbyteMirrorMode As Byte) As integer
	Public Declare Function SetMirrorMode Lib "StCamD.dll" Alias "StCam_SetMirrorMode" (ByVal hCamera As IntPtr, ByVal byteMirrorMode As Byte) As integer
	Public Declare Function GetMirrorMode Lib "StCamD.dll" Alias "StCam_GetMirrorMode" (ByVal hCamera As IntPtr, ByRef pbyteMirrorMode As Byte) As integer
	Public Declare Function SetRotationMode Lib "StCamD.dll" Alias "StCam_SetRotationMode" (ByVal hCamera As IntPtr, ByVal byteRotationMode As Byte) As integer
	Public Declare Function GetRotationMode Lib "StCamD.dll" Alias "StCam_GetRotationMode" (ByVal hCamera As IntPtr, ByRef pbyteRotationMode As Byte) As integer
	
	'------------------------------------------------------------------------------
	'Movie
	'------------------------------------------------------------------------------
	Public Declare Function SaveAVIA Lib "StCamD.dll" Alias "StCam_SaveAVIA" (ByVal hCamera As IntPtr, ByVal pszFileName As String, ByVal dwCompressor As integer, ByVal dwLength As integer, ByVal lpReserved As IntPtr) As integer
	Public Declare Function SaveAVIW Lib "StCamD.dll" Alias "StCam_SaveAVIW" (ByVal hCamera As IntPtr, ByVal pszFileName As String, ByVal dwCompressor As integer, ByVal dwLength As integer, ByVal lpReserved As IntPtr) As integer
	Public Declare Auto Function SaveAVI Lib "StCamD.dll" Alias "StCam_SaveAVI" (ByVal hCamera As IntPtr, ByVal pszFileName As String, ByVal dwCompressor As integer, ByVal dwLength As integer, ByVal lpReserved As IntPtr) As integer
	Public Declare Function SetAVIStatus Lib "StCamD.dll" Alias "StCam_SetAVIStatus" (ByVal hCamera As IntPtr, ByVal byteAVIStatus As Byte) As integer
	Public Declare Function GetAVIStatus Lib "StCamD.dll" Alias "StCam_GetAVIStatus" (ByVal hCamera As IntPtr, ByRef pbyteAVIStatus As Byte, ByRef pdwTotalFrameCounts As integer, ByRef pdwCurrentFrameCounts As integer) As integer
	Public Declare Function SetAVIQuality Lib "StCamD.dll" Alias "StCam_SetAVIQuality" (ByVal hCamera As IntPtr, ByVal dwQuality As integer) As integer
	Public Declare Function GetAVIQuality Lib "StCamD.dll" Alias "StCam_GetAVIQuality" (ByVal hCamera As IntPtr, ByRef pdwQuality As integer) As integer
	Public Declare Function SetAVIPriorityFileFormat Lib "StCamD.dll" Alias "StCam_SetAVIPriorityFileFormat" (ByVal hCamera As IntPtr, ByVal dwFileFormat As integer) As integer
	Public Declare Function GetAVIPriorityFileFormat Lib "StCamD.dll" Alias "StCam_GetAVIPriorityFileFormat" (ByVal hCamera As IntPtr, ByRef pdwFileFormat As integer) As integer
	
	'------------------------------------------------------------------------------
	'Clock
	'------------------------------------------------------------------------------
	Public Declare Function GetEnableClock Lib "StCamD.dll" Alias "StCam_GetEnableClock" (ByVal hCamera As IntPtr, ByRef pdwEnableClockMode As integer, ByRef pdwStandardClock As integer, ByRef pdwMinimumClock As integer, ByRef pdwMaximumClock As integer) As integer
	Public Declare Function SetClock Lib "StCamD.dll" Alias "StCam_SetClock" (ByVal hCamera As IntPtr, ByVal dwClockMode As integer, ByVal dwClock As integer) As integer
	Public Declare Function GetClock Lib "StCamD.dll" Alias "StCam_GetClock" (ByVal hCamera As IntPtr, ByRef pdwClockMode As integer, ByRef pdwClock As integer) As integer
	Public Declare Function GetFrameClock Lib "StCamD.dll" Alias "StCam_GetFrameClock" (ByVal hCamera As IntPtr, ByRef pwCurrentLinePerFrame As Short, ByRef pwCurrentClockPerLine As Short) As integer
	Public Declare Function GetOutputFPS Lib "StCamD.dll" Alias "StCam_GetOutputFPS" (ByVal hCamera As IntPtr, ByRef pfFPS As Single) As integer
	Public Declare Function SetVBlankForFPS Lib "StCamD.dll" Alias "StCam_SetVBlankForFPS" (ByVal hCamera As IntPtr, ByVal dwVLines As integer) As integer
	Public Declare Function GetVBlankForFPS Lib "StCamD.dll" Alias "StCam_GetVBlankForFPS" (ByVal hCamera As IntPtr, ByRef pdwVLines As integer) As integer
	Public Declare Function GetMaxVBlankForFPS Lib "StCamD.dll" Alias "StCam_GetMaxVBlankForFPS" (ByVal hCamera As IntPtr, ByRef pdwVLines As integer) As integer
	
	'------------------------------------------------------------------------------
	'IOPin
	'------------------------------------------------------------------------------
	Public Declare Function GetDeviceTemperature Lib "StCamD.dll" Alias "StCam_GetDeviceTemperature" (ByVal hCamera As IntPtr, ByVal dwSelector As integer, ByRef pnValue As integer) As integer
	
	'------------------------------------------------------------------------------
	'Defect pixel correction
	'------------------------------------------------------------------------------
	Public Declare Function GetEnableDefectPixelCorrectionCount Lib "StCamD.dll" Alias "StCam_GetEnableDefectPixelCorrectionCount" (ByVal hCamera As IntPtr, ByRef pwCount As Short) As integer
	Public Declare Function GetDefectPixelCorrectionMode Lib "StCamD.dll" Alias "StCam_GetDefectPixelCorrectionMode" (ByVal hCamera As IntPtr, ByRef pwMode As Short) As integer
	Public Declare Function SetDefectPixelCorrectionMode Lib "StCamD.dll" Alias "StCam_SetDefectPixelCorrectionMode" (ByVal hCamera As IntPtr, ByVal wMode As Short) As integer
	Public Declare Function GetDefectPixelCorrectionPosition Lib "StCamD.dll" Alias "StCam_GetDefectPixelCorrectionPosition" (ByVal hCamera As IntPtr, ByVal wIndex As Short, ByRef pdwX As integer, ByRef pdwY As integer) As integer
	Public Declare Function SetDefectPixelCorrectionPosition Lib "StCamD.dll" Alias "StCam_SetDefectPixelCorrectionPosition" (ByVal hCamera As IntPtr, ByVal wIndex As Short, ByVal dwX As integer, ByVal dwY As integer) As integer
	Public Declare Function DetectDefectPixel Lib "StCamD.dll" Alias "StCam_DetectDefectPixel" (ByVal hCamera As IntPtr, ByVal dwWidth As integer, ByVal dwHeight As integer,  pbyteRaw As IntPtr, ByVal wThreshold As Short) As integer
	
	'------------------------------------------------------------------------------
	'HDR
	'------------------------------------------------------------------------------
	Public Declare Function GetHDRType Lib "StCamD.dll" Alias "StCam_GetHDRType" (ByVal hCamera As IntPtr, ByRef pdwHDRType As integer) As integer
	Public Declare Function SetHDRParameter Lib "StCamD.dll" Alias "StCam_SetHDRParameter" (ByVal hCamera As IntPtr, byval pdwBuffer() As integer, ByVal dwSize As integer) As integer
	Public Declare Function GetHDRParameter Lib "StCamD.dll" Alias "StCam_GetHDRParameter" (ByVal hCamera As IntPtr, byval pdwBuffer() As integer, ByRef pdwSize As integer) As integer
	
	'------------------------------------------------------------------------------
	'Callback Function
	'------------------------------------------------------------------------------
	Public Declare Function AddPreviewBitmapCallback Lib "StCamD.dll" Alias "StCam_AddPreviewBitmapCallback" (ByVal hCamera As IntPtr, ByVal pPreviewBitmapCallbackFunc As fStCamPreviewBitmapCallbackFunc, ByVal pContext As IntPtr, ByRef pdwPreviewBitmapCallbackNo As integer) As integer
	Public Declare Function RemovePreviewBitmapCallback Lib "StCamD.dll" Alias "StCam_RemovePreviewBitmapCallback" (ByVal hCamera As IntPtr, ByVal dwPreviewBitmapCallbackNo As integer) As integer
	Public Declare Function RemoveAllPreviewBitmapCallback Lib "StCamD.dll" Alias "StCam_RemoveAllPreviewBitmapCallback" (ByVal hCamera As IntPtr) As integer
	Public Declare Function GetPreviewBitmapCallbackCount Lib "StCamD.dll" Alias "StCam_GetPreviewBitmapCallbackCount" (ByVal hCamera As IntPtr, ByRef pdwListCount As integer) As integer
	Public Declare Function GetPreviewBitmapCallback Lib "StCamD.dll" Alias "StCam_GetPreviewBitmapCallback" (ByVal hCamera As IntPtr, ByVal dwCallbackIndex As integer, ByRef ppPreviewBitmapCallbackFunc As fStCamPreviewBitmapCallbackFunc, ByRef pdwCallbackFunctionNo As integer) As integer
	Public Declare Function AddPreviewGDICallback Lib "StCamD.dll" Alias "StCam_AddPreviewGDICallback" (ByVal hCamera As IntPtr, ByVal pPreviewGDICallbackFunc As fStCamPreviewGDICallbackFunc, ByVal pContext As IntPtr, ByRef pdwPreviewGDICallbackNo As integer) As integer
	Public Declare Function RemovePreviewGDICallback Lib "StCamD.dll" Alias "StCam_RemovePreviewGDICallback" (ByVal hCamera As IntPtr, ByVal dwPreviewGDICallbackNo As integer) As integer
	Public Declare Function RemoveAllPreviewGDICallback Lib "StCamD.dll" Alias "StCam_RemoveAllPreviewGDICallback" (ByVal hCamera As IntPtr) As integer
	Public Declare Function GetPreviewGDICallbackCount Lib "StCamD.dll" Alias "StCam_GetPreviewGDICallbackCount" (ByVal hCamera As IntPtr, ByRef pdwListCount As integer) As integer
	Public Declare Function GetPreviewGDICallback Lib "StCamD.dll" Alias "StCam_GetPreviewGDICallback" (ByVal hCamera As IntPtr, ByVal dwCallbackIndex As integer, ByRef ppPreviewGDICallbackFunc As fStCamPreviewGDICallbackFunc, ByRef pdwCallbackFunctionNo As integer) As integer
	Public Declare Function AddRawCallback Lib "StCamD.dll" Alias "StCam_AddRawCallback" (ByVal hCamera As IntPtr, ByVal pRawCallbackFunc As fStCamRawCallbackFunc, ByVal pContext As IntPtr, ByRef pdwRawCallbackNo As integer) As integer
	Public Declare Function RemoveRawCallback Lib "StCamD.dll" Alias "StCam_RemoveRawCallback" (ByVal hCamera As IntPtr, ByVal dwRawCallbackNo As integer) As integer
	Public Declare Function RemoveAllRawCallback Lib "StCamD.dll" Alias "StCam_RemoveAllRawCallback" (ByVal hCamera As IntPtr) As integer
	Public Declare Function GetRawCallbackCount Lib "StCamD.dll" Alias "StCam_GetRawCallbackCount" (ByVal hCamera As IntPtr, ByRef pdwListCount As integer) As integer
	Public Declare Function GetRawCallback Lib "StCamD.dll" Alias "StCam_GetRawCallback" (ByVal hCamera As IntPtr, ByVal dwCallbackIndex As integer, ByRef ppRawCallbackFunc As fStCamRawCallbackFunc, ByRef pdwCallbackFunctionNo As integer) As integer
	
	'------------------------------------------------------------------------------
	'Setting
	'------------------------------------------------------------------------------
	Public Declare Function SaveSettingFileA Lib "StCamD.dll" Alias "StCam_SaveSettingFileA" (ByVal hCamera As IntPtr, ByVal pszFileName As String) As integer
	Public Declare Function SaveSettingFileW Lib "StCamD.dll" Alias "StCam_SaveSettingFileW" (ByVal hCamera As IntPtr, ByVal pszFileName As String) As integer
	Public Declare Auto Function SaveSettingFile Lib "StCamD.dll" Alias "StCam_SaveSettingFile" (ByVal hCamera As IntPtr, ByVal pszFileName As String) As integer
	Public Declare Function LoadSettingFileA Lib "StCamD.dll" Alias "StCam_LoadSettingFileA" (ByVal hCamera As IntPtr, ByVal pszFileName As String) As integer
	Public Declare Function LoadSettingFileW Lib "StCamD.dll" Alias "StCam_LoadSettingFileW" (ByVal hCamera As IntPtr, ByVal pszFileName As String) As integer
	Public Declare Auto Function LoadSettingFile Lib "StCamD.dll" Alias "StCam_LoadSettingFile" (ByVal hCamera As IntPtr, ByVal pszFileName As String) As integer
	Public Declare Function ResetSetting Lib "StCamD.dll" Alias "StCam_ResetSetting" (ByVal hCamera As IntPtr) As integer
	Public Declare Function CameraSetting Lib "StCamD.dll" Alias "StCam_CameraSetting" (ByVal hCamera As IntPtr, ByVal wMode As Short) As integer
	
	'------------------------------------------------------------------------------
	'EEPROM
	'------------------------------------------------------------------------------
	Public Declare Function ReadUserMemory Lib "StCamD.dll" Alias "StCam_ReadUserMemory" (ByVal hCamera As IntPtr, byval pbyteBuffer() As Byte, ByVal wOffset As Short, ByVal wLength As Short) As integer
	Public Declare Function WriteUserMemory Lib "StCamD.dll" Alias "StCam_WriteUserMemory" (ByVal hCamera As IntPtr, byval pbyteBuffer() As Byte, ByVal wOffset As Short, ByVal wLength As Short) As integer
	Public Declare Function ReadCameraUserIDA Lib "StCamD.dll" Alias "StCam_ReadCameraUserIDA" (ByVal hCamera As IntPtr, ByRef pdwCameraID As integer, ByVal pszBuffer As System.Text.StringBuilder, ByVal dwBufferSize As integer) As integer
	Public Declare Function ReadCameraUserIDW Lib "StCamD.dll" Alias "StCam_ReadCameraUserIDW" (ByVal hCamera As IntPtr, ByRef pdwCameraID As integer, ByVal pszBuffer As System.Text.StringBuilder, ByVal dwBufferSize As integer) As integer
	Public Declare Auto Function ReadCameraUserID Lib "StCamD.dll" Alias "StCam_ReadCameraUserID" (ByVal hCamera As IntPtr, ByRef pdwCameraID As integer, ByVal pszBuffer As System.Text.StringBuilder, ByVal dwBufferSize As integer) As integer
	Public Declare Function WriteCameraUserIDA Lib "StCamD.dll" Alias "StCam_WriteCameraUserIDA" (ByVal hCamera As IntPtr, ByVal dwCameraID As integer, ByVal pszBuffer As String, ByVal dwBufferSize As integer) As integer
	Public Declare Function WriteCameraUserIDW Lib "StCamD.dll" Alias "StCam_WriteCameraUserIDW" (ByVal hCamera As IntPtr, ByVal dwCameraID As integer, ByVal pszBuffer As String, ByVal dwBufferSize As integer) As integer
	Public Declare Auto Function WriteCameraUserID Lib "StCamD.dll" Alias "StCam_WriteCameraUserID" (ByVal hCamera As IntPtr, ByVal dwCameraID As integer, ByVal pszBuffer As String, ByVal dwBufferSize As integer) As integer
	
	'------------------------------------------------------------------------------
	'Version Information
	'------------------------------------------------------------------------------
	Public Declare Function GetProductNameA Lib "StCamD.dll" Alias "StCam_GetProductNameA" (ByVal hCamera As IntPtr, ByVal pszCameraName As System.Text.StringBuilder, ByVal dwBufferSize As integer) As integer
	Public Declare Function GetProductNameW Lib "StCamD.dll" Alias "StCam_GetProductNameW" (ByVal hCamera As IntPtr, ByVal pszCameraName As System.Text.StringBuilder, ByVal dwBufferSize As integer) As integer
	Public Declare Auto Function GetProductName Lib "StCamD.dll" Alias "StCam_GetProductName" (ByVal hCamera As IntPtr, ByVal pszCameraName As System.Text.StringBuilder, ByVal dwBufferSize As integer) As integer
	Public Declare Function GetCameraVersion Lib "StCamD.dll" Alias "StCam_GetCameraVersion" (ByVal hCamera As IntPtr, ByRef pwUSBVendorID As Short, ByRef pwUSBProductID As Short, ByRef pwFPGAVersion As Short, ByRef pwFirmVersion As Short) As integer
	Public Declare Function GetDriverVersion Lib "StCamD.dll" Alias "StCam_GetDriverVersion" (ByVal hCamera As IntPtr, ByRef pdwFileVersionMS As integer, ByRef pdwFileVersionLS As integer, ByRef pdwProductVersionMS As integer, ByRef pdwProductVersionLS As integer) As integer
	Public Declare Function GetUSBDllVersion Lib "StCamD.dll" Alias "StCam_GetUSBDllVersion" (ByRef pdwFileVersionMS As integer, ByRef pdwFileVersionLS As integer, ByRef pdwProductVersionMS As integer, ByRef pdwProductVersionLS As integer) As integer
	Public Declare Function GetCAMDllVersion Lib "StCamD.dll" Alias "StCam_GetCAMDllVersion" (ByRef pdwFileVersionMS As integer, ByRef pdwFileVersionLS As integer, ByRef pdwProductVersionMS As integer, ByRef pdwProductVersionLS As integer) As integer
	Public Declare Function GetUSBFunctionAddress Lib "StCamD.dll" Alias "StCam_GetUSBFunctionAddress" (ByVal hCamera As IntPtr, ByRef pbyteUSBFunctionAddress As Byte) As integer
	Public Declare Function HasFunction Lib "StCamD.dll" Alias "StCam_HasFunction" (ByVal hCamera As IntPtr, ByVal dwCameraFunctionID As integer, ByRef pbHasFunction As integer) As integer
	Public Declare Function GetDevicePathA Lib "StCamD.dll" Alias "StCam_GetDevicePathA" (ByVal hCamera As IntPtr, ByVal pszDevicePath As System.Text.StringBuilder, ByRef pdwBufferSize As integer) As integer
	Public Declare Function GetDevicePathW Lib "StCamD.dll" Alias "StCam_GetDevicePathW" (ByVal hCamera As IntPtr, ByVal pszDevicePath As System.Text.StringBuilder, ByRef pdwBufferSize As integer) As integer
	Public Declare Auto Function GetDevicePath Lib "StCamD.dll" Alias "StCam_GetDevicePath" (ByVal hCamera As IntPtr, ByVal pszDevicePath As System.Text.StringBuilder, ByRef pdwBufferSize As integer) As integer
	
	'------------------------------------------------------------------------------
	'Other
	'------------------------------------------------------------------------------
	Public Declare Function ConvertBitmapBGR24ToRGB24 Lib "StCamD.dll" Alias "StCam_ConvertBitmapBGR24ToRGB24" (ByVal hCamera As IntPtr, ByVal dwWidth As integer, ByVal dwHeight As integer,  pbyteBitmap As IntPtr) As integer
	Public Declare Function ConvertRawToBGR Lib "StCamD.dll" Alias "StCam_ConvertRawToBGR" (ByVal hCamera As IntPtr, ByVal dwWidth As integer, ByVal dwHeight As integer,  pbyteSrcRaw As IntPtr,  pbyteDstBGR As IntPtr, ByVal byteColorInterpolationMethod As Byte, ByVal dwPreviewPixelFormat As integer) As integer
	Public Declare Function SetControlArea Lib "StCamD.dll" Alias "StCam_SetControlArea" (ByVal hCamera As IntPtr, byval pwSepalateX() As Short, byval pwSepalateY() As Short) As integer
	Public Declare Function GetControlArea Lib "StCamD.dll" Alias "StCam_GetControlArea" (ByVal hCamera As IntPtr, byval pwSepalateX() As Short, byval pwSepalateY() As Short) As integer
	Public Declare Function GetDigitalClamp Lib "StCamD.dll" Alias "StCam_GetDigitalClamp" (ByVal hCamera As IntPtr, ByRef pwValue As Short) As integer
	Public Declare Function SetDigitalClamp Lib "StCamD.dll" Alias "StCam_SetDigitalClamp" (ByVal hCamera As IntPtr, ByVal wValue As Short) As integer
	Public Declare Function ResetRootHub Lib "StCamD.dll" Alias "StCam_ResetRootHub" () As integer
	Public Declare Function SetAnalogBlackLevel Lib "StCamD.dll" Alias "StCam_SetAnalogBlackLevel" (ByVal hCamera As IntPtr, ByVal wBlackLevel As Short) As integer
	Public Declare Function GetAnalogBlackLevel Lib "StCamD.dll" Alias "StCam_GetAnalogBlackLevel" (ByVal hCamera As IntPtr, ByRef pwBlackLevel As Short) As integer
	Public Declare Function GetMaxAnalogBlackLevel Lib "StCamD.dll" Alias "StCam_GetMaxAnalogBlackLevel" (ByVal hCamera As IntPtr, ByRef pwBlackLevel As Short) As integer
	Public Declare Function GetMaxDigitalClamp Lib "StCamD.dll" Alias "StCam_GetMaxDigitalClamp" (ByVal hCamera As IntPtr, ByRef pwDigitalClamp As Short) As integer
	Public Declare Function SetAdjustmentMode Lib "StCamD.dll" Alias "StCam_SetAdjustmentMode" (ByVal hCamera As IntPtr, ByVal dwValue As integer) As integer
	Public Declare Function GetAdjustmentMode Lib "StCamD.dll" Alias "StCam_GetAdjustmentMode" (ByVal hCamera As IntPtr, ByRef pdwValue As integer) As integer
	'------------------------------------------------------------------------------
	'ERROR_STCAM
	'------------------------------------------------------------------------------
	Public Const ERRST_NOT_FOUND_CAMERA As integer = &HE0000001
	Public Const ERRST_ALL_CAMARA_OPENED As integer = &HE0000002
	Public Const ERRST_INVALID_CAMERA_HANDLE As integer = &HE0000003
	Public Const ERRST_INVALID_FUNCTION_RECEIVING As integer = &HE0000004
	Public Const ERRST_USB_COMMAND_TRANSFER As integer = &HE0000005
	Public Const ERRST_WINDOW_ALREADY_EXISTS As integer = &HE0000006
	Public Const ERRST_WINDOW_DOES_NOT_EXISTS As integer = &HE0000007
	Public Const ERRST_INVALID_FUNCTION_RECORDING As integer = &HE0000008
	Public Const ERRST_AVI_STREAM As integer = &HE0000009
	Public Const ERRST_AVI_NOCOMPRESSOR As integer = &HE000000A
	Public Const ERRST_AVI_UNSUPPORTED As integer = &HE000000B
	Public Const ERRST_AVI_DISK As integer = &HE000000C
	Public Const ERRST_AVI_CANCELED As integer = &HE000000D
	Public Const ERRST_AVI_WRITE As integer = &HE000000E
	Public Const ERRST_INVALID_FILE_NAME As integer = &HE000000F
	Public Const ERRST_FILE_OPEN As integer = &HE0000010
	Public Const ERRST_FILE_WRITE As integer = &HE0000011
	Public Const ERRST_NOT_SUPPORTED_FUNCTION As integer = &HE0000021
	'------------------------------------------------------------------------------
	'WM_STCAM
	'------------------------------------------------------------------------------
	Public Const WM_STCAM_TRANSFER_START As integer = &HB001
	Public Const WM_STCAM_TRANSFER_FINISH As integer = &HB002
	Public Const WM_STCAM_PREVIEW_WINDOW_CREATE As integer = &HB003
	Public Const WM_STCAM_PREVIEW_WINDOW_CLOSE As integer = &HB004
	Public Const WM_STCAM_PREVIEW_WINDOW_RESIZE As integer = &HB005
	Public Const WM_STCAM_PREVIEW_MASK_RESIZE As integer = &HB006
	Public Const WM_STCAM_PREVIEW_DEST_RESIZE As integer = &HB007
	Public Const WM_STCAM_AVI_FILE_START As integer = &HB008
	Public Const WM_STCAM_AVI_FILE_FINISH As integer = &HB009
	Public Const WM_STCAM_PREVIEW_MENU_COMMAND As integer = &HB00A
	Public Const WM_STCAM_UPDATED_PREVIEW_IMAGE As integer = &HB00B
	'------------------------------------------------------------------------------
	'COLOR_ARRAY
	'------------------------------------------------------------------------------
	Public Const STCAM_COLOR_ARRAY_MONO As Short = &H0001S
	Public Const STCAM_COLOR_ARRAY_RGGB As Short = &H0002S
	Public Const STCAM_COLOR_ARRAY_GRBG As Short = &H0003S
	Public Const STCAM_COLOR_ARRAY_GBRG As Short = &H0004S
	Public Const STCAM_COLOR_ARRAY_BGGR As Short = &H0005S
	'------------------------------------------------------------------------------
	'TRANSER_BITS_PER_PIXEL
	'------------------------------------------------------------------------------
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_RAW_08 As integer = &H00000001
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_RAW_10 As integer = &H00000002
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_RAW_10P As integer = &H00010000
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_RAW_12 As integer = &H00000004
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_RAW_12P As integer = &H00020000
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_RAW_14 As integer = &H00000008
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_RAW_16 As integer = &H00000010
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_MONO_08 As integer = &H00000020
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10 As integer = &H00000040
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10P As integer = &H00100000
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12 As integer = &H00000080
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12P As integer = &H00200000
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_MONO_14 As integer = &H00000100
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_MONO_16 As integer = &H00000200
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_BGR_08 As integer = &H00000400
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_BGR_10 As integer = &H00000800
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_YCBCR411_08 As integer = &H00001000
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_YCBCR422_08 As integer = &H00002000
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_YCBCR444_08 As integer = &H00004000
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_08 As integer = &H00000001
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_10 As integer = &H00000002
	Public Const STCAM_TRANSFER_BITS_PER_PIXEL_12 As integer = &H00000004
	Public Const STCAM_TRANSER_BITS_PER_PIXEL_08 As integer = &H00000001
	Public Const STCAM_TRANSER_BITS_PER_PIXEL_16 As integer = &H00000002
	'------------------------------------------------------------------------------
	'IMAGE_SIZE_MODE
	'------------------------------------------------------------------------------
	Public Const STCAM_IMAGE_SIZE_MODE_CUSTOM As integer = &H00000001
	Public Const STCAM_IMAGE_SIZE_MODE_VGA As integer = &H00000008
	Public Const STCAM_IMAGE_SIZE_MODE_XGA As integer = &H00000020
	Public Const STCAM_IMAGE_SIZE_MODE_QUAD_VGA As integer = &H00000080
	Public Const STCAM_IMAGE_SIZE_MODE_SXGA As integer = &H00000100
	Public Const STCAM_IMAGE_SIZE_MODE_UXGA As integer = &H00000400
	'------------------------------------------------------------------------------
	'SCAN_MODE
	'------------------------------------------------------------------------------
	Public Const STCAM_SCAN_MODE_NORMAL As Short = &H0000S
	Public Const STCAM_SCAN_MODE_PARTIAL_2 As Short = &H0001S
	Public Const STCAM_SCAN_MODE_PARTIAL_4 As Short = &H0002S
	Public Const STCAM_SCAN_MODE_PARTIAL_1 As Short = &H0004S
	Public Const STCAM_SCAN_MODE_VARIABLE_PARTIAL As Short = &H0008S
	Public Const STCAM_SCAN_MODE_BINNING As Short = &H0010S
	Public Const STCAM_SCAN_MODE_BINNING_PARTIAL_1 As Short = &H0020S
	Public Const STCAM_SCAN_MODE_BINNING_PARTIAL_2 As Short = &H0040S
	Public Const STCAM_SCAN_MODE_BINNING_PARTIAL_4 As Short = &H0080S
	Public Const STCAM_SCAN_MODE_BINNING_VARIABLE_PARTIAL As Short = &H0100S
	Public Const STCAM_SCAN_MODE_ROI As Short = &H8000S
	Public Const STCAM_SCAN_MODE_AOI As Short = &H8000S
	'------------------------------------------------------------------------------
	'PIXEL_FORMAT
	'------------------------------------------------------------------------------
	Public Const STCAM_PIXEL_FORMAT_08_MONO_OR_RAW As integer = &H00000001
	Public Const STCAM_PIXEL_FORMAT_24_BGR As integer = &H00000004
	Public Const STCAM_PIXEL_FORMAT_32_BGR As integer = &H00000008
	'------------------------------------------------------------------------------
	'COLOR_INTERPOLATION
	'------------------------------------------------------------------------------
	Public Const STCAM_COLOR_INTERPOLATION_NONE_MONO As Byte = 0
	Public Const STCAM_COLOR_INTERPOLATION_NONE_COLOR As Byte = 1
	Public Const STCAM_COLOR_INTERPOLATION_NEAREST_NEIGHBOR As Byte = 2
	Public Const STCAM_COLOR_INTERPOLATION_BILINEAR As Byte = 3
	Public Const STCAM_COLOR_INTERPOLATION_BILINEAR_FALSE_COLOR_REDUCTION As Byte = 5
	Public Const STCAM_COLOR_INTERPOLATION_BICUBIC As Byte = 4
	'------------------------------------------------------------------------------
	'ASPECT
	'------------------------------------------------------------------------------
	Public Const STCAM_ASPECT_MODE_FIXED As Byte = 0
	Public Const STCAM_ASPECT_MODE_KEEP_ASPECT As Byte = 1
	Public Const STCAM_ASPECT_MODE_ADJUST_WINDOW As Byte = 2
	Public Const STCAM_ASPECT_MODE_MASK_SIZE As Byte = 3
	Public Const STCAM_ASPECT_MODE_CUSTOM_OFFSET As Byte = 254
	Public Const STCAM_ASPECT_MODE_CUSTOM_CENTER As Byte = 255
	Public Const STCAM_ASPECT_MODE_CUSTOM As Byte = 255
	'------------------------------------------------------------------------------
	'MAGNIFICATION
	'------------------------------------------------------------------------------
	Public Const STCAM_MAGNIFICATION_MODE_OFF As Byte = 0
	Public Const STCAM_MAGNIFICATION_MODE_ON As Byte = 1
	'------------------------------------------------------------------------------
	'ALCMODE
	'------------------------------------------------------------------------------
	Public Const STCAM_ALCMODE_FIXED_SHUTTER_AGC_OFF As Byte = 0
	Public Const STCAM_ALCMODE_AUTO_SHUTTER_ON_AGC_ON As Byte = 1
	Public Const STCAM_ALCMODE_AUTO_SHUTTER_ON_AGC_OFF As Byte = 2
	Public Const STCAM_ALCMODE_FIXED_SHUTTER_AGC_ON As Byte = 3
	Public Const STCAM_ALCMODE_AUTO_SHUTTER_AGC_ONESHOT As Byte = 4
	Public Const STCAM_ALCMODE_AUTO_SHUTTER_ONESHOT_AGC_OFF As Byte = 5
	Public Const STCAM_ALCMODE_FIXED_SHUTTER_AGC_ONESHOT As Byte = 6
	Public Const STCAM_ALCMODE_CAMERA_AE_ON As Byte = 16
	Public Const STCAM_ALCMODE_CAMERA_AGC_ON As Byte = 32
	Public Const STCAM_ALCMODE_CAMERA_AE_AGC_ON As Byte = 48
	Public Const STCAM_ALCMODE_ALC_FIXED_AGC_OFF As Byte = 0
	Public Const STCAM_ALCMODE_ALC_FULLAUTO_AGC_ON As Byte = 1
	Public Const STCAM_ALCMODE_ALC_FULLAUTO_AGC_OFF As Byte = 2
	Public Const STCAM_ALCMODE_ALC_FIXED_AGC_ON As Byte = 3
	Public Const STCAM_ALCMODE_ALCAGC_ONESHOT As Byte = 4
	Public Const STCAM_ALCMODE_ALC_ONESHOT_AGC_OFF As Byte = 5
	Public Const STCAM_ALCMODE_ALC_FIXED_AGC_ONESHOT As Byte = 6
	'------------------------------------------------------------------------------
	'WB
	'------------------------------------------------------------------------------
	Public Const STCAM_WB_OFF As Byte = 0
	Public Const STCAM_WB_MANUAL As Byte = 1
	Public Const STCAM_WB_FULLAUTO As Byte = 2
	Public Const STCAM_WB_ONESHOT As Byte = 3
	'------------------------------------------------------------------------------
	'GAMMA
	'------------------------------------------------------------------------------
	Public Const STCAM_GAMMA_OFF As Byte = 0
	Public Const STCAM_GAMMA_ON As Byte = 1
	Public Const STCAM_GAMMA_REVERSE As Byte = 2
	Public Const STCAM_GAMMA_TABLE As Byte = 255
	'------------------------------------------------------------------------------
	'GAMMA_TARGET
	'------------------------------------------------------------------------------
	Public Const STCAM_GAMMA_TARGET_Y As Byte = 0
	Public Const STCAM_GAMMA_TARGET_R As Byte = 1
	Public Const STCAM_GAMMA_TARGET_GR As Byte = 2
	Public Const STCAM_GAMMA_TARGET_GB As Byte = 3
	Public Const STCAM_GAMMA_TARGET_B As Byte = 4
	'------------------------------------------------------------------------------
	'SHARPNESS
	'------------------------------------------------------------------------------
	Public Const STCAM_SHARPNESS_OFF As Byte = 0
	Public Const STCAM_SHARPNESS_ON As Byte = 1
	'------------------------------------------------------------------------------
	'HUE_SATURATION
	'------------------------------------------------------------------------------
	Public Const STCAM_HUE_SATURATION_OFF As Byte = 0
	Public Const STCAM_HUE_SATURATION_ON As Byte = 1
	'------------------------------------------------------------------------------
	'COLOR_MATRIX
	'------------------------------------------------------------------------------
	Public Const STCAM_COLOR_MATRIX_OFF As Byte = &H00
	Public Const STCAM_COLOR_MATRIX_CUSTOM As Byte = &HFF
	'------------------------------------------------------------------------------
	'MIRROR
	'------------------------------------------------------------------------------
	Public Const STCAM_MIRROR_OFF As Byte = 0
	Public Const STCAM_MIRROR_HORIZONTAL As Byte = 1
	Public Const STCAM_MIRROR_VERTICAL As Byte = 2
	Public Const STCAM_MIRROR_HORIZONTAL_VERTICAL As Byte = 3
	Public Const STCAM_MIRROR_HORIZONTAL_CAMERA As Byte = 16
	Public Const STCAM_MIRROR_VERTICAL_CAMERA As Byte = 32
	'------------------------------------------------------------------------------
	'ROTATION
	'------------------------------------------------------------------------------
	Public Const STCAM_ROTATION_OFF As Byte = 0
	Public Const STCAM_ROTATION_CLOCKWISE_90 As Byte = 1
	Public Const STCAM_ROTATION_COUNTERCLOCKWISE_90 As Byte = 2
	'------------------------------------------------------------------------------
	'AVI_COMPRESSOR
	'------------------------------------------------------------------------------
	Public Const STCAM_AVI_COMPRESSOR_UNCOMPRESSED As integer = &H00000000
	Public Const STCAM_AVI_COMPRESSOR_MJPG As integer = &H47504A4D
	Public Const STCAM_AVI_COMPRESSOR_MP42 As integer = &H3234706D
	Public Const STCAM_AVI_COMPRESSOR_MPV4 As integer = &H3467706D
	Public Const STCAM_AVI_COMPRESSOR_DIALOG_BOX As integer = &HFFFFFFFF
	'------------------------------------------------------------------------------
	'CLOCK_MODE
	'------------------------------------------------------------------------------
	Public Const STCAM_CLOCK_MODE_NORMAL As integer = &H00000000
	Public Const STCAM_CLOCK_MODE_DIV_2 As integer = &H00000001
	Public Const STCAM_CLOCK_MODE_DIV_4 As integer = &H00000002
	Public Const STCAM_CLOCK_MODE_VGA_90FPS As integer = &H00000100
	Public Const STCAM_CLOCK_MODE_CUSTOM As integer = &H80000000
	'------------------------------------------------------------------------------
	'USBPID
	'------------------------------------------------------------------------------
	Public Const STCAM_USBPID_STC_C33USB As Short = &H0305S
	Public Const STCAM_USBPID_STC_B33USB As Short = &H0705S
	Public Const STCAM_USBPID_STC_B83USB As Short = &H0805S
	Public Const STCAM_USBPID_STC_C83USB As Short = &H0605S
	Public Const STCAM_USBPID_STC_TB33USB As Short = &H0906S
	Public Const STCAM_USBPID_STC_TC33USB As Short = &H1006S
	Public Const STCAM_USBPID_STC_TB83USB As Short = &H1106S
	Public Const STCAM_USBPID_STC_TC83USB As Short = &H1206S
	Public Const STCAM_USBPID_STC_TB133USB As Short = &H0109S
	Public Const STCAM_USBPID_STC_TC133USB As Short = &H0209S
	Public Const STCAM_USBPID_STC_TB152USB As Short = &H1306S
	Public Const STCAM_USBPID_STC_TC152USB As Short = &H1406S
	Public Const STCAM_USBPID_STC_TB202USB As Short = &H1506S
	Public Const STCAM_USBPID_STC_TC202USB As Short = &H1606S
	Public Const STCAM_USBPID_STC_MB33USB As Short = &H0110S
	Public Const STCAM_USBPID_STC_MC33USB As Short = &H0210S
	Public Const STCAM_USBPID_STC_MB83USB As Short = &H0310S
	Public Const STCAM_USBPID_STC_MC83USB As Short = &H0410S
	Public Const STCAM_USBPID_STC_MB133USB As Short = &H0510S
	Public Const STCAM_USBPID_STC_MC133USB As Short = &H0610S
	Public Const STCAM_USBPID_STC_MB152USB As Short = &H0710S
	Public Const STCAM_USBPID_STC_MC152USB As Short = &H0810S
	Public Const STCAM_USBPID_STC_MB202USB As Short = &H0910S
	Public Const STCAM_USBPID_STC_MC202USB As Short = &H1010S
	Public Const STCAM_USBPID_STC_MBA5MUSB3 As Short = &H0111S
	Public Const STCAM_USBPID_STC_MCA5MUSB3 As Short = &H0211S
	Public Const STCAM_USBPID_STC_MBE132U3V As Short = &H0112S
	Public Const STCAM_USBPID_STC_MCE132U3V As Short = &H0212S
	Public Const STCAM_USBPID_STC_MBCM401U3V As Short = &H0113S
	Public Const STCAM_USBPID_STC_MCCM401U3V As Short = &H0213S
	Public Const STCAM_USBPID_STC_MBCM200U3V As Short = &H0313S
	Public Const STCAM_USBPID_STC_MCCM200U3V As Short = &H0413S
	Public Const STCAM_USBPID_STC_MBCM33U3V As Short = &H0513S
	Public Const STCAM_USBPID_STC_MCCM33U3V As Short = &H0613S
	Public Const STCAM_USBPID_STC_MBS241U3V As Short = &H0713S
	Public Const STCAM_USBPID_STC_MCS241U3V As Short = &H0813S
	Public Const STCAM_USBPID_STC_MBE132U3V_IR As Short = &H0114S
	Public Const STCAM_USBPID_STC_RHB33U3V As Short = &H0115S
	Public Const STCAM_USBPID_STC_RHC33U3V As Short = &H0215S
	Public Const STCAM_USBPID_STC_MBS510U3V As Short = &H0315S
	Public Const STCAM_USBPID_STC_MCS510U3V As Short = &H0415S
	Public Const STCAM_USBPID_STC_MBS322U3V As Short = &H0515S
	Public Const STCAM_USBPID_STC_MCS322U3V As Short = &H0615S
	Public Const STCAM_USBPID_STC_MBS891U3V As Short = &H0116S
	Public Const STCAM_USBPID_STC_MCS891U3V As Short = &H0216S
	Public Const STCAM_USBPID_STC_MBS123BU3V As Short = &H0316S
	Public Const STCAM_USBPID_STC_MCS123BU3V As Short = &H0416S
	Public Const STCAM_USBPID_STC_MBS43U3V As Short = &H0516S
	Public Const STCAM_USBPID_STC_MCS43U3V As Short = &H0616S
	Public Const STCAM_USBPID_STC_MBS163U3V As Short = &H0716S
	Public Const STCAM_USBPID_STC_MCS163U3V As Short = &H0816S
	'------------------------------------------------------------------------------
	'AVI_STATUS
	'------------------------------------------------------------------------------
	Public Const STCAM_AVI_STATUS_STOP As Byte = &H00
	Public Const STCAM_AVI_STATUS_START As Byte = &H01
	Public Const STCAM_AVI_STATUS_PAUSE As Byte = &H02
	'------------------------------------------------------------------------------
	'DISPLAY_MODE
	'------------------------------------------------------------------------------
	Public Const STCAM_DISPLAY_MODE_GDI As Byte = &H00
	Public Const STCAM_DISPLAY_MODE_GDI_HALFTONE As Byte = &H08
	Public Const STCAM_DISPLAY_MODE_DD_OFFSCREEN As Byte = &H01
	Public Const STCAM_DISPLAY_MODE_DD_OVERLAY As Byte = &H02
	Public Const STCAM_DISPLAY_MODE_DD_OFFSCREEN_HQ As Byte = &H03
	Public Const STCAM_DISPLAY_MODE_DD_OVERLAY_HQ As Byte = &H04
	Public Const STCAM_DISPLAY_MODE_DIRECTX As Byte = &H05
	Public Const STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON As Byte = &H06
	Public Const STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON2 As Byte = &H07
	Public Const STCAM_DISPLAY_MODE_DIRECTX_FPU As Byte = &H09
	Public Const STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON_FPU As Byte = &H0A
	Public Const STCAM_DISPLAY_MODE_DIRECTX_VSYNC_ON2_FPU As Byte = &H0B
	'------------------------------------------------------------------------------
	'TRUE_FALSE
	'------------------------------------------------------------------------------
	Public Const STCAM_TRUE As integer = &HFFFFFFFF
	Public Const STCAM_FALSE As integer = &H00000000
	'------------------------------------------------------------------------------
	'CAMERA_SETTING
	'------------------------------------------------------------------------------
	Public Const STCAM_CAMERA_SETTING_INITIALIZE As Short = &H8000S
	Public Const STCAM_CAMERA_SETTING_WRITE As Short = &H2000S
	Public Const STCAM_CAMERA_SETTING_READ As Short = &H1000S
	Public Const STCAM_CAMERA_SETTING_STANDARD As Short = &H0800S
	Public Const STCAM_CAMERA_SETTING_DEFECT_PIXEL_POSITION As Short = &H0400S
	'------------------------------------------------------------------------------
	'DEFECT_PIXEL_CORRECTION
	'------------------------------------------------------------------------------
	Public Const STCAM_DEFECT_PIXEL_CORRECTION_OFF As Short = &H0000S
	Public Const STCAM_DEFECT_PIXEL_CORRECTION_ON As Short = &H0001S
	'------------------------------------------------------------------------------
	'BINNING_SUM
	'------------------------------------------------------------------------------
	Public Const STCAM_BINNING_SUM_MODE_OFF As Short = &H0000S
	Public Const STCAM_BINNING_SUM_MODE_H As Short = &H0001S
	Public Const STCAM_BINNING_SUM_MODE_V As Short = &H0100S
	'------------------------------------------------------------------------------
	'AVI_FILE_FORMAT
	'------------------------------------------------------------------------------
	Public Const STCAM_AVI_FILE_FORMAT_AVI1 As integer = 0
	Public Const STCAM_AVI_FILE_FORMAT_AVI2 As integer = 1
	'------------------------------------------------------------------------------
	'SHADING_CORRECTION_MODE
	'------------------------------------------------------------------------------
	Public Const STCAM_SHADING_CORRECTION_MODE_OFF As integer = &H0000
	Public Const STCAM_SHADING_CORRECTION_MODE_CALIBRATION_MULTIPLICATION As integer = &H0001
	Public Const STCAM_SHADING_CORRECTION_MODE_ON_MULTIPLICATION As integer = &H0002
	Public Const STCAM_SHADING_CORRECTION_MODE_CALIBRATION_ADDITION As integer = &H0003
	Public Const STCAM_SHADING_CORRECTION_MODE_ON_ADDITION As integer = &H0004
	'------------------------------------------------------------------------------
	'CAMERA_FUNCTION
	'------------------------------------------------------------------------------
	Public Const STCAM_CAMERA_FUNCTION_AWB As integer = 24
	Public Const STCAM_CAMERA_FUNCTION_AGC As integer = 25
	Public Const STCAM_CAMERA_FUNCTION_AE As integer = 26
	Public Const STCAM_CAMERA_FUNCTION_STORE_CAMERA_SETTING As integer = 59
	Public Const STCAM_CAMERA_FUNCTION_ANALOG_BLACK_LEVEL As integer = &H00050006
	Public Const STCAM_CAMERA_FUNCTION_DISABLED_ANALOG_GAIN As integer = &H00090004
	Public Const STCAM_CAMERA_FUNCTION_AGC_GAIN_TYPE As integer = &H00090005
	Public Const STCAM_CAMERA_FUNCTION_DEVICE_TEMPERATURE_MAINBOARD As integer = &H00090009
	Public Const STCAM_CAMERA_FUNCTION_ADJUSTMENT_MODE_DIGITAL_GAIN As integer = &H0009000A
	'------------------------------------------------------------------------------
	'ADJUSTMENT_MODE
	'------------------------------------------------------------------------------
	Public Const STCAM_ADJUSTMENT_MODE_DIGITAL_GAIN As integer = &H00000001
	'------------------------------------------------------------------------------
	'DEVICE_TEMPERATURE
	'------------------------------------------------------------------------------
	Public Const STCAM_DEVICE_TEMPERATURE_MAINBOARD As integer = &H00000001
	'------------------------------------------------------------------------------
	'HDR_TYPE
	'------------------------------------------------------------------------------
	Public Const STCAM_HDR_TYPE_CMOSIS_4M As integer = &H00000001
	'------------------------------------------------------------------------------
	'PRIORITY_MODE
	'------------------------------------------------------------------------------
	Public Const STCAM_PRIORITY_MODE_IMAGE_QUALITY As integer = 0
	Public Const STCAM_PRIORITY_MODE_FRAME_RATE As integer = 1
	'------------------------------------------------------------------------------
	'WINDOW_STYLE
	'------------------------------------------------------------------------------
	Public Const WS_OVERLAPPED As integer = &H00000000
	Public Const WS_POPUP As integer = &H80000000
	Public Const WS_CHILD As integer = &H40000000
	Public Const WS_MINIMIZE As integer = &H20000000
	Public Const WS_VISIBLE As integer = &H10000000
	Public Const WS_DISABLED As integer = &H08000000
	Public Const WS_CLIPSIBLINGS As integer = &H04000000
	Public Const WS_CLIPCHILDREN As integer = &H02000000
	Public Const WS_MAXIMIZE As integer = &H01000000
	Public Const WS_CAPTION As integer = &H00C00000
	Public Const WS_BORDER As integer = &H00800000
	Public Const WS_DLGFRAME As integer = &H00400000
	Public Const WS_VSCROLL As integer = &H00200000
	Public Const WS_HSCROLL As integer = &H00100000
	Public Const WS_SYSMENU As integer = &H00080000
	Public Const WS_THICKFRAME As integer = &H00040000
	Public Const WS_GROUP As integer = &H00020000
	Public Const WS_TABSTOP As integer = &H00010000
	Public Const WS_MINIMIZEBOX As integer = &H00020000
	Public Const WS_MAXIMIZEBOX As integer = &H00010000
	Public Const WS_OVERLAPPEDWINDOW As integer = &H00CF0000
	Public Const WS_POPUPWINDOW As integer = &H80880000
	Public Const WS_TILED As integer = &H00000000
	Public Const WS_ICONIC As integer = &H00020000
	Public Const WS_SIZEBOX As integer = &H00040000
	Public Const WS_TILEDWINDOW As integer = &H00CF0000
	Public Const WS_CHILDWINDOW As integer = &H40000000
End Class

