Public Class CameraListItem
	Implements ISelectItem
	Private INVALID_HANDLE_VALUE As IntPtr = CType(-1, IntPtr)
	Private m_CameraCollection As New Collection()

	Public Sub New()
		Call RefreshItems()
	End Sub


	Public Function GetItems() As Microsoft.VisualBasic.Collection Implements ISelectItem.GetItems
		Return (m_CameraCollection)
	End Function

	Public Sub RefreshItems() Implements ISelectItem.RefreshItems
		Do
			Dim hCamera As IntPtr
			hCamera = StTrg.Open()
			If INVALID_HANDLE_VALUE.Equals(hCamera) Then
				Exit Do
			Else
				m_CameraCollection.Add(New StCamera(hCamera))
			End If
		Loop While (False)
		If (m_CameraCollection.Count < 1) Then
			m_SelectedIndex = -1
		ElseIf (m_CameraCollection.Count <= m_SelectedIndex) Then
			m_SelectedIndex = m_CameraCollection.Count - 1
		End If

	End Sub
	Private Sub Clear()
		Do While 0 < m_CameraCollection.Count
			Dim stCamera As StCamera = DirectCast(m_CameraCollection.Item(1), StCamera)
			stCamera.Close()
			m_CameraCollection.Remove(1)
		Loop

	End Sub
	Private m_SelectedIndex As Integer = -1
	Public Property SelectedIndex() As Integer Implements ISelectItem.SelectedIndex
		Get
			Return (m_SelectedIndex)
		End Get
		Set(ByVal value As Integer)
			m_SelectedIndex = value
		End Set
	End Property

	Public Sub Close()
		Call Clear()
	End Sub

	Public Function GetSelectedItem() As StCamera
		Dim stCamera As StCamera = DirectCast(m_CameraCollection.Item(m_SelectedIndex + 1), StCamera)
		m_CameraCollection.Remove(m_SelectedIndex + 1)
		Return (stCamera)
	End Function

End Class
Public Interface ISelectItem
	Sub RefreshItems()
	Function GetItems() As Collection
	Property SelectedIndex() As Integer
End Interface