Public Class FormDisplay
	Private WithEvents m_Camera As StCamera = Nothing
	Private m_DispFrameNo As System.UInt32 = 0
	Private m_RcvCount As Long = 0
    Private m_hDisplayWnd As IntPtr = IntPtr.Zero


	Private Sub PanelDisplay_Paint(ByVal sender As System.Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles PanelDisplay.Paint
		If Not IsNothing(m_Camera) Then
			If PanelDisplay.EraseBackGround Then
				If m_Camera.HasDisplayImage Then
					PanelDisplay.EraseBackGround = False
					SaveBitmapToolStripMenuItem.Enabled = True
					ToolStripButtonSaveBitmapFile.Enabled = True
				End If
			End If


			m_Camera.Draw(Me.PanelDisplay.Handle, m_DispFrameNo)
			labelFPS.Text = String.Format("{0:N1}", m_Camera.GetFPS()) & " FPS"
			labelFrameNo.Text = "No." & m_DispFrameNo.ToString()
			labelRcvCount.Text = "Receive " & m_RcvCount.ToString()
			labelDrop.Text = "Dropped " & m_Camera.GetDroppedFrameCount()
		End If
	End Sub
    Private Sub FormDisplay_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        m_hDisplayWnd = PanelDisplay.Handle
        OpenCamera()
    End Sub
    Private Sub OpenCamera()
        m_Camera = StCamera.Open()
        If Not IsNothing(m_Camera) Then
            m_Camera.AddPreviewImageUpdatedEventHandler(AddressOf OnPreviewImageUpdated)
            m_Camera.AddErrRcvedEventHandler(AddressOf OnErrorRcved)
            AddHandler m_Camera.SettingUpdated, AddressOf OnSettingUpdated
            OnSettingUpdated(Me, New EventArgs())

            Dim imgWidth As System.UInt32 = m_Camera.ImageWidth
            Dim imgHeight As System.UInt32 = m_Camera.ImageHeight
            PanelDisplay.Width = CInt(imgWidth)
            PanelDisplay.Height = CInt(imgHeight)

            Dim clientSize As Size = New Size(CInt(imgWidth), CInt(imgHeight))
            If MenuStripDisplay.Visible Then
                clientSize.Height += MenuStripDisplay.Height
            End If
            If StatusStripDisplay.Visible Then
                clientSize.Height += StatusStripDisplay.Height
            End If
            If ToolStripDisplay.Visible Then
                clientSize.Height += ToolStripDisplay.Height
            End If
            Me.ClientSize = clientSize

            Dim workingArea As Rectangle = Screen.GetWorkingArea(Me)
            If (workingArea.Width < Width) Then
                Width = workingArea.Width
            End If
            If (workingArea.Height < Height) Then
                Height = workingArea.Height
            End If

            Top = CInt((workingArea.Height - Height) / 2)
            If Top < workingArea.Top Then
                Top = workingArea.Top
            End If
            Left = CInt((workingArea.Width - Width) / 2)
            If Left < workingArea.Left Then
                Left = workingArea.Left
            End If


            m_Camera.StartTransfer()
        End If
    End Sub
    Private Sub CloseCamera()
        If Not IsNothing(m_Camera) Then
            m_Camera.StopTransfer()
            m_Camera.Close()
            m_Camera = Nothing
        End If
    End Sub
    Public Sub OnPreviewImageUpdated(ByVal sender As Object, ByVal e As System.EventArgs)
        m_RcvCount += 1
        m_Camera.DelayedInvalidateRequest(m_hDisplayWnd)
        'PanelDisplay.Invalidate()
    End Sub
    Sub EnabledReOpenTimer()
        TimerReOpen.Enabled = True
    End Sub
    Public Sub OnErrorRcved(ByVal dwErrorCode As UInt32)
        If Native.ERROR_ACCESS_DENIED = dwErrorCode Then
            Dim mi As MethodInvoker = AddressOf EnabledReOpenTimer
            Me.Invoke(mi)
        End If
    End Sub

	Private Sub ExitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
		Close()
	End Sub

	Private Sub StatusBarToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles StatusBarToolStripMenuItem.Click
		StatusStripDisplay.Visible = Not StatusStripDisplay.Visible
	End Sub

	Private Sub ToolBarToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolBarToolStripMenuItem.Click
		ToolStripDisplay.Visible = Not ToolStripDisplay.Visible
	End Sub


	Private Sub ViewToolStripMenuItem_DropDownOpening(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ViewToolStripMenuItem.DropDownOpening
		Me.StatusBarToolStripMenuItem.Checked = StatusStripDisplay.Visible
		Me.ToolBarToolStripMenuItem.Checked = Me.ToolStripDisplay.Visible
	End Sub

	Private Sub SaveBitmapToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SaveBitmapToolStripMenuItem.Click
		If Not IsNothing(m_Camera) Then
			Using dlg As New SaveFileDialog()
				dlg.Filter = "Bitmap(*.bmp)|*.bmp|Tiff(*.tif)|*.tif|JPEG(*.jpg)|*.jpg|All Files(*.*)|*.*"
				dlg.DefaultExt = "bmp"
				If DialogResult.OK = dlg.ShowDialog() Then
					m_Camera.SaveImage(dlg.FileName)
				End If
			End Using
		End If
	End Sub

	Private Sub SettingToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SettingToolStripMenuItem.Click
		If Not IsNothing(m_Camera) Then
			m_Camera.ShowSettingDlg()
		End If
	End Sub

	Private Sub CameraIDToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CameraIDToolStripMenuItem.Click
		If Not IsNothing(m_Camera) Then
			m_Camera.ShowCameraIDDlg()
		End If
	End Sub


	Private Sub FormDisplay_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        CloseCamera()
	End Sub



    Private Sub ToolStripButtonSaveBitmapFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButtonSaveBitmapFile.Click
        SaveBitmapToolStripMenuItem.PerformClick()
    End Sub

    Private Sub OnSettingUpdated(ByVal sender As System.Object, ByVal e As System.EventArgs)

        ToolStripMenuItemTrigger_FrameStart.Enabled = False
        ToolStripMenuItemTrigger_ExposureStart.Enabled = False
        ToolStripMenuItemTrigger_ExposureEnd.Enabled = False
        ToolStripMenuItemTrigger_SensorReadOutStart.Enabled = False

        If Not IsNothing(m_Camera) Then
            If m_Camera.HasTriggerFunction() Then
                ToolStripMenuItemTrigger_FrameStart.Enabled = m_Camera.IsEnableTriggerSoftware(UInt32.Parse(ToolStripMenuItemTrigger_FrameStart.Tag.ToString()))
                ToolStripMenuItemTrigger_ExposureStart.Enabled = m_Camera.IsEnableTriggerSoftware(UInt32.Parse(ToolStripMenuItemTrigger_ExposureStart.Tag.ToString()))
                ToolStripMenuItemTrigger_ExposureEnd.Enabled = m_Camera.IsEnableTriggerSoftware(UInt32.Parse(ToolStripMenuItemTrigger_ExposureEnd.Tag.ToString()))
                ToolStripMenuItemTrigger_SensorReadOutStart.Enabled = m_Camera.IsEnableTriggerSoftware(UInt32.Parse(ToolStripMenuItemTrigger_SensorReadOutStart.Tag.ToString()))
            End If
        End If

        ToolStripButtonTrigger_FrameStart.Enabled = ToolStripMenuItemTrigger_FrameStart.Enabled
        ToolStripButtonTrigger_ExposureStart.Enabled = ToolStripMenuItemTrigger_ExposureStart.Enabled
        ToolStripButtonTrigger_ExposureEnd.Enabled = ToolStripMenuItemTrigger_ExposureEnd.Enabled
        ToolStripButtonTrigger_SensorReadOutStart.Enabled = ToolStripMenuItemTrigger_SensorReadOutStart.Enabled
    End Sub
	Private Sub AboutStTrgDisplayVB2005ToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AboutStTrgDisplayVB2005ToolStripMenuItem.Click
		Using dlg As FormVersion = New FormVersion
			dlg.ShowDialog()
		End Using
	End Sub

    Private Sub TimerReOpen_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TimerReOpen.Tick
        TimerReOpen.Enabled = False
        CloseCamera()
        OpenCamera()
        If IsNothing(m_Camera) Then
            Close()
        End If
    End Sub

    Private Sub ToolStripMenuItemTriggerSoftware_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripMenuItemTrigger_FrameStart.Click, ToolStripMenuItemTrigger_SensorReadOutStart.Click, ToolStripMenuItemTrigger_ExposureStart.Click, ToolStripMenuItemTrigger_ExposureEnd.Click, ToolStripButtonTrigger_SensorReadOutStart.Click, ToolStripButtonTrigger_FrameStart.Click, ToolStripButtonTrigger_ExposureStart.Click, ToolStripButtonTrigger_ExposureEnd.Click
        If Not IsNothing(m_Camera) Then
            Dim dwTriggerSelector As UInteger = 0

            Dim mi As ToolStripMenuItem = TryCast(sender, ToolStripMenuItem)
            If Not IsNothing(mi) Then
                dwTriggerSelector = UInteger.Parse(mi.Tag.ToString())
            Else
                Dim tsi As ToolStripItem = TryCast(sender, ToolStripItem)
                If Not IsNothing(tsi) Then
                    dwTriggerSelector = UInteger.Parse(tsi.Tag.ToString())
                End If
            End If
            m_Camera.TriggerSoftware(dwTriggerSelector)
        End If
    End Sub

End Class
