Public Class FormSelectCamera

	Private m_SelectItem As ISelectItem = Nothing
	Public Property SelectItem() As ISelectItem
		Get
			Return (m_SelectItem)
		End Get
		Set(ByVal value As ISelectItem)
			m_SelectItem = value
		End Set
	End Property
	Private Sub TimerRefresh_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TimerRefresh.Tick
		m_SelectItem.RefreshItems()
		UpdateComboBox()
	End Sub

	Private Sub FormSelectCamera_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
		btnOK.Enabled = False
		UpdateComboBox()
	End Sub

	Private Sub btnOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOK.Click
		m_SelectItem.SelectedIndex = comboBoxCamera.SelectedIndex
	End Sub

	Private Sub UpdateComboBox()
		comboBoxCamera.Items.Clear()
		Dim colItem As Collection = m_SelectItem.GetItems()

		If (0 < colItem.Count) Then
			For Each obj As Object In colItem
				comboBoxCamera.Items.Add(obj)
			Next
			comboBoxCamera.SelectedIndex = 0
			TimerRefresh.Enabled = False
			btnOK.Enabled = True
			If colItem.Count = 1 Then
				btnOK.PerformClick()
			End If
		Else
			TimerRefresh.Enabled = True
		End If

	End Sub
End Class