Public Class FormSetting
	Public Sub New(ByVal stCamera As StCamera)
		InitializeComponent()
		m_StCamera = stCamera
	End Sub
	Private m_StCamera As StCamera

	Public Sub SetChangeEvent(ByVal ctrls As Control.ControlCollection)
		For Each ctrl As Control In ctrls
			Dim hasChangedEventCtrl As IChanged = TryCast(ctrl, IChanged)
			If Not IsNothing(hasChangedEventCtrl) Then
				AddHandler hasChangedEventCtrl.Changed, AddressOf OnChanged
			End If
			If ctrl.HasChildren Then
				SetChangeEvent(ctrl.Controls)
			End If
		Next
	End Sub
	Public Sub UpdateDisplay(ByVal ctrls As Control.ControlCollection)
		For Each ctrl As Control In ctrls
			If TypeOf ctrl Is StComboBox Then
				UpdateDisplaySelection(CType(ctrl, StComboBox))
			ElseIf TypeOf ctrl Is StReadOnlyTextBox Then
				UpdateDisplayReadOnly(CType(ctrl, StReadOnlyTextBox))
			ElseIf TypeOf ctrl Is StButton Then
				UpdateDisplayButton(CType(ctrl, StButton))
			ElseIf TypeOf ctrl Is StCheckBox Then
				UpdateDisplayCheckBox(CType(ctrl, StCheckBox))
			ElseIf TypeOf ctrl Is IRange Then
				UpdateDisplayRange(ctrl)
			End If

			If ctrl.HasChildren Then
				UpdateDisplay(ctrl.Controls)
			End If
		Next
	End Sub
	Public Sub UpdateDisplaySelection(ByVal objStComboBox As StComboBox)
		Dim forceDisabled As Boolean = False
		Select Case (objStComboBox.Field)

			Case Fields.ALCMode	'Byte
				Dim nCount As Integer = 1
				If m_StCamera.HasAE Or m_StCamera.HasAGC Then
					If m_StCamera.HasAE Then
						nCount += 1
					End If
					If m_StCamera.HasAGC Then
						nCount += 1
						If m_StCamera.HasAE Then
							nCount += 1
						End If
					End If
				Else
					nCount = 7
				End If

				Dim value As Byte = m_StCamera.ALCMode
				Dim list(nCount - 1) As CStComboBoxItem(Of Byte)
				Dim nIndex As Integer = 0
				list(nIndex) = New CStComboBoxItem(Of Byte)("OFF", StTrg.STCAM_ALCMODE_OFF)
				nIndex += 1
				If m_StCamera.HasAE Or m_StCamera.HasAGC Then
					If m_StCamera.HasAE Then
						list(nIndex) = New CStComboBoxItem(Of Byte)("AE ON", StTrg.STCAM_ALCMODE_CAMERA_AE_ON)
						nIndex += 1
					End If
					If m_StCamera.HasAGC Then
						list(nIndex) = New CStComboBoxItem(Of Byte)("AGC ON", StTrg.STCAM_ALCMODE_CAMERA_AGC_ON)
						nIndex += 1
						If m_StCamera.HasAE Then
							list(nIndex) = New CStComboBoxItem(Of Byte)("AE/AGC ON", StTrg.STCAM_ALCMODE_CAMERA_AE_AGC_ON)
							nIndex += 1
						End If
					End If
				Else
					list(nIndex) = New CStComboBoxItem(Of Byte)("AE/AGC ON", StTrg.STCAM_ALCMODE_PC_AE_AGC_ON)
					nIndex += 1
					list(nIndex) = New CStComboBoxItem(Of Byte)("AE ON", StTrg.STCAM_ALCMODE_PC_AE_ON)
					nIndex += 1
					list(nIndex) = New CStComboBoxItem(Of Byte)("AGC ON", StTrg.STCAM_ALCMODE_PC_AGC_ON)
					nIndex += 1
					list(nIndex) = New CStComboBoxItem(Of Byte)("AE/AGC OneShot", StTrg.STCAM_ALCMODE_PC_AE_AGC_ONESHOT)
					nIndex += 1
					list(nIndex) = New CStComboBoxItem(Of Byte)("AE OneShot", StTrg.STCAM_ALCMODE_PC_AE_ONESHOT)
					nIndex += 1
					list(nIndex) = New CStComboBoxItem(Of Byte)("AGC OneShot", StTrg.STCAM_ALCMODE_PC_AGC_ONESHOT)
					nIndex += 1
				End If
                objStComboBox.InitList(list, value, forceDisabled)
            Case Fields.AdjustmentDigitalGain
                Dim enabled As Boolean = m_StCamera.HasAdjustmentModeDigitalGain()
                objStComboBox.Visible = enabled
                LabelAdjustmentDigitalGain.Visible = enabled
                forceDisabled = Not enabled
                If enabled Then
                    Dim value As Boolean = m_StCamera.EnableAdjustmentDigitalGain
                    objStComboBox.InitList(New CStComboBoxItem(Of Boolean)() { _
                    New CStComboBoxItem(Of Boolean)("OFF", False), _
                    New CStComboBoxItem(Of Boolean)("ON", True) _
                    }, value, forceDisabled)
                End If
            Case Fields.WBMode  'Byte
                Dim value As Byte = m_StCamera.WhiteBalanceMode
                objStComboBox.InitList(New CStComboBoxItem(Of Byte)() { _
                New CStComboBoxItem(Of Byte)("OFF", StTrg.STCAM_WB_OFF), _
                New CStComboBoxItem(Of Byte)("Manual", StTrg.STCAM_WB_MANUAL), _
                New CStComboBoxItem(Of Byte)("One Short", StTrg.STCAM_WB_ONESHOT), _
                New CStComboBoxItem(Of Byte)("Full Auto", StTrg.STCAM_WB_FULLAUTO) _
                }, value, forceDisabled)

            Case Fields.HueSaturationMode   'Byte
                Dim value As Byte = m_StCamera.HueSaturationMode
                objStComboBox.InitList(New CStComboBoxItem(Of Byte)() { _
                New CStComboBoxItem(Of Byte)("OFF", StTrg.STCAM_HUE_SATURATION_OFF), _
                New CStComboBoxItem(Of Byte)("ON", StTrg.STCAM_HUE_SATURATION_ON) _
                }, value, forceDisabled)
            Case Fields.SharpnessMode   'Byte
                Dim value As Byte = m_StCamera.SharpnessMode
                objStComboBox.InitList(New CStComboBoxItem(Of Byte)() { _
                New CStComboBoxItem(Of Byte)("OFF", StTrg.STCAM_SHARPNESS_OFF), _
                New CStComboBoxItem(Of Byte)("ON", StTrg.STCAM_SHARPNESS_ON) _
                }, value, forceDisabled)
            Case Fields.ShadingCorrectionMode
                Dim value As System.UInt32 = m_StCamera.ShadingCorrectionMode
                objStComboBox.InitList(New CStComboBoxItem(Of System.UInt32)() { _
                New CStComboBoxItem(Of System.UInt32)("OFF", StTrg.STCAM_SHADING_CORRECTION_MODE_OFF), _
                New CStComboBoxItem(Of System.UInt32)("Calibration(Multiplication)", StTrg.STCAM_SHADING_CORRECTION_MODE_CALIBRATION_MULTIPLICATION), _
                New CStComboBoxItem(Of System.UInt32)("ON(Multiplication)", StTrg.STCAM_SHADING_CORRECTION_MODE_ON_MULTIPLICATION), _
                New CStComboBoxItem(Of System.UInt32)("Calibration(Addition)", StTrg.STCAM_SHADING_CORRECTION_MODE_CALIBRATION_ADDITION), _
                New CStComboBoxItem(Of System.UInt32)("ON(Addition)", StTrg.STCAM_SHADING_CORRECTION_MODE_ON_ADDITION) _
                }, value, forceDisabled)
            Case Fields.YGammaMode  'Byte
                Dim value As Byte = m_StCamera.GammaMode(StTrg.STCAM_GAMMA_TARGET_Y)
                objStComboBox.InitList(New CStComboBoxItem(Of Byte)() { _
                New CStComboBoxItem(Of Byte)("OFF", StTrg.STCAM_GAMMA_OFF), _
                New CStComboBoxItem(Of Byte)("ON", StTrg.STCAM_GAMMA_ON), _
                New CStComboBoxItem(Of Byte)("REVERSE", StTrg.STCAM_GAMMA_REVERSE) _
                }, value, forceDisabled)
            Case Fields.RGammaMode  'Byte
                Dim value As Byte = m_StCamera.GammaMode(StTrg.STCAM_GAMMA_TARGET_R)
                objStComboBox.InitList(New CStComboBoxItem(Of Byte)() { _
                New CStComboBoxItem(Of Byte)("OFF", StTrg.STCAM_GAMMA_OFF), _
                New CStComboBoxItem(Of Byte)("ON", StTrg.STCAM_GAMMA_ON), _
                New CStComboBoxItem(Of Byte)("REVERSE", StTrg.STCAM_GAMMA_REVERSE) _
                }, value, forceDisabled)
            Case Fields.GRGammaMode 'Byte
                Dim value As Byte = m_StCamera.GammaMode(StTrg.STCAM_GAMMA_TARGET_GR)
                objStComboBox.InitList(New CStComboBoxItem(Of Byte)() { _
                New CStComboBoxItem(Of Byte)("OFF", StTrg.STCAM_GAMMA_OFF), _
                New CStComboBoxItem(Of Byte)("ON", StTrg.STCAM_GAMMA_ON), _
                New CStComboBoxItem(Of Byte)("REVERSE", StTrg.STCAM_GAMMA_REVERSE) _
                }, value, forceDisabled)
            Case Fields.GBGammaMode 'Byte
                Dim value As Byte = m_StCamera.GammaMode(StTrg.STCAM_GAMMA_TARGET_GB)
                objStComboBox.InitList(New CStComboBoxItem(Of Byte)() { _
                New CStComboBoxItem(Of Byte)("OFF", StTrg.STCAM_GAMMA_OFF), _
                New CStComboBoxItem(Of Byte)("ON", StTrg.STCAM_GAMMA_ON), _
                New CStComboBoxItem(Of Byte)("REVERSE", StTrg.STCAM_GAMMA_REVERSE) _
                }, value, forceDisabled)
            Case Fields.BGammaMode  'Byte
                Dim value As Byte = m_StCamera.GammaMode(StTrg.STCAM_GAMMA_TARGET_B)
                objStComboBox.InitList(New CStComboBoxItem(Of Byte)() { _
                New CStComboBoxItem(Of Byte)("OFF", StTrg.STCAM_GAMMA_OFF), _
                New CStComboBoxItem(Of Byte)("ON", StTrg.STCAM_GAMMA_ON), _
                New CStComboBoxItem(Of Byte)("REVERSE", StTrg.STCAM_GAMMA_REVERSE) _
                }, value, forceDisabled)
            Case Fields.ColorInterpolation  'Byte
                forceDisabled = StTrg.STCAM_COLOR_ARRAY_MONO.Equals(m_StCamera.ColorArray)

                Dim value As Byte = m_StCamera.ColorInterpolationMode
                objStComboBox.InitList(New CStComboBoxItem(Of Byte)() { _
                New CStComboBoxItem(Of Byte)("None(MONO)", StTrg.STCAM_COLOR_INTERPOLATION_NONE_MONO), _
                New CStComboBoxItem(Of Byte)("None(Color)", StTrg.STCAM_COLOR_INTERPOLATION_NONE_COLOR), _
                New CStComboBoxItem(Of Byte)("Nearest Neighbor", StTrg.STCAM_COLOR_INTERPOLATION_NEAREST_NEIGHBOR), _
                New CStComboBoxItem(Of Byte)("Bilinear", StTrg.STCAM_COLOR_INTERPOLATION_BILINEAR), _
                New CStComboBoxItem(Of Byte)("Bilinear(False color reduction)", StTrg.STCAM_COLOR_INTERPOLATION_BILINEAR_FALSE_COLOR_REDUCTION), _
                New CStComboBoxItem(Of Byte)("Bicubic", StTrg.STCAM_COLOR_INTERPOLATION_BICUBIC) _
                }, value, forceDisabled)

            Case Fields.Mirror  'Byte
                Dim value As Byte = m_StCamera.MirrorMode
                Dim hasMirrorHorizontal As Boolean = m_StCamera.HasMirrorHorizontal
                Dim hasMirrorVertical As Boolean = m_StCamera.HasMirrorVertical
                Dim nCount As Integer = 4
                If hasMirrorHorizontal Then
                    nCount += 1
                End If
                If hasMirrorVertical Then
                    nCount += 1
                    If hasMirrorHorizontal Then
                        nCount += 1
                    End If
                End If

                Dim list(nCount - 1) As CStComboBoxItem(Of Byte)
                list(0) = New CStComboBoxItem(Of Byte)("OFF", StTrg.STCAM_MIRROR_OFF)
                list(1) = New CStComboBoxItem(Of Byte)("Horizontal", StTrg.STCAM_MIRROR_HORIZONTAL)
                list(2) = New CStComboBoxItem(Of Byte)("Vertical", StTrg.STCAM_MIRROR_VERTICAL)
                list(3) = New CStComboBoxItem(Of Byte)("Horizontal/Vertical", StTrg.STCAM_MIRROR_HORIZONTAL_VERTICAL)

                Dim nIndex As Integer = 4
                If hasMirrorHorizontal Then
                    list(nIndex) = New CStComboBoxItem(Of Byte)("Horizontal[Camera]", StTrg.STCAM_MIRROR_HORIZONTAL_CAMERA)
                    nIndex += 1
                End If
                If hasMirrorVertical Then
                    list(nIndex) = New CStComboBoxItem(Of Byte)("Vertical[Camera]", StTrg.STCAM_MIRROR_VERTICAL_CAMERA)
                    nIndex += 1
                    If hasMirrorHorizontal Then
                        list(nIndex) = New CStComboBoxItem(Of Byte)("Horizontal/Vertical[Camera]", StTrg.STCAM_MIRROR_HORIZONTAL_CAMERA Or StTrg.STCAM_MIRROR_VERTICAL_CAMERA)
                        nIndex += 1
                    End If
                End If

                objStComboBox.InitList(list, value, forceDisabled)

            Case Fields.Rotation    'Byte
                Dim value As Byte = m_StCamera.RotationMode
                objStComboBox.InitList(New CStComboBoxItem(Of Byte)() { _
                New CStComboBoxItem(Of Byte)("OFF", StTrg.STCAM_ROTATION_OFF), _
                New CStComboBoxItem(Of Byte)("CLOCKWISE_90", StTrg.STCAM_ROTATION_CLOCKWISE_90), _
                New CStComboBoxItem(Of Byte)("COUNTERCLOCKWISE_90", StTrg.STCAM_ROTATION_COUNTERCLOCKWISE_90) _
                }, value, forceDisabled)
            Case Fields.ScanMode    'Word
                Dim value As UShort = m_StCamera.ScanMode
                Dim wEnableScanMode As UShort = m_StCamera.EnableScanMode
                Dim nScanModeCount As Integer = 1
                Dim wMask As UShort = 1
                Do
                    If (wMask And wEnableScanMode) <> 0 Then
                        nScanModeCount += 1
                    End If
                    wMask <<= 1
                Loop While wMask <> 0
                Dim list(nScanModeCount - 1) As CStComboBoxItem(Of UShort)
                list(0) = New CStComboBoxItem(Of UShort)("Normal", StTrg.STCAM_SCAN_MODE_NORMAL)
                Dim nIndex As Integer = 1
                wMask = 1
                Do
                    If (wMask And wEnableScanMode) <> 0 Then
                        Select Case (wMask)
                            Case (StTrg.STCAM_SCAN_MODE_PARTIAL_1)
                                list(nIndex) = New CStComboBoxItem(Of UShort)("Partial_1", wMask)
                            Case (StTrg.STCAM_SCAN_MODE_PARTIAL_2)
                                list(nIndex) = New CStComboBoxItem(Of UShort)("Partial_2", wMask)
                            Case (StTrg.STCAM_SCAN_MODE_PARTIAL_4)
                                list(nIndex) = New CStComboBoxItem(Of UShort)("Partial_4", wMask)
                            Case (StTrg.STCAM_SCAN_MODE_BINNING)
                                list(nIndex) = New CStComboBoxItem(Of UShort)("Binning", wMask)
                            Case (StTrg.STCAM_SCAN_MODE_BINNING_PARTIAL_1)
                                list(nIndex) = New CStComboBoxItem(Of UShort)("Binning Partial_1", wMask)
                            Case (StTrg.STCAM_SCAN_MODE_BINNING_PARTIAL_2)
                                list(nIndex) = New CStComboBoxItem(Of UShort)("Binning Partial_2", wMask)
                            Case (StTrg.STCAM_SCAN_MODE_BINNING_PARTIAL_4)
                                list(nIndex) = New CStComboBoxItem(Of UShort)("Binning Partial_4", wMask)
                            Case (StTrg.STCAM_SCAN_MODE_ROI)
                                list(nIndex) = New CStComboBoxItem(Of UShort)("ROI", wMask)
                            Case (StTrg.STCAM_SCAN_MODE_VARIABLE_PARTIAL)
                                list(nIndex) = New CStComboBoxItem(Of UShort)("Variable Partial", wMask)
                            Case (StTrg.STCAM_SCAN_MODE_BINNING_VARIABLE_PARTIAL)
                                list(nIndex) = New CStComboBoxItem(Of UShort)("Binning Variable Partial", wMask)
                        End Select
                        nIndex += 1
                    End If
                    wMask <<= 1
                Loop While wMask <> 0
                objStComboBox.InitList(list, value, forceDisabled)
            Case Fields.TriggerMode 'Dword
                forceDisabled = Not m_StCamera.HasTriggerFunction()
                Dim value As UInteger = m_StCamera.TriggerMode
                objStComboBox.InitList(New CStComboBoxItem(Of UInteger)() { _
                New CStComboBoxItem(Of UInteger)("OFF", StTrg.STCAM_TRIGGER_MODE_OFF), _
                New CStComboBoxItem(Of UInteger)("ON", StTrg.STCAM_TRIGGER_MODE_ON) _
                }, value, forceDisabled)
                
            Case Fields.TriggerSource   'Dword
                forceDisabled = (m_StCamera.TriggerMode <> StTrg.STCAM_TRIGGER_MODE_ON)
                Dim isGenICamIO As Boolean = m_StCamera.HasGenICamIO()
                If m_StCamera.TriggerSelector = StTrg.STCAM_TRIGGER_SELECTOR_FRAME_BURST_START Then
                    isGenICamIO = True
                End If
                Dim aIsInputPin(3) As Boolean
                Dim nItemCount As Integer = 2
                If (isGenICamIO) Then
                    For pin As Integer = 0 To aIsInputPin.GetLength(0) - 1
                        aIsInputPin(pin) = False
                        If m_StCamera.IOExistence(CType(pin, Byte)) Then
                            If m_StCamera.IOPinInOut(CType(pin, Byte)) = 0 Then
                                aIsInputPin(pin) = True
                                nItemCount = nItemCount + 1
                            End If
                        End If
                    Next
                Else
                    nItemCount = 3
                End If
                Dim value As UInteger = m_StCamera.TriggerSource
                Dim aStItem(nItemCount - 1) As CStComboBoxItem(Of UInteger)
                aStItem(0) = New CStComboBoxItem(Of UInteger)("Disable", StTrg.STCAM_TRIGGER_SOURCE_DISABLED)
                aStItem(1) = New CStComboBoxItem(Of UInteger)("Software", StTrg.STCAM_TRIGGER_SOURCE_SOFTWARE)
                If isGenICamIO Then
                    Dim nIndex As Integer = 2
                    For pin As Integer = 0 To aIsInputPin.GetLength(0) - 1
                        If aIsInputPin(pin) Then
                            aStItem(nIndex) = New CStComboBoxItem(Of UInteger)("Line" + pin.ToString(), CType(StTrg.STCAM_TRIGGER_SOURCE_LINE0 + pin, UInteger))
                            nIndex = nIndex + 1
                        End If
                    Next
                Else
                    aStItem(2) = New CStComboBoxItem(Of UInteger)("Hardware", StTrg.STCAM_TRIGGER_SOURCE_HARDWARE)
                    If 2 < value Then
                        value = 2
                    End If
                End If
                objStComboBox.InitList(aStItem, value, forceDisabled)
            Case Fields.ExposureMode    'Dword
                forceDisabled = Not m_StCamera.HasTriggerFunction()

                Dim value As UInteger = m_StCamera.ExposureMode
                Dim nItemCount As Integer = 2
                If (m_StCamera.HasExposureEndHardwareTrigger()) Then nItemCount += 1
                If (m_StCamera.HasExposureModeTriggerControlled()) Then nItemCount += 1
                Dim aStItem(nItemCount - 1) As CStComboBoxItem(Of UInteger)
                aStItem(0) = New CStComboBoxItem(Of UInteger)("Off", StTrg.STCAM_EXPOSURE_MODE_OFF)
                aStItem(1) = New CStComboBoxItem(Of UInteger)("Timed", StTrg.STCAM_EXPOSURE_MODE_TIMED)
                Dim nItemNo As Integer = 2

                If (m_StCamera.HasExposureEndHardwareTrigger()) Then
                    aStItem(nItemNo) = New CStComboBoxItem(Of UInteger)("Trigger Width", StTrg.STCAM_EXPOSURE_MODE_TRIGGER_WIDTH)
                    nItemNo += 1
                End If

                If (m_StCamera.HasExposureModeTriggerControlled()) Then
                    aStItem(nItemNo) = New CStComboBoxItem(Of UInteger)("Trigger Controlled", StTrg.STCAM_EXPOSURE_MODE_TRIGGER_CONTROLLED)
                    nItemNo += 1
                End If

                objStComboBox.InitList(aStItem, value, forceDisabled)
            Case Fields.TriggerSelector 'Dword
                Dim aSelector() As UInt32 = New UInt32() { _
                                    StTrg.STCAM_TRIGGER_SELECTOR_FRAME_START, _
                                    StTrg.STCAM_TRIGGER_SELECTOR_FRAME_BURST_START, _
                                    StTrg.STCAM_TRIGGER_SELECTOR_EXPOSURE_START, _
                                    StTrg.STCAM_TRIGGER_SELECTOR_EXPOSURE_END, _
                                    StTrg.STCAM_TRIGGER_SELECTOR_SENSOR_READ_OUT_START}
                Dim aText() As String = New String() { _
                                    "FrameStart", _
                                    "FrameBurstStart", _
                                    "ExposureStart", _
                                    "ExposureEnd", _
                                    "SensorReadOutStart" _
                                }
                Dim isSupported(aText.GetLength(0) - 1) As Boolean
                Dim value As UInteger = m_StCamera.TriggerSelector
                Dim nCount As Integer
                For j As Integer = 0 To aText.GetLength(0) - 1
                    isSupported(j) = m_StCamera.IsTriggerSelectorSupported(aSelector(j))
                    If (isSupported(j)) Then
                        nCount = nCount + 1
                    End If
                Next j
                Dim aStItem(nCount - 1) As CStComboBoxItem(Of UInteger)
                Dim index As Integer = 0
                For j As Integer = 0 To aText.GetLength(0) - 1
                    If (isSupported(j)) Then
                        aStItem(index) = New CStComboBoxItem(Of UInteger)(aText(j), aSelector(j))
                        index = index + 1
                    End If
                Next j
                objStComboBox.InitList(aStItem, value, forceDisabled)

            Case Fields.TriggerOverlap
                forceDisabled = Not m_StCamera.HasTriggerOverlapFunction()
                Dim arrayComboBoxItem() As CStComboBoxItem(Of UInteger) = Nothing
                If Not forceDisabled Then
                    Dim arrayValues() As UInteger = {StTrg.STCAM_TRIGGER_OVERLAP_OFF, StTrg.STCAM_TRIGGER_OVERLAP_READ_OUT, StTrg.STCAM_TRIGGER_OVERLAP_PREVIOUS_FRAME}
                    Dim arrayNames() As String = {"OFF", "Read Out", "Previos Frame"}
                    Dim nCount As Integer = 0
                    For j As Integer = 0 To arrayValues.Length() - 1
                        If m_StCamera.HasTriggerOverlapValue(arrayValues(j)) Then
                            ReDim Preserve arrayComboBoxItem(nCount)
                            arrayComboBoxItem(nCount) = New CStComboBoxItem(Of UInteger)(arrayNames(j), arrayValues(j))
                            nCount += 1
                        End If
                    Next
                End If
                Dim value As UInteger = m_StCamera.TriggerOverlap
                objStComboBox.InitList(arrayComboBoxItem, value, forceDisabled)
            Case Fields.ExposureWaitHD  'Dword
                forceDisabled = (Not m_StCamera.IsAnyTriggerModeON()) Or (Not m_StCamera.HasExposureStartWaitHD)
                Dim value As UInteger = m_StCamera.ExposureWaitHD
                objStComboBox.InitList(New CStComboBoxItem(Of UInteger)() { _
                New CStComboBoxItem(Of UInteger)("OFF", StTrg.STCAM_TRIGGER_MODE_EXPOSURE_WAIT_HD_OFF), _
                New CStComboBoxItem(Of UInteger)("ON", StTrg.STCAM_TRIGGER_MODE_EXPOSURE_WAIT_HD_ON) _
                }, value, forceDisabled)

            Case Fields.ExposureWaitReadOut 'Dword
                forceDisabled = (Not m_StCamera.IsAnyTriggerModeON()) Or (Not m_StCamera.HasExposureStartWaitReadOut)

                Dim value As UInteger = m_StCamera.ExposureWaitReadOut
                objStComboBox.InitList(New CStComboBoxItem(Of UInteger)() { _
                New CStComboBoxItem(Of UInteger)("OFF", StTrg.STCAM_TRIGGER_MODE_EXPOSURE_WAIT_READOUT_OFF), _
                New CStComboBoxItem(Of UInteger)("ON", StTrg.STCAM_TRIGGER_MODE_EXPOSURE_WAIT_READOUT_ON) _
                }, value, forceDisabled)


            Case Fields.ExposureEnd 'Dword
                Dim value As UInteger = m_StCamera.ExposureEnd
                objStComboBox.InitList(New CStComboBoxItem(Of UInteger)() { _
                New CStComboBoxItem(Of UInteger)("Disable", StTrg.STCAM_TRIGGER_MODE_EXPEND_DISABLE), _
                New CStComboBoxItem(Of UInteger)("Enable", StTrg.STCAM_TRIGGER_MODE_EXPEND_ENABLE) _
                }, value, forceDisabled)

            Case Fields.CameraMemory    'Dword
                forceDisabled = Not m_StCamera.HasCameraMemoryFunction()

                Dim value As UInteger = m_StCamera.CameraMemory
                objStComboBox.InitList(New CStComboBoxItem(Of UInteger)() { _
                New CStComboBoxItem(Of UInteger)("Type B", StTrg.STCAM_TRIGGER_MODE_CAMERA_MEMORY_TYPE_B), _
                New CStComboBoxItem(Of UInteger)("Type A", StTrg.STCAM_TRIGGER_MODE_CAMERA_MEMORY_TYPE_A), _
                New CStComboBoxItem(Of UInteger)("OFF", StTrg.STCAM_TRIGGER_MODE_CAMERA_MEMORY_OFF) _
                }, value, forceDisabled)
            Case Fields.SensorShutterMode
                Dim dwSupportedSensorShutterMode As UInteger = m_StCamera.GetSupportedSensorShutterMode()
                Dim value As UInteger = m_StCamera.SensorShutterMode

                Select Case dwSupportedSensorShutterMode
                    Case 1
                        objStComboBox.InitList(New CStComboBoxItem(Of UInteger)() { _
                        New CStComboBoxItem(Of UInteger)("Rolling", StTrg.STCAM_SENSOR_SHUTTER_MODE_ROLLING), _
                        New CStComboBoxItem(Of UInteger)("Global Reset", StTrg.STCAM_SENSOR_SHUTTER_MODE_GLOBAL_RESET) _
                        }, value, forceDisabled)
                    Case 2
                        objStComboBox.InitList(New CStComboBoxItem(Of UInteger)() { _
                        New CStComboBoxItem(Of UInteger)("Rolling", StTrg.STCAM_SENSOR_SHUTTER_MODE_ROLLING), _
                        New CStComboBoxItem(Of UInteger)("Global Shutter", StTrg.STCAM_SENSOR_SHUTTER_MODE_GLOBAL) _
                        }, value, forceDisabled)
                    Case Else
                        objStComboBox.Enabled = False
                End Select

            Case Fields.NoiseReduction  'Dword
                forceDisabled = (m_StCamera.ExposureMode = StTrg.STCAM_EXPOSURE_MODE_TIMED) OrElse (m_StCamera.ExposureMode = StTrg.STCAM_EXPOSURE_MODE_OFF)

                Dim value As UInteger = m_StCamera.NoiseReductionMode
                objStComboBox.InitList(New CStComboBoxItem(Of UInteger)() { _
                New CStComboBoxItem(Of UInteger)("OFF", StTrg.STCAM_NR_OFF), _
                New CStComboBoxItem(Of UInteger)("Easy", StTrg.STCAM_NR_EASY), _
                New CStComboBoxItem(Of UInteger)("Calibration", StTrg.STCAM_NR_DARK_CL), _
                New CStComboBoxItem(Of UInteger)("Complex", StTrg.STCAM_NR_COMPREX) _
                }, value, forceDisabled)

            Case Fields.ClockMode   'Dword
                Dim value As UInteger = m_StCamera.ClockMode
                Dim dwEnableMode As UInteger = m_StCamera.EnableClockMode
                Dim nCount As Integer = 1
                Dim dwMask As UInteger = 1
                Do
                    If (dwMask And dwEnableMode) <> 0 Then
                        nCount += 1
                    End If
                    dwMask <<= 1
                Loop While dwMask <> 0
                Dim list(nCount - 1) As CStComboBoxItem(Of UInteger)
                list(0) = New CStComboBoxItem(Of UInteger)("Normal", StTrg.STCAM_CLOCK_MODE_NORMAL)
                Dim nIndex As Integer = 1
                dwMask = 1
                Do
                    If (dwMask And dwEnableMode) <> 0 Then
                        Select Case (dwMask)
                            Case (StTrg.STCAM_CLOCK_MODE_DIV_2)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("1/2", dwMask)
                            Case (StTrg.STCAM_CLOCK_MODE_DIV_4)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("1/4", dwMask)
                            Case (StTrg.STCAM_CLOCK_MODE_VGA_90FPS)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("90FPS", dwMask)
                        End Select
                        nIndex += 1
                    End If
                    dwMask <<= 1
                Loop While dwMask <> 0
                forceDisabled = forceDisabled Or (nCount < 2)
                objStComboBox.InitList(list, value, forceDisabled)
            Case Fields.IOInOut0, Fields.IOInOut1, Fields.IOInOut2, Fields.IOInOut3    'Dword
                forceDisabled = Not m_StCamera.HasChangeIOFunction()

                Dim pinNo As Byte = 0
                If (Fields.IOInOut1.Equals(objStComboBox.Field)) Then
                    pinNo = 1
                ElseIf (Fields.IOInOut2.Equals(objStComboBox.Field)) Then
                    pinNo = 2
                ElseIf (Fields.IOInOut3.Equals(objStComboBox.Field)) Then
                    pinNo = 3
                End If
                If (Not forceDisabled) Then
                    forceDisabled = Not m_StCamera.IOExistence(pinNo)
                End If
                Dim value As UInteger = m_StCamera.IOPinInOut(pinNo)
                objStComboBox.InitList(New CStComboBoxItem(Of UInteger)() { _
                New CStComboBoxItem(Of UInteger)("Input", 0), _
                New CStComboBoxItem(Of UInteger)("Output", 1) _
                }, value, forceDisabled)


            Case Fields.IOMode0, Fields.IOMode1, Fields.IOMode2, Fields.IOMode3   'Dword
                Dim pinNo As Byte = 0
                If (Fields.IOMode1.Equals(objStComboBox.Field)) Then
                    pinNo = 1
                ElseIf (Fields.IOMode2.Equals(objStComboBox.Field)) Then
                    pinNo = 2
                ElseIf (Fields.IOMode3.Equals(objStComboBox.Field)) Then
                    pinNo = 3
                End If
                Dim value As UInteger = m_StCamera.IOPinMode(pinNo)
                If (Not forceDisabled) Then
                    forceDisabled = Not m_StCamera.IOExistence(pinNo)
                End If
                If m_StCamera.IOPinInOut(pinNo) = 1 Then
                    'Output
                    Dim nCount As Integer = 7
                    If (m_StCamera.HasTriggerThroughFunction()) Then
                        nCount += 1
                    End If
                    If (m_StCamera.HasTriggerValidOutput()) Then
                        nCount += 1
                    End If
                    If (m_StCamera.HasTransferEndOutput()) Then
                        nCount += 1
                    End If
                    Dim list(nCount - 1) As CStComboBoxItem(Of UInteger)
                    Dim nIndex As Integer = 0
                    list(nIndex) = New CStComboBoxItem(Of UInteger)("Disable", StTrg.STCAM_OUT_PIN_MODE_DISABLE)
                    nIndex += 1
                    list(nIndex) = New CStComboBoxItem(Of UInteger)("General Output", StTrg.STCAM_OUT_PIN_MODE_GENERAL_OUTPUT)
                    nIndex += 1
                    list(nIndex) = New CStComboBoxItem(Of UInteger)("Trigger Output Programmable", StTrg.STCAM_OUT_PIN_MODE_TRIGGER_OUTPUT_PROGRAMMABLE)
                    nIndex += 1
                    If (m_StCamera.HasTriggerThroughFunction()) Then
                        list(nIndex) = New CStComboBoxItem(Of UInteger)("Trigger Output Loop Through", StTrg.STCAM_OUT_PIN_MODE_TRIGGER_OUTPUT_LOOP_THROUGH)
                        nIndex += 1
                    End If
                    list(nIndex) = New CStComboBoxItem(Of UInteger)("Exposure End", StTrg.STCAM_OUT_PIN_MODE_EXPOSURE_END)
                    nIndex += 1
                    list(nIndex) = New CStComboBoxItem(Of UInteger)("CCD Read End Output", StTrg.STCAM_OUT_PIN_MODE_CCD_READ_END_OUTPUT)
                    nIndex += 1
                    list(nIndex) = New CStComboBoxItem(Of UInteger)("Strobe Output Programmable", StTrg.STCAM_OUT_PIN_MODE_STROBE_OUTPUT_PROGRAMMABLE)
                    nIndex += 1
                    list(nIndex) = New CStComboBoxItem(Of UInteger)("Strobe Output Exposure", StTrg.STCAM_OUT_PIN_MODE_STROBE_OUTPUT_EXPOSURE)
                    nIndex += 1
                    If (m_StCamera.HasTriggerValidOutput()) Then
                        list(nIndex) = New CStComboBoxItem(Of UInteger)("Trigger Valid Out", StTrg.STCAM_OUT_PIN_MODE_TRIGGER_VALID_OUT)
                        nIndex += 1
                    End If
                    If (m_StCamera.HasTransferEndOutput()) Then
                        list(nIndex) = New CStComboBoxItem(Of UInteger)("Transfer End", StTrg.STCAM_OUT_PIN_MODE_TRANSFER_END)
                        nIndex += 1
                    End If
                    objStComboBox.InitList(list, value, forceDisabled)
                Else
                    'input
                    If m_StCamera.HasGenICamIO() Then
                        objStComboBox.Items.Clear()
                        objStComboBox.Enabled = False
                    Else
                        Dim nCount As Integer = 3
                        If (m_StCamera.HasReadOut()) Then
                            nCount += 1
                        End If
                        If (m_StCamera.HasExposureEndHardwareTrigger()) Then
                            nCount += 1
                        End If
                        Dim list(nCount - 1) As CStComboBoxItem(Of UInteger)
                        Dim nIndex As Integer = 0
                        list(nIndex) = New CStComboBoxItem(Of UInteger)("Disable", StTrg.STCAM_IN_PIN_MODE_DISABLE)
                        nIndex += 1
                        list(nIndex) = New CStComboBoxItem(Of UInteger)("General Input", StTrg.STCAM_IN_PIN_MODE_GENERAL_INPUT)
                        nIndex += 1
                        list(nIndex) = New CStComboBoxItem(Of UInteger)("Frame/ExposureStart Input", StTrg.STCAM_IN_PIN_MODE_TRIGGER_INPUT)
                        nIndex += 1
                        If (m_StCamera.HasReadOut()) Then
                            list(nIndex) = New CStComboBoxItem(Of UInteger)("Readout Input", StTrg.STCAM_IN_PIN_MODE_READOUT_INPUT)
                            nIndex += 1
                        End If
                        If (m_StCamera.HasExposureEndHardwareTrigger()) Then
                            list(nIndex) = New CStComboBoxItem(Of UInteger)("ExposureEnd Input", StTrg.STCAM_IN_PIN_MODE_SUB_TRIGGER_INPUT)
                            nIndex += 1
                        End If

                        objStComboBox.InitList(list, value, forceDisabled)

                    End If
                End If


            Case Fields.IOPolarity0, Fields.IOPolarity1, Fields.IOPolarity2, Fields.IOPolarity3    'Dword
                Dim pinNo As Byte = 0
                If (Fields.IOPolarity1.Equals(objStComboBox.Field)) Then
                    pinNo = 1
                ElseIf (Fields.IOPolarity2.Equals(objStComboBox.Field)) Then
                    pinNo = 2
                ElseIf (Fields.IOPolarity3.Equals(objStComboBox.Field)) Then
                    pinNo = 3
                End If

                Dim ioMode As UInteger = m_StCamera.IOPinMode(pinNo)
                If m_StCamera.HasGenICamIO() Then

                Else
                    If StTrg.STCAM_IN_PIN_MODE_DISABLE.Equals(ioMode) OrElse StTrg.STCAM_IN_PIN_MODE_GENERAL_INPUT.Equals(ioMode) Then
                        forceDisabled = True
                    End If
                End If
                If (Not forceDisabled) Then
                    forceDisabled = Not m_StCamera.IOExistence(pinNo)
                End If


                Dim value As UInteger = m_StCamera.IOPinPolarity(pinNo)
                objStComboBox.InitList(New CStComboBoxItem(Of UInteger)() { _
                New CStComboBoxItem(Of UInteger)("Positive", 0), _
                New CStComboBoxItem(Of UInteger)("Negative", 1) _
                }, value, forceDisabled)
            Case Fields.IOStatus0, Fields.IOStatus1, Fields.IOStatus2, Fields.IOStatus3    'Dword
                Dim pinNo As Byte = 0
                If (Fields.IOStatus1.Equals(objStComboBox.Field)) Then
                    pinNo = 1
                ElseIf (Fields.IOStatus2.Equals(objStComboBox.Field)) Then
                    pinNo = 2
                ElseIf (Fields.IOStatus3.Equals(objStComboBox.Field)) Then
                    pinNo = 3
                End If

                If (0 = m_StCamera.IOPinInOut(pinNo)) OrElse (Not StTrg.STCAM_OUT_PIN_MODE_GENERAL_OUTPUT.Equals(m_StCamera.IOPinMode(pinNo))) Then
                    forceDisabled = True
                End If
                If (Not forceDisabled) Then
                    forceDisabled = Not m_StCamera.IOExistence(pinNo)
                End If


                Dim value As UInteger = m_StCamera.IOPinStatus(pinNo)
                objStComboBox.InitList(New CStComboBoxItem(Of UInteger)() { _
                New CStComboBoxItem(Of UInteger)("Low", 0), _
                New CStComboBoxItem(Of UInteger)("High", 1) _
                }, value, forceDisabled)
            Case Fields.ResetSwitch
                forceDisabled = Not m_StCamera.HasResetSwitchDisabledFunction()
                Dim value As Boolean = m_StCamera.ResetSwitchEnabled
                objStComboBox.InitList(New CStComboBoxItem(Of Boolean)() { _
                New CStComboBoxItem(Of Boolean)("Disabled", False), _
                New CStComboBoxItem(Of Boolean)("Enabled", True) _
                }, value, forceDisabled)

            Case Fields.LEDGreen    'Dword
                forceDisabled = Not m_StCamera.HasLEDFunction(0)
                Dim value As UInteger = m_StCamera.LEDGreen
                objStComboBox.InitList(New CStComboBoxItem(Of UInteger)() { _
                New CStComboBoxItem(Of UInteger)("OFF", 0), _
                New CStComboBoxItem(Of UInteger)("ON", StTrg.STCAM_LED_GREEN_ON) _
                }, value, forceDisabled)
            Case Fields.LEDRed  'Dword
                forceDisabled = Not m_StCamera.HasLEDFunction(1)
                Dim value As UInteger = m_StCamera.LEDRed
                objStComboBox.InitList(New CStComboBoxItem(Of UInteger)() { _
                New CStComboBoxItem(Of UInteger)("OFF", 0), _
                New CStComboBoxItem(Of UInteger)("ON", StTrg.STCAM_LED_RED_ON) _
                }, value, forceDisabled)
            Case Fields.TransferBitsPerPixel    'Dword
                Dim enableMode As UInteger = m_StCamera.EnableTransferBitsPerPixel
                Dim value As UInteger = m_StCamera.TransferBitsPerPixel
                Dim nModeCount As Integer = 0
                Dim dwMask As UInteger = 1
                Do
                    If (dwMask And enableMode) <> 0 Then
                        nModeCount += 1
                    End If
                    dwMask <<= 1
                Loop While dwMask <> 0
                Dim list(nModeCount - 1) As CStComboBoxItem(Of UInteger)
                Dim nIndex As Integer = 0
                dwMask = 1
                Do
                    If (dwMask And enableMode) <> 0 Then
                        Select Case (dwMask)
                            Case (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_RAW_08)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("RAW_08", dwMask)
                            Case (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_RAW_10)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("RAW_10", dwMask)
                            Case (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_RAW_12)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("RAW_12", dwMask)
                            Case (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_RAW_14)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("RAW_14", dwMask)
                            Case (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_RAW_16)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("RAW_16", dwMask)
                            Case (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_MONO_08)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("MONO_08", dwMask)
                            Case (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("MONO_10", dwMask)
                            Case (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("MONO_12", dwMask)
                            Case (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_MONO_14)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("MONO_14", dwMask)
                            Case (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_MONO_16)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("MONO_16", dwMask)
                            Case (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_BGR_08)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("BGR_08", dwMask)
                            Case (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_BGR_10)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("BGR_10", dwMask)
                            Case (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_RAW_10P)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("RAW_10bits[Packed]", dwMask)
                            Case (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_RAW_12P)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("RAW_12bits[Packed]", dwMask)
                            Case (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10P)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("MONO_10bits[Packed]", dwMask)
                            Case (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12P)
                                list(nIndex) = New CStComboBoxItem(Of UInteger)("MONO_12bits[Packed]", dwMask)
                        End Select
                        nIndex += 1
                    End If
                    dwMask <<= 1
                Loop While dwMask <> 0
                objStComboBox.InitList(list, value, forceDisabled)
            Case Fields.PriorityMode    'Dword
                If (m_StCamera.EnablePriorityMode <> 0) And (m_StCamera.TransferBitsPerPixel = StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_RAW_08) Then
                    objStComboBox.InitList(New CStComboBoxItem(Of UInt32)() { _
                        New CStComboBoxItem(Of UInt32)("Image quiality", StTrg.STCAM_PRIORITY_MODE_IMAGE_QUALITY), _
                        New CStComboBoxItem(Of UInt32)("Frame rate", StTrg.STCAM_PRIORITY_MODE_FRAME_RATE) _
                        }, m_StCamera.PriorityMode, forceDisabled)
                Else
                    objStComboBox.Items.Clear()
                    objStComboBox.Enabled = False
                End If
            Case Fields.DisplayPixelFormat  'Dword
                Dim value As UInteger = m_StCamera.StPixelFormat
                If (StTrg.STCAM_COLOR_ARRAY_MONO.Equals(m_StCamera.ColorArray)) Then
                    objStComboBox.InitList(New CStComboBoxItem(Of UInt32)() { _
                        New CStComboBoxItem(Of UInt32)("Mono8", StTrg.STCAM_PIXEL_FORMAT_08_MONO_OR_RAW), _
                        New CStComboBoxItem(Of UInt32)("BGR24", StTrg.STCAM_PIXEL_FORMAT_24_BGR), _
                        New CStComboBoxItem(Of UInt32)("BGR32", StTrg.STCAM_PIXEL_FORMAT_32_BGR) _
                        }, value, forceDisabled)
                Else
                    objStComboBox.InitList(New CStComboBoxItem(Of UInt32)() { _
                        New CStComboBoxItem(Of UInt32)("BGR24", StTrg.STCAM_PIXEL_FORMAT_24_BGR), _
                        New CStComboBoxItem(Of UInt32)("BGR32", StTrg.STCAM_PIXEL_FORMAT_32_BGR) _
                        }, value, forceDisabled)
                End If


            Case Fields.HBinningSkipping      'Word
                forceDisabled = Not (m_StCamera.ScanMode = StTrg.STCAM_SCAN_MODE_ROI)
                Dim value As UInt16 = m_StCamera.HBinningSkipping
                Select Case m_StCamera.USBPID
                    Case StTrg.STCAM_USBPID_STC_MBA5MUSB3, StTrg.STCAM_USBPID_STC_MCA5MUSB3
                        objStComboBox.InitList(New CStComboBoxItem(Of UInt16)() { _
                        New CStComboBoxItem(Of UInt16)("1/1", &H0), _
                        New CStComboBoxItem(Of UInt16)("1/2", &H1), _
                          New CStComboBoxItem(Of UInt16)("2/2", &H101), _
                          New CStComboBoxItem(Of UInt16)("1/3", &H2), _
                          New CStComboBoxItem(Of UInt16)("1/4", &H3), _
                          New CStComboBoxItem(Of UInt16)("2/4", &H103), _
                          New CStComboBoxItem(Of UInt16)("4/4", &H203), _
                          New CStComboBoxItem(Of UInt16)("1/5", &H4), _
                          New CStComboBoxItem(Of UInt16)("1/6", &H5), _
                          New CStComboBoxItem(Of UInt16)("2/6", &H105), _
                          New CStComboBoxItem(Of UInt16)("1/7", &H6) _
                        }, value, forceDisabled)
                    Case StTrg.STCAM_USBPID_STC_MBE132U3V, StTrg.STCAM_USBPID_STC_MCE132U3V
                        objStComboBox.InitList(New CStComboBoxItem(Of UInt16)() { _
                        New CStComboBoxItem(Of UInt16)("1/1", &H101), _
                        New CStComboBoxItem(Of UInt16)("1/2", &H102), _
                          New CStComboBoxItem(Of UInt16)("1/4", &H104), _
                          New CStComboBoxItem(Of UInt16)("2/1", &H201), _
                          New CStComboBoxItem(Of UInt16)("2/2", &H202), _
                          New CStComboBoxItem(Of UInt16)("2/4", &H204) _
                        }, value, forceDisabled)
                    Case StTrg.STCAM_USBPID_STC_MBCM401U3V, StTrg.STCAM_USBPID_STC_MBCM200U3V
                        objStComboBox.InitList(New CStComboBoxItem(Of UInt16)() { _
                        New CStComboBoxItem(Of UInt16)("1/1", &H101), _
                        New CStComboBoxItem(Of UInt16)("1/2", &H102), _
                          New CStComboBoxItem(Of UInt16)("1/4", &H104), _
                          New CStComboBoxItem(Of UInt16)("2/1", &H201), _
                          New CStComboBoxItem(Of UInt16)("4/1", &H401) _
                        }, value, forceDisabled)
                    Case StTrg.STCAM_USBPID_STC_MCCM401U3V, StTrg.STCAM_USBPID_STC_MCCM200U3V
                        objStComboBox.InitList(New CStComboBoxItem(Of UInt16)() { _
                        New CStComboBoxItem(Of UInt16)("1/1", &H101) _
                        }, value, forceDisabled)
                    Case StTrg.STCAM_USBPID_STC_MBS241U3V, StTrg.STCAM_USBPID_STC_MBS510U3V, StTrg.STCAM_USBPID_STC_MBS322U3V, StTrg.STCAM_USBPID_STC_MBS891U3V, StTrg.STCAM_USBPID_STC_MBS123BU3V, StTrg.STCAM_USBPID_STC_MBS163U3V
                        objStComboBox.InitList(New CStComboBoxItem(Of UInt16)() { _
                        New CStComboBoxItem(Of UInt16)("1/1", &H101), _
                        New CStComboBoxItem(Of UInt16)("1/2", &H102), _
                          New CStComboBoxItem(Of UInt16)("2/1", &H201) _
                        }, value, forceDisabled)
                    Case StTrg.STCAM_USBPID_STC_MCS241U3V, StTrg.STCAM_USBPID_STC_MCS510U3V, StTrg.STCAM_USBPID_STC_MCS322U3V, StTrg.STCAM_USBPID_STC_MCS891U3V, StTrg.STCAM_USBPID_STC_MCS123BU3V, StTrg.STCAM_USBPID_STC_MCS163U3V
                        objStComboBox.InitList(New CStComboBoxItem(Of UInt16)() { _
                        New CStComboBoxItem(Of UInt16)("1/1", &H101), _
                        New CStComboBoxItem(Of UInt16)("1/2", &H102) _
                        }, value, forceDisabled)
                    Case Else
                        objStComboBox.Enabled = False
                End Select

            Case Fields.VBinningSkipping      'Word
                forceDisabled = Not (m_StCamera.ScanMode = StTrg.STCAM_SCAN_MODE_ROI)
                Dim value As UInt16 = m_StCamera.VBinningSkipping

                Select Case m_StCamera.USBPID
                    Case StTrg.STCAM_USBPID_STC_MBA5MUSB3, StTrg.STCAM_USBPID_STC_MCA5MUSB3
                        objStComboBox.InitList(New CStComboBoxItem(Of UInt16)() { _
                          New CStComboBoxItem(Of UInt16)("1/1", &H0), _
                          New CStComboBoxItem(Of UInt16)("1/2", &H1), _
                         New CStComboBoxItem(Of UInt16)("2/2", &H101), _
                         New CStComboBoxItem(Of UInt16)("1/3", &H2), _
                         New CStComboBoxItem(Of UInt16)("1/4", &H3), _
                         New CStComboBoxItem(Of UInt16)("2/4", &H103), _
                         New CStComboBoxItem(Of UInt16)("4/4", &H203), _
                         New CStComboBoxItem(Of UInt16)("1/5", &H4), _
                         New CStComboBoxItem(Of UInt16)("1/6", &H5), _
                         New CStComboBoxItem(Of UInt16)("2/6", &H105), _
                         New CStComboBoxItem(Of UInt16)("1/7", &H6), _
                        New CStComboBoxItem(Of UInt16)("1/8", &H7), _
                        New CStComboBoxItem(Of UInt16)("2/8", &H107), _
                        New CStComboBoxItem(Of UInt16)("4/8", &H207) _
                        }, value, forceDisabled)
                    Case StTrg.STCAM_USBPID_STC_MBE132U3V, StTrg.STCAM_USBPID_STC_MCE132U3V
                        objStComboBox.InitList(New CStComboBoxItem(Of UInt16)() { _
                        New CStComboBoxItem(Of UInt16)("1/1", &H101), _
                        New CStComboBoxItem(Of UInt16)("1/2", &H102), _
                          New CStComboBoxItem(Of UInt16)("1/4", &H104), _
                          New CStComboBoxItem(Of UInt16)("2/1", &H201), _
                          New CStComboBoxItem(Of UInt16)("2/2", &H202), _
                          New CStComboBoxItem(Of UInt16)("2/4", &H204) _
                        }, value, forceDisabled)
                    Case StTrg.STCAM_USBPID_STC_MBCM401U3V, StTrg.STCAM_USBPID_STC_MBCM200U3V
                        objStComboBox.InitList(New CStComboBoxItem(Of UInt16)() { _
                        New CStComboBoxItem(Of UInt16)("1/1", &H101), _
                        New CStComboBoxItem(Of UInt16)("1/2", &H102), _
                          New CStComboBoxItem(Of UInt16)("1/4", &H104), _
                          New CStComboBoxItem(Of UInt16)("2/1", &H201), _
                          New CStComboBoxItem(Of UInt16)("4/1", &H401) _
                        }, value, forceDisabled)
                    Case StTrg.STCAM_USBPID_STC_MCCM401U3V, StTrg.STCAM_USBPID_STC_MCCM200U3V
                        objStComboBox.InitList(New CStComboBoxItem(Of UInt16)() { _
                        New CStComboBoxItem(Of UInt16)("1/1", &H101), _
                        New CStComboBoxItem(Of UInt16)("1/2", &H102), _
                          New CStComboBoxItem(Of UInt16)("1/4", &H104) _
                        }, value, forceDisabled)
                    Case StTrg.STCAM_USBPID_STC_MBS241U3V, StTrg.STCAM_USBPID_STC_MBS510U3V, StTrg.STCAM_USBPID_STC_MBS322U3V, StTrg.STCAM_USBPID_STC_MBS891U3V, StTrg.STCAM_USBPID_STC_MBS123BU3V, StTrg.STCAM_USBPID_STC_MBS163U3V
                        objStComboBox.InitList(New CStComboBoxItem(Of UInt16)() { _
                        New CStComboBoxItem(Of UInt16)("1/1", &H101), _
                        New CStComboBoxItem(Of UInt16)("1/2", &H102), _
                          New CStComboBoxItem(Of UInt16)("2/1", &H201) _
                        }, value, forceDisabled)
                    Case StTrg.STCAM_USBPID_STC_MCS241U3V, StTrg.STCAM_USBPID_STC_MCS510U3V, StTrg.STCAM_USBPID_STC_MCS322U3V, StTrg.STCAM_USBPID_STC_MCS891U3V, StTrg.STCAM_USBPID_STC_MCS123BU3V, StTrg.STCAM_USBPID_STC_MCS163U3V
                        objStComboBox.InitList(New CStComboBoxItem(Of UInt16)() { _
                        New CStComboBoxItem(Of UInt16)("1/1", &H101), _
                        New CStComboBoxItem(Of UInt16)("1/2", &H102) _
                        }, value, forceDisabled)
                    Case Else
                        objStComboBox.Enabled = False
                End Select
            Case Fields.HBinningSumMode 'Word
                forceDisabled = (Not m_StCamera.HasHBinningSum) Or (m_StCamera.ScanMode <> StTrg.STCAM_SCAN_MODE_ROI)
                Dim value As UInt16 = CUShort(m_StCamera.BinningSumMode And &HFF)
                objStComboBox.InitList(New CStComboBoxItem(Of UInt16)() { _
                New CStComboBoxItem(Of UInt16)("OFF", StTrg.STCAM_BINNING_SUM_MODE_OFF), _
                  New CStComboBoxItem(Of UInt16)("ON", StTrg.STCAM_BINNING_SUM_MODE_H) _
                }, value, forceDisabled)
            Case Fields.VBinningSumMode 'Word
                forceDisabled = (Not m_StCamera.HasVBinningSum) Or (m_StCamera.ScanMode <> StTrg.STCAM_SCAN_MODE_ROI)
                Dim value As UInt16 = CUShort(m_StCamera.BinningSumMode And &HFF00)
                objStComboBox.InitList(New CStComboBoxItem(Of UInt16)() { _
                New CStComboBoxItem(Of UInt16)("OFF", StTrg.STCAM_BINNING_SUM_MODE_OFF), _
                  New CStComboBoxItem(Of UInt16)("ON", StTrg.STCAM_BINNING_SUM_MODE_V) _
                }, value, forceDisabled)
            Case Fields.CurrentRegion
                forceDisabled = ((m_StCamera.ScanMode <> StTrg.STCAM_SCAN_MODE_ROI) Or (m_StCamera.MaxRegionCount < 2))
                Dim value As Integer = m_StCamera.CurrentRegion

                Dim list(m_StCamera.MaxRegionCount - 1) As CStComboBoxItem(Of Integer)
                For nRegionIndex As Integer = 0 To m_StCamera.MaxRegionCount - 1
                    list(nRegionIndex) = New CStComboBoxItem(Of Integer)("Region" + nRegionIndex.ToString(), nRegionIndex)
                Next
                objStComboBox.InitList(list, value, forceDisabled)
            Case Fields.RegionMode
                forceDisabled = (m_StCamera.CurrentRegion <= 0)
                Dim value As Boolean = m_StCamera.RegionMode
                objStComboBox.InitList( _
                    New CStComboBoxItem(Of Boolean)() _
                        { _
                            New CStComboBoxItem(Of Boolean)("OFF", False), _
                            New CStComboBoxItem(Of Boolean)("ON", True) _
                        }, value, forceDisabled)
            Case Fields.HDR_CMOSIS4M_Mode
                Dim value As Byte = m_StCamera.HDR_CMOSIS4M_Mode
                objStComboBox.InitList( _
                    New CStComboBoxItem(Of Byte)() _
                        { _
                            New CStComboBoxItem(Of Byte)("OFF", 0), _
                            New CStComboBoxItem(Of Byte)("ON", 1) _
                        }, value, forceDisabled)
            Case Fields.HDR_CMOSIS4M_SlopeNum
                forceDisabled = (m_StCamera.HDR_CMOSIS4M_Mode <= 0)
                Dim value As Byte = m_StCamera.HDR_CMOSIS4M_SlopeNum
                objStComboBox.InitList( _
                    New CStComboBoxItem(Of Byte)() _
                        { _
                            New CStComboBoxItem(Of Byte)("1", 1), _
                            New CStComboBoxItem(Of Byte)("2", 2), _
                            New CStComboBoxItem(Of Byte)("3", 3) _
                        }, value, forceDisabled)
        End Select

	End Sub
	Public Sub UpdateDisplayReadOnly(ByVal ctrl As StReadOnlyTextBox)
		Select Case (ctrl.Field)
			Case Fields.CameraType
				ctrl.Text = m_StCamera.CameraType
			Case Fields.FPGAVersion
				ctrl.Text = m_StCamera.FPGAVersion.ToString("X04")
			Case Fields.FirmVersion
				ctrl.Text = m_StCamera.FirmVersion.ToString("X04")
			Case Fields.SDKVersion
                ctrl.Text = m_StCamera.SDKVersion
            Case Fields.Temperature
                Dim visible As Boolean = m_StCamera.HasDeviceTemperatureMainBoard()
                ctrl.Visible = visible
                LabelTemperature.Visible = visible
                If visible Then
                    ctrl.Text = m_StCamera.DeviceTemperatureMainBoard.ToString()
                End If
            Case Fields.SwStatus0, Fields.SwStatus1, Fields.SwStatus2, Fields.SwStatus3
                Dim swNo As Byte = 0
                If Fields.SwStatus1.Equals(ctrl.Field) Then
                    swNo = 1
                ElseIf Fields.SwStatus2.Equals(ctrl.Field) Then
                    swNo = 2
                ElseIf Fields.SwStatus3.Equals(ctrl.Field) Then
                    swNo = 3
                End If
                If m_StCamera.SwStatus(swNo) = 1 Then
                    ctrl.Text = "ON"
                Else
                    ctrl.Text = "OFF"
                End If

			Case Fields.Exposure
				ctrl.Text = m_StCamera.ExposureTimeText
			Case Fields.Gain
				ctrl.Text = m_StCamera.GainText
			Case Fields.AEMinExposure	  'Dword
				ctrl.Text = m_StCamera.AEMinExposureTimeText
			Case Fields.AEMaxExposure	  'Dword
				ctrl.Text = m_StCamera.AEMaxExposureTimeText
			Case Fields.AGCMinGain	  'Word
				ctrl.Text = m_StCamera.AGCMinGainText
			Case Fields.AGCMaxGain	  'Word
				ctrl.Text = m_StCamera.AGCMaxGainText
			Case Fields.DigitalGain
                ctrl.Text = m_StCamera.DigitalGainText
			Case Fields.WBRGain
				ctrl.Text = String.Format("x {0:N2}", m_StCamera.WBRGain / 128.0)
			Case Fields.WBGRGain
				ctrl.Text = String.Format("x {0:N2}", m_StCamera.WBGrGain / 128.0)
			Case Fields.WBGBGain
				ctrl.Text = String.Format("x {0:N2}", m_StCamera.WBGbGain / 128.0)
			Case Fields.WBBGain
				ctrl.Text = String.Format("x {0:N2}", m_StCamera.WBBGain / 128.0)
			Case Fields.Hue
				ctrl.Text = String.Format("{0:N1}", m_StCamera.Hue / 10.0)
			Case Fields.Saturation
				ctrl.Text = String.Format("{0:N2}", m_StCamera.Saturation / 100.0)
			Case Fields.AutoTriggerTime
				ctrl.Text = m_StCamera.AutoTriggerDueTimeText
            Case Fields.TriggerDelay
                ctrl.Text = m_StCamera.TriggerDelayText()
			Case Fields.StrobeStartDelay
				ctrl.Text = m_StCamera.TriggerTimingText(StTrg.STCAM_TRIGGER_TIMING_STROBE_START_DELAY)
			Case Fields.StrobeEndDelay
				ctrl.Text = m_StCamera.TriggerTimingText(StTrg.STCAM_TRIGGER_TIMING_STROBE_END_DELAY)
			Case Fields.OutputPulseDelay
				ctrl.Text = m_StCamera.TriggerTimingText(StTrg.STCAM_TRIGGER_TIMING_OUTPUT_PULSE_DELAY)
			Case Fields.OutputPulseDuration
				ctrl.Text = m_StCamera.TriggerTimingText(StTrg.STCAM_TRIGGER_TIMING_OUTPUT_PULSE_DURATION)
			Case Fields.ReadOutDelay
                ctrl.Text = m_StCamera.TriggerTimingText(StTrg.STCAM_TRIGGER_TIMING_READOUT_DELAY)
            Case Fields.LineDebounceTime
                ctrl.Text = m_StCamera.TriggerTimingText(StTrg.STCAM_TRIGGER_TIMING_LINE_DEBOUNCE_TIME)
			Case Fields.VBlankForFPS	  'Dword
				ctrl.Text = m_StCamera.OutputFPS.ToString("N2") & "FPS"


		End Select
	End Sub
	Public Sub UpdateDisplayButton(ByVal ctrl As StButton)
		Dim enabled As Boolean = False
        Select Case (ctrl.Field)
            Case Fields.TriggerSoftware_FrameStart, Fields.TriggerSoftware_ExposureStart,Fields.TriggerSoftware_ExposureEnd,Fields.TriggerSoftware_SensorReadOutStart
                enabled = m_StCamera.IsEnableTriggerSoftware(UInteger.Parse(ctrl.Tag.ToString()))
            Case Fields.ResetFrameNo
                enabled = True
        End Select
		ctrl.Enabled = enabled
	End Sub
	Public Sub UpdateDisplayCheckBox(ByVal ctrl As StCheckBox)
		Dim enabled As Boolean = False
		Select Case (ctrl.Field)
			Case Fields.IsAutoTrigger
                If m_StCamera.IsAnyTriggerModeON() AndAlso m_StCamera.IsEnableTriggerSoftware(StTrg.STCAM_TRIGGER_SELECTOR_EXPOSURE_START) AndAlso (m_StCamera.ExposureMode = StTrg.STCAM_EXPOSURE_MODE_TRIGGER_CONTROLLED) Then
                    enabled = True
                    ctrl.Checked = m_StCamera.IsAutoTriggerMode
                End If
		End Select
		ctrl.Enabled = enabled

	End Sub
	Public Sub UpdateDisplayRange(ByVal ctrl As Control)
		Dim enabled As Boolean = True
		Dim objField As IField = TryCast(ctrl, IField)
		Dim objRange As IRange = TryCast(ctrl, IRange)
		Select Case (objField.Field)
			Case Fields.Exposure	'Dword
				enabled = Not m_StCamera.IsAEOn()
				objRange.SetRange(0, m_StCamera.MaxExposureClock, m_StCamera.ExposureClock)
            Case Fields.Gain    'Word
                enabled = m_StCamera.HasAnalogGainFucntion
                If enabled Then
                    enabled = (Not m_StCamera.IsAGCOn()) Or m_StCamera.IsDigitalGainCtrl
                    objRange.SetRange(0, m_StCamera.MaxGain, m_StCamera.Gain)
                End If
            Case Fields.DigitalGain 'Word
                enabled = m_StCamera.HasDigitalGainFunction
                If enabled Then
                    enabled = (Not m_StCamera.IsAGCOn()) Or (Not m_StCamera.IsDigitalGainCtrl)
                    objRange.SetRange(m_StCamera.DigitalGainOffValue, m_StCamera.MaxDigitalGain, m_StCamera.DigitalGain)
                End If
            Case Fields.ALCTarget   'Word
                enabled = m_StCamera.IsAEOn() Or m_StCamera.IsAGCOn()
                objRange.SetRange(0, 255, m_StCamera.ALCTargetLevel)
            Case Fields.AEMinExposure     'Dword
                enabled = m_StCamera.IsAEOn()
                objRange.SetRange(0, m_StCamera.MaxExposureClock, m_StCamera.AEMinExposureClock)
            Case Fields.AEMaxExposure     'Dword
                enabled = m_StCamera.IsAEOn()
                objRange.SetRange(0, m_StCamera.MaxExposureClock, m_StCamera.AEMaxExposureClock)
            Case Fields.AGCMinGain    'Word
                enabled = m_StCamera.IsAGCOn()
                objRange.SetRange(0, m_StCamera.MaxGain, m_StCamera.AGCMinGain)
            Case Fields.AGCMaxGain    'Word
                enabled = m_StCamera.IsAGCOn()
                objRange.SetRange(0, m_StCamera.MaxGain, m_StCamera.AGCMaxGain)
            Case Fields.SharpnessGain   'Word
                enabled = m_StCamera.SharpnessMode.Equals(StTrg.STCAM_SHARPNESS_ON)
                objRange.SetRange(0, 500, m_StCamera.SharpnessGain)
            Case Fields.SharpnessCoring 'Byte
                enabled = m_StCamera.SharpnessMode.Equals(StTrg.STCAM_SHARPNESS_ON)
                objRange.SetRange(0, 500, m_StCamera.SharpnessCoring)
            Case Fields.YGamma  'Word
                enabled = m_StCamera.GammaMode(StTrg.STCAM_GAMMA_TARGET_Y).Equals(StTrg.STCAM_GAMMA_ON)
                objRange.SetRange(1, 500, m_StCamera.GammaValue(StTrg.STCAM_GAMMA_TARGET_Y))
            Case Fields.CameraGamma     'Word
                enabled = m_StCamera.HasCameraGamma
                objRange.SetRange(0, 40, m_StCamera.CameraGamma)
            Case Fields.DigitalClamp    'Word
                enabled = m_StCamera.HasDigitalClamp
                objRange.SetRange(0, m_StCamera.MaxDigitalClamp, m_StCamera.DigitalClamp)
            Case Fields.AnalogBlackLevel    'Word
                enabled = m_StCamera.HasAnalogBlackLevel
                objRange.SetRange(0, m_StCamera.MaxAnalogBlackLevel, m_StCamera.AnalogBlackLevel)
            Case Fields.ShadingCorrectionTarget
                enabled = (m_StCamera.ShadingCorrectionMode = StTrg.STCAM_SHADING_CORRECTION_MODE_OFF)
                objRange.SetRange(0, 255, m_StCamera.ShadingCorrectionTarget)
            Case Fields.RGamma  'Word
                enabled = m_StCamera.GammaMode(StTrg.STCAM_GAMMA_TARGET_R).Equals(StTrg.STCAM_GAMMA_ON)
                objRange.SetRange(1, 500, m_StCamera.GammaValue(StTrg.STCAM_GAMMA_TARGET_R))
            Case Fields.GRGamma 'Word
                enabled = m_StCamera.GammaMode(StTrg.STCAM_GAMMA_TARGET_GR).Equals(StTrg.STCAM_GAMMA_ON)
                objRange.SetRange(1, 500, m_StCamera.GammaValue(StTrg.STCAM_GAMMA_TARGET_GR))
            Case Fields.GBGamma 'Word
                enabled = m_StCamera.GammaMode(StTrg.STCAM_GAMMA_TARGET_GB).Equals(StTrg.STCAM_GAMMA_ON)
                objRange.SetRange(1, 500, m_StCamera.GammaValue(StTrg.STCAM_GAMMA_TARGET_GB))
            Case Fields.BGamma  'Word
                enabled = m_StCamera.GammaMode(StTrg.STCAM_GAMMA_TARGET_B).Equals(StTrg.STCAM_GAMMA_ON)
                objRange.SetRange(1, 500, m_StCamera.GammaValue(StTrg.STCAM_GAMMA_TARGET_B))
            Case Fields.WBRGain 'Word
                enabled = m_StCamera.WhiteBalanceMode.Equals(StTrg.STCAM_WB_MANUAL)
                objRange.SetRange(0, 511, m_StCamera.WBRGain)
            Case Fields.WBGRGain    'Word
                enabled = Not m_StCamera.WhiteBalanceMode.Equals(StTrg.STCAM_WB_OFF)
                objRange.SetRange(0, 511, m_StCamera.WBGrGain)
            Case Fields.WBGBGain    'Word
                enabled = Not m_StCamera.WhiteBalanceMode.Equals(StTrg.STCAM_WB_OFF)
                objRange.SetRange(0, 511, m_StCamera.WBGbGain)
            Case Fields.WBBGain 'Word
                enabled = m_StCamera.WhiteBalanceMode.Equals(StTrg.STCAM_WB_MANUAL)
                objRange.SetRange(0, 511, m_StCamera.WBBGain)
            Case Fields.Hue 'Short
                enabled = m_StCamera.HueSaturationMode.Equals(StTrg.STCAM_HUE_SATURATION_ON)
                objRange.SetRange(-1800, 1800, m_StCamera.Hue)
            Case Fields.Saturation  'Word
                enabled = m_StCamera.HueSaturationMode.Equals(StTrg.STCAM_HUE_SATURATION_ON)
                objRange.SetRange(0, 200, m_StCamera.Saturation)
            Case Fields.HighChromaSuppressionStartLevel     'Word
                enabled = True
                objRange.SetRange(0, 255, m_StCamera.HighChromaSuppressionStartLevel)
            Case Fields.HighChromaSuppressionSuppressionLevel   'Word
                enabled = (m_StCamera.HighChromaSuppressionStartLevel < 255)
                objRange.SetRange(0, 255, m_StCamera.HighChromaSuppressionSuppressionLevel)
            Case Fields.LowChromaSuppressionStartLevel     'Word
                enabled = True
                objRange.SetRange(0, 255, m_StCamera.LowChromaSuppressionStartLevel)
            Case Fields.LowChromaSuppressionSuppressionLevel   'Word
                enabled = (0 < m_StCamera.LowChromaSuppressionStartLevel)
                objRange.SetRange(0, 255, m_StCamera.LowChromaSuppressionSuppressionLevel)
            Case Fields.AutoTriggerTime 'Integer
                enabled = m_StCamera.IsAutoTriggerMode AndAlso _
                m_StCamera.IsAnyTriggerModeON() AndAlso m_StCamera.IsEnableTriggerSoftware(StTrg.STCAM_TRIGGER_SELECTOR_EXPOSURE_START) AndAlso (m_StCamera.ExposureMode = StTrg.STCAM_EXPOSURE_MODE_TRIGGER_CONTROLLED)
                If enabled Then
                    objRange.SetRange(500, 600000, m_StCamera.AutoTriggerDueTime)
                End If
            Case Fields.TriggerDelay   'Dword
                Dim maxValue As UInt32 = 4094
                If m_StCamera.IsIOUnitUs() Then
                    maxValue = &H3FFFF
                End If
                objRange.SetRange(0, maxValue, m_StCamera.TriggerDelay)
            Case Fields.StrobeStartDelay    'Dword
                Dim maxValue As UInt32 = 4094
                If m_StCamera.IsIOUnitUs() Then
                    maxValue = &H3FFFF
                End If
                objRange.SetRange(0, maxValue, m_StCamera.TriggerTiming(StTrg.STCAM_TRIGGER_TIMING_STROBE_START_DELAY))
            Case Fields.StrobeEndDelay  'Dword
                Dim maxValue As UInt32 = 4094
                If m_StCamera.IsIOUnitUs() Then
                    maxValue = &H3FFFF
                End If
                objRange.SetRange(0, maxValue, m_StCamera.TriggerTiming(StTrg.STCAM_TRIGGER_TIMING_STROBE_END_DELAY))
            Case Fields.OutputPulseDelay    'Dword
                Dim maxValue As UInt32 = 4094
                If m_StCamera.IsIOUnitUs() Then
                    maxValue = &H3FFFF
                End If
                objRange.SetRange(0, maxValue, m_StCamera.TriggerTiming(StTrg.STCAM_TRIGGER_TIMING_OUTPUT_PULSE_DELAY))
            Case Fields.OutputPulseDuration 'Dword
                Dim maxValue As UInt32 = 4094
                If m_StCamera.IsIOUnitUs() Then
                    maxValue = &H3FFFF
                End If
                objRange.SetRange(0, maxValue, m_StCamera.TriggerTiming(StTrg.STCAM_TRIGGER_TIMING_OUTPUT_PULSE_DURATION))
            Case Fields.ReadOutDelay    'Dword
                objRange.SetRange(0, 65535, m_StCamera.TriggerTiming(StTrg.STCAM_TRIGGER_TIMING_READOUT_DELAY))
                enabled = m_StCamera.HasReadOut
            Case Fields.LineDebounceTime 'Dword
                Dim maxValue As UInt32 = 10000
                objRange.SetRange(0, maxValue, m_StCamera.TriggerTiming(StTrg.STCAM_TRIGGER_TIMING_LINE_DEBOUNCE_TIME))
                enabled = m_StCamera.HasLineDebounceTime
            Case Fields.ImageOffsetX      'Dword
                objRange.SetRange(0, m_StCamera.MaximumImageWidth - 4, m_StCamera.ImageOffsetX)
                enabled = m_StCamera.EnableImageOffsetX
            Case Fields.ImageOffsetY      'Dword
                objRange.SetRange(0, m_StCamera.MaximumImageHeight - 4, m_StCamera.ImageOffsetY)
                enabled = m_StCamera.EnableImageOffsetY
            Case Fields.ImageWidth    'Dword
                objRange.SetRange(0, m_StCamera.MaximumImageWidth, m_StCamera.ImageWidth)
                enabled = m_StCamera.EnableImageWidth
            Case Fields.ImageHeight   'Dword
                objRange.SetRange(0, m_StCamera.MaximumImageHeight, m_StCamera.ImageHeight)
                enabled = m_StCamera.EnableImageHeight
            Case Fields.VBlankForFPS      'Dword
                objRange.SetRange(0, m_StCamera.MaxVBlankForFPS, m_StCamera.VBlankForFPS)
                enabled = m_StCamera.HasVBlankForFPS

            Case Fields.HDR_CMOSIS4M_Knee1  'Byte
                objRange.SetRange(0, 255, m_StCamera.HDR_CMOSIS4M_Knee1)
                enabled = ((0 < m_StCamera.HDR_CMOSIS4M_Mode) And (1 < m_StCamera.HDR_CMOSIS4M_SlopeNum))
            Case Fields.HDR_CMOSIS4M_Vlow2  'Byte
                objRange.SetRange(0, 63, m_StCamera.HDR_CMOSIS4M_Vlow2)
                enabled = ((0 < m_StCamera.HDR_CMOSIS4M_Mode) And (1 < m_StCamera.HDR_CMOSIS4M_SlopeNum))
            Case Fields.HDR_CMOSIS4M_Knee2  'Byte
                objRange.SetRange(0, 255, m_StCamera.HDR_CMOSIS4M_Knee2)
                enabled = ((0 < m_StCamera.HDR_CMOSIS4M_Mode) And (2 < m_StCamera.HDR_CMOSIS4M_SlopeNum))
            Case Fields.HDR_CMOSIS4M_Vlow3  'Byte
                objRange.SetRange(0, 63, m_StCamera.HDR_CMOSIS4M_Vlow3)
                enabled = ((0 < m_StCamera.HDR_CMOSIS4M_Mode) And (2 < m_StCamera.HDR_CMOSIS4M_SlopeNum))
        End Select
		ctrl.Enabled = enabled
	End Sub

	Private Sub tabCtrl_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tabCtrl.SelectedIndexChanged

		UpdateDisplay(tabCtrl.SelectedTab.Controls)
	End Sub
	Private Sub FormSetting_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
		SetChangeEvent(Me.Controls)
		If Not m_StCamera.HasTriggerFunction() Then
			If tabCtrl.TabPages.Contains(TabPageTriggerMode) Then
				tabCtrl.TabPages.Remove(TabPageTriggerMode)
			End If
			If tabCtrl.TabPages.Contains(TabPageTriggerTiming) Then
				tabCtrl.TabPages.Remove(TabPageTriggerTiming)
			End If
			If tabCtrl.TabPages.Contains(TabPageIO) Then
				tabCtrl.TabPages.Remove(TabPageIO)
			End If
		End If

        If m_StCamera.HDRType <> StTrg.STCAM_HDR_TYPE_CMOSIS_4M Then
            If tabCtrl.TabPages.Contains(TabPageHDR_CMOSIS4M) Then
                tabCtrl.TabPages.Remove(TabPageHDR_CMOSIS4M)
            End If
        End If

        If StTrg.STCAM_COLOR_ARRAY_MONO.Equals(m_StCamera.ColorArray) Then
            If tabCtrl.TabPages.Contains(TabPageWB) Then
                tabCtrl.TabPages.Remove(TabPageWB)
            End If
            If tabCtrl.TabPages.Contains(TabPageColorGamma) Then
                tabCtrl.TabPages.Remove(TabPageColorGamma)
            End If
        End If

        If Not m_StCamera.HasStoreCameraSetting() Then
            If tabCtrl.TabPages.Contains(TabPageEEPROM) Then
                tabCtrl.TabPages.Remove(TabPageEEPROM)
            End If
        End If
        UpdateDisplay(tabCtrl.SelectedTab.Controls)
	End Sub

	Public Sub OnChanged(ByVal sender As Object, ByVal e As EventArgs)
		Dim field As IField = TryCast(sender, IField)
		If Not IsNothing(field) Then
			Do
				Dim objValue As IValue = TryCast(sender, IValue)
				If Not IsNothing(objValue) Then
					OnChanged(field.Field, objValue)
					Exit Do
				End If


				Dim ovjRange As IRange = TryCast(sender, IRange)
				If Not IsNothing(ovjRange) Then
					OnChanged(field.Field, ovjRange)
					Exit Do
				End If

				Dim objCheck As CheckBox = TryCast(sender, CheckBox)
				If Not IsNothing(objCheck) Then
					OnChanged(field.Field, objCheck)
					Exit Do
				End If

				Dim objButton As Button = TryCast(sender, Button)
				If Not IsNothing(objButton) Then
					OnChanged(field.Field, objButton)
					Exit Do
				End If


				Exit Do
			Loop While (False)
			UpdateDisplay(tabCtrl.SelectedTab.Controls)
		End If
	End Sub
	Protected Sub OnChanged(ByVal field As Fields, ByVal objValue As IValue)
		Select Case (field)
			'selection
			Case Fields.ALCMode	'Byte
                m_StCamera.ALCMode = objValue.GetValue(Of Byte)()
            Case Fields.AdjustmentDigitalGain
                m_StCamera.EnableAdjustmentDigitalGain = objValue.GetValue(Of Boolean)()
            Case (Fields.WBMode) 'Byte
                m_StCamera.WhiteBalanceMode = objValue.GetValue(Of Byte)()
			Case (Fields.HueSaturationMode)	 'Byte
                m_StCamera.HueSaturationMode = objValue.GetValue(Of Byte)()
            Case (Fields.ExposureMode)   'Dword
                m_StCamera.ExposureMode = objValue.GetValue(Of UInteger)()
            Case (Fields.TriggerSelector)
                m_StCamera.TriggerSelector = objValue.GetValue(Of UInteger)()
            Case (Fields.TriggerMode)    'Dword
                m_StCamera.TriggerMode = objValue.GetValue(Of UInteger)()
            Case (Fields.TriggerSource)  'Dword
                m_StCamera.TriggerSource = objValue.GetValue(Of UInteger)()
            Case (Fields.TriggerOverlap)
                m_StCamera.TriggerOverlap = objValue.GetValue(Of UInteger)()
            Case (Fields.ExposureWaitHD) 'Dword
                m_StCamera.ExposureWaitHD = objValue.GetValue(Of UInteger)()
			Case (Fields.ExposureWaitReadOut)	 'Dword
				m_StCamera.ExposureWaitReadOut = objValue.GetValue(Of UInteger)()
			Case (Fields.ExposureEnd)	 'Dword
				m_StCamera.ExposureEnd = objValue.GetValue(Of UInteger)()
			Case (Fields.CameraMemory)	 'Dword
				m_StCamera.CameraMemory = objValue.GetValue(Of UInteger)()
            Case (Fields.SensorShutterMode)
                m_StCamera.SensorShutterMode = objValue.GetValue(Of UInteger)()
			Case (Fields.NoiseReduction) 'Dword
				m_StCamera.NoiseReductionMode = objValue.GetValue(Of UInteger)()
			Case (Fields.ScanMode)	 'Word
				m_StCamera.ScanMode = objValue.GetValue(Of UShort)()
			Case (Fields.ClockMode)	 'Dword
				m_StCamera.ClockMode = objValue.GetValue(Of UInteger)()
			Case (Fields.SharpnessMode)	 'Byte
                m_StCamera.SharpnessMode = objValue.GetValue(Of Byte)()
            Case (Fields.ShadingCorrectionMode)
                m_StCamera.ShadingCorrectionMode = objValue.GetValue(Of System.UInt32)()
            Case (Fields.YGammaMode) 'Byte
                m_StCamera.GammaMode(StTrg.STCAM_GAMMA_TARGET_Y) = objValue.GetValue(Of Byte)()
			Case (Fields.RGammaMode) 'Byte
				m_StCamera.GammaMode(StTrg.STCAM_GAMMA_TARGET_R) = objValue.GetValue(Of Byte)()
			Case (Fields.GRGammaMode)	 'Byte
				m_StCamera.GammaMode(StTrg.STCAM_GAMMA_TARGET_GR) = objValue.GetValue(Of Byte)()
			Case (Fields.GBGammaMode)	 'Byte
				m_StCamera.GammaMode(StTrg.STCAM_GAMMA_TARGET_GB) = objValue.GetValue(Of Byte)()
			Case (Fields.BGammaMode) 'Byte
				m_StCamera.GammaMode(StTrg.STCAM_GAMMA_TARGET_B) = objValue.GetValue(Of Byte)()
			Case (Fields.ColorInterpolation) 'Byte
				m_StCamera.ColorInterpolationMode = objValue.GetValue(Of Byte)()
			Case (Fields.Mirror) 'Byte
				m_StCamera.MirrorMode = objValue.GetValue(Of Byte)()
			Case (Fields.Rotation)	 'Byte
				m_StCamera.RotationMode = objValue.GetValue(Of Byte)()
			Case (Fields.IOInOut0)	 'Dword
				m_StCamera.IOPinInOut(0) = objValue.GetValue(Of UInteger)()
			Case (Fields.IOInOut1)	 'Dword
				m_StCamera.IOPinInOut(1) = objValue.GetValue(Of UInteger)()
			Case (Fields.IOInOut2)	 'Dword
				m_StCamera.IOPinInOut(2) = objValue.GetValue(Of UInteger)()
			Case (Fields.IOInOut3)	 'Dword
				m_StCamera.IOPinInOut(3) = objValue.GetValue(Of UInteger)()
			Case (Fields.IOMode0)	 'Dword
				m_StCamera.IOPinMode(0) = objValue.GetValue(Of UInteger)()
			Case (Fields.IOMode1)	 'Dword
				m_StCamera.IOPinMode(1) = objValue.GetValue(Of UInteger)()
			Case (Fields.IOMode2)	 'Dword
				m_StCamera.IOPinMode(2) = objValue.GetValue(Of UInteger)()
			Case (Fields.IOMode3)	 'Dword
				m_StCamera.IOPinMode(3) = objValue.GetValue(Of UInteger)()
			Case (Fields.IOPolarity0)	 'Dword
				m_StCamera.IOPinPolarity(0) = objValue.GetValue(Of UInteger)()
			Case (Fields.IOPolarity1)	 'Dword
				m_StCamera.IOPinPolarity(1) = objValue.GetValue(Of UInteger)()
			Case (Fields.IOPolarity2)	 'Dword
				m_StCamera.IOPinPolarity(2) = objValue.GetValue(Of UInteger)()
			Case (Fields.IOPolarity3)	 'Dword
				m_StCamera.IOPinPolarity(3) = objValue.GetValue(Of UInteger)()
			Case (Fields.IOStatus0)	 'Dword
				m_StCamera.IOPinStatus(0) = objValue.GetValue(Of UInteger)()
			Case (Fields.IOStatus1)	 'Dword
				m_StCamera.IOPinStatus(1) = objValue.GetValue(Of UInteger)()
			Case (Fields.IOStatus2)	 'Dword
				m_StCamera.IOPinStatus(2) = objValue.GetValue(Of UInteger)()
			Case (Fields.IOStatus3)	 'Dword
                m_StCamera.IOPinStatus(3) = objValue.GetValue(Of UInteger)()
            Case (Fields.ResetSwitch)
                m_StCamera.ResetSwitchEnabled = objValue.GetValue(Of Boolean)()
            Case (Fields.LEDGreen)   'Dword
                m_StCamera.LEDGreen = objValue.GetValue(Of UInteger)()
			Case (Fields.LEDRed) 'Dword
				m_StCamera.LEDRed = objValue.GetValue(Of UInteger)()
			Case (Fields.TransferBitsPerPixel)	 'Dword
                m_StCamera.TransferBitsPerPixel = objValue.GetValue(Of UInteger)()
            Case (Fields.PriorityMode)   'Dword
                m_StCamera.PriorityMode = objValue.GetValue(Of UInteger)()
            Case (Fields.DisplayPixelFormat)  'Dword
                m_StCamera.StPixelFormat = objValue.GetValue(Of UInteger)()
            Case Fields.HBinningSkipping      'Word
                m_StCamera.HBinningSkipping = objValue.GetValue(Of UShort)()
			Case Fields.VBinningSkipping	  'Word
				m_StCamera.VBinningSkipping = objValue.GetValue(Of UShort)()
			Case Fields.HBinningSumMode	'Word
				Dim wTmp As UInt16 = CUShort(m_StCamera.BinningSumMode And &HFF00)
				wTmp = wTmp Or objValue.GetValue(Of UShort)()
				m_StCamera.BinningSumMode = wTmp
			Case Fields.VBinningSumMode	'Word
				Dim wTmp As UInt16 = CUShort(m_StCamera.BinningSumMode And &HFF)
				wTmp = wTmp Or objValue.GetValue(Of UShort)()
				m_StCamera.BinningSumMode = wTmp
            Case Fields.CurrentRegion
                m_StCamera.CurrentRegion = objValue.GetValue(Of Integer)()
            Case Fields.RegionMode
                m_StCamera.RegionMode = objValue.GetValue(Of Boolean)()
            Case Fields.HDR_CMOSIS4M_Mode
                m_StCamera.HDR_CMOSIS4M_Mode = objValue.GetValue(Of Byte)()
            Case Fields.HDR_CMOSIS4M_SlopeNum
                m_StCamera.HDR_CMOSIS4M_SlopeNum = objValue.GetValue(Of Byte)()
        End Select
	End Sub
	Protected Sub OnChanged(ByVal field As Fields, ByVal objRange As IRange)
		Select Case (field)
			'numeric
			Case (Fields.Exposure)	 'Dword
				m_StCamera.ExposureClock = CUInt(objRange.GetValue())
			Case (Fields.Gain)	 'Word
				m_StCamera.Gain = CUShort(objRange.GetValue())
			Case (Fields.DigitalGain)	 'Word
				m_StCamera.DigitalGain = CUShort(objRange.GetValue())
			Case Fields.ALCTarget	'Word
				m_StCamera.ALCTargetLevel = CUShort(objRange.GetValue())
			Case Fields.AEMinExposure	  'Dword
				m_StCamera.AEMinExposureClock = CUInt(objRange.GetValue())
			Case Fields.AEMaxExposure	  'Dword
				m_StCamera.AEMaxExposureClock = CUInt(objRange.GetValue())
			Case Fields.AGCMinGain	  'Word
				m_StCamera.AGCMinGain = CUShort(objRange.GetValue())
			Case Fields.AGCMaxGain	  'Word
				m_StCamera.AGCMaxGain = CUShort(objRange.GetValue())
			Case (Fields.SharpnessGain)	 'Word
				m_StCamera.SharpnessGain = CUShort(objRange.GetValue())
			Case (Fields.SharpnessCoring)	 'Byte
				m_StCamera.SharpnessCoring = CByte(objRange.GetValue())
			Case (Fields.YGamma) 'Word
				m_StCamera.GammaValue(StTrg.STCAM_GAMMA_TARGET_Y) = CUShort(objRange.GetValue())
			Case (Fields.CameraGamma) 'Word
				m_StCamera.CameraGamma = CUShort(objRange.GetValue())
			Case Fields.DigitalClamp	'Word
                m_StCamera.DigitalClamp = CUShort(objRange.GetValue())
            Case Fields.AnalogBlackLevel    'Word
                m_StCamera.AnalogBlackLevel = CUShort(objRange.GetValue())
            Case Fields.ShadingCorrectionTarget
                m_StCamera.ShadingCorrectionTarget = CUShort(objRange.GetValue())
            Case (Fields.RGamma) 'Word
                m_StCamera.GammaValue(StTrg.STCAM_GAMMA_TARGET_R) = CUShort(objRange.GetValue())
			Case (Fields.GRGamma)	 'Word
				m_StCamera.GammaValue(StTrg.STCAM_GAMMA_TARGET_GR) = CUShort(objRange.GetValue())
			Case (Fields.GBGamma)	 'Word
				m_StCamera.GammaValue(StTrg.STCAM_GAMMA_TARGET_GB) = CUShort(objRange.GetValue())
			Case (Fields.BGamma)	 'Word
				m_StCamera.GammaValue(StTrg.STCAM_GAMMA_TARGET_B) = CUShort(objRange.GetValue())
			Case (Fields.WBRGain)	 'Word
				m_StCamera.WBRGain = CUShort(objRange.GetValue())
			Case (Fields.WBGRGain)	 'Word
				m_StCamera.WBGrGain = CUShort(objRange.GetValue())
			Case (Fields.WBGBGain)	 'Word
				m_StCamera.WBGbGain = CUShort(objRange.GetValue())
			Case (Fields.WBBGain)	 'Word
				m_StCamera.WBBGain = CUShort(objRange.GetValue())
			Case (Fields.Hue)	 'Short
				m_StCamera.Hue = CShort(objRange.GetValue())
			Case (Fields.Saturation) 'Word
                m_StCamera.Saturation = CUShort(objRange.GetValue())
            Case (Fields.HighChromaSuppressionStartLevel)     'Word
                m_StCamera.HighChromaSuppressionStartLevel = CUShort(objRange.GetValue())
            Case (Fields.HighChromaSuppressionSuppressionLevel)   'Word
                m_StCamera.HighChromaSuppressionSuppressionLevel = CUShort(objRange.GetValue())
            Case (Fields.LowChromaSuppressionStartLevel)     'Word
                m_StCamera.LowChromaSuppressionStartLevel = CUShort(objRange.GetValue())
            Case (Fields.LowChromaSuppressionSuppressionLevel)   'Word
                m_StCamera.LowChromaSuppressionSuppressionLevel = CUShort(objRange.GetValue())
			Case (Fields.AutoTriggerTime)	 'Integer
				m_StCamera.AutoTriggerDueTime = CInt(objRange.GetValue())
            Case (Fields.TriggerDelay)   'Dword
                m_StCamera.TriggerDelay = CUInt(objRange.GetValue())
			Case (Fields.StrobeStartDelay)	 'Dword
				m_StCamera.TriggerTiming(StTrg.STCAM_TRIGGER_TIMING_STROBE_START_DELAY) = CUInt(objRange.GetValue())
			Case (Fields.StrobeEndDelay) 'Dword
				m_StCamera.TriggerTiming(StTrg.STCAM_TRIGGER_TIMING_STROBE_END_DELAY) = CUInt(objRange.GetValue())
			Case (Fields.OutputPulseDelay)	 'Dword
				m_StCamera.TriggerTiming(StTrg.STCAM_TRIGGER_TIMING_OUTPUT_PULSE_DELAY) = CUInt(objRange.GetValue())
			Case (Fields.OutputPulseDuration)	 'Dword
				m_StCamera.TriggerTiming(StTrg.STCAM_TRIGGER_TIMING_OUTPUT_PULSE_DURATION) = CUInt(objRange.GetValue())
			Case (Fields.ReadOutDelay)	 'Dword
                m_StCamera.TriggerTiming(StTrg.STCAM_TRIGGER_TIMING_READOUT_DELAY) = CUInt(objRange.GetValue())
            Case (Fields.LineDebounceTime)   'Dword
                m_StCamera.TriggerTiming(StTrg.STCAM_TRIGGER_TIMING_LINE_DEBOUNCE_TIME) = CUInt(objRange.GetValue())
			Case Fields.ImageOffsetX	  'Dword
				m_StCamera.ImageOffsetX = CUInt(objRange.GetValue())
			Case Fields.ImageOffsetY	  'Dword
				m_StCamera.ImageOffsetY = CUInt(objRange.GetValue())
			Case Fields.ImageWidth	  'Dword
				m_StCamera.ImageWidth = CUInt(objRange.GetValue())
			Case Fields.ImageHeight	  'Dword
				m_StCamera.ImageHeight = CUInt(objRange.GetValue())
			Case Fields.VBlankForFPS	  'Dword
                m_StCamera.VBlankForFPS = CUInt(objRange.GetValue())
            Case Fields.HDR_CMOSIS4M_Knee1  'Byte
                m_StCamera.HDR_CMOSIS4M_Knee1 = CByte(objRange.GetValue())
            Case Fields.HDR_CMOSIS4M_Vlow2  'Byte
                m_StCamera.HDR_CMOSIS4M_Vlow2 = CByte(objRange.GetValue())
            Case Fields.HDR_CMOSIS4M_Knee2  'Byte
                m_StCamera.HDR_CMOSIS4M_Knee2 = CByte(objRange.GetValue())
            Case Fields.HDR_CMOSIS4M_Vlow3  'Byte
                m_StCamera.HDR_CMOSIS4M_Vlow3 = CByte(objRange.GetValue())
        End Select

	End Sub
	Protected Sub OnChanged(ByVal field As Fields, ByVal objCheck As CheckBox)
		Select Case (field)
			'check
			Case (Fields.IsAutoTrigger)
				m_StCamera.IsAutoTriggerMode = objCheck.Checked
		End Select

	End Sub
	Protected Sub OnChanged(ByVal field As Fields, ByVal objButton As Button)
		Select Case (field)
            'button
            Case Fields.TriggerSoftware_FrameStart, Fields.TriggerSoftware_ExposureStart, Fields.TriggerSoftware_ExposureEnd, Fields.TriggerSoftware_SensorReadOutStart
                m_StCamera.TriggerSoftware(UInteger.Parse(objButton.Tag.ToString()))
			Case (Fields.ResetFrameNo)
				m_StCamera.ResetCounter()
		End Select

	End Sub

	Private Sub ButtonSave_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonSave.Click
		Using dlg As SaveFileDialog = New SaveFileDialog()
			dlg.Filter = "CFG File(*.cfg)|*.cfg|All Files(*.*)|*.*"
			dlg.DefaultExt = "cfg"
			dlg.FileName = m_StCamera.CameraUserName
			If (DialogResult.OK = dlg.ShowDialog()) Then
				m_StCamera.WriteSettingFile(dlg.FileName)
			End If
		End Using
	End Sub

	Private Sub ButtonLoad_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonLoad.Click
		Using dlg As OpenFileDialog = New OpenFileDialog()
			dlg.DefaultExt = "cfg"
			dlg.FileName = m_StCamera.CameraUserName
			If (DialogResult.OK = dlg.ShowDialog()) Then
				m_StCamera.ReadSettingFile(dlg.FileName)
				UpdateDisplay(tabCtrl.SelectedTab.Controls)
			End If
		End Using
	End Sub

	Private Sub ButtonRefresh_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonRefresh.Click
		UpdateDisplay(tabCtrl.SelectedTab.Controls)
	End Sub

	Private Sub ButtonOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
		Close()
	End Sub


	Private Sub ButtonCameraSetting_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonReadCameraSetting.Click, ButtonWriteCameraSetting.Click, ButtonWriteCameraSettingDPP.Click, ButtonReadCameraSettingDPP.Click, ButtonInitCameraSetting.Click
		Dim btn As Button = TryCast(sender, Button)
		Dim wMode As UShort = Convert.ToUInt16(btn.Tag.ToString(), 16)
		m_StCamera.CameraSetting(wMode)
		UpdateDisplay(tabCtrl.SelectedTab.Controls)
	End Sub


End Class